/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.model.commands.AddListMemberCommand;
import com.archimatetool.model.IDiagramModelImageProvider;
import com.archimatetool.model.IProfile;
import com.archimatetool.modelimporter.AbstractImporter;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusMessage;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

class ProfileImporter
extends AbstractImporter {
    ProfileImporter(ModelImporter importer) {
        super(importer);
    }

    IProfile importProfile(IProfile importedProfile) throws ImportException, IOException {
        IProfile targetProfile = this.findObjectInTargetModel(importedProfile);
        if (targetProfile == null) {
            this.addNewProfile(importedProfile);
        } else if (this.shouldUpdate()) {
            this.updateProfile(importedProfile, targetProfile);
        } else {
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ProfileImporter_0, importedProfile);
        }
        return targetProfile;
    }

    private void addNewProfile(IProfile importedProfile) throws IOException {
        IProfile newProfile = this.cloneObject(importedProfile);
        this.addCommand((Command)new AddListMemberCommand((List)this.getTargetModel().getProfiles(), (Object)newProfile));
        this.importImageBytes((IDiagramModelImageProvider)importedProfile, (IDiagramModelImageProvider)newProfile);
        this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ProfileImporter_1, newProfile);
    }

    private void updateProfile(IProfile importedProfile, IProfile targetProfile) throws IOException {
        this.updateObject((EObject)importedProfile, (EObject)targetProfile);
        this.importImageBytes((IDiagramModelImageProvider)importedProfile, (IDiagramModelImageProvider)targetProfile);
        this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ProfileImporter_2, importedProfile);
    }
}

