/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.StatusMessage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StatusDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.ImportModel";
    private static final int COPY_TO_CLIPBOARD_BUTTON = 1025;
    private StyledText textControl;
    private List<StatusMessage> messages;
    private Button btnInfo;
    private Button btnWarning;

    public StatusDialog(Shell parentShell, List<StatusMessage> messages) {
        super(parentShell, "ImporterStatusDialog");
        this.messages = messages;
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.StatusDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.StatusDialog_1);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        this.textControl = new StyledText(composite, 778);
        this.textControl.setLayoutData((Object)new GridData(1808));
        this.textControl.setBackground(parent.getDisplay().getSystemColor(25));
        this.textControl.setFont(JFaceResources.getTextFont());
        this.btnInfo = this.createCheckbox(composite, Messages.StatusDialog_3, StatusMessage.StatusMessageLevel.INFO);
        this.btnWarning = this.createCheckbox(composite, Messages.StatusDialog_4, StatusMessage.StatusMessageLevel.WARNING);
        this.showMessages();
        return composite;
    }

    private Button createCheckbox(Composite parent, String text, final StatusMessage.StatusMessageLevel level) {
        Button btn = new Button(parent, 32);
        btn.setText(text);
        btn.setSelection(this.hasMessageType(level));
        btn.setEnabled(btn.getSelection());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StatusDialog.this.hasMessageType(level)) {
                    StatusDialog.this.showMessages();
                }
            }
        });
        return btn;
    }

    private boolean hasMessageType(StatusMessage.StatusMessageLevel level) {
        return this.messages.stream().anyMatch(msg -> msg.getLevel() == level);
    }

    private void showMessages() {
        if (this.messages.isEmpty()) {
            this.textControl.setText(Messages.StatusDialog_2 + "\n");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean showInfo = this.btnInfo.getSelection();
        boolean showWarn = this.btnWarning.getSelection();
        ArrayList ranges = new ArrayList();
        this.messages.stream().filter(msg -> showInfo && msg.getLevel() == StatusMessage.StatusMessageLevel.INFO || showWarn && msg.getLevel() == StatusMessage.StatusMessageLevel.WARNING).forEach(msg -> {
            ranges.add(this.createStyleRange((StatusMessage)msg, sb.length()));
            sb.append(String.valueOf(msg) + "\n");
        });
        this.textControl.setText(sb.toString());
        this.textControl.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
    }

    private StyleRange createStyleRange(StatusMessage msg, int start) {
        StyleRange sr = new StyleRange();
        sr.foreground = msg.getLevel().getColor();
        sr.start = start;
        sr.length = msg.getLevel().getText().length();
        return sr;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.copyToClipboard();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{this.textControl.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.StatusDialog_5, false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Point getDefaultDialogSize() {
        return new Point(800, 640);
    }
}

