/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.modelimporter.Messages;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;

public class StatusMessage {
    private StatusMessageLevel level;
    private String message;
    private Object[] objs;

    StatusMessage(StatusMessageLevel level, String message, Object ... objs) {
        this.level = level;
        this.message = message;
        this.objs = objs;
    }

    public StatusMessageLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        Object[] objsList = Stream.of(this.objs).map(obj -> ArchiLabelProvider.INSTANCE.getLabel(obj)).toArray();
        return this.getLevel().getText() + " " + NLS.bind((String)this.message, (Object[])objsList);
    }

    public String toString() {
        return this.getMessage();
    }

    static enum StatusMessageLevel {
        INFO(Messages.StatusMessage_0, new Color(0, 0, 255)),
        WARNING(Messages.StatusMessage_1, new Color(255, 0, 0));

        private String text;
        private Color color;

        private StatusMessageLevel(String text, Color color) {
            this.text = text;
            this.color = color;
        }

        Color getColor() {
            return this.color;
        }

        String getText() {
            return this.text;
        }
    }
}

