/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.Logger;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelImageProvider;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.modelimporter.AbstractImporter;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

class ViewImporter
extends AbstractImporter {
    private IDiagramModel importedView;
    private IDiagramModel targetView;

    ViewImporter(ModelImporter importer) {
        super(importer);
    }

    IDiagramModel importView(IDiagramModel importedView) throws ImportException, IOException {
        this.importedView = importedView;
        this.targetView = this.findObjectInTargetModel(importedView);
        if (this.targetView == null) {
            this.targetView = this.cloneObject(importedView);
            this.createChildren();
            this.addToParentFolder((IArchimateModelObject)importedView, (IArchimateModelObject)this.targetView);
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ViewImporter_0, this.targetView);
        } else if (this.shouldUpdate()) {
            this.updateObject((EObject)importedView, (EObject)this.targetView);
            this.createChildren();
            this.addToParentFolder((IArchimateModelObject)importedView, (IArchimateModelObject)this.targetView);
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ViewImporter_1, this.targetView);
        } else {
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ViewImporter_3, this.targetView);
        }
        return this.targetView;
    }

    private void createChildren() throws ImportException, IOException {
        List<IDiagramModelObject> newChildren = this.createChildObjects((List<IDiagramModelObject>)this.importedView.getChildren(), new ArrayList<IDiagramModelObject>());
        this.addCommand(new SetViewChildrenCommand(this.targetView, newChildren));
        this.createConnections();
    }

    private List<IDiagramModelObject> createChildObjects(List<IDiagramModelObject> importedChildren, List<IDiagramModelObject> targetChildren) throws ImportException, IOException {
        for (IDiagramModelObject importedObject : importedChildren) {
            IDiagramModelObject targetObject = this.cloneObject(importedObject);
            targetChildren.add(targetObject);
            if (targetObject instanceof IDiagramModelArchimateObject) {
                this.setArchimateConcept((IDiagramModelArchimateComponent)((IDiagramModelArchimateObject)importedObject), (IDiagramModelArchimateComponent)((IDiagramModelArchimateObject)targetObject));
            }
            if (importedObject instanceof IDiagramModelImageProvider) {
                this.importImageBytes((IDiagramModelImageProvider)importedObject, (IDiagramModelImageProvider)targetObject);
            }
            if (!(importedObject instanceof IDiagramModelContainer)) continue;
            this.createChildObjects((List<IDiagramModelObject>)((IDiagramModelContainer)importedObject).getChildren(), (List<IDiagramModelObject>)((IDiagramModelContainer)targetObject).getChildren());
        }
        return targetChildren;
    }

    private void createConnections() throws ImportException {
        Hashtable<IDiagramModelConnection, IDiagramModelConnection> connections = new Hashtable<IDiagramModelConnection, IDiagramModelConnection>();
        TreeIterator iter = this.importedView.eAllContents();
        while (iter.hasNext()) {
            EObject importedObject = (EObject)iter.next();
            if (!(importedObject instanceof IDiagramModelConnection)) continue;
            connections.put((IDiagramModelConnection)importedObject, this.cloneObject((IDiagramModelConnection)importedObject));
        }
        for (Map.Entry entry : connections.entrySet()) {
            IDiagramModelConnection importedConnection = (IDiagramModelConnection)entry.getKey();
            IDiagramModelConnection targetConnection = (IDiagramModelConnection)entry.getValue();
            IConnectable targetSource = this.findObjectInTargetModel(importedConnection.getSource());
            if (targetSource == null) {
                throw new ImportException("Could not find source component: " + importedConnection.getSource().getId());
            }
            IConnectable targetTarget = this.findObjectInTargetModel(importedConnection.getTarget());
            if (targetTarget == null) {
                throw new ImportException("Could not find target component: " + importedConnection.getTarget().getId());
            }
            if (targetConnection instanceof IDiagramModelArchimateConnection) {
                this.setArchimateConcept((IDiagramModelArchimateComponent)((IDiagramModelArchimateConnection)importedConnection), (IDiagramModelArchimateComponent)((IDiagramModelArchimateConnection)targetConnection));
                this.addCommand(new ArchimateConnectionCommand((IDiagramModelArchimateConnection)targetConnection, targetSource, targetTarget));
                continue;
            }
            targetConnection.connect(targetSource, targetTarget);
        }
    }

    private void setArchimateConcept(IDiagramModelArchimateComponent importedComponent, IDiagramModelArchimateComponent targetComponent) throws ImportException {
        IArchimateConcept targetConcept = this.findObjectInTargetModel(importedComponent.getArchimateConcept());
        if (targetConcept == null) {
            throw new ImportException("Could not find concept in target: " + importedComponent.getId());
        }
        targetComponent.setArchimateConcept(targetConcept);
    }

    private class ArchimateConnectionCommand
    extends Command {
        private IDiagramModelArchimateConnection connection;
        private IConnectable connectionSource;
        private IConnectable connectionTarget;
        private IArchimateRelationship relationship;
        private IArchimateConcept oldSource;
        private IArchimateConcept oldTarget;
        private IArchimateConcept newSource;
        private IArchimateConcept newTarget;

        private ArchimateConnectionCommand(IDiagramModelArchimateConnection connection, IConnectable connectionSource, IConnectable connectionTarget) {
            this.connection = connection;
            this.connectionSource = connectionSource;
            this.connectionTarget = connectionTarget;
            this.relationship = connection.getArchimateRelationship();
        }

        public void execute() {
            this.oldSource = this.relationship.getSource();
            this.oldTarget = this.relationship.getTarget();
            this.connection.connect(this.connectionSource, this.connectionTarget);
            this.newSource = this.relationship.getSource();
            this.newTarget = this.relationship.getTarget();
            if (this.oldSource != this.newSource || this.oldTarget != this.newTarget) {
                ViewImporter.this.logMessage(StatusMessage.StatusMessageLevel.WARNING, Messages.ViewImporter_2, this.relationship, this.newSource, this.newTarget);
            }
        }

        public void undo() {
            if (this.oldSource != this.newSource) {
                this.relationship.setSource(this.oldSource);
            }
            if (this.oldTarget != this.newTarget) {
                this.relationship.setTarget(this.oldTarget);
            }
        }

        public void redo() {
            if (this.oldSource != this.newSource) {
                this.relationship.setSource(this.newSource);
            }
            if (this.oldTarget != this.newTarget) {
                this.relationship.setTarget(this.newTarget);
            }
        }

        public void dispose() {
            this.connection = null;
            this.connectionSource = null;
            this.connectionTarget = null;
            this.relationship = null;
            this.oldSource = null;
            this.oldTarget = null;
            this.newSource = null;
            this.newTarget = null;
        }
    }

    private class SetViewChildrenCommand
    extends Command {
        private IDiagramModel view;
        private List<IDiagramModelObject> oldChildren;
        private List<IDiagramModelObject> newChildren;

        private SetViewChildrenCommand(IDiagramModel view, List<IDiagramModelObject> newChildren) {
            this.view = view;
            this.newChildren = newChildren;
            this.oldChildren = new ArrayList<IDiagramModelObject>((Collection<IDiagramModelObject>)view.getChildren());
        }

        public void execute() {
            this.redo();
            this.resolveDiagramModelReferences();
        }

        public void undo() {
            this.view.getChildren().clear();
            this.view.getChildren().addAll(this.oldChildren);
        }

        public void redo() {
            this.view.getChildren().clear();
            this.view.getChildren().addAll(this.newChildren);
        }

        private void resolveDiagramModelReferences() {
            TreeIterator iter = this.view.eAllContents();
            while (iter.hasNext()) {
                IDiagramModelReference ref;
                IDiagramModel dm;
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelReference) || (dm = (ref = (IDiagramModelReference)eObject).getReferencedModel()).getArchimateModel() != ViewImporter.this.getImportedModel()) continue;
                try {
                    IDiagramModel targetDM = ViewImporter.this.findObjectInTargetModel(dm);
                    if (targetDM != null) {
                        ref.setReferencedModel(targetDM);
                        continue;
                    }
                    Logger.logError((String)"Could not get referenced View!");
                }
                catch (ImportException ex) {
                    Logger.logError((String)"Error getting referenced View!", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
        }

        public void dispose() {
            this.view = null;
            this.oldChildren = null;
            this.newChildren = null;
        }
    }
}

