/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.impl;

import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.impl.ArchimateRelationship;
import com.archimatetool.model.impl.DiagramModelConnection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

public class DiagramModelArchimateConnection
extends DiagramModelConnection
implements IDiagramModelArchimateConnection {
    private IArchimateRelationship fRelationship;

    protected DiagramModelArchimateConnection() {
    }

    @Override
    protected EClass eStaticClass() {
        return IArchimatePackage.Literals.DIAGRAM_MODEL_ARCHIMATE_CONNECTION;
    }

    @Override
    public String getName() {
        if (this.getArchimateRelationship() != null) {
            return this.getArchimateRelationship().getName();
        }
        return super.getName();
    }

    @Override
    public void setName(String name) {
        if (this.getArchimateRelationship() != null) {
            this.getArchimateRelationship().setName(name);
        }
    }

    @Override
    public void connect(IConnectable source, IConnectable target) {
        if (!(source instanceof IDiagramModelArchimateComponent) || !(target instanceof IDiagramModelArchimateComponent)) {
            throw new IllegalArgumentException("Should be Archimate objects/connections for source and target!");
        }
        super.connect(source, target);
    }

    @Override
    public void reconnect() {
        super.reconnect();
        if (this.source instanceof IDiagramModelArchimateComponent && this.target instanceof IDiagramModelArchimateComponent) {
            IArchimateConcept srcConcept = ((IDiagramModelArchimateComponent)this.source).getArchimateConcept();
            IArchimateConcept tgtConcept = ((IDiagramModelArchimateComponent)this.target).getArchimateConcept();
            this.getArchimateRelationship().setSource(srcConcept);
            this.getArchimateRelationship().setTarget(tgtConcept);
        }
    }

    @Override
    public IArchimateRelationship getArchimateRelationship() {
        return this.fRelationship;
    }

    @Override
    public void setArchimateRelationship(IArchimateRelationship relationship) {
        if (this.fRelationship != null) {
            ((ArchimateRelationship)this.fRelationship).diagramConnections.remove(this);
        }
        if (relationship != null) {
            ((ArchimateRelationship)relationship).diagramConnections.add(this);
        }
        this.fRelationship = relationship;
    }

    @Override
    public IArchimateRelationship getArchimateConcept() {
        return this.getArchimateRelationship();
    }

    @Override
    public void setArchimateConcept(IArchimateConcept concept) {
        if (concept != null && !(concept instanceof IArchimateRelationship)) {
            throw new IllegalArgumentException("Should be of type IArchimateRelationship");
        }
        this.setArchimateRelationship((IArchimateRelationship)concept);
    }

    @Override
    public void addArchimateConceptToModel(IFolder parent) {
        IArchimateRelationship relationship = this.getArchimateRelationship();
        if (relationship != null && relationship.eContainer() != null) {
            throw new IllegalArgumentException("Relationship already has parent folder");
        }
        if (parent == null) {
            parent = this.getDiagramModel().getArchimateModel().getDefaultFolderForObject(relationship);
        }
        if (relationship != null) {
            parent.getElements().add((Object)relationship);
            relationship.reconnect();
        }
    }

    @Override
    public void removeArchimateConceptFromModel() {
        IFolder folder;
        IArchimateRelationship relationship = this.getArchimateRelationship();
        if (relationship != null && (folder = (IFolder)relationship.eContainer()) != null) {
            relationship.disconnect();
            folder.getElements().remove((Object)relationship);
        }
    }

    @Override
    public EObject getCopy() {
        IDiagramModelArchimateConnection newConnection = (IDiagramModelArchimateConnection)super.getCopy();
        IArchimateRelationship relationship = (IArchimateRelationship)this.getArchimateRelationship().getCopy();
        newConnection.setArchimateRelationship(relationship);
        return newConnection;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (this.fRelationship != null) {
            ((ArchimateRelationship)this.fRelationship).diagramConnections.add(this);
        }
        return super.eInverseAdd(otherEnd, featureID, baseClass, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (this.fRelationship != null) {
            ((ArchimateRelationship)this.fRelationship).diagramConnections.remove(this);
        }
        return super.eInverseRemove(otherEnd, featureID, baseClass, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getArchimateRelationship();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setArchimateRelationship((IArchimateRelationship)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.setArchimateRelationship(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.getArchimateRelationship() != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

