/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.viewpoints;

import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.viewpoints.IViewpoint;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;

class Viewpoint
implements IViewpoint {
    private Set<EClass> elementsClassList = new HashSet<EClass>();
    private Set<EClass> relationsClassList = new HashSet<EClass>();
    private static Set<EClass> defaultList = Stream.of(IArchimatePackage.eINSTANCE.getJunction(), IArchimatePackage.eINSTANCE.getGrouping()).collect(Collectors.toCollection(HashSet::new));
    private String id;
    private String name;

    Viewpoint(String id, String name) {
        this.id = id;
        this.name = name;
    }

    void addEClass(EClass eClass) {
        if (IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(eClass)) {
            this.elementsClassList.add(eClass);
        } else if (IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass)) {
            this.relationsClassList.add(eClass);
        }
    }

    @Override
    public boolean isAllowedConcept(EClass eClass) {
        if (!IArchimatePackage.eINSTANCE.getArchimateConcept().isSuperTypeOf(eClass)) {
            return true;
        }
        if (IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(eClass) && this.elementsClassList.isEmpty()) {
            return true;
        }
        if (IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass) && this.relationsClassList.isEmpty()) {
            return true;
        }
        return this.elementsClassList.contains(eClass) || this.relationsClassList.contains(eClass) || defaultList.contains(eClass);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

