/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.viewpoints;

import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.Logger;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.Messages;
import com.archimatetool.model.viewpoints.Viewpoint;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class ViewpointManager {
    public static IViewpoint NONE_VIEWPOINT = new Viewpoint("", Messages.ViewpointsManager_0);
    private static final String BUNDLE_ID = "com.archimatetool.model";
    private static final String VIEWPOINTS_FILE = "model/viewpoints.xml";
    private static final String BUSINESS_ELEMENTS = "$BusinessElements$";
    private static final String APPLICATION_ELEMENTS = "$ApplicationElements$";
    private static final String TECHNOLOGY_ELEMENTS = "$TechnologyElements$";
    private static final String PHYSICAL_ELEMENTS = "$PhysicalElements$";
    private static final String STRATEGY_ELEMENTS = "$StrategyElements$";
    private static final String MOTIVATION_ELEMENTS = "$MotivationElements$";
    private static final String IMPLEMENTATION_MIGRATION_ELEMENTS = "$ImplementationMigrationElements$";
    private static final String STRUCTURAL_RELATIONSHIPS = "$StructuralRelationships$";
    private static final String DEPENDENCY_RELATIONSHIPS = "$DependencyRelationships$";
    private static final String DYNAMIC_RELATIONSHIPS = "$DynamicRelationships$";
    private static final String OTHER_RELATIONSHIPS = "$OtherRelationships$";
    public static ViewpointManager INSTANCE = new ViewpointManager();
    private final Map<String, EClass[]> CONCEPTS_MAP = new HashMap<String, EClass[]>();
    private Map<String, IViewpoint> VIEWPOINTS = new HashMap<String, IViewpoint>();

    private ViewpointManager() {
        this.CONCEPTS_MAP.put(BUSINESS_ELEMENTS, ArchimateModelUtils.getBusinessClasses());
        this.CONCEPTS_MAP.put(APPLICATION_ELEMENTS, ArchimateModelUtils.getApplicationClasses());
        this.CONCEPTS_MAP.put(TECHNOLOGY_ELEMENTS, ArchimateModelUtils.getTechnologyClasses());
        this.CONCEPTS_MAP.put(PHYSICAL_ELEMENTS, ArchimateModelUtils.getPhysicalClasses());
        this.CONCEPTS_MAP.put(STRATEGY_ELEMENTS, ArchimateModelUtils.getStrategyClasses());
        this.CONCEPTS_MAP.put(MOTIVATION_ELEMENTS, ArchimateModelUtils.getMotivationClasses());
        this.CONCEPTS_MAP.put(IMPLEMENTATION_MIGRATION_ELEMENTS, ArchimateModelUtils.getImplementationMigrationClasses());
        this.CONCEPTS_MAP.put(STRUCTURAL_RELATIONSHIPS, this.getTypedRelationships(IArchimatePackage.eINSTANCE.getStructuralRelationship()));
        this.CONCEPTS_MAP.put(DEPENDENCY_RELATIONSHIPS, this.getTypedRelationships(IArchimatePackage.eINSTANCE.getDependendencyRelationship()));
        this.CONCEPTS_MAP.put(DYNAMIC_RELATIONSHIPS, this.getTypedRelationships(IArchimatePackage.eINSTANCE.getDynamicRelationship()));
        this.CONCEPTS_MAP.put(OTHER_RELATIONSHIPS, this.getTypedRelationships(IArchimatePackage.eINSTANCE.getOtherRelationship()));
        try {
            this.loadDefaultViewpointsFile();
        }
        catch (IOException | JDOMException ex) {
            ex.printStackTrace();
            Logger.logError("Could not load Viewpoints", ex);
        }
    }

    public List<IViewpoint> getAllViewpoints() {
        ArrayList<IViewpoint> list = new ArrayList<IViewpoint>(this.VIEWPOINTS.values());
        Collections.sort(list, new Comparator<IViewpoint>(){

            @Override
            public int compare(IViewpoint vp1, IViewpoint vp2) {
                return vp1.getName().compareTo(vp2.getName());
            }
        });
        list.add(0, NONE_VIEWPOINT);
        return list;
    }

    public IViewpoint getViewpoint(String id) {
        if (id == null || "".equals(id)) {
            return NONE_VIEWPOINT;
        }
        IViewpoint vp = this.VIEWPOINTS.get(id);
        return vp == null ? NONE_VIEWPOINT : vp;
    }

    public boolean isAllowedDiagramModelComponent(IDiagramModelArchimateComponent dmc) {
        if (dmc.getDiagramModel() instanceof IArchimateDiagramModel) {
            IArchimateDiagramModel dm = (IArchimateDiagramModel)dmc.getDiagramModel();
            boolean isAllowedConcept = this.isAllowedConceptForDiagramModel(dm, dmc.getArchimateConcept().eClass());
            if (dmc instanceof IDiagramModelArchimateConnection) {
                IDiagramModelArchimateConnection connection = (IDiagramModelArchimateConnection)dmc;
                return isAllowedConcept && this.isAllowedDiagramModelComponent((IDiagramModelArchimateComponent)connection.getSource()) && this.isAllowedDiagramModelComponent((IDiagramModelArchimateComponent)connection.getTarget());
            }
            return isAllowedConcept;
        }
        return true;
    }

    public boolean isAllowedConceptForDiagramModel(IArchimateDiagramModel dm, EClass eClass) {
        if (dm != null) {
            IViewpoint vp = this.getViewpoint(dm.getViewpoint());
            return vp == null ? true : vp.isAllowedConcept(eClass);
        }
        return true;
    }

    private void loadDefaultViewpointsFile() throws IOException, JDOMException {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)BUNDLE_ID), (IPath)new Path("$nl$/model/viewpoints.xml"));
        url = FileLocator.resolve((URL)url);
        Document doc = new SAXBuilder().build(url);
        Element rootElement = doc.getRootElement();
        for (Element xmlViewpoint : rootElement.getChildren("viewpoint")) {
            String id = xmlViewpoint.getAttributeValue("id");
            if (id == null || "".equals(id)) {
                System.err.println("Blank id for viewpoint");
                continue;
            }
            Element xmlName = xmlViewpoint.getChild("name");
            if (xmlName == null) {
                System.err.println("No name element for viewpoint");
                continue;
            }
            String name = xmlName.getText();
            if (name == null || "".equals(name)) {
                System.err.println("Blank name for viewpoint");
                continue;
            }
            Viewpoint vp = new Viewpoint(id, name);
            for (Element xmlConcept : xmlViewpoint.getChildren("concept")) {
                String conceptName = xmlConcept.getText();
                if (conceptName == null || "".equals(conceptName)) {
                    System.err.println("Blank concept name for viewpoint");
                    continue;
                }
                if (this.CONCEPTS_MAP.containsKey(conceptName)) {
                    this.addCollection(vp, conceptName);
                    continue;
                }
                EClass eClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(conceptName);
                if (eClass != null) {
                    this.addConcept(vp, eClass);
                    continue;
                }
                System.err.println("Couldn't get eClass: " + conceptName);
            }
            this.VIEWPOINTS.put(id, vp);
        }
    }

    private void addCollection(Viewpoint vp, String conceptName) {
        EClass[] eClassArray = this.CONCEPTS_MAP.get(conceptName);
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            this.addConcept(vp, eClass);
            ++n2;
        }
    }

    private void addConcept(Viewpoint vp, EClass eClass) {
        vp.addEClass(eClass);
    }

    private EClass[] getTypedRelationships(EClass supertype) {
        ArrayList<EClass> list = new ArrayList<EClass>();
        EClass[] eClassArray = ArchimateModelUtils.getRelationsClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (supertype.isSuperTypeOf(eClass)) {
                list.add(eClass);
            }
            ++n2;
        }
        return list.toArray(new EClass[list.size()]);
    }
}

