/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.zest;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.ui.ClipboardImageTransfer;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.zest.Messages;
import com.archimatetool.zest.ZestGraphViewer;
import com.archimatetool.zest.ZestView;
import org.eclipse.core.commands.IHandler;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.IHandlerService;

public class CopyZestViewAsImageToClipboardAction
extends Action {
    private ZestGraphViewer fGraphViewer;

    public CopyZestViewAsImageToClipboardAction(ZestView zestView) {
        super(Messages.CopyZestViewAsImageToClipboardAction_0);
        this.fGraphViewer = zestView.getViewer();
        this.setToolTipText(this.getText());
        this.setActionDefinitionId("com.archimatetool.editor.action.exportAsImageToClipboard");
        IHandlerService service = (IHandlerService)zestView.getSite().getService(IHandlerService.class);
        service.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    public void run() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Image image = null;
                try {
                    try {
                        image = DiagramUtils.createImage((IFigure)CopyZestViewAsImageToClipboardAction.this.fGraphViewer.getGraphControl().getContents(), (double)1.0, (int)10);
                        ImageData imageData = image.getImageData(ImageFactory.getImageDeviceZoom());
                        ClipboardImageTransfer.copyImageDataToClipboard((ImageData)imageData);
                    }
                    catch (Throwable ex) {
                        Logger.log((int)4, (String)"Error exporting image", (Throwable)ex);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CopyZestViewAsImageToClipboardAction_0, (String)(Messages.CopyZestViewAsImageToClipboardAction_2 + " " + (ex.getMessage() == null ? ex.toString() : ex.getMessage())));
                        if (image != null) {
                            image.dispose();
                        }
                    }
                }
                finally {
                    if (image != null) {
                        image.dispose();
                    }
                }
            }
        });
    }
}

