/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.zest;

import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.zest.Messages;
import com.archimatetool.zest.ZestGraphViewer;
import com.archimatetool.zest.ZestView;
import com.archimatetool.zest.ZestViewerLabelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.zest.core.widgets.GraphNode;

public class DrillDownManager
implements ISelectionChangedListener {
    private Stack<IArchimateConcept> fBackStack = new Stack();
    private IAction fActionHome;
    private IAction fActionBack;
    private IAction fActionGoInto;
    private ZestView fView;
    private ZestGraphViewer fGraphViewer;
    private IArchimateConcept fHomeConcept;
    private IArchimateConcept fCurrentConcept;
    private Map<Object, NodePositions> fPositions = new HashMap<Object, NodePositions>();

    DrillDownManager(ZestView view) {
        this.fView = view;
        this.fGraphViewer = view.getViewer();
        this.fGraphViewer.addSelectionChangedListener(this);
        this.makeActions();
    }

    void setNewInput(IArchimateConcept concept) {
        if (concept == this.fCurrentConcept) {
            return;
        }
        this.saveCurrentState();
        this.fHomeConcept = concept;
        this.fCurrentConcept = concept;
        this.setGraphViewerInput(concept);
        this.fBackStack.clear();
        this.restoreLastState();
        this.updateNavigationButtons();
    }

    private void setGraphViewerInput(Object object) {
        ((ZestViewerLabelProvider)this.fGraphViewer.getLabelProvider()).setFocusElement(object);
        this.fGraphViewer.setInput(object);
    }

    IArchimateConcept getCurrentConcept() {
        return this.fCurrentConcept;
    }

    void reset() {
        this.setNewInput(null);
        this.fPositions.clear();
        this.fView.updateLabel();
        this.fView.updateActions();
    }

    void goHome() {
        if (this.isDeletedObject(this.fHomeConcept)) {
            this.reset();
        } else {
            this.setNewInput(this.fHomeConcept);
            this.fView.updateLabel();
        }
    }

    void goInto() {
        IArchimateConcept concept = (IArchimateConcept)this.fGraphViewer.getStructuredSelection().getFirstElement();
        if (!this.isValidObject(concept)) {
            return;
        }
        this.saveCurrentState();
        this.fBackStack.push(this.fCurrentConcept);
        this.fCurrentConcept = concept;
        this.setGraphViewerInput(concept);
        this.updateNavigationButtons();
        this.restoreLastState();
        this.fView.updateLabel();
    }

    void goBack() {
        if (this.fBackStack.isEmpty()) {
            return;
        }
        this.saveCurrentState();
        IArchimateConcept concept = this.fBackStack.pop();
        if (this.isDeletedObject(concept)) {
            this.reset();
            return;
        }
        this.fCurrentConcept = concept;
        this.setGraphViewerInput(concept);
        this.updateNavigationButtons();
        this.restoreLastState();
        this.fView.updateLabel();
    }

    void addNavigationActions(IToolBarManager toolBar) {
        toolBar.add(this.fActionHome);
        toolBar.add(this.fActionBack);
        toolBar.add(this.fActionGoInto);
    }

    void addNavigationActions(IMenuManager manager) {
        manager.add(this.fActionHome);
        manager.add(this.fActionBack);
        manager.add(this.fActionGoInto);
    }

    void saveCurrentState() {
        if (this.fCurrentConcept == null) {
            return;
        }
        NodePositions pos = this.fPositions.get(this.fCurrentConcept);
        if (pos == null) {
            pos = new NodePositions();
            this.fPositions.put(this.fCurrentConcept, pos);
        }
        pos.saveNodePositions();
    }

    void restoreLastState() {
        if (this.fCurrentConcept == null) {
            return;
        }
        NodePositions pos = this.fPositions.get(this.fCurrentConcept);
        if (pos != null) {
            pos.restoreNodePositions();
        } else {
            this.fGraphViewer.doApplyLayout();
        }
    }

    private void makeActions() {
        this.fActionHome = new Action(Messages.DrillDownManager_0){

            public void run() {
                DrillDownManager.this.goHome();
            }

            public String getToolTipText() {
                return Messages.DrillDownManager_1;
            }

            public ImageDescriptor getImageDescriptor() {
                return ResourceLocator.imageDescriptorFromBundle((String)"com.archimatetool.zest", (String)"img/home_nav.png").orElse(null);
            }
        };
        this.fActionHome.setEnabled(false);
        this.fActionBack = new Action(Messages.DrillDownManager_2){

            public void run() {
                DrillDownManager.this.goBack();
            }

            public String getToolTipText() {
                return Messages.DrillDownManager_3;
            }

            public ImageDescriptor getImageDescriptor() {
                return ResourceLocator.imageDescriptorFromBundle((String)"com.archimatetool.zest", (String)"img/backward_nav.png").orElse(null);
            }
        };
        this.fActionBack.setEnabled(false);
        this.fActionGoInto = new Action(Messages.DrillDownManager_4){

            public void run() {
                DrillDownManager.this.goInto();
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return ResourceLocator.imageDescriptorFromBundle((String)"com.archimatetool.zest", (String)"img/forward_nav.png").orElse(null);
            }
        };
        this.fActionGoInto.setEnabled(false);
    }

    private void updateNavigationButtons() {
        Object selected = this.fGraphViewer.getStructuredSelection().getFirstElement();
        this.fActionHome.setEnabled(this.fHomeConcept != null && this.fHomeConcept != this.fCurrentConcept);
        this.fActionBack.setEnabled(!this.fBackStack.isEmpty());
        this.fActionGoInto.setEnabled(this.isValidObject(selected));
    }

    private boolean isValidObject(Object selected) {
        return selected != null && selected != this.fCurrentConcept && selected instanceof IArchimateElement;
    }

    private boolean isDeletedObject(IArchimateConcept concept) {
        return concept != null && concept.eContainer() == null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNavigationButtons();
    }

    private class NodePositions {
        private Map<Object, Point> nodePositions = new HashMap<Object, Point>();

        private NodePositions() {
        }

        void saveNodePositions() {
            for (Object n : DrillDownManager.this.fGraphViewer.getGraphControl().getNodes()) {
                GraphNode node = (GraphNode)n;
                Object element = node.getData();
                this.nodePositions.put(element, node.getLocation());
            }
        }

        void restoreNodePositions() {
            boolean doLayout = false;
            for (Object n : DrillDownManager.this.fGraphViewer.getGraphControl().getNodes()) {
                GraphNode node = (GraphNode)n;
                Object element = node.getData();
                Point pt = this.nodePositions.get(element);
                if (pt != null && pt.x != 0 && pt.y != 0) {
                    node.setLocation((double)pt.x, (double)pt.y);
                } else {
                    pt = node.getLocation();
                    this.nodePositions.put(element, pt);
                }
                if (pt.x != 0 || pt.y != 0) continue;
                doLayout = true;
            }
            if (doLayout) {
                DrillDownManager.this.fGraphViewer.doApplyLayout();
            }
        }
    }
}

