/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.zest;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.zest.ZestViewerContentProvider;
import com.archimatetool.zest.ZestViewerLabelProvider;
import org.eclipse.draw2d.Viewport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.zest.core.viewers.GraphViewer;

public class ZestGraphViewer
extends GraphViewer {
    private IPropertyChangeListener prefsListener = event -> {
        if (AnimationUtil.supportsAnimation()) {
            if ("animateVisualiserNodes".equals(event.getProperty())) {
                this.getGraphControl().setAnimationEnabled(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("animateVisualiserNodes"));
            } else if ("animationVisualiserTime".equals(event.getProperty())) {
                this.getGraphControl().setAnimationTime(ArchiPlugin.getInstance().getPreferenceStore().getInt("animationVisualiserTime"));
            }
        }
    };

    public ZestGraphViewer(Composite composite, int style) {
        super(composite, style);
        this.setContentProvider((IContentProvider)new ZestViewerContentProvider());
        this.setLabelProvider(new ZestViewerLabelProvider());
        if (AnimationUtil.supportsAnimation()) {
            this.getGraphControl().setAnimationEnabled(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("animateVisualiserNodes"));
            this.getGraphControl().setAnimationTime(ArchiPlugin.getInstance().getPreferenceStore().getInt("animationVisualiserTime"));
        }
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
        this.getGraphControl().addDisposeListener(e -> ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener));
        this.getGraphControl().addMouseWheelListener(new MouseWheelListener(){
            private static final int DIRECTION = -1;
            private static final int DELTA = 30;

            public void mouseScrolled(MouseEvent event) {
                if ((event.stateMask & SWT.MOD2) != 0) {
                    Viewport viewPort = ZestGraphViewer.this.getGraphControl().getViewport();
                    viewPort.setViewLocation(viewPort.getViewLocation().translate(event.count * 30 * -1, 0));
                }
            }
        });
        ThemeUtils.registerCssId((Control)this.getGraphControl(), (String)"ArchiGraph");
        ThemeUtils.setBackgroundColorIfCssThemingDisabled((Control)this.getGraphControl(), (String)"com.archimatetool.editor.VISUALISER_BACKGROUND");
    }

    void doApplyLayout() {
        super.applyLayout();
    }

    public void applyLayout() {
    }
}

