/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.zest;

import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;

public class ZestViewerContentProvider
implements IGraphContentProvider {
    static final int DIR_BOTH = 1;
    static final int DIR_IN = 2;
    static final int DIR_OUT = 3;
    private int fDepth = 0;
    private IViewpoint fViewpoint = ViewpointManager.NONE_VIEWPOINT;
    private Set<EClass> fElementClasses = new LinkedHashSet<EClass>();
    private Set<EClass> fRelationshipClasses = new LinkedHashSet<EClass>();
    private int fDirection = 1;

    public void setViewpointFilter(IViewpoint vp) {
        assert (vp != null);
        this.fViewpoint = vp;
    }

    public IViewpoint getViewpointFilter() {
        return this.fViewpoint;
    }

    public void addElementFilter(EClass elementClass) {
        if (elementClass == null) {
            this.fElementClasses.clear();
        } else {
            this.fElementClasses.add(elementClass);
        }
    }

    public void removeElementFilter(EClass elementClass) {
        if (elementClass != null) {
            this.fElementClasses.remove(elementClass);
        }
    }

    public Set<EClass> getElementFilters() {
        return this.fElementClasses;
    }

    public void addRelationshipFilter(EClass relationshipClass) {
        if (relationshipClass == null) {
            this.fRelationshipClasses.clear();
        } else {
            this.fRelationshipClasses.add(relationshipClass);
        }
    }

    public void removeRelationshipFilter(EClass relationshipClass) {
        if (relationshipClass != null) {
            this.fRelationshipClasses.remove(relationshipClass);
        }
    }

    public Set<EClass> getRelationshipFilters() {
        return this.fRelationshipClasses;
    }

    public void setDirection(int direction) {
        if (direction == 1 || direction == 2 || direction == 3) {
            this.fDirection = direction;
        }
    }

    public int getDirection() {
        return this.fDirection;
    }

    public void setDepth(int depth) {
        this.fDepth = depth;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IArchimateConcept) {
            IArchimateConcept archimateConcept = (IArchimateConcept)inputElement;
            if (archimateConcept.eContainer() == null) {
                return new Object[0];
            }
            if (archimateConcept instanceof IArchimateRelationship) {
                return new Object[]{inputElement};
            }
            if (archimateConcept instanceof IArchimateElement) {
                HashSet<IArchimateRelationship> mainList = new HashSet<IArchimateRelationship>();
                this.getRelations(mainList, new HashSet<IArchimateConcept>(), archimateConcept, 0);
                return mainList.toArray();
            }
        }
        return new Object[0];
    }

    private void getRelations(Set<IArchimateRelationship> mainList, Set<IArchimateConcept> checkList, IArchimateConcept concept, int count) {
        if (checkList.contains(concept)) {
            return;
        }
        checkList.add(concept);
        if (count > this.fDepth) {
            return;
        }
        ++count;
        for (IArchimateRelationship relationship : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)concept)) {
            int direction;
            IArchimateConcept other = relationship.getSource().equals(concept) ? relationship.getTarget() : relationship.getSource();
            int n = direction = relationship.getSource().equals(concept) ? 3 : 2;
            if (!mainList.contains(relationship) && this.fViewpoint.isAllowedConcept(other.eClass()) && this.isVisible(relationship) && (direction == this.fDirection || this.fDirection == 1) && other instanceof IArchimateElement && this.isVisible((IArchimateElement)other)) {
                mainList.add(relationship);
            }
            if (!this.fViewpoint.isAllowedConcept(other.eClass()) || !this.isVisible(relationship) || direction != this.fDirection && this.fDirection != 1) continue;
            this.getRelations(mainList, checkList, other, count);
        }
    }

    public Object getSource(Object rel) {
        if (rel instanceof IArchimateRelationship) {
            return ((IArchimateRelationship)rel).getSource();
        }
        return null;
    }

    public Object getDestination(Object rel) {
        if (rel instanceof IArchimateRelationship) {
            return ((IArchimateRelationship)rel).getTarget();
        }
        return null;
    }

    private boolean isVisible(IArchimateElement element) {
        if (this.fElementClasses.isEmpty()) {
            return true;
        }
        return this.fElementClasses.contains(element.eClass());
    }

    private boolean isVisible(IArchimateRelationship relation) {
        if (this.fRelationshipClasses.isEmpty()) {
            return true;
        }
        return this.fRelationshipClasses.contains(relation.eClass());
    }
}

