"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CLI_TELEMETRY_CODES = exports.CLI_PRIVATE_SPAN = exports.CLI_PRIVATE_IO = void 0;
const make = require("../../api-private");
/**
 * Private message types specific to the CLI
 */
exports.CLI_PRIVATE_IO = {
    CDK_CLI_I1000: make.trace({
        code: 'CDK_CLI_I1000',
        description: 'Cloud Execution is starting',
        interface: 'EventStart',
    }),
    CDK_CLI_I1001: make.trace({
        code: 'CDK_CLI_I1001',
        description: 'Cloud Executable Result',
        interface: 'EventResult',
    }),
    CDK_CLI_I2000: make.trace({
        code: 'CDK_CLI_I2000',
        description: 'Command has started',
        interface: 'EventStart',
    }),
    CDK_CLI_I2001: make.trace({
        code: 'CDK_CLI_I2001',
        description: 'Command has finished executing',
        interface: 'EventResult',
    }),
    CDK_CLI_I3000: make.trace({
        code: 'CDK_CLI_I3000',
        description: 'Deploy has started',
        interface: 'EventStart',
    }),
    CDK_CLI_I3001: make.trace({
        code: 'CDK_CLI_I3001',
        description: 'Deploy has finished',
        interface: 'EventResult',
    }),
};
/**
 * Payload type of the end message must extend Duration
 */
exports.CLI_PRIVATE_SPAN = {
    SYNTH_ASSEMBLY: {
        name: 'Synthesis',
        start: exports.CLI_PRIVATE_IO.CDK_CLI_I1000,
        end: exports.CLI_PRIVATE_IO.CDK_CLI_I1001,
    },
    COMMAND: {
        name: 'Command',
        start: exports.CLI_PRIVATE_IO.CDK_CLI_I2000,
        end: exports.CLI_PRIVATE_IO.CDK_CLI_I2001,
    },
    DEPLOY: {
        name: 'Deploy',
        start: exports.CLI_PRIVATE_IO.CDK_CLI_I3000,
        end: exports.CLI_PRIVATE_IO.CDK_CLI_I3001,
    },
};
exports.CLI_TELEMETRY_CODES = [
    exports.CLI_PRIVATE_IO.CDK_CLI_I1001,
    exports.CLI_PRIVATE_IO.CDK_CLI_I2001,
    exports.CLI_PRIVATE_IO.CDK_CLI_I3001,
];
//# sourceMappingURL=data:application/json;base64,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