"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlagCommandHandler = void 0;
const interactive_handler_1 = require("./interactive-handler");
const operations_1 = require("./operations");
const router_1 = require("./router");
const validator_1 = require("./validator");
const obsolete_flags_1 = require("../../obsolete-flags");
class FlagCommandHandler {
    /** Main component that sets up all flag operation components */
    constructor(flagData, ioHelper, options, toolkit) {
        this.flags = flagData.filter(flag => !obsolete_flags_1.OBSOLETE_FLAGS.includes(flag.name));
        this.options = { ...options, concurrency: options.concurrency ?? 4 };
        this.ioHelper = ioHelper;
        const validator = new validator_1.FlagValidator(ioHelper);
        const flagOperations = new operations_1.FlagOperations(this.flags, toolkit, ioHelper);
        const interactiveHandler = new interactive_handler_1.InteractiveHandler(this.flags, flagOperations);
        this.router = new router_1.FlagOperationRouter(validator, interactiveHandler, flagOperations);
    }
    /** Main entry point that processes the flags command */
    async processFlagsCommand() {
        if (this.flags.length === 0) {
            await this.ioHelper.defaults.error('The \'cdk flags\' command is not compatible with the AWS CDK library used by your application. Please upgrade to 2.212.0 or above.');
            return;
        }
        await this.router.route(this.options);
    }
}
exports.FlagCommandHandler = FlagCommandHandler;
//# sourceMappingURL=data:application/json;base64,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