"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertYargsToUserInput = convertYargsToUserInput;
exports.convertConfigToUserInput = convertConfigToUserInput;
// @ts-ignore TS6133
function convertYargsToUserInput(args) {
    const globalOptions = {
        app: args.app,
        build: args.build,
        context: args.context,
        plugin: args.plugin,
        trace: args.trace,
        strict: args.strict,
        lookups: args.lookups,
        ignoreErrors: args.ignoreErrors,
        json: args.json,
        verbose: args.verbose,
        debug: args.debug,
        profile: args.profile,
        proxy: args.proxy,
        caBundlePath: args.caBundlePath,
        ec2creds: args.ec2creds,
        versionReporting: args.versionReporting,
        pathMetadata: args.pathMetadata,
        assetMetadata: args.assetMetadata,
        roleArn: args.roleArn,
        staging: args.staging,
        output: args.output,
        notices: args.notices,
        noColor: args.noColor,
        ci: args.ci,
        unstable: args.unstable,
        telemetryFile: args.telemetryFile,
        yes: args.yes,
    };
    let commandOptions;
    switch (args._[0]) {
        case 'list':
        case 'ls':
            commandOptions = {
                long: args.long,
                showDependencies: args.showDependencies,
                STACKS: args.STACKS,
            };
            break;
        case 'synth':
        case 'synthesize':
            commandOptions = {
                exclusively: args.exclusively,
                validation: args.validation,
                quiet: args.quiet,
                STACKS: args.STACKS,
            };
            break;
        case 'bootstrap':
            commandOptions = {
                bootstrapBucketName: args.bootstrapBucketName,
                bootstrapKmsKeyId: args.bootstrapKmsKeyId,
                examplePermissionsBoundary: args.examplePermissionsBoundary,
                customPermissionsBoundary: args.customPermissionsBoundary,
                bootstrapCustomerKey: args.bootstrapCustomerKey,
                qualifier: args.qualifier,
                publicAccessBlockConfiguration: args.publicAccessBlockConfiguration,
                denyExternalId: args.denyExternalId,
                tags: args.tags,
                execute: args.execute,
                trust: args.trust,
                trustForLookup: args.trustForLookup,
                untrust: args.untrust,
                cloudformationExecutionPolicies: args.cloudformationExecutionPolicies,
                force: args.force,
                terminationProtection: args.terminationProtection,
                showTemplate: args.showTemplate,
                toolkitStackName: args.toolkitStackName,
                template: args.template,
                previousParameters: args.previousParameters,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'gc':
            commandOptions = {
                action: args.action,
                type: args.type,
                rollbackBufferDays: args.rollbackBufferDays,
                createdBufferDays: args.createdBufferDays,
                confirm: args.confirm,
                toolkitStackName: args.toolkitStackName,
                bootstrapStackName: args.bootstrapStackName,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'flags':
            commandOptions = {
                value: args.value,
                set: args.set,
                all: args.all,
                unconfigured: args.unconfigured,
                recommended: args.recommended,
                default: args.default,
                interactive: args.interactive,
                safe: args.safe,
                concurrency: args.concurrency,
                FLAGNAME: args.FLAGNAME,
            };
            break;
        case 'deploy':
            commandOptions = {
                all: args.all,
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                requireApproval: args.requireApproval,
                notificationArns: args.notificationArns,
                tags: args.tags,
                execute: args.execute,
                changeSetName: args.changeSetName,
                method: args.method,
                importExistingResources: args.importExistingResources,
                force: args.force,
                parameters: args.parameters,
                outputsFile: args.outputsFile,
                previousParameters: args.previousParameters,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                watch: args.watch,
                logs: args.logs,
                concurrency: args.concurrency,
                assetParallelism: args.assetParallelism,
                assetPrebuild: args.assetPrebuild,
                ignoreNoStacks: args.ignoreNoStacks,
                STACKS: args.STACKS,
            };
            break;
        case 'rollback':
            commandOptions = {
                all: args.all,
                toolkitStackName: args.toolkitStackName,
                force: args.force,
                validateBootstrapVersion: args.validateBootstrapVersion,
                orphan: args.orphan,
                STACKS: args.STACKS,
            };
            break;
        case 'import':
            commandOptions = {
                execute: args.execute,
                changeSetName: args.changeSetName,
                toolkitStackName: args.toolkitStackName,
                rollback: args.rollback,
                force: args.force,
                recordResourceMapping: args.recordResourceMapping,
                resourceMapping: args.resourceMapping,
                STACK: args.STACK,
            };
            break;
        case 'watch':
            commandOptions = {
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                changeSetName: args.changeSetName,
                force: args.force,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                logs: args.logs,
                concurrency: args.concurrency,
                STACKS: args.STACKS,
            };
            break;
        case 'destroy':
            commandOptions = {
                all: args.all,
                exclusively: args.exclusively,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'diff':
            commandOptions = {
                exclusively: args.exclusively,
                contextLines: args.contextLines,
                template: args.template,
                strict: args.strict,
                securityOnly: args.securityOnly,
                fail: args.fail,
                processed: args.processed,
                quiet: args.quiet,
                changeSet: args.changeSet,
                importExistingResources: args.importExistingResources,
                includeMoves: args.includeMoves,
                STACKS: args.STACKS,
            };
            break;
        case 'drift':
            commandOptions = {
                fail: args.fail,
                STACKS: args.STACKS,
            };
            break;
        case 'metadata':
            commandOptions = {
                STACK: args.STACK,
            };
            break;
        case 'acknowledge':
        case 'ack':
            commandOptions = {
                ID: args.ID,
            };
            break;
        case 'notices':
            commandOptions = {
                unacknowledged: args.unacknowledged,
            };
            break;
        case 'init':
            commandOptions = {
                language: args.language,
                list: args.list,
                generateOnly: args.generateOnly,
                libVersion: args.libVersion,
                fromPath: args.fromPath,
                templatePath: args.templatePath,
                packageManager: args.packageManager,
                TEMPLATE: args.TEMPLATE,
            };
            break;
        case 'migrate':
            commandOptions = {
                stackName: args.stackName,
                language: args.language,
                account: args.account,
                region: args.region,
                fromPath: args.fromPath,
                fromStack: args.fromStack,
                outputPath: args.outputPath,
                fromScan: args.fromScan,
                filter: args.filter,
                compress: args.compress,
            };
            break;
        case 'context':
            commandOptions = {
                reset: args.reset,
                force: args.force,
                clear: args.clear,
            };
            break;
        case 'docs':
        case 'doc':
            commandOptions = {
                browser: args.browser,
            };
            break;
        case 'doctor':
            commandOptions = {};
            break;
        case 'refactor':
            commandOptions = {
                additionalStackName: args.additionalStackName,
                dryRun: args.dryRun,
                overrideFile: args.overrideFile,
                revert: args.revert,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'cli-telemetry':
            commandOptions = {
                enable: args.enable,
                disable: args.disable,
                status: args.status,
            };
            break;
    }
    const userInput = {
        command: args._[0],
        globalOptions,
        [args._[0]]: commandOptions,
    };
    return userInput;
}
// @ts-ignore TS6133
function convertConfigToUserInput(config) {
    const globalOptions = {
        app: config.app,
        build: config.build,
        context: config.context,
        plugin: config.plugin,
        trace: config.trace,
        strict: config.strict,
        lookups: config.lookups,
        ignoreErrors: config.ignoreErrors,
        json: config.json,
        verbose: config.verbose,
        debug: config.debug,
        profile: config.profile,
        proxy: config.proxy,
        caBundlePath: config.caBundlePath,
        ec2creds: config.ec2creds,
        versionReporting: config.versionReporting,
        pathMetadata: config.pathMetadata,
        assetMetadata: config.assetMetadata,
        roleArn: config.roleArn,
        staging: config.staging,
        output: config.output,
        notices: config.notices,
        noColor: config.noColor,
        ci: config.ci,
        unstable: config.unstable,
        telemetryFile: config.telemetryFile,
        yes: config.yes,
    };
    const listOptions = {
        long: config.list?.long,
        showDependencies: config.list?.showDependencies,
    };
    const synthOptions = {
        exclusively: config.synth?.exclusively,
        validation: config.synth?.validation,
        quiet: config.synth?.quiet,
    };
    const bootstrapOptions = {
        bootstrapBucketName: config.bootstrap?.bootstrapBucketName,
        bootstrapKmsKeyId: config.bootstrap?.bootstrapKmsKeyId,
        examplePermissionsBoundary: config.bootstrap?.examplePermissionsBoundary,
        customPermissionsBoundary: config.bootstrap?.customPermissionsBoundary,
        bootstrapCustomerKey: config.bootstrap?.bootstrapCustomerKey,
        qualifier: config.bootstrap?.qualifier,
        publicAccessBlockConfiguration: config.bootstrap?.publicAccessBlockConfiguration,
        denyExternalId: config.bootstrap?.denyExternalId,
        tags: config.bootstrap?.tags,
        execute: config.bootstrap?.execute,
        trust: config.bootstrap?.trust,
        trustForLookup: config.bootstrap?.trustForLookup,
        untrust: config.bootstrap?.untrust,
        cloudformationExecutionPolicies: config.bootstrap?.cloudformationExecutionPolicies,
        force: config.bootstrap?.force,
        terminationProtection: config.bootstrap?.terminationProtection,
        showTemplate: config.bootstrap?.showTemplate,
        toolkitStackName: config.bootstrap?.toolkitStackName,
        template: config.bootstrap?.template,
        previousParameters: config.bootstrap?.previousParameters,
    };
    const gcOptions = {
        action: config.gc?.action,
        type: config.gc?.type,
        rollbackBufferDays: config.gc?.rollbackBufferDays,
        createdBufferDays: config.gc?.createdBufferDays,
        confirm: config.gc?.confirm,
        toolkitStackName: config.gc?.toolkitStackName,
        bootstrapStackName: config.gc?.bootstrapStackName,
    };
    const flagsOptions = {
        value: config.flags?.value,
        set: config.flags?.set,
        all: config.flags?.all,
        unconfigured: config.flags?.unconfigured,
        recommended: config.flags?.recommended,
        default: config.flags?.default,
        interactive: config.flags?.interactive,
        safe: config.flags?.safe,
        concurrency: config.flags?.concurrency,
    };
    const deployOptions = {
        all: config.deploy?.all,
        buildExclude: config.deploy?.buildExclude,
        exclusively: config.deploy?.exclusively,
        requireApproval: config.deploy?.requireApproval,
        notificationArns: config.deploy?.notificationArns,
        tags: config.deploy?.tags,
        execute: config.deploy?.execute,
        changeSetName: config.deploy?.changeSetName,
        method: config.deploy?.method,
        importExistingResources: config.deploy?.importExistingResources,
        force: config.deploy?.force,
        parameters: config.deploy?.parameters,
        outputsFile: config.deploy?.outputsFile,
        previousParameters: config.deploy?.previousParameters,
        toolkitStackName: config.deploy?.toolkitStackName,
        progress: config.deploy?.progress,
        rollback: config.deploy?.rollback,
        hotswap: config.deploy?.hotswap,
        hotswapFallback: config.deploy?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.deploy?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.deploy?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.deploy?.hotswapEcsStabilizationTimeoutSeconds,
        watch: config.deploy?.watch,
        logs: config.deploy?.logs,
        concurrency: config.deploy?.concurrency,
        assetParallelism: config.deploy?.assetParallelism,
        assetPrebuild: config.deploy?.assetPrebuild,
        ignoreNoStacks: config.deploy?.ignoreNoStacks,
    };
    const rollbackOptions = {
        all: config.rollback?.all,
        toolkitStackName: config.rollback?.toolkitStackName,
        force: config.rollback?.force,
        validateBootstrapVersion: config.rollback?.validateBootstrapVersion,
        orphan: config.rollback?.orphan,
    };
    const importOptions = {
        execute: config.import?.execute,
        changeSetName: config.import?.changeSetName,
        toolkitStackName: config.import?.toolkitStackName,
        rollback: config.import?.rollback,
        force: config.import?.force,
        recordResourceMapping: config.import?.recordResourceMapping,
        resourceMapping: config.import?.resourceMapping,
    };
    const watchOptions = {
        buildExclude: config.watch?.buildExclude,
        exclusively: config.watch?.exclusively,
        changeSetName: config.watch?.changeSetName,
        force: config.watch?.force,
        toolkitStackName: config.watch?.toolkitStackName,
        progress: config.watch?.progress,
        rollback: config.watch?.rollback,
        hotswap: config.watch?.hotswap,
        hotswapFallback: config.watch?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.watch?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.watch?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.watch?.hotswapEcsStabilizationTimeoutSeconds,
        logs: config.watch?.logs,
        concurrency: config.watch?.concurrency,
    };
    const destroyOptions = {
        all: config.destroy?.all,
        exclusively: config.destroy?.exclusively,
        force: config.destroy?.force,
    };
    const diffOptions = {
        exclusively: config.diff?.exclusively,
        contextLines: config.diff?.contextLines,
        template: config.diff?.template,
        strict: config.diff?.strict,
        securityOnly: config.diff?.securityOnly,
        fail: config.diff?.fail,
        processed: config.diff?.processed,
        quiet: config.diff?.quiet,
        changeSet: config.diff?.changeSet,
        importExistingResources: config.diff?.importExistingResources,
        includeMoves: config.diff?.includeMoves,
    };
    const driftOptions = {
        fail: config.drift?.fail,
    };
    const metadataOptions = {};
    const acknowledgeOptions = {};
    const noticesOptions = {
        unacknowledged: config.notices?.unacknowledged,
    };
    const initOptions = {
        language: config.init?.language,
        list: config.init?.list,
        generateOnly: config.init?.generateOnly,
        libVersion: config.init?.libVersion,
        fromPath: config.init?.fromPath,
        templatePath: config.init?.templatePath,
        packageManager: config.init?.packageManager,
    };
    const migrateOptions = {
        stackName: config.migrate?.stackName,
        language: config.migrate?.language,
        account: config.migrate?.account,
        region: config.migrate?.region,
        fromPath: config.migrate?.fromPath,
        fromStack: config.migrate?.fromStack,
        outputPath: config.migrate?.outputPath,
        fromScan: config.migrate?.fromScan,
        filter: config.migrate?.filter,
        compress: config.migrate?.compress,
    };
    const contextOptions = {
        reset: config.context?.reset,
        force: config.context?.force,
        clear: config.context?.clear,
    };
    const docsOptions = {
        browser: config.docs?.browser,
    };
    const doctorOptions = {};
    const refactorOptions = {
        additionalStackName: config.refactor?.additionalStackName,
        dryRun: config.refactor?.dryRun,
        overrideFile: config.refactor?.overrideFile,
        revert: config.refactor?.revert,
        force: config.refactor?.force,
    };
    const cliTelemetryOptions = {
        enable: config.cliTelemetry?.enable,
        disable: config.cliTelemetry?.disable,
        status: config.cliTelemetry?.status,
    };
    const userInput = {
        globalOptions,
        list: listOptions,
        synth: synthOptions,
        bootstrap: bootstrapOptions,
        gc: gcOptions,
        flags: flagsOptions,
        deploy: deployOptions,
        rollback: rollbackOptions,
        import: importOptions,
        watch: watchOptions,
        destroy: destroyOptions,
        diff: diffOptions,
        drift: driftOptions,
        metadata: metadataOptions,
        acknowledge: acknowledgeOptions,
        notices: noticesOptions,
        init: initOptions,
        migrate: migrateOptions,
        context: contextOptions,
        docs: docsOptions,
        doctor: doctorOptions,
        refactor: refactorOptions,
        cliTelemetry: cliTelemetryOptions,
    };
    return userInput;
}
//# sourceMappingURL=data:application/json;base64,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