"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.aliases = exports.describe = exports.command = void 0;
exports.docs = docs;
const childProcess = require("child_process");
const node_util_1 = require("node:util");
const chalk = require("chalk");
exports.command = 'docs';
exports.describe = 'Opens the reference documentation in a browser';
exports.aliases = ['doc'];
async function docs(options) {
    const ioHelper = options.ioHelper;
    const url = 'https://docs.aws.amazon.com/cdk/api/v2/';
    await ioHelper.defaults.info(chalk.green(url));
    const browserCommand = (options.browser).replace(/%u/g, url);
    await ioHelper.defaults.debug(`Opening documentation ${chalk.green(browserCommand)}`);
    const exec = (0, node_util_1.promisify)(childProcess.exec);
    try {
        const { stdout, stderr } = await exec(browserCommand);
        if (stdout) {
            await ioHelper.defaults.debug(stdout);
        }
        if (stderr) {
            await ioHelper.defaults.warn(stderr);
        }
    }
    catch (err) {
        const e = err;
        await ioHelper.defaults.debug(`An error occurred when trying to open a browser: ${e.stack || e.message}`);
    }
    return 0;
}
//# sourceMappingURL=data:application/json;base64,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