"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCommandLineArguments = parseCommandLineArguments;
// -------------------------------------------------------------------------------------------
// GENERATED FROM packages/aws-cdk/lib/cli/cli-config.ts.
// Do not edit by hand; all changes will be overwritten at build time from the config file.
// -------------------------------------------------------------------------------------------
/* eslint-disable @stylistic/max-len, @typescript-eslint/consistent-type-imports */
const helpers = require("./util/yargs-helpers");
// @ts-ignore TS6133
function parseCommandLineArguments(args) {
    return yargs
        .env('CDK')
        .usage('Usage: cdk -a <cdk-app> COMMAND')
        .option('app', {
        default: undefined,
        type: 'string',
        alias: 'a',
        desc: 'REQUIRED WHEN RUNNING APP: command-line for executing your app or a cloud assembly directory (e.g. "node bin/my-app.js"). Can also be specified in cdk.json or ~/.cdk.json',
        requiresArg: true,
    })
        .option('build', {
        default: undefined,
        type: 'string',
        desc: 'Command-line for a pre-synth build',
    })
        .option('context', {
        type: 'array',
        alias: 'c',
        desc: 'Add contextual string parameter (KEY=VALUE)',
        nargs: 1,
        requiresArg: true,
    })
        .option('plugin', {
        type: 'array',
        alias: 'p',
        desc: 'Name or path of a node package that extend the CDK features. Can be specified multiple times',
        nargs: 1,
        requiresArg: true,
    })
        .option('trace', {
        default: undefined,
        type: 'boolean',
        desc: 'Print trace for stack warnings',
    })
        .option('strict', {
        default: undefined,
        type: 'boolean',
        desc: 'Do not construct stacks with warnings',
    })
        .option('lookups', {
        default: true,
        type: 'boolean',
        desc: 'Perform context lookups (synthesis fails if this is disabled and context lookups need to be performed)',
    })
        .option('ignore-errors', {
        default: false,
        type: 'boolean',
        desc: 'Ignores synthesis errors, which will likely produce an invalid output',
    })
        .option('json', {
        default: false,
        type: 'boolean',
        alias: 'j',
        desc: 'Use JSON output instead of YAML when templates are printed to STDOUT',
    })
        .option('verbose', {
        default: false,
        type: 'boolean',
        alias: 'v',
        desc: 'Show debug logs (specify multiple times to increase verbosity)',
        count: true,
    })
        .option('debug', {
        default: false,
        type: 'boolean',
        desc: 'Debug the CDK app. Log additional information during synthesis, such as creation stack traces of tokens (sets CDK_DEBUG, will slow down synthesis)',
    })
        .option('profile', {
        default: undefined,
        type: 'string',
        desc: 'Use the indicated AWS profile as the default environment',
        requiresArg: true,
    })
        .option('proxy', {
        default: undefined,
        type: 'string',
        desc: 'Use the indicated proxy. Will read from HTTPS_PROXY environment variable if not specified',
        requiresArg: true,
    })
        .option('ca-bundle-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to CA certificate to use when validating HTTPS requests. Will read from AWS_CA_BUNDLE environment variable if not specified',
        requiresArg: true,
    })
        .option('ec2creds', {
        default: undefined,
        type: 'boolean',
        alias: 'i',
        desc: 'Force trying to fetch EC2 instance credentials. Default: guess EC2 instance status',
    })
        .option('version-reporting', {
        default: undefined,
        type: 'boolean',
        desc: 'Disable CLI telemetry and do not include the "AWS::CDK::Metadata" resource in synthesized templates (enabled by default)',
        alias: 'telemetry',
    })
        .option('path-metadata', {
        default: undefined,
        type: 'boolean',
        desc: 'Include "aws:cdk:path" CloudFormation metadata for each resource (enabled by default)',
    })
        .option('asset-metadata', {
        default: undefined,
        type: 'boolean',
        desc: 'Include "aws:asset:*" CloudFormation metadata for resources that uses assets (enabled by default)',
    })
        .option('role-arn', {
        default: undefined,
        type: 'string',
        alias: 'r',
        desc: 'ARN of Role to use when invoking CloudFormation',
        requiresArg: true,
    })
        .option('staging', {
        default: true,
        type: 'boolean',
        desc: 'Copy assets to the output directory (use --no-staging to disable the copy of assets which allows local debugging via the SAM CLI to reference the original source files)',
    })
        .option('output', {
        default: undefined,
        type: 'string',
        alias: 'o',
        desc: 'Emits the synthesized cloud assembly into a directory (default: cdk.out)',
        requiresArg: true,
    })
        .option('notices', {
        default: undefined,
        type: 'boolean',
        desc: 'Show relevant notices',
    })
        .option('no-color', {
        default: false,
        type: 'boolean',
        desc: 'Removes colors and other style from console output',
    })
        .option('ci', {
        default: helpers.isCI(),
        type: 'boolean',
        desc: 'Force CI detection. If CI=true then logs will be sent to stdout instead of stderr',
    })
        .option('unstable', {
        type: 'array',
        desc: 'Opt in to unstable features. The flag indicates that the scope and API of a feature might still change. Otherwise the feature is generally production ready and fully supported. Can be specified multiple times.',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('telemetry-file', {
        default: undefined,
        type: 'string',
        desc: 'Send telemetry data to a local file.',
    })
        .option('yes', {
        default: false,
        type: 'boolean',
        alias: 'y',
        desc: 'Automatically answer interactive prompts with the recommended response. This includes confirming actions.',
    })
        .command(['list [STACKS..]', 'ls [STACKS..]'], 'Lists all stacks in the app', (yargs) => yargs
        .option('long', {
        default: false,
        type: 'boolean',
        alias: 'l',
        desc: 'Display environment information for each stack',
    })
        .option('show-dependencies', {
        default: false,
        type: 'boolean',
        alias: 'd',
        desc: 'Display stack dependency information for each stack',
    }))
        .command(['synth [STACKS..]', 'synthesize [STACKS..]'], 'Synthesizes and prints the CloudFormation template for this stack', (yargs) => yargs
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only synthesize requested stacks, don't include dependencies",
    })
        .option('validation', {
        default: true,
        type: 'boolean',
        desc: 'After synthesis, validate stacks with the "validateOnSynth" attribute set (can also be controlled with CDK_VALIDATION)',
    })
        .option('quiet', {
        default: false,
        type: 'boolean',
        alias: 'q',
        desc: 'Do not output CloudFormation Template to stdout',
    }))
        .command('bootstrap [ENVIRONMENTS..]', 'Deploys the CDK toolkit stack into an AWS environment', (yargs) => yargs
        .option('bootstrap-bucket-name', {
        default: undefined,
        type: 'string',
        alias: ['b', 'toolkit-bucket-name'],
        desc: 'The name of the CDK toolkit bucket; bucket will be created and must not exist',
    })
        .option('bootstrap-kms-key-id', {
        default: undefined,
        type: 'string',
        desc: 'AWS KMS master key ID used for the SSE-KMS encryption (specify AWS_MANAGED_KEY to use an AWS-managed key)',
        conflicts: 'bootstrap-customer-key',
    })
        .option('example-permissions-boundary', {
        default: undefined,
        type: 'boolean',
        alias: 'epb',
        desc: 'Use the example permissions boundary.',
        conflicts: 'custom-permissions-boundary',
    })
        .option('custom-permissions-boundary', {
        default: undefined,
        type: 'string',
        alias: 'cpb',
        desc: 'Use the permissions boundary specified by name.',
        conflicts: 'example-permissions-boundary',
    })
        .option('bootstrap-customer-key', {
        default: undefined,
        type: 'boolean',
        desc: 'Create a Customer Master Key (CMK) for the bootstrap bucket (you will be charged but can customize permissions, modern bootstrapping only)',
        conflicts: 'bootstrap-kms-key-id',
    })
        .option('qualifier', {
        default: undefined,
        type: 'string',
        desc: 'String which must be unique for each bootstrap stack. You must configure it on your CDK app if you change this from the default.',
    })
        .option('public-access-block-configuration', {
        default: undefined,
        type: 'boolean',
        desc: 'Block public access configuration on CDK toolkit bucket (enabled by default) ',
    })
        .option('deny-external-id', {
        default: undefined,
        type: 'boolean',
        desc: 'Block AssumeRole access to all boostrapped roles if an ExternalId is provided (enabled by default) ',
    })
        .option('tags', {
        type: 'array',
        alias: 't',
        desc: 'Tags to add for the stack (KEY=VALUE)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('execute', {
        default: true,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)',
    })
        .option('trust', {
        type: 'array',
        desc: 'The AWS account IDs that should be trusted to perform deployments into this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('trust-for-lookup', {
        type: 'array',
        desc: 'The AWS account IDs that should be trusted to look up values in this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('untrust', {
        type: 'array',
        desc: 'The AWS account IDs that should not be trusted by this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('cloudformation-execution-policies', {
        type: 'array',
        desc: 'The Managed Policy ARNs that should be attached to the role performing deployments into this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always bootstrap even if it would downgrade template version',
    })
        .option('termination-protection', {
        default: undefined,
        type: 'boolean',
        desc: 'Toggle CloudFormation termination protection on the bootstrap stacks',
    })
        .option('show-template', {
        default: false,
        type: 'boolean',
        desc: "Instead of actual bootstrapping, print the current CLI's bootstrapping template to stdout for customization",
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack to create',
        requiresArg: true,
    })
        .option('template', {
        default: undefined,
        type: 'string',
        requiresArg: true,
        desc: 'Use the template from the given file instead of the built-in one (use --show-template to obtain an example)',
    })
        .option('previous-parameters', {
        default: true,
        type: 'boolean',
        desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)',
    }))
        .command('gc [ENVIRONMENTS..]', 'Garbage collect assets. Options detailed here: https://github.com/aws/aws-cdk-cli/tree/main/packages/aws-cdk#cdk-gc', (yargs) => yargs
        .option('action', {
        default: 'full',
        type: 'string',
        desc: 'The action (or sub-action) you want to perform. Valid entires are "print", "tag", "delete-tagged", "full".',
    })
        .option('type', {
        default: 'all',
        type: 'string',
        desc: 'Specify either ecr, s3, or all',
    })
        .option('rollback-buffer-days', {
        default: 0,
        type: 'number',
        desc: 'Delete assets that have been marked as isolated for this many days',
    })
        .option('created-buffer-days', {
        default: 1,
        type: 'number',
        desc: 'Never delete assets younger than this (in days)',
    })
        .option('confirm', {
        default: true,
        type: 'boolean',
        desc: 'Confirm via manual prompt before deletion',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit"',
        requiresArg: true,
        conflicts: 'bootstrap-stack-name',
    })
        .option('bootstrap-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit" (deprecated, use --toolkit-stack-name)',
        deprecated: 'use --toolkit-stack-name',
        requiresArg: true,
        conflicts: 'toolkit-stack-name',
    }))
        .command('flags [FLAGNAME..]', 'View and toggle feature flags.', (yargs) => yargs
        .option('value', {
        default: undefined,
        type: 'string',
        desc: 'The value the user would like to set the feature flag configuration to',
        requiresArg: true,
    })
        .option('set', {
        default: undefined,
        type: 'boolean',
        desc: 'Signifies the user would like to modify their feature flag configuration',
        requiresArg: false,
    })
        .option('all', {
        default: undefined,
        type: 'boolean',
        desc: 'Modify or view all feature flags',
        requiresArg: false,
    })
        .option('unconfigured', {
        default: undefined,
        type: 'boolean',
        desc: 'Modify unconfigured feature flags',
        requiresArg: false,
    })
        .option('recommended', {
        default: undefined,
        type: 'boolean',
        desc: 'Change flags to recommended states',
        requiresArg: false,
    })
        .option('default', {
        default: undefined,
        type: 'boolean',
        desc: 'Change flags to default state',
        requiresArg: false,
    })
        .option('interactive', {
        default: undefined,
        type: 'boolean',
        alias: ['i'],
        desc: 'Interactive option for the flags command',
    })
        .option('safe', {
        default: undefined,
        type: 'boolean',
        desc: "Enable all feature flags that do not impact the user's application",
        requiresArg: false,
    })
        .option('concurrency', {
        default: 4,
        type: 'number',
        alias: ['n'],
        desc: 'Maximum number of simultaneous synths to execute.',
        requiresArg: true,
    }))
        .command('deploy [STACKS..]', 'Deploys the stack(s) named STACKS into your AWS account', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Deploy all available stacks',
    })
        .option('build-exclude', {
        type: 'array',
        alias: 'E',
        desc: 'Do not rebuild asset with the given ID. Can be specified multiple times',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only deploy requested stacks, don't include dependencies",
    })
        .option('require-approval', {
        default: undefined,
        type: 'string',
        choices: ['never', 'any-change', 'broadening'],
        desc: 'What security-sensitive changes need manual approval',
    })
        .option('notification-arns', {
        type: 'array',
        desc: "ARNs of SNS topics that CloudFormation will notify with stack related events. These will be added to ARNs specified with the 'notificationArns' stack property.",
        nargs: 1,
        requiresArg: true,
    })
        .option('tags', {
        type: 'array',
        alias: 't',
        desc: 'Tags to add to the stack (KEY=VALUE), overrides tags from Cloud Assembly (deprecated)',
        nargs: 1,
        requiresArg: true,
    })
        .option('execute', {
        default: undefined,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet) (deprecated)',
        deprecated: true,
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create (only if method is not direct)',
    })
        .option('method', {
        default: undefined,
        alias: 'm',
        type: 'string',
        choices: ['direct', 'change-set', 'prepare-change-set'],
        requiresArg: true,
        desc: 'How to perform the deployment. Direct is a bit faster but lacks progress information',
    })
        .option('import-existing-resources', {
        default: false,
        type: 'boolean',
        desc: 'Indicates if the stack set imports resources that already exist.',
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always deploy stack even if templates are identical',
    })
        .option('parameters', {
        type: 'array',
        desc: 'Additional parameters passed to CloudFormation at deploy time (STACK:KEY=VALUE)',
        default: {},
        nargs: 1,
        requiresArg: true,
    })
        .option('outputs-file', {
        default: undefined,
        type: 'string',
        alias: 'O',
        desc: 'Path to file where stack outputs will be written as JSON',
        requiresArg: true,
    })
        .option('previous-parameters', {
        default: true,
        type: 'boolean',
        desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)',
        requiresArg: true,
    })
        .option('progress', {
        default: undefined,
        type: 'string',
        choices: ['bar', 'events'],
        desc: 'Display mode for stack activity events',
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('R', { type: 'boolean', hidden: true })
        .middleware(helpers.yargsNegativeAlias('R', 'rollback'), true)
        .option('hotswap', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, but does not fall back to a full deployment if that is not possible. Instead, changes to any non-hotswappable properties are ignored.Do not use this in production environments",
    })
        .option('hotswap-fallback', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, which skips CloudFormation and updates the resources directly, and falls back to a full deployment if that is not possible. Do not use this in production environments",
    })
        .option('hotswap-ecs-minimum-healthy-percent', {
        default: undefined,
        type: 'string',
        desc: "Lower limit on the number of your service's tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-maximum-healthy-percent', {
        default: undefined,
        type: 'string',
        desc: "Upper limit on the number of your service's tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-stabilization-timeout-seconds', {
        default: undefined,
        type: 'string',
        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
    })
        .option('watch', {
        default: undefined,
        type: 'boolean',
        desc: 'Continuously observe the project files, and deploy the given stack(s) automatically when changes are detected. Implies --hotswap by default',
    })
        .option('logs', {
        default: true,
        type: 'boolean',
        desc: "Show CloudWatch log events from all resources in the selected Stacks in the terminal. 'true' by default, use --no-logs to turn off. Only in effect if specified alongside the '--watch' option",
    })
        .option('concurrency', {
        default: 1,
        type: 'number',
        desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.',
        requiresArg: true,
    })
        .option('asset-parallelism', {
        default: undefined,
        type: 'boolean',
        desc: 'Whether to build/publish assets in parallel',
    })
        .option('asset-prebuild', {
        default: true,
        type: 'boolean',
        desc: 'Whether to build all assets before deploying the first stack (useful for failing Docker builds)',
    })
        .option('ignore-no-stacks', {
        default: false,
        type: 'boolean',
        desc: 'Whether to deploy if the app contains no stacks',
    }))
        .command('rollback [STACKS..]', 'Rolls back the stack(s) named STACKS to their last stable state', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Roll back all available stacks',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack the environment is bootstrapped with',
        requiresArg: true,
    })
        .option('force', {
        default: undefined,
        alias: 'f',
        type: 'boolean',
        desc: 'Orphan all resources for which the rollback operation fails.',
    })
        .option('validate-bootstrap-version', {
        default: undefined,
        type: 'boolean',
        desc: "Whether to validate the bootstrap stack version. Defaults to 'true', disable with --no-validate-bootstrap-version.",
    })
        .option('orphan', {
        type: 'array',
        desc: 'Orphan the given resources, identified by their logical ID (can be specified multiple times)',
        default: [],
        nargs: 1,
        requiresArg: true,
    }))
        .command('import [STACK]', 'Import existing resource(s) into the given STACK', (yargs) => yargs
        .option('execute', {
        default: true,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)',
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack to create',
        requiresArg: true,
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('force', {
        default: undefined,
        alias: 'f',
        type: 'boolean',
        desc: "Do not abort if the template diff includes updates or deletes. This is probably safe but we're not sure, let us know how it goes.",
    })
        .option('record-resource-mapping', {
        default: undefined,
        type: 'string',
        alias: 'r',
        requiresArg: true,
        desc: 'If specified, CDK will generate a mapping of existing physical resources to CDK resources to be imported as. The mapping will be written in the given file path. No actual import operation will be performed',
    })
        .option('resource-mapping', {
        default: undefined,
        type: 'string',
        alias: 'm',
        requiresArg: true,
        desc: 'If specified, CDK will use the given file to map physical resources to CDK resources for import, instead of interactively asking the user. Can be run from scripts',
    }))
        .command('watch [STACKS..]', "Shortcut for 'deploy --watch'", (yargs) => yargs
        .option('build-exclude', {
        type: 'array',
        alias: 'E',
        desc: 'Do not rebuild asset with the given ID. Can be specified multiple times',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only deploy requested stacks, don't include dependencies",
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create',
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always deploy stack even if templates are identical',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)',
        requiresArg: true,
    })
        .option('progress', {
        default: undefined,
        type: 'string',
        choices: ['bar', 'events'],
        desc: 'Display mode for stack activity events',
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('R', { type: 'boolean', hidden: true })
        .middleware(helpers.yargsNegativeAlias('R', 'rollback'), true)
        .option('hotswap', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, but does not fall back to a full deployment if that is not possible. Instead, changes to any non-hotswappable properties are ignored.'true' by default, use --no-hotswap to turn off",
    })
        .option('hotswap-fallback', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, which skips CloudFormation and updates the resources directly, and falls back to a full deployment if that is not possible.",
    })
        .option('hotswap-ecs-minimum-healthy-percent', {
        default: undefined,
        type: 'string',
        desc: "Lower limit on the number of your service's tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-maximum-healthy-percent', {
        default: undefined,
        type: 'string',
        desc: "Upper limit on the number of your service's tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-stabilization-timeout-seconds', {
        default: undefined,
        type: 'string',
        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
    })
        .option('logs', {
        default: true,
        type: 'boolean',
        desc: "Show CloudWatch log events from all resources in the selected Stacks in the terminal. 'true' by default, use --no-logs to turn off",
    })
        .option('concurrency', {
        default: 1,
        type: 'number',
        desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.',
        requiresArg: true,
    }))
        .command('destroy [STACKS..]', 'Destroy the stack(s) named STACKS', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Destroy all available stacks',
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only destroy requested stacks, don't include dependees",
    })
        .option('force', {
        default: undefined,
        type: 'boolean',
        alias: 'f',
        desc: 'Do not ask for confirmation before destroying the stacks',
    }))
        .command('diff [STACKS..]', 'Compares the specified stack with the deployed stack or a local template file, and returns with status 1 if any difference is found', (yargs) => yargs
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only diff requested stacks, don't include dependencies",
    })
        .option('context-lines', {
        default: 3,
        type: 'number',
        desc: 'Number of context lines to include in arbitrary JSON diff rendering',
        requiresArg: true,
    })
        .option('template', {
        default: undefined,
        type: 'string',
        desc: 'The path to the CloudFormation template to compare with',
        requiresArg: true,
    })
        .option('strict', {
        default: false,
        type: 'boolean',
        desc: 'Do not filter out AWS::CDK::Metadata resources, mangled non-ASCII characters, or the CheckBootstrapVersionRule',
    })
        .option('security-only', {
        default: false,
        type: 'boolean',
        desc: 'Only diff for broadened security changes',
    })
        .option('fail', {
        default: undefined,
        type: 'boolean',
        desc: 'Fail with exit code 1 in case of diff',
    })
        .option('processed', {
        default: false,
        type: 'boolean',
        desc: 'Whether to compare against the template with Transforms already processed',
    })
        .option('quiet', {
        default: false,
        type: 'boolean',
        alias: 'q',
        desc: 'Do not print stack name and default message when there is no diff to stdout',
    })
        .option('change-set', {
        default: true,
        type: 'boolean',
        alias: 'changeset',
        desc: 'Whether to create a changeset to analyze resource replacements. In this mode, diff will use the deploy role instead of the lookup role.',
    })
        .option('import-existing-resources', {
        default: false,
        type: 'boolean',
        desc: 'Whether or not the change set imports resources that already exist',
    })
        .option('include-moves', {
        default: false,
        type: 'boolean',
        desc: 'Whether to include moves in the diff',
    }))
        .command('drift [STACKS..]', 'Detect drifts in the given CloudFormation stack(s)', (yargs) => yargs.option('fail', {
        default: undefined,
        type: 'boolean',
        desc: 'Fail with exit code 1 if drift is detected',
    }))
        .command('metadata [STACK]', 'Returns all metadata associated with this stack')
        .command(['acknowledge [ID]', 'ack [ID]'], 'Acknowledge a notice so that it does not show up anymore')
        .command('notices', 'Returns a list of relevant notices', (yargs) => yargs.option('unacknowledged', {
        default: false,
        type: 'boolean',
        alias: 'u',
        desc: 'Returns a list of unacknowledged notices',
    }))
        .command('init [TEMPLATE]', 'Create a new, empty CDK project from a template.', (yargs) => yargs
        .option('language', {
        default: undefined,
        type: 'string',
        alias: 'l',
        desc: 'The language to be used for the new project (default can be configured in ~/.cdk.json)',
        choices: ['csharp', 'cs', 'fsharp', 'fs', 'go', 'java', 'javascript', 'js', 'python', 'py', 'typescript', 'ts'],
    })
        .option('list', {
        default: undefined,
        type: 'boolean',
        desc: 'List the available templates',
    })
        .option('generate-only', {
        default: false,
        type: 'boolean',
        desc: 'If true, only generates project files, without executing additional operations such as setting up a git repo, installing dependencies or compiling the project',
    })
        .option('lib-version', {
        default: undefined,
        type: 'string',
        alias: 'V',
        desc: 'The version of the CDK library (aws-cdk-lib) to initialize built-in templates with. Defaults to the version that was current when this CLI was built.',
    })
        .option('from-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to a local custom template directory or multi-template repository',
        requiresArg: true,
        conflicts: ['lib-version'],
    })
        .option('template-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to a specific template within a multi-template repository',
        requiresArg: true,
    })
        .option('package-manager', {
        default: undefined,
        type: 'string',
        desc: 'The package manager to use to install dependencies. Only applicable for TypeScript and JavaScript projects. Defaults to npm in TypeScript and JavaScript projects.',
        choices: ['npm', 'yarn', 'pnpm', 'bun'],
    }))
        .command('migrate', 'Migrate existing AWS resources into a CDK app', (yargs) => yargs
        .option('stack-name', {
        default: undefined,
        type: 'string',
        alias: 'n',
        desc: 'The name assigned to the stack created in the new project. The name of the app will be based off this name as well.',
        requiresArg: true,
    })
        .option('language', {
        default: 'typescript',
        type: 'string',
        alias: 'l',
        desc: 'The language to be used for the new project',
        choices: ['typescript', 'ts', 'go', 'java', 'python', 'py', 'csharp', 'cs'],
    })
        .option('account', {
        default: undefined,
        type: 'string',
        desc: 'The account to retrieve the CloudFormation stack template from',
    })
        .option('region', {
        default: undefined,
        type: 'string',
        desc: 'The region to retrieve the CloudFormation stack template from',
    })
        .option('from-path', {
        default: undefined,
        type: 'string',
        desc: 'The path to the CloudFormation template to migrate. Use this for locally stored templates',
    })
        .option('from-stack', {
        default: undefined,
        type: 'boolean',
        desc: 'Use this flag to retrieve the template for an existing CloudFormation stack',
    })
        .option('output-path', {
        default: undefined,
        type: 'string',
        desc: 'The output path for the migrated CDK app',
    })
        .option('from-scan', {
        default: undefined,
        type: 'string',
        desc: 'Determines if a new scan should be created, or the last successful existing scan should be used \n options are "new" or "most-recent"',
    })
        .option('filter', {
        type: 'array',
        desc: 'Filters the resource scan based on the provided criteria in the following format: "key1=value1,key2=value2"\n This field can be passed multiple times for OR style filtering: \n filtering options: \n resource-identifier: A key-value pair that identifies the target resource. i.e. {"ClusterName", "myCluster"}\n resource-type-prefix: A string that represents a type-name prefix. i.e. "AWS::DynamoDB::"\n tag-key: a string that matches resources with at least one tag with the provided key. i.e. "myTagKey"\n tag-value: a string that matches resources with at least one tag with the provided value. i.e. "myTagValue"',
        nargs: 1,
        requiresArg: true,
    })
        .option('compress', {
        default: undefined,
        type: 'boolean',
        desc: 'Use this flag to zip the generated CDK app',
    }))
        .command('context', 'Manage cached context values', (yargs) => yargs
        .option('reset', {
        default: undefined,
        alias: 'e',
        desc: 'The context key (or its index) to reset',
        type: 'string',
        requiresArg: true,
    })
        .option('force', {
        default: false,
        alias: 'f',
        desc: 'Ignore missing key error',
        type: 'boolean',
    })
        .option('clear', {
        default: false,
        desc: 'Clear all context',
        type: 'boolean',
    }))
        .command(['docs', 'doc'], 'Opens the reference documentation in a browser', (yargs) => yargs.option('browser', {
        default: helpers.browserForPlatform(),
        alias: 'b',
        desc: 'the command to use to open the browser, using %u as a placeholder for the path of the file to open',
        type: 'string',
    }))
        .command('doctor', 'Check your set-up for potential problems')
        .command('refactor [STACKS..]', 'Moves resources between stacks or within the same stack', (yargs) => yargs
        .option('additional-stack-name', {
        type: 'array',
        requiresArg: true,
        desc: 'Names of deployed stacks to be considered for resource comparison.',
        nargs: 1,
    })
        .option('dry-run', {
        default: false,
        type: 'boolean',
        desc: 'Do not perform any changes, just show what would be done',
    })
        .option('override-file', {
        default: undefined,
        type: 'string',
        requiresArg: true,
        desc: 'A file that declares overrides to be applied to the list of mappings computed by the CLI.',
    })
        .option('revert', {
        default: false,
        type: 'boolean',
        desc: 'If specified, the command will revert the refactor operation. This is only valid if a mapping file was provided.',
    })
        .option('force', {
        default: false,
        type: 'boolean',
        desc: 'Whether to do the refactor without asking for confirmation',
    }))
        .command('cli-telemetry', 'Enable or disable anonymous telemetry', (yargs) => yargs
        .option('enable', {
        default: undefined,
        type: 'boolean',
        desc: 'Enable anonymous telemetry',
        conflicts: 'disable',
    })
        .option('disable', {
        default: undefined,
        type: 'boolean',
        desc: 'Disable anonymous telemetry',
        conflicts: 'enable',
    })
        .option('status', {
        default: undefined,
        type: 'boolean',
        desc: 'Report telemetry opt-in/out status',
        conflicts: ['enable', 'disable'],
    }))
        .version(helpers.cliVersion())
        .demandCommand(1, '')
        .recommendCommands()
        .help()
        .alias('h', 'help')
        .epilogue('If your app has a single stack, there is no need to specify the stack name\n\nIf one of cdk.json or ~/.cdk.json exists, options specified there will be used as defaults. Settings in cdk.json take precedence.')
        .parse(args);
}
// eslint-disable-next-line @typescript-eslint/no-require-imports
const yargs = require('yargs');
//# sourceMappingURL=data:application/json;base64,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