"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.canCollectTelemetry = canCollectTelemetry;
/**
 * Whether or not we collect telemetry
 */
function canCollectTelemetry(args, context) {
    if ((['true', '1'].includes(process.env.CDK_DISABLE_CLI_TELEMETRY ?? '')) ||
        ['false', false].includes(context.get('cli-telemetry')) ||
        (args['version-reporting'] !== undefined && !args['version-reporting']) || /* aliased with telemetry option */
        (args._[0] === 'cli-telemetry' && args.disable)) /* special case for `cdk cli-telemetry --disable` */ {
        return false;
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29sbGVjdC10ZWxlbWV0cnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjb2xsZWN0LXRlbGVtZXRyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLGtEQVNDO0FBWkQ7O0dBRUc7QUFDSCxTQUFnQixtQkFBbUIsQ0FBQyxJQUFTLEVBQUUsT0FBZ0I7SUFDN0QsSUFBSSxDQUFDLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLHlCQUF5QixJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQ3ZFLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3ZELENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssU0FBUyxJQUFJLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUMsSUFBSSxtQ0FBbUM7UUFDOUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLGVBQWUsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsb0RBQW9ELENBQUMsQ0FBQztRQUN2RyxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IENvbnRleHQgfSBmcm9tICcuLi8uLi9hcGkvY29udGV4dCc7XG5cbi8qKlxuICogV2hldGhlciBvciBub3Qgd2UgY29sbGVjdCB0ZWxlbWV0cnlcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGNhbkNvbGxlY3RUZWxlbWV0cnkoYXJnczogYW55LCBjb250ZXh0OiBDb250ZXh0KTogYm9vbGVhbiB7XG4gIGlmICgoWyd0cnVlJywgJzEnXS5pbmNsdWRlcyhwcm9jZXNzLmVudi5DREtfRElTQUJMRV9DTElfVEVMRU1FVFJZID8/ICcnKSkgfHxcbiAgICBbJ2ZhbHNlJywgZmFsc2VdLmluY2x1ZGVzKGNvbnRleHQuZ2V0KCdjbGktdGVsZW1ldHJ5JykpIHx8XG4gICAgKGFyZ3NbJ3ZlcnNpb24tcmVwb3J0aW5nJ10gIT09IHVuZGVmaW5lZCAmJiAhYXJnc1sndmVyc2lvbi1yZXBvcnRpbmcnXSkgfHwgLyogYWxpYXNlZCB3aXRoIHRlbGVtZXRyeSBvcHRpb24gKi9cbiAgICAoYXJncy5fWzBdID09PSAnY2xpLXRlbGVtZXRyeScgJiYgYXJncy5kaXNhYmxlKSkgLyogc3BlY2lhbCBjYXNlIGZvciBgY2RrIGNsaS10ZWxlbWV0cnkgLS1kaXNhYmxlYCAqLyB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=