"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.YARGS_HELPERS = void 0;
exports.makeConfig = makeConfig;
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
// eslint-disable-next-line import/no-extraneous-dependencies
const user_input_gen_1 = require("@aws-cdk/user-input-gen");
const cdk_from_cfn = require("cdk-from-cfn");
const deploy_1 = require("../commands/deploy");
const init_1 = require("../commands/init");
const package_manager_1 = require("../commands/init/package-manager");
const language_1 = require("../commands/language");
exports.YARGS_HELPERS = new user_input_gen_1.CliHelpers('./util/yargs-helpers');
/**
 * Source of truth for all CDK CLI commands. `user-input-gen` translates this into:
 *
 * - the `yargs` definition in `lib/parse-command-line-arguments.ts`.
 * - the `UserInput` type in `lib/user-input.ts`.
 * - the `convertXxxToUserInput` functions in `lib/convert-to-user-input.ts`.
 */
async function makeConfig() {
    return {
        globalOptions: {
            'app': { type: 'string', alias: 'a', desc: 'REQUIRED WHEN RUNNING APP: command-line for executing your app or a cloud assembly directory (e.g. "node bin/my-app.js"). Can also be specified in cdk.json or ~/.cdk.json', requiresArg: true },
            'build': { type: 'string', desc: 'Command-line for a pre-synth build' },
            'context': { type: 'array', alias: 'c', desc: 'Add contextual string parameter (KEY=VALUE)' },
            'plugin': { type: 'array', alias: 'p', desc: 'Name or path of a node package that extend the CDK features. Can be specified multiple times' },
            'trace': { type: 'boolean', desc: 'Print trace for stack warnings' },
            'strict': { type: 'boolean', desc: 'Do not construct stacks with warnings' },
            'lookups': { type: 'boolean', desc: 'Perform context lookups (synthesis fails if this is disabled and context lookups need to be performed)', default: true },
            'ignore-errors': { type: 'boolean', default: false, desc: 'Ignores synthesis errors, which will likely produce an invalid output' },
            'json': { type: 'boolean', alias: 'j', desc: 'Use JSON output instead of YAML when templates are printed to STDOUT', default: false },
            'verbose': { type: 'boolean', alias: 'v', desc: 'Show debug logs (specify multiple times to increase verbosity)', default: false, count: true },
            'debug': { type: 'boolean', desc: 'Debug the CDK app. Log additional information during synthesis, such as creation stack traces of tokens (sets CDK_DEBUG, will slow down synthesis)', default: false },
            'profile': { type: 'string', desc: 'Use the indicated AWS profile as the default environment', requiresArg: true },
            'proxy': { type: 'string', desc: 'Use the indicated proxy. Will read from HTTPS_PROXY environment variable if not specified', requiresArg: true },
            'ca-bundle-path': { type: 'string', desc: 'Path to CA certificate to use when validating HTTPS requests. Will read from AWS_CA_BUNDLE environment variable if not specified', requiresArg: true },
            'ec2creds': { type: 'boolean', alias: 'i', default: undefined, desc: 'Force trying to fetch EC2 instance credentials. Default: guess EC2 instance status' },
            'version-reporting': { type: 'boolean', desc: 'Disable CLI telemetry and do not include the "AWS::CDK::Metadata" resource in synthesized templates (enabled by default)', default: undefined, alias: 'telemetry' },
            'path-metadata': { type: 'boolean', desc: 'Include "aws:cdk:path" CloudFormation metadata for each resource (enabled by default)', default: undefined },
            'asset-metadata': { type: 'boolean', desc: 'Include "aws:asset:*" CloudFormation metadata for resources that uses assets (enabled by default)', default: undefined },
            'role-arn': { type: 'string', alias: 'r', desc: 'ARN of Role to use when invoking CloudFormation', default: undefined, requiresArg: true },
            'staging': { type: 'boolean', desc: 'Copy assets to the output directory (use --no-staging to disable the copy of assets which allows local debugging via the SAM CLI to reference the original source files)', default: true },
            'output': { type: 'string', alias: 'o', desc: 'Emits the synthesized cloud assembly into a directory (default: cdk.out)', requiresArg: true },
            'notices': { type: 'boolean', desc: 'Show relevant notices' },
            'no-color': { type: 'boolean', desc: 'Removes colors and other style from console output', default: false },
            'ci': { type: 'boolean', desc: 'Force CI detection. If CI=true then logs will be sent to stdout instead of stderr', default: exports.YARGS_HELPERS.isCI() },
            'unstable': { type: 'array', desc: 'Opt in to unstable features. The flag indicates that the scope and API of a feature might still change. Otherwise the feature is generally production ready and fully supported. Can be specified multiple times.', default: [] },
            'telemetry-file': { type: 'string', desc: 'Send telemetry data to a local file.', default: undefined },
            'yes': { type: 'boolean', alias: 'y', desc: 'Automatically answer interactive prompts with the recommended response. This includes confirming actions.', default: false },
        },
        commands: {
            'list': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['ls'],
                description: 'Lists all stacks in the app',
                options: {
                    'long': { type: 'boolean', default: false, alias: 'l', desc: 'Display environment information for each stack' },
                    'show-dependencies': { type: 'boolean', default: false, alias: 'd', desc: 'Display stack dependency information for each stack' },
                },
            },
            'synth': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['synthesize'],
                description: 'Synthesizes and prints the CloudFormation template for this stack',
                options: {
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only synthesize requested stacks, don\'t include dependencies' },
                    validation: { type: 'boolean', desc: 'After synthesis, validate stacks with the "validateOnSynth" attribute set (can also be controlled with CDK_VALIDATION)', default: true },
                    quiet: { type: 'boolean', alias: 'q', desc: 'Do not output CloudFormation Template to stdout', default: false },
                },
            },
            'bootstrap': {
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                description: 'Deploys the CDK toolkit stack into an AWS environment',
                options: {
                    'bootstrap-bucket-name': { type: 'string', alias: ['b', 'toolkit-bucket-name'], desc: 'The name of the CDK toolkit bucket; bucket will be created and must not exist', default: undefined },
                    'bootstrap-kms-key-id': { type: 'string', desc: 'AWS KMS master key ID used for the SSE-KMS encryption (specify AWS_MANAGED_KEY to use an AWS-managed key)', default: undefined, conflicts: 'bootstrap-customer-key' },
                    'example-permissions-boundary': { type: 'boolean', alias: 'epb', desc: 'Use the example permissions boundary.', default: undefined, conflicts: 'custom-permissions-boundary' },
                    'custom-permissions-boundary': { type: 'string', alias: 'cpb', desc: 'Use the permissions boundary specified by name.', default: undefined, conflicts: 'example-permissions-boundary' },
                    'bootstrap-customer-key': { type: 'boolean', desc: 'Create a Customer Master Key (CMK) for the bootstrap bucket (you will be charged but can customize permissions, modern bootstrapping only)', default: undefined, conflicts: 'bootstrap-kms-key-id' },
                    'qualifier': { type: 'string', desc: 'String which must be unique for each bootstrap stack. You must configure it on your CDK app if you change this from the default.', default: undefined },
                    'public-access-block-configuration': { type: 'boolean', desc: 'Block public access configuration on CDK toolkit bucket (enabled by default) ', default: undefined },
                    'deny-external-id': { type: 'boolean', desc: 'Block AssumeRole access to all boostrapped roles if an ExternalId is provided (enabled by default) ', default: undefined },
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add for the stack (KEY=VALUE)', default: [] },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'trust': { type: 'array', desc: 'The AWS account IDs that should be trusted to perform deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'trust-for-lookup': { type: 'array', desc: 'The AWS account IDs that should be trusted to look up values in this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'untrust': { type: 'array', desc: 'The AWS account IDs that should not be trusted by this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'cloudformation-execution-policies': { type: 'array', desc: 'The Managed Policy ARNs that should be attached to the role performing deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always bootstrap even if it would downgrade template version', default: false },
                    'termination-protection': { type: 'boolean', default: undefined, desc: 'Toggle CloudFormation termination protection on the bootstrap stacks' },
                    'show-template': { type: 'boolean', desc: 'Instead of actual bootstrapping, print the current CLI\'s bootstrapping template to stdout for customization', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'template': { type: 'string', requiresArg: true, desc: 'Use the template from the given file instead of the built-in one (use --show-template to obtain an example)' },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                },
            },
            'gc': {
                description: 'Garbage collect assets. Options detailed here: https://github.com/aws/aws-cdk-cli/tree/main/packages/aws-cdk#cdk-gc',
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                options: {
                    'action': { type: 'string', desc: 'The action (or sub-action) you want to perform. Valid entires are "print", "tag", "delete-tagged", "full".', default: 'full' },
                    'type': { type: 'string', desc: 'Specify either ecr, s3, or all', default: 'all' },
                    'rollback-buffer-days': { type: 'number', desc: 'Delete assets that have been marked as isolated for this many days', default: 0 },
                    'created-buffer-days': { type: 'number', desc: 'Never delete assets younger than this (in days)', default: 1 },
                    'confirm': { type: 'boolean', desc: 'Confirm via manual prompt before deletion', default: true },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit"', requiresArg: true, conflicts: 'bootstrap-stack-name' },
                    'bootstrap-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit" (deprecated, use --toolkit-stack-name)', deprecated: 'use --toolkit-stack-name', requiresArg: true, conflicts: 'toolkit-stack-name' }, // TODO: remove when garbage collection is GA
                },
            },
            'flags': {
                description: 'View and toggle feature flags.',
                arg: {
                    name: 'FLAGNAME',
                    variadic: true,
                },
                options: {
                    value: { type: 'string', desc: 'The value the user would like to set the feature flag configuration to', requiresArg: true },
                    set: { type: 'boolean', desc: 'Signifies the user would like to modify their feature flag configuration', requiresArg: false },
                    all: { type: 'boolean', desc: 'Modify or view all feature flags', requiresArg: false },
                    unconfigured: { type: 'boolean', desc: 'Modify unconfigured feature flags', requiresArg: false },
                    recommended: { type: 'boolean', desc: 'Change flags to recommended states', requiresArg: false },
                    default: { type: 'boolean', desc: 'Change flags to default state', requiresArg: false },
                    interactive: { type: 'boolean', alias: ['i'], desc: 'Interactive option for the flags command' },
                    safe: { type: 'boolean', desc: 'Enable all feature flags that do not impact the user\'s application', requiresArg: false },
                    concurrency: { type: 'number', alias: ['n'], desc: 'Maximum number of simultaneous synths to execute.', default: 4, requiresArg: true },
                },
            },
            'deploy': {
                description: 'Deploys the stack(s) named STACKS into your AWS account',
                options: {
                    'all': { type: 'boolean', desc: 'Deploy all available stacks', default: false },
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'require-approval': { type: 'string', choices: [cloud_assembly_schema_1.RequireApproval.NEVER, cloud_assembly_schema_1.RequireApproval.ANYCHANGE, cloud_assembly_schema_1.RequireApproval.BROADENING], desc: 'What security-sensitive changes need manual approval' },
                    'notification-arns': { type: 'array', desc: 'ARNs of SNS topics that CloudFormation will notify with stack related events. These will be added to ARNs specified with the \'notificationArns\' stack property.' },
                    // @deprecated(v2) -- tags are part of the Cloud Assembly and tags specified here will be overwritten on the next deployment
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add to the stack (KEY=VALUE), overrides tags from Cloud Assembly (deprecated)' },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet) (deprecated)', deprecated: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create (only if method is not direct)' },
                    'method': {
                        alias: 'm',
                        type: 'string',
                        choices: ['direct', 'change-set', 'prepare-change-set'],
                        requiresArg: true,
                        desc: 'How to perform the deployment. Direct is a bit faster but lacks progress information',
                    },
                    'import-existing-resources': { type: 'boolean', desc: 'Indicates if the stack set imports resources that already exist.', default: false },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'parameters': { type: 'array', desc: 'Additional parameters passed to CloudFormation at deploy time (STACK:KEY=VALUE)', default: {} },
                    'outputs-file': { type: 'string', alias: 'O', desc: 'Path to file where stack outputs will be written as JSON', requiresArg: true },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            'Do not use this in production environments',
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible. ' +
                            'Do not use this in production environments',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'number',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'number',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'number',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'watch': {
                        type: 'boolean',
                        desc: 'Continuously observe the project files, ' +
                            'and deploy the given stack(s) automatically when changes are detected. ' +
                            'Implies --hotswap by default',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off. " +
                            "Only in effect if specified alongside the '--watch' option",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                    'asset-parallelism': { type: 'boolean', desc: 'Whether to build/publish assets in parallel' },
                    'asset-prebuild': { type: 'boolean', desc: 'Whether to build all assets before deploying the first stack (useful for failing Docker builds)', default: true },
                    'ignore-no-stacks': { type: 'boolean', desc: 'Whether to deploy if the app contains no stacks', default: false },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'rollback': {
                description: 'Rolls back the stack(s) named STACKS to their last stable state',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'all': { type: 'boolean', default: false, desc: 'Roll back all available stacks' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack the environment is bootstrapped with', requiresArg: true },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Orphan all resources for which the rollback operation fails.',
                    },
                    'validate-bootstrap-version': {
                        type: 'boolean',
                        desc: 'Whether to validate the bootstrap stack version. Defaults to \'true\', disable with --no-validate-bootstrap-version.',
                    },
                    'orphan': {
                        // alias: 'o' conflicts with --output
                        type: 'array',
                        desc: 'Orphan the given resources, identified by their logical ID (can be specified multiple times)',
                        default: [],
                    },
                },
            },
            'import': {
                description: 'Import existing resource(s) into the given STACK',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
                options: {
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                    },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Do not abort if the template diff includes updates or deletes. This is probably safe but we\'re not sure, let us know how it goes.',
                    },
                    'record-resource-mapping': {
                        type: 'string',
                        alias: 'r',
                        requiresArg: true,
                        desc: 'If specified, CDK will generate a mapping of existing physical resources to CDK resources to be imported as. The mapping ' +
                            'will be written in the given file path. No actual import operation will be performed',
                    },
                    'resource-mapping': {
                        type: 'string',
                        alias: 'm',
                        requiresArg: true,
                        desc: 'If specified, CDK will use the given file to map physical resources to CDK resources for import, instead of interactively ' +
                            'asking the user. Can be run from scripts',
                    },
                },
            },
            'watch': {
                description: "Shortcut for 'deploy --watch'",
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            "'true' by default, use --no-hotswap to turn off",
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible.',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'number',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'number',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'number',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                },
            },
            'destroy': {
                description: 'Destroy the stack(s) named STACKS',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    all: { type: 'boolean', default: false, desc: 'Destroy all available stacks' },
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only destroy requested stacks, don\'t include dependees' },
                    force: { type: 'boolean', alias: 'f', desc: 'Do not ask for confirmation before destroying the stacks' },
                },
            },
            'diff': {
                description: 'Compares the specified stack with the deployed stack or a local template file, and returns with status 1 if any difference is found',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only diff requested stacks, don\'t include dependencies' },
                    'context-lines': { type: 'number', desc: 'Number of context lines to include in arbitrary JSON diff rendering', default: 3, requiresArg: true },
                    'template': { type: 'string', desc: 'The path to the CloudFormation template to compare with', requiresArg: true },
                    'strict': { type: 'boolean', desc: 'Do not filter out AWS::CDK::Metadata resources, mangled non-ASCII characters, or the CheckBootstrapVersionRule', default: false },
                    'security-only': { type: 'boolean', desc: 'Only diff for broadened security changes', default: false },
                    'fail': { type: 'boolean', desc: 'Fail with exit code 1 in case of diff' },
                    'processed': { type: 'boolean', desc: 'Whether to compare against the template with Transforms already processed', default: false },
                    'quiet': { type: 'boolean', alias: 'q', desc: 'Do not print stack name and default message when there is no diff to stdout', default: false },
                    'change-set': { type: 'boolean', alias: 'changeset', desc: 'Whether to create a changeset to analyze resource replacements. In this mode, diff will use the deploy role instead of the lookup role.', default: true },
                    'import-existing-resources': { type: 'boolean', desc: 'Whether or not the change set imports resources that already exist', default: false },
                    'include-moves': { type: 'boolean', desc: 'Whether to include moves in the diff', default: false },
                },
            },
            'drift': {
                description: 'Detect drifts in the given CloudFormation stack(s)',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    fail: { type: 'boolean', desc: 'Fail with exit code 1 if drift is detected' },
                },
            },
            'metadata': {
                description: 'Returns all metadata associated with this stack',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
            },
            'acknowledge': {
                aliases: ['ack'],
                description: 'Acknowledge a notice so that it does not show up anymore',
                arg: {
                    name: 'ID',
                    variadic: false,
                },
            },
            'notices': {
                description: 'Returns a list of relevant notices',
                options: {
                    unacknowledged: { type: 'boolean', alias: 'u', default: false, desc: 'Returns a list of unacknowledged notices' },
                },
            },
            'init': {
                description: 'Create a new, empty CDK project from a template.',
                arg: {
                    name: 'TEMPLATE',
                    variadic: false,
                },
                options: {
                    'language': { type: 'string', alias: 'l', desc: 'The language to be used for the new project (default can be configured in ~/.cdk.json)', choices: await (0, init_1.availableInitLanguages)() },
                    'list': { type: 'boolean', desc: 'List the available templates' },
                    'generate-only': { type: 'boolean', default: false, desc: 'If true, only generates project files, without executing additional operations such as setting up a git repo, installing dependencies or compiling the project' },
                    'lib-version': { type: 'string', alias: 'V', default: undefined, desc: 'The version of the CDK library (aws-cdk-lib) to initialize built-in templates with. Defaults to the version that was current when this CLI was built.' },
                    'from-path': { type: 'string', desc: 'Path to a local custom template directory or multi-template repository', requiresArg: true, conflicts: ['lib-version'] },
                    'template-path': { type: 'string', desc: 'Path to a specific template within a multi-template repository', requiresArg: true },
                    'package-manager': { type: 'string', desc: 'The package manager to use to install dependencies. Only applicable for TypeScript and JavaScript projects. Defaults to npm in TypeScript and JavaScript projects.', choices: package_manager_1.JS_PACKAGE_MANAGERS.map(({ name }) => name) },
                    'project-name': { type: 'string', alias: 'n', desc: 'The name of the new project', requiresArg: true },
                },
                implies: { 'template-path': 'from-path' },
            },
            'migrate': {
                description: 'Migrate existing AWS resources into a CDK app',
                options: {
                    'stack-name': { type: 'string', alias: 'n', desc: 'The name assigned to the stack created in the new project. The name of the app will be based off this name as well.', requiresArg: true },
                    'language': {
                        type: 'string',
                        default: 'typescript',
                        alias: 'l',
                        desc: 'The language to be used for the new project',
                        choices: [...new Set(cdk_from_cfn.supported_languages().flatMap((lang) => [lang, (0, language_1.getLanguageAlias)(lang)]))],
                    },
                    'account': { type: 'string', desc: 'The account to retrieve the CloudFormation stack template from' },
                    'region': { type: 'string', desc: 'The region to retrieve the CloudFormation stack template from' },
                    'from-path': { type: 'string', desc: 'The path to the CloudFormation template to migrate. Use this for locally stored templates' },
                    'from-stack': { type: 'boolean', desc: 'Use this flag to retrieve the template for an existing CloudFormation stack' },
                    'output-path': { type: 'string', desc: 'The output path for the migrated CDK app' },
                    'from-scan': {
                        type: 'string',
                        desc: 'Determines if a new scan should be created, or the last successful existing scan should be used ' +
                            '\n options are "new" or "most-recent"',
                    },
                    'filter': {
                        type: 'array',
                        desc: 'Filters the resource scan based on the provided criteria in the following format: "key1=value1,key2=value2"' +
                            '\n This field can be passed multiple times for OR style filtering: ' +
                            '\n filtering options: ' +
                            '\n resource-identifier: A key-value pair that identifies the target resource. i.e. {"ClusterName", "myCluster"}' +
                            '\n resource-type-prefix: A string that represents a type-name prefix. i.e. "AWS::DynamoDB::"' +
                            '\n tag-key: a string that matches resources with at least one tag with the provided key. i.e. "myTagKey"' +
                            '\n tag-value: a string that matches resources with at least one tag with the provided value. i.e. "myTagValue"',
                    },
                    'compress': { type: 'boolean', desc: 'Use this flag to zip the generated CDK app' },
                },
            },
            'context': {
                description: 'Manage cached context values',
                options: {
                    reset: { alias: 'e', desc: 'The context key (or its index) to reset', type: 'string', requiresArg: true, default: undefined },
                    force: { alias: 'f', desc: 'Ignore missing key error', type: 'boolean', default: false },
                    clear: { desc: 'Clear all context', type: 'boolean', default: false },
                },
            },
            'docs': {
                aliases: ['doc'],
                description: 'Opens the reference documentation in a browser',
                options: {
                    browser: {
                        alias: 'b',
                        desc: 'the command to use to open the browser, using %u as a placeholder for the path of the file to open',
                        type: 'string',
                        default: exports.YARGS_HELPERS.browserForPlatform(),
                    },
                },
            },
            'doctor': {
                description: 'Check your set-up for potential problems',
            },
            'refactor': {
                description: 'Moves resources between stacks or within the same stack',
                options: {
                    'additional-stack-name': {
                        type: 'array',
                        requiresArg: true,
                        desc: 'Names of deployed stacks to be considered for resource comparison.',
                    },
                    'dry-run': {
                        type: 'boolean',
                        desc: 'Do not perform any changes, just show what would be done',
                        default: false,
                    },
                    'override-file': {
                        type: 'string',
                        requiresArg: true,
                        desc: 'A file that declares overrides to be applied to the list of mappings computed by the CLI.',
                    },
                    'revert': {
                        type: 'boolean',
                        default: false,
                        desc: 'If specified, the command will revert the refactor operation. This is only valid if a mapping file was provided.',
                    },
                    'force': {
                        type: 'boolean',
                        default: false,
                        desc: 'Whether to do the refactor without asking for confirmation',
                    },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'cli-telemetry': {
                description: 'Enable or disable anonymous telemetry',
                options: {
                    enable: {
                        type: 'boolean',
                        desc: 'Enable anonymous telemetry',
                        conflicts: 'disable',
                    },
                    disable: {
                        type: 'boolean',
                        desc: 'Disable anonymous telemetry',
                        conflicts: 'enable',
                    },
                    status: {
                        type: 'boolean',
                        desc: 'Report telemetry opt-in/out status',
                        conflicts: ['enable', 'disable'],
                    },
                },
            },
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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