"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureFlag = void 0;
// TODO: implement this by bundling the source of truth with the CDK CLI
// We are currently hardcoding these values to facilitate a quicker release.
/**
 * Enum of all valid CDK feature flag names.
 *
 * These flags are used to control behavior changes in the CDK.
 * For more information, see: https://github.com/aws/aws-cdk/blob/main/packages/aws-cdk-lib/cx-api/FEATURE_FLAGS.md
 */
var FeatureFlag;
(function (FeatureFlag) {
    FeatureFlag["CORE_NEW_STYLE_STACK_SYNTHESIS"] = "@aws-cdk/core:newStyleStackSynthesis";
    FeatureFlag["CORE_STACK_RELATIVE_EXPORTS"] = "@aws-cdk/core:stackRelativeExports";
    FeatureFlag["RDS_LOWERCASE_DB_IDENTIFIER"] = "@aws-cdk/aws-rds:lowercaseDbIdentifier";
    FeatureFlag["APIGATEWAY_USAGE_PLAN_KEY_ORDER_INSENSITIVE_ID"] = "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId";
    FeatureFlag["LAMBDA_RECOGNIZE_VERSION_PROPS"] = "@aws-cdk/aws-lambda:recognizeVersionProps";
    FeatureFlag["CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021"] = "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021";
    FeatureFlag["CORE_TARGET_PARTITIONS"] = "@aws-cdk/core:target-partitions";
    FeatureFlag["ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER"] = "@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver";
    FeatureFlag["EC2_UNIQUE_IMDSV2_TEMPLATE_NAME"] = "@aws-cdk/aws-ec2:uniqueImdsv2TemplateName";
    FeatureFlag["IAM_MINIMIZE_POLICIES"] = "@aws-cdk/aws-iam:minimizePolicies";
    FeatureFlag["CORE_CHECK_SECRET_USAGE"] = "@aws-cdk/core:checkSecretUsage";
    FeatureFlag["LAMBDA_RECOGNIZE_LAYER_VERSION"] = "@aws-cdk/aws-lambda:recognizeLayerVersion";
    FeatureFlag["CORE_VALIDATE_SNAPSHOT_REMOVAL_POLICY"] = "@aws-cdk/core:validateSnapshotRemovalPolicy";
    FeatureFlag["CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME"] = "@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName";
    FeatureFlag["S3_CREATE_DEFAULT_LOGGING_POLICY"] = "@aws-cdk/aws-s3:createDefaultLoggingPolicy";
    FeatureFlag["SNS_SUBSCRIPTIONS_RESTRICT_SQS_DECRYPTION"] = "@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption";
    FeatureFlag["ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME"] = "@aws-cdk/aws-ecs:arnFormatIncludesClusterName";
    FeatureFlag["APIGATEWAY_DISABLE_CLOUD_WATCH_ROLE"] = "@aws-cdk/aws-apigateway:disableCloudWatchRole";
    FeatureFlag["CORE_ENABLE_PARTITION_LITERALS"] = "@aws-cdk/core:enablePartitionLiterals";
    FeatureFlag["ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER"] = "@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker";
    FeatureFlag["EVENTS_EVENTS_TARGET_QUEUE_SAME_ACCOUNT"] = "@aws-cdk/aws-events:eventsTargetQueueSameAccount";
    FeatureFlag["IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME"] = "@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName";
    FeatureFlag["S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY"] = "@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy";
    FeatureFlag["CUSTOMRESOURCES_INSTALL_LATEST_AWS_SDK_DEFAULT"] = "@aws-cdk/customresources:installLatestAwsSdkDefault";
    FeatureFlag["ROUTE53_PATTERNS_USE_CERTIFICATE"] = "@aws-cdk/aws-route53-patterns:useCertificate";
    FeatureFlag["CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP"] = "@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup";
    FeatureFlag["RDS_DATABASE_PROXY_UNIQUE_RESOURCE_NAME"] = "@aws-cdk/aws-rds:databaseProxyUniqueResourceName";
    FeatureFlag["APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID"] = "@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId";
    FeatureFlag["EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA"] = "@aws-cdk/aws-ec2:launchTemplateDefaultUserData";
    FeatureFlag["SECRETSMANAGER_USE_ATTACHED_SECRET_RESOURCE_POLICY_FOR_SECRET_TARGET_ATTACHMENTS"] = "@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments";
    FeatureFlag["REDSHIFT_COLUMN_ID"] = "@aws-cdk/aws-redshift:columnId";
    FeatureFlag["STEPFUNCTIONS_TASKS_ENABLE_EMR_SERVICE_POLICY_V2"] = "@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2";
    FeatureFlag["APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID"] = "@aws-cdk/aws-apigateway:requestValidatorUniqueId";
    FeatureFlag["EC2_RESTRICT_DEFAULT_SECURITY_GROUP"] = "@aws-cdk/aws-ec2:restrictDefaultSecurityGroup";
    FeatureFlag["KMS_ALIAS_NAME_REF"] = "@aws-cdk/aws-kms:aliasNameRef";
    FeatureFlag["CORE_INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION"] = "@aws-cdk/core:includePrefixInUniqueNameGeneration";
    FeatureFlag["AUTOSCALING_GENERATE_LAUNCH_TEMPLATE_INSTEAD_OF_LAUNCH_CONFIG"] = "@aws-cdk/aws-autoscaling:generateLaunchTemplateInsteadOfLaunchConfig";
    FeatureFlag["OPENSEARCHSERVICE_ENABLE_OPENSEARCH_MULTI_AZ_WITH_STANDBY"] = "@aws-cdk/aws-opensearchservice:enableOpensearchMultiAzWithStandby";
    FeatureFlag["EFS_DENY_ANONYMOUS_ACCESS"] = "@aws-cdk/aws-efs:denyAnonymousAccess";
    FeatureFlag["EFS_MOUNT_TARGET_ORDER_INSENSITIVE_LOGICAL_ID"] = "@aws-cdk/aws-efs:mountTargetOrderInsensitiveLogicalId";
    FeatureFlag["LAMBDA_NODEJS_USE_LATEST_RUNTIME_VERSION"] = "@aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion";
    FeatureFlag["APPSYNC_USE_ARN_FOR_SOURCE_API_ASSOCIATION_IDENTIFIER"] = "@aws-cdk/aws-appsync:useArnForSourceApiAssociationIdentifier";
    FeatureFlag["RDS_AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS"] = "@aws-cdk/aws-rds:auroraClusterChangeScopeOfInstanceParameterGroupWithEachParameters";
    FeatureFlag["RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS"] = "@aws-cdk/aws-rds:preventRenderingDeprecatedCredentials";
    FeatureFlag["CODEPIPELINE_ACTIONS_USE_NEW_DEFAULT_BRANCH_FOR_CODE_COMMIT_SOURCE"] = "@aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource";
    FeatureFlag["CLOUDWATCH_ACTIONS_CHANGE_LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION"] = "@aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction";
    FeatureFlag["CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE"] = "@aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse";
    FeatureFlag["CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2"] = "@aws-cdk/aws-codepipeline:defaultPipelineTypeToV2";
    FeatureFlag["KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE"] = "@aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope";
    FeatureFlag["EKS_NODEGROUP_NAME_ATTRIBUTE"] = "@aws-cdk/aws-eks:nodegroupNameAttribute";
    FeatureFlag["EC2_EBS_DEFAULT_GP3_VOLUME"] = "@aws-cdk/aws-ec2:ebsDefaultGp3Volume";
    FeatureFlag["PIPELINES_REDUCE_ASSET_ROLE_TRUST_SCOPE"] = "@aws-cdk/pipelines:reduceAssetRoleTrustScope";
    FeatureFlag["ECS_REMOVE_DEFAULT_DEPLOYMENT_ALARM"] = "@aws-cdk/aws-ecs:removeDefaultDeploymentAlarm";
    FeatureFlag["CUSTOM_RESOURCES_LOG_API_RESPONSE_DATA_PROPERTY_TRUE_DEFAULT"] = "@aws-cdk/custom-resources:logApiResponseDataPropertyTrueDefault";
    FeatureFlag["S3_KEEP_NOTIFICATION_IN_IMPORTED_BUCKET"] = "@aws-cdk/aws-s3:keepNotificationInImportedBucket";
    FeatureFlag["STEPFUNCTIONS_TASKS_USE_NEW_S3_URI_PARAMETERS_FOR_BEDROCK_INVOKE_MODEL_TASK"] = "@aws-cdk/aws-stepfunctions-tasks:useNewS3UriParametersForBedrockInvokeModelTask";
    FeatureFlag["ECS_REDUCE_EC2_FARGATE_CLOUD_WATCH_PERMISSIONS"] = "@aws-cdk/aws-ecs:reduceEc2FargateCloudWatchPermissions";
    FeatureFlag["EC2_EC2_SUM_TIMEOUT_ENABLED"] = "@aws-cdk/aws-ec2:ec2SumTimeoutEnabled";
    FeatureFlag["APPSYNC_APP_SYNC_GRAPHQL_API_SCOPE_LAMBDA_PERMISSION"] = "@aws-cdk/aws-appsync:appSyncGraphQLAPIScopeLambdaPermission";
    FeatureFlag["LAMBDA_NODEJS_SDK_V3_EXCLUDE_SMITHY_PACKAGES"] = "@aws-cdk/aws-lambda-nodejs:sdkV3ExcludeSmithyPackages";
    FeatureFlag["RDS_SET_CORRECT_VALUE_FOR_DATABASE_INSTANCE_READ_REPLICA_INSTANCE_RESOURCE_ID"] = "@aws-cdk/aws-rds:setCorrectValueForDatabaseInstanceReadReplicaInstanceResourceId";
    FeatureFlag["CORE_CFN_INCLUDE_REJECT_COMPLEX_RESOURCE_UPDATE_CREATE_POLICY_INTRINSICS"] = "@aws-cdk/core:cfnIncludeRejectComplexResourceUpdateCreatePolicyIntrinsics";
    FeatureFlag["STEPFUNCTIONS_TASKS_FIX_RUN_ECS_TASK_POLICY"] = "@aws-cdk/aws-stepfunctions-tasks:fixRunEcsTaskPolicy";
    FeatureFlag["DYNAMODB_RESOURCE_POLICY_PER_REPLICA"] = "@aws-cdk/aws-dynamodb:resourcePolicyPerReplica";
    FeatureFlag["EC2_BASTION_HOST_USE_AMAZON_LINUX_2023_BY_DEFAULT"] = "@aws-cdk/aws-ec2:bastionHostUseAmazonLinux2023ByDefault";
    FeatureFlag["CORE_ASPECT_STABILIZATION"] = "@aws-cdk/core:aspectStabilization";
    FeatureFlag["ROUTE53_TARGETS_USER_POOL_DOMAIN_NAME_METHOD_WITHOUT_CUSTOM_RESOURCE"] = "@aws-cdk/aws-route53-targets:userPoolDomainNameMethodWithoutCustomResource";
    FeatureFlag["ECS_DISABLE_ECS_IMDS_BLOCKING"] = "@aws-cdk/aws-ecs:disableEcsImdsBlocking";
    FeatureFlag["ECS_ENABLE_IMDS_BLOCKING_DEPRECATED_FEATURE"] = "@aws-cdk/aws-ecs:enableImdsBlockingDeprecatedFeature";
    FeatureFlag["ELASTICLOADBALANCINGV2_ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT"] = "@aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault";
    FeatureFlag["IAM_OIDC_REJECT_UNAUTHORIZED_CONNECTIONS"] = "@aws-cdk/aws-iam:oidcRejectUnauthorizedConnections";
    FeatureFlag["CORE_ENABLE_ADDITIONAL_METADATA_COLLECTION"] = "@aws-cdk/core:enableAdditionalMetadataCollection";
    FeatureFlag["LAMBDA_CREATE_NEW_POLICIES_WITH_ADD_TO_ROLE_POLICY"] = "@aws-cdk/aws-lambda:createNewPoliciesWithAddToRolePolicy";
    FeatureFlag["S3_SET_UNIQUE_REPLICATION_ROLE_NAME"] = "@aws-cdk/aws-s3:setUniqueReplicationRoleName";
    FeatureFlag["PIPELINES_REDUCE_STAGE_ROLE_TRUST_SCOPE"] = "@aws-cdk/pipelines:reduceStageRoleTrustScope";
    FeatureFlag["EVENTS_REQUIRE_EVENT_BUS_POLICY_SID"] = "@aws-cdk/aws-events:requireEventBusPolicySid";
    FeatureFlag["DYNAMODB_RETAIN_TABLE_REPLICA"] = "@aws-cdk/aws-dynamodb:retainTableReplica";
    FeatureFlag["COGNITO_LOG_USER_POOL_CLIENT_SECRET_VALUE"] = "@aws-cdk/cognito:logUserPoolClientSecretValue";
    FeatureFlag["STEPFUNCTIONS_USE_DISTRIBUTED_MAP_RESULT_WRITER_V2"] = "@aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2";
    FeatureFlag["PIPELINES_REDUCE_CROSS_ACCOUNT_ACTION_ROLE_TRUST_SCOPE"] = "@aws-cdk/pipelines:reduceCrossAccountActionRoleTrustScope";
    FeatureFlag["CORE_ASPECT_PRIORITIES_MUTATING"] = "@aws-cdk/core:aspectPrioritiesMutating";
    FeatureFlag["S3_NOTIFICATIONS_ADD_S3_TRUST_KEY_POLICY_FOR_SNS_SUBSCRIPTIONS"] = "@aws-cdk/s3-notifications:addS3TrustKeyPolicyForSnsSubscriptions";
    FeatureFlag["EC2_ALPHA_USE_RESOURCE_ID_FOR_VPC_V2_MIGRATION"] = "@aws-cdk/aws-ec2-alpha:useResourceIdForVpcV2Migration";
    FeatureFlag["EC2_REQUIRE_PRIVATE_SUBNETS_FOR_EGRESS_ONLY_INTERNET_GATEWAY"] = "@aws-cdk/aws-ec2:requirePrivateSubnetsForEgressOnlyInternetGateway";
    FeatureFlag["S3_PUBLIC_ACCESS_BLOCKED_BY_DEFAULT"] = "@aws-cdk/aws-s3:publicAccessBlockedByDefault";
    FeatureFlag["LAMBDA_USE_CDK_MANAGED_LOG_GROUP"] = "@aws-cdk/aws-lambda:useCdkManagedLogGroup";
    FeatureFlag["KMS_APPLY_IMPORTED_ALIAS_PERMISSIONS_TO_PRINCIPAL"] = "@aws-cdk/aws-kms:applyImportedAliasPermissionsToPrincipal";
    FeatureFlag["CORE_EXPLICIT_STACK_TAGS"] = "@aws-cdk/core:explicitStackTags";
})(FeatureFlag || (exports.FeatureFlag = FeatureFlag = {}));
//# sourceMappingURL=data:application/json;base64,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