"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.YARGS_HELPERS = void 0;
exports.makeConfig = makeConfig;
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
// eslint-disable-next-line import/no-extraneous-dependencies
const user_input_gen_1 = require("@aws-cdk/user-input-gen");
const cdk_from_cfn = require("cdk-from-cfn");
const deploy_1 = require("../commands/deploy");
const init_1 = require("../commands/init");
const package_manager_1 = require("../commands/init/package-manager");
const language_1 = require("../commands/language");
exports.YARGS_HELPERS = new user_input_gen_1.CliHelpers('./util/yargs-helpers');
/**
 * Source of truth for all CDK CLI commands. `user-input-gen` translates this into:
 *
 * - the `yargs` definition in `lib/parse-command-line-arguments.ts`.
 * - the `UserInput` type in `lib/user-input.ts`.
 * - the `convertXxxToUserInput` functions in `lib/convert-to-user-input.ts`.
 */
async function makeConfig() {
    return {
        globalOptions: {
            'app': { type: 'string', alias: 'a', desc: 'REQUIRED WHEN RUNNING APP: command-line for executing your app or a cloud assembly directory (e.g. "node bin/my-app.js"). Can also be specified in cdk.json or ~/.cdk.json', requiresArg: true },
            'build': { type: 'string', desc: 'Command-line for a pre-synth build' },
            'context': { type: 'array', alias: 'c', desc: 'Add contextual string parameter (KEY=VALUE)' },
            'plugin': { type: 'array', alias: 'p', desc: 'Name or path of a node package that extend the CDK features. Can be specified multiple times' },
            'trace': { type: 'boolean', desc: 'Print trace for stack warnings' },
            'strict': { type: 'boolean', desc: 'Do not construct stacks with warnings' },
            'lookups': { type: 'boolean', desc: 'Perform context lookups (synthesis fails if this is disabled and context lookups need to be performed)', default: true },
            'ignore-errors': { type: 'boolean', default: false, desc: 'Ignores synthesis errors, which will likely produce an invalid output' },
            'json': { type: 'boolean', alias: 'j', desc: 'Use JSON output instead of YAML when templates are printed to STDOUT', default: false },
            'verbose': { type: 'boolean', alias: 'v', desc: 'Show debug logs (specify multiple times to increase verbosity)', default: false, count: true },
            'debug': { type: 'boolean', desc: 'Debug the CDK app. Log additional information during synthesis, such as creation stack traces of tokens (sets CDK_DEBUG, will slow down synthesis)', default: false },
            'profile': { type: 'string', desc: 'Use the indicated AWS profile as the default environment', requiresArg: true },
            'proxy': { type: 'string', desc: 'Use the indicated proxy. Will read from HTTPS_PROXY environment variable if not specified', requiresArg: true },
            'ca-bundle-path': { type: 'string', desc: 'Path to CA certificate to use when validating HTTPS requests. Will read from AWS_CA_BUNDLE environment variable if not specified', requiresArg: true },
            'ec2creds': { type: 'boolean', alias: 'i', default: undefined, desc: 'Force trying to fetch EC2 instance credentials. Default: guess EC2 instance status' },
            'version-reporting': { type: 'boolean', desc: 'Disable CLI telemetry and do not include the "AWS::CDK::Metadata" resource in synthesized templates (enabled by default)', default: undefined, alias: 'telemetry' },
            'path-metadata': { type: 'boolean', desc: 'Include "aws:cdk:path" CloudFormation metadata for each resource (enabled by default)', default: undefined },
            'asset-metadata': { type: 'boolean', desc: 'Include "aws:asset:*" CloudFormation metadata for resources that uses assets (enabled by default)', default: undefined },
            'role-arn': { type: 'string', alias: 'r', desc: 'ARN of Role to use when invoking CloudFormation', default: undefined, requiresArg: true },
            'staging': { type: 'boolean', desc: 'Copy assets to the output directory (use --no-staging to disable the copy of assets which allows local debugging via the SAM CLI to reference the original source files)', default: true },
            'output': { type: 'string', alias: 'o', desc: 'Emits the synthesized cloud assembly into a directory (default: cdk.out)', requiresArg: true },
            'notices': { type: 'boolean', desc: 'Show relevant notices' },
            'no-color': { type: 'boolean', desc: 'Removes colors and other style from console output', default: false },
            'color': { type: 'boolean', desc: 'Force colored output even when stdout is not a TTY', default: undefined },
            'ci': { type: 'boolean', desc: 'Force CI detection. If CI=true then logs will be sent to stdout instead of stderr', default: exports.YARGS_HELPERS.isCI() },
            'unstable': { type: 'array', desc: 'Opt in to unstable features. The flag indicates that the scope and API of a feature might still change. Otherwise the feature is generally production ready and fully supported. Can be specified multiple times.', default: [] },
            'telemetry-file': { type: 'string', desc: 'Send telemetry data to a local file.', default: undefined },
            'yes': { type: 'boolean', alias: 'y', desc: 'Automatically answer interactive prompts with the recommended response. This includes confirming actions.', default: false },
        },
        commands: {
            'list': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['ls'],
                description: 'Lists all stacks in the app',
                options: {
                    'long': { type: 'boolean', default: false, alias: 'l', desc: 'Display environment information for each stack' },
                    'show-dependencies': { type: 'boolean', default: false, alias: 'd', desc: 'Display stack dependency information for each stack' },
                },
            },
            'synth': {
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                aliases: ['synthesize'],
                description: 'Synthesizes and prints the CloudFormation template for this stack',
                options: {
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only synthesize requested stacks, don\'t include dependencies' },
                    validation: { type: 'boolean', desc: 'After synthesis, validate stacks with the "validateOnSynth" attribute set (can also be controlled with CDK_VALIDATION)', default: true },
                    quiet: { type: 'boolean', alias: 'q', desc: 'Do not output CloudFormation Template to stdout', default: false },
                },
            },
            'bootstrap': {
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                description: 'Deploys the CDK toolkit stack into an AWS environment',
                options: {
                    'bootstrap-bucket-name': { type: 'string', alias: ['b', 'toolkit-bucket-name'], desc: 'The name of the CDK toolkit bucket; bucket will be created and must not exist', default: undefined },
                    'bootstrap-kms-key-id': { type: 'string', desc: 'AWS KMS master key ID used for the SSE-KMS encryption (specify AWS_MANAGED_KEY to use an AWS-managed key)', default: undefined, conflicts: 'bootstrap-customer-key' },
                    'example-permissions-boundary': { type: 'boolean', alias: 'epb', desc: 'Use the example permissions boundary.', default: undefined, conflicts: 'custom-permissions-boundary' },
                    'custom-permissions-boundary': { type: 'string', alias: 'cpb', desc: 'Use the permissions boundary specified by name.', default: undefined, conflicts: 'example-permissions-boundary' },
                    'bootstrap-customer-key': { type: 'boolean', desc: 'Create a Customer Master Key (CMK) for the bootstrap bucket (you will be charged but can customize permissions, modern bootstrapping only)', default: undefined, conflicts: 'bootstrap-kms-key-id' },
                    'qualifier': { type: 'string', desc: 'String which must be unique for each bootstrap stack. You must configure it on your CDK app if you change this from the default.', default: undefined },
                    'public-access-block-configuration': { type: 'boolean', desc: 'Block public access configuration on CDK toolkit bucket (enabled by default) ', default: undefined },
                    'deny-external-id': { type: 'boolean', desc: 'Block AssumeRole access to all boostrapped roles if an ExternalId is provided (enabled by default) ', default: undefined },
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add for the stack (KEY=VALUE)', default: [] },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'trust': { type: 'array', desc: 'The AWS account IDs that should be trusted to perform deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'trust-for-lookup': { type: 'array', desc: 'The AWS account IDs that should be trusted to look up values in this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'untrust': { type: 'array', desc: 'The AWS account IDs that should not be trusted by this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'cloudformation-execution-policies': { type: 'array', desc: 'The Managed Policy ARNs that should be attached to the role performing deployments into this environment (may be repeated, modern bootstrapping only)', default: [] },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always bootstrap even if it would downgrade template version', default: false },
                    'termination-protection': { type: 'boolean', default: undefined, desc: 'Toggle CloudFormation termination protection on the bootstrap stacks' },
                    'show-template': { type: 'boolean', desc: 'Instead of actual bootstrapping, print the current CLI\'s bootstrapping template to stdout for customization', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'template': { type: 'string', requiresArg: true, desc: 'Use the template from the given file instead of the built-in one (use --show-template to obtain an example)' },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                },
            },
            'gc': {
                description: 'Garbage collect assets. Options detailed here: https://github.com/aws/aws-cdk-cli/tree/main/packages/aws-cdk#cdk-gc',
                arg: {
                    name: 'ENVIRONMENTS',
                    variadic: true,
                },
                options: {
                    'action': { type: 'string', desc: 'The action (or sub-action) you want to perform. Valid entires are "print", "tag", "delete-tagged", "full".', default: 'full' },
                    'type': { type: 'string', desc: 'Specify either ecr, s3, or all', default: 'all' },
                    'rollback-buffer-days': { type: 'number', desc: 'Delete assets that have been marked as isolated for this many days', default: 0 },
                    'created-buffer-days': { type: 'number', desc: 'Never delete assets younger than this (in days)', default: 1 },
                    'confirm': { type: 'boolean', desc: 'Confirm via manual prompt before deletion', default: true },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit"', requiresArg: true, conflicts: 'bootstrap-stack-name' },
                    'bootstrap-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit" (deprecated, use --toolkit-stack-name)', deprecated: 'use --toolkit-stack-name', requiresArg: true, conflicts: 'toolkit-stack-name' }, // TODO: remove when garbage collection is GA
                },
            },
            'flags': {
                description: 'View and toggle feature flags.',
                arg: {
                    name: 'FLAGNAME',
                    variadic: true,
                },
                options: {
                    value: { type: 'string', desc: 'The value the user would like to set the feature flag configuration to', requiresArg: true },
                    set: { type: 'boolean', desc: 'Signifies the user would like to modify their feature flag configuration', requiresArg: false },
                    all: { type: 'boolean', desc: 'Modify or view all feature flags', requiresArg: false },
                    unconfigured: { type: 'boolean', desc: 'Modify unconfigured feature flags', requiresArg: false },
                    recommended: { type: 'boolean', desc: 'Change flags to recommended states', requiresArg: false },
                    default: { type: 'boolean', desc: 'Change flags to default state', requiresArg: false },
                    interactive: { type: 'boolean', alias: ['i'], desc: 'Interactive option for the flags command' },
                    safe: { type: 'boolean', desc: 'Enable all feature flags that do not impact the user\'s application', requiresArg: false },
                    concurrency: { type: 'number', alias: ['n'], desc: 'Maximum number of simultaneous synths to execute.', default: 4, requiresArg: true },
                },
            },
            'deploy': {
                description: 'Deploys the stack(s) named STACKS into your AWS account',
                options: {
                    'all': { type: 'boolean', desc: 'Deploy all available stacks', default: false },
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'require-approval': { type: 'string', choices: [cloud_assembly_schema_1.RequireApproval.NEVER, cloud_assembly_schema_1.RequireApproval.ANYCHANGE, cloud_assembly_schema_1.RequireApproval.BROADENING], desc: 'What security-sensitive changes need manual approval' },
                    'notification-arns': { type: 'array', desc: 'ARNs of SNS topics that CloudFormation will notify with stack related events. These will be added to ARNs specified with the \'notificationArns\' stack property.' },
                    // @deprecated(v2) -- tags are part of the Cloud Assembly and tags specified here will be overwritten on the next deployment
                    'tags': { type: 'array', alias: 't', desc: 'Tags to add to the stack (KEY=VALUE), overrides tags from Cloud Assembly (deprecated)' },
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet) (deprecated)', deprecated: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create (only if method is not direct)' },
                    'method': {
                        alias: 'm',
                        type: 'string',
                        choices: ['direct', 'change-set', 'prepare-change-set'],
                        requiresArg: true,
                        desc: 'How to perform the deployment. Direct is a bit faster but lacks progress information',
                    },
                    'import-existing-resources': { type: 'boolean', desc: 'Indicates if the stack set imports resources that already exist.', default: false },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'parameters': { type: 'array', desc: 'Additional parameters passed to CloudFormation at deploy time (STACK:KEY=VALUE)', default: {} },
                    'outputs-file': { type: 'string', alias: 'O', desc: 'Path to file where stack outputs will be written as JSON', requiresArg: true },
                    'previous-parameters': { type: 'boolean', default: true, desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            'Do not use this in production environments',
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible. ' +
                            'Do not use this in production environments',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'number',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'number',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'number',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'watch': {
                        type: 'boolean',
                        desc: 'Continuously observe the project files, ' +
                            'and deploy the given stack(s) automatically when changes are detected. ' +
                            'Implies --hotswap by default',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off. " +
                            "Only in effect if specified alongside the '--watch' option",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                    'asset-parallelism': { type: 'boolean', desc: 'Whether to build/publish assets in parallel' },
                    'asset-prebuild': { type: 'boolean', desc: 'Whether to build all assets before deploying the first stack (useful for failing Docker builds)', default: true },
                    'ignore-no-stacks': { type: 'boolean', desc: 'Whether to deploy if the app contains no stacks', default: false },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'rollback': {
                description: 'Rolls back the stack(s) named STACKS to their last stable state',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'all': { type: 'boolean', default: false, desc: 'Roll back all available stacks' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack the environment is bootstrapped with', requiresArg: true },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Orphan all resources for which the rollback operation fails.',
                    },
                    'validate-bootstrap-version': {
                        type: 'boolean',
                        desc: 'Whether to validate the bootstrap stack version. Defaults to \'true\', disable with --no-validate-bootstrap-version.',
                    },
                    'orphan': {
                        // alias: 'o' conflicts with --output
                        type: 'array',
                        desc: 'Orphan the given resources, identified by their logical ID (can be specified multiple times)',
                        default: [],
                    },
                },
            },
            'import': {
                description: 'Import existing resource(s) into the given STACK',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
                options: {
                    'execute': { type: 'boolean', desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)', default: true },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the CDK toolkit stack to create', requiresArg: true },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                    },
                    'force': {
                        alias: 'f',
                        type: 'boolean',
                        desc: 'Do not abort if the template diff includes updates or deletes. This is probably safe but we\'re not sure, let us know how it goes.',
                    },
                    'record-resource-mapping': {
                        type: 'string',
                        alias: 'r',
                        requiresArg: true,
                        desc: 'If specified, CDK will generate a mapping of existing physical resources to CDK resources to be imported as. The mapping ' +
                            'will be written in the given file path. No actual import operation will be performed',
                    },
                    'resource-mapping': {
                        type: 'string',
                        alias: 'm',
                        requiresArg: true,
                        desc: 'If specified, CDK will use the given file to map physical resources to CDK resources for import, instead of interactively ' +
                            'asking the user. Can be run from scripts',
                    },
                },
            },
            'watch': {
                description: "Shortcut for 'deploy --watch'",
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'build-exclude': { type: 'array', alias: 'E', desc: 'Do not rebuild asset with the given ID. Can be specified multiple times', default: [] },
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only deploy requested stacks, don\'t include dependencies' },
                    'change-set-name': { type: 'string', desc: 'Name of the CloudFormation change set to create' },
                    'force': { alias: 'f', type: 'boolean', desc: 'Always deploy stack even if templates are identical', default: false },
                    'toolkit-stack-name': { type: 'string', desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)', requiresArg: true },
                    'progress': { type: 'string', choices: [deploy_1.StackActivityProgress.BAR, deploy_1.StackActivityProgress.EVENTS], desc: 'Display mode for stack activity events' },
                    'rollback': {
                        type: 'boolean',
                        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. " +
                            'Note: do **not** disable this flag for deployments with resource replacements, as that will always fail',
                        negativeAlias: 'R',
                    },
                    'hotswap': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'but does not fall back to a full deployment if that is not possible. ' +
                            'Instead, changes to any non-hotswappable properties are ignored.' +
                            "'true' by default, use --no-hotswap to turn off",
                    },
                    'hotswap-fallback': {
                        type: 'boolean',
                        desc: "Attempts to perform a 'hotswap' deployment, " +
                            'which skips CloudFormation and updates the resources directly, ' +
                            'and falls back to a full deployment if that is not possible.',
                    },
                    'hotswap-ecs-minimum-healthy-percent': {
                        type: 'number',
                        desc: 'Lower limit on the number of your service\'s tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-maximum-healthy-percent': {
                        type: 'number',
                        desc: 'Upper limit on the number of your service\'s tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount',
                    },
                    'hotswap-ecs-stabilization-timeout-seconds': {
                        type: 'number',
                        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
                    },
                    'logs': {
                        type: 'boolean',
                        default: true,
                        desc: 'Show CloudWatch log events from all resources in the selected Stacks in the terminal. ' +
                            "'true' by default, use --no-logs to turn off",
                    },
                    'concurrency': { type: 'number', desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.', default: 1, requiresArg: true },
                },
            },
            'destroy': {
                description: 'Destroy the stack(s) named STACKS',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    all: { type: 'boolean', default: false, desc: 'Destroy all available stacks' },
                    exclusively: { type: 'boolean', alias: 'e', desc: 'Only destroy requested stacks, don\'t include dependees' },
                    force: { type: 'boolean', alias: 'f', desc: 'Do not ask for confirmation before destroying the stacks' },
                },
            },
            'diff': {
                description: 'Compares the specified stack with the deployed stack or a local template file, and returns with status 1 if any difference is found',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    'exclusively': { type: 'boolean', alias: 'e', desc: 'Only diff requested stacks, don\'t include dependencies' },
                    'context-lines': { type: 'number', desc: 'Number of context lines to include in arbitrary JSON diff rendering', default: 3, requiresArg: true },
                    'template': { type: 'string', desc: 'The path to the CloudFormation template to compare with', requiresArg: true },
                    'strict': { type: 'boolean', desc: 'Do not filter out AWS::CDK::Metadata resources, mangled non-ASCII characters, or the CheckBootstrapVersionRule', default: false },
                    'security-only': { type: 'boolean', desc: 'Only diff for broadened security changes', default: false },
                    'fail': { type: 'boolean', desc: 'Fail with exit code 1 in case of diff' },
                    'processed': { type: 'boolean', desc: 'Whether to compare against the template with Transforms already processed', default: false },
                    'quiet': { type: 'boolean', alias: 'q', desc: 'Do not print stack name and default message when there is no diff to stdout', default: false },
                    'change-set': { type: 'boolean', alias: 'changeset', desc: 'Whether to create a changeset to analyze resource replacements. In this mode, diff will use the deploy role instead of the lookup role.', default: true },
                    'import-existing-resources': { type: 'boolean', desc: 'Whether or not the change set imports resources that already exist', default: false },
                    'include-moves': { type: 'boolean', desc: 'Whether to include moves in the diff', default: false },
                },
            },
            'drift': {
                description: 'Detect drifts in the given CloudFormation stack(s)',
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
                options: {
                    fail: { type: 'boolean', desc: 'Fail with exit code 1 if drift is detected' },
                },
            },
            'metadata': {
                description: 'Returns all metadata associated with this stack',
                arg: {
                    name: 'STACK',
                    variadic: false,
                },
            },
            'acknowledge': {
                aliases: ['ack'],
                description: 'Acknowledge a notice so that it does not show up anymore',
                arg: {
                    name: 'ID',
                    variadic: false,
                },
            },
            'notices': {
                description: 'Returns a list of relevant notices',
                options: {
                    unacknowledged: { type: 'boolean', alias: 'u', default: false, desc: 'Returns a list of unacknowledged notices' },
                },
            },
            'init': {
                description: 'Create a new, empty CDK project from a template.',
                arg: {
                    name: 'TEMPLATE',
                    variadic: false,
                },
                options: {
                    'language': { type: 'string', alias: 'l', desc: 'The language to be used for the new project (default can be configured in ~/.cdk.json)', choices: await (0, init_1.availableInitLanguages)() },
                    'list': { type: 'boolean', desc: 'List the available templates' },
                    'generate-only': { type: 'boolean', default: false, desc: 'If true, only generates project files, without executing additional operations such as setting up a git repo, installing dependencies or compiling the project' },
                    'lib-version': { type: 'string', alias: 'V', default: undefined, desc: 'The version of the CDK library (aws-cdk-lib) to initialize built-in templates with. Defaults to the version that was current when this CLI was built.' },
                    'from-path': { type: 'string', desc: 'Path to a local custom template directory or multi-template repository', requiresArg: true, conflicts: ['lib-version'] },
                    'template-path': { type: 'string', desc: 'Path to a specific template within a multi-template repository', requiresArg: true },
                    'package-manager': { type: 'string', desc: 'The package manager to use to install dependencies. Only applicable for TypeScript and JavaScript projects. Defaults to npm in TypeScript and JavaScript projects.', choices: package_manager_1.JS_PACKAGE_MANAGERS.map(({ name }) => name) },
                    'project-name': { type: 'string', alias: 'n', desc: 'The name of the new project', requiresArg: true },
                },
                implies: { 'template-path': 'from-path' },
            },
            'migrate': {
                description: 'Migrate existing AWS resources into a CDK app',
                options: {
                    'stack-name': { type: 'string', alias: 'n', desc: 'The name assigned to the stack created in the new project. The name of the app will be based off this name as well.', requiresArg: true },
                    'language': {
                        type: 'string',
                        default: 'typescript',
                        alias: 'l',
                        desc: 'The language to be used for the new project',
                        choices: [...new Set(cdk_from_cfn.supported_languages().flatMap((lang) => [lang, (0, language_1.getLanguageAlias)(lang)]))],
                    },
                    'account': { type: 'string', desc: 'The account to retrieve the CloudFormation stack template from' },
                    'region': { type: 'string', desc: 'The region to retrieve the CloudFormation stack template from' },
                    'from-path': { type: 'string', desc: 'The path to the CloudFormation template to migrate. Use this for locally stored templates' },
                    'from-stack': { type: 'boolean', desc: 'Use this flag to retrieve the template for an existing CloudFormation stack' },
                    'output-path': { type: 'string', desc: 'The output path for the migrated CDK app' },
                    'from-scan': {
                        type: 'string',
                        desc: 'Determines if a new scan should be created, or the last successful existing scan should be used ' +
                            '\n options are "new" or "most-recent"',
                    },
                    'filter': {
                        type: 'array',
                        desc: 'Filters the resource scan based on the provided criteria in the following format: "key1=value1,key2=value2"' +
                            '\n This field can be passed multiple times for OR style filtering: ' +
                            '\n filtering options: ' +
                            '\n resource-identifier: A key-value pair that identifies the target resource. i.e. {"ClusterName", "myCluster"}' +
                            '\n resource-type-prefix: A string that represents a type-name prefix. i.e. "AWS::DynamoDB::"' +
                            '\n tag-key: a string that matches resources with at least one tag with the provided key. i.e. "myTagKey"' +
                            '\n tag-value: a string that matches resources with at least one tag with the provided value. i.e. "myTagValue"',
                    },
                    'compress': { type: 'boolean', desc: 'Use this flag to zip the generated CDK app' },
                },
            },
            'context': {
                description: 'Manage cached context values',
                options: {
                    reset: { alias: 'e', desc: 'The context key (or its index) to reset', type: 'string', requiresArg: true, default: undefined },
                    force: { alias: 'f', desc: 'Ignore missing key error', type: 'boolean', default: false },
                    clear: { desc: 'Clear all context', type: 'boolean', default: false },
                },
            },
            'docs': {
                aliases: ['doc'],
                description: 'Opens the reference documentation in a browser',
                options: {
                    browser: {
                        alias: 'b',
                        desc: 'the command to use to open the browser, using %u as a placeholder for the path of the file to open',
                        type: 'string',
                        default: exports.YARGS_HELPERS.browserForPlatform(),
                    },
                },
            },
            'doctor': {
                description: 'Check your set-up for potential problems',
            },
            'refactor': {
                description: 'Moves resources between stacks or within the same stack',
                options: {
                    'additional-stack-name': {
                        type: 'array',
                        requiresArg: true,
                        desc: 'Names of deployed stacks to be considered for resource comparison.',
                    },
                    'dry-run': {
                        type: 'boolean',
                        desc: 'Do not perform any changes, just show what would be done',
                        default: false,
                    },
                    'override-file': {
                        type: 'string',
                        requiresArg: true,
                        desc: 'A file that declares overrides to be applied to the list of mappings computed by the CLI.',
                    },
                    'revert': {
                        type: 'boolean',
                        default: false,
                        desc: 'If specified, the command will revert the refactor operation. This is only valid if a mapping file was provided.',
                    },
                    'force': {
                        type: 'boolean',
                        default: false,
                        desc: 'Whether to do the refactor without asking for confirmation',
                    },
                },
                arg: {
                    name: 'STACKS',
                    variadic: true,
                },
            },
            'cli-telemetry': {
                description: 'Enable or disable anonymous telemetry',
                options: {
                    enable: {
                        type: 'boolean',
                        desc: 'Enable anonymous telemetry',
                        conflicts: 'disable',
                    },
                    disable: {
                        type: 'boolean',
                        desc: 'Disable anonymous telemetry',
                        conflicts: 'enable',
                    },
                    status: {
                        type: 'boolean',
                        desc: 'Report telemetry opt-in/out status',
                        conflicts: ['enable', 'disable'],
                    },
                },
            },
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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