"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertYargsToUserInput = convertYargsToUserInput;
exports.convertConfigToUserInput = convertConfigToUserInput;
// @ts-ignore TS6133
function convertYargsToUserInput(args) {
    const globalOptions = {
        app: args.app,
        build: args.build,
        context: args.context,
        plugin: args.plugin,
        trace: args.trace,
        strict: args.strict,
        lookups: args.lookups,
        ignoreErrors: args.ignoreErrors,
        json: args.json,
        verbose: args.verbose,
        debug: args.debug,
        profile: args.profile,
        proxy: args.proxy,
        caBundlePath: args.caBundlePath,
        ec2creds: args.ec2creds,
        versionReporting: args.versionReporting,
        pathMetadata: args.pathMetadata,
        assetMetadata: args.assetMetadata,
        roleArn: args.roleArn,
        staging: args.staging,
        output: args.output,
        notices: args.notices,
        noColor: args.noColor,
        color: args.color,
        ci: args.ci,
        unstable: args.unstable,
        telemetryFile: args.telemetryFile,
        yes: args.yes,
    };
    let commandOptions;
    switch (args._[0]) {
        case 'list':
        case 'ls':
            commandOptions = {
                long: args.long,
                showDependencies: args.showDependencies,
                STACKS: args.STACKS,
            };
            break;
        case 'synth':
        case 'synthesize':
            commandOptions = {
                exclusively: args.exclusively,
                validation: args.validation,
                quiet: args.quiet,
                STACKS: args.STACKS,
            };
            break;
        case 'bootstrap':
            commandOptions = {
                bootstrapBucketName: args.bootstrapBucketName,
                bootstrapKmsKeyId: args.bootstrapKmsKeyId,
                examplePermissionsBoundary: args.examplePermissionsBoundary,
                customPermissionsBoundary: args.customPermissionsBoundary,
                bootstrapCustomerKey: args.bootstrapCustomerKey,
                qualifier: args.qualifier,
                publicAccessBlockConfiguration: args.publicAccessBlockConfiguration,
                denyExternalId: args.denyExternalId,
                tags: args.tags,
                execute: args.execute,
                trust: args.trust,
                trustForLookup: args.trustForLookup,
                untrust: args.untrust,
                cloudformationExecutionPolicies: args.cloudformationExecutionPolicies,
                force: args.force,
                terminationProtection: args.terminationProtection,
                showTemplate: args.showTemplate,
                toolkitStackName: args.toolkitStackName,
                template: args.template,
                previousParameters: args.previousParameters,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'gc':
            commandOptions = {
                action: args.action,
                type: args.type,
                rollbackBufferDays: args.rollbackBufferDays,
                createdBufferDays: args.createdBufferDays,
                confirm: args.confirm,
                toolkitStackName: args.toolkitStackName,
                bootstrapStackName: args.bootstrapStackName,
                ENVIRONMENTS: args.ENVIRONMENTS,
            };
            break;
        case 'flags':
            commandOptions = {
                value: args.value,
                set: args.set,
                all: args.all,
                unconfigured: args.unconfigured,
                recommended: args.recommended,
                default: args.default,
                interactive: args.interactive,
                safe: args.safe,
                concurrency: args.concurrency,
                FLAGNAME: args.FLAGNAME,
            };
            break;
        case 'deploy':
            commandOptions = {
                all: args.all,
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                requireApproval: args.requireApproval,
                notificationArns: args.notificationArns,
                tags: args.tags,
                execute: args.execute,
                changeSetName: args.changeSetName,
                method: args.method,
                importExistingResources: args.importExistingResources,
                force: args.force,
                parameters: args.parameters,
                outputsFile: args.outputsFile,
                previousParameters: args.previousParameters,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                watch: args.watch,
                logs: args.logs,
                concurrency: args.concurrency,
                assetParallelism: args.assetParallelism,
                assetPrebuild: args.assetPrebuild,
                ignoreNoStacks: args.ignoreNoStacks,
                STACKS: args.STACKS,
            };
            break;
        case 'rollback':
            commandOptions = {
                all: args.all,
                toolkitStackName: args.toolkitStackName,
                force: args.force,
                validateBootstrapVersion: args.validateBootstrapVersion,
                orphan: args.orphan,
                STACKS: args.STACKS,
            };
            break;
        case 'import':
            commandOptions = {
                execute: args.execute,
                changeSetName: args.changeSetName,
                toolkitStackName: args.toolkitStackName,
                rollback: args.rollback,
                force: args.force,
                recordResourceMapping: args.recordResourceMapping,
                resourceMapping: args.resourceMapping,
                STACK: args.STACK,
            };
            break;
        case 'watch':
            commandOptions = {
                buildExclude: args.buildExclude,
                exclusively: args.exclusively,
                changeSetName: args.changeSetName,
                force: args.force,
                toolkitStackName: args.toolkitStackName,
                progress: args.progress,
                rollback: args.rollback,
                hotswap: args.hotswap,
                hotswapFallback: args.hotswapFallback,
                hotswapEcsMinimumHealthyPercent: args.hotswapEcsMinimumHealthyPercent,
                hotswapEcsMaximumHealthyPercent: args.hotswapEcsMaximumHealthyPercent,
                hotswapEcsStabilizationTimeoutSeconds: args.hotswapEcsStabilizationTimeoutSeconds,
                logs: args.logs,
                concurrency: args.concurrency,
                STACKS: args.STACKS,
            };
            break;
        case 'destroy':
            commandOptions = {
                all: args.all,
                exclusively: args.exclusively,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'diff':
            commandOptions = {
                exclusively: args.exclusively,
                contextLines: args.contextLines,
                template: args.template,
                strict: args.strict,
                securityOnly: args.securityOnly,
                fail: args.fail,
                processed: args.processed,
                quiet: args.quiet,
                changeSet: args.changeSet,
                importExistingResources: args.importExistingResources,
                includeMoves: args.includeMoves,
                STACKS: args.STACKS,
            };
            break;
        case 'drift':
            commandOptions = {
                fail: args.fail,
                STACKS: args.STACKS,
            };
            break;
        case 'metadata':
            commandOptions = {
                STACK: args.STACK,
            };
            break;
        case 'acknowledge':
        case 'ack':
            commandOptions = {
                ID: args.ID,
            };
            break;
        case 'notices':
            commandOptions = {
                unacknowledged: args.unacknowledged,
            };
            break;
        case 'init':
            commandOptions = {
                language: args.language,
                list: args.list,
                generateOnly: args.generateOnly,
                libVersion: args.libVersion,
                fromPath: args.fromPath,
                templatePath: args.templatePath,
                packageManager: args.packageManager,
                projectName: args.projectName,
                TEMPLATE: args.TEMPLATE,
            };
            break;
        case 'migrate':
            commandOptions = {
                stackName: args.stackName,
                language: args.language,
                account: args.account,
                region: args.region,
                fromPath: args.fromPath,
                fromStack: args.fromStack,
                outputPath: args.outputPath,
                fromScan: args.fromScan,
                filter: args.filter,
                compress: args.compress,
            };
            break;
        case 'context':
            commandOptions = {
                reset: args.reset,
                force: args.force,
                clear: args.clear,
            };
            break;
        case 'docs':
        case 'doc':
            commandOptions = {
                browser: args.browser,
            };
            break;
        case 'doctor':
            commandOptions = {};
            break;
        case 'refactor':
            commandOptions = {
                additionalStackName: args.additionalStackName,
                dryRun: args.dryRun,
                overrideFile: args.overrideFile,
                revert: args.revert,
                force: args.force,
                STACKS: args.STACKS,
            };
            break;
        case 'cli-telemetry':
            commandOptions = {
                enable: args.enable,
                disable: args.disable,
                status: args.status,
            };
            break;
    }
    const userInput = {
        command: args._[0],
        globalOptions,
        [args._[0]]: commandOptions,
    };
    return userInput;
}
// @ts-ignore TS6133
function convertConfigToUserInput(config) {
    const globalOptions = {
        app: config.app,
        build: config.build,
        context: config.context,
        plugin: config.plugin,
        trace: config.trace,
        strict: config.strict,
        lookups: config.lookups,
        ignoreErrors: config.ignoreErrors,
        json: config.json,
        verbose: config.verbose,
        debug: config.debug,
        profile: config.profile,
        proxy: config.proxy,
        caBundlePath: config.caBundlePath,
        ec2creds: config.ec2creds,
        versionReporting: config.versionReporting,
        pathMetadata: config.pathMetadata,
        assetMetadata: config.assetMetadata,
        roleArn: config.roleArn,
        staging: config.staging,
        output: config.output,
        notices: config.notices,
        noColor: config.noColor,
        color: config.color,
        ci: config.ci,
        unstable: config.unstable,
        telemetryFile: config.telemetryFile,
        yes: config.yes,
    };
    const listOptions = {
        long: config.list?.long,
        showDependencies: config.list?.showDependencies,
    };
    const synthOptions = {
        exclusively: config.synth?.exclusively,
        validation: config.synth?.validation,
        quiet: config.synth?.quiet,
    };
    const bootstrapOptions = {
        bootstrapBucketName: config.bootstrap?.bootstrapBucketName,
        bootstrapKmsKeyId: config.bootstrap?.bootstrapKmsKeyId,
        examplePermissionsBoundary: config.bootstrap?.examplePermissionsBoundary,
        customPermissionsBoundary: config.bootstrap?.customPermissionsBoundary,
        bootstrapCustomerKey: config.bootstrap?.bootstrapCustomerKey,
        qualifier: config.bootstrap?.qualifier,
        publicAccessBlockConfiguration: config.bootstrap?.publicAccessBlockConfiguration,
        denyExternalId: config.bootstrap?.denyExternalId,
        tags: config.bootstrap?.tags,
        execute: config.bootstrap?.execute,
        trust: config.bootstrap?.trust,
        trustForLookup: config.bootstrap?.trustForLookup,
        untrust: config.bootstrap?.untrust,
        cloudformationExecutionPolicies: config.bootstrap?.cloudformationExecutionPolicies,
        force: config.bootstrap?.force,
        terminationProtection: config.bootstrap?.terminationProtection,
        showTemplate: config.bootstrap?.showTemplate,
        toolkitStackName: config.bootstrap?.toolkitStackName,
        template: config.bootstrap?.template,
        previousParameters: config.bootstrap?.previousParameters,
    };
    const gcOptions = {
        action: config.gc?.action,
        type: config.gc?.type,
        rollbackBufferDays: config.gc?.rollbackBufferDays,
        createdBufferDays: config.gc?.createdBufferDays,
        confirm: config.gc?.confirm,
        toolkitStackName: config.gc?.toolkitStackName,
        bootstrapStackName: config.gc?.bootstrapStackName,
    };
    const flagsOptions = {
        value: config.flags?.value,
        set: config.flags?.set,
        all: config.flags?.all,
        unconfigured: config.flags?.unconfigured,
        recommended: config.flags?.recommended,
        default: config.flags?.default,
        interactive: config.flags?.interactive,
        safe: config.flags?.safe,
        concurrency: config.flags?.concurrency,
    };
    const deployOptions = {
        all: config.deploy?.all,
        buildExclude: config.deploy?.buildExclude,
        exclusively: config.deploy?.exclusively,
        requireApproval: config.deploy?.requireApproval,
        notificationArns: config.deploy?.notificationArns,
        tags: config.deploy?.tags,
        execute: config.deploy?.execute,
        changeSetName: config.deploy?.changeSetName,
        method: config.deploy?.method,
        importExistingResources: config.deploy?.importExistingResources,
        force: config.deploy?.force,
        parameters: config.deploy?.parameters,
        outputsFile: config.deploy?.outputsFile,
        previousParameters: config.deploy?.previousParameters,
        toolkitStackName: config.deploy?.toolkitStackName,
        progress: config.deploy?.progress,
        rollback: config.deploy?.rollback,
        hotswap: config.deploy?.hotswap,
        hotswapFallback: config.deploy?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.deploy?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.deploy?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.deploy?.hotswapEcsStabilizationTimeoutSeconds,
        watch: config.deploy?.watch,
        logs: config.deploy?.logs,
        concurrency: config.deploy?.concurrency,
        assetParallelism: config.deploy?.assetParallelism,
        assetPrebuild: config.deploy?.assetPrebuild,
        ignoreNoStacks: config.deploy?.ignoreNoStacks,
    };
    const rollbackOptions = {
        all: config.rollback?.all,
        toolkitStackName: config.rollback?.toolkitStackName,
        force: config.rollback?.force,
        validateBootstrapVersion: config.rollback?.validateBootstrapVersion,
        orphan: config.rollback?.orphan,
    };
    const importOptions = {
        execute: config.import?.execute,
        changeSetName: config.import?.changeSetName,
        toolkitStackName: config.import?.toolkitStackName,
        rollback: config.import?.rollback,
        force: config.import?.force,
        recordResourceMapping: config.import?.recordResourceMapping,
        resourceMapping: config.import?.resourceMapping,
    };
    const watchOptions = {
        buildExclude: config.watch?.buildExclude,
        exclusively: config.watch?.exclusively,
        changeSetName: config.watch?.changeSetName,
        force: config.watch?.force,
        toolkitStackName: config.watch?.toolkitStackName,
        progress: config.watch?.progress,
        rollback: config.watch?.rollback,
        hotswap: config.watch?.hotswap,
        hotswapFallback: config.watch?.hotswapFallback,
        hotswapEcsMinimumHealthyPercent: config.watch?.hotswapEcsMinimumHealthyPercent,
        hotswapEcsMaximumHealthyPercent: config.watch?.hotswapEcsMaximumHealthyPercent,
        hotswapEcsStabilizationTimeoutSeconds: config.watch?.hotswapEcsStabilizationTimeoutSeconds,
        logs: config.watch?.logs,
        concurrency: config.watch?.concurrency,
    };
    const destroyOptions = {
        all: config.destroy?.all,
        exclusively: config.destroy?.exclusively,
        force: config.destroy?.force,
    };
    const diffOptions = {
        exclusively: config.diff?.exclusively,
        contextLines: config.diff?.contextLines,
        template: config.diff?.template,
        strict: config.diff?.strict,
        securityOnly: config.diff?.securityOnly,
        fail: config.diff?.fail,
        processed: config.diff?.processed,
        quiet: config.diff?.quiet,
        changeSet: config.diff?.changeSet,
        importExistingResources: config.diff?.importExistingResources,
        includeMoves: config.diff?.includeMoves,
    };
    const driftOptions = {
        fail: config.drift?.fail,
    };
    const metadataOptions = {};
    const acknowledgeOptions = {};
    const noticesOptions = {
        unacknowledged: config.notices?.unacknowledged,
    };
    const initOptions = {
        language: config.init?.language,
        list: config.init?.list,
        generateOnly: config.init?.generateOnly,
        libVersion: config.init?.libVersion,
        fromPath: config.init?.fromPath,
        templatePath: config.init?.templatePath,
        packageManager: config.init?.packageManager,
        projectName: config.init?.projectName,
    };
    const migrateOptions = {
        stackName: config.migrate?.stackName,
        language: config.migrate?.language,
        account: config.migrate?.account,
        region: config.migrate?.region,
        fromPath: config.migrate?.fromPath,
        fromStack: config.migrate?.fromStack,
        outputPath: config.migrate?.outputPath,
        fromScan: config.migrate?.fromScan,
        filter: config.migrate?.filter,
        compress: config.migrate?.compress,
    };
    const contextOptions = {
        reset: config.context?.reset,
        force: config.context?.force,
        clear: config.context?.clear,
    };
    const docsOptions = {
        browser: config.docs?.browser,
    };
    const doctorOptions = {};
    const refactorOptions = {
        additionalStackName: config.refactor?.additionalStackName,
        dryRun: config.refactor?.dryRun,
        overrideFile: config.refactor?.overrideFile,
        revert: config.refactor?.revert,
        force: config.refactor?.force,
    };
    const cliTelemetryOptions = {
        enable: config.cliTelemetry?.enable,
        disable: config.cliTelemetry?.disable,
        status: config.cliTelemetry?.status,
    };
    const userInput = {
        globalOptions,
        list: listOptions,
        synth: synthOptions,
        bootstrap: bootstrapOptions,
        gc: gcOptions,
        flags: flagsOptions,
        deploy: deployOptions,
        rollback: rollbackOptions,
        import: importOptions,
        watch: watchOptions,
        destroy: destroyOptions,
        diff: diffOptions,
        drift: driftOptions,
        metadata: metadataOptions,
        acknowledge: acknowledgeOptions,
        notices: noticesOptions,
        init: initOptions,
        migrate: migrateOptions,
        context: contextOptions,
        docs: docsOptions,
        doctor: doctorOptions,
        refactor: refactorOptions,
        cliTelemetry: cliTelemetryOptions,
    };
    return userInput;
}
//# sourceMappingURL=data:application/json;base64,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