"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCommandLineArguments = parseCommandLineArguments;
const helpers = require("./util/yargs-helpers");
// @ts-ignore TS6133
function parseCommandLineArguments(args) {
    return yargs
        .env('CDK')
        .usage('Usage: cdk -a <cdk-app> COMMAND')
        .option('app', {
        default: undefined,
        type: 'string',
        alias: 'a',
        desc: 'REQUIRED WHEN RUNNING APP: command-line for executing your app or a cloud assembly directory (e.g. "node bin/my-app.js"). Can also be specified in cdk.json or ~/.cdk.json',
        requiresArg: true,
    })
        .option('build', {
        default: undefined,
        type: 'string',
        desc: 'Command-line for a pre-synth build',
    })
        .option('context', {
        type: 'array',
        alias: 'c',
        desc: 'Add contextual string parameter (KEY=VALUE)',
        nargs: 1,
        requiresArg: true,
    })
        .option('plugin', {
        type: 'array',
        alias: 'p',
        desc: 'Name or path of a node package that extend the CDK features. Can be specified multiple times',
        nargs: 1,
        requiresArg: true,
    })
        .option('trace', {
        default: undefined,
        type: 'boolean',
        desc: 'Print trace for stack warnings',
    })
        .option('strict', {
        default: undefined,
        type: 'boolean',
        desc: 'Do not construct stacks with warnings',
    })
        .option('lookups', {
        default: true,
        type: 'boolean',
        desc: 'Perform context lookups (synthesis fails if this is disabled and context lookups need to be performed)',
    })
        .option('ignore-errors', {
        default: false,
        type: 'boolean',
        desc: 'Ignores synthesis errors, which will likely produce an invalid output',
    })
        .option('json', {
        default: false,
        type: 'boolean',
        alias: 'j',
        desc: 'Use JSON output instead of YAML when templates are printed to STDOUT',
    })
        .option('verbose', {
        default: false,
        type: 'boolean',
        alias: 'v',
        desc: 'Show debug logs (specify multiple times to increase verbosity)',
        count: true,
    })
        .option('debug', {
        default: false,
        type: 'boolean',
        desc: 'Debug the CDK app. Log additional information during synthesis, such as creation stack traces of tokens (sets CDK_DEBUG, will slow down synthesis)',
    })
        .option('profile', {
        default: undefined,
        type: 'string',
        desc: 'Use the indicated AWS profile as the default environment',
        requiresArg: true,
    })
        .option('proxy', {
        default: undefined,
        type: 'string',
        desc: 'Use the indicated proxy. Will read from HTTPS_PROXY environment variable if not specified',
        requiresArg: true,
    })
        .option('ca-bundle-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to CA certificate to use when validating HTTPS requests. Will read from AWS_CA_BUNDLE environment variable if not specified',
        requiresArg: true,
    })
        .option('ec2creds', {
        default: undefined,
        type: 'boolean',
        alias: 'i',
        desc: 'Force trying to fetch EC2 instance credentials. Default: guess EC2 instance status',
    })
        .option('version-reporting', {
        default: undefined,
        type: 'boolean',
        desc: 'Disable CLI telemetry and do not include the "AWS::CDK::Metadata" resource in synthesized templates (enabled by default)',
        alias: 'telemetry',
    })
        .option('path-metadata', {
        default: undefined,
        type: 'boolean',
        desc: 'Include "aws:cdk:path" CloudFormation metadata for each resource (enabled by default)',
    })
        .option('asset-metadata', {
        default: undefined,
        type: 'boolean',
        desc: 'Include "aws:asset:*" CloudFormation metadata for resources that uses assets (enabled by default)',
    })
        .option('role-arn', {
        default: undefined,
        type: 'string',
        alias: 'r',
        desc: 'ARN of Role to use when invoking CloudFormation',
        requiresArg: true,
    })
        .option('staging', {
        default: true,
        type: 'boolean',
        desc: 'Copy assets to the output directory (use --no-staging to disable the copy of assets which allows local debugging via the SAM CLI to reference the original source files)',
    })
        .option('output', {
        default: undefined,
        type: 'string',
        alias: 'o',
        desc: 'Emits the synthesized cloud assembly into a directory (default: cdk.out)',
        requiresArg: true,
    })
        .option('notices', {
        default: undefined,
        type: 'boolean',
        desc: 'Show relevant notices',
    })
        .option('no-color', {
        default: false,
        type: 'boolean',
        desc: 'Removes colors and other style from console output',
    })
        .option('color', {
        default: undefined,
        type: 'boolean',
        desc: 'Force colored output even when stdout is not a TTY',
    })
        .option('ci', {
        default: helpers.isCI(),
        type: 'boolean',
        desc: 'Force CI detection. If CI=true then logs will be sent to stdout instead of stderr',
    })
        .option('unstable', {
        type: 'array',
        desc: 'Opt in to unstable features. The flag indicates that the scope and API of a feature might still change. Otherwise the feature is generally production ready and fully supported. Can be specified multiple times.',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('telemetry-file', {
        default: undefined,
        type: 'string',
        desc: 'Send telemetry data to a local file.',
    })
        .option('yes', {
        default: false,
        type: 'boolean',
        alias: 'y',
        desc: 'Automatically answer interactive prompts with the recommended response. This includes confirming actions.',
    })
        .command(['list [STACKS..]', 'ls [STACKS..]'], 'Lists all stacks in the app', (yargs) => yargs
        .option('long', {
        default: false,
        type: 'boolean',
        alias: 'l',
        desc: 'Display environment information for each stack',
    })
        .option('show-dependencies', {
        default: false,
        type: 'boolean',
        alias: 'd',
        desc: 'Display stack dependency information for each stack',
    }))
        .command(['synth [STACKS..]', 'synthesize [STACKS..]'], 'Synthesizes and prints the CloudFormation template for this stack', (yargs) => yargs
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only synthesize requested stacks, don't include dependencies",
    })
        .option('validation', {
        default: true,
        type: 'boolean',
        desc: 'After synthesis, validate stacks with the "validateOnSynth" attribute set (can also be controlled with CDK_VALIDATION)',
    })
        .option('quiet', {
        default: false,
        type: 'boolean',
        alias: 'q',
        desc: 'Do not output CloudFormation Template to stdout',
    }))
        .command('bootstrap [ENVIRONMENTS..]', 'Deploys the CDK toolkit stack into an AWS environment', (yargs) => yargs
        .option('bootstrap-bucket-name', {
        default: undefined,
        type: 'string',
        alias: ['b', 'toolkit-bucket-name'],
        desc: 'The name of the CDK toolkit bucket; bucket will be created and must not exist',
    })
        .option('bootstrap-kms-key-id', {
        default: undefined,
        type: 'string',
        desc: 'AWS KMS master key ID used for the SSE-KMS encryption (specify AWS_MANAGED_KEY to use an AWS-managed key)',
        conflicts: 'bootstrap-customer-key',
    })
        .option('example-permissions-boundary', {
        default: undefined,
        type: 'boolean',
        alias: 'epb',
        desc: 'Use the example permissions boundary.',
        conflicts: 'custom-permissions-boundary',
    })
        .option('custom-permissions-boundary', {
        default: undefined,
        type: 'string',
        alias: 'cpb',
        desc: 'Use the permissions boundary specified by name.',
        conflicts: 'example-permissions-boundary',
    })
        .option('bootstrap-customer-key', {
        default: undefined,
        type: 'boolean',
        desc: 'Create a Customer Master Key (CMK) for the bootstrap bucket (you will be charged but can customize permissions, modern bootstrapping only)',
        conflicts: 'bootstrap-kms-key-id',
    })
        .option('qualifier', {
        default: undefined,
        type: 'string',
        desc: 'String which must be unique for each bootstrap stack. You must configure it on your CDK app if you change this from the default.',
    })
        .option('public-access-block-configuration', {
        default: undefined,
        type: 'boolean',
        desc: 'Block public access configuration on CDK toolkit bucket (enabled by default) ',
    })
        .option('deny-external-id', {
        default: undefined,
        type: 'boolean',
        desc: 'Block AssumeRole access to all boostrapped roles if an ExternalId is provided (enabled by default) ',
    })
        .option('tags', {
        type: 'array',
        alias: 't',
        desc: 'Tags to add for the stack (KEY=VALUE)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('execute', {
        default: true,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)',
    })
        .option('trust', {
        type: 'array',
        desc: 'The AWS account IDs that should be trusted to perform deployments into this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('trust-for-lookup', {
        type: 'array',
        desc: 'The AWS account IDs that should be trusted to look up values in this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('untrust', {
        type: 'array',
        desc: 'The AWS account IDs that should not be trusted by this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('cloudformation-execution-policies', {
        type: 'array',
        desc: 'The Managed Policy ARNs that should be attached to the role performing deployments into this environment (may be repeated, modern bootstrapping only)',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always bootstrap even if it would downgrade template version',
    })
        .option('termination-protection', {
        default: undefined,
        type: 'boolean',
        desc: 'Toggle CloudFormation termination protection on the bootstrap stacks',
    })
        .option('show-template', {
        default: false,
        type: 'boolean',
        desc: "Instead of actual bootstrapping, print the current CLI's bootstrapping template to stdout for customization",
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack to create',
        requiresArg: true,
    })
        .option('template', {
        default: undefined,
        type: 'string',
        requiresArg: true,
        desc: 'Use the template from the given file instead of the built-in one (use --show-template to obtain an example)',
    })
        .option('previous-parameters', {
        default: true,
        type: 'boolean',
        desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)',
    }))
        .command('gc [ENVIRONMENTS..]', 'Garbage collect assets. Options detailed here: https://github.com/aws/aws-cdk-cli/tree/main/packages/aws-cdk#cdk-gc', (yargs) => yargs
        .option('action', {
        default: 'full',
        type: 'string',
        desc: 'The action (or sub-action) you want to perform. Valid entires are "print", "tag", "delete-tagged", "full".',
    })
        .option('type', {
        default: 'all',
        type: 'string',
        desc: 'Specify either ecr, s3, or all',
    })
        .option('rollback-buffer-days', {
        default: 0,
        type: 'number',
        desc: 'Delete assets that have been marked as isolated for this many days',
    })
        .option('created-buffer-days', {
        default: 1,
        type: 'number',
        desc: 'Never delete assets younger than this (in days)',
    })
        .option('confirm', {
        default: true,
        type: 'boolean',
        desc: 'Confirm via manual prompt before deletion',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit"',
        requiresArg: true,
        conflicts: 'bootstrap-stack-name',
    })
        .option('bootstrap-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack, if different from the default "CDKToolkit" (deprecated, use --toolkit-stack-name)',
        deprecated: 'use --toolkit-stack-name',
        requiresArg: true,
        conflicts: 'toolkit-stack-name',
    }))
        .command('flags [FLAGNAME..]', 'View and toggle feature flags.', (yargs) => yargs
        .option('value', {
        default: undefined,
        type: 'string',
        desc: 'The value the user would like to set the feature flag configuration to',
        requiresArg: true,
    })
        .option('set', {
        default: undefined,
        type: 'boolean',
        desc: 'Signifies the user would like to modify their feature flag configuration',
        requiresArg: false,
    })
        .option('all', {
        default: undefined,
        type: 'boolean',
        desc: 'Modify or view all feature flags',
        requiresArg: false,
    })
        .option('unconfigured', {
        default: undefined,
        type: 'boolean',
        desc: 'Modify unconfigured feature flags',
        requiresArg: false,
    })
        .option('recommended', {
        default: undefined,
        type: 'boolean',
        desc: 'Change flags to recommended states',
        requiresArg: false,
    })
        .option('default', {
        default: undefined,
        type: 'boolean',
        desc: 'Change flags to default state',
        requiresArg: false,
    })
        .option('interactive', {
        default: undefined,
        type: 'boolean',
        alias: ['i'],
        desc: 'Interactive option for the flags command',
    })
        .option('safe', {
        default: undefined,
        type: 'boolean',
        desc: "Enable all feature flags that do not impact the user's application",
        requiresArg: false,
    })
        .option('concurrency', {
        default: 4,
        type: 'number',
        alias: ['n'],
        desc: 'Maximum number of simultaneous synths to execute.',
        requiresArg: true,
    }))
        .command('deploy [STACKS..]', 'Deploys the stack(s) named STACKS into your AWS account', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Deploy all available stacks',
    })
        .option('build-exclude', {
        type: 'array',
        alias: 'E',
        desc: 'Do not rebuild asset with the given ID. Can be specified multiple times',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only deploy requested stacks, don't include dependencies",
    })
        .option('require-approval', {
        default: undefined,
        type: 'string',
        choices: ['never', 'any-change', 'broadening'],
        desc: 'What security-sensitive changes need manual approval',
    })
        .option('notification-arns', {
        type: 'array',
        desc: "ARNs of SNS topics that CloudFormation will notify with stack related events. These will be added to ARNs specified with the 'notificationArns' stack property.",
        nargs: 1,
        requiresArg: true,
    })
        .option('tags', {
        type: 'array',
        alias: 't',
        desc: 'Tags to add to the stack (KEY=VALUE), overrides tags from Cloud Assembly (deprecated)',
        nargs: 1,
        requiresArg: true,
    })
        .option('execute', {
        default: undefined,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet) (deprecated)',
        deprecated: true,
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create (only if method is not direct)',
    })
        .option('method', {
        default: undefined,
        alias: 'm',
        type: 'string',
        choices: ['direct', 'change-set', 'prepare-change-set'],
        requiresArg: true,
        desc: 'How to perform the deployment. Direct is a bit faster but lacks progress information',
    })
        .option('import-existing-resources', {
        default: false,
        type: 'boolean',
        desc: 'Indicates if the stack set imports resources that already exist.',
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always deploy stack even if templates are identical',
    })
        .option('parameters', {
        type: 'array',
        desc: 'Additional parameters passed to CloudFormation at deploy time (STACK:KEY=VALUE)',
        default: {},
        nargs: 1,
        requiresArg: true,
    })
        .option('outputs-file', {
        default: undefined,
        type: 'string',
        alias: 'O',
        desc: 'Path to file where stack outputs will be written as JSON',
        requiresArg: true,
    })
        .option('previous-parameters', {
        default: true,
        type: 'boolean',
        desc: 'Use previous values for existing parameters (you must specify all parameters on every deployment if this is disabled)',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)',
        requiresArg: true,
    })
        .option('progress', {
        default: undefined,
        type: 'string',
        choices: ['bar', 'events'],
        desc: 'Display mode for stack activity events',
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('R', { type: 'boolean', hidden: true })
        .middleware(helpers.yargsNegativeAlias('R', 'rollback'), true)
        .option('hotswap', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, but does not fall back to a full deployment if that is not possible. Instead, changes to any non-hotswappable properties are ignored.Do not use this in production environments",
    })
        .option('hotswap-fallback', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, which skips CloudFormation and updates the resources directly, and falls back to a full deployment if that is not possible. Do not use this in production environments",
    })
        .option('hotswap-ecs-minimum-healthy-percent', {
        default: undefined,
        type: 'number',
        desc: "Lower limit on the number of your service's tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-maximum-healthy-percent', {
        default: undefined,
        type: 'number',
        desc: "Upper limit on the number of your service's tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-stabilization-timeout-seconds', {
        default: undefined,
        type: 'number',
        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
    })
        .option('watch', {
        default: undefined,
        type: 'boolean',
        desc: 'Continuously observe the project files, and deploy the given stack(s) automatically when changes are detected. Implies --hotswap by default',
    })
        .option('logs', {
        default: true,
        type: 'boolean',
        desc: "Show CloudWatch log events from all resources in the selected Stacks in the terminal. 'true' by default, use --no-logs to turn off. Only in effect if specified alongside the '--watch' option",
    })
        .option('concurrency', {
        default: 1,
        type: 'number',
        desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.',
        requiresArg: true,
    })
        .option('asset-parallelism', {
        default: undefined,
        type: 'boolean',
        desc: 'Whether to build/publish assets in parallel',
    })
        .option('asset-prebuild', {
        default: true,
        type: 'boolean',
        desc: 'Whether to build all assets before deploying the first stack (useful for failing Docker builds)',
    })
        .option('ignore-no-stacks', {
        default: false,
        type: 'boolean',
        desc: 'Whether to deploy if the app contains no stacks',
    }))
        .command('rollback [STACKS..]', 'Rolls back the stack(s) named STACKS to their last stable state', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Roll back all available stacks',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack the environment is bootstrapped with',
        requiresArg: true,
    })
        .option('force', {
        default: undefined,
        alias: 'f',
        type: 'boolean',
        desc: 'Orphan all resources for which the rollback operation fails.',
    })
        .option('validate-bootstrap-version', {
        default: undefined,
        type: 'boolean',
        desc: "Whether to validate the bootstrap stack version. Defaults to 'true', disable with --no-validate-bootstrap-version.",
    })
        .option('orphan', {
        type: 'array',
        desc: 'Orphan the given resources, identified by their logical ID (can be specified multiple times)',
        default: [],
        nargs: 1,
        requiresArg: true,
    }))
        .command('import [STACK]', 'Import existing resource(s) into the given STACK', (yargs) => yargs
        .option('execute', {
        default: true,
        type: 'boolean',
        desc: 'Whether to execute ChangeSet (--no-execute will NOT execute the ChangeSet)',
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the CDK toolkit stack to create',
        requiresArg: true,
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('force', {
        default: undefined,
        alias: 'f',
        type: 'boolean',
        desc: "Do not abort if the template diff includes updates or deletes. This is probably safe but we're not sure, let us know how it goes.",
    })
        .option('record-resource-mapping', {
        default: undefined,
        type: 'string',
        alias: 'r',
        requiresArg: true,
        desc: 'If specified, CDK will generate a mapping of existing physical resources to CDK resources to be imported as. The mapping will be written in the given file path. No actual import operation will be performed',
    })
        .option('resource-mapping', {
        default: undefined,
        type: 'string',
        alias: 'm',
        requiresArg: true,
        desc: 'If specified, CDK will use the given file to map physical resources to CDK resources for import, instead of interactively asking the user. Can be run from scripts',
    }))
        .command('watch [STACKS..]', "Shortcut for 'deploy --watch'", (yargs) => yargs
        .option('build-exclude', {
        type: 'array',
        alias: 'E',
        desc: 'Do not rebuild asset with the given ID. Can be specified multiple times',
        default: [],
        nargs: 1,
        requiresArg: true,
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only deploy requested stacks, don't include dependencies",
    })
        .option('change-set-name', {
        default: undefined,
        type: 'string',
        desc: 'Name of the CloudFormation change set to create',
    })
        .option('force', {
        default: false,
        alias: 'f',
        type: 'boolean',
        desc: 'Always deploy stack even if templates are identical',
    })
        .option('toolkit-stack-name', {
        default: undefined,
        type: 'string',
        desc: 'The name of the existing CDK toolkit stack (only used for app using legacy synthesis)',
        requiresArg: true,
    })
        .option('progress', {
        default: undefined,
        type: 'string',
        choices: ['bar', 'events'],
        desc: 'Display mode for stack activity events',
    })
        .option('rollback', {
        default: undefined,
        type: 'boolean',
        desc: "Rollback stack to stable state on failure. Defaults to 'true', iterate more rapidly with --no-rollback or -R. Note: do **not** disable this flag for deployments with resource replacements, as that will always fail",
    })
        .option('R', { type: 'boolean', hidden: true })
        .middleware(helpers.yargsNegativeAlias('R', 'rollback'), true)
        .option('hotswap', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, but does not fall back to a full deployment if that is not possible. Instead, changes to any non-hotswappable properties are ignored.'true' by default, use --no-hotswap to turn off",
    })
        .option('hotswap-fallback', {
        default: undefined,
        type: 'boolean',
        desc: "Attempts to perform a 'hotswap' deployment, which skips CloudFormation and updates the resources directly, and falls back to a full deployment if that is not possible.",
    })
        .option('hotswap-ecs-minimum-healthy-percent', {
        default: undefined,
        type: 'number',
        desc: "Lower limit on the number of your service's tasks that must remain in the RUNNING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-maximum-healthy-percent', {
        default: undefined,
        type: 'number',
        desc: "Upper limit on the number of your service's tasks that are allowed in the RUNNING or PENDING state during a deployment, as a percentage of the desiredCount",
    })
        .option('hotswap-ecs-stabilization-timeout-seconds', {
        default: undefined,
        type: 'number',
        desc: 'Number of seconds to wait for a single service to reach stable state, where the desiredCount is equal to the runningCount',
    })
        .option('logs', {
        default: true,
        type: 'boolean',
        desc: "Show CloudWatch log events from all resources in the selected Stacks in the terminal. 'true' by default, use --no-logs to turn off",
    })
        .option('concurrency', {
        default: 1,
        type: 'number',
        desc: 'Maximum number of simultaneous deployments (dependency permitting) to execute.',
        requiresArg: true,
    }))
        .command('destroy [STACKS..]', 'Destroy the stack(s) named STACKS', (yargs) => yargs
        .option('all', {
        default: false,
        type: 'boolean',
        desc: 'Destroy all available stacks',
    })
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only destroy requested stacks, don't include dependees",
    })
        .option('force', {
        default: undefined,
        type: 'boolean',
        alias: 'f',
        desc: 'Do not ask for confirmation before destroying the stacks',
    }))
        .command('diff [STACKS..]', 'Compares the specified stack with the deployed stack or a local template file, and returns with status 1 if any difference is found', (yargs) => yargs
        .option('exclusively', {
        default: undefined,
        type: 'boolean',
        alias: 'e',
        desc: "Only diff requested stacks, don't include dependencies",
    })
        .option('context-lines', {
        default: 3,
        type: 'number',
        desc: 'Number of context lines to include in arbitrary JSON diff rendering',
        requiresArg: true,
    })
        .option('template', {
        default: undefined,
        type: 'string',
        desc: 'The path to the CloudFormation template to compare with',
        requiresArg: true,
    })
        .option('strict', {
        default: false,
        type: 'boolean',
        desc: 'Do not filter out AWS::CDK::Metadata resources, mangled non-ASCII characters, or the CheckBootstrapVersionRule',
    })
        .option('security-only', {
        default: false,
        type: 'boolean',
        desc: 'Only diff for broadened security changes',
    })
        .option('fail', {
        default: undefined,
        type: 'boolean',
        desc: 'Fail with exit code 1 in case of diff',
    })
        .option('processed', {
        default: false,
        type: 'boolean',
        desc: 'Whether to compare against the template with Transforms already processed',
    })
        .option('quiet', {
        default: false,
        type: 'boolean',
        alias: 'q',
        desc: 'Do not print stack name and default message when there is no diff to stdout',
    })
        .option('change-set', {
        default: true,
        type: 'boolean',
        alias: 'changeset',
        desc: 'Whether to create a changeset to analyze resource replacements. In this mode, diff will use the deploy role instead of the lookup role.',
    })
        .option('import-existing-resources', {
        default: false,
        type: 'boolean',
        desc: 'Whether or not the change set imports resources that already exist',
    })
        .option('include-moves', {
        default: false,
        type: 'boolean',
        desc: 'Whether to include moves in the diff',
    }))
        .command('drift [STACKS..]', 'Detect drifts in the given CloudFormation stack(s)', (yargs) => yargs.option('fail', {
        default: undefined,
        type: 'boolean',
        desc: 'Fail with exit code 1 if drift is detected',
    }))
        .command('metadata [STACK]', 'Returns all metadata associated with this stack')
        .command(['acknowledge [ID]', 'ack [ID]'], 'Acknowledge a notice so that it does not show up anymore')
        .command('notices', 'Returns a list of relevant notices', (yargs) => yargs.option('unacknowledged', {
        default: false,
        type: 'boolean',
        alias: 'u',
        desc: 'Returns a list of unacknowledged notices',
    }))
        .command('init [TEMPLATE]', 'Create a new, empty CDK project from a template.', (yargs) => yargs
        .option('language', {
        default: undefined,
        type: 'string',
        alias: 'l',
        desc: 'The language to be used for the new project (default can be configured in ~/.cdk.json)',
        choices: ['csharp', 'cs', 'fsharp', 'fs', 'go', 'java', 'javascript', 'js', 'python', 'py', 'typescript', 'ts'],
    })
        .option('list', {
        default: undefined,
        type: 'boolean',
        desc: 'List the available templates',
    })
        .option('generate-only', {
        default: false,
        type: 'boolean',
        desc: 'If true, only generates project files, without executing additional operations such as setting up a git repo, installing dependencies or compiling the project',
    })
        .option('lib-version', {
        default: undefined,
        type: 'string',
        alias: 'V',
        desc: 'The version of the CDK library (aws-cdk-lib) to initialize built-in templates with. Defaults to the version that was current when this CLI was built.',
    })
        .option('from-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to a local custom template directory or multi-template repository',
        requiresArg: true,
        conflicts: ['lib-version'],
    })
        .option('template-path', {
        default: undefined,
        type: 'string',
        desc: 'Path to a specific template within a multi-template repository',
        requiresArg: true,
    })
        .option('package-manager', {
        default: undefined,
        type: 'string',
        desc: 'The package manager to use to install dependencies. Only applicable for TypeScript and JavaScript projects. Defaults to npm in TypeScript and JavaScript projects.',
        choices: ['npm', 'yarn', 'pnpm', 'bun'],
    })
        .option('project-name', {
        default: undefined,
        type: 'string',
        alias: 'n',
        desc: 'The name of the new project',
        requiresArg: true,
    }))
        .command('migrate', 'Migrate existing AWS resources into a CDK app', (yargs) => yargs
        .option('stack-name', {
        default: undefined,
        type: 'string',
        alias: 'n',
        desc: 'The name assigned to the stack created in the new project. The name of the app will be based off this name as well.',
        requiresArg: true,
    })
        .option('language', {
        default: 'typescript',
        type: 'string',
        alias: 'l',
        desc: 'The language to be used for the new project',
        choices: ['typescript', 'ts', 'go', 'java', 'python', 'py', 'csharp', 'cs'],
    })
        .option('account', {
        default: undefined,
        type: 'string',
        desc: 'The account to retrieve the CloudFormation stack template from',
    })
        .option('region', {
        default: undefined,
        type: 'string',
        desc: 'The region to retrieve the CloudFormation stack template from',
    })
        .option('from-path', {
        default: undefined,
        type: 'string',
        desc: 'The path to the CloudFormation template to migrate. Use this for locally stored templates',
    })
        .option('from-stack', {
        default: undefined,
        type: 'boolean',
        desc: 'Use this flag to retrieve the template for an existing CloudFormation stack',
    })
        .option('output-path', {
        default: undefined,
        type: 'string',
        desc: 'The output path for the migrated CDK app',
    })
        .option('from-scan', {
        default: undefined,
        type: 'string',
        desc: 'Determines if a new scan should be created, or the last successful existing scan should be used \n options are "new" or "most-recent"',
    })
        .option('filter', {
        type: 'array',
        desc: 'Filters the resource scan based on the provided criteria in the following format: "key1=value1,key2=value2"\n This field can be passed multiple times for OR style filtering: \n filtering options: \n resource-identifier: A key-value pair that identifies the target resource. i.e. {"ClusterName", "myCluster"}\n resource-type-prefix: A string that represents a type-name prefix. i.e. "AWS::DynamoDB::"\n tag-key: a string that matches resources with at least one tag with the provided key. i.e. "myTagKey"\n tag-value: a string that matches resources with at least one tag with the provided value. i.e. "myTagValue"',
        nargs: 1,
        requiresArg: true,
    })
        .option('compress', {
        default: undefined,
        type: 'boolean',
        desc: 'Use this flag to zip the generated CDK app',
    }))
        .command('context', 'Manage cached context values', (yargs) => yargs
        .option('reset', {
        default: undefined,
        alias: 'e',
        desc: 'The context key (or its index) to reset',
        type: 'string',
        requiresArg: true,
    })
        .option('force', {
        default: false,
        alias: 'f',
        desc: 'Ignore missing key error',
        type: 'boolean',
    })
        .option('clear', {
        default: false,
        desc: 'Clear all context',
        type: 'boolean',
    }))
        .command(['docs', 'doc'], 'Opens the reference documentation in a browser', (yargs) => yargs.option('browser', {
        default: helpers.browserForPlatform(),
        alias: 'b',
        desc: 'the command to use to open the browser, using %u as a placeholder for the path of the file to open',
        type: 'string',
    }))
        .command('doctor', 'Check your set-up for potential problems')
        .command('refactor [STACKS..]', 'Moves resources between stacks or within the same stack', (yargs) => yargs
        .option('additional-stack-name', {
        type: 'array',
        requiresArg: true,
        desc: 'Names of deployed stacks to be considered for resource comparison.',
        nargs: 1,
    })
        .option('dry-run', {
        default: false,
        type: 'boolean',
        desc: 'Do not perform any changes, just show what would be done',
    })
        .option('override-file', {
        default: undefined,
        type: 'string',
        requiresArg: true,
        desc: 'A file that declares overrides to be applied to the list of mappings computed by the CLI.',
    })
        .option('revert', {
        default: false,
        type: 'boolean',
        desc: 'If specified, the command will revert the refactor operation. This is only valid if a mapping file was provided.',
    })
        .option('force', {
        default: false,
        type: 'boolean',
        desc: 'Whether to do the refactor without asking for confirmation',
    }))
        .command('cli-telemetry', 'Enable or disable anonymous telemetry', (yargs) => yargs
        .option('enable', {
        default: undefined,
        type: 'boolean',
        desc: 'Enable anonymous telemetry',
        conflicts: 'disable',
    })
        .option('disable', {
        default: undefined,
        type: 'boolean',
        desc: 'Disable anonymous telemetry',
        conflicts: 'enable',
    })
        .option('status', {
        default: undefined,
        type: 'boolean',
        desc: 'Report telemetry opt-in/out status',
        conflicts: ['enable', 'disable'],
    }))
        .version(helpers.cliVersion())
        .demandCommand(1, '')
        .recommendCommands()
        .help()
        .alias('h', 'help')
        .epilogue('If your app has a single stack, there is no need to specify the stack name\n\nIf one of cdk.json or ~/.cdk.json exists, options specified there will be used as defaults. Settings in cdk.json take precedence.')
        .parse(args);
}
// eslint-disable-next-line @typescript-eslint/no-require-imports
const yargs = require('yargs');
//# sourceMappingURL=data:application/json;base64,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