/**
 * Enum of all valid CDK feature flag names.
 *
 * These flags are used to control behavior changes in the CDK.
 * For more information, see: https://github.com/aws/aws-cdk/blob/main/packages/aws-cdk-lib/cx-api/FEATURE_FLAGS.md
 */
export declare enum FeatureFlag {
    CORE_NEW_STYLE_STACK_SYNTHESIS = "@aws-cdk/core:newStyleStackSynthesis",
    CORE_STACK_RELATIVE_EXPORTS = "@aws-cdk/core:stackRelativeExports",
    RDS_LOWERCASE_DB_IDENTIFIER = "@aws-cdk/aws-rds:lowercaseDbIdentifier",
    APIGATEWAY_USAGE_PLAN_KEY_ORDER_INSENSITIVE_ID = "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId",
    LAMBDA_RECOGNIZE_VERSION_PROPS = "@aws-cdk/aws-lambda:recognizeVersionProps",
    CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021",
    CORE_TARGET_PARTITIONS = "@aws-cdk/core:target-partitions",
    ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = "@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver",
    EC2_UNIQUE_IMDSV2_TEMPLATE_NAME = "@aws-cdk/aws-ec2:uniqueImdsv2TemplateName",
    IAM_MINIMIZE_POLICIES = "@aws-cdk/aws-iam:minimizePolicies",
    CORE_CHECK_SECRET_USAGE = "@aws-cdk/core:checkSecretUsage",
    LAMBDA_RECOGNIZE_LAYER_VERSION = "@aws-cdk/aws-lambda:recognizeLayerVersion",
    CORE_VALIDATE_SNAPSHOT_REMOVAL_POLICY = "@aws-cdk/core:validateSnapshotRemovalPolicy",
    CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = "@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName",
    S3_CREATE_DEFAULT_LOGGING_POLICY = "@aws-cdk/aws-s3:createDefaultLoggingPolicy",
    SNS_SUBSCRIPTIONS_RESTRICT_SQS_DECRYPTION = "@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption",
    ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = "@aws-cdk/aws-ecs:arnFormatIncludesClusterName",
    APIGATEWAY_DISABLE_CLOUD_WATCH_ROLE = "@aws-cdk/aws-apigateway:disableCloudWatchRole",
    CORE_ENABLE_PARTITION_LITERALS = "@aws-cdk/core:enablePartitionLiterals",
    ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = "@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker",
    EVENTS_EVENTS_TARGET_QUEUE_SAME_ACCOUNT = "@aws-cdk/aws-events:eventsTargetQueueSameAccount",
    IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = "@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName",
    S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = "@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy",
    CUSTOMRESOURCES_INSTALL_LATEST_AWS_SDK_DEFAULT = "@aws-cdk/customresources:installLatestAwsSdkDefault",
    ROUTE53_PATTERNS_USE_CERTIFICATE = "@aws-cdk/aws-route53-patterns:useCertificate",
    CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = "@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup",
    RDS_DATABASE_PROXY_UNIQUE_RESOURCE_NAME = "@aws-cdk/aws-rds:databaseProxyUniqueResourceName",
    APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = "@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId",
    EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = "@aws-cdk/aws-ec2:launchTemplateDefaultUserData",
    SECRETSMANAGER_USE_ATTACHED_SECRET_RESOURCE_POLICY_FOR_SECRET_TARGET_ATTACHMENTS = "@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments",
    REDSHIFT_COLUMN_ID = "@aws-cdk/aws-redshift:columnId",
    STEPFUNCTIONS_TASKS_ENABLE_EMR_SERVICE_POLICY_V2 = "@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2",
    APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = "@aws-cdk/aws-apigateway:requestValidatorUniqueId",
    EC2_RESTRICT_DEFAULT_SECURITY_GROUP = "@aws-cdk/aws-ec2:restrictDefaultSecurityGroup",
    KMS_ALIAS_NAME_REF = "@aws-cdk/aws-kms:aliasNameRef",
    CORE_INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = "@aws-cdk/core:includePrefixInUniqueNameGeneration",
    AUTOSCALING_GENERATE_LAUNCH_TEMPLATE_INSTEAD_OF_LAUNCH_CONFIG = "@aws-cdk/aws-autoscaling:generateLaunchTemplateInsteadOfLaunchConfig",
    OPENSEARCHSERVICE_ENABLE_OPENSEARCH_MULTI_AZ_WITH_STANDBY = "@aws-cdk/aws-opensearchservice:enableOpensearchMultiAzWithStandby",
    EFS_DENY_ANONYMOUS_ACCESS = "@aws-cdk/aws-efs:denyAnonymousAccess",
    EFS_MOUNT_TARGET_ORDER_INSENSITIVE_LOGICAL_ID = "@aws-cdk/aws-efs:mountTargetOrderInsensitiveLogicalId",
    LAMBDA_NODEJS_USE_LATEST_RUNTIME_VERSION = "@aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion",
    APPSYNC_USE_ARN_FOR_SOURCE_API_ASSOCIATION_IDENTIFIER = "@aws-cdk/aws-appsync:useArnForSourceApiAssociationIdentifier",
    RDS_AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = "@aws-cdk/aws-rds:auroraClusterChangeScopeOfInstanceParameterGroupWithEachParameters",
    RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = "@aws-cdk/aws-rds:preventRenderingDeprecatedCredentials",
    CODEPIPELINE_ACTIONS_USE_NEW_DEFAULT_BRANCH_FOR_CODE_COMMIT_SOURCE = "@aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource",
    CLOUDWATCH_ACTIONS_CHANGE_LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION = "@aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction",
    CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE = "@aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse",
    CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2 = "@aws-cdk/aws-codepipeline:defaultPipelineTypeToV2",
    KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE = "@aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope",
    EKS_NODEGROUP_NAME_ATTRIBUTE = "@aws-cdk/aws-eks:nodegroupNameAttribute",
    EC2_EBS_DEFAULT_GP3_VOLUME = "@aws-cdk/aws-ec2:ebsDefaultGp3Volume",
    PIPELINES_REDUCE_ASSET_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceAssetRoleTrustScope",
    ECS_REMOVE_DEFAULT_DEPLOYMENT_ALARM = "@aws-cdk/aws-ecs:removeDefaultDeploymentAlarm",
    CUSTOM_RESOURCES_LOG_API_RESPONSE_DATA_PROPERTY_TRUE_DEFAULT = "@aws-cdk/custom-resources:logApiResponseDataPropertyTrueDefault",
    S3_KEEP_NOTIFICATION_IN_IMPORTED_BUCKET = "@aws-cdk/aws-s3:keepNotificationInImportedBucket",
    STEPFUNCTIONS_TASKS_USE_NEW_S3_URI_PARAMETERS_FOR_BEDROCK_INVOKE_MODEL_TASK = "@aws-cdk/aws-stepfunctions-tasks:useNewS3UriParametersForBedrockInvokeModelTask",
    ECS_REDUCE_EC2_FARGATE_CLOUD_WATCH_PERMISSIONS = "@aws-cdk/aws-ecs:reduceEc2FargateCloudWatchPermissions",
    EC2_EC2_SUM_TIMEOUT_ENABLED = "@aws-cdk/aws-ec2:ec2SumTimeoutEnabled",
    APPSYNC_APP_SYNC_GRAPHQL_API_SCOPE_LAMBDA_PERMISSION = "@aws-cdk/aws-appsync:appSyncGraphQLAPIScopeLambdaPermission",
    LAMBDA_NODEJS_SDK_V3_EXCLUDE_SMITHY_PACKAGES = "@aws-cdk/aws-lambda-nodejs:sdkV3ExcludeSmithyPackages",
    RDS_SET_CORRECT_VALUE_FOR_DATABASE_INSTANCE_READ_REPLICA_INSTANCE_RESOURCE_ID = "@aws-cdk/aws-rds:setCorrectValueForDatabaseInstanceReadReplicaInstanceResourceId",
    CORE_CFN_INCLUDE_REJECT_COMPLEX_RESOURCE_UPDATE_CREATE_POLICY_INTRINSICS = "@aws-cdk/core:cfnIncludeRejectComplexResourceUpdateCreatePolicyIntrinsics",
    STEPFUNCTIONS_TASKS_FIX_RUN_ECS_TASK_POLICY = "@aws-cdk/aws-stepfunctions-tasks:fixRunEcsTaskPolicy",
    DYNAMODB_RESOURCE_POLICY_PER_REPLICA = "@aws-cdk/aws-dynamodb:resourcePolicyPerReplica",
    EC2_BASTION_HOST_USE_AMAZON_LINUX_2023_BY_DEFAULT = "@aws-cdk/aws-ec2:bastionHostUseAmazonLinux2023ByDefault",
    CORE_ASPECT_STABILIZATION = "@aws-cdk/core:aspectStabilization",
    ROUTE53_TARGETS_USER_POOL_DOMAIN_NAME_METHOD_WITHOUT_CUSTOM_RESOURCE = "@aws-cdk/aws-route53-targets:userPoolDomainNameMethodWithoutCustomResource",
    ECS_DISABLE_ECS_IMDS_BLOCKING = "@aws-cdk/aws-ecs:disableEcsImdsBlocking",
    ECS_ENABLE_IMDS_BLOCKING_DEPRECATED_FEATURE = "@aws-cdk/aws-ecs:enableImdsBlockingDeprecatedFeature",
    ELASTICLOADBALANCINGV2_ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT = "@aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault",
    IAM_OIDC_REJECT_UNAUTHORIZED_CONNECTIONS = "@aws-cdk/aws-iam:oidcRejectUnauthorizedConnections",
    CORE_ENABLE_ADDITIONAL_METADATA_COLLECTION = "@aws-cdk/core:enableAdditionalMetadataCollection",
    LAMBDA_CREATE_NEW_POLICIES_WITH_ADD_TO_ROLE_POLICY = "@aws-cdk/aws-lambda:createNewPoliciesWithAddToRolePolicy",
    S3_SET_UNIQUE_REPLICATION_ROLE_NAME = "@aws-cdk/aws-s3:setUniqueReplicationRoleName",
    PIPELINES_REDUCE_STAGE_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceStageRoleTrustScope",
    EVENTS_REQUIRE_EVENT_BUS_POLICY_SID = "@aws-cdk/aws-events:requireEventBusPolicySid",
    DYNAMODB_RETAIN_TABLE_REPLICA = "@aws-cdk/aws-dynamodb:retainTableReplica",
    COGNITO_LOG_USER_POOL_CLIENT_SECRET_VALUE = "@aws-cdk/cognito:logUserPoolClientSecretValue",
    STEPFUNCTIONS_USE_DISTRIBUTED_MAP_RESULT_WRITER_V2 = "@aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2",
    PIPELINES_REDUCE_CROSS_ACCOUNT_ACTION_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceCrossAccountActionRoleTrustScope",
    CORE_ASPECT_PRIORITIES_MUTATING = "@aws-cdk/core:aspectPrioritiesMutating",
    S3_NOTIFICATIONS_ADD_S3_TRUST_KEY_POLICY_FOR_SNS_SUBSCRIPTIONS = "@aws-cdk/s3-notifications:addS3TrustKeyPolicyForSnsSubscriptions",
    EC2_ALPHA_USE_RESOURCE_ID_FOR_VPC_V2_MIGRATION = "@aws-cdk/aws-ec2-alpha:useResourceIdForVpcV2Migration",
    EC2_REQUIRE_PRIVATE_SUBNETS_FOR_EGRESS_ONLY_INTERNET_GATEWAY = "@aws-cdk/aws-ec2:requirePrivateSubnetsForEgressOnlyInternetGateway",
    S3_PUBLIC_ACCESS_BLOCKED_BY_DEFAULT = "@aws-cdk/aws-s3:publicAccessBlockedByDefault",
    LAMBDA_USE_CDK_MANAGED_LOG_GROUP = "@aws-cdk/aws-lambda:useCdkManagedLogGroup",
    KMS_APPLY_IMPORTED_ALIAS_PERMISSIONS_TO_PRINCIPAL = "@aws-cdk/aws-kms:applyImportedAliasPermissionsToPrincipal",
    CORE_EXPLICIT_STACK_TAGS = "@aws-cdk/core:explicitStackTags"
}
