"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlagCommandHandler = void 0;
const interactive_handler_1 = require("./interactive-handler");
const obsolete_flags_1 = require("./obsolete-flags");
const operations_1 = require("./operations");
const router_1 = require("./router");
const validator_1 = require("./validator");
class FlagCommandHandler {
    /** Main component that sets up all flag operation components */
    constructor(flagData, ioHelper, options, toolkit, cliContextValues = {}) {
        this.flags = flagData.filter(flag => !obsolete_flags_1.OBSOLETE_FLAGS.includes(flag.name));
        this.options = { ...options, concurrency: options.concurrency ?? 4 };
        this.ioHelper = ioHelper;
        const validator = new validator_1.FlagValidator(ioHelper);
        const flagOperations = new operations_1.FlagOperations(this.flags, toolkit, ioHelper, cliContextValues);
        const interactiveHandler = new interactive_handler_1.InteractiveHandler(this.flags, flagOperations);
        this.router = new router_1.FlagOperationRouter(validator, interactiveHandler, flagOperations);
    }
    /** Main entry point that processes the flags command */
    async processFlagsCommand() {
        if (this.flags.length === 0) {
            await this.ioHelper.defaults.error('The \'cdk flags\' command is not compatible with the AWS CDK library used by your application. Please upgrade to 2.212.0 or above.');
            return;
        }
        await this.router.route(this.options);
    }
}
exports.FlagCommandHandler = FlagCommandHandler;
//# sourceMappingURL=data:application/json;base64,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