"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __knownSymbol = (name, symbol) => (symbol = Symbol[name]) ? symbol : /* @__PURE__ */ Symbol.for("Symbol." + name);
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result2 = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i13 = decorators.length - 1, decorator; i13 >= 0; i13--)
    if (decorator = decorators[i13])
      result2 = (kind ? decorator(target, key, result2) : decorator(result2)) || result2;
  if (kind && result2) __defProp(target, key, result2);
  return result2;
};
var __using = (stack, value, async) => {
  if (value != null) {
    if (typeof value !== "object" && typeof value !== "function") __typeError("Object expected");
    var dispose, inner;
    if (async) dispose = value[__knownSymbol("asyncDispose")];
    if (dispose === void 0) {
      dispose = value[__knownSymbol("dispose")];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") __typeError("Object not disposable");
    if (inner) dispose = function() {
      try {
        inner.call(this);
      } catch (e13) {
        return Promise.reject(e13);
      }
    };
    stack.push([async, dispose, value]);
  } else if (async) {
    stack.push([async]);
  }
  return value;
};
var __callDispose = (stack, error5, hasError) => {
  var E5 = typeof SuppressedError === "function" ? SuppressedError : function(e13, s13, m13, _2) {
    return _2 = Error(m13), _2.name = "SuppressedError", _2.error = e13, _2.suppressed = s13, _2;
  };
  var fail = (e13) => error5 = hasError ? new E5(e13, error5, "An error was suppressed during disposal") : (hasError = true, e13);
  var next = (it) => {
    while (it = stack.pop()) {
      try {
        var result2 = it[1] && it[1].call(it[2]);
        if (it[0]) return Promise.resolve(result2).then(next, (e13) => (fail(e13), next()));
      } catch (e13) {
        fail(e13);
      }
    }
    if (hasError) throw error5;
  };
  return next();
};

// ../@aws-cdk/cloud-assembly-api/lib/context/vpc.ts
var vpc_exports = {};
__export(vpc_exports, {
  VpcSubnetGroupType: () => VpcSubnetGroupType
});
var VpcSubnetGroupType;
var init_vpc = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/vpc.ts"() {
    "use strict";
    VpcSubnetGroupType = /* @__PURE__ */ ((VpcSubnetGroupType3) => {
      VpcSubnetGroupType3["PUBLIC"] = "Public";
      VpcSubnetGroupType3["PRIVATE"] = "Private";
      VpcSubnetGroupType3["ISOLATED"] = "Isolated";
      return VpcSubnetGroupType3;
    })(VpcSubnetGroupType || {});
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/ami.ts
var ami_exports = {};
var init_ami = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/ami.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/load-balancer.ts
var load_balancer_exports = {};
__export(load_balancer_exports, {
  LoadBalancerIpAddressType: () => LoadBalancerIpAddressType
});
var LoadBalancerIpAddressType;
var init_load_balancer = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/load-balancer.ts"() {
    "use strict";
    LoadBalancerIpAddressType = /* @__PURE__ */ ((LoadBalancerIpAddressType3) => {
      LoadBalancerIpAddressType3["IPV4"] = "ipv4";
      LoadBalancerIpAddressType3["DUAL_STACK"] = "dualstack";
      LoadBalancerIpAddressType3["DUAL_STACK_WITHOUT_PUBLIC_IPV4"] = "dualstack-without-public-ipv4";
      return LoadBalancerIpAddressType3;
    })(LoadBalancerIpAddressType || {});
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/availability-zones.ts
var availability_zones_exports = {};
__export(availability_zones_exports, {
  AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY: () => AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY
});
var AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY;
var init_availability_zones = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/availability-zones.ts"() {
    "use strict";
    AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = "aws:cdk:availability-zones:fallback";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/endpoint-service-availability-zones.ts
var endpoint_service_availability_zones_exports = {};
__export(endpoint_service_availability_zones_exports, {
  ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER: () => ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER
});
var ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER;
var init_endpoint_service_availability_zones = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/endpoint-service-availability-zones.ts"() {
    "use strict";
    ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/security-group.ts
var security_group_exports = {};
var init_security_group = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/security-group.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/key.ts
var key_exports = {};
var init_key = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/key.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/context/generic.ts
var generic_exports = {};
__export(generic_exports, {
  PROVIDER_ERROR_KEY: () => PROVIDER_ERROR_KEY
});
var PROVIDER_ERROR_KEY;
var init_generic = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/context/generic.ts"() {
    "use strict";
    PROVIDER_ERROR_KEY = "$providerError";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.ts
var ArtifactType;
var init_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.ts"() {
    "use strict";
    ArtifactType = /* @__PURE__ */ ((ArtifactType7) => {
      ArtifactType7["NONE"] = "none";
      ArtifactType7["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
      ArtifactType7["CDK_TREE"] = "cdk:tree";
      ArtifactType7["ASSET_MANIFEST"] = "cdk:asset-manifest";
      ArtifactType7["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
      ArtifactType7["FEATURE_FLAG_REPORT"] = "cdk:feature-flag-report";
      return ArtifactType7;
    })(ArtifactType || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.ts
var ArtifactMetadataEntryType;
var init_metadata_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.ts"() {
    "use strict";
    ArtifactMetadataEntryType = /* @__PURE__ */ ((ArtifactMetadataEntryType8) => {
      ArtifactMetadataEntryType8["ASSET"] = "aws:cdk:asset";
      ArtifactMetadataEntryType8["INFO"] = "aws:cdk:info";
      ArtifactMetadataEntryType8["WARN"] = "aws:cdk:warning";
      ArtifactMetadataEntryType8["ERROR"] = "aws:cdk:error";
      ArtifactMetadataEntryType8["LOGICAL_ID"] = "aws:cdk:logicalId";
      ArtifactMetadataEntryType8["STACK_TAGS"] = "aws:cdk:stack-tags";
      ArtifactMetadataEntryType8["DO_NOT_REFACTOR"] = "aws:cdk:do-not-refactor";
      return ArtifactMetadataEntryType8;
    })(ArtifactMetadataEntryType || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.ts
var init_artifact_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.ts
var ContextProvider, LoadBalancerType, LoadBalancerListenerProtocol;
var init_context_queries = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.ts"() {
    "use strict";
    ContextProvider = /* @__PURE__ */ ((ContextProvider3) => {
      ContextProvider3["AMI_PROVIDER"] = "ami";
      ContextProvider3["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
      ContextProvider3["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
      ContextProvider3["SSM_PARAMETER_PROVIDER"] = "ssm";
      ContextProvider3["VPC_PROVIDER"] = "vpc-provider";
      ContextProvider3["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
      ContextProvider3["LOAD_BALANCER_PROVIDER"] = "load-balancer";
      ContextProvider3["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
      ContextProvider3["SECURITY_GROUP_PROVIDER"] = "security-group";
      ContextProvider3["KEY_PROVIDER"] = "key-provider";
      ContextProvider3["CC_API_PROVIDER"] = "cc-api-provider";
      ContextProvider3["PLUGIN"] = "plugin";
      return ContextProvider3;
    })(ContextProvider || {});
    LoadBalancerType = /* @__PURE__ */ ((LoadBalancerType2) => {
      LoadBalancerType2["NETWORK"] = "network";
      LoadBalancerType2["APPLICATION"] = "application";
      return LoadBalancerType2;
    })(LoadBalancerType || {});
    LoadBalancerListenerProtocol = /* @__PURE__ */ ((LoadBalancerListenerProtocol2) => {
      LoadBalancerListenerProtocol2["HTTP"] = "HTTP";
      LoadBalancerListenerProtocol2["HTTPS"] = "HTTPS";
      LoadBalancerListenerProtocol2["TCP"] = "TCP";
      LoadBalancerListenerProtocol2["TLS"] = "TLS";
      LoadBalancerListenerProtocol2["UDP"] = "UDP";
      LoadBalancerListenerProtocol2["TCP_UDP"] = "TCP_UDP";
      return LoadBalancerListenerProtocol2;
    })(LoadBalancerListenerProtocol || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/interfaces.ts
var init_interfaces = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/interfaces.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.ts
var cloud_assembly_exports = {};
__export(cloud_assembly_exports, {
  ArtifactMetadataEntryType: () => ArtifactMetadataEntryType,
  ArtifactType: () => ArtifactType,
  ContextProvider: () => ContextProvider,
  LoadBalancerListenerProtocol: () => LoadBalancerListenerProtocol,
  LoadBalancerType: () => LoadBalancerType
});
var init_cloud_assembly = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.ts"() {
    "use strict";
    init_schema();
    init_metadata_schema();
    init_artifact_schema();
    init_context_queries();
    init_interfaces();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/schema.ts
var init_schema2 = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.ts
var init_docker_image_asset = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.ts
var FileAssetPackaging;
var init_file_asset = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.ts"() {
    "use strict";
    FileAssetPackaging = /* @__PURE__ */ ((FileAssetPackaging4) => {
      FileAssetPackaging4["FILE"] = "file";
      FileAssetPackaging4["ZIP_DIRECTORY"] = "zip";
      return FileAssetPackaging4;
    })(FileAssetPackaging || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.ts
var init_aws_destination = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/index.ts
var assets_exports = {};
__export(assets_exports, {
  FileAssetPackaging: () => FileAssetPackaging
});
var init_assets = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/index.ts"() {
    "use strict";
    init_schema2();
    init_docker_image_asset();
    init_file_asset();
    init_aws_destination();
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js
var require_helpers = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js"(exports2, module2) {
    "use strict";
    var uri = require("url");
    var ValidationError = exports2.ValidationError = /* @__PURE__ */ __name(function ValidationError2(message2, instance, schema, path44, name, argument) {
      if (Array.isArray(path44)) {
        this.path = path44;
        this.property = path44.reduce(function(sum3, item) {
          return sum3 + makeSuffix(item);
        }, "instance");
      } else if (path44 !== void 0) {
        this.property = path44;
      }
      if (message2) {
        this.message = message2;
      }
      if (schema) {
        var id = schema.$id || schema.id;
        this.schema = id || schema;
      }
      if (instance !== void 0) {
        this.instance = instance;
      }
      this.name = name;
      this.argument = argument;
      this.stack = this.toString();
    }, "ValidationError");
    ValidationError.prototype.toString = /* @__PURE__ */ __name(function toString() {
      return this.property + " " + this.message;
    }, "toString");
    var ValidatorResult = exports2.ValidatorResult = /* @__PURE__ */ __name(function ValidatorResult2(instance, schema, options, ctx) {
      this.instance = instance;
      this.schema = schema;
      this.options = options;
      this.path = ctx.path;
      this.propertyPath = ctx.propertyPath;
      this.errors = [];
      this.throwError = options && options.throwError;
      this.throwFirst = options && options.throwFirst;
      this.throwAll = options && options.throwAll;
      this.disableFormat = options && options.disableFormat === true;
    }, "ValidatorResult");
    ValidatorResult.prototype.addError = /* @__PURE__ */ __name(function addError(detail) {
      var err;
      if (typeof detail == "string") {
        err = new ValidationError(detail, this.instance, this.schema, this.path);
      } else {
        if (!detail) throw new Error("Missing error detail");
        if (!detail.message) throw new Error("Missing error message");
        if (!detail.name) throw new Error("Missing validator type");
        err = new ValidationError(detail.message, this.instance, this.schema, this.path, detail.name, detail.argument);
      }
      this.errors.push(err);
      if (this.throwFirst) {
        throw new ValidatorResultError(this);
      } else if (this.throwError) {
        throw err;
      }
      return err;
    }, "addError");
    ValidatorResult.prototype.importErrors = /* @__PURE__ */ __name(function importErrors(res) {
      if (typeof res == "string" || res && res.validatorType) {
        this.addError(res);
      } else if (res && res.errors) {
        this.errors = this.errors.concat(res.errors);
      }
    }, "importErrors");
    function stringizer(v14, i13) {
      return i13 + ": " + v14.toString() + "\n";
    }
    __name(stringizer, "stringizer");
    ValidatorResult.prototype.toString = /* @__PURE__ */ __name(function toString(res) {
      return this.errors.map(stringizer).join("");
    }, "toString");
    Object.defineProperty(ValidatorResult.prototype, "valid", { get: /* @__PURE__ */ __name(function() {
      return !this.errors.length;
    }, "get") });
    module2.exports.ValidatorResultError = ValidatorResultError;
    function ValidatorResultError(result2) {
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ValidatorResultError);
      }
      this.instance = result2.instance;
      this.schema = result2.schema;
      this.options = result2.options;
      this.errors = result2.errors;
    }
    __name(ValidatorResultError, "ValidatorResultError");
    ValidatorResultError.prototype = new Error();
    ValidatorResultError.prototype.constructor = ValidatorResultError;
    ValidatorResultError.prototype.name = "Validation Error";
    var SchemaError = exports2.SchemaError = /* @__PURE__ */ __name(function SchemaError2(msg, schema) {
      this.message = msg;
      this.schema = schema;
      Error.call(this, msg);
      Error.captureStackTrace(this, SchemaError2);
    }, "SchemaError");
    SchemaError.prototype = Object.create(
      Error.prototype,
      {
        constructor: { value: SchemaError, enumerable: false },
        name: { value: "SchemaError", enumerable: false }
      }
    );
    var SchemaContext = exports2.SchemaContext = /* @__PURE__ */ __name(function SchemaContext2(schema, options, path44, base, schemas) {
      this.schema = schema;
      this.options = options;
      if (Array.isArray(path44)) {
        this.path = path44;
        this.propertyPath = path44.reduce(function(sum3, item) {
          return sum3 + makeSuffix(item);
        }, "instance");
      } else {
        this.propertyPath = path44;
      }
      this.base = base;
      this.schemas = schemas;
    }, "SchemaContext");
    SchemaContext.prototype.resolve = /* @__PURE__ */ __name(function resolve16(target) {
      return uri.resolve(this.base, target);
    }, "resolve");
    SchemaContext.prototype.makeChild = /* @__PURE__ */ __name(function makeChild(schema, propertyName) {
      var path44 = propertyName === void 0 ? this.path : this.path.concat([propertyName]);
      var id = schema.$id || schema.id;
      var base = uri.resolve(this.base, id || "");
      var ctx = new SchemaContext(schema, this.options, path44, base, Object.create(this.schemas));
      if (id && !ctx.schemas[base]) {
        ctx.schemas[base] = schema;
      }
      return ctx;
    }, "makeChild");
    var FORMAT_REGEXPS = exports2.FORMAT_REGEXPS = {
      // 7.3.1. Dates, Times, and Duration
      "date-time": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,
      "date": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,
      "time": /^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,
      "duration": /P(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S)|\d+(D|M(\d+D)?|Y(\d+M(\d+D)?)?)(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S))?|\d+W)/i,
      // 7.3.2. Email Addresses
      // TODO: fix the email production
      "email": /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,
      "idn-email": /^("(?:[!#-\[\]-\u{10FFFF}]|\\[\t -\u{10FFFF}])*"|[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*)@([!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*|\[[!-Z\^-\u{10FFFF}]*\])$/u,
      // 7.3.3. Hostnames
      // 7.3.4. IP Addresses
      "ip-address": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      // FIXME whitespace is invalid
      "ipv6": /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,
      // 7.3.5. Resource Identifiers
      // TODO: A more accurate regular expression for "uri" goes:
      // [A-Za-z][+\-.0-9A-Za-z]*:((/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?)?#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])|/?%[0-9A-Fa-f]{2}|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*(#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?)?
      "uri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "uri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,
      "iri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "iri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~-\u{10FFFF}]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~-\u{10FFFF}])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/u,
      "uuid": /^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i,
      // 7.3.6. uri-template
      "uri-template": /(%[0-9a-f]{2}|[!#$&(-;=?@\[\]_a-z~]|\{[!#&+,./;=?@|]?(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?(,(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?)*\})*/iu,
      // 7.3.7. JSON Pointers
      "json-pointer": /^(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*$/iu,
      "relative-json-pointer": /^\d+(#|(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*)$/iu,
      // hostname regex from: http://stackoverflow.com/a/1420225/5628
      "hostname": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "host-name": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "utc-millisec": /* @__PURE__ */ __name(function(input) {
        return typeof input === "string" && parseFloat(input) === parseInt(input, 10) && !isNaN(input);
      }, "utc-millisec"),
      // 7.3.8. regex
      "regex": /* @__PURE__ */ __name(function(input) {
        var result2 = true;
        try {
          new RegExp(input);
        } catch (e13) {
          result2 = false;
        }
        return result2;
      }, "regex"),
      // Other definitions
      // "style" was removed from JSON Schema in draft-4 and is deprecated
      "style": /[\r\n\t ]*[^\r\n\t ][^:]*:[\r\n\t ]*[^\r\n\t ;]*[\r\n\t ]*;?/,
      // "color" was removed from JSON Schema in draft-4 and is deprecated
      "color": /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,
      "phone": /^\+(?:[0-9] ?){6,14}[0-9]$/,
      "alpha": /^[a-zA-Z]+$/,
      "alphanumeric": /^[a-zA-Z0-9]+$/
    };
    FORMAT_REGEXPS.regexp = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.pattern = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.ipv4 = FORMAT_REGEXPS["ip-address"];
    exports2.isFormat = /* @__PURE__ */ __name(function isFormat(input, format28, validator) {
      if (typeof input === "string" && FORMAT_REGEXPS[format28] !== void 0) {
        if (FORMAT_REGEXPS[format28] instanceof RegExp) {
          return FORMAT_REGEXPS[format28].test(input);
        }
        if (typeof FORMAT_REGEXPS[format28] === "function") {
          return FORMAT_REGEXPS[format28](input);
        }
      } else if (validator && validator.customFormats && typeof validator.customFormats[format28] === "function") {
        return validator.customFormats[format28](input);
      }
      return true;
    }, "isFormat");
    var makeSuffix = exports2.makeSuffix = /* @__PURE__ */ __name(function makeSuffix2(key) {
      key = key.toString();
      if (!key.match(/[.\s\[\]]/) && !key.match(/^[\d]/)) {
        return "." + key;
      }
      if (key.match(/^\d+$/)) {
        return "[" + key + "]";
      }
      return "[" + JSON.stringify(key) + "]";
    }, "makeSuffix");
    exports2.deepCompareStrict = /* @__PURE__ */ __name(function deepCompareStrict(a13, b13) {
      if (typeof a13 !== typeof b13) {
        return false;
      }
      if (Array.isArray(a13)) {
        if (!Array.isArray(b13)) {
          return false;
        }
        if (a13.length !== b13.length) {
          return false;
        }
        return a13.every(function(v14, i13) {
          return deepCompareStrict(a13[i13], b13[i13]);
        });
      }
      if (typeof a13 === "object") {
        if (!a13 || !b13) {
          return a13 === b13;
        }
        var aKeys = Object.keys(a13);
        var bKeys = Object.keys(b13);
        if (aKeys.length !== bKeys.length) {
          return false;
        }
        return aKeys.every(function(v14) {
          return deepCompareStrict(a13[v14], b13[v14]);
        });
      }
      return a13 === b13;
    }, "deepCompareStrict");
    function deepMerger(target, dst, e13, i13) {
      if (typeof e13 === "object") {
        dst[i13] = deepMerge2(target[i13], e13);
      } else {
        if (target.indexOf(e13) === -1) {
          dst.push(e13);
        }
      }
    }
    __name(deepMerger, "deepMerger");
    function copyist(src, dst, key) {
      dst[key] = src[key];
    }
    __name(copyist, "copyist");
    function copyistWithDeepMerge(target, src, dst, key) {
      if (typeof src[key] !== "object" || !src[key]) {
        dst[key] = src[key];
      } else {
        if (!target[key]) {
          dst[key] = src[key];
        } else {
          dst[key] = deepMerge2(target[key], src[key]);
        }
      }
    }
    __name(copyistWithDeepMerge, "copyistWithDeepMerge");
    function deepMerge2(target, src) {
      var array = Array.isArray(src);
      var dst = array && [] || {};
      if (array) {
        target = target || [];
        dst = dst.concat(target);
        src.forEach(deepMerger.bind(null, target, dst));
      } else {
        if (target && typeof target === "object") {
          Object.keys(target).forEach(copyist.bind(null, target, dst));
        }
        Object.keys(src).forEach(copyistWithDeepMerge.bind(null, target, src, dst));
      }
      return dst;
    }
    __name(deepMerge2, "deepMerge");
    module2.exports.deepMerge = deepMerge2;
    exports2.objectGetPath = /* @__PURE__ */ __name(function objectGetPath(o13, s13) {
      var parts = s13.split("/").slice(1);
      var k13;
      while (typeof (k13 = parts.shift()) == "string") {
        var n13 = decodeURIComponent(k13.replace(/~0/, "~").replace(/~1/g, "/"));
        if (!(n13 in o13)) return;
        o13 = o13[n13];
      }
      return o13;
    }, "objectGetPath");
    function pathEncoder(v14) {
      return "/" + encodeURIComponent(v14).replace(/~/g, "%7E");
    }
    __name(pathEncoder, "pathEncoder");
    exports2.encodePath = /* @__PURE__ */ __name(function encodePointer(a13) {
      return a13.map(pathEncoder).join("");
    }, "encodePointer");
    exports2.getDecimalPlaces = /* @__PURE__ */ __name(function getDecimalPlaces(number) {
      var decimalPlaces = 0;
      if (isNaN(number)) return decimalPlaces;
      if (typeof number !== "number") {
        number = Number(number);
      }
      var parts = number.toString().split("e");
      if (parts.length === 2) {
        if (parts[1][0] !== "-") {
          return decimalPlaces;
        } else {
          decimalPlaces = Number(parts[1].slice(1));
        }
      }
      var decimalParts = parts[0].split(".");
      if (decimalParts.length === 2) {
        decimalPlaces += decimalParts[1].length;
      }
      return decimalPlaces;
    }, "getDecimalPlaces");
    exports2.isSchema = /* @__PURE__ */ __name(function isSchema(val) {
      return typeof val === "object" && val || typeof val === "boolean";
    }, "isSchema");
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js
var require_attribute = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js"(exports2, module2) {
    "use strict";
    var helpers = require_helpers();
    var ValidatorResult = helpers.ValidatorResult;
    var SchemaError = helpers.SchemaError;
    var attribute = {};
    attribute.ignoreProperties = {
      // informative properties
      "id": true,
      "default": true,
      "description": true,
      "title": true,
      // arguments to other properties
      "additionalItems": true,
      "then": true,
      "else": true,
      // special-handled properties
      "$schema": true,
      "$ref": true,
      "extends": true
    };
    var validators = attribute.validators = {};
    validators.type = /* @__PURE__ */ __name(function validateType(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var types5 = Array.isArray(schema.type) ? schema.type : [schema.type];
      if (!types5.some(this.testType.bind(this, instance, schema, options, ctx))) {
        var list2 = types5.map(function(v14) {
          if (!v14) return;
          var id = v14.$id || v14.id;
          return id ? "<" + id + ">" : v14 + "";
        });
        result2.addError({
          name: "type",
          argument: list2,
          message: "is not of a type(s) " + list2
        });
      }
      return result2;
    }, "validateType");
    function testSchemaNoThrow(instance, options, ctx, callback, schema) {
      var throwError = options.throwError;
      var throwAll = options.throwAll;
      options.throwError = false;
      options.throwAll = false;
      var res = this.validateSchema(instance, schema, options, ctx);
      options.throwError = throwError;
      options.throwAll = throwAll;
      if (!res.valid && callback instanceof Function) {
        callback(res);
      }
      return res.valid;
    }
    __name(testSchemaNoThrow, "testSchemaNoThrow");
    validators.anyOf = /* @__PURE__ */ __name(function validateAnyOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      if (!Array.isArray(schema.anyOf)) {
        throw new SchemaError("anyOf must be an array");
      }
      if (!schema.anyOf.some(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      )) {
        var list2 = schema.anyOf.map(function(v14, i13) {
          var id = v14.$id || v14.id;
          if (id) return "<" + id + ">";
          return v14.title && JSON.stringify(v14.title) || v14["$ref"] && "<" + v14["$ref"] + ">" || "[subschema " + i13 + "]";
        });
        if (options.nestedErrors) {
          result2.importErrors(inner);
        }
        result2.addError({
          name: "anyOf",
          argument: list2,
          message: "is not any of " + list2.join(",")
        });
      }
      return result2;
    }, "validateAnyOf");
    validators.allOf = /* @__PURE__ */ __name(function validateAllOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.allOf)) {
        throw new SchemaError("allOf must be an array");
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var self2 = this;
      schema.allOf.forEach(function(v14, i13) {
        var valid3 = self2.validateSchema(instance, v14, options, ctx);
        if (!valid3.valid) {
          var id = v14.$id || v14.id;
          var msg = id || v14.title && JSON.stringify(v14.title) || v14["$ref"] && "<" + v14["$ref"] + ">" || "[subschema " + i13 + "]";
          result2.addError({
            name: "allOf",
            argument: { id: msg, length: valid3.errors.length, valid: valid3 },
            message: "does not match allOf schema " + msg + " with " + valid3.errors.length + " error[s]:"
          });
          result2.importErrors(valid3);
        }
      });
      return result2;
    }, "validateAllOf");
    validators.oneOf = /* @__PURE__ */ __name(function validateOneOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.oneOf)) {
        throw new SchemaError("oneOf must be an array");
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      var count = schema.oneOf.filter(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      ).length;
      var list2 = schema.oneOf.map(function(v14, i13) {
        var id = v14.$id || v14.id;
        return id || v14.title && JSON.stringify(v14.title) || v14["$ref"] && "<" + v14["$ref"] + ">" || "[subschema " + i13 + "]";
      });
      if (count !== 1) {
        if (options.nestedErrors) {
          result2.importErrors(inner);
        }
        result2.addError({
          name: "oneOf",
          argument: list2,
          message: "is not exactly one from " + list2.join(",")
        });
      }
      return result2;
    }, "validateOneOf");
    validators.if = /* @__PURE__ */ __name(function validateIf(instance, schema, options, ctx) {
      if (instance === void 0) return null;
      if (!helpers.isSchema(schema.if)) throw new Error('Expected "if" keyword to be a schema');
      var ifValid = testSchemaNoThrow.call(this, instance, options, ctx, null, schema.if);
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var res;
      if (ifValid) {
        if (schema.then === void 0) return;
        if (!helpers.isSchema(schema.then)) throw new Error('Expected "then" keyword to be a schema');
        res = this.validateSchema(instance, schema.then, options, ctx.makeChild(schema.then));
        result2.importErrors(res);
      } else {
        if (schema.else === void 0) return;
        if (!helpers.isSchema(schema.else)) throw new Error('Expected "else" keyword to be a schema');
        res = this.validateSchema(instance, schema.else, options, ctx.makeChild(schema.else));
        result2.importErrors(res);
      }
      return result2;
    }, "validateIf");
    function getEnumerableProperty(object, key) {
      if (Object.hasOwnProperty.call(object, key)) return object[key];
      if (!(key in object)) return;
      while (object = Object.getPrototypeOf(object)) {
        if (Object.propertyIsEnumerable.call(object, key)) return object[key];
      }
    }
    __name(getEnumerableProperty, "getEnumerableProperty");
    validators.propertyNames = /* @__PURE__ */ __name(function validatePropertyNames(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var subschema = schema.propertyNames !== void 0 ? schema.propertyNames : {};
      if (!helpers.isSchema(subschema)) throw new SchemaError('Expected "propertyNames" to be a schema (object or boolean)');
      for (var property in instance) {
        if (getEnumerableProperty(instance, property) !== void 0) {
          var res = this.validateSchema(property, subschema, options, ctx.makeChild(subschema));
          result2.importErrors(res);
        }
      }
      return result2;
    }, "validatePropertyNames");
    validators.properties = /* @__PURE__ */ __name(function validateProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var properties = schema.properties || {};
      for (var property in properties) {
        var subschema = properties[property];
        if (subschema === void 0) {
          continue;
        } else if (subschema === null) {
          throw new SchemaError('Unexpected null, expected schema in "properties"');
        }
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, subschema, options, ctx);
        }
        var prop = getEnumerableProperty(instance, property);
        var res = this.validateSchema(prop, subschema, options, ctx.makeChild(subschema, property));
        if (res.instance !== result2.instance[property]) result2.instance[property] = res.instance;
        result2.importErrors(res);
      }
      return result2;
    }, "validateProperties");
    function testAdditionalProperty(instance, schema, options, ctx, property, result2) {
      if (!this.types.object(instance)) return;
      if (schema.properties && schema.properties[property] !== void 0) {
        return;
      }
      if (schema.additionalProperties === false) {
        result2.addError({
          name: "additionalProperties",
          argument: property,
          message: "is not allowed to have the additional property " + JSON.stringify(property)
        });
      } else {
        var additionalProperties = schema.additionalProperties || {};
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, additionalProperties, options, ctx);
        }
        var res = this.validateSchema(instance[property], additionalProperties, options, ctx.makeChild(additionalProperties, property));
        if (res.instance !== result2.instance[property]) result2.instance[property] = res.instance;
        result2.importErrors(res);
      }
    }
    __name(testAdditionalProperty, "testAdditionalProperty");
    validators.patternProperties = /* @__PURE__ */ __name(function validatePatternProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var patternProperties = schema.patternProperties || {};
      for (var property in instance) {
        var test = true;
        for (var pattern in patternProperties) {
          var subschema = patternProperties[pattern];
          if (subschema === void 0) {
            continue;
          } else if (subschema === null) {
            throw new SchemaError('Unexpected null, expected schema in "patternProperties"');
          }
          try {
            var regexp = new RegExp(pattern, "u");
          } catch (_e13) {
            regexp = new RegExp(pattern);
          }
          if (!regexp.test(property)) {
            continue;
          }
          test = false;
          if (typeof options.preValidateProperty == "function") {
            options.preValidateProperty(instance, property, subschema, options, ctx);
          }
          var res = this.validateSchema(instance[property], subschema, options, ctx.makeChild(subschema, property));
          if (res.instance !== result2.instance[property]) result2.instance[property] = res.instance;
          result2.importErrors(res);
        }
        if (test) {
          testAdditionalProperty.call(this, instance, schema, options, ctx, property, result2);
        }
      }
      return result2;
    }, "validatePatternProperties");
    validators.additionalProperties = /* @__PURE__ */ __name(function validateAdditionalProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      if (schema.patternProperties) {
        return null;
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      for (var property in instance) {
        testAdditionalProperty.call(this, instance, schema, options, ctx, property, result2);
      }
      return result2;
    }, "validateAdditionalProperties");
    validators.minProperties = /* @__PURE__ */ __name(function validateMinProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length >= schema.minProperties)) {
        result2.addError({
          name: "minProperties",
          argument: schema.minProperties,
          message: "does not meet minimum property length of " + schema.minProperties
        });
      }
      return result2;
    }, "validateMinProperties");
    validators.maxProperties = /* @__PURE__ */ __name(function validateMaxProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length <= schema.maxProperties)) {
        result2.addError({
          name: "maxProperties",
          argument: schema.maxProperties,
          message: "does not meet maximum property length of " + schema.maxProperties
        });
      }
      return result2;
    }, "validateMaxProperties");
    validators.items = /* @__PURE__ */ __name(function validateItems(instance, schema, options, ctx) {
      var self2 = this;
      if (!this.types.array(instance)) return;
      if (schema.items === void 0) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      instance.every(function(value, i13) {
        if (Array.isArray(schema.items)) {
          var items = schema.items[i13] === void 0 ? schema.additionalItems : schema.items[i13];
        } else {
          var items = schema.items;
        }
        if (items === void 0) {
          return true;
        }
        if (items === false) {
          result2.addError({
            name: "items",
            message: "additionalItems not permitted"
          });
          return false;
        }
        var res = self2.validateSchema(value, items, options, ctx.makeChild(items, i13));
        if (res.instance !== result2.instance[i13]) result2.instance[i13] = res.instance;
        result2.importErrors(res);
        return true;
      });
      return result2;
    }, "validateItems");
    validators.contains = /* @__PURE__ */ __name(function validateContains(instance, schema, options, ctx) {
      var self2 = this;
      if (!this.types.array(instance)) return;
      if (schema.contains === void 0) return;
      if (!helpers.isSchema(schema.contains)) throw new Error('Expected "contains" keyword to be a schema');
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var count = instance.some(function(value, i13) {
        var res = self2.validateSchema(value, schema.contains, options, ctx.makeChild(schema.contains, i13));
        return res.errors.length === 0;
      });
      if (count === false) {
        result2.addError({
          name: "contains",
          argument: schema.contains,
          message: "must contain an item matching given schema"
        });
      }
      return result2;
    }, "validateContains");
    validators.minimum = /* @__PURE__ */ __name(function validateMinimum(instance, schema, options, ctx) {
      if (!this.types.number(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMinimum && schema.exclusiveMinimum === true) {
        if (!(instance > schema.minimum)) {
          result2.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than " + schema.minimum
          });
        }
      } else {
        if (!(instance >= schema.minimum)) {
          result2.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than or equal to " + schema.minimum
          });
        }
      }
      return result2;
    }, "validateMinimum");
    validators.maximum = /* @__PURE__ */ __name(function validateMaximum(instance, schema, options, ctx) {
      if (!this.types.number(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMaximum && schema.exclusiveMaximum === true) {
        if (!(instance < schema.maximum)) {
          result2.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than " + schema.maximum
          });
        }
      } else {
        if (!(instance <= schema.maximum)) {
          result2.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than or equal to " + schema.maximum
          });
        }
      }
      return result2;
    }, "validateMaximum");
    validators.exclusiveMinimum = /* @__PURE__ */ __name(function validateExclusiveMinimum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMinimum === "boolean") return;
      if (!this.types.number(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var valid3 = instance > schema.exclusiveMinimum;
      if (!valid3) {
        result2.addError({
          name: "exclusiveMinimum",
          argument: schema.exclusiveMinimum,
          message: "must be strictly greater than " + schema.exclusiveMinimum
        });
      }
      return result2;
    }, "validateExclusiveMinimum");
    validators.exclusiveMaximum = /* @__PURE__ */ __name(function validateExclusiveMaximum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean") return;
      if (!this.types.number(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var valid3 = instance < schema.exclusiveMaximum;
      if (!valid3) {
        result2.addError({
          name: "exclusiveMaximum",
          argument: schema.exclusiveMaximum,
          message: "must be strictly less than " + schema.exclusiveMaximum
        });
      }
      return result2;
    }, "validateExclusiveMaximum");
    var validateMultipleOfOrDivisbleBy = /* @__PURE__ */ __name(function validateMultipleOfOrDivisbleBy2(instance, schema, options, ctx, validationType, errorMessage) {
      if (!this.types.number(instance)) return;
      var validationArgument = schema[validationType];
      if (validationArgument == 0) {
        throw new SchemaError(validationType + " cannot be zero");
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var instanceDecimals = helpers.getDecimalPlaces(instance);
      var divisorDecimals = helpers.getDecimalPlaces(validationArgument);
      var maxDecimals = Math.max(instanceDecimals, divisorDecimals);
      var multiplier = Math.pow(10, maxDecimals);
      if (Math.round(instance * multiplier) % Math.round(validationArgument * multiplier) !== 0) {
        result2.addError({
          name: validationType,
          argument: validationArgument,
          message: errorMessage + JSON.stringify(validationArgument)
        });
      }
      return result2;
    }, "validateMultipleOfOrDivisbleBy");
    validators.multipleOf = /* @__PURE__ */ __name(function validateMultipleOf(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "multipleOf", "is not a multiple of (divisible by) ");
    }, "validateMultipleOf");
    validators.divisibleBy = /* @__PURE__ */ __name(function validateDivisibleBy(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "divisibleBy", "is not divisible by (multiple of) ");
    }, "validateDivisibleBy");
    validators.required = /* @__PURE__ */ __name(function validateRequired(instance, schema, options, ctx) {
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (instance === void 0 && schema.required === true) {
        result2.addError({
          name: "required",
          message: "is required"
        });
      } else if (this.types.object(instance) && Array.isArray(schema.required)) {
        schema.required.forEach(function(n13) {
          if (getEnumerableProperty(instance, n13) === void 0) {
            result2.addError({
              name: "required",
              argument: n13,
              message: "requires property " + JSON.stringify(n13)
            });
          }
        });
      }
      return result2;
    }, "validateRequired");
    validators.pattern = /* @__PURE__ */ __name(function validatePattern(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var pattern = schema.pattern;
      try {
        var regexp = new RegExp(pattern, "u");
      } catch (_e13) {
        regexp = new RegExp(pattern);
      }
      if (!instance.match(regexp)) {
        result2.addError({
          name: "pattern",
          argument: schema.pattern,
          message: "does not match pattern " + JSON.stringify(schema.pattern.toString())
        });
      }
      return result2;
    }, "validatePattern");
    validators.format = /* @__PURE__ */ __name(function validateFormat(instance, schema, options, ctx) {
      if (instance === void 0) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!result2.disableFormat && !helpers.isFormat(instance, schema.format, this)) {
        result2.addError({
          name: "format",
          argument: schema.format,
          message: "does not conform to the " + JSON.stringify(schema.format) + " format"
        });
      }
      return result2;
    }, "validateFormat");
    validators.minLength = /* @__PURE__ */ __name(function validateMinLength(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length >= schema.minLength)) {
        result2.addError({
          name: "minLength",
          argument: schema.minLength,
          message: "does not meet minimum length of " + schema.minLength
        });
      }
      return result2;
    }, "validateMinLength");
    validators.maxLength = /* @__PURE__ */ __name(function validateMaxLength(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length <= schema.maxLength)) {
        result2.addError({
          name: "maxLength",
          argument: schema.maxLength,
          message: "does not meet maximum length of " + schema.maxLength
        });
      }
      return result2;
    }, "validateMaxLength");
    validators.minItems = /* @__PURE__ */ __name(function validateMinItems(instance, schema, options, ctx) {
      if (!this.types.array(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length >= schema.minItems)) {
        result2.addError({
          name: "minItems",
          argument: schema.minItems,
          message: "does not meet minimum length of " + schema.minItems
        });
      }
      return result2;
    }, "validateMinItems");
    validators.maxItems = /* @__PURE__ */ __name(function validateMaxItems(instance, schema, options, ctx) {
      if (!this.types.array(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length <= schema.maxItems)) {
        result2.addError({
          name: "maxItems",
          argument: schema.maxItems,
          message: "does not meet maximum length of " + schema.maxItems
        });
      }
      return result2;
    }, "validateMaxItems");
    function testArrays(v14, i13, a13) {
      var j13, len = a13.length;
      for (j13 = i13 + 1, len; j13 < len; j13++) {
        if (helpers.deepCompareStrict(v14, a13[j13])) {
          return false;
        }
      }
      return true;
    }
    __name(testArrays, "testArrays");
    validators.uniqueItems = /* @__PURE__ */ __name(function validateUniqueItems(instance, schema, options, ctx) {
      if (schema.uniqueItems !== true) return;
      if (!this.types.array(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!instance.every(testArrays)) {
        result2.addError({
          name: "uniqueItems",
          message: "contains duplicate item"
        });
      }
      return result2;
    }, "validateUniqueItems");
    validators.dependencies = /* @__PURE__ */ __name(function validateDependencies(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      for (var property in schema.dependencies) {
        if (instance[property] === void 0) {
          continue;
        }
        var dep = schema.dependencies[property];
        var childContext = ctx.makeChild(dep, property);
        if (typeof dep == "string") {
          dep = [dep];
        }
        if (Array.isArray(dep)) {
          dep.forEach(function(prop) {
            if (instance[prop] === void 0) {
              result2.addError({
                // FIXME there's two different "dependencies" errors here with slightly different outputs
                // Can we make these the same? Or should we create different error types?
                name: "dependencies",
                argument: childContext.propertyPath,
                message: "property " + prop + " not found, required by " + childContext.propertyPath
              });
            }
          });
        } else {
          var res = this.validateSchema(instance, dep, options, childContext);
          if (result2.instance !== res.instance) result2.instance = res.instance;
          if (res && res.errors.length) {
            result2.addError({
              name: "dependencies",
              argument: childContext.propertyPath,
              message: "does not meet dependency required by " + childContext.propertyPath
            });
            result2.importErrors(res);
          }
        }
      }
      return result2;
    }, "validateDependencies");
    validators["enum"] = /* @__PURE__ */ __name(function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema["enum"])) {
        throw new SchemaError("enum expects an array", schema);
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!schema["enum"].some(helpers.deepCompareStrict.bind(null, instance))) {
        result2.addError({
          name: "enum",
          argument: schema["enum"],
          message: "is not one of enum values: " + schema["enum"].map(String).join(",")
        });
      }
      return result2;
    }, "validateEnum");
    validators["const"] = /* @__PURE__ */ __name(function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (!helpers.deepCompareStrict(schema["const"], instance)) {
        result2.addError({
          name: "const",
          argument: schema["const"],
          message: "does not exactly match expected constant: " + schema["const"]
        });
      }
      return result2;
    }, "validateEnum");
    validators.not = validators.disallow = /* @__PURE__ */ __name(function validateNot(instance, schema, options, ctx) {
      var self2 = this;
      if (instance === void 0) return null;
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      var notTypes = schema.not || schema.disallow;
      if (!notTypes) return null;
      if (!Array.isArray(notTypes)) notTypes = [notTypes];
      notTypes.forEach(function(type) {
        if (self2.testType(instance, schema, options, ctx, type)) {
          var id = type && (type.$id || type.id);
          var schemaId = id || type;
          result2.addError({
            name: "not",
            argument: schemaId,
            message: "is of prohibited type " + schemaId
          });
        }
      });
      return result2;
    }, "validateNot");
    module2.exports = attribute;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js
var require_scan = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js"(exports2, module2) {
    "use strict";
    var urilib = require("url");
    var helpers = require_helpers();
    module2.exports.SchemaScanResult = SchemaScanResult;
    function SchemaScanResult(found, ref) {
      this.id = found;
      this.ref = ref;
    }
    __name(SchemaScanResult, "SchemaScanResult");
    module2.exports.scan = /* @__PURE__ */ __name(function scan(base, schema) {
      function scanSchema(baseuri, schema2) {
        if (!schema2 || typeof schema2 != "object") return;
        if (schema2.$ref) {
          var resolvedUri = urilib.resolve(baseuri, schema2.$ref);
          ref[resolvedUri] = ref[resolvedUri] ? ref[resolvedUri] + 1 : 0;
          return;
        }
        var id = schema2.$id || schema2.id;
        var ourBase = id ? urilib.resolve(baseuri, id) : baseuri;
        if (ourBase) {
          if (ourBase.indexOf("#") < 0) ourBase += "#";
          if (found[ourBase]) {
            if (!helpers.deepCompareStrict(found[ourBase], schema2)) {
              throw new Error("Schema <" + ourBase + "> already exists with different definition");
            }
            return found[ourBase];
          }
          found[ourBase] = schema2;
          if (ourBase[ourBase.length - 1] == "#") {
            found[ourBase.substring(0, ourBase.length - 1)] = schema2;
          }
        }
        scanArray(ourBase + "/items", Array.isArray(schema2.items) ? schema2.items : [schema2.items]);
        scanArray(ourBase + "/extends", Array.isArray(schema2.extends) ? schema2.extends : [schema2.extends]);
        scanSchema(ourBase + "/additionalItems", schema2.additionalItems);
        scanObject(ourBase + "/properties", schema2.properties);
        scanSchema(ourBase + "/additionalProperties", schema2.additionalProperties);
        scanObject(ourBase + "/definitions", schema2.definitions);
        scanObject(ourBase + "/patternProperties", schema2.patternProperties);
        scanObject(ourBase + "/dependencies", schema2.dependencies);
        scanArray(ourBase + "/disallow", schema2.disallow);
        scanArray(ourBase + "/allOf", schema2.allOf);
        scanArray(ourBase + "/anyOf", schema2.anyOf);
        scanArray(ourBase + "/oneOf", schema2.oneOf);
        scanSchema(ourBase + "/not", schema2.not);
      }
      __name(scanSchema, "scanSchema");
      function scanArray(baseuri, schemas) {
        if (!Array.isArray(schemas)) return;
        for (var i13 = 0; i13 < schemas.length; i13++) {
          scanSchema(baseuri + "/" + i13, schemas[i13]);
        }
      }
      __name(scanArray, "scanArray");
      function scanObject(baseuri, schemas) {
        if (!schemas || typeof schemas != "object") return;
        for (var p13 in schemas) {
          scanSchema(baseuri + "/" + p13, schemas[p13]);
        }
      }
      __name(scanObject, "scanObject");
      var found = {};
      var ref = {};
      scanSchema(base, schema);
      return new SchemaScanResult(found, ref);
    }, "scan");
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js
var require_validator = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js"(exports2, module2) {
    "use strict";
    var urilib = require("url");
    var attribute = require_attribute();
    var helpers = require_helpers();
    var scanSchema = require_scan().scan;
    var ValidatorResult = helpers.ValidatorResult;
    var ValidatorResultError = helpers.ValidatorResultError;
    var SchemaError = helpers.SchemaError;
    var SchemaContext = helpers.SchemaContext;
    var anonymousBase = "/";
    var Validator2 = /* @__PURE__ */ __name(function Validator3() {
      this.customFormats = Object.create(Validator3.prototype.customFormats);
      this.schemas = {};
      this.unresolvedRefs = [];
      this.types = Object.create(types5);
      this.attributes = Object.create(attribute.validators);
    }, "Validator");
    Validator2.prototype.customFormats = {};
    Validator2.prototype.schemas = null;
    Validator2.prototype.types = null;
    Validator2.prototype.attributes = null;
    Validator2.prototype.unresolvedRefs = null;
    Validator2.prototype.addSchema = /* @__PURE__ */ __name(function addSchema(schema, base) {
      var self2 = this;
      if (!schema) {
        return null;
      }
      var scan = scanSchema(base || anonymousBase, schema);
      var ourUri = base || schema.$id || schema.id;
      for (var uri in scan.id) {
        this.schemas[uri] = scan.id[uri];
      }
      for (var uri in scan.ref) {
        this.unresolvedRefs.push(uri);
      }
      this.unresolvedRefs = this.unresolvedRefs.filter(function(uri2) {
        return typeof self2.schemas[uri2] === "undefined";
      });
      return this.schemas[ourUri];
    }, "addSchema");
    Validator2.prototype.addSubSchemaArray = /* @__PURE__ */ __name(function addSubSchemaArray(baseuri, schemas) {
      if (!Array.isArray(schemas)) return;
      for (var i13 = 0; i13 < schemas.length; i13++) {
        this.addSubSchema(baseuri, schemas[i13]);
      }
    }, "addSubSchemaArray");
    Validator2.prototype.addSubSchemaObject = /* @__PURE__ */ __name(function addSubSchemaArray(baseuri, schemas) {
      if (!schemas || typeof schemas != "object") return;
      for (var p13 in schemas) {
        this.addSubSchema(baseuri, schemas[p13]);
      }
    }, "addSubSchemaArray");
    Validator2.prototype.setSchemas = /* @__PURE__ */ __name(function setSchemas(schemas) {
      this.schemas = schemas;
    }, "setSchemas");
    Validator2.prototype.getSchema = /* @__PURE__ */ __name(function getSchema(urn) {
      return this.schemas[urn];
    }, "getSchema");
    Validator2.prototype.validate = /* @__PURE__ */ __name(function validate(instance, schema, options, ctx) {
      if (typeof schema !== "boolean" && typeof schema !== "object" || schema === null) {
        throw new SchemaError("Expected `schema` to be an object or boolean");
      }
      if (!options) {
        options = {};
      }
      var id = schema.$id || schema.id;
      var base = urilib.resolve(options.base || anonymousBase, id || "");
      if (!ctx) {
        ctx = new SchemaContext(schema, options, [], base, Object.create(this.schemas));
        if (!ctx.schemas[base]) {
          ctx.schemas[base] = schema;
        }
        var found = scanSchema(base, schema);
        for (var n13 in found.id) {
          var sch = found.id[n13];
          ctx.schemas[n13] = sch;
        }
      }
      if (options.required && instance === void 0) {
        var result2 = new ValidatorResult(instance, schema, options, ctx);
        result2.addError("is required, but is undefined");
        return result2;
      }
      var result2 = this.validateSchema(instance, schema, options, ctx);
      if (!result2) {
        throw new Error("Result undefined");
      } else if (options.throwAll && result2.errors.length) {
        throw new ValidatorResultError(result2);
      }
      return result2;
    }, "validate");
    function shouldResolve(schema) {
      var ref = typeof schema === "string" ? schema : schema.$ref;
      if (typeof ref == "string") return ref;
      return false;
    }
    __name(shouldResolve, "shouldResolve");
    Validator2.prototype.validateSchema = /* @__PURE__ */ __name(function validateSchema(instance, schema, options, ctx) {
      var result2 = new ValidatorResult(instance, schema, options, ctx);
      if (typeof schema === "boolean") {
        if (schema === true) {
          schema = {};
        } else if (schema === false) {
          schema = { type: [] };
        }
      } else if (!schema) {
        throw new Error("schema is undefined");
      }
      if (schema["extends"]) {
        if (Array.isArray(schema["extends"])) {
          var schemaobj = { schema, ctx };
          schema["extends"].forEach(this.schemaTraverser.bind(this, schemaobj));
          schema = schemaobj.schema;
          schemaobj.schema = null;
          schemaobj.ctx = null;
          schemaobj = null;
        } else {
          schema = helpers.deepMerge(schema, this.superResolve(schema["extends"], ctx));
        }
      }
      var switchSchema = shouldResolve(schema);
      if (switchSchema) {
        var resolved = this.resolve(schema, switchSchema, ctx);
        var subctx = new SchemaContext(resolved.subschema, options, ctx.path, resolved.switchSchema, ctx.schemas);
        return this.validateSchema(instance, resolved.subschema, options, subctx);
      }
      var skipAttributes = options && options.skipAttributes || [];
      for (var key in schema) {
        if (!attribute.ignoreProperties[key] && skipAttributes.indexOf(key) < 0) {
          var validatorErr = null;
          var validator = this.attributes[key];
          if (validator) {
            validatorErr = validator.call(this, instance, schema, options, ctx);
          } else if (options.allowUnknownAttributes === false) {
            throw new SchemaError("Unsupported attribute: " + key, schema);
          }
          if (validatorErr) {
            result2.importErrors(validatorErr);
          }
        }
      }
      if (typeof options.rewrite == "function") {
        var value = options.rewrite.call(this, instance, schema, options, ctx);
        result2.instance = value;
      }
      return result2;
    }, "validateSchema");
    Validator2.prototype.schemaTraverser = /* @__PURE__ */ __name(function schemaTraverser(schemaobj, s13) {
      schemaobj.schema = helpers.deepMerge(schemaobj.schema, this.superResolve(s13, schemaobj.ctx));
    }, "schemaTraverser");
    Validator2.prototype.superResolve = /* @__PURE__ */ __name(function superResolve(schema, ctx) {
      var ref = shouldResolve(schema);
      if (ref) {
        return this.resolve(schema, ref, ctx).subschema;
      }
      return schema;
    }, "superResolve");
    Validator2.prototype.resolve = /* @__PURE__ */ __name(function resolve16(schema, switchSchema, ctx) {
      switchSchema = ctx.resolve(switchSchema);
      if (ctx.schemas[switchSchema]) {
        return { subschema: ctx.schemas[switchSchema], switchSchema };
      }
      var parsed = urilib.parse(switchSchema);
      var fragment = parsed && parsed.hash;
      var document2 = fragment && fragment.length && switchSchema.substr(0, switchSchema.length - fragment.length);
      if (!document2 || !ctx.schemas[document2]) {
        throw new SchemaError("no such schema <" + switchSchema + ">", schema);
      }
      var subschema = helpers.objectGetPath(ctx.schemas[document2], fragment.substr(1));
      if (subschema === void 0) {
        throw new SchemaError("no such schema " + fragment + " located in <" + document2 + ">", schema);
      }
      return { subschema, switchSchema };
    }, "resolve");
    Validator2.prototype.testType = /* @__PURE__ */ __name(function validateType(instance, schema, options, ctx, type) {
      if (type === void 0) {
        return;
      } else if (type === null) {
        throw new SchemaError('Unexpected null in "type" keyword');
      }
      if (typeof this.types[type] == "function") {
        return this.types[type].call(this, instance);
      }
      if (type && typeof type == "object") {
        var res = this.validateSchema(instance, type, options, ctx);
        return res === void 0 || !(res && res.errors.length);
      }
      return true;
    }, "validateType");
    var types5 = Validator2.prototype.types = {};
    types5.string = /* @__PURE__ */ __name(function testString(instance) {
      return typeof instance == "string";
    }, "testString");
    types5.number = /* @__PURE__ */ __name(function testNumber(instance) {
      return typeof instance == "number" && isFinite(instance);
    }, "testNumber");
    types5.integer = /* @__PURE__ */ __name(function testInteger(instance) {
      return typeof instance == "number" && instance % 1 === 0;
    }, "testInteger");
    types5.boolean = /* @__PURE__ */ __name(function testBoolean(instance) {
      return typeof instance == "boolean";
    }, "testBoolean");
    types5.array = /* @__PURE__ */ __name(function testArray(instance) {
      return Array.isArray(instance);
    }, "testArray");
    types5["null"] = /* @__PURE__ */ __name(function testNull(instance) {
      return instance === null;
    }, "testNull");
    types5.date = /* @__PURE__ */ __name(function testDate(instance) {
      return instance instanceof Date;
    }, "testDate");
    types5.any = /* @__PURE__ */ __name(function testAny(instance) {
      return true;
    }, "testAny");
    types5.object = /* @__PURE__ */ __name(function testObject(instance) {
      return instance && typeof instance === "object" && !Array.isArray(instance) && !(instance instanceof Date);
    }, "testObject");
    module2.exports = Validator2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js
var require_lib = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js"(exports2, module2) {
    "use strict";
    var Validator2 = module2.exports.Validator = require_validator();
    module2.exports.ValidatorResult = require_helpers().ValidatorResult;
    module2.exports.ValidatorResultError = require_helpers().ValidatorResultError;
    module2.exports.ValidationError = require_helpers().ValidationError;
    module2.exports.SchemaError = require_helpers().SchemaError;
    module2.exports.SchemaScanResult = require_scan().SchemaScanResult;
    module2.exports.scan = require_scan().scan;
    module2.exports.validate = function(instance, schema, options) {
      var v14 = new Validator2();
      return v14.validate(instance, schema, options);
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js"(exports2, module2) {
    "use strict";
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
    9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
    var RELEASE_TYPES = [
      "major",
      "premajor",
      "minor",
      "preminor",
      "patch",
      "prepatch",
      "prerelease"
    ];
    module2.exports = {
      MAX_LENGTH,
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_SAFE_INTEGER,
      RELEASE_TYPES,
      SEMVER_SPEC_VERSION,
      FLAG_INCLUDE_PRERELEASE: 1,
      FLAG_LOOSE: 2
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js"(exports2, module2) {
    "use strict";
    var debug3 = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug3;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js
var require_re = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js"(exports2, module2) {
    "use strict";
    var {
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_LENGTH
    } = require_constants();
    var debug3 = require_debug();
    exports2 = module2.exports = {};
    var re = exports2.re = [];
    var safeRe = exports2.safeRe = [];
    var src = exports2.src = [];
    var safeSrc = exports2.safeSrc = [];
    var t13 = exports2.t = {};
    var R = 0;
    var LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    var safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]
    ];
    var makeSafeRegex = /* @__PURE__ */ __name((value) => {
      for (const [token, max] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
      }
      return value;
    }, "makeSafeRegex");
    var createToken = /* @__PURE__ */ __name((name, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index = R++;
      debug3(name, index, value);
      t13[name] = index;
      src[index] = value;
      safeSrc[index] = safe;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
    }, "createToken");
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src[t13.NUMERICIDENTIFIER]})\\.(${src[t13.NUMERICIDENTIFIER]})\\.(${src[t13.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t13.NUMERICIDENTIFIERLOOSE]})\\.(${src[t13.NUMERICIDENTIFIERLOOSE]})\\.(${src[t13.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t13.NONNUMERICIDENTIFIER]}|${src[t13.NUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t13.NONNUMERICIDENTIFIER]}|${src[t13.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASE", `(?:-(${src[t13.PRERELEASEIDENTIFIER]}(?:\\.${src[t13.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t13.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t13.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src[t13.BUILDIDENTIFIER]}(?:\\.${src[t13.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t13.MAINVERSION]}${src[t13.PRERELEASE]}?${src[t13.BUILD]}?`);
    createToken("FULL", `^${src[t13.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t13.MAINVERSIONLOOSE]}${src[t13.PRERELEASELOOSE]}?${src[t13.BUILD]}?`);
    createToken("LOOSE", `^${src[t13.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t13.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t13.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t13.XRANGEIDENTIFIER]})(?:\\.(${src[t13.XRANGEIDENTIFIER]})(?:\\.(${src[t13.XRANGEIDENTIFIER]})(?:${src[t13.PRERELEASE]})?${src[t13.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t13.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t13.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t13.XRANGEIDENTIFIERLOOSE]})(?:${src[t13.PRERELEASELOOSE]})?${src[t13.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t13.GTLT]}\\s*${src[t13.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t13.GTLT]}\\s*${src[t13.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
    createToken("COERCE", `${src[t13.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src[t13.COERCEPLAIN] + `(?:${src[t13.PRERELEASE]})?(?:${src[t13.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t13.COERCE], true);
    createToken("COERCERTLFULL", src[t13.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t13.LONETILDE]}\\s+`, true);
    exports2.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t13.LONETILDE]}${src[t13.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t13.LONETILDE]}${src[t13.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t13.LONECARET]}\\s+`, true);
    exports2.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t13.LONECARET]}${src[t13.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t13.LONECARET]}${src[t13.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t13.GTLT]}\\s*(${src[t13.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t13.GTLT]}\\s*(${src[t13.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t13.GTLT]}\\s*(${src[t13.LOOSEPLAIN]}|${src[t13.XRANGEPLAIN]})`, true);
    exports2.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t13.XRANGEPLAIN]})\\s+-\\s+(${src[t13.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t13.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t13.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js"(exports2, module2) {
    "use strict";
    var looseOption = Object.freeze({ loose: true });
    var emptyOpts = Object.freeze({});
    var parseOptions = /* @__PURE__ */ __name((options) => {
      if (!options) {
        return emptyOpts;
      }
      if (typeof options !== "object") {
        return looseOption;
      }
      return options;
    }, "parseOptions");
    module2.exports = parseOptions;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js"(exports2, module2) {
    "use strict";
    var numeric2 = /^[0-9]+$/;
    var compareIdentifiers = /* @__PURE__ */ __name((a13, b13) => {
      if (typeof a13 === "number" && typeof b13 === "number") {
        return a13 === b13 ? 0 : a13 < b13 ? -1 : 1;
      }
      const anum = numeric2.test(a13);
      const bnum = numeric2.test(b13);
      if (anum && bnum) {
        a13 = +a13;
        b13 = +b13;
      }
      return a13 === b13 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a13 < b13 ? -1 : 1;
    }, "compareIdentifiers");
    var rcompareIdentifiers = /* @__PURE__ */ __name((a13, b13) => compareIdentifiers(b13, a13), "rcompareIdentifiers");
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js"(exports2, module2) {
    "use strict";
    var debug3 = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { safeRe: re, t: t13 } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class _SemVer {
      static {
        __name(this, "SemVer");
      }
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof _SemVer) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug3("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m13 = version.trim().match(options.loose ? re[t13.LOOSE] : re[t13.FULL]);
        if (!m13) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m13[1];
        this.minor = +m13[2];
        this.patch = +m13[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m13[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m13[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m13[5] ? m13[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug3("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof _SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new _SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.major < other.major) {
          return -1;
        }
        if (this.major > other.major) {
          return 1;
        }
        if (this.minor < other.minor) {
          return -1;
        }
        if (this.minor > other.minor) {
          return 1;
        }
        if (this.patch < other.patch) {
          return -1;
        }
        if (this.patch > other.patch) {
          return 1;
        }
        return 0;
      }
      comparePre(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i13 = 0;
        do {
          const a13 = this.prerelease[i13];
          const b13 = other.prerelease[i13];
          debug3("prerelease compare", i13, a13, b13);
          if (a13 === void 0 && b13 === void 0) {
            return 0;
          } else if (b13 === void 0) {
            return 1;
          } else if (a13 === void 0) {
            return -1;
          } else if (a13 === b13) {
            continue;
          } else {
            return compareIdentifiers(a13, b13);
          }
        } while (++i13);
      }
      compareBuild(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        let i13 = 0;
        do {
          const a13 = this.build[i13];
          const b13 = other.build[i13];
          debug3("build compare", i13, a13, b13);
          if (a13 === void 0 && b13 === void 0) {
            return 0;
          } else if (b13 === void 0) {
            return 1;
          } else if (a13 === void 0) {
            return -1;
          } else if (a13 === b13) {
            continue;
          } else {
            return compareIdentifiers(a13, b13);
          }
        } while (++i13);
      }
      // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.
      inc(release2, identifier, identifierBase) {
        if (release2.startsWith("pre")) {
          if (!identifier && identifierBase === false) {
            throw new Error("invalid increment argument: identifier is empty");
          }
          if (identifier) {
            const match4 = `-${identifier}`.match(this.options.loose ? re[t13.PRERELEASELOOSE] : re[t13.PRERELEASE]);
            if (!match4 || match4[1] !== identifier) {
              throw new Error(`invalid identifier: ${identifier}`);
            }
          }
        }
        switch (release2) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier, identifierBase);
            this.inc("pre", identifier, identifierBase);
            break;
          // If the input is a non-prerelease version, this acts the same as
          // prepatch.
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier, identifierBase);
            }
            this.inc("pre", identifier, identifierBase);
            break;
          case "release":
            if (this.prerelease.length === 0) {
              throw new Error(`version ${this.raw} is not a prerelease`);
            }
            this.prerelease.length = 0;
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          // This probably shouldn't be used publicly.
          // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
          case "pre": {
            const base = Number(identifierBase) ? 1 : 0;
            if (this.prerelease.length === 0) {
              this.prerelease = [base];
            } else {
              let i13 = this.prerelease.length;
              while (--i13 >= 0) {
                if (typeof this.prerelease[i13] === "number") {
                  this.prerelease[i13]++;
                  i13 = -2;
                }
              }
              if (i13 === -1) {
                if (identifier === this.prerelease.join(".") && identifierBase === false) {
                  throw new Error("invalid increment argument: identifier already exists");
                }
                this.prerelease.push(base);
              }
            }
            if (identifier) {
              let prerelease = [identifier, base];
              if (identifierBase === false) {
                prerelease = [identifier];
              }
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = prerelease;
                }
              } else {
                this.prerelease = prerelease;
              }
            }
            break;
          }
          default:
            throw new Error(`invalid increment argument: ${release2}`);
        }
        this.raw = this.format();
        if (this.build.length) {
          this.raw += `+${this.build.join(".")}`;
        }
        return this;
      }
    };
    module2.exports = SemVer;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse2 = /* @__PURE__ */ __name((version, options, throwErrors = false) => {
      if (version instanceof SemVer) {
        return version;
      }
      try {
        return new SemVer(version, options);
      } catch (er) {
        if (!throwErrors) {
          return null;
        }
        throw er;
      }
    }, "parse");
    module2.exports = parse2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js"(exports2, module2) {
    "use strict";
    var parse2 = require_parse();
    var valid3 = /* @__PURE__ */ __name((version, options) => {
      const v14 = parse2(version, options);
      return v14 ? v14.version : null;
    }, "valid");
    module2.exports = valid3;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js"(exports2, module2) {
    "use strict";
    var parse2 = require_parse();
    var clean = /* @__PURE__ */ __name((version, options) => {
      const s13 = parse2(version.trim().replace(/^[=v]+/, ""), options);
      return s13 ? s13.version : null;
    }, "clean");
    module2.exports = clean;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var inc = /* @__PURE__ */ __name((version, release2, options, identifier, identifierBase) => {
      if (typeof options === "string") {
        identifierBase = identifier;
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer(
          version instanceof SemVer ? version.version : version,
          options
        ).inc(release2, identifier, identifierBase).version;
      } catch (er) {
        return null;
      }
    }, "inc");
    module2.exports = inc;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js"(exports2, module2) {
    "use strict";
    var parse2 = require_parse();
    var diff = /* @__PURE__ */ __name((version1, version2) => {
      const v1 = parse2(version1, null, true);
      const v22 = parse2(version2, null, true);
      const comparison = v1.compare(v22);
      if (comparison === 0) {
        return null;
      }
      const v1Higher = comparison > 0;
      const highVersion = v1Higher ? v1 : v22;
      const lowVersion = v1Higher ? v22 : v1;
      const highHasPre = !!highVersion.prerelease.length;
      const lowHasPre = !!lowVersion.prerelease.length;
      if (lowHasPre && !highHasPre) {
        if (!lowVersion.patch && !lowVersion.minor) {
          return "major";
        }
        if (lowVersion.compareMain(highVersion) === 0) {
          if (lowVersion.minor && !lowVersion.patch) {
            return "minor";
          }
          return "patch";
        }
      }
      const prefix2 = highHasPre ? "pre" : "";
      if (v1.major !== v22.major) {
        return prefix2 + "major";
      }
      if (v1.minor !== v22.minor) {
        return prefix2 + "minor";
      }
      if (v1.patch !== v22.patch) {
        return prefix2 + "patch";
      }
      return "prerelease";
    }, "diff");
    module2.exports = diff;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js
var require_major = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var major6 = /* @__PURE__ */ __name((a13, loose) => new SemVer(a13, loose).major, "major");
    module2.exports = major6;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var minor = /* @__PURE__ */ __name((a13, loose) => new SemVer(a13, loose).minor, "minor");
    module2.exports = minor;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var patch = /* @__PURE__ */ __name((a13, loose) => new SemVer(a13, loose).patch, "patch");
    module2.exports = patch;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js"(exports2, module2) {
    "use strict";
    var parse2 = require_parse();
    var prerelease = /* @__PURE__ */ __name((version, options) => {
      const parsed = parse2(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    }, "prerelease");
    module2.exports = prerelease;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compare2 = /* @__PURE__ */ __name((a13, b13, loose) => new SemVer(a13, loose).compare(new SemVer(b13, loose)), "compare");
    module2.exports = compare2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var rcompare = /* @__PURE__ */ __name((a13, b13, loose) => compare2(b13, a13, loose), "rcompare");
    module2.exports = rcompare;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var compareLoose = /* @__PURE__ */ __name((a13, b13) => compare2(a13, b13, true), "compareLoose");
    module2.exports = compareLoose;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compareBuild = /* @__PURE__ */ __name((a13, b13, loose) => {
      const versionA = new SemVer(a13, loose);
      const versionB = new SemVer(b13, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    }, "compareBuild");
    module2.exports = compareBuild;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var sort = /* @__PURE__ */ __name((list2, loose) => list2.sort((a13, b13) => compareBuild(a13, b13, loose)), "sort");
    module2.exports = sort;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var rsort = /* @__PURE__ */ __name((list2, loose) => list2.sort((a13, b13) => compareBuild(b13, a13, loose)), "rsort");
    module2.exports = rsort;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gt = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) > 0, "gt");
    module2.exports = gt;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lt = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) < 0, "lt");
    module2.exports = lt;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var eq2 = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) === 0, "eq");
    module2.exports = eq2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var neq = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) !== 0, "neq");
    module2.exports = neq;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gte2 = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) >= 0, "gte");
    module2.exports = gte2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lte3 = /* @__PURE__ */ __name((a13, b13, loose) => compare2(a13, b13, loose) <= 0, "lte");
    module2.exports = lte3;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js"(exports2, module2) {
    "use strict";
    var eq2 = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte2 = require_gte();
    var lt = require_lt();
    var lte3 = require_lte();
    var cmp = /* @__PURE__ */ __name((a13, op2, b13, loose) => {
      switch (op2) {
        case "===":
          if (typeof a13 === "object") {
            a13 = a13.version;
          }
          if (typeof b13 === "object") {
            b13 = b13.version;
          }
          return a13 === b13;
        case "!==":
          if (typeof a13 === "object") {
            a13 = a13.version;
          }
          if (typeof b13 === "object") {
            b13 = b13.version;
          }
          return a13 !== b13;
        case "":
        case "=":
        case "==":
          return eq2(a13, b13, loose);
        case "!=":
          return neq(a13, b13, loose);
        case ">":
          return gt(a13, b13, loose);
        case ">=":
          return gte2(a13, b13, loose);
        case "<":
          return lt(a13, b13, loose);
        case "<=":
          return lte3(a13, b13, loose);
        default:
          throw new TypeError(`Invalid operator: ${op2}`);
      }
    }, "cmp");
    module2.exports = cmp;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse2 = require_parse();
    var { safeRe: re, t: t13 } = require_re();
    var coerce2 = /* @__PURE__ */ __name((version, options) => {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match4 = null;
      if (!options.rtl) {
        match4 = version.match(options.includePrerelease ? re[t13.COERCEFULL] : re[t13.COERCE]);
      } else {
        const coerceRtlRegex = options.includePrerelease ? re[t13.COERCERTLFULL] : re[t13.COERCERTL];
        let next;
        while ((next = coerceRtlRegex.exec(version)) && (!match4 || match4.index + match4[0].length !== version.length)) {
          if (!match4 || next.index + next[0].length !== match4.index + match4[0].length) {
            match4 = next;
          }
          coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        coerceRtlRegex.lastIndex = -1;
      }
      if (match4 === null) {
        return null;
      }
      const major6 = match4[2];
      const minor = match4[3] || "0";
      const patch = match4[4] || "0";
      const prerelease = options.includePrerelease && match4[5] ? `-${match4[5]}` : "";
      const build = options.includePrerelease && match4[6] ? `+${match4[6]}` : "";
      return parse2(`${major6}.${minor}.${patch}${prerelease}${build}`, options);
    }, "coerce");
    module2.exports = coerce2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/lrucache.js
var require_lrucache = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/lrucache.js"(exports2, module2) {
    "use strict";
    var LRUCache2 = class {
      static {
        __name(this, "LRUCache");
      }
      constructor() {
        this.max = 1e3;
        this.map = /* @__PURE__ */ new Map();
      }
      get(key) {
        const value = this.map.get(key);
        if (value === void 0) {
          return void 0;
        } else {
          this.map.delete(key);
          this.map.set(key, value);
          return value;
        }
      }
      delete(key) {
        return this.map.delete(key);
      }
      set(key, value) {
        const deleted = this.delete(key);
        if (!deleted && value !== void 0) {
          if (this.map.size >= this.max) {
            const firstKey = this.map.keys().next().value;
            this.delete(firstKey);
          }
          this.map.set(key, value);
        }
        return this;
      }
    };
    module2.exports = LRUCache2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js
var require_range = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js"(exports2, module2) {
    "use strict";
    var SPACE_CHARACTERS = /\s+/g;
    var Range = class _Range {
      static {
        __name(this, "Range");
      }
      constructor(range3, options) {
        options = parseOptions(options);
        if (range3 instanceof _Range) {
          if (range3.loose === !!options.loose && range3.includePrerelease === !!options.includePrerelease) {
            return range3;
          } else {
            return new _Range(range3.raw, options);
          }
        }
        if (range3 instanceof Comparator) {
          this.raw = range3.value;
          this.set = [[range3]];
          this.formatted = void 0;
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range3.trim().replace(SPACE_CHARACTERS, " ");
        this.set = this.raw.split("||").map((r13) => this.parseRange(r13.trim())).filter((c13) => c13.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c13) => !isNullSet(c13[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c13 of this.set) {
              if (c13.length === 1 && isAny(c13[0])) {
                this.set = [c13];
                break;
              }
            }
          }
        }
        this.formatted = void 0;
      }
      get range() {
        if (this.formatted === void 0) {
          this.formatted = "";
          for (let i13 = 0; i13 < this.set.length; i13++) {
            if (i13 > 0) {
              this.formatted += "||";
            }
            const comps = this.set[i13];
            for (let k13 = 0; k13 < comps.length; k13++) {
              if (k13 > 0) {
                this.formatted += " ";
              }
              this.formatted += comps[k13].toString().trim();
            }
          }
        }
        return this.formatted;
      }
      format() {
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range3) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range3;
        const cached4 = cache13.get(memoKey);
        if (cached4) {
          return cached4;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t13.HYPHENRANGELOOSE] : re[t13.HYPHENRANGE];
        range3 = range3.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug3("hyphen replace", range3);
        range3 = range3.replace(re[t13.COMPARATORTRIM], comparatorTrimReplace);
        debug3("comparator trim", range3);
        range3 = range3.replace(re[t13.TILDETRIM], tildeTrimReplace);
        debug3("tilde trim", range3);
        range3 = range3.replace(re[t13.CARETTRIM], caretTrimReplace);
        debug3("caret trim", range3);
        let rangeList = range3.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug3("loose invalid filter", comp, this.options);
            return !!comp.match(re[t13.COMPARATORLOOSE]);
          });
        }
        debug3("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result2 = [...rangeMap.values()];
        cache13.set(memoKey, result2);
        return result2;
      }
      intersects(range3, options) {
        if (!(range3 instanceof _Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range3.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i13 = 0; i13 < this.set.length; i13++) {
          if (testSet(this.set[i13], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lrucache();
    var cache13 = new LRU();
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug3 = require_debug();
    var SemVer = require_semver();
    var {
      safeRe: re,
      t: t13,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = require_constants();
    var isNullSet = /* @__PURE__ */ __name((c13) => c13.value === "<0.0.0-0", "isNullSet");
    var isAny = /* @__PURE__ */ __name((c13) => c13.value === "", "isAny");
    var isSatisfiable = /* @__PURE__ */ __name((comparators, options) => {
      let result2 = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result2 && remainingComparators.length) {
        result2 = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result2;
    }, "isSatisfiable");
    var parseComparator = /* @__PURE__ */ __name((comp, options) => {
      comp = comp.replace(re[t13.BUILD], "");
      debug3("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug3("caret", comp);
      comp = replaceTildes(comp, options);
      debug3("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug3("xrange", comp);
      comp = replaceStars(comp, options);
      debug3("stars", comp);
      return comp;
    }, "parseComparator");
    var isX = /* @__PURE__ */ __name((id) => !id || id.toLowerCase() === "x" || id === "*", "isX");
    var replaceTildes = /* @__PURE__ */ __name((comp, options) => {
      return comp.trim().split(/\s+/).map((c13) => replaceTilde(c13, options)).join(" ");
    }, "replaceTildes");
    var replaceTilde = /* @__PURE__ */ __name((comp, options) => {
      const r13 = options.loose ? re[t13.TILDELOOSE] : re[t13.TILDE];
      return comp.replace(r13, (_2, M, m13, p13, pr) => {
        debug3("tilde", comp, _2, M, m13, p13, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m13)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p13)) {
          ret = `>=${M}.${m13}.0 <${M}.${+m13 + 1}.0-0`;
        } else if (pr) {
          debug3("replaceTilde pr", pr);
          ret = `>=${M}.${m13}.${p13}-${pr} <${M}.${+m13 + 1}.0-0`;
        } else {
          ret = `>=${M}.${m13}.${p13} <${M}.${+m13 + 1}.0-0`;
        }
        debug3("tilde return", ret);
        return ret;
      });
    }, "replaceTilde");
    var replaceCarets = /* @__PURE__ */ __name((comp, options) => {
      return comp.trim().split(/\s+/).map((c13) => replaceCaret(c13, options)).join(" ");
    }, "replaceCarets");
    var replaceCaret = /* @__PURE__ */ __name((comp, options) => {
      debug3("caret", comp, options);
      const r13 = options.loose ? re[t13.CARETLOOSE] : re[t13.CARET];
      const z5 = options.includePrerelease ? "-0" : "";
      return comp.replace(r13, (_2, M, m13, p13, pr) => {
        debug3("caret", comp, _2, M, m13, p13, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m13)) {
          ret = `>=${M}.0.0${z5} <${+M + 1}.0.0-0`;
        } else if (isX(p13)) {
          if (M === "0") {
            ret = `>=${M}.${m13}.0${z5} <${M}.${+m13 + 1}.0-0`;
          } else {
            ret = `>=${M}.${m13}.0${z5} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug3("replaceCaret pr", pr);
          if (M === "0") {
            if (m13 === "0") {
              ret = `>=${M}.${m13}.${p13}-${pr} <${M}.${m13}.${+p13 + 1}-0`;
            } else {
              ret = `>=${M}.${m13}.${p13}-${pr} <${M}.${+m13 + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m13}.${p13}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug3("no pr");
          if (M === "0") {
            if (m13 === "0") {
              ret = `>=${M}.${m13}.${p13}${z5} <${M}.${m13}.${+p13 + 1}-0`;
            } else {
              ret = `>=${M}.${m13}.${p13}${z5} <${M}.${+m13 + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m13}.${p13} <${+M + 1}.0.0-0`;
          }
        }
        debug3("caret return", ret);
        return ret;
      });
    }, "replaceCaret");
    var replaceXRanges = /* @__PURE__ */ __name((comp, options) => {
      debug3("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c13) => replaceXRange(c13, options)).join(" ");
    }, "replaceXRanges");
    var replaceXRange = /* @__PURE__ */ __name((comp, options) => {
      comp = comp.trim();
      const r13 = options.loose ? re[t13.XRANGELOOSE] : re[t13.XRANGE];
      return comp.replace(r13, (ret, gtlt, M, m13, p13, pr) => {
        debug3("xRange", comp, ret, gtlt, M, m13, p13, pr);
        const xM = isX(M);
        const xm = xM || isX(m13);
        const xp = xm || isX(p13);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m13 = 0;
          }
          p13 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m13 = 0;
              p13 = 0;
            } else {
              m13 = +m13 + 1;
              p13 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m13 = +m13 + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m13}.${p13}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m13}.0${pr} <${M}.${+m13 + 1}.0-0`;
        }
        debug3("xRange return", ret);
        return ret;
      });
    }, "replaceXRange");
    var replaceStars = /* @__PURE__ */ __name((comp, options) => {
      debug3("replaceStars", comp, options);
      return comp.trim().replace(re[t13.STAR], "");
    }, "replaceStars");
    var replaceGTE0 = /* @__PURE__ */ __name((comp, options) => {
      debug3("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t13.GTE0PRE : t13.GTE0], "");
    }, "replaceGTE0");
    var hyphenReplace = /* @__PURE__ */ __name((incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    }, "hyphenReplace");
    var testSet = /* @__PURE__ */ __name((set, version, options) => {
      for (let i13 = 0; i13 < set.length; i13++) {
        if (!set[i13].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i13 = 0; i13 < set.length; i13++) {
          debug3(set[i13].semver);
          if (set[i13].semver === Comparator.ANY) {
            continue;
          }
          if (set[i13].semver.prerelease.length > 0) {
            const allowed = set[i13].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    }, "testSet");
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js"(exports2, module2) {
    "use strict";
    var ANY = /* @__PURE__ */ Symbol("SemVer ANY");
    var Comparator = class _Comparator {
      static {
        __name(this, "Comparator");
      }
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof _Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug3("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug3("comp", this);
      }
      parse(comp) {
        const r13 = this.options.loose ? re[t13.COMPARATORLOOSE] : re[t13.COMPARATOR];
        const m13 = comp.match(r13);
        if (!m13) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m13[1] !== void 0 ? m13[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m13[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m13[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug3("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof _Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        options = parseOptions(options);
        if (options.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { safeRe: re, t: t13 } = require_re();
    var cmp = require_cmp();
    var debug3 = require_debug();
    var SemVer = require_semver();
    var Range = require_range();
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var satisfies2 = /* @__PURE__ */ __name((version, range3, options) => {
      try {
        range3 = new Range(range3, options);
      } catch (er) {
        return false;
      }
      return range3.test(version);
    }, "satisfies");
    module2.exports = satisfies2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var toComparators = /* @__PURE__ */ __name((range3, options) => new Range(range3, options).set.map((comp) => comp.map((c13) => c13.value).join(" ").trim().split(" ")), "toComparators");
    module2.exports = toComparators;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var maxSatisfying = /* @__PURE__ */ __name((versions, range3, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range3, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v14) => {
        if (rangeObj.test(v14)) {
          if (!max || maxSV.compare(v14) === -1) {
            max = v14;
            maxSV = new SemVer(max, options);
          }
        }
      });
      return max;
    }, "maxSatisfying");
    module2.exports = maxSatisfying;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var minSatisfying = /* @__PURE__ */ __name((versions, range3, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range3, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v14) => {
        if (rangeObj.test(v14)) {
          if (!min || minSV.compare(v14) === 1) {
            min = v14;
            minSV = new SemVer(min, options);
          }
        }
      });
      return min;
    }, "minSatisfying");
    module2.exports = minSatisfying;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = /* @__PURE__ */ __name((range3, loose) => {
      range3 = new Range(range3, loose);
      let minver = new SemVer("0.0.0");
      if (range3.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range3.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i13 = 0; i13 < range3.set.length; ++i13) {
        const comparators = range3.set[i13];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            /* fallthrough */
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            /* istanbul ignore next */
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range3.test(minver)) {
        return minver;
      }
      return null;
    }, "minVersion");
    module2.exports = minVersion;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var validRange = /* @__PURE__ */ __name((range3, options) => {
      try {
        return new Range(range3, options).range || "*";
      } catch (er) {
        return null;
      }
    }, "validRange");
    module2.exports = validRange;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies2 = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte3 = require_lte();
    var gte2 = require_gte();
    var outside = /* @__PURE__ */ __name((version, range3, hilo, options) => {
      version = new SemVer(version, options);
      range3 = new Range(range3, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte3;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte2;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies2(version, range3, options)) {
        return false;
      }
      for (let i13 = 0; i13 < range3.set.length; ++i13) {
        const comparators = range3.set[i13];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    }, "outside");
    module2.exports = outside;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var gtr = /* @__PURE__ */ __name((version, range3, options) => outside(version, range3, ">", options), "gtr");
    module2.exports = gtr;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var ltr = /* @__PURE__ */ __name((version, range3, options) => outside(version, range3, "<", options), "ltr");
    module2.exports = ltr;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var intersects = /* @__PURE__ */ __name((r1, r22, options) => {
      r1 = new Range(r1, options);
      r22 = new Range(r22, options);
      return r1.intersects(r22, options);
    }, "intersects");
    module2.exports = intersects;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js"(exports2, module2) {
    "use strict";
    var satisfies2 = require_satisfies();
    var compare2 = require_compare();
    module2.exports = (versions, range3, options) => {
      const set = [];
      let first = null;
      let prev = null;
      const v14 = versions.sort((a13, b13) => compare2(a13, b13, options));
      for (const version of v14) {
        const included = satisfies2(version, range3, options);
        if (included) {
          prev = version;
          if (!first) {
            first = version;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v14[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v14[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range3.raw === "string" ? range3.raw : String(range3);
      return simplified.length < original.length ? simplified : range3;
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies2 = require_satisfies();
    var compare2 = require_compare();
    var subset = /* @__PURE__ */ __name((sub, dom, options = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER: for (const simpleSub of sub.set) {
        for (const simpleDom of dom.set) {
          const isSub = simpleSubset(simpleSub, simpleDom, options);
          sawNonNull = sawNonNull || isSub !== null;
          if (isSub) {
            continue OUTER;
          }
        }
        if (sawNonNull) {
          return false;
        }
      }
      return true;
    }, "subset");
    var minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")];
    var minimumVersion = [new Comparator(">=0.0.0")];
    var simpleSubset = /* @__PURE__ */ __name((sub, dom, options) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options.includePrerelease) {
          sub = minimumVersionWithPreRelease;
        } else {
          sub = minimumVersion;
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
          return true;
        } else {
          dom = minimumVersion;
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c13 of sub) {
        if (c13.operator === ">" || c13.operator === ">=") {
          gt = higherGT(gt, c13, options);
        } else if (c13.operator === "<" || c13.operator === "<=") {
          lt = lowerLT(lt, c13, options);
        } else {
          eqSet.add(c13.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare2(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq2 of eqSet) {
        if (gt && !satisfies2(eq2, String(gt), options)) {
          return null;
        }
        if (lt && !satisfies2(eq2, String(lt), options)) {
          return null;
        }
        for (const c13 of dom) {
          if (!satisfies2(eq2, String(c13), options)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c13 of dom) {
        hasDomGT = hasDomGT || c13.operator === ">" || c13.operator === ">=";
        hasDomLT = hasDomLT || c13.operator === "<" || c13.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c13.semver.prerelease && c13.semver.prerelease.length && c13.semver.major === needDomGTPre.major && c13.semver.minor === needDomGTPre.minor && c13.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c13.operator === ">" || c13.operator === ">=") {
            higher = higherGT(gt, c13, options);
            if (higher === c13 && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies2(gt.semver, String(c13), options)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c13.semver.prerelease && c13.semver.prerelease.length && c13.semver.major === needDomLTPre.major && c13.semver.minor === needDomLTPre.minor && c13.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c13.operator === "<" || c13.operator === "<=") {
            lower = lowerLT(lt, c13, options);
            if (lower === c13 && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies2(lt.semver, String(c13), options)) {
            return false;
          }
        }
        if (!c13.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    }, "simpleSubset");
    var higherGT = /* @__PURE__ */ __name((a13, b13, options) => {
      if (!a13) {
        return b13;
      }
      const comp = compare2(a13.semver, b13.semver, options);
      return comp > 0 ? a13 : comp < 0 ? b13 : b13.operator === ">" && a13.operator === ">=" ? b13 : a13;
    }, "higherGT");
    var lowerLT = /* @__PURE__ */ __name((a13, b13, options) => {
      if (!a13) {
        return b13;
      }
      const comp = compare2(a13.semver, b13.semver, options);
      return comp < 0 ? a13 : comp > 0 ? b13 : b13.operator === "<" && a13.operator === "<=" ? b13 : a13;
    }, "lowerLT");
    module2.exports = subset;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js
var require_semver2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js"(exports2, module2) {
    "use strict";
    var internalRe = require_re();
    var constants3 = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse2 = require_parse();
    var valid3 = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major6 = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare2 = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq2 = require_eq();
    var neq = require_neq();
    var gte2 = require_gte();
    var lte3 = require_lte();
    var cmp = require_cmp();
    var coerce2 = require_coerce();
    var Comparator = require_comparator();
    var Range = require_range();
    var satisfies2 = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module2.exports = {
      parse: parse2,
      valid: valid3,
      clean,
      inc,
      diff,
      major: major6,
      minor,
      patch,
      prerelease,
      compare: compare2,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq: eq2,
      neq,
      gte: gte2,
      lte: lte3,
      cmp,
      coerce: coerce2,
      Comparator,
      Range,
      satisfies: satisfies2,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants3.SEMVER_SPEC_VERSION,
      RELEASE_TYPES: constants3.RELEASE_TYPES,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/cli-version.json
var require_cli_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/cli-version.json"(exports2, module2) {
    module2.exports = { version: "2.1104.0" };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/assets.schema.json
var require_assets_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/assets.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/AssetManifest",
      definitions: {
        AssetManifest: {
          description: "Definitions for the asset manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            files: {
              description: "The file assets in this manifest (Default - No files)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileAsset"
              }
            },
            dockerImages: {
              description: "The Docker image assets in this manifest (Default - No Docker images)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageAsset"
              }
            }
          },
          required: [
            "version"
          ]
        },
        FileAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            displayName: {
              description: "A display name for this asset (Default - The identifier will be used as the display name)",
              type: "string"
            },
            source: {
              $ref: "#/definitions/FileSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        FileSource: {
          description: "Describe the source of a file asset",
          type: "object",
          properties: {
            executable: {
              description: "External command which will produce the file asset to upload. (Default - Exactly one of `executable` and `path` is required.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            path: {
              description: "The filesystem object to upload\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `executable` and `path` is required.)",
              type: "string"
            },
            packaging: {
              description: "Packaging method\n\nOnly allowed when `path` is specified. (Default FILE)",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            }
          }
        },
        FileDestination: {
          description: "Where in S3 a file asset needs to be published",
          type: "object",
          properties: {
            bucketName: {
              description: "The name of the bucket",
              type: "string"
            },
            objectKey: {
              description: "The destination object key",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "bucketName",
            "objectKey"
          ]
        },
        DockerImageAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            displayName: {
              description: "A display name for this asset (Default - The identifier will be used as the display name)",
              type: "string"
            },
            source: {
              $ref: "#/definitions/DockerImageSource",
              description: "Source description for container assets"
            },
            destinations: {
              description: "Destinations for this container asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        DockerImageSource: {
          description: "Properties for how to produce a Docker image from a source",
          type: "object",
          properties: {
            directory: {
              description: "The directory containing the Docker image build instructions.\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `directory` and `executable` is required)",
              type: "string"
            },
            executable: {
              description: "A command-line executable that returns the name of a local\nDocker image on stdout after being run. (Default - Exactly one of `directory` and `executable` is required)",
              type: "array",
              items: {
                type: "string"
              }
            },
            dockerFile: {
              description: "The name of the file with build instructions\n\nOnly allowed when `directory` is set. (Default Dockerfile)",
              type: "string"
            },
            dockerBuildTarget: {
              description: "Target build stage in a Dockerfile with multiple build stages\n\nOnly allowed when `directory` is set. (Default - The last stage in the Dockerfile)",
              type: "string"
            },
            dockerBuildArgs: {
              description: "Additional build arguments\n\nOnly allowed when `directory` is set. (Default - No additional build arguments)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            dockerBuildSsh: {
              description: "SSH agent socket or keys\n\nRequires building with docker buildkit. (Default - No ssh flag is set)",
              type: "string"
            },
            dockerBuildSecrets: {
              description: "Additional build secrets\n\nOnly allowed when `directory` is set. (Default - No additional build secrets)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. _Requires Docker Engine API v1.25+_.\n\nSpecify this property to build images on a specific networking mode. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_.\n\nSpecify this property to build images on a specific platform/architecture. (Default - current machine platform)",
              type: "string"
            },
            dockerOutputs: {
              description: "Outputs (Default - no outputs are passed to the build command (default outputs are used))",
              type: "array",
              items: {
                type: "string"
              }
            },
            cacheFrom: {
              description: "Cache from options to pass to the `docker build` command. (Default - no cache from options are passed to the build command)",
              type: "array",
              items: {
                $ref: "#/definitions/DockerCacheOption"
              }
            },
            cacheTo: {
              description: "Cache to options to pass to the `docker build` command. (Default - no cache to options are passed to the build command)",
              $ref: "#/definitions/DockerCacheOption"
            },
            cacheDisabled: {
              description: "Disable the cache and pass `--no-cache` to the `docker build` command. (Default - cache is used)",
              type: "boolean"
            }
          }
        },
        DockerCacheOption: {
          description: "Options for configuring the Docker cache backend",
          type: "object",
          properties: {
            type: {
              description: "The type of cache to use.\nRefer to https://docs.docker.com/build/cache/backends/ for full list of backends. (Default - unspecified)",
              type: "string"
            },
            params: {
              description: "Any parameters to pass into the docker cache backend configuration.\nRefer to https://docs.docker.com/build/cache/backends/ for cache backend configuration. (Default {} No options provided)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        DockerImageDestination: {
          description: "Where to publish docker images",
          type: "object",
          properties: {
            repositoryName: {
              description: "Name of the ECR repository to publish to",
              type: "string"
            },
            imageTag: {
              description: "Tag of the image to publish",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "imageTag",
            "repositoryName"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json
var require_cloud_assembly_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/AssemblyManifest",
      definitions: {
        AssemblyManifest: {
          description: "A manifest which describes the cloud assembly.",
          type: "object",
          properties: {
            version: {
              description: "Protocol version",
              type: "string"
            },
            minimumCliVersion: {
              description: "Required CLI version, if available\n\nIf the manifest producer knows, it can put the minimum version of the CLI\nhere that supports reading this assembly.\n\nIf set, it can be used to show a more informative error message to users. (Default - Minimum CLI version unknown)",
              type: "string"
            },
            artifacts: {
              description: "The set of artifacts in this assembly. (Default - no artifacts.)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/ArtifactManifest"
              }
            },
            missing: {
              description: "Missing context information. If this field has values, it means that the\ncloud assembly is not complete and should not be deployed. (Default - no missing context.)",
              type: "array",
              items: {
                $ref: "#/definitions/MissingContext"
              }
            },
            runtime: {
              description: "Runtime information. (Default - no info.)",
              $ref: "#/definitions/RuntimeInfo"
            }
          },
          required: [
            "version"
          ]
        },
        ArtifactManifest: {
          description: "A manifest for a single artifact within the cloud assembly.",
          type: "object",
          properties: {
            type: {
              $ref: "#/definitions/ArtifactType",
              description: "The type of artifact."
            },
            environment: {
              description: "The environment into which this artifact is deployed. (Default - no envrionment.)",
              type: "string"
            },
            metadata: {
              description: "Associated metadata. (Default - no metadata.)",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  $ref: "#/definitions/MetadataEntry"
                }
              }
            },
            dependencies: {
              description: "IDs of artifacts that must be deployed before this artifact. (Default - no dependencies.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            properties: {
              description: "The set of properties for this artifact (depends on type) (Default - no properties.)",
              anyOf: [
                {
                  $ref: "#/definitions/AwsCloudFormationStackProperties"
                },
                {
                  $ref: "#/definitions/AssetManifestProperties"
                },
                {
                  $ref: "#/definitions/TreeArtifactProperties"
                },
                {
                  $ref: "#/definitions/NestedCloudAssemblyProperties"
                },
                {
                  $ref: "#/definitions/FeatureFlagReportProperties"
                }
              ]
            },
            displayName: {
              description: `A string that can be shown to a user to uniquely identify this artifact inside a cloud assembly tree

Is used by the CLI to present a list of stacks to the user in a way that
makes sense to them. Even though the property name "display name" doesn't
imply it, this field is used to select stacks as well, so all stacks should
have a unique display name. (Default - no display name)`,
              type: "string"
            }
          },
          required: [
            "type"
          ]
        },
        ArtifactType: {
          description: "Type of cloud artifact.",
          type: "string",
          enum: [
            "none",
            "aws:cloudformation:stack",
            "cdk:tree",
            "cdk:asset-manifest",
            "cdk:cloud-assembly",
            "cdk:feature-flag-report"
          ]
        },
        MetadataEntry: {
          description: "A metadata entry in a cloud assembly artifact.",
          type: "object",
          properties: {
            type: {
              description: "The type of the metadata entry.",
              type: "string"
            },
            data: {
              description: "The data. (Default - no data.)",
              anyOf: [
                {
                  $ref: "#/definitions/FileAssetMetadataEntry"
                },
                {
                  $ref: "#/definitions/ContainerImageAssetMetadataEntry"
                },
                {
                  type: "array",
                  items: {
                    $ref: "#/definitions/Tag"
                  }
                },
                {
                  type: [
                    "string",
                    "number",
                    "boolean"
                  ]
                },
                {
                  description: "Free form data."
                }
              ]
            },
            trace: {
              description: "A stack trace for when the entry was created. (Default - no trace.)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        FileAssetMetadataEntry: {
          description: "Metadata Entry spec for files.",
          type: "object",
          properties: {
            packaging: {
              description: "Requested packaging style",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            },
            s3BucketParameter: {
              description: "Name of parameter where S3 bucket should be passed in",
              type: "string"
            },
            s3KeyParameter: {
              description: "Name of parameter where S3 key should be passed in",
              type: "string"
            },
            artifactHashParameter: {
              description: "The name of the parameter where the hash of the bundled asset should be passed in.",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "artifactHashParameter",
            "id",
            "packaging",
            "path",
            "s3BucketParameter",
            "s3KeyParameter",
            "sourceHash"
          ]
        },
        ContainerImageAssetMetadataEntry: {
          description: "Metadata Entry spec for container images.",
          type: "object",
          properties: {
            packaging: {
              description: "Type of asset",
              type: "string",
              const: "container-image"
            },
            imageNameParameter: {
              description: 'ECR Repository name and repo digest (separated by "@sha256:") where this\nimage is stored. (Default undefined If not specified, `repositoryName` and `imageTag` are\nrequired because otherwise how will the stack know where to find the asset,\nha?)',
              type: "string"
            },
            repositoryName: {
              description: "ECR repository name, if omitted a default name based on the asset's ID is\nused instead. Specify this property if you need to statically address the\nimage, e.g. from a Kubernetes Pod. Note, this is only the repository name,\nwithout the registry and the tag parts. (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            imageTag: {
              description: "The docker image tag to use for tagging pushed images. This field is\nrequired if `imageParameterName` is ommited (otherwise, the app won't be\nable to find the image). (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            buildArgs: {
              description: "Build args to pass to the `docker build` command (Default no build args are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            buildSsh: {
              description: "SSH agent socket or keys to pass to the `docker build` command (Default no ssh arg is passed)",
              type: "string"
            },
            buildSecrets: {
              description: "Build secrets to pass to the `docker build` command (Default no build secrets are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            target: {
              description: "Docker target to build to (Default no build target)",
              type: "string"
            },
            file: {
              description: "Path to the Dockerfile (relative to the directory). (Default - no file is passed)",
              type: "string"
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_. (Default - current machine platform)",
              type: "string"
            },
            outputs: {
              description: "Outputs to pass to the `docker build` command. (Default - no outputs are passed to the build command (default outputs are used))",
              type: "array",
              items: {
                type: "string"
              }
            },
            cacheFrom: {
              description: "Cache from options to pass to the `docker build` command. (Default - no cache from options are passed to the build command)",
              type: "array",
              items: {
                $ref: "#/definitions/ContainerImageAssetCacheOption"
              }
            },
            cacheTo: {
              description: "Cache to options to pass to the `docker build` command. (Default - no cache to options are passed to the build command)",
              $ref: "#/definitions/ContainerImageAssetCacheOption"
            },
            cacheDisabled: {
              description: "Disable the cache and pass `--no-cache` to the `docker build` command. (Default - cache is used)",
              type: "boolean"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "id",
            "packaging",
            "path",
            "sourceHash"
          ]
        },
        ContainerImageAssetCacheOption: {
          description: "Options for configuring the Docker cache backend",
          type: "object",
          properties: {
            type: {
              description: "The type of cache to use.\nRefer to https://docs.docker.com/build/cache/backends/ for full list of backends. (Default - unspecified)",
              type: "string"
            },
            params: {
              description: "Any parameters to pass into the docker cache backend configuration.\nRefer to https://docs.docker.com/build/cache/backends/ for cache backend configuration. (Default {} No options provided)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        Tag: {
          description: "Metadata Entry spec for stack tag.",
          type: "object",
          properties: {
            key: {
              description: 'Tag key.\n\n(In the actual file on disk this will be cased as "Key", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            },
            value: {
              description: 'Tag value.\n\n(In the actual file on disk this will be cased as "Value", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            }
          },
          required: [
            "key",
            "value"
          ]
        },
        AwsCloudFormationStackProperties: {
          description: "Artifact properties for CloudFormation stacks.",
          type: "object",
          properties: {
            templateFile: {
              description: "A file relative to the assembly root which contains the CloudFormation template for this stack.",
              type: "string"
            },
            parameters: {
              description: "Values for CloudFormation stack parameters that should be passed when the stack is deployed. (Default - No parameters)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            tags: {
              description: "Values for CloudFormation stack tags that should be passed when the stack is deployed.\n\nN.B.: Tags are also written to stack metadata, under the path of the Stack\nconstruct. Only in CDK CLI v1 are those tags found in metadata used for\nactual deployments; in all stable versions of CDK only the stack tags\ndirectly found in the `tags` property of `AwsCloudFormationStack` artifact\n(i.e., this property) are used. (Default - No tags)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            notificationArns: {
              description: "SNS Notification ARNs that should receive CloudFormation Stack Events. (Default - No notification arns)",
              type: "array",
              items: {
                type: "string"
              }
            },
            stackName: {
              description: "The name to use for the CloudFormation stack. (Default - name derived from artifact ID)",
              type: "string"
            },
            terminationProtection: {
              description: "Whether to enable termination protection for this stack.",
              default: false,
              type: "boolean"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed to deploy the stack (Default - No role is assumed (current credentials are used))",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming role for cloudformation deployments (Default - No external ID)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            },
            cloudFormationExecutionRoleArn: {
              description: "The role that is passed to CloudFormation to execute the change set (Default - No role is passed (currently assumed role/credentials are used))",
              type: "string"
            },
            lookupRole: {
              description: "The role to use to look up values from the target AWS account (Default - No role is assumed (current credentials are used))",
              $ref: "#/definitions/BootstrapRole"
            },
            stackTemplateAssetObjectUrl: {
              description: "If the stack template has already been included in the asset manifest, its asset URL (Default - Not uploaded yet, upload just before deploying)",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\nOnly used if `requiresBootstrapStackVersion` is set.\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            },
            validateOnSynth: {
              description: "Whether this stack should be validated by the CLI after synthesis (Default - false)",
              type: "boolean"
            }
          },
          required: [
            "templateFile"
          ]
        },
        BootstrapRole: {
          description: "Information needed to access an IAM role created\nas part of the bootstrap process",
          type: "object",
          properties: {
            arn: {
              description: "The ARN of the IAM role created as part of bootrapping\ne.g. lookupRoleArn",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming the bootstrap role (Default - No external ID)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `arn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to use this role (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "Name of SSM parameter with bootstrap stack version (Default - Discover SSM parameter by reading stack)",
              type: "string"
            }
          },
          required: [
            "arn"
          ]
        },
        AssetManifestProperties: {
          description: "Artifact properties for the Asset Manifest",
          type: "object",
          properties: {
            file: {
              description: "Filename of the asset manifest",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - Version 1 (basic modern bootstrap stack))",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        TreeArtifactProperties: {
          description: "Artifact properties for the Construct Tree Artifact",
          type: "object",
          properties: {
            file: {
              description: "Filename of the tree artifact",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        NestedCloudAssemblyProperties: {
          description: "Artifact properties for nested cloud assemblies",
          type: "object",
          properties: {
            directoryName: {
              description: "Relative path to the nested cloud assembly",
              type: "string"
            },
            displayName: {
              description: "Display name for the cloud assembly (Default - The artifact ID)",
              type: "string"
            }
          },
          required: [
            "directoryName"
          ]
        },
        FeatureFlagReportProperties: {
          description: "Artifact properties for a feature flag report\n\nA feature flag report is small enough that all the properties can be inlined\nhere, and doesn't need an additional file.",
          type: "object",
          properties: {
            module: {
              description: "The library that this feature flag report applies to.",
              type: "string"
            },
            flags: {
              description: "Information about every feature flag supported by this library.",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FeatureFlag"
              }
            }
          },
          required: [
            "flags",
            "module"
          ]
        },
        FeatureFlag: {
          description: "A single feature flag",
          type: "object",
          properties: {
            recommendedValue: {
              description: "The library-recommended value for this flag, if any\n\nIt is possible that there is no recommended value. (Default - No recommended value.)"
            },
            userValue: {
              description: "The value configured by the user\n\nThis is the value configured at the root of the tree. Users may also have\nconfigured values at specific locations in the tree; we don't report on\nthose. (Default - Not configured by the user)"
            },
            explanation: {
              description: "Explanation about the purpose of this flag that can be shown to the user. (Default - No description)",
              type: "string"
            },
            unconfiguredBehavesLike: {
              description: "The value of the flag that produces the same behavior as when the flag is not configured at all\n\nThe structure of this field is a historical accident. The type of this field\nshould have been boolean, which should have contained the default value for\nthe flag appropriate for the *current* version of the CDK library. We are\nnot rectifying this accident because doing so\n\nInstead, the canonical way to access this value is by evaluating\n`unconfiguredBehavesLike?.v2 ?? false`.",
              default: false,
              $ref: "#/definitions/UnconfiguredBehavesLike"
            }
          }
        },
        UnconfiguredBehavesLike: {
          type: "object",
          properties: {
            v1: {
              description: "Historical accident, don't use.\n\nThis value may be present, but it should never be used. The actual value is\nin the `v2` field, regardless of the version of the CDK library. (Default - ignore)"
            },
            v2: {
              description: "The value of the flag that produces the same behavior as when the flag is not configured at all\n\nEven though it is called 'v2', this is the official name of this field. In\nany future versions of CDK (v3, v4, ...), this field will still be called 'v2'.\n\nThe structure of this field is a historical accident. See the comment on\n`unconfiguredBehavesLike` for more information.",
              default: false
            }
          }
        },
        MissingContext: {
          description: "Represents a missing piece of context.",
          type: "object",
          properties: {
            key: {
              description: "The missing context key.",
              type: "string"
            },
            provider: {
              $ref: "#/definitions/ContextProvider",
              description: "The provider from which we expect this context key to be obtained."
            },
            props: {
              $ref: "#/definitions/ContextQueryProperties",
              description: "A set of provider-specific options."
            }
          },
          required: [
            "key",
            "props",
            "provider"
          ]
        },
        ContextProvider: {
          description: "Identifier for the context provider",
          type: "string",
          enum: [
            "ami",
            "availability-zones",
            "hosted-zone",
            "ssm",
            "vpc-provider",
            "endpoint-service-availability-zones",
            "load-balancer",
            "load-balancer-listener",
            "security-group",
            "key-provider",
            "cc-api-provider",
            "plugin"
          ]
        },
        ContextQueryProperties: {
          anyOf: [
            {
              $ref: "#/definitions/AmiContextQuery"
            },
            {
              $ref: "#/definitions/AvailabilityZonesContextQuery"
            },
            {
              $ref: "#/definitions/HostedZoneContextQuery"
            },
            {
              $ref: "#/definitions/SSMParameterContextQuery"
            },
            {
              $ref: "#/definitions/VpcContextQuery"
            },
            {
              $ref: "#/definitions/EndpointServiceAvailabilityZonesContextQuery"
            },
            {
              $ref: "#/definitions/LoadBalancerContextQuery"
            },
            {
              $ref: "#/definitions/LoadBalancerListenerContextQuery"
            },
            {
              $ref: "#/definitions/SecurityGroupContextQuery"
            },
            {
              $ref: "#/definitions/KeyContextQuery"
            },
            {
              $ref: "#/definitions/CcApiContextQuery"
            },
            {
              $ref: "#/definitions/PluginContextQuery"
            }
          ]
        },
        AmiContextQuery: {
          description: "Query to AMI context provider",
          type: "object",
          properties: {
            owners: {
              description: "Owners to DescribeImages call (Default - All owners)",
              type: "array",
              items: {
                type: "string"
              }
            },
            filters: {
              description: "Filters to DescribeImages call",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  type: "string"
                }
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "filters",
            "region"
          ]
        },
        AvailabilityZonesContextQuery: {
          description: "Query to availability zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        HostedZoneContextQuery: {
          description: "Query to hosted zone context provider",
          type: "object",
          properties: {
            domainName: {
              description: "The domain name e.g. example.com to lookup",
              type: "string"
            },
            privateZone: {
              description: "True if the zone you want to find is a private hosted zone",
              default: false,
              type: "boolean"
            },
            vpcId: {
              description: "The VPC ID to that the private zone must be associated with\n\nIf you provide VPC ID and privateZone is false, this will return no results\nand raise an error. (Default - Required if privateZone=true)",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "domainName",
            "region"
          ]
        },
        SSMParameterContextQuery: {
          description: "Query to SSM Parameter Context Provider",
          type: "object",
          properties: {
            parameterName: {
              description: "Parameter name to query",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "parameterName",
            "region"
          ]
        },
        VpcContextQuery: {
          description: "Query input for looking up a VPC",
          type: "object",
          properties: {
            filter: {
              description: "Filters to apply to the VPC\n\nFilter parameters are the same as passed to DescribeVpcs.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            returnAsymmetricSubnets: {
              description: "Whether to populate the subnetGroups field of the `VpcContextResponse`,\nwhich contains potentially asymmetric subnet groups.",
              default: false,
              type: "boolean"
            },
            subnetGroupNameTag: {
              description: "Optional tag for subnet group name.\nIf not provided, we'll look at the aws-cdk:subnet-name tag.\nIf the subnet does not have the specified tag,\nwe'll use its type as the name. (Default 'aws-cdk:subnet-name')",
              type: "string"
            },
            returnVpnGateways: {
              description: "Whether to populate the `vpnGatewayId` field of the `VpcContextResponse`,\nwhich contains the VPN Gateway ID, if one exists. You can explicitly\ndisable this in order to avoid the lookup if you know the VPC does not have\na VPN Gatway attached. (Default true)",
              type: "boolean"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "filter",
            "region"
          ]
        },
        EndpointServiceAvailabilityZonesContextQuery: {
          description: "Query to endpoint service context provider",
          type: "object",
          properties: {
            serviceName: {
              description: "Query service name",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region",
            "serviceName"
          ]
        },
        LoadBalancerContextQuery: {
          description: "Query input for looking up a load balancer",
          type: "object",
          properties: {
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        LoadBalancerType: {
          description: "Type of load balancer",
          type: "string",
          enum: [
            "network",
            "application"
          ]
        },
        LoadBalancerListenerContextQuery: {
          description: "Query input for looking up a load balancer listener",
          type: "object",
          properties: {
            listenerArn: {
              description: "Find by listener's arn (Default - does not find by listener arn)",
              type: "string"
            },
            listenerProtocol: {
              description: "Filter by listener protocol (Default - does not filter by listener protocol)",
              enum: [
                "HTTP",
                "HTTPS",
                "TCP",
                "TCP_UDP",
                "TLS",
                "UDP"
              ],
              type: "string"
            },
            listenerPort: {
              description: "Filter listeners by listener port (Default - does not filter by a listener port)",
              type: "number"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        SecurityGroupContextQuery: {
          description: "Query input for looking up a security group",
          type: "object",
          properties: {
            securityGroupId: {
              description: "Security group id (Default - None)",
              type: "string"
            },
            securityGroupName: {
              description: "Security group name (Default - None)",
              type: "string"
            },
            vpcId: {
              description: "VPC ID (Default - None)",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        KeyContextQuery: {
          description: "Query input for looking up a KMS Key",
          type: "object",
          properties: {
            aliasName: {
              description: "Alias name used to search the Key",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "aliasName",
            "region"
          ]
        },
        CcApiContextQuery: {
          description: "Query input for lookup up CloudFormation resources using CC API\n\nThe example below is required to successfully compile CDK (otherwise,\nthe CDK build will generate a synthetic example for the below, but it\ndoesn't have enough type information about the literal string union\nto generate a validly compiling example).",
          type: "object",
          properties: {
            typeName: {
              description: "The CloudFormation resource type.\nSee https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/supported-resources.html",
              type: "string"
            },
            exactIdentifier: {
              description: "Identifier of the resource to look up using `GetResource`.\n\nSpecifying exactIdentifier will return exactly one result, or throw an error\nunless `ignoreErrorOnMissingContext` is set. (Default - Either exactIdentifier or propertyMatch should be specified.)",
              type: "string"
            },
            resourceModel: {
              description: "The resource model to use to select the resources, using `ListResources`..\n\nThis is needed for sub-resources where the parent Arn is required.\n\nSee https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-list.html#resource-operations-list-containers (Default - no resource Model is provided)",
              $ref: "#/definitions/Record%3Cstring%2Cunknown%3E"
            },
            propertyMatch: {
              description: "Returns any resources matching these properties, using `ListResources`.\n\nBy default, specifying propertyMatch will successfully return 0 or more\nresults. To throw an error if the number of results is unexpected (and\nprevent the query results from being committed to context), specify\n`expectedMatchCount`.\n\n## Notes on property completeness\n\nCloudControl API's `ListResources` may return fewer properties than\n`GetResource` would, depending on the resource implementation.\n\nThe resources that `propertyMatch` matches against will *only ever* be the\nproperties returned by the `ListResources` call. (Default - Either exactIdentifier or propertyMatch should be specified.)",
              $ref: "#/definitions/Record%3Cstring%2Cunknown%3E"
            },
            propertiesToReturn: {
              description: "This is a set of properties returned from CC API that we want to return from ContextQuery.\n\nIf any properties listed here are absent from the target resource, an error will be thrown.\n\nThe returned object will always include the key `Identifier` with the CC-API returned\nfield `Identifier`.\n\n## Notes on property completeness\n\nCloudControl API's `ListResources` may return fewer properties than\n`GetResource` would, depending on the resource implementation.\n\nThe returned properties here are *currently* selected from the response\nobject that CloudControl API returns to the CDK CLI.\n\nHowever, if we find there is need to do so, we may decide to change this\nbehavior in the future: we might change it to perform an additional\n`GetResource` call for resources matched by `propertyMatch`.",
              type: "array",
              items: {
                type: "string"
              }
            },
            expectedMatchCount: {
              description: "Expected count of results if `propertyMatch` is specified.\n\nIf the expected result count does not match the actual count,\nby default an error is produced and the result is not committed to cached\ncontext, and the user can correct the situation and try again without\nhaving to manually clear out the context key using `cdk context --remove`\n\nIf the value of * `ignoreErrorOnMissingContext` is `true`, the value of\n`expectedMatchCount` is `at-least-one | exactly-one` and the number\nof found resources is 0, `dummyValue` is returned and committed to context\ninstead. (Default 'any')",
              enum: [
                "any",
                "at-least-one",
                "at-most-one",
                "exactly-one"
              ],
              type: "string"
            },
            dummyValue: {
              description: "The value to return if the resource was not found and `ignoreErrorOnMissingContext` is true.\n\nIf supplied, `dummyValue` should be an array of objects.\n\n`dummyValue` does not have to have elements, and it may have objects with\ndifferent properties than the properties in `propertiesToReturn`, but it\nwill be easiest for downstream code if the `dummyValue` conforms to\nthe expected response shape. (Default - No dummy value available)"
            },
            ignoreErrorOnMissingContext: {
              description: "Ignore an error and return the `dummyValue` instead if the resource was not found.\n\n- In case of an `exactIdentifier` lookup, return the `dummyValue` if the resource with\n  that identifier was not found.\n- In case of a `propertyMatch` lookup, return the `dummyValue` if `expectedMatchCount`\n  is `at-least-one | exactly-one` and the number of resources found was 0.\n\nif `ignoreErrorOnMissingContext` is set, `dummyValue` should be set and be an array.",
              default: false,
              type: "boolean"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "propertiesToReturn",
            "region",
            "typeName"
          ]
        },
        "Record<string,unknown>": {
          type: "object"
        },
        PluginContextQuery: {
          description: "Query input for plugins\n\nThis alternate branch is necessary because it needs to be able to escape all type checking\nwe do on on the cloud assembly -- we cannot know the properties that will be used a priori.",
          type: "object",
          additionalProperties: {},
          properties: {
            pluginName: {
              description: "The name of the plugin",
              type: "string"
            }
          },
          required: [
            "pluginName"
          ]
        },
        RuntimeInfo: {
          description: "Information about the application's runtime components.",
          type: "object",
          properties: {
            libraries: {
              description: "The list of libraries loaded in the application, associated with their versions.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "libraries"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/integ.schema.json
var require_integ_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/integ.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/IntegManifest",
      definitions: {
        IntegManifest: {
          description: "Definitions for the integration testing manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            enableLookups: {
              description: "Enable lookups for this test. If lookups are enabled\nthen `stackUpdateWorkflow` must be set to false.\nLookups should only be enabled when you are explicitly testing\nlookups.",
              default: false,
              type: "boolean"
            },
            synthContext: {
              description: "Additional context to use when performing\na synth. Any context provided here will override\nany default context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            testCases: {
              description: "test cases",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/TestCase"
              }
            }
          },
          required: [
            "testCases",
            "version"
          ]
        },
        TestCase: {
          description: "Represents an integration test case",
          type: "object",
          properties: {
            stacks: {
              description: "Stacks that should be tested as part of this test case\nThe stackNames will be passed as args to the cdk commands\nso dependent stacks will be automatically deployed unless\n`exclusively` is passed",
              type: "array",
              items: {
                type: "string"
              }
            },
            assertionStack: {
              description: "The node id of the stack that contains assertions.\nThis is the value that can be used to deploy the stack with the CDK CLI (Default - no assertion stack)",
              type: "string"
            },
            assertionStackName: {
              description: "The name of the stack that contains assertions (Default - no assertion stack)",
              type: "string"
            },
            stackUpdateWorkflow: {
              description: "Run update workflow on this test case\nThis should only be set to false to test scenarios\nthat are not possible to test as part of the update workflow (Default true)",
              type: "boolean"
            },
            cdkCommandOptions: {
              description: "Additional options to use for each CDK command (Default - runner default options)",
              $ref: "#/definitions/CdkCommands"
            },
            hooks: {
              description: "Additional commands to run at predefined points in the test workflow\n\ne.g. { postDeploy: ['yarn', 'test'] } (Default - no hooks)",
              $ref: "#/definitions/Hooks"
            },
            diffAssets: {
              description: "Whether or not to include asset hashes in the diff\nAsset hashes can introduces a lot of unneccessary noise into tests,\nbut there are some cases where asset hashes _should_ be included. For example\nany tests involving custom resources or bundling",
              default: false,
              type: "boolean"
            },
            allowDestroy: {
              description: "List of CloudFormation resource types in this stack that can\nbe destroyed as part of an update without failing the test.\n\nThis list should only include resources that for this specific\nintegration test we are sure will not cause errors or an outage if\ndestroyed. For example, maybe we know that a new resource will be created\nfirst before the old resource is destroyed which prevents any outage.\n\ne.g. ['AWS::IAM::Role'] (Default - do not allow destruction of any resources on update)",
              type: "array",
              items: {
                type: "string"
              }
            },
            regions: {
              description: "Limit deployment to these regions (Default - can run in any region)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "stacks"
          ]
        },
        CdkCommands: {
          description: "Options for specific cdk commands that are run\nas part of the integration test workflow",
          type: "object",
          properties: {
            deploy: {
              description: "Options to for the cdk deploy command (Default - default deploy options)",
              $ref: "#/definitions/DeployCommand"
            },
            destroy: {
              description: "Options to for the cdk destroy command (Default - default destroy options)",
              $ref: "#/definitions/DestroyCommand"
            }
          }
        },
        DeployCommand: {
          description: "Represents a cdk deploy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DeployOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DeployOptions: {
          description: "Options to use with cdk deploy",
          type: "object",
          properties: {
            exclusively: {
              description: "Only perform action on the given stack",
              default: false,
              type: "boolean"
            },
            toolkitStackName: {
              description: "Name of the toolkit stack to use/deploy (Default CDKToolkit)",
              type: "string"
            },
            reuseAssets: {
              description: "Reuse the assets with the given asset IDs (Default - do not reuse assets)",
              type: "array",
              items: {
                type: "string"
              }
            },
            changeSetName: {
              description: "Optional name to use for the CloudFormation change set.\nIf not provided, a name will be generated automatically. (Default - auto generate a name)",
              type: "string"
            },
            force: {
              description: "Always deploy, even if templates are identical.",
              default: false,
              type: "boolean"
            },
            rollback: {
              description: "Rollback failed deployments (Default true)",
              type: "boolean"
            },
            notificationArns: {
              description: "ARNs of SNS topics that CloudFormation will notify with stack related events (Default - no notifications)",
              type: "array",
              items: {
                type: "string"
              }
            },
            requireApproval: {
              description: "What kind of security changes require approval (Default RequireApproval.NEVER)",
              enum: [
                "any-change",
                "broadening",
                "never"
              ],
              type: "string"
            },
            execute: {
              description: "Whether to execute the ChangeSet\nNot providing `execute` parameter will result in execution of ChangeSet (Default true)",
              type: "boolean"
            },
            parameters: {
              description: "Additional parameters for CloudFormation at deploy time (Default [object Object])",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            usePreviousParameters: {
              description: "Use previous values for unspecified parameters\n\nIf not set, all parameters must be specified for every deployment. (Default true)",
              type: "boolean"
            },
            outputsFile: {
              description: "Path to file where stack outputs will be written after a successful deploy as JSON (Default - Outputs are not written to any file)",
              type: "string"
            },
            ci: {
              description: "Whether we are on a CI system",
              default: false,
              type: "boolean"
            },
            concurrency: {
              description: "Deploy multiple stacks in parallel (Default 1)",
              type: "number"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        DestroyCommand: {
          description: "Represents a cdk destroy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DestroyOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DestroyOptions: {
          description: "Options to use with cdk destroy",
          type: "object",
          properties: {
            force: {
              description: "Do not ask for permission before destroying stacks",
              default: false,
              type: "boolean"
            },
            exclusively: {
              description: "Only destroy the given stack",
              default: false,
              type: "boolean"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        Hooks: {
          description: "Commands to run at predefined points during the\nintegration test workflow",
          type: "object",
          properties: {
            preDeploy: {
              description: "Commands to run prior to deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDeploy: {
              description: "Commands to run prior after deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            preDestroy: {
              description: "Commands to run prior to destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDestroy: {
              description: "Commands to run after destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            }
          }
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/version.json
var require_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/version.json"(exports2, module2) {
    module2.exports = {
      schemaHash: "1b06659a117c44714e2e52854571bb1b45b765b277bb1c208bc4b7ea01f6a684",
      $comment: "Do not hold back the version on additions: jsonschema validation of the manifest by the consumer will trigger errors on unexpected fields.",
      revision: 50
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/manifest.ts
var manifest_exports = {};
__export(manifest_exports, {
  Manifest: () => Manifest,
  VERSION_MISMATCH: () => VERSION_MISMATCH
});
function stripEnumErrors(errors) {
  return errors.filter((e13) => typeof e13.schema === "string" || !("enum" in e13.schema));
}
var fs, jsonschema, semver, VERSION_MISMATCH, CLI_VERSION, ASSETS_SCHEMA, ASSEMBLY_SCHEMA, INTEG_SCHEMA, SCHEMA_VERSION, Manifest;
var init_manifest = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/manifest.ts"() {
    "use strict";
    fs = __toESM(require("fs"));
    jsonschema = __toESM(require_lib());
    semver = __toESM(require_semver2());
    init_cloud_assembly();
    VERSION_MISMATCH = "Cloud assembly schema version mismatch";
    CLI_VERSION = require_cli_version();
    ASSETS_SCHEMA = require_assets_schema();
    ASSEMBLY_SCHEMA = require_cloud_assembly_schema();
    INTEG_SCHEMA = require_integ_schema();
    SCHEMA_VERSION = require_version();
    Manifest = class _Manifest {
      static {
        __name(this, "Manifest");
      }
      /**
       * Validates and saves the cloud assembly manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveAssemblyManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, ASSEMBLY_SCHEMA);
      }
      /**
       * Load and validates the cloud assembly manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadAssemblyManifest(filePath, options) {
        return _Manifest.loadManifest(filePath, ASSEMBLY_SCHEMA, _Manifest.patchStackTagsOnRead, options);
      }
      /**
       * Validates and saves the asset manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveAssetManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, ASSETS_SCHEMA);
      }
      /**
       * Load and validates the asset manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadAssetManifest(filePath) {
        return _Manifest.loadManifest(filePath, ASSETS_SCHEMA);
      }
      /**
       * Validates and saves the integ manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveIntegManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, INTEG_SCHEMA);
      }
      /**
       * Load and validates the integ manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadIntegManifest(filePath) {
        const manifest = this.loadManifest(filePath, INTEG_SCHEMA);
        return {
          ...manifest,
          testCases: manifest.testCases ?? []
        };
      }
      /**
       * Fetch the current schema version number.
       */
      static version() {
        return `${SCHEMA_VERSION.revision}.0.0`;
      }
      /**
       * Return the CLI version that supports this Cloud Assembly Schema version
       */
      static cliVersion() {
        const version = CLI_VERSION.version;
        return version ? version : void 0;
      }
      /**
       * Deprecated
       * @deprecated use `saveAssemblyManifest()`
       */
      static save(manifest, filePath) {
        return this.saveAssemblyManifest(manifest, filePath);
      }
      /**
       * Deprecated
       * @deprecated use `loadAssemblyManifest()`
       */
      static load(filePath) {
        return this.loadAssemblyManifest(filePath);
      }
      static validate(manifest, schema, options) {
        function parseVersion(version) {
          const ver = semver.valid(version);
          if (!ver) {
            throw new Error(`Invalid semver string: "${version}"`);
          }
          return ver;
        }
        __name(parseVersion, "parseVersion");
        const maxSupported = semver.major(parseVersion(_Manifest.version()));
        const actual = parseVersion(manifest.version);
        if (maxSupported < semver.major(actual) && !options?.skipVersionCheck) {
          const cliVersion2 = manifest.minimumCliVersion;
          let cliWarning = "";
          if (cliVersion2) {
            cliWarning = `. You need at least CLI version ${cliVersion2} to read this manifest.`;
          }
          throw new Error(
            `${VERSION_MISMATCH}: Maximum schema version supported is ${maxSupported}.x.x, but found ${actual}${cliWarning}`
          );
        }
        const validator = new jsonschema.Validator();
        const result2 = validator.validate(manifest, schema, {
          // does exist but is not in the TypeScript definitions
          nestedErrors: true,
          allowUnknownAttributes: false,
          preValidateProperty: _Manifest.validateAssumeRoleAdditionalOptions
        });
        let errors = result2.errors;
        if (options?.skipEnumCheck) {
          errors = stripEnumErrors(errors);
        }
        if (errors.length > 0) {
          throw new Error(`Invalid assembly manifest:
${errors.map((e13) => e13.stack).join("\n")}`);
        }
      }
      static saveManifest(manifest, filePath, schema, preprocess) {
        let withVersion = {
          ...manifest,
          version: _Manifest.version(),
          minimumCliVersion: _Manifest.cliVersion()
        };
        _Manifest.validate(withVersion, schema);
        if (preprocess) {
          withVersion = preprocess(withVersion);
        }
        fs.writeFileSync(filePath, JSON.stringify(withVersion, void 0, 2));
      }
      static loadManifest(filePath, schema, preprocess, options) {
        const contents = fs.readFileSync(filePath, { encoding: "utf-8" });
        let obj;
        try {
          obj = JSON.parse(contents);
        } catch (e13) {
          throw new Error(`${e13.message}, while parsing ${JSON.stringify(contents)}`);
        }
        if (preprocess) {
          obj = preprocess(obj);
        }
        _Manifest.validate(obj, schema, options);
        return obj;
      }
      /**
       * Fix the casing of stack tags entries
       *
       * At the very beginning of the CDK we used to emit stack tags as an object with
       * `{ Key, Value }` keys; this had the "advantage" that we could stick those
       * tags directly into the `CreateChangeSet` call.
       *
       * Then we later on used jsii on the assembly schema and we were forced to type
       * the in-memory objects as `{ key, value }` with lowercase letters. Now the
       * objects have a different on-disk and in-memory format, and we need to convert
       * between them.
       *
       * For backwards compatibility reasons, we used to convert lowercase in-memory
       * to uppercase on-disk variant until very recently. This is now unnecessary,
       * since no officially supported CDK tools read the stack tags from the
       * metadata; the CLI and toolkit library read stack tags from the artifact
       * properties.
       *
       * So although we don't emit uppercase stack tag objects anymore, we might still read
       * manifests that have them. Because the manifest we read must pass JSON Schema
       * validation (which expects lowercase tag objects), we have to fix the casing
       * of these objects after reading from disk and before validating.
       *
       * That's what this function does.
       */
      static patchStackTagsOnRead(manifest) {
        const artifacts = Object.values(manifest.artifacts ?? {}).filter((artifact) => artifact.type === "aws:cloudformation:stack" /* AWS_CLOUDFORMATION_STACK */);
        for (const artifact of artifacts) {
          const tagMetadata = Object.values(artifact.metadata ?? {}).flatMap((x13) => x13).filter((entry) => entry.type === "aws:cdk:stack-tags" /* STACK_TAGS */);
          for (const entry of tagMetadata) {
            const tags = entry.data;
            for (const tag2 of tags ?? []) {
              const t13 = tag2;
              if ("Key" in t13) {
                t13.key = t13.Key;
                delete t13.Key;
              }
              if ("Value" in t13) {
                t13.value = t13.Value;
                delete t13.Value;
              }
            }
          }
        }
        return manifest;
      }
      /**
       * Validates that `assumeRoleAdditionalOptions` doesn't contain nor `ExternalId` neither `RoleArn`, as they
       * should have dedicated properties preceding this (e.g `assumeRoleArn` and `assumeRoleExternalId`).
       */
      static validateAssumeRoleAdditionalOptions(instance, key, _schema, _options, _ctx) {
        if (key !== "assumeRoleAdditionalOptions") {
          return;
        }
        const assumeRoleOptions = instance[key];
        if (assumeRoleOptions?.RoleArn) {
          throw new Error(`RoleArn is not allowed inside '${key}'`);
        }
        if (assumeRoleOptions?.ExternalId) {
          throw new Error(`ExternalId is not allowed inside '${key}'`);
        }
      }
    };
    __name(stripEnumErrors, "stripEnumErrors");
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/schema.ts
var init_schema3 = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/common.ts
var RequireApproval;
var init_common = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/common.ts"() {
    "use strict";
    RequireApproval = /* @__PURE__ */ ((RequireApproval5) => {
      RequireApproval5["NEVER"] = "never";
      RequireApproval5["ANYCHANGE"] = "any-change";
      RequireApproval5["BROADENING"] = "broadening";
      return RequireApproval5;
    })(RequireApproval || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/deploy.ts
var init_deploy = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/deploy.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/destroy.ts
var init_destroy = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/destroy.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/index.ts
var init_commands = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/index.ts"() {
    "use strict";
    init_common();
    init_deploy();
    init_destroy();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/test-case.ts
var init_test_case = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/test-case.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/index.ts
var integ_tests_exports = {};
__export(integ_tests_exports, {
  RequireApproval: () => RequireApproval
});
var init_integ_tests = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/index.ts"() {
    "use strict";
    init_schema3();
    init_commands();
    init_test_case();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/index.js
var require_lib2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/lib/index.js"(exports2) {
    "use strict";
    var __createBinding3 = exports2 && exports2.__createBinding || (Object.create ? (function(o13, m13, k13, k22) {
      if (k22 === void 0) k22 = k13;
      var desc = Object.getOwnPropertyDescriptor(m13, k13);
      if (!desc || ("get" in desc ? !m13.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: /* @__PURE__ */ __name(function() {
          return m13[k13];
        }, "get") };
      }
      Object.defineProperty(o13, k22, desc);
    }) : (function(o13, m13, k13, k22) {
      if (k22 === void 0) k22 = k13;
      o13[k22] = m13[k13];
    }));
    var __exportStar3 = exports2 && exports2.__exportStar || function(m13, exports3) {
      for (var p13 in m13) if (p13 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p13)) __createBinding3(exports3, m13, p13);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar3((init_cloud_assembly(), __toCommonJS(cloud_assembly_exports)), exports2);
    __exportStar3((init_assets(), __toCommonJS(assets_exports)), exports2);
    __exportStar3((init_manifest(), __toCommonJS(manifest_exports)), exports2);
    __exportStar3((init_integ_tests(), __toCommonJS(integ_tests_exports)), exports2);
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/metadata.ts
var metadata_exports = {};
__export(metadata_exports, {
  PATH_METADATA_KEY: () => PATH_METADATA_KEY,
  SynthesisMessageLevel: () => SynthesisMessageLevel
});
var PATH_METADATA_KEY, SynthesisMessageLevel;
var init_metadata = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/metadata.ts"() {
    "use strict";
    PATH_METADATA_KEY = "aws:cdk:path";
    SynthesisMessageLevel = /* @__PURE__ */ ((SynthesisMessageLevel3) => {
      SynthesisMessageLevel3["INFO"] = "info";
      SynthesisMessageLevel3["WARNING"] = "warning";
      SynthesisMessageLevel3["ERROR"] = "error";
      return SynthesisMessageLevel3;
    })(SynthesisMessageLevel || {});
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/private/error.ts
var ASSEMBLY_ERROR_SYMBOL, CloudAssemblyError;
var init_error = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/private/error.ts"() {
    "use strict";
    ASSEMBLY_ERROR_SYMBOL = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.CloudAssemblyError");
    CloudAssemblyError = class _CloudAssemblyError extends Error {
      static {
        __name(this, "CloudAssemblyError");
      }
      #time;
      /**
       * The time the error was thrown.
       */
      get time() {
        return this.#time;
      }
      get type() {
        return "assembly";
      }
      constructor(msg) {
        super(msg);
        Object.setPrototypeOf(this, _CloudAssemblyError.prototype);
        Object.defineProperty(this, ASSEMBLY_ERROR_SYMBOL, { value: true });
        this.name = new.target.name;
        this.#time = (/* @__PURE__ */ new Date()).toISOString();
      }
    };
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/cloud-artifact.ts
var cloud_artifact_exports = {};
__export(cloud_artifact_exports, {
  CloudArtifact: () => CloudArtifact
});
var cxschema, CloudArtifact;
var init_cloud_artifact = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/cloud-artifact.ts"() {
    "use strict";
    cxschema = __toESM(require_lib2());
    init_metadata();
    init_error();
    CloudArtifact = class {
      constructor(assembly, id, manifest) {
        this.assembly = assembly;
        this.id = id;
        this.manifest = manifest;
        this.messages = this.renderMessages();
        this._dependencyIDs = manifest.dependencies || [];
      }
      static {
        __name(this, "CloudArtifact");
      }
      /**
       * Returns a subclass of `CloudArtifact` based on the artifact type defined in the artifact manifest.
       *
       * @param assembly - The cloud assembly from which to load the artifact
       * @param id - The artifact ID
       * @param artifact - The artifact manifest
       * @returns the `CloudArtifact` that matches the artifact type or `undefined` if it's an artifact type that is unrecognized by this module.
       */
      static fromManifest(assembly, id, artifact) {
        void assembly, void id, void artifact;
        throw new CloudAssemblyError("Implementation not overridden yet");
      }
      /**
       * Returns all the artifacts that this artifact depends on.
       */
      get dependencies() {
        if (this._deps) {
          return this._deps;
        }
        this._deps = this._dependencyIDs.map((id) => {
          const dep = this.assembly.tryGetArtifact(id);
          if (!dep) {
            throw new CloudAssemblyError(`Artifact ${this.id} depends on non-existing artifact ${id}`);
          }
          return dep;
        });
        return this._deps;
      }
      /**
       * @returns all the metadata entries of a specific type in this artifact.
       */
      findMetadataByType(type) {
        const result2 = new Array();
        for (const path44 of Object.keys(this.manifest.metadata || {})) {
          for (const entry of (this.manifest.metadata || {})[path44]) {
            if (entry.type === type) {
              result2.push({ path: path44, ...entry });
            }
          }
        }
        return result2;
      }
      renderMessages() {
        const messages = new Array();
        for (const [id, metadata] of Object.entries(this.manifest.metadata || {})) {
          for (const entry of metadata) {
            let level;
            switch (entry.type) {
              case cxschema.ArtifactMetadataEntryType.WARN:
                level = "warning" /* WARNING */;
                break;
              case cxschema.ArtifactMetadataEntryType.ERROR:
                level = "error" /* ERROR */;
                break;
              case cxschema.ArtifactMetadataEntryType.INFO:
                level = "info" /* INFO */;
                break;
              default:
                continue;
            }
            messages.push({ level, entry, id });
          }
        }
        return messages;
      }
      /**
       * An identifier that shows where this artifact is located in the tree
       * of nested assemblies, based on their manifests. Defaults to the normal
       * id. Should only be used in user interfaces.
       */
      get hierarchicalId() {
        return this.manifest.displayName ?? this.id;
      }
    };
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/artifacts/asset-manifest-artifact.ts
var asset_manifest_artifact_exports = {};
__export(asset_manifest_artifact_exports, {
  AssetManifestArtifact: () => AssetManifestArtifact
});
var fs2, path, ASSET_MANIFEST_ARTIFACT_SYM, AssetManifestArtifact;
var init_asset_manifest_artifact = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/artifacts/asset-manifest-artifact.ts"() {
    "use strict";
    fs2 = __toESM(require("fs"));
    path = __toESM(require("path"));
    init_cloud_artifact();
    init_error();
    ASSET_MANIFEST_ARTIFACT_SYM = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.AssetManifestArtifact");
    AssetManifestArtifact = class extends CloudArtifact {
      static {
        __name(this, "AssetManifestArtifact");
      }
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `AssetManifestArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `AssetManifestArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isAssetManifestArtifact(art) {
        return art && typeof art === "object" && art[ASSET_MANIFEST_ARTIFACT_SYM];
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new CloudAssemblyError('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
      }
      /**
       * The Asset Manifest contents
       */
      get contents() {
        if (this._contents !== void 0) {
          return this._contents;
        }
        const contents = this._contents = JSON.parse(fs2.readFileSync(this.file, "utf-8"));
        return contents;
      }
    };
    Object.defineProperty(AssetManifestArtifact.prototype, ASSET_MANIFEST_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/environment.ts
var environment_exports = {};
__export(environment_exports, {
  EnvironmentUtils: () => EnvironmentUtils,
  UNKNOWN_ACCOUNT: () => UNKNOWN_ACCOUNT,
  UNKNOWN_REGION: () => UNKNOWN_REGION
});
var AWS_ENV_REGEX, UNKNOWN_ACCOUNT, UNKNOWN_REGION, EnvironmentUtils;
var init_environment = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/environment.ts"() {
    "use strict";
    init_error();
    AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
    UNKNOWN_ACCOUNT = "unknown-account";
    UNKNOWN_REGION = "unknown-region";
    EnvironmentUtils = class {
      static {
        __name(this, "EnvironmentUtils");
      }
      static parse(environment) {
        const env2 = AWS_ENV_REGEX.exec(environment);
        if (!env2) {
          throw new CloudAssemblyError(
            `Unable to parse environment specification "${environment}". Expected format: aws://account/region`
          );
        }
        const [, account, region] = env2;
        if (!account || !region) {
          throw new CloudAssemblyError(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
      }
      /**
       * Build an environment object from an account and region
       */
      static make(account, region) {
        return { account, region, name: this.format(account, region) };
      }
      /**
       * Format an environment string from an account and region
       */
      static format(account, region) {
        return `aws://${account}/${region}`;
      }
    };
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/artifacts/cloudformation-artifact.ts
var cloudformation_artifact_exports = {};
__export(cloudformation_artifact_exports, {
  CloudFormationStackArtifact: () => CloudFormationStackArtifact
});
var fs3, path2, cxschema2, CLOUDFORMATION_STACK_ARTIFACT_SYM, CloudFormationStackArtifact;
var init_cloudformation_artifact = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/artifacts/cloudformation-artifact.ts"() {
    "use strict";
    fs3 = __toESM(require("fs"));
    path2 = __toESM(require("path"));
    cxschema2 = __toESM(require_lib2());
    init_cloud_artifact();
    init_environment();
    init_error();
    CLOUDFORMATION_STACK_ARTIFACT_SYM = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.CloudFormationStackArtifact");
    CloudFormationStackArtifact = class extends CloudArtifact {
      static {
        __name(this, "CloudFormationStackArtifact");
      }
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `CloudFormationStackArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `CloudFormationStackArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isCloudFormationStackArtifact(art) {
        return art && typeof art === "object" && CLOUDFORMATION_STACK_ARTIFACT_SYM in art;
      }
      constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.templateFile) {
          throw new CloudAssemblyError('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
          throw new CloudAssemblyError("Invalid CloudFormation stack artifact. Missing environment");
        }
        this.environment = EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters ?? {};
        this.tags = properties.tags ?? {};
        this.notificationArns = properties.notificationArns;
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.assumeRoleAdditionalOptions = properties.assumeRoleAdditionalOptions;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema2.ArtifactMetadataEntryType.ASSET).map((e13) => e13.data);
        this.displayName = this.stackName === artifactId ? this.hierarchicalId : `${this.hierarchicalId} (${this.stackName})`;
        this.name = this.stackName;
        this.originalName = this.stackName;
      }
      /**
       * Full path to the template file
       */
      get templateFullPath() {
        return path2.join(this.assembly.directory, this.templateFile);
      }
      /**
       * The CloudFormation template for this stack.
       */
      get template() {
        if (this._template === void 0) {
          this._template = JSON.parse(fs3.readFileSync(this.templateFullPath, "utf-8"));
        }
        return this._template;
      }
    };
    Object.defineProperty(CloudFormationStackArtifact.prototype, CLOUDFORMATION_STACK_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/artifacts/nested-cloud-assembly-artifact.ts
var nested_cloud_assembly_artifact_exports = {};
__export(nested_cloud_assembly_artifact_exports, {
  NestedCloudAssemblyArtifact: () => NestedCloudAssemblyArtifact
});
var path3, NESTED_CLOUD_ASSEMBLY_SYM, NestedCloudAssemblyArtifact;
var init_nested_cloud_assembly_artifact = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/artifacts/nested-cloud-assembly-artifact.ts"() {
    "use strict";
    path3 = __toESM(require("path"));
    init_cloud_artifact();
    NESTED_CLOUD_ASSEMBLY_SYM = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.NestedCloudAssemblyArtifact");
    NestedCloudAssemblyArtifact = class extends CloudArtifact {
      static {
        __name(this, "NestedCloudAssemblyArtifact");
      }
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `NestedCloudAssemblyArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `NestedCloudAssemblyArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isNestedCloudAssemblyArtifact(art) {
        return art && typeof art === "object" && NESTED_CLOUD_ASSEMBLY_SYM in art;
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        this.directoryName = properties.directoryName;
        this.displayName = properties.displayName ?? name;
      }
      /**
       * Full path to the nested assembly directory
       */
      get fullPath() {
        return path3.join(this.assembly.directory, this.directoryName);
      }
    };
    Object.defineProperty(NestedCloudAssemblyArtifact.prototype, NESTED_CLOUD_ASSEMBLY_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/artifacts/tree-cloud-artifact.ts
var tree_cloud_artifact_exports = {};
__export(tree_cloud_artifact_exports, {
  TreeCloudArtifact: () => TreeCloudArtifact
});
var TREE_CLOUD_ARTIFACT_SYM, TreeCloudArtifact;
var init_tree_cloud_artifact = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/artifacts/tree-cloud-artifact.ts"() {
    "use strict";
    init_cloud_artifact();
    init_error();
    TREE_CLOUD_ARTIFACT_SYM = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.TreeCloudArtifact");
    TreeCloudArtifact = class extends CloudArtifact {
      static {
        __name(this, "TreeCloudArtifact");
      }
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `TreeCloudArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `TreeCloudArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isTreeCloudArtifact(art) {
        return art && typeof art === "object" && TREE_CLOUD_ARTIFACT_SYM in art;
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new CloudAssemblyError('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
      }
    };
    Object.defineProperty(TreeCloudArtifact.prototype, TREE_CLOUD_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/cloud-artifact-aug.ts
var cloud_artifact_aug_exports = {};
var cxschema3;
var init_cloud_artifact_aug = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/cloud-artifact-aug.ts"() {
    "use strict";
    cxschema3 = __toESM(require_lib2());
    init_asset_manifest_artifact();
    init_cloudformation_artifact();
    init_nested_cloud_assembly_artifact();
    init_tree_cloud_artifact();
    init_cloud_artifact();
    CloudArtifact.fromManifest = /* @__PURE__ */ __name(function fromManifest(assembly, id, artifact) {
      switch (artifact.type) {
        case cxschema3.ArtifactType.AWS_CLOUDFORMATION_STACK:
          return new CloudFormationStackArtifact(assembly, id, artifact);
        case cxschema3.ArtifactType.CDK_TREE:
          return new TreeCloudArtifact(assembly, id, artifact);
        case cxschema3.ArtifactType.ASSET_MANIFEST:
          return new AssetManifestArtifact(assembly, id, artifact);
        case cxschema3.ArtifactType.NESTED_CLOUD_ASSEMBLY:
          return new NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
          return void 0;
      }
    }, "fromManifest");
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/private/toposort.ts
function topologicalSort(xs, keyFn, depFn) {
  const remaining = /* @__PURE__ */ new Map();
  for (const element of xs) {
    const key = keyFn(element);
    remaining.set(key, { key, element, dependencies: depFn(element) });
  }
  const ret = new Array();
  while (remaining.size > 0) {
    const selectable = Array.from(remaining.values()).filter((e13) => e13.dependencies.every((d13) => !remaining.has(d13)));
    selectable.sort((a13, b13) => a13.key < b13.key ? -1 : b13.key < a13.key ? 1 : 0);
    for (const selected of selectable) {
      ret.push(selected.element);
      remaining.delete(selected.key);
    }
    if (selectable.length === 0) {
      throw new CloudAssemblyError(`Could not determine ordering between: ${Array.from(remaining.keys()).join(", ")}`);
    }
  }
  return ret;
}
var init_toposort = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/private/toposort.ts"() {
    "use strict";
    init_error();
    __name(topologicalSort, "topologicalSort");
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/cloud-assembly.ts
var cloud_assembly_exports2 = {};
__export(cloud_assembly_exports2, {
  CloudAssembly: () => CloudAssembly,
  CloudAssemblyBuilder: () => CloudAssemblyBuilder
});
function filterUndefined(obj) {
  if (Array.isArray(obj)) {
    return obj.filter((x13) => x13 !== void 0).map((x13) => filterUndefined(x13));
  }
  if (typeof obj === "object") {
    const ret = {};
    for (const [key, value] of Object.entries(obj)) {
      if (value === void 0) {
        continue;
      }
      ret[key] = filterUndefined(value);
    }
    return ret;
  }
  return obj;
}
function ignore(_x) {
  return;
}
function determineOutputDirectory(outdir) {
  if (outdir) {
    return outdir;
  }
  const tmpDir = fs4.mkdtempSync(path4.join(fs4.realpathSync(os.tmpdir()), "cdk.out"));
  TEMPORARY_ASSEMBLY_DIRS.push(tmpDir);
  return outdir ?? tmpDir;
}
function ensureDirSync(dir) {
  if (fs4.existsSync(dir)) {
    if (!fs4.statSync(dir).isDirectory()) {
      throw new CloudAssemblyError(`${dir} must be a directory`);
    }
  } else {
    fs4.mkdirSync(dir, { recursive: true });
  }
}
var fs4, os, path4, cxschema4, CLOUD_ASSEMBLY_SYMBOL, MANIFEST_FILE, CloudAssembly, CloudAssemblyBuilder, TEMPORARY_ASSEMBLY_DIRS;
var init_cloud_assembly2 = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/cloud-assembly.ts"() {
    "use strict";
    fs4 = __toESM(require("fs"));
    os = __toESM(require("os"));
    path4 = __toESM(require("path"));
    cxschema4 = __toESM(require_lib2());
    init_cloudformation_artifact();
    init_nested_cloud_assembly_artifact();
    init_tree_cloud_artifact();
    init_cloud_artifact();
    init_error();
    init_toposort();
    CLOUD_ASSEMBLY_SYMBOL = /* @__PURE__ */ Symbol.for("@aws-cdk/cx-api.CloudAssembly");
    MANIFEST_FILE = "manifest.json";
    CloudAssembly = class {
      static {
        __name(this, "CloudAssembly");
      }
      /**
       * Return whether the given object is a CloudAssembly.
       *
       * We do attribute detection since we can't reliably use 'instanceof'.
       */
      static isCloudAssembly(x13) {
        return x13 !== null && typeof x13 === "object" && CLOUD_ASSEMBLY_SYMBOL in x13;
      }
      /**
       * Cleans up any temporary assembly directories that got created in this process
       *
       * If a Cloud Assembly is emitted to a temporary directory, its directory gets
       * added to a list. This function iterates over that list and deletes each
       * directory in it, to free up disk space.
       *
       * This function will normally be called automatically during Node process
       * exit and so you don't need to call this. However, some test environments do
       * not properly trigger Node's `exit` event. Notably: Jest does not trigger
       * the `exit` event (<https://github.com/jestjs/jest/issues/10927>).
       *
       * ## Cleaning up temporary directories in jest
       *
       * For Jest, you have to make sure this function is called at the end of the
       * test suite instead:
       *
       * ```js
       * import { CloudAssembly } from 'aws-cdk-lib/cx-api';
       *
       * afterAll(CloudAssembly.cleanupTemporaryDirectories);
       * ```
       *
       * Alternatively, you can use the `setupFilesAfterEnv` feature and use a
       * provided helper script to automatically inject the above into every
       * test file, so you don't have to do it by hand.
       *
       * ```
       * $ npx jest --setupFilesAfterEnv aws-cdk-lib/testhelpers/jest-autoclean
       * ```
       *
       * Or put the following into `jest.config.js`:
       *
       * ```js
       * module.exports = {
       *   // ...
       *   setupFilesAfterEnv: ['aws-cdk-lib/testhelpers/jest-cleanup'],
       * };
       * ```
       */
      static cleanupTemporaryDirectories() {
        for (const dir of TEMPORARY_ASSEMBLY_DIRS) {
          fs4.rmSync(dir, { recursive: true, force: true });
        }
        TEMPORARY_ASSEMBLY_DIRS.splice(0, TEMPORARY_ASSEMBLY_DIRS.length);
      }
      /**
       * Reads a cloud assembly from the specified directory.
       * @param directory - The root directory of the assembly.
       */
      constructor(directory, loadOptions) {
        this.directory = directory;
        this.manifest = cxschema4.Manifest.loadAssemblyManifest(path4.join(directory, MANIFEST_FILE), loadOptions);
        this.version = this.manifest.version;
        this.artifacts = this.renderArtifacts(loadOptions?.topoSort ?? true);
        this.runtime = this.manifest.runtime || { libraries: {} };
        Object.defineProperty(this, CLOUD_ASSEMBLY_SYMBOL, { value: true });
        this.validateDeps();
      }
      /**
       * Attempts to find an artifact with a specific identity.
       * @returns A `CloudArtifact` object or `undefined` if the artifact does not exist in this assembly.
       * @param id - The artifact ID
       */
      tryGetArtifact(id) {
        return this.artifacts.find((a13) => a13.id === id);
      }
      /**
       * Returns a CloudFormation stack artifact from this assembly.
       *
       * Will only search the current assembly.
       *
       * @param stackName - the name of the CloudFormation stack.
       * @throws if there is no stack artifact by that name
       * @throws if there is more than one stack with the same stack name. You can
       * use `getStackArtifact(stack.artifactId)` instead.
       * @returns a `CloudFormationStackArtifact` object.
       */
      getStackByName(stackName) {
        const artifacts = this.artifacts.filter((a13) => a13 instanceof CloudFormationStackArtifact && a13.stackName === stackName);
        if (!artifacts || artifacts.length === 0) {
          throw new CloudAssemblyError(`Unable to find stack with stack name "${stackName}"`);
        }
        if (artifacts.length > 1) {
          throw new CloudAssemblyError(`There are multiple stacks with the stack name "${stackName}" (${artifacts.map((a13) => a13.id).join(",")}). Use "getStackArtifact(id)" instead`);
        }
        return artifacts[0];
      }
      /**
       * Returns a CloudFormation stack artifact by name from this assembly.
       * @deprecated renamed to `getStackByName` (or `getStackArtifact(id)`)
       */
      getStack(stackName) {
        return this.getStackByName(stackName);
      }
      /**
       * Returns a CloudFormation stack artifact from this assembly.
       *
       * @param artifactId - the artifact id of the stack (can be obtained through `stack.artifactId`).
       * @throws if there is no stack artifact with that id
       * @returns a `CloudFormationStackArtifact` object.
       */
      getStackArtifact(artifactId) {
        const artifact = this.tryGetArtifactRecursively(artifactId);
        if (!artifact) {
          throw new CloudAssemblyError(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof CloudFormationStackArtifact)) {
          throw new CloudAssemblyError(`Artifact ${artifactId} is not a CloudFormation stack`);
        }
        return artifact;
      }
      tryGetArtifactRecursively(artifactId) {
        return this.stacksRecursively.find((a13) => a13.id === artifactId);
      }
      /**
       * Returns all the stacks, including the ones in nested assemblies
       */
      get stacksRecursively() {
        function search(stackArtifacts, assemblies) {
          if (assemblies.length === 0) {
            return stackArtifacts;
          }
          const [head, ...tail] = assemblies;
          const nestedAssemblies = head.nestedAssemblies.map((asm) => asm.nestedAssembly);
          return search(stackArtifacts.concat(head.stacks), tail.concat(nestedAssemblies));
        }
        __name(search, "search");
        return search([], [this]);
      }
      /**
       * Returns a nested assembly artifact.
       *
       * @param artifactId - The artifact ID of the nested assembly
       */
      getNestedAssemblyArtifact(artifactId) {
        const artifact = this.tryGetArtifact(artifactId);
        if (!artifact) {
          throw new CloudAssemblyError(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof NestedCloudAssemblyArtifact)) {
          throw new CloudAssemblyError(`Found artifact '${artifactId}' but it's not a nested cloud assembly`);
        }
        return artifact;
      }
      /**
       * Returns a nested assembly.
       *
       * @param artifactId - The artifact ID of the nested assembly
       */
      getNestedAssembly(artifactId) {
        return this.getNestedAssemblyArtifact(artifactId).nestedAssembly;
      }
      /**
       * Returns the tree metadata artifact from this assembly.
       * @throws if there is no metadata artifact by that name
       * @returns a `TreeCloudArtifact` object if there is one defined in the manifest, `undefined` otherwise.
       */
      tree() {
        const trees = this.artifacts.filter((a13) => a13.manifest.type === cxschema4.ArtifactType.CDK_TREE);
        if (trees.length === 0) {
          return void 0;
        } else if (trees.length > 1) {
          throw new CloudAssemblyError(`Multiple artifacts of type ${cxschema4.ArtifactType.CDK_TREE} found in manifest`);
        }
        const tree = trees[0];
        if (!(tree instanceof TreeCloudArtifact)) {
          throw new CloudAssemblyError('"Tree" artifact is not of expected type');
        }
        return tree;
      }
      /**
       * @returns all the CloudFormation stack artifacts that are included in this assembly.
       */
      get stacks() {
        return this.artifacts.filter(isCloudFormationStackArtifact);
        function isCloudFormationStackArtifact(x13) {
          return x13 instanceof CloudFormationStackArtifact;
        }
        __name(isCloudFormationStackArtifact, "isCloudFormationStackArtifact");
      }
      /**
       * The nested assembly artifacts in this assembly
       */
      get nestedAssemblies() {
        return this.artifacts.filter(isNestedCloudAssemblyArtifact);
        function isNestedCloudAssemblyArtifact(x13) {
          return x13 instanceof NestedCloudAssemblyArtifact;
        }
        __name(isNestedCloudAssemblyArtifact, "isNestedCloudAssemblyArtifact");
      }
      validateDeps() {
        for (const artifact of this.artifacts) {
          ignore(artifact.dependencies);
        }
      }
      renderArtifacts(topoSort) {
        const result2 = new Array();
        for (const [name, artifact] of Object.entries(this.manifest.artifacts || {})) {
          const cloudartifact = CloudArtifact.fromManifest(this, name, artifact);
          if (cloudartifact) {
            result2.push(cloudartifact);
          }
        }
        return topoSort ? topologicalSort(result2, (x13) => x13.id, (x13) => x13._dependencyIDs) : result2;
      }
    };
    CloudAssemblyBuilder = class _CloudAssemblyBuilder {
      /**
       * Initializes a cloud assembly builder.
       * @param outdir - The output directory, uses temporary directory if undefined
       */
      constructor(outdir, props = {}) {
        this.artifacts = {};
        this.missing = new Array();
        this.outdir = determineOutputDirectory(outdir);
        this.assetOutdir = props.assetOutdir ?? this.outdir;
        this.parentBuilder = props.parentBuilder;
        ensureDirSync(this.outdir);
      }
      static {
        __name(this, "CloudAssemblyBuilder");
      }
      /**
       * Adds an artifact into the cloud assembly.
       * @param id - The ID of the artifact.
       * @param manifest - The artifact manifest
       */
      addArtifact(id, manifest) {
        this.artifacts[id] = filterUndefined(manifest);
      }
      /**
       * Reports that some context is missing in order for this cloud assembly to be fully synthesized.
       * @param missing - Missing context information.
       */
      addMissing(missing) {
        if (this.missing.every((m13) => m13.key !== missing.key)) {
          this.missing.push(missing);
        }
        this.parentBuilder?.addMissing(missing);
      }
      /**
       * Finalizes the cloud assembly into the output directory returns a
       * `CloudAssembly` object that can be used to inspect the assembly.
       */
      buildAssembly(options = {}) {
        let manifest = {
          version: cxschema4.Manifest.version(),
          artifacts: this.artifacts,
          runtime: options.runtimeInfo,
          missing: this.missing.length > 0 ? this.missing : void 0
        };
        manifest = filterUndefined(manifest);
        const manifestFilePath = path4.join(this.outdir, MANIFEST_FILE);
        cxschema4.Manifest.saveAssemblyManifest(manifest, manifestFilePath);
        fs4.writeFileSync(path4.join(this.outdir, "cdk.out"), JSON.stringify({ version: manifest.version }));
        return new CloudAssembly(this.outdir);
      }
      /**
       * Creates a nested cloud assembly
       */
      createNestedAssembly(artifactId, displayName) {
        const directoryName = artifactId;
        const innerAsmDir = path4.join(this.outdir, directoryName);
        this.addArtifact(artifactId, {
          type: cxschema4.ArtifactType.NESTED_CLOUD_ASSEMBLY,
          properties: {
            directoryName,
            displayName
          }
        });
        return new _CloudAssemblyBuilder(innerAsmDir, {
          // Reuse the same asset output directory as the current Casm builder
          assetOutdir: this.assetOutdir,
          parentBuilder: this
        });
      }
      /**
       * Delete the cloud assembly directory
       */
      delete() {
        fs4.rmSync(this.outdir, { recursive: true, force: true });
      }
    };
    __name(filterUndefined, "filterUndefined");
    __name(ignore, "ignore");
    __name(determineOutputDirectory, "determineOutputDirectory");
    __name(ensureDirSync, "ensureDirSync");
    TEMPORARY_ASSEMBLY_DIRS = [];
    process.on("exit", () => CloudAssembly.cleanupTemporaryDirectories());
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/artifacts/nested-cloud-assembly-artifact-aug.ts
var nested_cloud_assembly_artifact_aug_exports = {};
var cacheSym;
var init_nested_cloud_assembly_artifact_aug = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/artifacts/nested-cloud-assembly-artifact-aug.ts"() {
    "use strict";
    init_nested_cloud_assembly_artifact();
    init_cloud_assembly2();
    cacheSym = /* @__PURE__ */ Symbol();
    Object.defineProperty(NestedCloudAssemblyArtifact.prototype, "nestedAssembly", {
      get() {
        if (!this[cacheSym]) {
          this[cacheSym] = new CloudAssembly(this.fullPath);
        }
        return this[cacheSym];
      }
    });
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/assets.ts
var assets_exports2 = {};
__export(assets_exports2, {
  ASSET_PREFIX_SEPARATOR: () => ASSET_PREFIX_SEPARATOR,
  ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY: () => ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY,
  ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY: () => ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY,
  ASSET_RESOURCE_METADATA_ENABLED_CONTEXT: () => ASSET_RESOURCE_METADATA_ENABLED_CONTEXT,
  ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY: () => ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY,
  ASSET_RESOURCE_METADATA_PATH_KEY: () => ASSET_RESOURCE_METADATA_PATH_KEY,
  ASSET_RESOURCE_METADATA_PROPERTY_KEY: () => ASSET_RESOURCE_METADATA_PROPERTY_KEY
});
var ASSET_RESOURCE_METADATA_ENABLED_CONTEXT, ASSET_RESOURCE_METADATA_PATH_KEY, ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY, ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY, ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY, ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY, ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY, ASSET_RESOURCE_METADATA_PROPERTY_KEY, ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY, ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY, ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY, ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY, ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY, ASSET_PREFIX_SEPARATOR;
var init_assets2 = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/assets.ts"() {
    "use strict";
    ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = "aws:cdk:enable-asset-metadata";
    ASSET_RESOURCE_METADATA_PATH_KEY = "aws:asset:path";
    ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = "aws:asset:dockerfile-path";
    ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = "aws:asset:docker-build-args";
    ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY = "aws:asset:docker-build-secrets";
    ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY = "aws:asset:docker-build-ssh";
    ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = "aws:asset:docker-build-target";
    ASSET_RESOURCE_METADATA_PROPERTY_KEY = "aws:asset:property";
    ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = "aws:asset:is-bundled";
    ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY = "aws:asset:docker-outputs";
    ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY = "aws:asset:docker-cache-from";
    ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY = "aws:asset:docker-cache-to";
    ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY = "aws:asset:docker-cache-disabled";
    ASSET_PREFIX_SEPARATOR = "||";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/placeholders.ts
var placeholders_exports = {};
__export(placeholders_exports, {
  EnvironmentPlaceholders: () => EnvironmentPlaceholders
});
function replaceAll(s13, search, replace) {
  return s13.split(search).join(replace);
}
var EnvironmentPlaceholders;
var init_placeholders = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/placeholders.ts"() {
    "use strict";
    EnvironmentPlaceholders = class _EnvironmentPlaceholders {
      static {
        __name(this, "EnvironmentPlaceholders");
      }
      static {
        /**
         * Insert this into the destination fields to be replaced with the current region
         */
        this.CURRENT_REGION = "${AWS::Region}";
      }
      static {
        /**
         * Insert this into the destination fields to be replaced with the current account
         */
        this.CURRENT_ACCOUNT = "${AWS::AccountId}";
      }
      static {
        /**
         * Insert this into the destination fields to be replaced with the current partition
         */
        this.CURRENT_PARTITION = "${AWS::Partition}";
      }
      /**
       * Replace the environment placeholders in all strings found in a complex object.
       *
       * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
       * (they're nominally independent tools).
       */
      static replace(object, values) {
        return this.recurse(object, (value) => {
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_REGION, values.region);
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
          return value;
        });
      }
      /**
       * Like 'replace', but asynchronous
       */
      static async replaceAsync(object, provider) {
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, (value) => {
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_REGION) > 1) {
            needRegion = true;
          }
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
            needAccountId = true;
          }
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
            needPartition = true;
          }
          return value;
        });
        const region = needRegion ? await provider.region() : void 0;
        const accountId = needAccountId ? await provider.accountId() : void 0;
        const partition3 = needPartition ? await provider.partition() : void 0;
        return this.recurse(object, (value) => {
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_REGION, region ?? "WONTHAPPEN");
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId ?? "WONTHAPPEN");
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_PARTITION, partition3 ?? "WONTHAPPEN");
          return value;
        });
      }
      static recurse(value, cb) {
        if (typeof value === "string") {
          return cb(value);
        }
        if (typeof value !== "object" || value === null) {
          return value;
        }
        if (Array.isArray(value)) {
          return value.map((x13) => this.recurse(x13, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
          ret[key] = this.recurse(inner, cb);
        }
        return ret;
      }
    };
    __name(replaceAll, "replaceAll");
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/bootstrap.ts
var bootstrap_exports = {};
__export(bootstrap_exports, {
  SSMPARAM_NO_INVALIDATE: () => SSMPARAM_NO_INVALIDATE
});
var SSMPARAM_NO_INVALIDATE;
var init_bootstrap = __esm({
  "../@aws-cdk/cloud-assembly-api/lib/bootstrap.ts"() {
    "use strict";
    SSMPARAM_NO_INVALIDATE = "[cdk:skip]";
  }
});

// ../@aws-cdk/cloud-assembly-api/lib/index.js
var require_lib3 = __commonJS({
  "../@aws-cdk/cloud-assembly-api/lib/index.js"(exports2) {
    "use strict";
    var __createBinding3 = exports2 && exports2.__createBinding || (Object.create ? (function(o13, m13, k13, k22) {
      if (k22 === void 0) k22 = k13;
      var desc = Object.getOwnPropertyDescriptor(m13, k13);
      if (!desc || ("get" in desc ? !m13.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: /* @__PURE__ */ __name(function() {
          return m13[k13];
        }, "get") };
      }
      Object.defineProperty(o13, k22, desc);
    }) : (function(o13, m13, k13, k22) {
      if (k22 === void 0) k22 = k13;
      o13[k22] = m13[k13];
    }));
    var __exportStar3 = exports2 && exports2.__exportStar || function(m13, exports3) {
      for (var p13 in m13) if (p13 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p13)) __createBinding3(exports3, m13, p13);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar3((init_vpc(), __toCommonJS(vpc_exports)), exports2);
    __exportStar3((init_ami(), __toCommonJS(ami_exports)), exports2);
    __exportStar3((init_load_balancer(), __toCommonJS(load_balancer_exports)), exports2);
    __exportStar3((init_availability_zones(), __toCommonJS(availability_zones_exports)), exports2);
    __exportStar3((init_endpoint_service_availability_zones(), __toCommonJS(endpoint_service_availability_zones_exports)), exports2);
    __exportStar3((init_security_group(), __toCommonJS(security_group_exports)), exports2);
    __exportStar3((init_key(), __toCommonJS(key_exports)), exports2);
    __exportStar3((init_generic(), __toCommonJS(generic_exports)), exports2);
    __exportStar3((init_cloud_artifact(), __toCommonJS(cloud_artifact_exports)), exports2);
    init_cloud_artifact_aug();
    __exportStar3((init_asset_manifest_artifact(), __toCommonJS(asset_manifest_artifact_exports)), exports2);
    __exportStar3((init_cloudformation_artifact(), __toCommonJS(cloudformation_artifact_exports)), exports2);
    __exportStar3((init_tree_cloud_artifact(), __toCommonJS(tree_cloud_artifact_exports)), exports2);
    __exportStar3((init_nested_cloud_assembly_artifact(), __toCommonJS(nested_cloud_assembly_artifact_exports)), exports2);
    init_nested_cloud_assembly_artifact_aug();
    __exportStar3((init_cloud_assembly2(), __toCommonJS(cloud_assembly_exports2)), exports2);
    __exportStar3((init_assets2(), __toCommonJS(assets_exports2)), exports2);
    __exportStar3((init_metadata(), __toCommonJS(metadata_exports)), exports2);
    __exportStar3((init_placeholders(), __toCommonJS(placeholders_exports)), exports2);
    __exportStar3((init_environment(), __toCommonJS(environment_exports)), exports2);
    __exportStar3((init_bootstrap(), __toCommonJS(bootstrap_exports)), exports2);
  }
});

// ../../node_modules/universalify/index.js
var require_universalify = __commonJS({
  "../../node_modules/universalify/index.js"(exports2) {
    "use strict";
    exports2.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function") fn.apply(this, args);
        else {
          return new Promise((resolve16, reject) => {
            args.push((err, res) => err != null ? reject(err) : resolve16(res));
            fn.apply(this, args);
          });
        }
      }, "name", { value: fn.name });
    };
    exports2.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function") return fn.apply(this, args);
        else {
          args.pop();
          fn.apply(this, args).then((r13) => cb(null, r13), cb);
        }
      }, "name", { value: fn.name });
    };
  }
});

// ../../node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "../../node_modules/graceful-fs/polyfills.js"(exports2, module2) {
    var constants3 = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform3 = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d13) {
        cwd = null;
        chdir.call(process, d13);
      };
      if (Object.setPrototypeOf) Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs47) {
      if (constants3.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs47);
      }
      if (!fs47.lutimes) {
        patchLutimes(fs47);
      }
      fs47.chown = chownFix(fs47.chown);
      fs47.fchown = chownFix(fs47.fchown);
      fs47.lchown = chownFix(fs47.lchown);
      fs47.chmod = chmodFix(fs47.chmod);
      fs47.fchmod = chmodFix(fs47.fchmod);
      fs47.lchmod = chmodFix(fs47.lchmod);
      fs47.chownSync = chownFixSync(fs47.chownSync);
      fs47.fchownSync = chownFixSync(fs47.fchownSync);
      fs47.lchownSync = chownFixSync(fs47.lchownSync);
      fs47.chmodSync = chmodFixSync(fs47.chmodSync);
      fs47.fchmodSync = chmodFixSync(fs47.fchmodSync);
      fs47.lchmodSync = chmodFixSync(fs47.lchmodSync);
      fs47.stat = statFix(fs47.stat);
      fs47.fstat = statFix(fs47.fstat);
      fs47.lstat = statFix(fs47.lstat);
      fs47.statSync = statFixSync(fs47.statSync);
      fs47.fstatSync = statFixSync(fs47.fstatSync);
      fs47.lstatSync = statFixSync(fs47.lstatSync);
      if (fs47.chmod && !fs47.lchmod) {
        fs47.lchmod = function(path44, mode, cb) {
          if (cb) process.nextTick(cb);
        };
        fs47.lchmodSync = function() {
        };
      }
      if (fs47.chown && !fs47.lchown) {
        fs47.lchown = function(path44, uid, gid, cb) {
          if (cb) process.nextTick(cb);
        };
        fs47.lchownSync = function() {
        };
      }
      if (platform3 === "win32") {
        fs47.rename = typeof fs47.rename !== "function" ? fs47.rename : (function(fs$rename) {
          function rename(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, /* @__PURE__ */ __name(function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM" || er.code === "EBUSY") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs47.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb) cb(er);
            }, "CB"));
          }
          __name(rename, "rename");
          if (Object.setPrototypeOf) Object.setPrototypeOf(rename, fs$rename);
          return rename;
        })(fs47.rename);
      }
      fs47.read = typeof fs47.read !== "function" ? fs47.read : (function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = /* @__PURE__ */ __name(function(er, _2, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs47, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            }, "callback");
          }
          return fs$read.call(fs47, fd, buffer, offset, length, position, callback);
        }
        __name(read, "read");
        if (Object.setPrototypeOf) Object.setPrototypeOf(read, fs$read);
        return read;
      })(fs47.read);
      fs47.readSync = typeof fs47.readSync !== "function" ? fs47.readSync : /* @__PURE__ */ (function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs47, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      })(fs47.readSync);
      function patchLchmod(fs48) {
        fs48.lchmod = function(path44, mode, callback) {
          fs48.open(
            path44,
            constants3.O_WRONLY | constants3.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback) callback(err);
                return;
              }
              fs48.fchmod(fd, mode, function(err2) {
                fs48.close(fd, function(err22) {
                  if (callback) callback(err2 || err22);
                });
              });
            }
          );
        };
        fs48.lchmodSync = function(path44, mode) {
          var fd = fs48.openSync(path44, constants3.O_WRONLY | constants3.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs48.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs48.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs48.closeSync(fd);
            }
          }
          return ret;
        };
      }
      __name(patchLchmod, "patchLchmod");
      function patchLutimes(fs48) {
        if (constants3.hasOwnProperty("O_SYMLINK") && fs48.futimes) {
          fs48.lutimes = function(path44, at, mt, cb) {
            fs48.open(path44, constants3.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb) cb(er);
                return;
              }
              fs48.futimes(fd, at, mt, function(er2) {
                fs48.close(fd, function(er22) {
                  if (cb) cb(er2 || er22);
                });
              });
            });
          };
          fs48.lutimesSync = function(path44, at, mt) {
            var fd = fs48.openSync(path44, constants3.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs48.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs48.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs48.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs48.futimes) {
          fs48.lutimes = function(_a5, _b, _c13, cb) {
            if (cb) process.nextTick(cb);
          };
          fs48.lutimesSync = function() {
          };
        }
      }
      __name(patchLutimes, "patchLutimes");
      function chmodFix(orig) {
        if (!orig) return orig;
        return function(target, mode, cb) {
          return orig.call(fs47, target, mode, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      __name(chmodFix, "chmodFix");
      function chmodFixSync(orig) {
        if (!orig) return orig;
        return function(target, mode) {
          try {
            return orig.call(fs47, target, mode);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      __name(chmodFixSync, "chmodFixSync");
      function chownFix(orig) {
        if (!orig) return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs47, target, uid, gid, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      __name(chownFix, "chownFix");
      function chownFixSync(orig) {
        if (!orig) return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs47, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      __name(chownFixSync, "chownFixSync");
      function statFix(orig) {
        if (!orig) return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0) stats.uid += 4294967296;
              if (stats.gid < 0) stats.gid += 4294967296;
            }
            if (cb) cb.apply(this, arguments);
          }
          __name(callback, "callback");
          return options ? orig.call(fs47, target, options, callback) : orig.call(fs47, target, callback);
        };
      }
      __name(statFix, "statFix");
      function statFixSync(orig) {
        if (!orig) return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs47, target, options) : orig.call(fs47, target);
          if (stats) {
            if (stats.uid < 0) stats.uid += 4294967296;
            if (stats.gid < 0) stats.gid += 4294967296;
          }
          return stats;
        };
      }
      __name(statFixSync, "statFixSync");
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
      __name(chownErOk, "chownErOk");
    }
    __name(patch, "patch");
  }
});

// ../../node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "../../node_modules/graceful-fs/legacy-streams.js"(exports2, module2) {
    var Stream2 = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs47) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path44, options) {
        if (!(this instanceof ReadStream)) return new ReadStream(path44, options);
        Stream2.call(this);
        var self2 = this;
        this.path = path44;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding) this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self2._read();
          });
          return;
        }
        fs47.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self2.emit("error", err);
            self2.readable = false;
            return;
          }
          self2.fd = fd;
          self2.emit("open", fd);
          self2._read();
        });
      }
      __name(ReadStream, "ReadStream");
      function WriteStream(path44, options) {
        if (!(this instanceof WriteStream)) return new WriteStream(path44, options);
        Stream2.call(this);
        this.path = path44;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs47.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
      __name(WriteStream, "WriteStream");
    }
    __name(legacy, "legacy");
  }
});

// ../../node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "../../node_modules/graceful-fs/clone.js"(exports2, module2) {
    "use strict";
    module2.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy2 = { __proto__: getPrototypeOf(obj) };
      else
        var copy2 = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy2, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy2;
    }
    __name(clone, "clone");
  }
});

// ../../node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "../../node_modules/graceful-fs/graceful-fs.js"(exports2, module2) {
    var fs47 = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util12 = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = /* @__PURE__ */ Symbol.for("graceful-fs.queue");
      previousSymbol = /* @__PURE__ */ Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    __name(noop, "noop");
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: /* @__PURE__ */ __name(function() {
          return queue2;
        }, "get")
      });
    }
    __name(publishQueue, "publishQueue");
    var debug3 = noop;
    if (util12.debuglog)
      debug3 = util12.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug3 = /* @__PURE__ */ __name(function() {
        var m13 = util12.format.apply(util12, arguments);
        m13 = "GFS4: " + m13.split(/\n/).join("\nGFS4: ");
        console.error(m13);
      }, "debug");
    if (!fs47[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs47, queue);
      fs47.close = (function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs47, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        __name(close, "close");
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      })(fs47.close);
      fs47.closeSync = (function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs47, arguments);
          resetQueue();
        }
        __name(closeSync, "closeSync");
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      })(fs47.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug3(fs47[gracefulQueue]);
          require("assert").equal(fs47[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs47[gracefulQueue]);
    }
    module2.exports = patch(clone(fs47));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs47.__patched) {
      module2.exports = patch(fs47);
      fs47.__patched = true;
    }
    function patch(fs48) {
      polyfills(fs48);
      fs48.gracefulify = patch;
      fs48.createReadStream = createReadStream2;
      fs48.createWriteStream = createWriteStream3;
      var fs$readFile = fs48.readFile;
      fs48.readFile = readFile5;
      function readFile5(path44, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path44, options, cb);
        function go$readFile(path45, options2, cb2, startTime) {
          return fs$readFile(path45, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path45, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$readFile, "go$readFile");
      }
      __name(readFile5, "readFile");
      var fs$writeFile = fs48.writeFile;
      fs48.writeFile = writeFile5;
      function writeFile5(path44, data3, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path44, data3, options, cb);
        function go$writeFile(path45, data4, options2, cb2, startTime) {
          return fs$writeFile(path45, data4, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path45, data4, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$writeFile, "go$writeFile");
      }
      __name(writeFile5, "writeFile");
      var fs$appendFile = fs48.appendFile;
      if (fs$appendFile)
        fs48.appendFile = appendFile;
      function appendFile(path44, data3, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path44, data3, options, cb);
        function go$appendFile(path45, data4, options2, cb2, startTime) {
          return fs$appendFile(path45, data4, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path45, data4, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$appendFile, "go$appendFile");
      }
      __name(appendFile, "appendFile");
      var fs$copyFile = fs48.copyFile;
      if (fs$copyFile)
        fs48.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$copyFile, "go$copyFile");
      }
      __name(copyFile, "copyFile");
      var fs$readdir = fs48.readdir;
      fs48.readdir = readdir5;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir5(path44, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? /* @__PURE__ */ __name(function go$readdir2(path45, options2, cb2, startTime) {
          return fs$readdir(path45, fs$readdirCallback(
            path45,
            options2,
            cb2,
            startTime
          ));
        }, "go$readdir") : /* @__PURE__ */ __name(function go$readdir2(path45, options2, cb2, startTime) {
          return fs$readdir(path45, options2, fs$readdirCallback(
            path45,
            options2,
            cb2,
            startTime
          ));
        }, "go$readdir");
        return go$readdir(path44, options, cb);
        function fs$readdirCallback(path45, options2, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path45, options2, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
        __name(fs$readdirCallback, "fs$readdirCallback");
      }
      __name(readdir5, "readdir");
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs48);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs48.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs48.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs48, "ReadStream", {
        get: /* @__PURE__ */ __name(function() {
          return ReadStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          ReadStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs48, "WriteStream", {
        get: /* @__PURE__ */ __name(function() {
          return WriteStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          WriteStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs48, "FileReadStream", {
        get: /* @__PURE__ */ __name(function() {
          return FileReadStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          FileReadStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs48, "FileWriteStream", {
        get: /* @__PURE__ */ __name(function() {
          return FileWriteStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          FileWriteStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      function ReadStream(path44, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      __name(ReadStream, "ReadStream");
      function ReadStream$open() {
        var that = this;
        open2(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      __name(ReadStream$open, "ReadStream$open");
      function WriteStream(path44, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      __name(WriteStream, "WriteStream");
      function WriteStream$open() {
        var that = this;
        open2(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      __name(WriteStream$open, "WriteStream$open");
      function createReadStream2(path44, options) {
        return new fs48.ReadStream(path44, options);
      }
      __name(createReadStream2, "createReadStream");
      function createWriteStream3(path44, options) {
        return new fs48.WriteStream(path44, options);
      }
      __name(createWriteStream3, "createWriteStream");
      var fs$open = fs48.open;
      fs48.open = open2;
      function open2(path44, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path44, flags, mode, cb);
        function go$open(path45, flags2, mode2, cb2, startTime) {
          return fs$open(path45, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path45, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$open, "go$open");
      }
      __name(open2, "open");
      return fs48;
    }
    __name(patch, "patch");
    function enqueue(elem) {
      debug3("ENQUEUE", elem[0].name, elem[1]);
      fs47[gracefulQueue].push(elem);
      retry();
    }
    __name(enqueue, "enqueue");
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i13 = 0; i13 < fs47[gracefulQueue].length; ++i13) {
        if (fs47[gracefulQueue][i13].length > 2) {
          fs47[gracefulQueue][i13][3] = now;
          fs47[gracefulQueue][i13][4] = now;
        }
      }
      retry();
    }
    __name(resetQueue, "resetQueue");
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs47[gracefulQueue].length === 0)
        return;
      var elem = fs47[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug3("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug3("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug3("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs47[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
    __name(retry, "retry");
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/fs/index.js"(exports2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var fs47 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs47[key] === "function";
    });
    Object.keys(fs47).forEach((key) => {
      if (key === "promises") {
        return;
      }
      exports2[key] = fs47[key];
    });
    api.forEach((method) => {
      exports2[method] = u13(fs47[method]);
    });
    exports2.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs47.exists(filename, callback);
      }
      return new Promise((resolve16) => {
        return fs47.exists(filename, resolve16);
      });
    };
    exports2.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs47.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve16, reject) => {
        fs47.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err) return reject(err);
          resolve16({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports2.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs47.write(fd, buffer, ...args);
      }
      return new Promise((resolve16, reject) => {
        fs47.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err) return reject(err);
          resolve16({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs47.writev === "function") {
      exports2.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs47.writev(fd, buffers, ...args);
        }
        return new Promise((resolve16, reject) => {
          fs47.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err) return reject(err);
            resolve16({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
    if (typeof fs47.realpath.native === "function") {
      exports2.realpath.native = u13(fs47.realpath.native);
    }
  }
});

// ../../node_modules/at-least-node/index.js
var require_at_least_node = __commonJS({
  "../../node_modules/at-least-node/index.js"(exports2, module2) {
    module2.exports = (r13) => {
      const n13 = process.versions.node.split(".").map((x13) => parseInt(x13, 10));
      r13 = r13.split(".").map((x13) => parseInt(x13, 10));
      return n13[0] > r13[0] || n13[0] === r13[0] && (n13[1] > r13[1] || n13[1] === r13[1] && n13[2] >= r13[2]);
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports2, module2) {
    "use strict";
    var fs47 = require_fs();
    var path44 = require("path");
    var atLeastNode = require_at_least_node();
    var useNativeRecursiveOption = atLeastNode("10.12.0");
    var checkPath = /* @__PURE__ */ __name((pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path44.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error5 = new Error(`Path contains invalid characters: ${pth}`);
          error5.code = "EINVAL";
          throw error5;
        }
      }
    }, "checkPath");
    var processOptions = /* @__PURE__ */ __name((options) => {
      const defaults4 = { mode: 511 };
      if (typeof options === "number") options = { mode: options };
      return { ...defaults4, ...options };
    }, "processOptions");
    var permissionError = /* @__PURE__ */ __name((pth) => {
      const error5 = new Error(`operation not permitted, mkdir '${pth}'`);
      error5.code = "EPERM";
      error5.errno = -4048;
      error5.path = pth;
      error5.syscall = "mkdir";
      return error5;
    }, "permissionError");
    module2.exports.makeDir = async (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path44.resolve(input);
        return fs47.mkdir(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = /* @__PURE__ */ __name(async (pth) => {
        try {
          await fs47.mkdir(pth, options.mode);
        } catch (error5) {
          if (error5.code === "EPERM") {
            throw error5;
          }
          if (error5.code === "ENOENT") {
            if (path44.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error5.message.includes("null bytes")) {
              throw error5;
            }
            await make(path44.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await fs47.stat(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error5;
          }
        }
      }, "make");
      return make(path44.resolve(input));
    };
    module2.exports.makeDirSync = (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path44.resolve(input);
        return fs47.mkdirSync(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = /* @__PURE__ */ __name((pth) => {
        try {
          fs47.mkdirSync(pth, options.mode);
        } catch (error5) {
          if (error5.code === "EPERM") {
            throw error5;
          }
          if (error5.code === "ENOENT") {
            if (path44.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error5.message.includes("null bytes")) {
              throw error5;
            }
            make(path44.dirname(pth));
            return make(pth);
          }
          try {
            if (!fs47.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error5;
          }
        }
      }, "make");
      return make(path44.resolve(input));
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u13(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      // alias
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/utimes.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    function utimesMillis(path44, atime, mtime, callback) {
      fs47.open(path44, "r+", (err, fd) => {
        if (err) return callback(err);
        fs47.futimes(fd, atime, mtime, (futimesErr) => {
          fs47.close(fd, (closeErr) => {
            if (callback) callback(futimesErr || closeErr);
          });
        });
      });
    }
    __name(utimesMillis, "utimesMillis");
    function utimesMillisSync(path44, atime, mtime) {
      const fd = fs47.openSync(path44, "r+");
      fs47.futimesSync(fd, atime, mtime);
      return fs47.closeSync(fd);
    }
    __name(utimesMillisSync, "utimesMillisSync");
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/stat.js"(exports2, module2) {
    "use strict";
    var fs47 = require_fs();
    var path44 = require("path");
    var util12 = require("util");
    var atLeastNode = require_at_least_node();
    var nodeSupportsBigInt = atLeastNode("10.5.0");
    var stat8 = /* @__PURE__ */ __name((file) => nodeSupportsBigInt ? fs47.stat(file, { bigint: true }) : fs47.stat(file), "stat");
    var statSync3 = /* @__PURE__ */ __name((file) => nodeSupportsBigInt ? fs47.statSync(file, { bigint: true }) : fs47.statSync(file), "statSync");
    function getStats(src, dest) {
      return Promise.all([
        stat8(src),
        stat8(dest).catch((err) => {
          if (err.code === "ENOENT") return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    __name(getStats, "getStats");
    function getStatsSync(src, dest) {
      let destStat;
      const srcStat = statSync3(src);
      try {
        destStat = statSync3(dest);
      } catch (err) {
        if (err.code === "ENOENT") return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    __name(getStatsSync, "getStatsSync");
    function checkPaths(src, dest, funcName, cb) {
      util12.callbackify(getStats)(src, dest, (err, stats) => {
        if (err) return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat && areIdentical(srcStat, destStat)) {
          return cb(new Error("Source and destination must not be the same."));
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    __name(checkPaths, "checkPaths");
    function checkPathsSync(src, dest, funcName) {
      const { srcStat, destStat } = getStatsSync(src, dest);
      if (destStat && areIdentical(srcStat, destStat)) {
        throw new Error("Source and destination must not be the same.");
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    __name(checkPathsSync, "checkPathsSync");
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path44.resolve(path44.dirname(src));
      const destParent = path44.resolve(path44.dirname(dest));
      if (destParent === srcParent || destParent === path44.parse(destParent).root) return cb();
      const callback = /* @__PURE__ */ __name((err, destStat) => {
        if (err) {
          if (err.code === "ENOENT") return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      }, "callback");
      if (nodeSupportsBigInt) fs47.stat(destParent, { bigint: true }, callback);
      else fs47.stat(destParent, callback);
    }
    __name(checkParentPaths, "checkParentPaths");
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path44.resolve(path44.dirname(src));
      const destParent = path44.resolve(path44.dirname(dest));
      if (destParent === srcParent || destParent === path44.parse(destParent).root) return;
      let destStat;
      try {
        destStat = statSync3(destParent);
      } catch (err) {
        if (err.code === "ENOENT") return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    __name(checkParentPathsSync, "checkParentPathsSync");
    function areIdentical(srcStat, destStat) {
      if (destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev) {
        if (nodeSupportsBigInt || destStat.ino < Number.MAX_SAFE_INTEGER) {
          return true;
        }
        if (destStat.size === srcStat.size && destStat.mode === srcStat.mode && destStat.nlink === srcStat.nlink && destStat.atimeMs === srcStat.atimeMs && destStat.mtimeMs === srcStat.mtimeMs && destStat.ctimeMs === srcStat.ctimeMs && destStat.birthtimeMs === srcStat.birthtimeMs) {
          return true;
        }
      }
      return false;
    }
    __name(areIdentical, "areIdentical");
    function isSrcSubdir(src, dest) {
      const srcArr = path44.resolve(src).split(path44.sep).filter((i13) => i13);
      const destArr = path44.resolve(dest).split(path44.sep).filter((i13) => i13);
      return srcArr.reduce((acc, cur, i13) => acc && destArr[i13] === cur, true);
    }
    __name(isSrcSubdir, "isSrcSubdir");
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    __name(errMsg, "errMsg");
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var mkdirsSync2 = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat8 = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat8.checkPathsSync(src, dest, "copy");
      stat8.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    __name(copySync, "copySync");
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest)) return;
      const destParent = path44.dirname(dest);
      if (!fs47.existsSync(destParent)) mkdirsSync2(destParent);
      return startCopy(destStat, src, dest, opts);
    }
    __name(handleFilterAndCopy, "handleFilterAndCopy");
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest)) return;
      return getStats(destStat, src, dest, opts);
    }
    __name(startCopy, "startCopy");
    function getStats(destStat, src, dest, opts) {
      const statSync3 = opts.dereference ? fs47.statSync : fs47.lstatSync;
      const srcStat = statSync3(src);
      if (srcStat.isDirectory()) return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice()) return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink()) return onLink(destStat, src, dest, opts);
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat) return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs47.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile(srcStat, src, dest, opts) {
      fs47.copyFileSync(src, dest);
      if (opts.preserveTimestamps) handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    __name(copyFile, "copyFile");
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode)) makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    __name(handleTimestamps, "handleTimestamps");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestMode(dest, srcMode) {
      return fs47.chmodSync(dest, srcMode);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs47.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat) return mkDirAndCopy(srcStat.mode, src, dest, opts);
      if (destStat && !destStat.isDirectory()) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
      }
      return copyDir(src, dest, opts);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs47.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts) {
      fs47.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    __name(copyDir, "copyDir");
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path44.join(src, item);
      const destItem = path44.join(dest, item);
      const { destStat } = stat8.checkPathsSync(srcItem, destItem, "copy");
      return startCopy(destStat, srcItem, destItem, opts);
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs47.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path44.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs47.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs47.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN") return fs47.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path44.resolve(process.cwd(), resolvedDest);
        }
        if (stat8.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs47.statSync(dest).isDirectory() && stat8.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest) {
      fs47.unlinkSync(dest);
      return fs47.symlinkSync(resolvedSrc, dest);
    }
    __name(copyLink, "copyLink");
    module2.exports = copySync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync()
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/path-exists/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromPromise;
    var fs47 = require_fs();
    function pathExists9(path44) {
      return fs47.access(path44).then(() => true).catch(() => false);
    }
    __name(pathExists9, "pathExists");
    module2.exports = {
      pathExists: u13(pathExists9),
      pathExistsSync: fs47.existsSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/copy.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists9 = require_path_exists().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat8 = require_stat();
    function copy2(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat8.checkPaths(src, dest, "copy", (err, stats) => {
        if (err) return cb(err);
        const { srcStat, destStat } = stats;
        stat8.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2) return cb(err2);
          if (opts.filter) return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    __name(copy2, "copy");
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path44.dirname(dest);
      pathExists9(destParent, (err, dirExists) => {
        if (err) return cb(err);
        if (dirExists) return startCopy(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2) return cb(err2);
          return startCopy(destStat, src, dest, opts, cb);
        });
      });
    }
    __name(checkParentDir, "checkParentDir");
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include) return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error5) => cb(error5));
    }
    __name(handleFilter, "handleFilter");
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter) return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    __name(startCopy, "startCopy");
    function getStats(destStat, src, dest, opts, cb) {
      const stat9 = opts.dereference ? fs47.stat : fs47.lstat;
      stat9(src, (err, srcStat) => {
        if (err) return cb(err);
        if (srcStat.isDirectory()) return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice()) return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink()) return onLink(destStat, src, dest, opts, cb);
      });
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat) return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs47.unlink(dest, (err) => {
          if (err) return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else return cb();
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile(srcStat, src, dest, opts, cb) {
      fs47.copyFile(src, dest, (err) => {
        if (err) return cb(err);
        if (opts.preserveTimestamps) return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    __name(copyFile, "copyFile");
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err) return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    __name(handleTimestampsAndMode, "handleTimestampsAndMode");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err) return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    __name(setDestTimestampsAndMode, "setDestTimestampsAndMode");
    function setDestMode(dest, srcMode, cb) {
      return fs47.chmod(dest, srcMode, cb);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest, cb) {
      fs47.stat(src, (err, updatedSrcStat) => {
        if (err) return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat) return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      if (destStat && !destStat.isDirectory()) {
        return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
      }
      return copyDir(src, dest, opts, cb);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs47.mkdir(dest, (err) => {
        if (err) return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2) return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts, cb) {
      fs47.readdir(src, (err, items) => {
        if (err) return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    __name(copyDir, "copyDir");
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item) return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    __name(copyDirItems, "copyDirItems");
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path44.join(src, item);
      const destItem = path44.join(dest, item);
      stat8.checkPaths(srcItem, destItem, "copy", (err, stats) => {
        if (err) return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2) return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts, cb) {
      fs47.readlink(src, (err, resolvedSrc) => {
        if (err) return cb(err);
        if (opts.dereference) {
          resolvedSrc = path44.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs47.symlink(resolvedSrc, dest, cb);
        } else {
          fs47.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN") return fs47.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path44.resolve(process.cwd(), resolvedDest);
            }
            if (stat8.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat8.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest, cb) {
      fs47.unlink(dest, (err) => {
        if (err) return cb(err);
        return fs47.symlink(resolvedSrc, dest, cb);
      });
    }
    __name(copyLink, "copyLink");
    module2.exports = copy2;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    module2.exports = {
      copy: u13(require_copy())
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/rimraf.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var assert = require("assert");
    var isWindows2 = process.platform === "win32";
    function defaults4(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m13) => {
        options[m13] = options[m13] || fs47[m13];
        m13 = m13 + "Sync";
        options[m13] = options[m13] || fs47[m13];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    __name(defaults4, "defaults");
    function rimraf(p13, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p13, "rimraf: missing path");
      assert.strictEqual(typeof p13, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults4(options);
      rimraf_(p13, options, /* @__PURE__ */ __name(function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time2 = busyTries * 100;
            return setTimeout(() => rimraf_(p13, options, CB), time2);
          }
          if (er.code === "ENOENT") er = null;
        }
        cb(er);
      }, "CB"));
    }
    __name(rimraf, "rimraf");
    function rimraf_(p13, options, cb) {
      assert(p13);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p13, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows2) {
          return fixWinEPERM(p13, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p13, options, er, cb);
        }
        options.unlink(p13, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows2 ? fixWinEPERM(p13, options, er2, cb) : rmdir(p13, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p13, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    __name(rimraf_, "rimraf_");
    function fixWinEPERM(p13, options, er, cb) {
      assert(p13);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p13, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p13, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p13, options, er, cb);
            } else {
              options.unlink(p13, cb);
            }
          });
        }
      });
    }
    __name(fixWinEPERM, "fixWinEPERM");
    function fixWinEPERMSync(p13, options, er) {
      let stats;
      assert(p13);
      assert(options);
      try {
        options.chmodSync(p13, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p13);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync2(p13, options, er);
      } else {
        options.unlinkSync(p13);
      }
    }
    __name(fixWinEPERMSync, "fixWinEPERMSync");
    function rmdir(p13, options, originalEr, cb) {
      assert(p13);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p13, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p13, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    __name(rmdir, "rmdir");
    function rmkids(p13, options, cb) {
      assert(p13);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p13, (er, files) => {
        if (er) return cb(er);
        let n13 = files.length;
        let errState;
        if (n13 === 0) return options.rmdir(p13, cb);
        files.forEach((f13) => {
          rimraf(path44.join(p13, f13), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2) return cb(errState = er2);
            if (--n13 === 0) {
              options.rmdir(p13, cb);
            }
          });
        });
      });
    }
    __name(rmkids, "rmkids");
    function rimrafSync(p13, options) {
      let st;
      options = options || {};
      defaults4(options);
      assert(p13, "rimraf: missing path");
      assert.strictEqual(typeof p13, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p13);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows2) {
          fixWinEPERMSync(p13, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync2(p13, options, null);
        } else {
          options.unlinkSync(p13);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows2 ? fixWinEPERMSync(p13, options, er) : rmdirSync2(p13, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync2(p13, options, er);
      }
    }
    __name(rimrafSync, "rimrafSync");
    function rmdirSync2(p13, options, originalEr) {
      assert(p13);
      assert(options);
      try {
        options.rmdirSync(p13);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p13, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    __name(rmdirSync2, "rmdirSync");
    function rmkidsSync(p13, options) {
      assert(p13);
      assert(options);
      options.readdirSync(p13).forEach((f13) => rimrafSync(path44.join(p13, f13), options));
      if (isWindows2) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p13, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p13, options);
        return ret;
      }
    }
    __name(rmkidsSync, "rmkidsSync");
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var rimraf = require_rimraf();
    module2.exports = {
      remove: u13(rimraf),
      removeSync: rimraf.sync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/empty/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var mkdir2 = require_mkdirs();
    var remove2 = require_remove();
    var emptyDir = u13(/* @__PURE__ */ __name(function emptyDir2(dir, callback) {
      callback = callback || function() {
      };
      fs47.readdir(dir, (err, items) => {
        if (err) return mkdir2.mkdirs(dir, callback);
        items = items.map((item) => path44.join(dir, item));
        deleteItem();
        function deleteItem() {
          const item = items.pop();
          if (!item) return callback();
          remove2.remove(item, (err2) => {
            if (err2) return callback(err2);
            deleteItem();
          });
        }
        __name(deleteItem, "deleteItem");
      });
    }, "emptyDir"));
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs47.readdirSync(dir);
      } catch {
        return mkdir2.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path44.join(dir, item);
        remove2.removeSync(item);
      });
    }
    __name(emptyDirSync, "emptyDirSync");
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/file.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var path44 = require("path");
    var fs47 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    function createFile(file, callback) {
      function makeFile() {
        fs47.writeFile(file, "", (err) => {
          if (err) return callback(err);
          callback();
        });
      }
      __name(makeFile, "makeFile");
      fs47.stat(file, (err, stats) => {
        if (!err && stats.isFile()) return callback();
        const dir = path44.dirname(file);
        fs47.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir2.mkdirs(dir, (err3) => {
                if (err3) return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory()) makeFile();
          else {
            fs47.readdir(dir, (err3) => {
              if (err3) return callback(err3);
            });
          }
        });
      });
    }
    __name(createFile, "createFile");
    function createFileSync(file) {
      let stats;
      try {
        stats = fs47.statSync(file);
      } catch {
      }
      if (stats && stats.isFile()) return;
      const dir = path44.dirname(file);
      try {
        if (!fs47.statSync(dir).isDirectory()) {
          fs47.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT") mkdir2.mkdirsSync(dir);
        else throw err;
      }
      fs47.writeFileSync(file, "");
    }
    __name(createFileSync, "createFileSync");
    module2.exports = {
      createFile: u13(createFile),
      createFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/link.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var path44 = require("path");
    var fs47 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    var pathExists9 = require_path_exists().pathExists;
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs47.link(srcpath2, dstpath2, (err) => {
          if (err) return callback(err);
          callback(null);
        });
      }
      __name(makeLink, "makeLink");
      pathExists9(dstpath, (err, destinationExists) => {
        if (err) return callback(err);
        if (destinationExists) return callback(null);
        fs47.lstat(srcpath, (err2) => {
          if (err2) {
            err2.message = err2.message.replace("lstat", "ensureLink");
            return callback(err2);
          }
          const dir = path44.dirname(dstpath);
          pathExists9(dir, (err3, dirExists) => {
            if (err3) return callback(err3);
            if (dirExists) return makeLink(srcpath, dstpath);
            mkdir2.mkdirs(dir, (err4) => {
              if (err4) return callback(err4);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    __name(createLink, "createLink");
    function createLinkSync(srcpath, dstpath) {
      const destinationExists = fs47.existsSync(dstpath);
      if (destinationExists) return void 0;
      try {
        fs47.lstatSync(srcpath);
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path44.dirname(dstpath);
      const dirExists = fs47.existsSync(dir);
      if (dirExists) return fs47.linkSync(srcpath, dstpath);
      mkdir2.mkdirsSync(dir);
      return fs47.linkSync(srcpath, dstpath);
    }
    __name(createLinkSync, "createLinkSync");
    module2.exports = {
      createLink: u13(createLink),
      createLinkSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports2, module2) {
    "use strict";
    var path44 = require("path");
    var fs47 = require_graceful_fs();
    var pathExists9 = require_path_exists().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path44.isAbsolute(srcpath)) {
        return fs47.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path44.dirname(dstpath);
        const relativeToDst = path44.join(dstdir, srcpath);
        return pathExists9(relativeToDst, (err, exists) => {
          if (err) return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs47.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path44.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    __name(symlinkPaths, "symlinkPaths");
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path44.isAbsolute(srcpath)) {
        exists = fs47.existsSync(srcpath);
        if (!exists) throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path44.dirname(dstpath);
        const relativeToDst = path44.join(dstdir, srcpath);
        exists = fs47.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs47.existsSync(srcpath);
          if (!exists) throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path44.relative(dstdir, srcpath)
          };
        }
      }
    }
    __name(symlinkPathsSync, "symlinkPathsSync");
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type) return callback(null, type);
      fs47.lstat(srcpath, (err, stats) => {
        if (err) return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    __name(symlinkType, "symlinkType");
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type) return type;
      try {
        stats = fs47.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    __name(symlinkTypeSync, "symlinkTypeSync");
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var path44 = require("path");
    var fs47 = require_graceful_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync2 = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists9 = require_path_exists().pathExists;
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      pathExists9(dstpath, (err, destinationExists) => {
        if (err) return callback(err);
        if (destinationExists) return callback(null);
        symlinkPaths(srcpath, dstpath, (err2, relative4) => {
          if (err2) return callback(err2);
          srcpath = relative4.toDst;
          symlinkType(relative4.toCwd, type, (err3, type2) => {
            if (err3) return callback(err3);
            const dir = path44.dirname(dstpath);
            pathExists9(dir, (err4, dirExists) => {
              if (err4) return callback(err4);
              if (dirExists) return fs47.symlink(srcpath, dstpath, type2, callback);
              mkdirs(dir, (err5) => {
                if (err5) return callback(err5);
                fs47.symlink(srcpath, dstpath, type2, callback);
              });
            });
          });
        });
      });
    }
    __name(createSymlink, "createSymlink");
    function createSymlinkSync(srcpath, dstpath, type) {
      const destinationExists = fs47.existsSync(dstpath);
      if (destinationExists) return void 0;
      const relative4 = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative4.toDst;
      type = symlinkTypeSync(relative4.toCwd, type);
      const dir = path44.dirname(dstpath);
      const exists = fs47.existsSync(dir);
      if (exists) return fs47.symlinkSync(srcpath, dstpath, type);
      mkdirsSync2(dir);
      return fs47.symlinkSync(srcpath, dstpath, type);
    }
    __name(createSymlinkSync, "createSymlinkSync");
    module2.exports = {
      createSymlink: u13(createSymlink),
      createSymlinkSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/index.js"(exports2, module2) {
    "use strict";
    var file = require_file();
    var link = require_link();
    var symlink = require_symlink();
    module2.exports = {
      // file
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      // link
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      // symlink
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// ../../node_modules/jsonfile/utils.js
var require_utils = __commonJS({
  "../../node_modules/jsonfile/utils.js"(exports2, module2) {
    function stringify2(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF2 = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF2;
    }
    __name(stringify2, "stringify");
    function stripBom(content) {
      if (Buffer.isBuffer(content)) content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    __name(stripBom, "stripBom");
    module2.exports = { stringify: stringify2, stripBom };
  }
});

// ../../node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "../../node_modules/jsonfile/index.js"(exports2, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_2) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify: stringify2, stripBom } = require_utils();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs47 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data3 = await universalify.fromCallback(fs47.readFile)(file, options);
      data3 = stripBom(data3);
      let obj;
      try {
        obj = JSON.parse(data3, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    __name(_readFile, "_readFile");
    var readFile5 = universalify.fromPromise(_readFile);
    function readFileSync12(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs47 = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs47.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    __name(readFileSync12, "readFileSync");
    async function _writeFile(file, obj, options = {}) {
      const fs47 = options.fs || _fs;
      const str = stringify2(obj, options);
      await universalify.fromCallback(fs47.writeFile)(file, str, options);
    }
    __name(_writeFile, "_writeFile");
    var writeFile5 = universalify.fromPromise(_writeFile);
    function writeFileSync6(file, obj, options = {}) {
      const fs47 = options.fs || _fs;
      const str = stringify2(obj, options);
      return fs47.writeFileSync(file, str, options);
    }
    __name(writeFileSync6, "writeFileSync");
    module2.exports = {
      readFile: readFile5,
      readFileSync: readFileSync12,
      writeFile: writeFile5,
      writeFileSync: writeFileSync6
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/jsonfile.js"(exports2, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      // jsonfile exports
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/output/index.js
var require_output = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/output/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var mkdir2 = require_mkdirs();
    var pathExists9 = require_path_exists().pathExists;
    function outputFile(file, data3, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path44.dirname(file);
      pathExists9(dir, (err, itDoes) => {
        if (err) return callback(err);
        if (itDoes) return fs47.writeFile(file, data3, encoding, callback);
        mkdir2.mkdirs(dir, (err2) => {
          if (err2) return callback(err2);
          fs47.writeFile(file, data3, encoding, callback);
        });
      });
    }
    __name(outputFile, "outputFile");
    function outputFileSync(file, ...args) {
      const dir = path44.dirname(file);
      if (fs47.existsSync(dir)) {
        return fs47.writeFileSync(file, ...args);
      }
      mkdir2.mkdirsSync(dir);
      fs47.writeFileSync(file, ...args);
    }
    __name(outputFileSync, "outputFileSync");
    module2.exports = {
      outputFile: u13(outputFile),
      outputFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils();
    var { outputFile } = require_output();
    async function outputJson(file, data3, options = {}) {
      const str = stringify2(data3, options);
      await outputFile(file, str, options);
    }
    __name(outputJson, "outputJson");
    module2.exports = outputJson;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json-sync.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils();
    var { outputFileSync } = require_output();
    function outputJsonSync(file, data3, options) {
      const str = stringify2(data3, options);
      outputFileSync(file, str, options);
    }
    __name(outputJsonSync, "outputJsonSync");
    module2.exports = outputJsonSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u13(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/move-sync.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var copySync = require_copy_sync2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync2 = require_mkdirs().mkdirpSync;
    var stat8 = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat } = stat8.checkPathsSync(src, dest, "move");
      stat8.checkParentPathsSync(src, srcStat, dest, "move");
      mkdirpSync2(path44.dirname(dest));
      return doRename(src, dest, overwrite);
    }
    __name(moveSync, "moveSync");
    function doRename(src, dest, overwrite) {
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs47.existsSync(dest)) throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    __name(doRename, "doRename");
    function rename(src, dest, overwrite) {
      try {
        fs47.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV") throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    __name(rename, "rename");
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = moveSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync()
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/move.js"(exports2, module2) {
    "use strict";
    var fs47 = require_graceful_fs();
    var path44 = require("path");
    var copy2 = require_copy2().copy;
    var remove2 = require_remove().remove;
    var mkdirp2 = require_mkdirs().mkdirp;
    var pathExists9 = require_path_exists().pathExists;
    var stat8 = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat8.checkPaths(src, dest, "move", (err, stats) => {
        if (err) return cb(err);
        const { srcStat } = stats;
        stat8.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2) return cb(err2);
          mkdirp2(path44.dirname(dest), (err3) => {
            if (err3) return cb(err3);
            return doRename(src, dest, overwrite, cb);
          });
        });
      });
    }
    __name(move, "move");
    function doRename(src, dest, overwrite, cb) {
      if (overwrite) {
        return remove2(dest, (err) => {
          if (err) return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists9(dest, (err, destExists) => {
        if (err) return cb(err);
        if (destExists) return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    __name(doRename, "doRename");
    function rename(src, dest, overwrite, cb) {
      fs47.rename(src, dest, (err) => {
        if (!err) return cb();
        if (err.code !== "EXDEV") return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    __name(rename, "rename");
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy2(src, dest, opts, (err) => {
        if (err) return cb(err);
        return remove2(src, cb);
      });
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = move;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/index.js"(exports2, module2) {
    "use strict";
    var u13 = require_universalify().fromCallback;
    module2.exports = {
      move: u13(require_move())
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/index.js
var require_lib4 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      // Export promiseified graceful-fs:
      ...require_fs(),
      // Export extra methods:
      ...require_copy_sync2(),
      ...require_copy2(),
      ...require_empty(),
      ...require_ensure(),
      ...require_json(),
      ...require_mkdirs(),
      ...require_move_sync2(),
      ...require_move2(),
      ...require_output(),
      ...require_path_exists(),
      ...require_remove()
    };
    var fs47 = require("fs");
    if (Object.getOwnPropertyDescriptor(fs47, "promises")) {
      Object.defineProperty(module2.exports, "promises", {
        get() {
          return fs47.promises;
        }
      });
    }
  }
});

// ../@aws-cdk/toolkit-lib/lib/api/bootstrap/bootstrap-props.ts
var BUCKET_NAME_OUTPUT, REPOSITORY_NAME_OUTPUT, BUCKET_DOMAIN_NAME_OUTPUT, BOOTSTRAP_VERSION_OUTPUT, BOOTSTRAP_VERSION_RESOURCE, BOOTSTRAP_VARIANT_PARAMETER, DEFAULT_BOOTSTRAP_VARIANT;
var init_bootstrap_props = __esm({
  "../@aws-cdk/toolkit-lib/lib/api/bootstrap/bootstrap-props.ts"() {
    "use strict";
    BUCKET_NAME_OUTPUT = "BucketName";
    REPOSITORY_NAME_OUTPUT = "ImageRepositoryName";
    BUCKET_DOMAIN_NAME_OUTPUT = "BucketDomainName";
    BOOTSTRAP_VERSION_OUTPUT = "BootstrapVersion";
    BOOTSTRAP_VERSION_RESOURCE = "CdkBootstrapVersion";
    BOOTSTRAP_VARIANT_PARAMETER = "BootstrapVariant";
    DEFAULT_BOOTSTRAP_VARIANT = "AWS CDK: Default Resources";
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/progress.ts
var progress_exports = {};
__export(progress_exports, {
  EventType: () => EventType,
  shellEventPublisherFromEventEmitter: () => shellEventPublisherFromEventEmitter,
  shellEventToEventType: () => shellEventToEventType
});
function shellEventToEventType(event) {
  switch (event) {
    case "open":
      return "shell_open" /* SHELL_OPEN */;
    case "close":
      return "shell_close" /* SHELL_CLOSE */;
    case "data_stdout":
      return "shell_stdout" /* SHELL_STDOUT */;
    case "data_stderr":
      return "shell_stderr" /* SHELL_STDERR */;
  }
}
function shellEventPublisherFromEventEmitter(eventEmitter) {
  return (event, message2) => {
    const eventType = shellEventToEventType(event);
    eventEmitter(eventType, message2);
  };
}
var EventType;
var init_progress = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/progress.ts"() {
    "use strict";
    EventType = /* @__PURE__ */ ((EventType2) => {
      EventType2["START"] = "start";
      EventType2["SUCCESS"] = "success";
      EventType2["FAIL"] = "fail";
      EventType2["CHECK"] = "check";
      EventType2["FOUND"] = "found";
      EventType2["CACHED"] = "cached";
      EventType2["BUILD"] = "build";
      EventType2["UPLOAD"] = "upload";
      EventType2["DEBUG"] = "debug";
      EventType2["SHELL_OPEN"] = "shell_open";
      EventType2["SHELL_STDOUT"] = "shell_stdout";
      EventType2["SHELL_STDERR"] = "shell_stderr";
      EventType2["SHELL_CLOSE"] = "shell_close";
      return EventType2;
    })(EventType || {});
    __name(shellEventToEventType, "shellEventToEventType");
    __name(shellEventPublisherFromEventEmitter, "shellEventPublisherFromEventEmitter");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/docker-credentials.ts
function cdkCredentialsConfigFile() {
  return process.env.CDK_DOCKER_CREDS_FILE ?? path5.join(
    (os2.userInfo().homedir ?? os2.homedir()).trim() || "/",
    ".cdk",
    "cdk-docker-creds.json"
  );
}
function cdkCredentialsConfig() {
  if (!_cdkCredentials) {
    try {
      _cdkCredentials = JSON.parse(
        fs5.readFileSync(cdkCredentialsConfigFile(), { encoding: "utf-8" })
      );
    } catch {
    }
  }
  return _cdkCredentials;
}
async function obtainEcrCredentials(ecr, eventEmitter) {
  if (eventEmitter) {
    eventEmitter("debug" /* DEBUG */, "Fetching ECR authorization token");
  }
  const authData = (await ecr.getAuthorizationToken()).authorizationData || [];
  if (authData.length === 0) {
    throw new Error("No authorization data received from ECR");
  }
  const token = Buffer.from(authData[0].authorizationToken, "base64").toString("ascii");
  const [username, password] = token.split(":");
  if (!username || !password) {
    throw new Error("unexpected ECR authData format");
  }
  return {
    username,
    password,
    endpoint: authData[0].proxyEndpoint
  };
}
var fs5, os2, path5, _cdkCredentials;
var init_docker_credentials = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/docker-credentials.ts"() {
    "use strict";
    fs5 = __toESM(require("fs"));
    os2 = __toESM(require("os"));
    path5 = __toESM(require("path"));
    init_progress();
    __name(cdkCredentialsConfigFile, "cdkCredentialsConfigFile");
    __name(cdkCredentialsConfig, "cdkCredentialsConfig");
    __name(obtainEcrCredentials, "obtainEcrCredentials");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/shell.ts
async function shell(command2, options) {
  handleShellOutput(renderCommandLine(command2), options, "open");
  const child = child_process.spawn(command2[0], command2.slice(1), {
    ...options,
    stdio: [options.input ? "pipe" : "ignore", "pipe", "pipe"]
  });
  return new Promise((resolve16, reject) => {
    if (options.input) {
      child.stdin.write(options.input);
      child.stdin.end();
    }
    const stdout2 = new Array();
    const stderr2 = new Array();
    child.stdout.on("data", (chunk) => {
      handleShellOutput(chunk, options, "data_stdout");
      stdout2.push(chunk);
    });
    child.stderr.on("data", (chunk) => {
      handleShellOutput(chunk, options, "data_stderr");
      stderr2.push(chunk);
    });
    child.once("error", reject);
    child.once("close", (code, signal) => {
      handleShellOutput(renderCommandLine(command2), options, "close");
      if (code === 0) {
        resolve16(Buffer.concat(stdout2).toString("utf-8"));
      } else {
        const out = Buffer.concat(stderr2).toString("utf-8").trim();
        reject(
          new ProcessFailed(
            code,
            signal,
            `${renderCommandLine(command2)} exited with ${code != null ? "error code" : "signal"} ${code ?? signal}: ${out}`
          )
        );
      }
    });
  });
}
function handleShellOutput(chunk, options, shellEventType) {
  switch (options.subprocessOutputDestination) {
    case "ignore":
      return;
    case "publish":
      options.shellEventPublisher(shellEventType, chunk.toString("utf-8"));
      break;
    case "stdio":
    default:
      switch (shellEventType) {
        case "data_stdout":
          process.stdout.write(chunk);
          break;
        case "data_stderr":
          process.stderr.write(chunk);
          break;
        case "open":
          options.shellEventPublisher(shellEventType, chunk.toString("utf-8"));
          break;
      }
      break;
  }
}
function renderCommandLine(cmd) {
  if (process.platform !== "win32") {
    return doRender(cmd, hasAnyChars(" ", "\\", "!", '"', "'", "&", "$"), posixEscape);
  } else {
    return doRender(cmd, hasAnyChars(" ", '"', "&", "^", "%"), windowsEscape);
  }
}
function doRender(cmd, needsEscaping, doEscape) {
  return cmd.map((x13) => needsEscaping(x13) ? doEscape(x13) : x13).join(" ");
}
function hasAnyChars(...chars) {
  return (str) => {
    return chars.some((c13) => str.indexOf(c13) !== -1);
  };
}
function posixEscape(x13) {
  x13 = x13.replace(/'/g, `'"'"'`);
  return `'${x13}'`;
}
function windowsEscape(x13) {
  x13 = `"${x13}"`;
  const shellMeta = /* @__PURE__ */ new Set(['"', "&", "^", "%"]);
  return x13.split("").map((c13) => shellMeta.has(x13) ? "^" + c13 : c13).join("");
}
var child_process, ProcessFailed;
var init_shell = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/shell.ts"() {
    "use strict";
    child_process = __toESM(require("child_process"));
    __name(shell, "shell");
    __name(handleShellOutput, "handleShellOutput");
    ProcessFailed = class extends Error {
      constructor(exitCode, signal, message2) {
        super(message2);
        this.exitCode = exitCode;
        this.signal = signal;
        this.code = "PROCESS_FAILED";
      }
      static {
        __name(this, "ProcessFailed");
      }
    };
    __name(renderCommandLine, "renderCommandLine");
    __name(doRender, "doRender");
    __name(hasAnyChars, "hasAnyChars");
    __name(posixEscape, "posixEscape");
    __name(windowsEscape, "windowsEscape");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/util.ts
function createCriticalSection() {
  let lock = Promise.resolve();
  return async (criticalFunction) => {
    const res = lock.then(() => criticalFunction());
    lock = res.catch((e13) => e13);
    return res;
  };
}
var init_util = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/util.ts"() {
    "use strict";
    __name(createCriticalSection, "createCriticalSection");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/docker.ts
function getDockerCmd() {
  return process.env.CDK_DOCKER ?? "docker";
}
function flatten(x13) {
  return Array.prototype.concat([], ...x13);
}
var fs6, os3, path6, Docker, DockerFactory;
var init_docker = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/docker.ts"() {
    "use strict";
    fs6 = __toESM(require("fs"));
    os3 = __toESM(require("os"));
    path6 = __toESM(require("path"));
    init_docker_credentials();
    init_shell();
    init_util();
    init_progress();
    Docker = class {
      constructor(eventEmitter, subprocessOutputDestination) {
        this.eventEmitter = eventEmitter;
        this.subprocessOutputDestination = subprocessOutputDestination;
        this.configDir = void 0;
      }
      static {
        __name(this, "Docker");
      }
      /**
       * Whether an image with the given tag exists
       */
      async exists(tag2) {
        try {
          await this.execute(["inspect", tag2], {
            subprocessOutputDestination: "ignore"
          });
          return true;
        } catch (e13) {
          const error5 = e13;
          if (error5.code !== "PROCESS_FAILED") {
            throw error5;
          }
          switch (error5.exitCode) {
            case 1 /* Docker */:
            case 125 /* Podman */:
              return false;
            default:
              throw error5;
          }
        }
      }
      async build(options) {
        const buildCommand = [
          "build",
          ...flatten(
            Object.entries(options.buildArgs || {}).map(([k13, v14]) => ["--build-arg", `${k13}=${v14}`])
          ),
          ...flatten(
            Object.entries(options.buildSecrets || {}).map(([k13, v14]) => ["--secret", `id=${k13},${v14}`])
          ),
          ...options.buildSsh ? ["--ssh", options.buildSsh] : [],
          "--tag",
          options.tag,
          ...options.target ? ["--target", options.target] : [],
          ...options.file ? ["--file", options.file] : [],
          ...options.networkMode ? ["--network", options.networkMode] : [],
          ...options.platform ? ["--platform", options.platform] : [],
          ...options.outputs ? options.outputs.map((output) => [`--output=${output}`]) : [],
          ...options.cacheFrom ? [
            ...options.cacheFrom.map((cacheFrom) => ["--cache-from", this.cacheOptionToFlag(cacheFrom)]).flat()
          ] : [],
          ...options.cacheTo ? ["--cache-to", this.cacheOptionToFlag(options.cacheTo)] : [],
          ...options.cacheDisabled ? ["--no-cache"] : [],
          "."
        ];
        await this.execute(buildCommand, {
          cwd: options.directory,
          subprocessOutputDestination: this.subprocessOutputDestination,
          env: {
            BUILDX_NO_DEFAULT_ATTESTATIONS: "1"
            // Docker Build adds provenance attestations by default that confuse cdk-assets
          }
        });
      }
      /**
       * Get credentials from ECR and run docker login
       */
      async login(ecr) {
        const credentials = await obtainEcrCredentials(ecr, this.eventEmitter);
        await this.execute(
          ["login", "--username", credentials.username, "--password-stdin", credentials.endpoint.replace(/^https?:\/\/|\/$/g, "")],
          {
            input: credentials.password,
            // Need to ignore otherwise Docker will complain
            // 'WARNING! Your password will be stored unencrypted'
            // doesn't really matter since it's a token.
            subprocessOutputDestination: "ignore"
          }
        );
      }
      async tag(sourceTag, targetTag) {
        await this.execute(["tag", sourceTag, targetTag]);
      }
      async push(options) {
        await this.execute(["push", options.tag], {
          subprocessOutputDestination: this.subprocessOutputDestination
        });
      }
      /**
       * If a CDK Docker Credentials file exists, creates a new Docker config directory.
       * Sets up `docker-credential-cdk-assets` to be the credential helper for each domain in the CDK config.
       * All future commands (e.g., `build`, `push`) will use this config.
       *
       * See https://docs.docker.com/engine/reference/commandline/login/#credential-helpers for more details on cred helpers.
       *
       * @returns true if CDK config was found and configured, false otherwise
       */
      configureCdkCredentials() {
        const config = cdkCredentialsConfig();
        if (!config) {
          return false;
        }
        this.configDir = fs6.mkdtempSync(path6.join(os3.tmpdir(), "cdkDockerConfig"));
        const domains = Object.keys(config.domainCredentials);
        const credHelpers = domains.reduce((map2, domain) => {
          map2[domain] = "cdk-assets";
          return map2;
        }, {});
        fs6.writeFileSync(path6.join(this.configDir, "config.json"), JSON.stringify({ credHelpers }), {
          encoding: "utf-8"
        });
        return true;
      }
      /**
       * Removes any configured Docker config directory.
       * All future commands (e.g., `build`, `push`) will use the default config.
       *
       * This is useful after calling `configureCdkCredentials` to reset to default credentials.
       */
      resetAuthPlugins() {
        this.configDir = void 0;
      }
      async execute(args, options = {}) {
        const configArgs = this.configDir ? ["--config", this.configDir] : [];
        const pathToCdkAssets = path6.resolve(__dirname, "..", "..", "bin");
        const shellEventPublisher = shellEventPublisherFromEventEmitter(this.eventEmitter);
        try {
          await shell([getDockerCmd(), ...configArgs, ...args], {
            ...options,
            shellEventPublisher,
            env: {
              ...process.env,
              ...options.env,
              PATH: `${pathToCdkAssets}${path6.delimiter}${options.env?.PATH ?? process.env.PATH}`
            }
          });
        } catch (e13) {
          if (e13.code === "ENOENT") {
            throw new Error(
              `Failed to find and execute '${getDockerCmd()}' while attempting to build a container asset. Please install '${getDockerCmd()}' and try again. (Or set the 'CDK_DOCKER ' environment variable to choose a different compatible container client.)`
            );
          }
          throw e13;
        }
      }
      cacheOptionToFlag(option) {
        let flag = `type=${option.type}`;
        if (option.params) {
          flag += "," + Object.entries(option.params).map(([k13, v14]) => `${k13}=${v14}`).join(",");
        }
        return flag;
      }
    };
    DockerFactory = class {
      constructor() {
        this.enterLoggedInDestinationsCriticalSection = createCriticalSection();
        this.loggedInDestinations = /* @__PURE__ */ new Set();
      }
      static {
        __name(this, "DockerFactory");
      }
      /**
       * Gets a Docker instance for building images.
       */
      async forBuild(options) {
        const docker = new Docker(options.eventEmitter, options.subprocessOutputDestination);
        let cdkDockerCredentialsConfigured = docker.configureCdkCredentials();
        if (!cdkDockerCredentialsConfigured) {
          await this.loginOncePerDestination(docker, options);
        }
        return docker;
      }
      /**
       * Gets a Docker instance for pushing images to ECR.
       */
      async forEcrPush(options) {
        const docker = new Docker(options.eventEmitter, options.subprocessOutputDestination);
        await this.loginOncePerDestination(docker, options);
        return docker;
      }
      async loginOncePerDestination(docker, options) {
        const repositoryDomain = options.repoUri.split("/")[0];
        await this.enterLoggedInDestinationsCriticalSection(async () => {
          if (this.loggedInDestinations.has(repositoryDomain)) {
            return;
          }
          await docker.login(options.ecr);
          this.loggedInDestinations.add(repositoryDomain);
        });
      }
    };
    __name(getDockerCmd, "getDockerCmd");
    __name(flatten, "flatten");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/handlers/client-options.ts
function destinationToClientOptions(destination) {
  return {
    assumeRoleArn: destination.assumeRoleArn,
    assumeRoleExternalId: destination.assumeRoleExternalId,
    assumeRoleAdditionalOptions: destination.assumeRoleAdditionalOptions,
    region: destination.region
  };
}
var init_client_options = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/handlers/client-options.ts"() {
    "use strict";
    __name(destinationToClientOptions, "destinationToClientOptions");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/placeholders.ts
async function replaceAwsPlaceholders(object, aws) {
  let partition3 = /* @__PURE__ */ __name(async () => {
    const p13 = await aws.discoverPartition();
    partition3 = /* @__PURE__ */ __name(() => Promise.resolve(p13), "partition");
    return p13;
  }, "partition");
  let account = /* @__PURE__ */ __name(async () => {
    const a13 = await aws.discoverCurrentAccount();
    account = /* @__PURE__ */ __name(() => Promise.resolve(a13), "account");
    return a13;
  }, "account");
  return import_cloud_assembly_api.EnvironmentPlaceholders.replaceAsync(object, {
    async region() {
      return object.region ?? aws.discoverDefaultRegion();
    },
    async accountId() {
      return (await account()).accountId;
    },
    async partition() {
      return partition3();
    }
  });
}
var import_cloud_assembly_api;
var init_placeholders2 = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/placeholders.ts"() {
    "use strict";
    import_cloud_assembly_api = __toESM(require_lib3());
    __name(replaceAwsPlaceholders, "replaceAwsPlaceholders");
  }
});

// ../@aws-cdk/cdk-assets-lib/lib/private/handlers/container-images.ts
async function imageExists(ecr, repositoryName, imageTag) {
  try {
    await ecr.describeImages({
      repositoryName,
      imageIds: [{ imageTag }]
    });
    return true;
  } catch (e13) {
    if (e13.name !== "ImageNotFoundException") {
      throw e13;
    }
    return false;
  }
}
async function repositoryUri(ecr, repositoryName) {
  try {
    const response = await ecr.describeRepositories({
      repositoryNames: [repositoryName]
    });
    return (response.repositories || [])[0]?.repositoryUri;
  } catch (e13) {
    if (e13.name !== "RepositoryNotFoundException") {
      throw e13;
    }
    return void 0;
  }
}
var path7, ContainerImageAssetHandler, ContainerImageBuilder;
var init_container_images = __esm({
  "../@aws-cdk/cdk-assets-lib/lib/private/handlers/container-images.ts"() {
    "use strict";
    path7 = __toESM(require("path"));
    init_client_options();
    init_progress();
    init_placeholders2();
    init_shell();
    ContainerImageAssetHandler = class {
      constructor(workDir, asset, host, options) {
        this.workDir = workDir;
        this.asset = asset;
        this.host = host;
        this.options = options;
      }
      static {
        __name(this, "ContainerImageAssetHandler");
      }
      async build() {
        const initOnce = await this.initOnce();
        if (initOnce.destinationAlreadyExists) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        const dockerForBuilding = await this.host.dockerFactory.forBuild({
          repoUri: initOnce.repoUri,
          eventEmitter: /* @__PURE__ */ __name((m13) => this.host.emitMessage("debug" /* DEBUG */, m13), "eventEmitter"),
          ecr: initOnce.ecr,
          subprocessOutputDestination: this.options.subprocessOutputDestination
        });
        const builder = new ContainerImageBuilder(
          dockerForBuilding,
          this.workDir,
          this.asset,
          this.host
        );
        const localTagName = await builder.build();
        if (localTagName === void 0 || this.host.aborted) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        await dockerForBuilding.tag(localTagName, initOnce.imageUri);
      }
      async isPublished() {
        try {
          const initOnce = await this.initOnce({ quiet: true });
          return initOnce.destinationAlreadyExists;
        } catch (e13) {
          this.host.emitMessage("debug" /* DEBUG */, `${e13.message}`);
        }
        return false;
      }
      async publish() {
        const initOnce = await this.initOnce();
        if (initOnce.destinationAlreadyExists) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        const dockerForPushing = await this.host.dockerFactory.forEcrPush({
          repoUri: initOnce.repoUri,
          eventEmitter: this.host.emitMessage,
          ecr: initOnce.ecr,
          subprocessOutputDestination: this.options.subprocessOutputDestination
        });
        if (this.host.aborted) {
          return;
        }
        this.host.emitMessage("upload" /* UPLOAD */, `Push ${initOnce.imageUri}`);
        await dockerForPushing.push({
          tag: initOnce.imageUri
        });
      }
      async initOnce(options = {}) {
        if (this.init) {
          return this.init;
        }
        const destination = await replaceAwsPlaceholders(this.asset.destination, this.host.aws);
        const ecr = await this.host.aws.ecrClient({
          ...destinationToClientOptions(destination),
          quiet: options.quiet
        });
        const account = /* @__PURE__ */ __name(async () => (await this.host.aws.discoverCurrentAccount())?.accountId, "account");
        const repoUri = await repositoryUri(ecr, destination.repositoryName);
        if (!repoUri) {
          throw new Error(
            `No ECR repository named '${destination.repositoryName}' in account ${await account()}. Is this account bootstrapped?`
          );
        }
        const imageUri = `${repoUri}:${destination.imageTag}`;
        this.init = {
          imageUri,
          ecr,
          repoUri,
          destinationAlreadyExists: await this.destinationAlreadyExists(ecr, destination, imageUri)
        };
        return this.init;
      }
      /**
       * Check whether the image already exists in the ECR repo
       *
       * Use the fields from the destination to do the actual check. The imageUri
       * should correspond to that, but is only used to print Docker image location
       * for user benefit (the format is slightly different).
       */
      async destinationAlreadyExists(ecr, destination, imageUri) {
        this.host.emitMessage("check" /* CHECK */, `Check ${imageUri}`);
        if (await imageExists(ecr, destination.repositoryName, destination.imageTag)) {
          this.host.emitMessage("found" /* FOUND */, `Found ${imageUri}`);
          return true;
        }
        return false;
      }
    };
    ContainerImageBuilder = class {
      constructor(docker, workDir, asset, host) {
        this.docker = docker;
        this.workDir = workDir;
        this.asset = asset;
        this.host = host;
      }
      static {
        __name(this, "ContainerImageBuilder");
      }
      async build() {
        return this.asset.source.executable ? this.buildExternalAsset(this.asset.source.executable) : this.buildDirectoryAsset();
      }
      /**
       * Build a (local) Docker asset from a directory with a Dockerfile
       *
       * Tags under a deterministic, unique, local identifier wich will skip
       * the build if it already exists.
       */
      async buildDirectoryAsset() {
        const localTagName = `cdkasset-${this.asset.id.assetId.toLowerCase()}`;
        if (!await this.isImageCached(localTagName)) {
          if (this.host.aborted) {
            return void 0;
          }
          await this.buildImage(localTagName);
        }
        return localTagName;
      }
      /**
       * Build a (local) Docker asset by running an external command
       *
       * External command is responsible for deduplicating the build if possible,
       * and is expected to return the generated image identifier on stdout.
       */
      async buildExternalAsset(executable, cwd) {
        const assetPath = cwd ?? this.workDir;
        this.host.emitMessage("build" /* BUILD */, `Building Docker image using command '${executable}'`);
        if (this.host.aborted) {
          return void 0;
        }
        const shellEventPublisher = shellEventPublisherFromEventEmitter(this.host.emitMessage);
        return (await shell(executable, {
          cwd: assetPath,
          shellEventPublisher,
          subprocessOutputDestination: "ignore"
        })).trim();
      }
      async buildImage(localTagName) {
        const source = this.asset.source;
        if (!source.directory) {
          throw new Error(
            `'directory' is expected in the DockerImage asset source, got: ${JSON.stringify(source)}`
          );
        }
        const fullPath = path7.resolve(this.workDir, source.directory);
        this.host.emitMessage("build" /* BUILD */, `Building Docker image at ${fullPath}`);
        await this.docker.build({
          directory: fullPath,
          tag: localTagName,
          buildArgs: source.dockerBuildArgs,
          buildSecrets: source.dockerBuildSecrets,
          buildSsh: source.dockerBuildSsh,
          target: source.dockerBuildTarget,
          file: source.dockerFile,
          networkMode: source.networkMode,
          platform: source.platform,
          outputs: source.dockerOutputs,
          cacheFrom: source.cacheFrom,
          cacheTo: source.cacheTo,
          cacheDisabled: source.cacheDisabled
        });
      }
      async isImageCached(localTagName) {
        if (await this.docker.exists(localTagName)) {
          this.host.emitMessage("cached" /* CACHED */, `Cached ${localTagName}`);
          return true;
        }
        return false;
      }
    };
    __name(imageExists, "imageExists");
    __name(repositoryUri, "repositoryUri");
  }
});

// ../../node_modules/mime/Mime.js
var require_Mime = __commonJS({
  "../../node_modules/mime/Mime.js"(exports2, module2) {
    "use strict";
    function Mime() {
      this._types = /* @__PURE__ */ Object.create(null);
      this._extensions = /* @__PURE__ */ Object.create(null);
      for (let i13 = 0; i13 < arguments.length; i13++) {
        this.define(arguments[i13]);
      }
      this.define = this.define.bind(this);
      this.getType = this.getType.bind(this);
      this.getExtension = this.getExtension.bind(this);
    }
    __name(Mime, "Mime");
    Mime.prototype.define = function(typeMap, force) {
      for (let type in typeMap) {
        let extensions = typeMap[type].map(function(t13) {
          return t13.toLowerCase();
        });
        type = type.toLowerCase();
        for (let i13 = 0; i13 < extensions.length; i13++) {
          const ext4 = extensions[i13];
          if (ext4[0] === "*") {
            continue;
          }
          if (!force && ext4 in this._types) {
            throw new Error(
              'Attempt to change mapping for "' + ext4 + '" extension from "' + this._types[ext4] + '" to "' + type + '". Pass `force=true` to allow this, otherwise remove "' + ext4 + '" from the list of extensions for "' + type + '".'
            );
          }
          this._types[ext4] = type;
        }
        if (force || !this._extensions[type]) {
          const ext4 = extensions[0];
          this._extensions[type] = ext4[0] !== "*" ? ext4 : ext4.substr(1);
        }
      }
    };
    Mime.prototype.getType = function(path44) {
      path44 = String(path44);
      let last = path44.replace(/^.*[/\\]/, "").toLowerCase();
      let ext4 = last.replace(/^.*\./, "").toLowerCase();
      let hasPath = last.length < path44.length;
      let hasDot = ext4.length < last.length - 1;
      return (hasDot || !hasPath) && this._types[ext4] || null;
    };
    Mime.prototype.getExtension = function(type) {
      type = /^\s*([^;\s]*)/.test(type) && RegExp.$1;
      return type && this._extensions[type.toLowerCase()] || null;
    };
    module2.exports = Mime;
  }
});

// ../../node_modules/mime/types/standard.js
var require_standard = __commonJS({
  "../../node_modules/mime/types/standard.js"(exports2, module2) {
    module2.exports = { "application/andrew-inset": ["ez"], "application/applixware": ["aw"], "application/atom+xml": ["atom"], "application/atomcat+xml": ["atomcat"], "application/atomdeleted+xml": ["atomdeleted"], "application/atomsvc+xml": ["atomsvc"], "application/atsc-dwd+xml": ["dwd"], "application/atsc-held+xml": ["held"], "application/atsc-rsat+xml": ["rsat"], "application/bdoc": ["bdoc"], "application/calendar+xml": ["xcs"], "application/ccxml+xml": ["ccxml"], "application/cdfx+xml": ["cdfx"], "application/cdmi-capability": ["cdmia"], "application/cdmi-container": ["cdmic"], "application/cdmi-domain": ["cdmid"], "application/cdmi-object": ["cdmio"], "application/cdmi-queue": ["cdmiq"], "application/cu-seeme": ["cu"], "application/dash+xml": ["mpd"], "application/davmount+xml": ["davmount"], "application/docbook+xml": ["dbk"], "application/dssc+der": ["dssc"], "application/dssc+xml": ["xdssc"], "application/ecmascript": ["es", "ecma"], "application/emma+xml": ["emma"], "application/emotionml+xml": ["emotionml"], "application/epub+zip": ["epub"], "application/exi": ["exi"], "application/express": ["exp"], "application/fdt+xml": ["fdt"], "application/font-tdpfr": ["pfr"], "application/geo+json": ["geojson"], "application/gml+xml": ["gml"], "application/gpx+xml": ["gpx"], "application/gxf": ["gxf"], "application/gzip": ["gz"], "application/hjson": ["hjson"], "application/hyperstudio": ["stk"], "application/inkml+xml": ["ink", "inkml"], "application/ipfix": ["ipfix"], "application/its+xml": ["its"], "application/java-archive": ["jar", "war", "ear"], "application/java-serialized-object": ["ser"], "application/java-vm": ["class"], "application/javascript": ["js", "mjs"], "application/json": ["json", "map"], "application/json5": ["json5"], "application/jsonml+json": ["jsonml"], "application/ld+json": ["jsonld"], "application/lgr+xml": ["lgr"], "application/lost+xml": ["lostxml"], "application/mac-binhex40": ["hqx"], "application/mac-compactpro": ["cpt"], "application/mads+xml": ["mads"], "application/manifest+json": ["webmanifest"], "application/marc": ["mrc"], "application/marcxml+xml": ["mrcx"], "application/mathematica": ["ma", "nb", "mb"], "application/mathml+xml": ["mathml"], "application/mbox": ["mbox"], "application/mediaservercontrol+xml": ["mscml"], "application/metalink+xml": ["metalink"], "application/metalink4+xml": ["meta4"], "application/mets+xml": ["mets"], "application/mmt-aei+xml": ["maei"], "application/mmt-usd+xml": ["musd"], "application/mods+xml": ["mods"], "application/mp21": ["m21", "mp21"], "application/mp4": ["mp4s", "m4p"], "application/msword": ["doc", "dot"], "application/mxf": ["mxf"], "application/n-quads": ["nq"], "application/n-triples": ["nt"], "application/node": ["cjs"], "application/octet-stream": ["bin", "dms", "lrf", "mar", "so", "dist", "distz", "pkg", "bpk", "dump", "elc", "deploy", "exe", "dll", "deb", "dmg", "iso", "img", "msi", "msp", "msm", "buffer"], "application/oda": ["oda"], "application/oebps-package+xml": ["opf"], "application/ogg": ["ogx"], "application/omdoc+xml": ["omdoc"], "application/onenote": ["onetoc", "onetoc2", "onetmp", "onepkg"], "application/oxps": ["oxps"], "application/p2p-overlay+xml": ["relo"], "application/patch-ops-error+xml": ["xer"], "application/pdf": ["pdf"], "application/pgp-encrypted": ["pgp"], "application/pgp-signature": ["asc", "sig"], "application/pics-rules": ["prf"], "application/pkcs10": ["p10"], "application/pkcs7-mime": ["p7m", "p7c"], "application/pkcs7-signature": ["p7s"], "application/pkcs8": ["p8"], "application/pkix-attr-cert": ["ac"], "application/pkix-cert": ["cer"], "application/pkix-crl": ["crl"], "application/pkix-pkipath": ["pkipath"], "application/pkixcmp": ["pki"], "application/pls+xml": ["pls"], "application/postscript": ["ai", "eps", "ps"], "application/provenance+xml": ["provx"], "application/pskc+xml": ["pskcxml"], "application/raml+yaml": ["raml"], "application/rdf+xml": ["rdf", "owl"], "application/reginfo+xml": ["rif"], "application/relax-ng-compact-syntax": ["rnc"], "application/resource-lists+xml": ["rl"], "application/resource-lists-diff+xml": ["rld"], "application/rls-services+xml": ["rs"], "application/route-apd+xml": ["rapd"], "application/route-s-tsid+xml": ["sls"], "application/route-usd+xml": ["rusd"], "application/rpki-ghostbusters": ["gbr"], "application/rpki-manifest": ["mft"], "application/rpki-roa": ["roa"], "application/rsd+xml": ["rsd"], "application/rss+xml": ["rss"], "application/rtf": ["rtf"], "application/sbml+xml": ["sbml"], "application/scvp-cv-request": ["scq"], "application/scvp-cv-response": ["scs"], "application/scvp-vp-request": ["spq"], "application/scvp-vp-response": ["spp"], "application/sdp": ["sdp"], "application/senml+xml": ["senmlx"], "application/sensml+xml": ["sensmlx"], "application/set-payment-initiation": ["setpay"], "application/set-registration-initiation": ["setreg"], "application/shf+xml": ["shf"], "application/sieve": ["siv", "sieve"], "application/smil+xml": ["smi", "smil"], "application/sparql-query": ["rq"], "application/sparql-results+xml": ["srx"], "application/srgs": ["gram"], "application/srgs+xml": ["grxml"], "application/sru+xml": ["sru"], "application/ssdl+xml": ["ssdl"], "application/ssml+xml": ["ssml"], "application/swid+xml": ["swidtag"], "application/tei+xml": ["tei", "teicorpus"], "application/thraud+xml": ["tfi"], "application/timestamped-data": ["tsd"], "application/toml": ["toml"], "application/trig": ["trig"], "application/ttml+xml": ["ttml"], "application/ubjson": ["ubj"], "application/urc-ressheet+xml": ["rsheet"], "application/urc-targetdesc+xml": ["td"], "application/voicexml+xml": ["vxml"], "application/wasm": ["wasm"], "application/widget": ["wgt"], "application/winhlp": ["hlp"], "application/wsdl+xml": ["wsdl"], "application/wspolicy+xml": ["wspolicy"], "application/xaml+xml": ["xaml"], "application/xcap-att+xml": ["xav"], "application/xcap-caps+xml": ["xca"], "application/xcap-diff+xml": ["xdf"], "application/xcap-el+xml": ["xel"], "application/xcap-ns+xml": ["xns"], "application/xenc+xml": ["xenc"], "application/xhtml+xml": ["xhtml", "xht"], "application/xliff+xml": ["xlf"], "application/xml": ["xml", "xsl", "xsd", "rng"], "application/xml-dtd": ["dtd"], "application/xop+xml": ["xop"], "application/xproc+xml": ["xpl"], "application/xslt+xml": ["*xsl", "xslt"], "application/xspf+xml": ["xspf"], "application/xv+xml": ["mxml", "xhvml", "xvml", "xvm"], "application/yang": ["yang"], "application/yin+xml": ["yin"], "application/zip": ["zip"], "audio/3gpp": ["*3gpp"], "audio/adpcm": ["adp"], "audio/amr": ["amr"], "audio/basic": ["au", "snd"], "audio/midi": ["mid", "midi", "kar", "rmi"], "audio/mobile-xmf": ["mxmf"], "audio/mp3": ["*mp3"], "audio/mp4": ["m4a", "mp4a"], "audio/mpeg": ["mpga", "mp2", "mp2a", "mp3", "m2a", "m3a"], "audio/ogg": ["oga", "ogg", "spx", "opus"], "audio/s3m": ["s3m"], "audio/silk": ["sil"], "audio/wav": ["wav"], "audio/wave": ["*wav"], "audio/webm": ["weba"], "audio/xm": ["xm"], "font/collection": ["ttc"], "font/otf": ["otf"], "font/ttf": ["ttf"], "font/woff": ["woff"], "font/woff2": ["woff2"], "image/aces": ["exr"], "image/apng": ["apng"], "image/avif": ["avif"], "image/bmp": ["bmp"], "image/cgm": ["cgm"], "image/dicom-rle": ["drle"], "image/emf": ["emf"], "image/fits": ["fits"], "image/g3fax": ["g3"], "image/gif": ["gif"], "image/heic": ["heic"], "image/heic-sequence": ["heics"], "image/heif": ["heif"], "image/heif-sequence": ["heifs"], "image/hej2k": ["hej2"], "image/hsj2": ["hsj2"], "image/ief": ["ief"], "image/jls": ["jls"], "image/jp2": ["jp2", "jpg2"], "image/jpeg": ["jpeg", "jpg", "jpe"], "image/jph": ["jph"], "image/jphc": ["jhc"], "image/jpm": ["jpm"], "image/jpx": ["jpx", "jpf"], "image/jxr": ["jxr"], "image/jxra": ["jxra"], "image/jxrs": ["jxrs"], "image/jxs": ["jxs"], "image/jxsc": ["jxsc"], "image/jxsi": ["jxsi"], "image/jxss": ["jxss"], "image/ktx": ["ktx"], "image/ktx2": ["ktx2"], "image/png": ["png"], "image/sgi": ["sgi"], "image/svg+xml": ["svg", "svgz"], "image/t38": ["t38"], "image/tiff": ["tif", "tiff"], "image/tiff-fx": ["tfx"], "image/webp": ["webp"], "image/wmf": ["wmf"], "message/disposition-notification": ["disposition-notification"], "message/global": ["u8msg"], "message/global-delivery-status": ["u8dsn"], "message/global-disposition-notification": ["u8mdn"], "message/global-headers": ["u8hdr"], "message/rfc822": ["eml", "mime"], "model/3mf": ["3mf"], "model/gltf+json": ["gltf"], "model/gltf-binary": ["glb"], "model/iges": ["igs", "iges"], "model/mesh": ["msh", "mesh", "silo"], "model/mtl": ["mtl"], "model/obj": ["obj"], "model/step+xml": ["stpx"], "model/step+zip": ["stpz"], "model/step-xml+zip": ["stpxz"], "model/stl": ["stl"], "model/vrml": ["wrl", "vrml"], "model/x3d+binary": ["*x3db", "x3dbz"], "model/x3d+fastinfoset": ["x3db"], "model/x3d+vrml": ["*x3dv", "x3dvz"], "model/x3d+xml": ["x3d", "x3dz"], "model/x3d-vrml": ["x3dv"], "text/cache-manifest": ["appcache", "manifest"], "text/calendar": ["ics", "ifb"], "text/coffeescript": ["coffee", "litcoffee"], "text/css": ["css"], "text/csv": ["csv"], "text/html": ["html", "htm", "shtml"], "text/jade": ["jade"], "text/jsx": ["jsx"], "text/less": ["less"], "text/markdown": ["markdown", "md"], "text/mathml": ["mml"], "text/mdx": ["mdx"], "text/n3": ["n3"], "text/plain": ["txt", "text", "conf", "def", "list", "log", "in", "ini"], "text/richtext": ["rtx"], "text/rtf": ["*rtf"], "text/sgml": ["sgml", "sgm"], "text/shex": ["shex"], "text/slim": ["slim", "slm"], "text/spdx": ["spdx"], "text/stylus": ["stylus", "styl"], "text/tab-separated-values": ["tsv"], "text/troff": ["t", "tr", "roff", "man", "me", "ms"], "text/turtle": ["ttl"], "text/uri-list": ["uri", "uris", "urls"], "text/vcard": ["vcard"], "text/vtt": ["vtt"], "text/xml": ["*xml"], "text/yaml": ["yaml", "yml"], "video/3gpp": ["3gp", "3gpp"], "video/3gpp2": ["3g2"], "video/h261": ["h261"], "video/h263": ["h263"], "video/h264": ["h264"], "video/iso.segment": ["m4s"], "video/jpeg": ["jpgv"], "video/jpm": ["*jpm", "jpgm"], "video/mj2": ["mj2", "mjp2"], "video/mp2t": ["ts"], "video/mp4": ["mp4", "mp4v", "mpg4"], "video/mpeg": ["mpeg", "mpg", "mpe", "m1v", "m2v"], "video/ogg": ["ogv"], "video/quicktime": ["qt", "mov"], "video/webm": ["webm"] };
  }
});

// ../../node_modules/mime/types/other.js
var require_other = __commonJS({
  "../../node_modules/mime/types/other.js"(exports2, module2) {
    module2.exports = { "application/prs.cww": ["cww"], "application/vnd.1000minds.decision-model+xml": ["1km"], "application/vnd.3gpp.pic-bw-large": ["plb"], "application/vnd.3gpp.pic-bw-small": ["psb"], "application/vnd.3gpp.pic-bw-var": ["pvb"], "application/vnd.3gpp2.tcap": ["tcap"], "application/vnd.3m.post-it-notes": ["pwn"], "application/vnd.accpac.simply.aso": ["aso"], "application/vnd.accpac.simply.imp": ["imp"], "application/vnd.acucobol": ["acu"], "application/vnd.acucorp": ["atc", "acutc"], "application/vnd.adobe.air-application-installer-package+zip": ["air"], "application/vnd.adobe.formscentral.fcdt": ["fcdt"], "application/vnd.adobe.fxp": ["fxp", "fxpl"], "application/vnd.adobe.xdp+xml": ["xdp"], "application/vnd.adobe.xfdf": ["xfdf"], "application/vnd.ahead.space": ["ahead"], "application/vnd.airzip.filesecure.azf": ["azf"], "application/vnd.airzip.filesecure.azs": ["azs"], "application/vnd.amazon.ebook": ["azw"], "application/vnd.americandynamics.acc": ["acc"], "application/vnd.amiga.ami": ["ami"], "application/vnd.android.package-archive": ["apk"], "application/vnd.anser-web-certificate-issue-initiation": ["cii"], "application/vnd.anser-web-funds-transfer-initiation": ["fti"], "application/vnd.antix.game-component": ["atx"], "application/vnd.apple.installer+xml": ["mpkg"], "application/vnd.apple.keynote": ["key"], "application/vnd.apple.mpegurl": ["m3u8"], "application/vnd.apple.numbers": ["numbers"], "application/vnd.apple.pages": ["pages"], "application/vnd.apple.pkpass": ["pkpass"], "application/vnd.aristanetworks.swi": ["swi"], "application/vnd.astraea-software.iota": ["iota"], "application/vnd.audiograph": ["aep"], "application/vnd.balsamiq.bmml+xml": ["bmml"], "application/vnd.blueice.multipass": ["mpm"], "application/vnd.bmi": ["bmi"], "application/vnd.businessobjects": ["rep"], "application/vnd.chemdraw+xml": ["cdxml"], "application/vnd.chipnuts.karaoke-mmd": ["mmd"], "application/vnd.cinderella": ["cdy"], "application/vnd.citationstyles.style+xml": ["csl"], "application/vnd.claymore": ["cla"], "application/vnd.cloanto.rp9": ["rp9"], "application/vnd.clonk.c4group": ["c4g", "c4d", "c4f", "c4p", "c4u"], "application/vnd.cluetrust.cartomobile-config": ["c11amc"], "application/vnd.cluetrust.cartomobile-config-pkg": ["c11amz"], "application/vnd.commonspace": ["csp"], "application/vnd.contact.cmsg": ["cdbcmsg"], "application/vnd.cosmocaller": ["cmc"], "application/vnd.crick.clicker": ["clkx"], "application/vnd.crick.clicker.keyboard": ["clkk"], "application/vnd.crick.clicker.palette": ["clkp"], "application/vnd.crick.clicker.template": ["clkt"], "application/vnd.crick.clicker.wordbank": ["clkw"], "application/vnd.criticaltools.wbs+xml": ["wbs"], "application/vnd.ctc-posml": ["pml"], "application/vnd.cups-ppd": ["ppd"], "application/vnd.curl.car": ["car"], "application/vnd.curl.pcurl": ["pcurl"], "application/vnd.dart": ["dart"], "application/vnd.data-vision.rdz": ["rdz"], "application/vnd.dbf": ["dbf"], "application/vnd.dece.data": ["uvf", "uvvf", "uvd", "uvvd"], "application/vnd.dece.ttml+xml": ["uvt", "uvvt"], "application/vnd.dece.unspecified": ["uvx", "uvvx"], "application/vnd.dece.zip": ["uvz", "uvvz"], "application/vnd.denovo.fcselayout-link": ["fe_launch"], "application/vnd.dna": ["dna"], "application/vnd.dolby.mlp": ["mlp"], "application/vnd.dpgraph": ["dpg"], "application/vnd.dreamfactory": ["dfac"], "application/vnd.ds-keypoint": ["kpxx"], "application/vnd.dvb.ait": ["ait"], "application/vnd.dvb.service": ["svc"], "application/vnd.dynageo": ["geo"], "application/vnd.ecowin.chart": ["mag"], "application/vnd.enliven": ["nml"], "application/vnd.epson.esf": ["esf"], "application/vnd.epson.msf": ["msf"], "application/vnd.epson.quickanime": ["qam"], "application/vnd.epson.salt": ["slt"], "application/vnd.epson.ssf": ["ssf"], "application/vnd.eszigno3+xml": ["es3", "et3"], "application/vnd.ezpix-album": ["ez2"], "application/vnd.ezpix-package": ["ez3"], "application/vnd.fdf": ["fdf"], "application/vnd.fdsn.mseed": ["mseed"], "application/vnd.fdsn.seed": ["seed", "dataless"], "application/vnd.flographit": ["gph"], "application/vnd.fluxtime.clip": ["ftc"], "application/vnd.framemaker": ["fm", "frame", "maker", "book"], "application/vnd.frogans.fnc": ["fnc"], "application/vnd.frogans.ltf": ["ltf"], "application/vnd.fsc.weblaunch": ["fsc"], "application/vnd.fujitsu.oasys": ["oas"], "application/vnd.fujitsu.oasys2": ["oa2"], "application/vnd.fujitsu.oasys3": ["oa3"], "application/vnd.fujitsu.oasysgp": ["fg5"], "application/vnd.fujitsu.oasysprs": ["bh2"], "application/vnd.fujixerox.ddd": ["ddd"], "application/vnd.fujixerox.docuworks": ["xdw"], "application/vnd.fujixerox.docuworks.binder": ["xbd"], "application/vnd.fuzzysheet": ["fzs"], "application/vnd.genomatix.tuxedo": ["txd"], "application/vnd.geogebra.file": ["ggb"], "application/vnd.geogebra.tool": ["ggt"], "application/vnd.geometry-explorer": ["gex", "gre"], "application/vnd.geonext": ["gxt"], "application/vnd.geoplan": ["g2w"], "application/vnd.geospace": ["g3w"], "application/vnd.gmx": ["gmx"], "application/vnd.google-apps.document": ["gdoc"], "application/vnd.google-apps.presentation": ["gslides"], "application/vnd.google-apps.spreadsheet": ["gsheet"], "application/vnd.google-earth.kml+xml": ["kml"], "application/vnd.google-earth.kmz": ["kmz"], "application/vnd.grafeq": ["gqf", "gqs"], "application/vnd.groove-account": ["gac"], "application/vnd.groove-help": ["ghf"], "application/vnd.groove-identity-message": ["gim"], "application/vnd.groove-injector": ["grv"], "application/vnd.groove-tool-message": ["gtm"], "application/vnd.groove-tool-template": ["tpl"], "application/vnd.groove-vcard": ["vcg"], "application/vnd.hal+xml": ["hal"], "application/vnd.handheld-entertainment+xml": ["zmm"], "application/vnd.hbci": ["hbci"], "application/vnd.hhe.lesson-player": ["les"], "application/vnd.hp-hpgl": ["hpgl"], "application/vnd.hp-hpid": ["hpid"], "application/vnd.hp-hps": ["hps"], "application/vnd.hp-jlyt": ["jlt"], "application/vnd.hp-pcl": ["pcl"], "application/vnd.hp-pclxl": ["pclxl"], "application/vnd.hydrostatix.sof-data": ["sfd-hdstx"], "application/vnd.ibm.minipay": ["mpy"], "application/vnd.ibm.modcap": ["afp", "listafp", "list3820"], "application/vnd.ibm.rights-management": ["irm"], "application/vnd.ibm.secure-container": ["sc"], "application/vnd.iccprofile": ["icc", "icm"], "application/vnd.igloader": ["igl"], "application/vnd.immervision-ivp": ["ivp"], "application/vnd.immervision-ivu": ["ivu"], "application/vnd.insors.igm": ["igm"], "application/vnd.intercon.formnet": ["xpw", "xpx"], "application/vnd.intergeo": ["i2g"], "application/vnd.intu.qbo": ["qbo"], "application/vnd.intu.qfx": ["qfx"], "application/vnd.ipunplugged.rcprofile": ["rcprofile"], "application/vnd.irepository.package+xml": ["irp"], "application/vnd.is-xpr": ["xpr"], "application/vnd.isac.fcs": ["fcs"], "application/vnd.jam": ["jam"], "application/vnd.jcp.javame.midlet-rms": ["rms"], "application/vnd.jisp": ["jisp"], "application/vnd.joost.joda-archive": ["joda"], "application/vnd.kahootz": ["ktz", "ktr"], "application/vnd.kde.karbon": ["karbon"], "application/vnd.kde.kchart": ["chrt"], "application/vnd.kde.kformula": ["kfo"], "application/vnd.kde.kivio": ["flw"], "application/vnd.kde.kontour": ["kon"], "application/vnd.kde.kpresenter": ["kpr", "kpt"], "application/vnd.kde.kspread": ["ksp"], "application/vnd.kde.kword": ["kwd", "kwt"], "application/vnd.kenameaapp": ["htke"], "application/vnd.kidspiration": ["kia"], "application/vnd.kinar": ["kne", "knp"], "application/vnd.koan": ["skp", "skd", "skt", "skm"], "application/vnd.kodak-descriptor": ["sse"], "application/vnd.las.las+xml": ["lasxml"], "application/vnd.llamagraphics.life-balance.desktop": ["lbd"], "application/vnd.llamagraphics.life-balance.exchange+xml": ["lbe"], "application/vnd.lotus-1-2-3": ["123"], "application/vnd.lotus-approach": ["apr"], "application/vnd.lotus-freelance": ["pre"], "application/vnd.lotus-notes": ["nsf"], "application/vnd.lotus-organizer": ["org"], "application/vnd.lotus-screencam": ["scm"], "application/vnd.lotus-wordpro": ["lwp"], "application/vnd.macports.portpkg": ["portpkg"], "application/vnd.mapbox-vector-tile": ["mvt"], "application/vnd.mcd": ["mcd"], "application/vnd.medcalcdata": ["mc1"], "application/vnd.mediastation.cdkey": ["cdkey"], "application/vnd.mfer": ["mwf"], "application/vnd.mfmp": ["mfm"], "application/vnd.micrografx.flo": ["flo"], "application/vnd.micrografx.igx": ["igx"], "application/vnd.mif": ["mif"], "application/vnd.mobius.daf": ["daf"], "application/vnd.mobius.dis": ["dis"], "application/vnd.mobius.mbk": ["mbk"], "application/vnd.mobius.mqy": ["mqy"], "application/vnd.mobius.msl": ["msl"], "application/vnd.mobius.plc": ["plc"], "application/vnd.mobius.txf": ["txf"], "application/vnd.mophun.application": ["mpn"], "application/vnd.mophun.certificate": ["mpc"], "application/vnd.mozilla.xul+xml": ["xul"], "application/vnd.ms-artgalry": ["cil"], "application/vnd.ms-cab-compressed": ["cab"], "application/vnd.ms-excel": ["xls", "xlm", "xla", "xlc", "xlt", "xlw"], "application/vnd.ms-excel.addin.macroenabled.12": ["xlam"], "application/vnd.ms-excel.sheet.binary.macroenabled.12": ["xlsb"], "application/vnd.ms-excel.sheet.macroenabled.12": ["xlsm"], "application/vnd.ms-excel.template.macroenabled.12": ["xltm"], "application/vnd.ms-fontobject": ["eot"], "application/vnd.ms-htmlhelp": ["chm"], "application/vnd.ms-ims": ["ims"], "application/vnd.ms-lrm": ["lrm"], "application/vnd.ms-officetheme": ["thmx"], "application/vnd.ms-outlook": ["msg"], "application/vnd.ms-pki.seccat": ["cat"], "application/vnd.ms-pki.stl": ["*stl"], "application/vnd.ms-powerpoint": ["ppt", "pps", "pot"], "application/vnd.ms-powerpoint.addin.macroenabled.12": ["ppam"], "application/vnd.ms-powerpoint.presentation.macroenabled.12": ["pptm"], "application/vnd.ms-powerpoint.slide.macroenabled.12": ["sldm"], "application/vnd.ms-powerpoint.slideshow.macroenabled.12": ["ppsm"], "application/vnd.ms-powerpoint.template.macroenabled.12": ["potm"], "application/vnd.ms-project": ["mpp", "mpt"], "application/vnd.ms-word.document.macroenabled.12": ["docm"], "application/vnd.ms-word.template.macroenabled.12": ["dotm"], "application/vnd.ms-works": ["wps", "wks", "wcm", "wdb"], "application/vnd.ms-wpl": ["wpl"], "application/vnd.ms-xpsdocument": ["xps"], "application/vnd.mseq": ["mseq"], "application/vnd.musician": ["mus"], "application/vnd.muvee.style": ["msty"], "application/vnd.mynfc": ["taglet"], "application/vnd.neurolanguage.nlu": ["nlu"], "application/vnd.nitf": ["ntf", "nitf"], "application/vnd.noblenet-directory": ["nnd"], "application/vnd.noblenet-sealer": ["nns"], "application/vnd.noblenet-web": ["nnw"], "application/vnd.nokia.n-gage.ac+xml": ["*ac"], "application/vnd.nokia.n-gage.data": ["ngdat"], "application/vnd.nokia.n-gage.symbian.install": ["n-gage"], "application/vnd.nokia.radio-preset": ["rpst"], "application/vnd.nokia.radio-presets": ["rpss"], "application/vnd.novadigm.edm": ["edm"], "application/vnd.novadigm.edx": ["edx"], "application/vnd.novadigm.ext": ["ext"], "application/vnd.oasis.opendocument.chart": ["odc"], "application/vnd.oasis.opendocument.chart-template": ["otc"], "application/vnd.oasis.opendocument.database": ["odb"], "application/vnd.oasis.opendocument.formula": ["odf"], "application/vnd.oasis.opendocument.formula-template": ["odft"], "application/vnd.oasis.opendocument.graphics": ["odg"], "application/vnd.oasis.opendocument.graphics-template": ["otg"], "application/vnd.oasis.opendocument.image": ["odi"], "application/vnd.oasis.opendocument.image-template": ["oti"], "application/vnd.oasis.opendocument.presentation": ["odp"], "application/vnd.oasis.opendocument.presentation-template": ["otp"], "application/vnd.oasis.opendocument.spreadsheet": ["ods"], "application/vnd.oasis.opendocument.spreadsheet-template": ["ots"], "application/vnd.oasis.opendocument.text": ["odt"], "application/vnd.oasis.opendocument.text-master": ["odm"], "application/vnd.oasis.opendocument.text-template": ["ott"], "application/vnd.oasis.opendocument.text-web": ["oth"], "application/vnd.olpc-sugar": ["xo"], "application/vnd.oma.dd2+xml": ["dd2"], "application/vnd.openblox.game+xml": ["obgx"], "application/vnd.openofficeorg.extension": ["oxt"], "application/vnd.openstreetmap.data+xml": ["osm"], "application/vnd.openxmlformats-officedocument.presentationml.presentation": ["pptx"], "application/vnd.openxmlformats-officedocument.presentationml.slide": ["sldx"], "application/vnd.openxmlformats-officedocument.presentationml.slideshow": ["ppsx"], "application/vnd.openxmlformats-officedocument.presentationml.template": ["potx"], "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": ["xlsx"], "application/vnd.openxmlformats-officedocument.spreadsheetml.template": ["xltx"], "application/vnd.openxmlformats-officedocument.wordprocessingml.document": ["docx"], "application/vnd.openxmlformats-officedocument.wordprocessingml.template": ["dotx"], "application/vnd.osgeo.mapguide.package": ["mgp"], "application/vnd.osgi.dp": ["dp"], "application/vnd.osgi.subsystem": ["esa"], "application/vnd.palm": ["pdb", "pqa", "oprc"], "application/vnd.pawaafile": ["paw"], "application/vnd.pg.format": ["str"], "application/vnd.pg.osasli": ["ei6"], "application/vnd.picsel": ["efif"], "application/vnd.pmi.widget": ["wg"], "application/vnd.pocketlearn": ["plf"], "application/vnd.powerbuilder6": ["pbd"], "application/vnd.previewsystems.box": ["box"], "application/vnd.proteus.magazine": ["mgz"], "application/vnd.publishare-delta-tree": ["qps"], "application/vnd.pvi.ptid1": ["ptid"], "application/vnd.quark.quarkxpress": ["qxd", "qxt", "qwd", "qwt", "qxl", "qxb"], "application/vnd.rar": ["rar"], "application/vnd.realvnc.bed": ["bed"], "application/vnd.recordare.musicxml": ["mxl"], "application/vnd.recordare.musicxml+xml": ["musicxml"], "application/vnd.rig.cryptonote": ["cryptonote"], "application/vnd.rim.cod": ["cod"], "application/vnd.rn-realmedia": ["rm"], "application/vnd.rn-realmedia-vbr": ["rmvb"], "application/vnd.route66.link66+xml": ["link66"], "application/vnd.sailingtracker.track": ["st"], "application/vnd.seemail": ["see"], "application/vnd.sema": ["sema"], "application/vnd.semd": ["semd"], "application/vnd.semf": ["semf"], "application/vnd.shana.informed.formdata": ["ifm"], "application/vnd.shana.informed.formtemplate": ["itp"], "application/vnd.shana.informed.interchange": ["iif"], "application/vnd.shana.informed.package": ["ipk"], "application/vnd.simtech-mindmapper": ["twd", "twds"], "application/vnd.smaf": ["mmf"], "application/vnd.smart.teacher": ["teacher"], "application/vnd.software602.filler.form+xml": ["fo"], "application/vnd.solent.sdkm+xml": ["sdkm", "sdkd"], "application/vnd.spotfire.dxp": ["dxp"], "application/vnd.spotfire.sfs": ["sfs"], "application/vnd.stardivision.calc": ["sdc"], "application/vnd.stardivision.draw": ["sda"], "application/vnd.stardivision.impress": ["sdd"], "application/vnd.stardivision.math": ["smf"], "application/vnd.stardivision.writer": ["sdw", "vor"], "application/vnd.stardivision.writer-global": ["sgl"], "application/vnd.stepmania.package": ["smzip"], "application/vnd.stepmania.stepchart": ["sm"], "application/vnd.sun.wadl+xml": ["wadl"], "application/vnd.sun.xml.calc": ["sxc"], "application/vnd.sun.xml.calc.template": ["stc"], "application/vnd.sun.xml.draw": ["sxd"], "application/vnd.sun.xml.draw.template": ["std"], "application/vnd.sun.xml.impress": ["sxi"], "application/vnd.sun.xml.impress.template": ["sti"], "application/vnd.sun.xml.math": ["sxm"], "application/vnd.sun.xml.writer": ["sxw"], "application/vnd.sun.xml.writer.global": ["sxg"], "application/vnd.sun.xml.writer.template": ["stw"], "application/vnd.sus-calendar": ["sus", "susp"], "application/vnd.svd": ["svd"], "application/vnd.symbian.install": ["sis", "sisx"], "application/vnd.syncml+xml": ["xsm"], "application/vnd.syncml.dm+wbxml": ["bdm"], "application/vnd.syncml.dm+xml": ["xdm"], "application/vnd.syncml.dmddf+xml": ["ddf"], "application/vnd.tao.intent-module-archive": ["tao"], "application/vnd.tcpdump.pcap": ["pcap", "cap", "dmp"], "application/vnd.tmobile-livetv": ["tmo"], "application/vnd.trid.tpt": ["tpt"], "application/vnd.triscape.mxs": ["mxs"], "application/vnd.trueapp": ["tra"], "application/vnd.ufdl": ["ufd", "ufdl"], "application/vnd.uiq.theme": ["utz"], "application/vnd.umajin": ["umj"], "application/vnd.unity": ["unityweb"], "application/vnd.uoml+xml": ["uoml"], "application/vnd.vcx": ["vcx"], "application/vnd.visio": ["vsd", "vst", "vss", "vsw"], "application/vnd.visionary": ["vis"], "application/vnd.vsf": ["vsf"], "application/vnd.wap.wbxml": ["wbxml"], "application/vnd.wap.wmlc": ["wmlc"], "application/vnd.wap.wmlscriptc": ["wmlsc"], "application/vnd.webturbo": ["wtb"], "application/vnd.wolfram.player": ["nbp"], "application/vnd.wordperfect": ["wpd"], "application/vnd.wqd": ["wqd"], "application/vnd.wt.stf": ["stf"], "application/vnd.xara": ["xar"], "application/vnd.xfdl": ["xfdl"], "application/vnd.yamaha.hv-dic": ["hvd"], "application/vnd.yamaha.hv-script": ["hvs"], "application/vnd.yamaha.hv-voice": ["hvp"], "application/vnd.yamaha.openscoreformat": ["osf"], "application/vnd.yamaha.openscoreformat.osfpvg+xml": ["osfpvg"], "application/vnd.yamaha.smaf-audio": ["saf"], "application/vnd.yamaha.smaf-phrase": ["spf"], "application/vnd.yellowriver-custom-menu": ["cmp"], "application/vnd.zul": ["zir", "zirz"], "application/vnd.zzazz.deck+xml": ["zaz"], "application/x-7z-compressed": ["7z"], "application/x-abiword": ["abw"], "application/x-ace-compressed": ["ace"], "application/x-apple-diskimage": ["*dmg"], "application/x-arj": ["arj"], "application/x-authorware-bin": ["aab", "x32", "u32", "vox"], "application/x-authorware-map": ["aam"], "application/x-authorware-seg": ["aas"], "application/x-bcpio": ["bcpio"], "application/x-bdoc": ["*bdoc"], "application/x-bittorrent": ["torrent"], "application/x-blorb": ["blb", "blorb"], "application/x-bzip": ["bz"], "application/x-bzip2": ["bz2", "boz"], "application/x-cbr": ["cbr", "cba", "cbt", "cbz", "cb7"], "application/x-cdlink": ["vcd"], "application/x-cfs-compressed": ["cfs"], "application/x-chat": ["chat"], "application/x-chess-pgn": ["pgn"], "application/x-chrome-extension": ["crx"], "application/x-cocoa": ["cco"], "application/x-conference": ["nsc"], "application/x-cpio": ["cpio"], "application/x-csh": ["csh"], "application/x-debian-package": ["*deb", "udeb"], "application/x-dgc-compressed": ["dgc"], "application/x-director": ["dir", "dcr", "dxr", "cst", "cct", "cxt", "w3d", "fgd", "swa"], "application/x-doom": ["wad"], "application/x-dtbncx+xml": ["ncx"], "application/x-dtbook+xml": ["dtb"], "application/x-dtbresource+xml": ["res"], "application/x-dvi": ["dvi"], "application/x-envoy": ["evy"], "application/x-eva": ["eva"], "application/x-font-bdf": ["bdf"], "application/x-font-ghostscript": ["gsf"], "application/x-font-linux-psf": ["psf"], "application/x-font-pcf": ["pcf"], "application/x-font-snf": ["snf"], "application/x-font-type1": ["pfa", "pfb", "pfm", "afm"], "application/x-freearc": ["arc"], "application/x-futuresplash": ["spl"], "application/x-gca-compressed": ["gca"], "application/x-glulx": ["ulx"], "application/x-gnumeric": ["gnumeric"], "application/x-gramps-xml": ["gramps"], "application/x-gtar": ["gtar"], "application/x-hdf": ["hdf"], "application/x-httpd-php": ["php"], "application/x-install-instructions": ["install"], "application/x-iso9660-image": ["*iso"], "application/x-iwork-keynote-sffkey": ["*key"], "application/x-iwork-numbers-sffnumbers": ["*numbers"], "application/x-iwork-pages-sffpages": ["*pages"], "application/x-java-archive-diff": ["jardiff"], "application/x-java-jnlp-file": ["jnlp"], "application/x-keepass2": ["kdbx"], "application/x-latex": ["latex"], "application/x-lua-bytecode": ["luac"], "application/x-lzh-compressed": ["lzh", "lha"], "application/x-makeself": ["run"], "application/x-mie": ["mie"], "application/x-mobipocket-ebook": ["prc", "mobi"], "application/x-ms-application": ["application"], "application/x-ms-shortcut": ["lnk"], "application/x-ms-wmd": ["wmd"], "application/x-ms-wmz": ["wmz"], "application/x-ms-xbap": ["xbap"], "application/x-msaccess": ["mdb"], "application/x-msbinder": ["obd"], "application/x-mscardfile": ["crd"], "application/x-msclip": ["clp"], "application/x-msdos-program": ["*exe"], "application/x-msdownload": ["*exe", "*dll", "com", "bat", "*msi"], "application/x-msmediaview": ["mvb", "m13", "m14"], "application/x-msmetafile": ["*wmf", "*wmz", "*emf", "emz"], "application/x-msmoney": ["mny"], "application/x-mspublisher": ["pub"], "application/x-msschedule": ["scd"], "application/x-msterminal": ["trm"], "application/x-mswrite": ["wri"], "application/x-netcdf": ["nc", "cdf"], "application/x-ns-proxy-autoconfig": ["pac"], "application/x-nzb": ["nzb"], "application/x-perl": ["pl", "pm"], "application/x-pilot": ["*prc", "*pdb"], "application/x-pkcs12": ["p12", "pfx"], "application/x-pkcs7-certificates": ["p7b", "spc"], "application/x-pkcs7-certreqresp": ["p7r"], "application/x-rar-compressed": ["*rar"], "application/x-redhat-package-manager": ["rpm"], "application/x-research-info-systems": ["ris"], "application/x-sea": ["sea"], "application/x-sh": ["sh"], "application/x-shar": ["shar"], "application/x-shockwave-flash": ["swf"], "application/x-silverlight-app": ["xap"], "application/x-sql": ["sql"], "application/x-stuffit": ["sit"], "application/x-stuffitx": ["sitx"], "application/x-subrip": ["srt"], "application/x-sv4cpio": ["sv4cpio"], "application/x-sv4crc": ["sv4crc"], "application/x-t3vm-image": ["t3"], "application/x-tads": ["gam"], "application/x-tar": ["tar"], "application/x-tcl": ["tcl", "tk"], "application/x-tex": ["tex"], "application/x-tex-tfm": ["tfm"], "application/x-texinfo": ["texinfo", "texi"], "application/x-tgif": ["*obj"], "application/x-ustar": ["ustar"], "application/x-virtualbox-hdd": ["hdd"], "application/x-virtualbox-ova": ["ova"], "application/x-virtualbox-ovf": ["ovf"], "application/x-virtualbox-vbox": ["vbox"], "application/x-virtualbox-vbox-extpack": ["vbox-extpack"], "application/x-virtualbox-vdi": ["vdi"], "application/x-virtualbox-vhd": ["vhd"], "application/x-virtualbox-vmdk": ["vmdk"], "application/x-wais-source": ["src"], "application/x-web-app-manifest+json": ["webapp"], "application/x-x509-ca-cert": ["der", "crt", "pem"], "application/x-xfig": ["fig"], "application/x-xliff+xml": ["*xlf"], "application/x-xpinstall": ["xpi"], "application/x-xz": ["xz"], "application/x-zmachine": ["z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8"], "audio/vnd.dece.audio": ["uva", "uvva"], "audio/vnd.digital-winds": ["eol"], "audio/vnd.dra": ["dra"], "audio/vnd.dts": ["dts"], "audio/vnd.dts.hd": ["dtshd"], "audio/vnd.lucent.voice": ["lvp"], "audio/vnd.ms-playready.media.pya": ["pya"], "audio/vnd.nuera.ecelp4800": ["ecelp4800"], "audio/vnd.nuera.ecelp7470": ["ecelp7470"], "audio/vnd.nuera.ecelp9600": ["ecelp9600"], "audio/vnd.rip": ["rip"], "audio/x-aac": ["aac"], "audio/x-aiff": ["aif", "aiff", "aifc"], "audio/x-caf": ["caf"], "audio/x-flac": ["flac"], "audio/x-m4a": ["*m4a"], "audio/x-matroska": ["mka"], "audio/x-mpegurl": ["m3u"], "audio/x-ms-wax": ["wax"], "audio/x-ms-wma": ["wma"], "audio/x-pn-realaudio": ["ram", "ra"], "audio/x-pn-realaudio-plugin": ["rmp"], "audio/x-realaudio": ["*ra"], "audio/x-wav": ["*wav"], "chemical/x-cdx": ["cdx"], "chemical/x-cif": ["cif"], "chemical/x-cmdf": ["cmdf"], "chemical/x-cml": ["cml"], "chemical/x-csml": ["csml"], "chemical/x-xyz": ["xyz"], "image/prs.btif": ["btif"], "image/prs.pti": ["pti"], "image/vnd.adobe.photoshop": ["psd"], "image/vnd.airzip.accelerator.azv": ["azv"], "image/vnd.dece.graphic": ["uvi", "uvvi", "uvg", "uvvg"], "image/vnd.djvu": ["djvu", "djv"], "image/vnd.dvb.subtitle": ["*sub"], "image/vnd.dwg": ["dwg"], "image/vnd.dxf": ["dxf"], "image/vnd.fastbidsheet": ["fbs"], "image/vnd.fpx": ["fpx"], "image/vnd.fst": ["fst"], "image/vnd.fujixerox.edmics-mmr": ["mmr"], "image/vnd.fujixerox.edmics-rlc": ["rlc"], "image/vnd.microsoft.icon": ["ico"], "image/vnd.ms-dds": ["dds"], "image/vnd.ms-modi": ["mdi"], "image/vnd.ms-photo": ["wdp"], "image/vnd.net-fpx": ["npx"], "image/vnd.pco.b16": ["b16"], "image/vnd.tencent.tap": ["tap"], "image/vnd.valve.source.texture": ["vtf"], "image/vnd.wap.wbmp": ["wbmp"], "image/vnd.xiff": ["xif"], "image/vnd.zbrush.pcx": ["pcx"], "image/x-3ds": ["3ds"], "image/x-cmu-raster": ["ras"], "image/x-cmx": ["cmx"], "image/x-freehand": ["fh", "fhc", "fh4", "fh5", "fh7"], "image/x-icon": ["*ico"], "image/x-jng": ["jng"], "image/x-mrsid-image": ["sid"], "image/x-ms-bmp": ["*bmp"], "image/x-pcx": ["*pcx"], "image/x-pict": ["pic", "pct"], "image/x-portable-anymap": ["pnm"], "image/x-portable-bitmap": ["pbm"], "image/x-portable-graymap": ["pgm"], "image/x-portable-pixmap": ["ppm"], "image/x-rgb": ["rgb"], "image/x-tga": ["tga"], "image/x-xbitmap": ["xbm"], "image/x-xpixmap": ["xpm"], "image/x-xwindowdump": ["xwd"], "message/vnd.wfa.wsc": ["wsc"], "model/vnd.collada+xml": ["dae"], "model/vnd.dwf": ["dwf"], "model/vnd.gdl": ["gdl"], "model/vnd.gtw": ["gtw"], "model/vnd.mts": ["mts"], "model/vnd.opengex": ["ogex"], "model/vnd.parasolid.transmit.binary": ["x_b"], "model/vnd.parasolid.transmit.text": ["x_t"], "model/vnd.sap.vds": ["vds"], "model/vnd.usdz+zip": ["usdz"], "model/vnd.valve.source.compiled-map": ["bsp"], "model/vnd.vtu": ["vtu"], "text/prs.lines.tag": ["dsc"], "text/vnd.curl": ["curl"], "text/vnd.curl.dcurl": ["dcurl"], "text/vnd.curl.mcurl": ["mcurl"], "text/vnd.curl.scurl": ["scurl"], "text/vnd.dvb.subtitle": ["sub"], "text/vnd.fly": ["fly"], "text/vnd.fmi.flexstor": ["flx"], "text/vnd.graphviz": ["gv"], "text/vnd.in3d.3dml": ["3dml"], "text/vnd.in3d.spot": ["spot"], "text/vnd.sun.j2me.app-descriptor": ["jad"], "text/vnd.wap.wml": ["wml"], "text/vnd.wap.wmlscript": ["wmls"], "text/x-asm": ["s", "asm"], "text/x-c": ["c", "cc", "cxx", "cpp", "h", "hh", "dic"], "text/x-component": ["htc"], "text/x-fortran": ["f", "for", "f77", "f90"], "text/x-handlebars-template": ["hbs"], "text/x-java-source": ["java"], "text/x-lua": ["lua"], "text/x-markdown": ["mkd"], "text/x-nfo": ["nfo"], "text/x-opml": ["opml"], "text/x-org": ["*org"], "text/x-pascal": ["p", "pas"], "text/x-processing": ["pde"], "text/x-sass": ["sass"], "text/x-scss": ["scss"], "text/x-setext": ["etx"], "text/x-sfv": ["sfv"], "text/x-suse-ymp": ["ymp"], "text/x-uuencode": ["uu"], "text/x-vcalendar": ["vcs"], "text/x-vcard": ["vcf"], "video/vnd.dece.hd": ["uvh", "uvvh"], "video/vnd.dece.mobile": ["uvm", "uvvm"], "video/vnd.dece.pd": ["uvp", "uvvp"], "video/vnd.dece.sd": ["uvs", "uvvs"], "video/vnd.dece.video": ["uvv", "uvvv"], "video/vnd.dvb.file": ["dvb"], "video/vnd.fvt": ["fvt"], "video/vnd.mpegurl": ["mxu", "m4u"], "video/vnd.ms-playready.media.pyv": ["pyv"], "video/vnd.uvvu.mp4": ["uvu", "uvvu"], "video/vnd.vivo": ["viv"], "video/x-f4v": ["f4v"], "video/x-fli": ["fli"], "video/x-flv": ["flv"], "video/x-m4v": ["m4v"], "video/x-matroska": ["mkv", "mk3d", "mks"], "video/x-mng": ["mng"], "video/x-ms-asf": ["asf", "asx"], "video/x-ms-vob": ["vob"], "video/x-ms-wm": ["wm"], "video/x-ms-wmv": ["wmv"], "video/x-ms-wmx": ["wmx"], "video/x-ms-wvx": ["wvx"], "video/x-msvideo": ["avi"], "video/x-sgi-movie": ["movie"], "video/x-smv": ["smv"], "x-conference/x-cooltalk": ["ice"] };
  }
});

// ../../node_modules/mime/index.js
var require_mime = __commonJS({
  "../../node_modules/mime/index.js"(exports2, module2) {
    "use strict";
    var Mime = require_Mime();
    module2.exports = new Mime(require_standard(), require_other());
  }
});

// ../../node_modules/@isaacs/balanced-match/dist/esm/index.js
var balanced, maybeMatch, range;
var init_esm = __esm({
  "../../node_modules/@isaacs/balanced-match/dist/esm/index.js"() {
    balanced = /* @__PURE__ */ __name((a13, b13, str) => {
      const ma = a13 instanceof RegExp ? maybeMatch(a13, str) : a13;
      const mb = b13 instanceof RegExp ? maybeMatch(b13, str) : b13;
      const r13 = ma !== null && mb != null && range(ma, mb, str);
      return r13 && {
        start: r13[0],
        end: r13[1],
        pre: str.slice(0, r13[0]),
        body: str.slice(r13[0] + ma.length, r13[1]),
        post: str.slice(r13[1] + mb.length)
      };
    }, "balanced");
    maybeMatch = /* @__PURE__ */ __name((reg, str) => {
      const m13 = str.match(reg);
      return m13 ? m13[0] : null;
    }, "maybeMatch");
    range = /* @__PURE__ */ __name((a13, b13, str) => {
      let begs, beg, left, right = void 0, result2;
      let ai = str.indexOf(a13);
      let bi = str.indexOf(b13, ai + 1);
      let i13 = ai;
      if (ai >= 0 && bi > 0) {
        if (a13 === b13) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i13 >= 0 && !result2) {
          if (i13 === ai) {
            begs.push(i13);
            ai = str.indexOf(a13, i13 + 1);
          } else if (begs.length === 1) {
            const r13 = begs.pop();
            if (r13 !== void 0)
              result2 = [r13, bi];
          } else {
            beg = begs.pop();
            if (beg !== void 0 && beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b13, i13 + 1);
          }
          i13 = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length && right !== void 0) {
          result2 = [left, right];
        }
      }
      return result2;
    }, "range");
  }
});

// ../../node_modules/@isaacs/brace-expansion/dist/esm/index.js
function numeric(str) {
  return !isNaN(str) ? parseInt(str, 10) : str.charCodeAt(0);
}
function escapeBraces(str) {
  return str.replace(slashPattern, escSlash).replace(openPattern, escOpen).replace(closePattern, escClose).replace(commaPattern, escComma).replace(periodPattern, escPeriod);
}
function unescapeBraces(str) {
  return str.replace(escSlashPattern, "\\").replace(escOpenPattern, "{").replace(escClosePattern, "}").replace(escCommaPattern, ",").replace(escPeriodPattern, ".");
}
function parseCommaParts(str) {
  if (!str) {
    return [""];
  }
  const parts = [];
  const m13 = balanced("{", "}", str);
  if (!m13) {
    return str.split(",");
  }
  const { pre, body, post } = m13;
  const p13 = pre.split(",");
  p13[p13.length - 1] += "{" + body + "}";
  const postParts = parseCommaParts(post);
  if (post.length) {
    ;
    p13[p13.length - 1] += postParts.shift();
    p13.push.apply(p13, postParts);
  }
  parts.push.apply(parts, p13);
  return parts;
}
function expand(str) {
  if (!str) {
    return [];
  }
  if (str.slice(0, 2) === "{}") {
    str = "\\{\\}" + str.slice(2);
  }
  return expand_(escapeBraces(str), true).map(unescapeBraces);
}
function embrace(str) {
  return "{" + str + "}";
}
function isPadded(el) {
  return /^-?0\d/.test(el);
}
function lte(i13, y5) {
  return i13 <= y5;
}
function gte(i13, y5) {
  return i13 >= y5;
}
function expand_(str, isTop) {
  const expansions = [];
  const m13 = balanced("{", "}", str);
  if (!m13)
    return [str];
  const pre = m13.pre;
  const post = m13.post.length ? expand_(m13.post, false) : [""];
  if (/\$$/.test(m13.pre)) {
    for (let k13 = 0; k13 < post.length; k13++) {
      const expansion = pre + "{" + m13.body + "}" + post[k13];
      expansions.push(expansion);
    }
  } else {
    const isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m13.body);
    const isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m13.body);
    const isSequence = isNumericSequence || isAlphaSequence;
    const isOptions = m13.body.indexOf(",") >= 0;
    if (!isSequence && !isOptions) {
      if (m13.post.match(/,(?!,).*\}/)) {
        str = m13.pre + "{" + m13.body + escClose + m13.post;
        return expand_(str);
      }
      return [str];
    }
    let n13;
    if (isSequence) {
      n13 = m13.body.split(/\.\./);
    } else {
      n13 = parseCommaParts(m13.body);
      if (n13.length === 1 && n13[0] !== void 0) {
        n13 = expand_(n13[0], false).map(embrace);
        if (n13.length === 1) {
          return post.map((p13) => m13.pre + n13[0] + p13);
        }
      }
    }
    let N;
    if (isSequence && n13[0] !== void 0 && n13[1] !== void 0) {
      const x13 = numeric(n13[0]);
      const y5 = numeric(n13[1]);
      const width = Math.max(n13[0].length, n13[1].length);
      let incr = n13.length === 3 && n13[2] !== void 0 ? Math.abs(numeric(n13[2])) : 1;
      let test = lte;
      const reverse = y5 < x13;
      if (reverse) {
        incr *= -1;
        test = gte;
      }
      const pad = n13.some(isPadded);
      N = [];
      for (let i13 = x13; test(i13, y5); i13 += incr) {
        let c13;
        if (isAlphaSequence) {
          c13 = String.fromCharCode(i13);
          if (c13 === "\\") {
            c13 = "";
          }
        } else {
          c13 = String(i13);
          if (pad) {
            const need = width - c13.length;
            if (need > 0) {
              const z5 = new Array(need + 1).join("0");
              if (i13 < 0) {
                c13 = "-" + z5 + c13.slice(1);
              } else {
                c13 = z5 + c13;
              }
            }
          }
        }
        N.push(c13);
      }
    } else {
      N = [];
      for (let j13 = 0; j13 < n13.length; j13++) {
        N.push.apply(N, expand_(n13[j13], false));
      }
    }
    for (let j13 = 0; j13 < N.length; j13++) {
      for (let k13 = 0; k13 < post.length; k13++) {
        const expansion = pre + N[j13] + post[k13];
        if (!isTop || isSequence || expansion) {
          expansions.push(expansion);
        }
      }
    }
  }
  return expansions;
}
var escSlash, escOpen, escClose, escComma, escPeriod, escSlashPattern, escOpenPattern, escClosePattern, escCommaPattern, escPeriodPattern, slashPattern, openPattern, closePattern, commaPattern, periodPattern;
var init_esm2 = __esm({
  "../../node_modules/@isaacs/brace-expansion/dist/esm/index.js"() {
    init_esm();
    escSlash = "\0SLASH" + Math.random() + "\0";
    escOpen = "\0OPEN" + Math.random() + "\0";
    escClose = "\0CLOSE" + Math.random() + "\0";
    escComma = "\0COMMA" + Math.random() + "\0";
    escPeriod = "\0PERIOD" + Math.random() + "\0";
    escSlashPattern = new RegExp(escSlash, "g");
    escOpenPattern = new RegExp(escOpen, "g");
    escClosePattern = new RegExp(escClose, "g");
    escCommaPattern = new RegExp(escComma, "g");
    escPeriodPattern = new RegExp(escPeriod, "g");
    slashPattern = /\\\\/g;
    openPattern = /\\{/g;
    closePattern = /\\}/g;
    commaPattern = /\\,/g;
    periodPattern = /\\./g;
    __name(numeric, "numeric");
    __name(escapeBraces, "escapeBraces");
    __name(unescapeBraces, "unescapeBraces");
    __name(parseCommaParts, "parseCommaParts");
    __name(expand, "expand");
    __name(embrace, "embrace");
    __name(isPadded, "isPadded");
    __name(lte, "lte");
    __name(gte, "gte");
    __name(expand_, "expand_");
  }
});

// ../../node_modules/minimatch/dist/esm/assert-valid-pattern.js
var MAX_PATTERN_LENGTH, assertValidPattern;
var init_assert_valid_pattern = __esm({
  "../../node_modules/minimatch/dist/esm/assert-valid-pattern.js"() {
    MAX_PATTERN_LENGTH = 1024 * 64;
    assertValidPattern = /* @__PURE__ */ __name((pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    }, "assertValidPattern");
  }
});

// ../../node_modules/minimatch/dist/esm/brace-expressions.js
var posixClasses, braceEscape, regexpEscape, rangesToString, parseClass;
var init_brace_expressions = __esm({
  "../../node_modules/minimatch/dist/esm/brace-expressions.js"() {
    posixClasses = {
      "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
      "[:alpha:]": ["\\p{L}\\p{Nl}", true],
      "[:ascii:]": ["\\x00-\\x7f", false],
      "[:blank:]": ["\\p{Zs}\\t", true],
      "[:cntrl:]": ["\\p{Cc}", true],
      "[:digit:]": ["\\p{Nd}", true],
      "[:graph:]": ["\\p{Z}\\p{C}", true, true],
      "[:lower:]": ["\\p{Ll}", true],
      "[:print:]": ["\\p{C}", true],
      "[:punct:]": ["\\p{P}", true],
      "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
      "[:upper:]": ["\\p{Lu}", true],
      "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
      "[:xdigit:]": ["A-Fa-f0-9", false]
    };
    braceEscape = /* @__PURE__ */ __name((s13) => s13.replace(/[[\]\\-]/g, "\\$&"), "braceEscape");
    regexpEscape = /* @__PURE__ */ __name((s13) => s13.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "regexpEscape");
    rangesToString = /* @__PURE__ */ __name((ranges) => ranges.join(""), "rangesToString");
    parseClass = /* @__PURE__ */ __name((glob2, position) => {
      const pos = position;
      if (glob2.charAt(pos) !== "[") {
        throw new Error("not in a brace expression");
      }
      const ranges = [];
      const negs = [];
      let i13 = pos + 1;
      let sawStart = false;
      let uflag = false;
      let escaping = false;
      let negate = false;
      let endPos = pos;
      let rangeStart = "";
      WHILE: while (i13 < glob2.length) {
        const c13 = glob2.charAt(i13);
        if ((c13 === "!" || c13 === "^") && i13 === pos + 1) {
          negate = true;
          i13++;
          continue;
        }
        if (c13 === "]" && sawStart && !escaping) {
          endPos = i13 + 1;
          break;
        }
        sawStart = true;
        if (c13 === "\\") {
          if (!escaping) {
            escaping = true;
            i13++;
            continue;
          }
        }
        if (c13 === "[" && !escaping) {
          for (const [cls, [unip, u13, neg]] of Object.entries(posixClasses)) {
            if (glob2.startsWith(cls, i13)) {
              if (rangeStart) {
                return ["$.", false, glob2.length - pos, true];
              }
              i13 += cls.length;
              if (neg)
                negs.push(unip);
              else
                ranges.push(unip);
              uflag = uflag || u13;
              continue WHILE;
            }
          }
        }
        escaping = false;
        if (rangeStart) {
          if (c13 > rangeStart) {
            ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c13));
          } else if (c13 === rangeStart) {
            ranges.push(braceEscape(c13));
          }
          rangeStart = "";
          i13++;
          continue;
        }
        if (glob2.startsWith("-]", i13 + 1)) {
          ranges.push(braceEscape(c13 + "-"));
          i13 += 2;
          continue;
        }
        if (glob2.startsWith("-", i13 + 1)) {
          rangeStart = c13;
          i13 += 2;
          continue;
        }
        ranges.push(braceEscape(c13));
        i13++;
      }
      if (endPos < i13) {
        return ["", false, 0, false];
      }
      if (!ranges.length && !negs.length) {
        return ["$.", false, glob2.length - pos, true];
      }
      if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
        const r13 = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r13), false, endPos - pos, false];
      }
      const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
      const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
      const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
      return [comb, uflag, endPos - pos, true];
    }, "parseClass");
  }
});

// ../../node_modules/minimatch/dist/esm/unescape.js
var unescape2;
var init_unescape = __esm({
  "../../node_modules/minimatch/dist/esm/unescape.js"() {
    unescape2 = /* @__PURE__ */ __name((s13, { windowsPathsNoEscape = false, magicalBraces = true } = {}) => {
      if (magicalBraces) {
        return windowsPathsNoEscape ? s13.replace(/\[([^\/\\])\]/g, "$1") : s13.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
      }
      return windowsPathsNoEscape ? s13.replace(/\[([^\/\\{}])\]/g, "$1") : s13.replace(/((?!\\).|^)\[([^\/\\{}])\]/g, "$1$2").replace(/\\([^\/{}])/g, "$1");
    }, "unescape");
  }
});

// ../../node_modules/minimatch/dist/esm/ast.js
var types, isExtglobType, startNoTraversal, startNoDot, addPatternStart, justDots, reSpecials, regExpEscape, qmark, star, starNoEmpty, AST;
var init_ast = __esm({
  "../../node_modules/minimatch/dist/esm/ast.js"() {
    init_brace_expressions();
    init_unescape();
    types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
    isExtglobType = /* @__PURE__ */ __name((c13) => types.has(c13), "isExtglobType");
    startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
    startNoDot = "(?!\\.)";
    addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
    justDots = /* @__PURE__ */ new Set(["..", "."]);
    reSpecials = new Set("().*{}+?[]^$\\!");
    regExpEscape = /* @__PURE__ */ __name((s13) => s13.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "regExpEscape");
    qmark = "[^/]";
    star = qmark + "*?";
    starNoEmpty = qmark + "+?";
    AST = class _AST {
      static {
        __name(this, "AST");
      }
      type;
      #root;
      #hasMagic;
      #uflag = false;
      #parts = [];
      #parent;
      #parentIndex;
      #negs;
      #filledNegs = false;
      #options;
      #toString;
      // set to true if it's an extglob with no children
      // (which really means one child of '')
      #emptyExt = false;
      constructor(type, parent, options = {}) {
        this.type = type;
        if (type)
          this.#hasMagic = true;
        this.#parent = parent;
        this.#root = this.#parent ? this.#parent.#root : this;
        this.#options = this.#root === this ? options : this.#root.#options;
        this.#negs = this.#root === this ? [] : this.#root.#negs;
        if (type === "!" && !this.#root.#filledNegs)
          this.#negs.push(this);
        this.#parentIndex = this.#parent ? this.#parent.#parts.length : 0;
      }
      get hasMagic() {
        if (this.#hasMagic !== void 0)
          return this.#hasMagic;
        for (const p13 of this.#parts) {
          if (typeof p13 === "string")
            continue;
          if (p13.type || p13.hasMagic)
            return this.#hasMagic = true;
        }
        return this.#hasMagic;
      }
      // reconstructs the pattern
      toString() {
        if (this.#toString !== void 0)
          return this.#toString;
        if (!this.type) {
          return this.#toString = this.#parts.map((p13) => String(p13)).join("");
        } else {
          return this.#toString = this.type + "(" + this.#parts.map((p13) => String(p13)).join("|") + ")";
        }
      }
      #fillNegs() {
        if (this !== this.#root)
          throw new Error("should only call on root");
        if (this.#filledNegs)
          return this;
        this.toString();
        this.#filledNegs = true;
        let n13;
        while (n13 = this.#negs.pop()) {
          if (n13.type !== "!")
            continue;
          let p13 = n13;
          let pp = p13.#parent;
          while (pp) {
            for (let i13 = p13.#parentIndex + 1; !pp.type && i13 < pp.#parts.length; i13++) {
              for (const part of n13.#parts) {
                if (typeof part === "string") {
                  throw new Error("string part in extglob AST??");
                }
                part.copyIn(pp.#parts[i13]);
              }
            }
            p13 = pp;
            pp = p13.#parent;
          }
        }
        return this;
      }
      push(...parts) {
        for (const p13 of parts) {
          if (p13 === "")
            continue;
          if (typeof p13 !== "string" && !(p13 instanceof _AST && p13.#parent === this)) {
            throw new Error("invalid part: " + p13);
          }
          this.#parts.push(p13);
        }
      }
      toJSON() {
        const ret = this.type === null ? this.#parts.slice().map((p13) => typeof p13 === "string" ? p13 : p13.toJSON()) : [this.type, ...this.#parts.map((p13) => p13.toJSON())];
        if (this.isStart() && !this.type)
          ret.unshift([]);
        if (this.isEnd() && (this === this.#root || this.#root.#filledNegs && this.#parent?.type === "!")) {
          ret.push({});
        }
        return ret;
      }
      isStart() {
        if (this.#root === this)
          return true;
        if (!this.#parent?.isStart())
          return false;
        if (this.#parentIndex === 0)
          return true;
        const p13 = this.#parent;
        for (let i13 = 0; i13 < this.#parentIndex; i13++) {
          const pp = p13.#parts[i13];
          if (!(pp instanceof _AST && pp.type === "!")) {
            return false;
          }
        }
        return true;
      }
      isEnd() {
        if (this.#root === this)
          return true;
        if (this.#parent?.type === "!")
          return true;
        if (!this.#parent?.isEnd())
          return false;
        if (!this.type)
          return this.#parent?.isEnd();
        const pl2 = this.#parent ? this.#parent.#parts.length : 0;
        return this.#parentIndex === pl2 - 1;
      }
      copyIn(part) {
        if (typeof part === "string")
          this.push(part);
        else
          this.push(part.clone(this));
      }
      clone(parent) {
        const c13 = new _AST(this.type, parent);
        for (const p13 of this.#parts) {
          c13.copyIn(p13);
        }
        return c13;
      }
      static #parseAST(str, ast, pos, opt) {
        let escaping = false;
        let inBrace = false;
        let braceStart = -1;
        let braceNeg = false;
        if (ast.type === null) {
          let i14 = pos;
          let acc2 = "";
          while (i14 < str.length) {
            const c13 = str.charAt(i14++);
            if (escaping || c13 === "\\") {
              escaping = !escaping;
              acc2 += c13;
              continue;
            }
            if (inBrace) {
              if (i14 === braceStart + 1) {
                if (c13 === "^" || c13 === "!") {
                  braceNeg = true;
                }
              } else if (c13 === "]" && !(i14 === braceStart + 2 && braceNeg)) {
                inBrace = false;
              }
              acc2 += c13;
              continue;
            } else if (c13 === "[") {
              inBrace = true;
              braceStart = i14;
              braceNeg = false;
              acc2 += c13;
              continue;
            }
            if (!opt.noext && isExtglobType(c13) && str.charAt(i14) === "(") {
              ast.push(acc2);
              acc2 = "";
              const ext4 = new _AST(c13, ast);
              i14 = _AST.#parseAST(str, ext4, i14, opt);
              ast.push(ext4);
              continue;
            }
            acc2 += c13;
          }
          ast.push(acc2);
          return i14;
        }
        let i13 = pos + 1;
        let part = new _AST(null, ast);
        const parts = [];
        let acc = "";
        while (i13 < str.length) {
          const c13 = str.charAt(i13++);
          if (escaping || c13 === "\\") {
            escaping = !escaping;
            acc += c13;
            continue;
          }
          if (inBrace) {
            if (i13 === braceStart + 1) {
              if (c13 === "^" || c13 === "!") {
                braceNeg = true;
              }
            } else if (c13 === "]" && !(i13 === braceStart + 2 && braceNeg)) {
              inBrace = false;
            }
            acc += c13;
            continue;
          } else if (c13 === "[") {
            inBrace = true;
            braceStart = i13;
            braceNeg = false;
            acc += c13;
            continue;
          }
          if (isExtglobType(c13) && str.charAt(i13) === "(") {
            part.push(acc);
            acc = "";
            const ext4 = new _AST(c13, part);
            part.push(ext4);
            i13 = _AST.#parseAST(str, ext4, i13, opt);
            continue;
          }
          if (c13 === "|") {
            part.push(acc);
            acc = "";
            parts.push(part);
            part = new _AST(null, ast);
            continue;
          }
          if (c13 === ")") {
            if (acc === "" && ast.#parts.length === 0) {
              ast.#emptyExt = true;
            }
            part.push(acc);
            acc = "";
            ast.push(...parts, part);
            return i13;
          }
          acc += c13;
        }
        ast.type = null;
        ast.#hasMagic = void 0;
        ast.#parts = [str.substring(pos - 1)];
        return i13;
      }
      static fromGlob(pattern, options = {}) {
        const ast = new _AST(null, void 0, options);
        _AST.#parseAST(pattern, ast, 0, options);
        return ast;
      }
      // returns the regular expression if there's magic, or the unescaped
      // string if not.
      toMMPattern() {
        if (this !== this.#root)
          return this.#root.toMMPattern();
        const glob2 = this.toString();
        const [re, body, hasMagic2, uflag] = this.toRegExpSource();
        const anyMagic = hasMagic2 || this.#hasMagic || this.#options.nocase && !this.#options.nocaseMagicOnly && glob2.toUpperCase() !== glob2.toLowerCase();
        if (!anyMagic) {
          return body;
        }
        const flags = (this.#options.nocase ? "i" : "") + (uflag ? "u" : "");
        return Object.assign(new RegExp(`^${re}$`, flags), {
          _src: re,
          _glob: glob2
        });
      }
      get options() {
        return this.#options;
      }
      // returns the string match, the regexp source, whether there's magic
      // in the regexp (so a regular expression is required) and whether or
      // not the uflag is needed for the regular expression (for posix classes)
      // TODO: instead of injecting the start/end at this point, just return
      // the BODY of the regexp, along with the start/end portions suitable
      // for binding the start/end in either a joined full-path makeRe context
      // (where we bind to (^|/), or a standalone matchPart context (where
      // we bind to ^, and not /).  Otherwise slashes get duped!
      //
      // In part-matching mode, the start is:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: ^(?!\.\.?$)
      // - if dots allowed or not possible: ^
      // - if dots possible and not allowed: ^(?!\.)
      // end is:
      // - if not isEnd(): nothing
      // - else: $
      //
      // In full-path matching mode, we put the slash at the START of the
      // pattern, so start is:
      // - if first pattern: same as part-matching mode
      // - if not isStart(): nothing
      // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
      // - if dots allowed or not possible: /
      // - if dots possible and not allowed: /(?!\.)
      // end is:
      // - if last pattern, same as part-matching mode
      // - else nothing
      //
      // Always put the (?:$|/) on negated tails, though, because that has to be
      // there to bind the end of the negated pattern portion, and it's easier to
      // just stick it in now rather than try to inject it later in the middle of
      // the pattern.
      //
      // We can just always return the same end, and leave it up to the caller
      // to know whether it's going to be used joined or in parts.
      // And, if the start is adjusted slightly, can do the same there:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
      // - if dots allowed or not possible: (?:/|^)
      // - if dots possible and not allowed: (?:/|^)(?!\.)
      //
      // But it's better to have a simpler binding without a conditional, for
      // performance, so probably better to return both start options.
      //
      // Then the caller just ignores the end if it's not the first pattern,
      // and the start always gets applied.
      //
      // But that's always going to be $ if it's the ending pattern, or nothing,
      // so the caller can just attach $ at the end of the pattern when building.
      //
      // So the todo is:
      // - better detect what kind of start is needed
      // - return both flavors of starting pattern
      // - attach $ at the end of the pattern when creating the actual RegExp
      //
      // Ah, but wait, no, that all only applies to the root when the first pattern
      // is not an extglob. If the first pattern IS an extglob, then we need all
      // that dot prevention biz to live in the extglob portions, because eg
      // +(*|.x*) can match .xy but not .yx.
      //
      // So, return the two flavors if it's #root and the first child is not an
      // AST, otherwise leave it to the child AST to handle it, and there,
      // use the (?:^|/) style of start binding.
      //
      // Even simplified further:
      // - Since the start for a join is eg /(?!\.) and the start for a part
      // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
      // or start or whatever) and prepend ^ or / at the Regexp construction.
      toRegExpSource(allowDot) {
        const dot = allowDot ?? !!this.#options.dot;
        if (this.#root === this)
          this.#fillNegs();
        if (!this.type) {
          const noEmpty = this.isStart() && this.isEnd() && !this.#parts.some((s13) => typeof s13 !== "string");
          const src = this.#parts.map((p13) => {
            const [re, _2, hasMagic2, uflag] = typeof p13 === "string" ? _AST.#parseGlob(p13, this.#hasMagic, noEmpty) : p13.toRegExpSource(allowDot);
            this.#hasMagic = this.#hasMagic || hasMagic2;
            this.#uflag = this.#uflag || uflag;
            return re;
          }).join("");
          let start2 = "";
          if (this.isStart()) {
            if (typeof this.#parts[0] === "string") {
              const dotTravAllowed = this.#parts.length === 1 && justDots.has(this.#parts[0]);
              if (!dotTravAllowed) {
                const aps = addPatternStart;
                const needNoTrav = (
                  // dots are allowed, and the pattern starts with [ or .
                  dot && aps.has(src.charAt(0)) || // the pattern starts with \., and then [ or .
                  src.startsWith("\\.") && aps.has(src.charAt(2)) || // the pattern starts with \.\., and then [ or .
                  src.startsWith("\\.\\.") && aps.has(src.charAt(4))
                );
                const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
              }
            }
          }
          let end = "";
          if (this.isEnd() && this.#root.#filledNegs && this.#parent?.type === "!") {
            end = "(?:$|\\/)";
          }
          const final2 = start2 + src + end;
          return [
            final2,
            unescape2(src),
            this.#hasMagic = !!this.#hasMagic,
            this.#uflag
          ];
        }
        const repeated = this.type === "*" || this.type === "+";
        const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
        let body = this.#partsToRegExp(dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
          const s13 = this.toString();
          this.#parts = [s13];
          this.type = null;
          this.#hasMagic = void 0;
          return [s13, unescape2(this.toString()), false, false];
        }
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : this.#partsToRegExp(true);
        if (bodyDotAllowed === body) {
          bodyDotAllowed = "";
        }
        if (bodyDotAllowed) {
          body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        let final = "";
        if (this.type === "!" && this.#emptyExt) {
          final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
        } else {
          const close = this.type === "!" ? (
            // !() must match something,but !(x) can match ''
            "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")"
          ) : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
          final = start + body + close;
        }
        return [
          final,
          unescape2(body),
          this.#hasMagic = !!this.#hasMagic,
          this.#uflag
        ];
      }
      #partsToRegExp(dot) {
        return this.#parts.map((p13) => {
          if (typeof p13 === "string") {
            throw new Error("string type in extglob ast??");
          }
          const [re, _2, _hasMagic, uflag] = p13.toRegExpSource(dot);
          this.#uflag = this.#uflag || uflag;
          return re;
        }).filter((p13) => !(this.isStart() && this.isEnd()) || !!p13).join("|");
      }
      static #parseGlob(glob2, hasMagic2, noEmpty = false) {
        let escaping = false;
        let re = "";
        let uflag = false;
        for (let i13 = 0; i13 < glob2.length; i13++) {
          const c13 = glob2.charAt(i13);
          if (escaping) {
            escaping = false;
            re += (reSpecials.has(c13) ? "\\" : "") + c13;
            continue;
          }
          if (c13 === "\\") {
            if (i13 === glob2.length - 1) {
              re += "\\\\";
            } else {
              escaping = true;
            }
            continue;
          }
          if (c13 === "[") {
            const [src, needUflag, consumed, magic] = parseClass(glob2, i13);
            if (consumed) {
              re += src;
              uflag = uflag || needUflag;
              i13 += consumed - 1;
              hasMagic2 = hasMagic2 || magic;
              continue;
            }
          }
          if (c13 === "*") {
            re += noEmpty && glob2 === "*" ? starNoEmpty : star;
            hasMagic2 = true;
            continue;
          }
          if (c13 === "?") {
            re += qmark;
            hasMagic2 = true;
            continue;
          }
          re += regExpEscape(c13);
        }
        return [re, unescape2(glob2), !!hasMagic2, uflag];
      }
    };
  }
});

// ../../node_modules/minimatch/dist/esm/escape.js
var escape;
var init_escape = __esm({
  "../../node_modules/minimatch/dist/esm/escape.js"() {
    escape = /* @__PURE__ */ __name((s13, { windowsPathsNoEscape = false, magicalBraces = false } = {}) => {
      if (magicalBraces) {
        return windowsPathsNoEscape ? s13.replace(/[?*()[\]{}]/g, "[$&]") : s13.replace(/[?*()[\]\\{}]/g, "\\$&");
      }
      return windowsPathsNoEscape ? s13.replace(/[?*()[\]]/g, "[$&]") : s13.replace(/[?*()[\]\\]/g, "\\$&");
    }, "escape");
  }
});

// ../../node_modules/minimatch/dist/esm/index.js
var minimatch, starDotExtRE, starDotExtTest, starDotExtTestDot, starDotExtTestNocase, starDotExtTestNocaseDot, starDotStarRE, starDotStarTest, starDotStarTestDot, dotStarRE, dotStarTest, starRE, starTest, starTestDot, qmarksRE, qmarksTestNocase, qmarksTestNocaseDot, qmarksTestDot, qmarksTest, qmarksTestNoExt, qmarksTestNoExtDot, defaultPlatform, path8, sep, GLOBSTAR, qmark2, star2, twoStarDot, twoStarNoDot, filter, ext, defaults, braceExpand, makeRe, match, globMagic, regExpEscape2, Minimatch;
var init_esm3 = __esm({
  "../../node_modules/minimatch/dist/esm/index.js"() {
    init_esm2();
    init_assert_valid_pattern();
    init_ast();
    init_escape();
    init_unescape();
    init_ast();
    init_escape();
    init_unescape();
    minimatch = /* @__PURE__ */ __name((p13, pattern, options = {}) => {
      assertValidPattern(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options).match(p13);
    }, "minimatch");
    starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
    starDotExtTest = /* @__PURE__ */ __name((ext4) => (f13) => !f13.startsWith(".") && f13.endsWith(ext4), "starDotExtTest");
    starDotExtTestDot = /* @__PURE__ */ __name((ext4) => (f13) => f13.endsWith(ext4), "starDotExtTestDot");
    starDotExtTestNocase = /* @__PURE__ */ __name((ext4) => {
      ext4 = ext4.toLowerCase();
      return (f13) => !f13.startsWith(".") && f13.toLowerCase().endsWith(ext4);
    }, "starDotExtTestNocase");
    starDotExtTestNocaseDot = /* @__PURE__ */ __name((ext4) => {
      ext4 = ext4.toLowerCase();
      return (f13) => f13.toLowerCase().endsWith(ext4);
    }, "starDotExtTestNocaseDot");
    starDotStarRE = /^\*+\.\*+$/;
    starDotStarTest = /* @__PURE__ */ __name((f13) => !f13.startsWith(".") && f13.includes("."), "starDotStarTest");
    starDotStarTestDot = /* @__PURE__ */ __name((f13) => f13 !== "." && f13 !== ".." && f13.includes("."), "starDotStarTestDot");
    dotStarRE = /^\.\*+$/;
    dotStarTest = /* @__PURE__ */ __name((f13) => f13 !== "." && f13 !== ".." && f13.startsWith("."), "dotStarTest");
    starRE = /^\*+$/;
    starTest = /* @__PURE__ */ __name((f13) => f13.length !== 0 && !f13.startsWith("."), "starTest");
    starTestDot = /* @__PURE__ */ __name((f13) => f13.length !== 0 && f13 !== "." && f13 !== "..", "starTestDot");
    qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
    qmarksTestNocase = /* @__PURE__ */ __name(([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      if (!ext4)
        return noext;
      ext4 = ext4.toLowerCase();
      return (f13) => noext(f13) && f13.toLowerCase().endsWith(ext4);
    }, "qmarksTestNocase");
    qmarksTestNocaseDot = /* @__PURE__ */ __name(([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      if (!ext4)
        return noext;
      ext4 = ext4.toLowerCase();
      return (f13) => noext(f13) && f13.toLowerCase().endsWith(ext4);
    }, "qmarksTestNocaseDot");
    qmarksTestDot = /* @__PURE__ */ __name(([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      return !ext4 ? noext : (f13) => noext(f13) && f13.endsWith(ext4);
    }, "qmarksTestDot");
    qmarksTest = /* @__PURE__ */ __name(([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      return !ext4 ? noext : (f13) => noext(f13) && f13.endsWith(ext4);
    }, "qmarksTest");
    qmarksTestNoExt = /* @__PURE__ */ __name(([$0]) => {
      const len = $0.length;
      return (f13) => f13.length === len && !f13.startsWith(".");
    }, "qmarksTestNoExt");
    qmarksTestNoExtDot = /* @__PURE__ */ __name(([$0]) => {
      const len = $0.length;
      return (f13) => f13.length === len && f13 !== "." && f13 !== "..";
    }, "qmarksTestNoExtDot");
    defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
    path8 = {
      win32: { sep: "\\" },
      posix: { sep: "/" }
    };
    sep = defaultPlatform === "win32" ? path8.win32.sep : path8.posix.sep;
    minimatch.sep = sep;
    GLOBSTAR = /* @__PURE__ */ Symbol("globstar **");
    minimatch.GLOBSTAR = GLOBSTAR;
    qmark2 = "[^/]";
    star2 = qmark2 + "*?";
    twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    filter = /* @__PURE__ */ __name((pattern, options = {}) => (p13) => minimatch(p13, pattern, options), "filter");
    minimatch.filter = filter;
    ext = /* @__PURE__ */ __name((a13, b13 = {}) => Object.assign({}, a13, b13), "ext");
    defaults = /* @__PURE__ */ __name((def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch;
      }
      const orig = minimatch;
      const m13 = /* @__PURE__ */ __name((p13, pattern, options = {}) => orig(p13, pattern, ext(def, options)), "m");
      return Object.assign(m13, {
        Minimatch: class Minimatch extends orig.Minimatch {
          static {
            __name(this, "Minimatch");
          }
          constructor(pattern, options = {}) {
            super(pattern, ext(def, options));
          }
          static defaults(options) {
            return orig.defaults(ext(def, options)).Minimatch;
          }
        },
        AST: class AST extends orig.AST {
          static {
            __name(this, "AST");
          }
          /* c8 ignore start */
          constructor(type, parent, options = {}) {
            super(type, parent, ext(def, options));
          }
          /* c8 ignore stop */
          static fromGlob(pattern, options = {}) {
            return orig.AST.fromGlob(pattern, ext(def, options));
          }
        },
        unescape: /* @__PURE__ */ __name((s13, options = {}) => orig.unescape(s13, ext(def, options)), "unescape"),
        escape: /* @__PURE__ */ __name((s13, options = {}) => orig.escape(s13, ext(def, options)), "escape"),
        filter: /* @__PURE__ */ __name((pattern, options = {}) => orig.filter(pattern, ext(def, options)), "filter"),
        defaults: /* @__PURE__ */ __name((options) => orig.defaults(ext(def, options)), "defaults"),
        makeRe: /* @__PURE__ */ __name((pattern, options = {}) => orig.makeRe(pattern, ext(def, options)), "makeRe"),
        braceExpand: /* @__PURE__ */ __name((pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)), "braceExpand"),
        match: /* @__PURE__ */ __name((list2, pattern, options = {}) => orig.match(list2, pattern, ext(def, options)), "match"),
        sep: orig.sep,
        GLOBSTAR
      });
    }, "defaults");
    minimatch.defaults = defaults;
    braceExpand = /* @__PURE__ */ __name((pattern, options = {}) => {
      assertValidPattern(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand(pattern);
    }, "braceExpand");
    minimatch.braceExpand = braceExpand;
    makeRe = /* @__PURE__ */ __name((pattern, options = {}) => new Minimatch(pattern, options).makeRe(), "makeRe");
    minimatch.makeRe = makeRe;
    match = /* @__PURE__ */ __name((list2, pattern, options = {}) => {
      const mm = new Minimatch(pattern, options);
      list2 = list2.filter((f13) => mm.match(f13));
      if (mm.options.nonull && !list2.length) {
        list2.push(pattern);
      }
      return list2;
    }, "match");
    minimatch.match = match;
    globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
    regExpEscape2 = /* @__PURE__ */ __name((s13) => s13.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "regExpEscape");
    Minimatch = class {
      static {
        __name(this, "Minimatch");
      }
      options;
      set;
      pattern;
      windowsPathsNoEscape;
      nonegate;
      negate;
      comment;
      empty;
      preserveMultipleSlashes;
      partial;
      globSet;
      globParts;
      nocase;
      isWindows;
      platform;
      windowsNoMagicRoot;
      regexp;
      constructor(pattern, options = {}) {
        assertValidPattern(pattern);
        options = options || {};
        this.options = options;
        this.pattern = pattern;
        this.platform = options.platform || defaultPlatform;
        this.isWindows = this.platform === "win32";
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
          return true;
        }
        for (const pattern of this.set) {
          for (const part of pattern) {
            if (typeof part !== "string")
              return true;
          }
        }
        return false;
      }
      debug(..._2) {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        this.globSet = [...new Set(this.braceExpand())];
        if (options.debug) {
          this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        const rawGlobParts = this.globSet.map((s13) => this.slashSplit(s13));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        let set = this.globParts.map((s13, _2, __) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const isUNC = s13[0] === "" && s13[1] === "" && (s13[2] === "?" || !globMagic.test(s13[2])) && !globMagic.test(s13[3]);
            const isDrive = /^[a-z]:/i.test(s13[0]);
            if (isUNC) {
              return [...s13.slice(0, 4), ...s13.slice(4).map((ss) => this.parse(ss))];
            } else if (isDrive) {
              return [s13[0], ...s13.slice(1).map((ss) => this.parse(ss))];
            }
          }
          return s13.map((ss) => this.parse(ss));
        });
        this.debug(this.pattern, set);
        this.set = set.filter((s13) => s13.indexOf(false) === -1);
        if (this.isWindows) {
          for (let i13 = 0; i13 < this.set.length; i13++) {
            const p13 = this.set[i13];
            if (p13[0] === "" && p13[1] === "" && this.globParts[i13][2] === "?" && typeof p13[3] === "string" && /^[a-z]:$/i.test(p13[3])) {
              p13[2] = "?";
            }
          }
        }
        this.debug(this.pattern, this.set);
      }
      // various transforms to equivalent pattern sets that are
      // faster to process in a filesystem walk.  The goal is to
      // eliminate what we can, and push all ** patterns as far
      // to the right as possible, even if it increases the number
      // of patterns that we have to process.
      preprocess(globParts) {
        if (this.options.noglobstar) {
          for (let i13 = 0; i13 < globParts.length; i13++) {
            for (let j13 = 0; j13 < globParts[i13].length; j13++) {
              if (globParts[i13][j13] === "**") {
                globParts[i13][j13] = "*";
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          globParts = this.firstPhasePreProcess(globParts);
          globParts = this.secondPhasePreProcess(globParts);
        } else if (optimizationLevel >= 1) {
          globParts = this.levelOneOptimize(globParts);
        } else {
          globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
      }
      // just get rid of adjascent ** portions
      adjascentGlobstarOptimize(globParts) {
        return globParts.map((parts) => {
          let gs = -1;
          while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
            let i13 = gs;
            while (parts[i13 + 1] === "**") {
              i13++;
            }
            if (i13 !== gs) {
              parts.splice(gs, i13 - gs);
            }
          }
          return parts;
        });
      }
      // get rid of adjascent ** and resolve .. portions
      levelOneOptimize(globParts) {
        return globParts.map((parts) => {
          parts = parts.reduce((set, part) => {
            const prev = set[set.length - 1];
            if (part === "**" && prev === "**") {
              return set;
            }
            if (part === "..") {
              if (prev && prev !== ".." && prev !== "." && prev !== "**") {
                set.pop();
                return set;
              }
            }
            set.push(part);
            return set;
          }, []);
          return parts.length === 0 ? [""] : parts;
        });
      }
      levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
          parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
          didSomething = false;
          if (!this.preserveMultipleSlashes) {
            for (let i13 = 1; i13 < parts.length - 1; i13++) {
              const p13 = parts[i13];
              if (i13 === 1 && p13 === "" && parts[0] === "")
                continue;
              if (p13 === "." || p13 === "") {
                didSomething = true;
                parts.splice(i13, 1);
                i13--;
              }
            }
            if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
              didSomething = true;
              parts.pop();
            }
          }
          let dd = 0;
          while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
            const p13 = parts[dd - 1];
            if (p13 && p13 !== "." && p13 !== ".." && p13 !== "**") {
              didSomething = true;
              parts.splice(dd - 1, 2);
              dd -= 2;
            }
          }
        } while (didSomething);
        return parts.length === 0 ? [""] : parts;
      }
      // First phase: single-pattern processing
      // <pre> is 1 or more portions
      // <rest> is 1 or more portions
      // <p> is any portion other than ., .., '', or **
      // <e> is . or ''
      //
      // **/.. is *brutal* for filesystem walking performance, because
      // it effectively resets the recursive walk each time it occurs,
      // and ** cannot be reduced out by a .. pattern part like a regexp
      // or most strings (other than .., ., and '') can be.
      //
      // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
      // <pre>/<e>/<rest> -> <pre>/<rest>
      // <pre>/<p>/../<rest> -> <pre>/<rest>
      // **/**/<rest> -> **/<rest>
      //
      // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
      // this WOULD be allowed if ** did follow symlinks, or * didn't
      firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
          didSomething = false;
          for (let parts of globParts) {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
              let gss = gs;
              while (parts[gss + 1] === "**") {
                gss++;
              }
              if (gss > gs) {
                parts.splice(gs + 1, gss - gs);
              }
              let next = parts[gs + 1];
              const p13 = parts[gs + 2];
              const p22 = parts[gs + 3];
              if (next !== "..")
                continue;
              if (!p13 || p13 === "." || p13 === ".." || !p22 || p22 === "." || p22 === "..") {
                continue;
              }
              didSomething = true;
              parts.splice(gs, 1);
              const other = parts.slice(0);
              other[gs] = "**";
              globParts.push(other);
              gs--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let i13 = 1; i13 < parts.length - 1; i13++) {
                const p13 = parts[i13];
                if (i13 === 1 && p13 === "" && parts[0] === "")
                  continue;
                if (p13 === "." || p13 === "") {
                  didSomething = true;
                  parts.splice(i13, 1);
                  i13--;
                }
              }
              if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
                didSomething = true;
                parts.pop();
              }
            }
            let dd = 0;
            while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
              const p13 = parts[dd - 1];
              if (p13 && p13 !== "." && p13 !== ".." && p13 !== "**") {
                didSomething = true;
                const needDot = dd === 1 && parts[dd + 1] === "**";
                const splin = needDot ? ["."] : [];
                parts.splice(dd - 1, 2, ...splin);
                if (parts.length === 0)
                  parts.push("");
                dd -= 2;
              }
            }
          }
        } while (didSomething);
        return globParts;
      }
      // second phase: multi-pattern dedupes
      // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
      // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
      // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
      //
      // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
      // ^-- not valid because ** doens't follow symlinks
      secondPhasePreProcess(globParts) {
        for (let i13 = 0; i13 < globParts.length - 1; i13++) {
          for (let j13 = i13 + 1; j13 < globParts.length; j13++) {
            const matched = this.partsMatch(globParts[i13], globParts[j13], !this.preserveMultipleSlashes);
            if (matched) {
              globParts[i13] = [];
              globParts[j13] = matched;
              break;
            }
          }
        }
        return globParts.filter((gs) => gs.length);
      }
      partsMatch(a13, b13, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result2 = [];
        let which = "";
        while (ai < a13.length && bi < b13.length) {
          if (a13[ai] === b13[bi]) {
            result2.push(which === "b" ? b13[bi] : a13[ai]);
            ai++;
            bi++;
          } else if (emptyGSMatch && a13[ai] === "**" && b13[bi] === a13[ai + 1]) {
            result2.push(a13[ai]);
            ai++;
          } else if (emptyGSMatch && b13[bi] === "**" && a13[ai] === b13[bi + 1]) {
            result2.push(b13[bi]);
            bi++;
          } else if (a13[ai] === "*" && b13[bi] && (this.options.dot || !b13[bi].startsWith(".")) && b13[bi] !== "**") {
            if (which === "b")
              return false;
            which = "a";
            result2.push(a13[ai]);
            ai++;
            bi++;
          } else if (b13[bi] === "*" && a13[ai] && (this.options.dot || !a13[ai].startsWith(".")) && a13[ai] !== "**") {
            if (which === "a")
              return false;
            which = "b";
            result2.push(b13[bi]);
            ai++;
            bi++;
          } else {
            return false;
          }
        }
        return a13.length === b13.length && result2;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i13 = 0; i13 < pattern.length && pattern.charAt(i13) === "!"; i13++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset)
          this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial = false) {
        const options = this.options;
        if (this.isWindows) {
          const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
          const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
          const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
          const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
          const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
          const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
          if (typeof fdi === "number" && typeof pdi === "number") {
            const [fd, pd] = [file[fdi], pattern[pdi]];
            if (fd.toLowerCase() === pd.toLowerCase()) {
              pattern[pdi] = fd;
              if (pdi > fdi) {
                pattern = pattern.slice(pdi);
              } else if (fdi > pdi) {
                file = file.slice(fdi);
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          file = this.levelTwoFileOptimize(file);
        }
        this.debug("matchOne", this, { file, pattern });
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl2 = pattern.length; fi < fl && pi < pl2; fi++, pi++) {
          this.debug("matchOne loop");
          var p13 = pattern[pi];
          var f13 = file[fi];
          this.debug(pattern, p13, f13);
          if (p13 === false) {
            return false;
          }
          if (p13 === GLOBSTAR) {
            this.debug("GLOBSTAR", [pattern, p13, f13]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl2) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                  return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) {
                return true;
              }
            }
            return false;
          }
          let hit;
          if (typeof p13 === "string") {
            hit = f13 === p13;
            this.debug("string match", p13, f13, hit);
          } else {
            hit = p13.test(f13);
            this.debug("pattern match", p13, f13, hit);
          }
          if (!hit)
            return false;
        }
        if (fi === fl && pi === pl2) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl2) {
          return fi === fl - 1 && file[fi] === "";
        } else {
          throw new Error("wtf?");
        }
      }
      braceExpand() {
        return braceExpand(this.pattern, this.options);
      }
      parse(pattern) {
        assertValidPattern(pattern);
        const options = this.options;
        if (pattern === "**")
          return GLOBSTAR;
        if (pattern === "")
          return "";
        let m13;
        let fastTest = null;
        if (m13 = pattern.match(starRE)) {
          fastTest = options.dot ? starTestDot : starTest;
        } else if (m13 = pattern.match(starDotExtRE)) {
          fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m13[1]);
        } else if (m13 = pattern.match(qmarksRE)) {
          fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m13);
        } else if (m13 = pattern.match(starDotStarRE)) {
          fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
        } else if (m13 = pattern.match(dotStarRE)) {
          fastTest = dotStarTest;
        }
        const re = AST.fromGlob(pattern, this.options).toMMPattern();
        if (fastTest && typeof re === "object") {
          Reflect.defineProperty(re, "test", { value: fastTest });
        }
        return re;
      }
      makeRe() {
        if (this.regexp || this.regexp === false)
          return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star2 : options.dot ? twoStarDot : twoStarNoDot;
        const flags = new Set(options.nocase ? ["i"] : []);
        let re = set.map((pattern) => {
          const pp = pattern.map((p13) => {
            if (p13 instanceof RegExp) {
              for (const f13 of p13.flags.split(""))
                flags.add(f13);
            }
            return typeof p13 === "string" ? regExpEscape2(p13) : p13 === GLOBSTAR ? GLOBSTAR : p13._src;
          });
          pp.forEach((p13, i13) => {
            const next = pp[i13 + 1];
            const prev = pp[i13 - 1];
            if (p13 !== GLOBSTAR || prev === GLOBSTAR) {
              return;
            }
            if (prev === void 0) {
              if (next !== void 0 && next !== GLOBSTAR) {
                pp[i13 + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
              } else {
                pp[i13] = twoStar;
              }
            } else if (next === void 0) {
              pp[i13 - 1] = prev + "(?:\\/|\\/" + twoStar + ")?";
            } else if (next !== GLOBSTAR) {
              pp[i13 - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
              pp[i13 + 1] = GLOBSTAR;
            }
          });
          const filtered = pp.filter((p13) => p13 !== GLOBSTAR);
          if (this.partial && filtered.length >= 1) {
            const prefixes = [];
            for (let i13 = 1; i13 <= filtered.length; i13++) {
              prefixes.push(filtered.slice(0, i13).join("/"));
            }
            return "(?:" + prefixes.join("|") + ")";
          }
          return filtered.join("/");
        }).join("|");
        const [open2, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
        re = "^" + open2 + re + close + "$";
        if (this.partial) {
          re = "^(?:\\/|" + open2 + re.slice(1, -1) + close + ")$";
        }
        if (this.negate)
          re = "^(?!" + re + ").+$";
        try {
          this.regexp = new RegExp(re, [...flags].join(""));
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(p13) {
        if (this.preserveMultipleSlashes) {
          return p13.split("/");
        } else if (this.isWindows && /^\/\/[^\/]+/.test(p13)) {
          return ["", ...p13.split(/\/+/)];
        } else {
          return p13.split(/\/+/);
        }
      }
      match(f13, partial = this.partial) {
        this.debug("match", f13, this.pattern);
        if (this.comment) {
          return false;
        }
        if (this.empty) {
          return f13 === "";
        }
        if (f13 === "/" && partial) {
          return true;
        }
        const options = this.options;
        if (this.isWindows) {
          f13 = f13.split("\\").join("/");
        }
        const ff = this.slashSplit(f13);
        this.debug(this.pattern, "split", ff);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename = ff[ff.length - 1];
        if (!filename) {
          for (let i13 = ff.length - 2; !filename && i13 >= 0; i13--) {
            filename = ff[i13];
          }
        }
        for (let i13 = 0; i13 < set.length; i13++) {
          const pattern = set[i13];
          let file = ff;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) {
              return true;
            }
            return !this.negate;
          }
        }
        if (options.flipNegate) {
          return false;
        }
        return this.negate;
      }
      static defaults(def) {
        return minimatch.defaults(def).Minimatch;
      }
    };
    minimatch.AST = AST;
    minimatch.Minimatch = Minimatch;
    minimatch.escape = escape;
    minimatch.unescape = unescape2;
  }
});

// ../../node_modules/lru-cache/dist/esm/index.js
var defaultPerf, warned, PROCESS, emitWarning, AC, AS, shouldWarn, isPosInt, getUintArray, ZeroArray, Stack, LRUCache;
var init_esm4 = __esm({
  "../../node_modules/lru-cache/dist/esm/index.js"() {
    defaultPerf = typeof performance === "object" && performance && typeof performance.now === "function" ? performance : Date;
    warned = /* @__PURE__ */ new Set();
    PROCESS = typeof process === "object" && !!process ? process : {};
    emitWarning = /* @__PURE__ */ __name((msg, type, code, fn) => {
      typeof PROCESS.emitWarning === "function" ? PROCESS.emitWarning(msg, type, code, fn) : console.error(`[${code}] ${type}: ${msg}`);
    }, "emitWarning");
    AC = globalThis.AbortController;
    AS = globalThis.AbortSignal;
    if (typeof AC === "undefined") {
      AS = class AbortSignal {
        static {
          __name(this, "AbortSignal");
        }
        onabort;
        _onabort = [];
        reason;
        aborted = false;
        addEventListener(_2, fn) {
          this._onabort.push(fn);
        }
      };
      AC = class AbortController {
        static {
          __name(this, "AbortController");
        }
        constructor() {
          warnACPolyfill();
        }
        signal = new AS();
        abort(reason) {
          if (this.signal.aborted)
            return;
          this.signal.reason = reason;
          this.signal.aborted = true;
          for (const fn of this.signal._onabort) {
            fn(reason);
          }
          this.signal.onabort?.(reason);
        }
      };
      let printACPolyfillWarning = PROCESS.env?.LRU_CACHE_IGNORE_AC_WARNING !== "1";
      const warnACPolyfill = /* @__PURE__ */ __name(() => {
        if (!printACPolyfillWarning)
          return;
        printACPolyfillWarning = false;
        emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.", "NO_ABORT_CONTROLLER", "ENOTSUP", warnACPolyfill);
      }, "warnACPolyfill");
    }
    shouldWarn = /* @__PURE__ */ __name((code) => !warned.has(code), "shouldWarn");
    isPosInt = /* @__PURE__ */ __name((n13) => n13 && n13 === Math.floor(n13) && n13 > 0 && isFinite(n13), "isPosInt");
    getUintArray = /* @__PURE__ */ __name((max) => !isPosInt(max) ? null : max <= Math.pow(2, 8) ? Uint8Array : max <= Math.pow(2, 16) ? Uint16Array : max <= Math.pow(2, 32) ? Uint32Array : max <= Number.MAX_SAFE_INTEGER ? ZeroArray : null, "getUintArray");
    ZeroArray = class extends Array {
      static {
        __name(this, "ZeroArray");
      }
      constructor(size) {
        super(size);
        this.fill(0);
      }
    };
    Stack = class _Stack {
      static {
        __name(this, "Stack");
      }
      heap;
      length;
      // private constructor
      static #constructing = false;
      static create(max) {
        const HeapCls = getUintArray(max);
        if (!HeapCls)
          return [];
        _Stack.#constructing = true;
        const s13 = new _Stack(max, HeapCls);
        _Stack.#constructing = false;
        return s13;
      }
      constructor(max, HeapCls) {
        if (!_Stack.#constructing) {
          throw new TypeError("instantiate Stack using Stack.create(n)");
        }
        this.heap = new HeapCls(max);
        this.length = 0;
      }
      push(n13) {
        this.heap[this.length++] = n13;
      }
      pop() {
        return this.heap[--this.length];
      }
    };
    LRUCache = class _LRUCache {
      static {
        __name(this, "LRUCache");
      }
      // options that cannot be changed without disaster
      #max;
      #maxSize;
      #dispose;
      #onInsert;
      #disposeAfter;
      #fetchMethod;
      #memoMethod;
      #perf;
      /**
       * {@link LRUCache.OptionsBase.perf}
       */
      get perf() {
        return this.#perf;
      }
      /**
       * {@link LRUCache.OptionsBase.ttl}
       */
      ttl;
      /**
       * {@link LRUCache.OptionsBase.ttlResolution}
       */
      ttlResolution;
      /**
       * {@link LRUCache.OptionsBase.ttlAutopurge}
       */
      ttlAutopurge;
      /**
       * {@link LRUCache.OptionsBase.updateAgeOnGet}
       */
      updateAgeOnGet;
      /**
       * {@link LRUCache.OptionsBase.updateAgeOnHas}
       */
      updateAgeOnHas;
      /**
       * {@link LRUCache.OptionsBase.allowStale}
       */
      allowStale;
      /**
       * {@link LRUCache.OptionsBase.noDisposeOnSet}
       */
      noDisposeOnSet;
      /**
       * {@link LRUCache.OptionsBase.noUpdateTTL}
       */
      noUpdateTTL;
      /**
       * {@link LRUCache.OptionsBase.maxEntrySize}
       */
      maxEntrySize;
      /**
       * {@link LRUCache.OptionsBase.sizeCalculation}
       */
      sizeCalculation;
      /**
       * {@link LRUCache.OptionsBase.noDeleteOnFetchRejection}
       */
      noDeleteOnFetchRejection;
      /**
       * {@link LRUCache.OptionsBase.noDeleteOnStaleGet}
       */
      noDeleteOnStaleGet;
      /**
       * {@link LRUCache.OptionsBase.allowStaleOnFetchAbort}
       */
      allowStaleOnFetchAbort;
      /**
       * {@link LRUCache.OptionsBase.allowStaleOnFetchRejection}
       */
      allowStaleOnFetchRejection;
      /**
       * {@link LRUCache.OptionsBase.ignoreFetchAbort}
       */
      ignoreFetchAbort;
      // computed properties
      #size;
      #calculatedSize;
      #keyMap;
      #keyList;
      #valList;
      #next;
      #prev;
      #head;
      #tail;
      #free;
      #disposed;
      #sizes;
      #starts;
      #ttls;
      #autopurgeTimers;
      #hasDispose;
      #hasFetchMethod;
      #hasDisposeAfter;
      #hasOnInsert;
      /**
       * Do not call this method unless you need to inspect the
       * inner workings of the cache.  If anything returned by this
       * object is modified in any way, strange breakage may occur.
       *
       * These fields are private for a reason!
       *
       * @internal
       */
      static unsafeExposeInternals(c13) {
        return {
          // properties
          starts: c13.#starts,
          ttls: c13.#ttls,
          autopurgeTimers: c13.#autopurgeTimers,
          sizes: c13.#sizes,
          keyMap: c13.#keyMap,
          keyList: c13.#keyList,
          valList: c13.#valList,
          next: c13.#next,
          prev: c13.#prev,
          get head() {
            return c13.#head;
          },
          get tail() {
            return c13.#tail;
          },
          free: c13.#free,
          // methods
          isBackgroundFetch: /* @__PURE__ */ __name((p13) => c13.#isBackgroundFetch(p13), "isBackgroundFetch"),
          backgroundFetch: /* @__PURE__ */ __name((k13, index, options, context) => c13.#backgroundFetch(k13, index, options, context), "backgroundFetch"),
          moveToTail: /* @__PURE__ */ __name((index) => c13.#moveToTail(index), "moveToTail"),
          indexes: /* @__PURE__ */ __name((options) => c13.#indexes(options), "indexes"),
          rindexes: /* @__PURE__ */ __name((options) => c13.#rindexes(options), "rindexes"),
          isStale: /* @__PURE__ */ __name((index) => c13.#isStale(index), "isStale")
        };
      }
      // Protected read-only members
      /**
       * {@link LRUCache.OptionsBase.max} (read-only)
       */
      get max() {
        return this.#max;
      }
      /**
       * {@link LRUCache.OptionsBase.maxSize} (read-only)
       */
      get maxSize() {
        return this.#maxSize;
      }
      /**
       * The total computed size of items in the cache (read-only)
       */
      get calculatedSize() {
        return this.#calculatedSize;
      }
      /**
       * The number of items stored in the cache (read-only)
       */
      get size() {
        return this.#size;
      }
      /**
       * {@link LRUCache.OptionsBase.fetchMethod} (read-only)
       */
      get fetchMethod() {
        return this.#fetchMethod;
      }
      get memoMethod() {
        return this.#memoMethod;
      }
      /**
       * {@link LRUCache.OptionsBase.dispose} (read-only)
       */
      get dispose() {
        return this.#dispose;
      }
      /**
       * {@link LRUCache.OptionsBase.onInsert} (read-only)
       */
      get onInsert() {
        return this.#onInsert;
      }
      /**
       * {@link LRUCache.OptionsBase.disposeAfter} (read-only)
       */
      get disposeAfter() {
        return this.#disposeAfter;
      }
      constructor(options) {
        const { max = 0, ttl, ttlResolution = 1, ttlAutopurge, updateAgeOnGet, updateAgeOnHas, allowStale, dispose, onInsert, disposeAfter, noDisposeOnSet, noUpdateTTL, maxSize = 0, maxEntrySize = 0, sizeCalculation, fetchMethod, memoMethod, noDeleteOnFetchRejection, noDeleteOnStaleGet, allowStaleOnFetchRejection, allowStaleOnFetchAbort, ignoreFetchAbort, perf } = options;
        if (perf !== void 0) {
          if (typeof perf?.now !== "function") {
            throw new TypeError("perf option must have a now() method if specified");
          }
        }
        this.#perf = perf ?? defaultPerf;
        if (max !== 0 && !isPosInt(max)) {
          throw new TypeError("max option must be a nonnegative integer");
        }
        const UintArray = max ? getUintArray(max) : Array;
        if (!UintArray) {
          throw new Error("invalid max value: " + max);
        }
        this.#max = max;
        this.#maxSize = maxSize;
        this.maxEntrySize = maxEntrySize || this.#maxSize;
        this.sizeCalculation = sizeCalculation;
        if (this.sizeCalculation) {
          if (!this.#maxSize && !this.maxEntrySize) {
            throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");
          }
          if (typeof this.sizeCalculation !== "function") {
            throw new TypeError("sizeCalculation set to non-function");
          }
        }
        if (memoMethod !== void 0 && typeof memoMethod !== "function") {
          throw new TypeError("memoMethod must be a function if defined");
        }
        this.#memoMethod = memoMethod;
        if (fetchMethod !== void 0 && typeof fetchMethod !== "function") {
          throw new TypeError("fetchMethod must be a function if specified");
        }
        this.#fetchMethod = fetchMethod;
        this.#hasFetchMethod = !!fetchMethod;
        this.#keyMap = /* @__PURE__ */ new Map();
        this.#keyList = new Array(max).fill(void 0);
        this.#valList = new Array(max).fill(void 0);
        this.#next = new UintArray(max);
        this.#prev = new UintArray(max);
        this.#head = 0;
        this.#tail = 0;
        this.#free = Stack.create(max);
        this.#size = 0;
        this.#calculatedSize = 0;
        if (typeof dispose === "function") {
          this.#dispose = dispose;
        }
        if (typeof onInsert === "function") {
          this.#onInsert = onInsert;
        }
        if (typeof disposeAfter === "function") {
          this.#disposeAfter = disposeAfter;
          this.#disposed = [];
        } else {
          this.#disposeAfter = void 0;
          this.#disposed = void 0;
        }
        this.#hasDispose = !!this.#dispose;
        this.#hasOnInsert = !!this.#onInsert;
        this.#hasDisposeAfter = !!this.#disposeAfter;
        this.noDisposeOnSet = !!noDisposeOnSet;
        this.noUpdateTTL = !!noUpdateTTL;
        this.noDeleteOnFetchRejection = !!noDeleteOnFetchRejection;
        this.allowStaleOnFetchRejection = !!allowStaleOnFetchRejection;
        this.allowStaleOnFetchAbort = !!allowStaleOnFetchAbort;
        this.ignoreFetchAbort = !!ignoreFetchAbort;
        if (this.maxEntrySize !== 0) {
          if (this.#maxSize !== 0) {
            if (!isPosInt(this.#maxSize)) {
              throw new TypeError("maxSize must be a positive integer if specified");
            }
          }
          if (!isPosInt(this.maxEntrySize)) {
            throw new TypeError("maxEntrySize must be a positive integer if specified");
          }
          this.#initializeSizeTracking();
        }
        this.allowStale = !!allowStale;
        this.noDeleteOnStaleGet = !!noDeleteOnStaleGet;
        this.updateAgeOnGet = !!updateAgeOnGet;
        this.updateAgeOnHas = !!updateAgeOnHas;
        this.ttlResolution = isPosInt(ttlResolution) || ttlResolution === 0 ? ttlResolution : 1;
        this.ttlAutopurge = !!ttlAutopurge;
        this.ttl = ttl || 0;
        if (this.ttl) {
          if (!isPosInt(this.ttl)) {
            throw new TypeError("ttl must be a positive integer if specified");
          }
          this.#initializeTTLTracking();
        }
        if (this.#max === 0 && this.ttl === 0 && this.#maxSize === 0) {
          throw new TypeError("At least one of max, maxSize, or ttl is required");
        }
        if (!this.ttlAutopurge && !this.#max && !this.#maxSize) {
          const code = "LRU_CACHE_UNBOUNDED";
          if (shouldWarn(code)) {
            warned.add(code);
            const msg = "TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.";
            emitWarning(msg, "UnboundedCacheWarning", code, _LRUCache);
          }
        }
      }
      /**
       * Return the number of ms left in the item's TTL. If item is not in cache,
       * returns `0`. Returns `Infinity` if item is in cache without a defined TTL.
       */
      getRemainingTTL(key) {
        return this.#keyMap.has(key) ? Infinity : 0;
      }
      #initializeTTLTracking() {
        const ttls = new ZeroArray(this.#max);
        const starts = new ZeroArray(this.#max);
        this.#ttls = ttls;
        this.#starts = starts;
        const purgeTimers = this.ttlAutopurge ? new Array(this.#max) : void 0;
        this.#autopurgeTimers = purgeTimers;
        this.#setItemTTL = (index, ttl, start = this.#perf.now()) => {
          starts[index] = ttl !== 0 ? start : 0;
          ttls[index] = ttl;
          if (purgeTimers?.[index]) {
            clearTimeout(purgeTimers[index]);
            purgeTimers[index] = void 0;
          }
          if (ttl !== 0 && purgeTimers) {
            const t13 = setTimeout(() => {
              if (this.#isStale(index)) {
                this.#delete(this.#keyList[index], "expire");
              }
            }, ttl + 1);
            if (t13.unref) {
              t13.unref();
            }
            purgeTimers[index] = t13;
          }
        };
        this.#updateItemAge = (index) => {
          starts[index] = ttls[index] !== 0 ? this.#perf.now() : 0;
        };
        this.#statusTTL = (status, index) => {
          if (ttls[index]) {
            const ttl = ttls[index];
            const start = starts[index];
            if (!ttl || !start)
              return;
            status.ttl = ttl;
            status.start = start;
            status.now = cachedNow || getNow();
            const age = status.now - start;
            status.remainingTTL = ttl - age;
          }
        };
        let cachedNow = 0;
        const getNow = /* @__PURE__ */ __name(() => {
          const n13 = this.#perf.now();
          if (this.ttlResolution > 0) {
            cachedNow = n13;
            const t13 = setTimeout(() => cachedNow = 0, this.ttlResolution);
            if (t13.unref) {
              t13.unref();
            }
          }
          return n13;
        }, "getNow");
        this.getRemainingTTL = (key) => {
          const index = this.#keyMap.get(key);
          if (index === void 0) {
            return 0;
          }
          const ttl = ttls[index];
          const start = starts[index];
          if (!ttl || !start) {
            return Infinity;
          }
          const age = (cachedNow || getNow()) - start;
          return ttl - age;
        };
        this.#isStale = (index) => {
          const s13 = starts[index];
          const t13 = ttls[index];
          return !!t13 && !!s13 && (cachedNow || getNow()) - s13 > t13;
        };
      }
      // conditionally set private methods related to TTL
      #updateItemAge = /* @__PURE__ */ __name(() => {
      }, "#updateItemAge");
      #statusTTL = /* @__PURE__ */ __name(() => {
      }, "#statusTTL");
      #setItemTTL = /* @__PURE__ */ __name(() => {
      }, "#setItemTTL");
      /* c8 ignore stop */
      #isStale = /* @__PURE__ */ __name(() => false, "#isStale");
      #initializeSizeTracking() {
        const sizes = new ZeroArray(this.#max);
        this.#calculatedSize = 0;
        this.#sizes = sizes;
        this.#removeItemSize = (index) => {
          this.#calculatedSize -= sizes[index];
          sizes[index] = 0;
        };
        this.#requireSize = (k13, v14, size, sizeCalculation) => {
          if (this.#isBackgroundFetch(v14)) {
            return 0;
          }
          if (!isPosInt(size)) {
            if (sizeCalculation) {
              if (typeof sizeCalculation !== "function") {
                throw new TypeError("sizeCalculation must be a function");
              }
              size = sizeCalculation(v14, k13);
              if (!isPosInt(size)) {
                throw new TypeError("sizeCalculation return invalid (expect positive integer)");
              }
            } else {
              throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");
            }
          }
          return size;
        };
        this.#addItemSize = (index, size, status) => {
          sizes[index] = size;
          if (this.#maxSize) {
            const maxSize = this.#maxSize - sizes[index];
            while (this.#calculatedSize > maxSize) {
              this.#evict(true);
            }
          }
          this.#calculatedSize += sizes[index];
          if (status) {
            status.entrySize = size;
            status.totalCalculatedSize = this.#calculatedSize;
          }
        };
      }
      #removeItemSize = /* @__PURE__ */ __name((_i) => {
      }, "#removeItemSize");
      #addItemSize = /* @__PURE__ */ __name((_i, _s13, _st) => {
      }, "#addItemSize");
      #requireSize = /* @__PURE__ */ __name((_k, _v, size, sizeCalculation) => {
        if (size || sizeCalculation) {
          throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");
        }
        return 0;
      }, "#requireSize");
      *#indexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i13 = this.#tail; true; ) {
            if (!this.#isValidIndex(i13)) {
              break;
            }
            if (allowStale || !this.#isStale(i13)) {
              yield i13;
            }
            if (i13 === this.#head) {
              break;
            } else {
              i13 = this.#prev[i13];
            }
          }
        }
      }
      *#rindexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i13 = this.#head; true; ) {
            if (!this.#isValidIndex(i13)) {
              break;
            }
            if (allowStale || !this.#isStale(i13)) {
              yield i13;
            }
            if (i13 === this.#tail) {
              break;
            } else {
              i13 = this.#next[i13];
            }
          }
        }
      }
      #isValidIndex(index) {
        return index !== void 0 && this.#keyMap.get(this.#keyList[index]) === index;
      }
      /**
       * Return a generator yielding `[key, value]` pairs,
       * in order from most recently used to least recently used.
       */
      *entries() {
        for (const i13 of this.#indexes()) {
          if (this.#valList[i13] !== void 0 && this.#keyList[i13] !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield [this.#keyList[i13], this.#valList[i13]];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.entries}
       *
       * Return a generator yielding `[key, value]` pairs,
       * in order from least recently used to most recently used.
       */
      *rentries() {
        for (const i13 of this.#rindexes()) {
          if (this.#valList[i13] !== void 0 && this.#keyList[i13] !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield [this.#keyList[i13], this.#valList[i13]];
          }
        }
      }
      /**
       * Return a generator yielding the keys in the cache,
       * in order from most recently used to least recently used.
       */
      *keys() {
        for (const i13 of this.#indexes()) {
          const k13 = this.#keyList[i13];
          if (k13 !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield k13;
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.keys}
       *
       * Return a generator yielding the keys in the cache,
       * in order from least recently used to most recently used.
       */
      *rkeys() {
        for (const i13 of this.#rindexes()) {
          const k13 = this.#keyList[i13];
          if (k13 !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield k13;
          }
        }
      }
      /**
       * Return a generator yielding the values in the cache,
       * in order from most recently used to least recently used.
       */
      *values() {
        for (const i13 of this.#indexes()) {
          const v14 = this.#valList[i13];
          if (v14 !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield this.#valList[i13];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.values}
       *
       * Return a generator yielding the values in the cache,
       * in order from least recently used to most recently used.
       */
      *rvalues() {
        for (const i13 of this.#rindexes()) {
          const v14 = this.#valList[i13];
          if (v14 !== void 0 && !this.#isBackgroundFetch(this.#valList[i13])) {
            yield this.#valList[i13];
          }
        }
      }
      /**
       * Iterating over the cache itself yields the same results as
       * {@link LRUCache.entries}
       */
      [Symbol.iterator]() {
        return this.entries();
      }
      /**
       * A String value that is used in the creation of the default string
       * description of an object. Called by the built-in method
       * `Object.prototype.toString`.
       */
      [Symbol.toStringTag] = "LRUCache";
      /**
       * Find a value for which the supplied fn method returns a truthy value,
       * similar to `Array.find()`. fn is called as `fn(value, key, cache)`.
       */
      find(fn, getOptions = {}) {
        for (const i13 of this.#indexes()) {
          const v14 = this.#valList[i13];
          const value = this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
          if (value === void 0)
            continue;
          if (fn(value, this.#keyList[i13], this)) {
            return this.get(this.#keyList[i13], getOptions);
          }
        }
      }
      /**
       * Call the supplied function on each item in the cache, in order from most
       * recently used to least recently used.
       *
       * `fn` is called as `fn(value, key, cache)`.
       *
       * If `thisp` is provided, function will be called in the `this`-context of
       * the provided object, or the cache if no `thisp` object is provided.
       *
       * Does not update age or recenty of use, or iterate over stale values.
       */
      forEach(fn, thisp = this) {
        for (const i13 of this.#indexes()) {
          const v14 = this.#valList[i13];
          const value = this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i13], this);
        }
      }
      /**
       * The same as {@link LRUCache.forEach} but items are iterated over in
       * reverse order.  (ie, less recently used items are iterated over first.)
       */
      rforEach(fn, thisp = this) {
        for (const i13 of this.#rindexes()) {
          const v14 = this.#valList[i13];
          const value = this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i13], this);
        }
      }
      /**
       * Delete any stale entries. Returns true if anything was removed,
       * false otherwise.
       */
      purgeStale() {
        let deleted = false;
        for (const i13 of this.#rindexes({ allowStale: true })) {
          if (this.#isStale(i13)) {
            this.#delete(this.#keyList[i13], "expire");
            deleted = true;
          }
        }
        return deleted;
      }
      /**
       * Get the extended info about a given entry, to get its value, size, and
       * TTL info simultaneously. Returns `undefined` if the key is not present.
       *
       * Unlike {@link LRUCache#dump}, which is designed to be portable and survive
       * serialization, the `start` value is always the current timestamp, and the
       * `ttl` is a calculated remaining time to live (negative if expired).
       *
       * Always returns stale values, if their info is found in the cache, so be
       * sure to check for expirations (ie, a negative {@link LRUCache.Entry#ttl})
       * if relevant.
       */
      info(key) {
        const i13 = this.#keyMap.get(key);
        if (i13 === void 0)
          return void 0;
        const v14 = this.#valList[i13];
        const value = this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
        if (value === void 0)
          return void 0;
        const entry = { value };
        if (this.#ttls && this.#starts) {
          const ttl = this.#ttls[i13];
          const start = this.#starts[i13];
          if (ttl && start) {
            const remain = ttl - (this.#perf.now() - start);
            entry.ttl = remain;
            entry.start = Date.now();
          }
        }
        if (this.#sizes) {
          entry.size = this.#sizes[i13];
        }
        return entry;
      }
      /**
       * Return an array of [key, {@link LRUCache.Entry}] tuples which can be
       * passed to {@link LRUCache#load}.
       *
       * The `start` fields are calculated relative to a portable `Date.now()`
       * timestamp, even if `performance.now()` is available.
       *
       * Stale entries are always included in the `dump`, even if
       * {@link LRUCache.OptionsBase.allowStale} is false.
       *
       * Note: this returns an actual array, not a generator, so it can be more
       * easily passed around.
       */
      dump() {
        const arr = [];
        for (const i13 of this.#indexes({ allowStale: true })) {
          const key = this.#keyList[i13];
          const v14 = this.#valList[i13];
          const value = this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
          if (value === void 0 || key === void 0)
            continue;
          const entry = { value };
          if (this.#ttls && this.#starts) {
            entry.ttl = this.#ttls[i13];
            const age = this.#perf.now() - this.#starts[i13];
            entry.start = Math.floor(Date.now() - age);
          }
          if (this.#sizes) {
            entry.size = this.#sizes[i13];
          }
          arr.unshift([key, entry]);
        }
        return arr;
      }
      /**
       * Reset the cache and load in the items in entries in the order listed.
       *
       * The shape of the resulting cache may be different if the same options are
       * not used in both caches.
       *
       * The `start` fields are assumed to be calculated relative to a portable
       * `Date.now()` timestamp, even if `performance.now()` is available.
       */
      load(arr) {
        this.clear();
        for (const [key, entry] of arr) {
          if (entry.start) {
            const age = Date.now() - entry.start;
            entry.start = this.#perf.now() - age;
          }
          this.set(key, entry.value, entry);
        }
      }
      /**
       * Add a value to the cache.
       *
       * Note: if `undefined` is specified as a value, this is an alias for
       * {@link LRUCache#delete}
       *
       * Fields on the {@link LRUCache.SetOptions} options param will override
       * their corresponding values in the constructor options for the scope
       * of this single `set()` operation.
       *
       * If `start` is provided, then that will set the effective start
       * time for the TTL calculation. Note that this must be a previous
       * value of `performance.now()` if supported, or a previous value of
       * `Date.now()` if not.
       *
       * Options object may also include `size`, which will prevent
       * calling the `sizeCalculation` function and just use the specified
       * number if it is a positive integer, and `noDisposeOnSet` which
       * will prevent calling a `dispose` function in the case of
       * overwrites.
       *
       * If the `size` (or return value of `sizeCalculation`) for a given
       * entry is greater than `maxEntrySize`, then the item will not be
       * added to the cache.
       *
       * Will update the recency of the entry.
       *
       * If the value is `undefined`, then this is an alias for
       * `cache.delete(key)`. `undefined` is never stored in the cache.
       */
      set(k13, v14, setOptions = {}) {
        if (v14 === void 0) {
          this.delete(k13);
          return this;
        }
        const { ttl = this.ttl, start, noDisposeOnSet = this.noDisposeOnSet, sizeCalculation = this.sizeCalculation, status } = setOptions;
        let { noUpdateTTL = this.noUpdateTTL } = setOptions;
        const size = this.#requireSize(k13, v14, setOptions.size || 0, sizeCalculation);
        if (this.maxEntrySize && size > this.maxEntrySize) {
          if (status) {
            status.set = "miss";
            status.maxEntrySizeExceeded = true;
          }
          this.#delete(k13, "set");
          return this;
        }
        let index = this.#size === 0 ? void 0 : this.#keyMap.get(k13);
        if (index === void 0) {
          index = this.#size === 0 ? this.#tail : this.#free.length !== 0 ? this.#free.pop() : this.#size === this.#max ? this.#evict(false) : this.#size;
          this.#keyList[index] = k13;
          this.#valList[index] = v14;
          this.#keyMap.set(k13, index);
          this.#next[this.#tail] = index;
          this.#prev[index] = this.#tail;
          this.#tail = index;
          this.#size++;
          this.#addItemSize(index, size, status);
          if (status)
            status.set = "add";
          noUpdateTTL = false;
          if (this.#hasOnInsert) {
            this.#onInsert?.(v14, k13, "add");
          }
        } else {
          this.#moveToTail(index);
          const oldVal = this.#valList[index];
          if (v14 !== oldVal) {
            if (this.#hasFetchMethod && this.#isBackgroundFetch(oldVal)) {
              oldVal.__abortController.abort(new Error("replaced"));
              const { __staleWhileFetching: s13 } = oldVal;
              if (s13 !== void 0 && !noDisposeOnSet) {
                if (this.#hasDispose) {
                  this.#dispose?.(s13, k13, "set");
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([s13, k13, "set"]);
                }
              }
            } else if (!noDisposeOnSet) {
              if (this.#hasDispose) {
                this.#dispose?.(oldVal, k13, "set");
              }
              if (this.#hasDisposeAfter) {
                this.#disposed?.push([oldVal, k13, "set"]);
              }
            }
            this.#removeItemSize(index);
            this.#addItemSize(index, size, status);
            this.#valList[index] = v14;
            if (status) {
              status.set = "replace";
              const oldValue = oldVal && this.#isBackgroundFetch(oldVal) ? oldVal.__staleWhileFetching : oldVal;
              if (oldValue !== void 0)
                status.oldValue = oldValue;
            }
          } else if (status) {
            status.set = "update";
          }
          if (this.#hasOnInsert) {
            this.onInsert?.(v14, k13, v14 === oldVal ? "update" : "replace");
          }
        }
        if (ttl !== 0 && !this.#ttls) {
          this.#initializeTTLTracking();
        }
        if (this.#ttls) {
          if (!noUpdateTTL) {
            this.#setItemTTL(index, ttl, start);
          }
          if (status)
            this.#statusTTL(status, index);
        }
        if (!noDisposeOnSet && this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return this;
      }
      /**
       * Evict the least recently used item, returning its value or
       * `undefined` if cache is empty.
       */
      pop() {
        try {
          while (this.#size) {
            const val = this.#valList[this.#head];
            this.#evict(true);
            if (this.#isBackgroundFetch(val)) {
              if (val.__staleWhileFetching) {
                return val.__staleWhileFetching;
              }
            } else if (val !== void 0) {
              return val;
            }
          }
        } finally {
          if (this.#hasDisposeAfter && this.#disposed) {
            const dt = this.#disposed;
            let task;
            while (task = dt?.shift()) {
              this.#disposeAfter?.(...task);
            }
          }
        }
      }
      #evict(free) {
        const head = this.#head;
        const k13 = this.#keyList[head];
        const v14 = this.#valList[head];
        if (this.#hasFetchMethod && this.#isBackgroundFetch(v14)) {
          v14.__abortController.abort(new Error("evicted"));
        } else if (this.#hasDispose || this.#hasDisposeAfter) {
          if (this.#hasDispose) {
            this.#dispose?.(v14, k13, "evict");
          }
          if (this.#hasDisposeAfter) {
            this.#disposed?.push([v14, k13, "evict"]);
          }
        }
        this.#removeItemSize(head);
        if (this.#autopurgeTimers?.[head]) {
          clearTimeout(this.#autopurgeTimers[head]);
          this.#autopurgeTimers[head] = void 0;
        }
        if (free) {
          this.#keyList[head] = void 0;
          this.#valList[head] = void 0;
          this.#free.push(head);
        }
        if (this.#size === 1) {
          this.#head = this.#tail = 0;
          this.#free.length = 0;
        } else {
          this.#head = this.#next[head];
        }
        this.#keyMap.delete(k13);
        this.#size--;
        return head;
      }
      /**
       * Check if a key is in the cache, without updating the recency of use.
       * Will return false if the item is stale, even though it is technically
       * in the cache.
       *
       * Check if a key is in the cache, without updating the recency of
       * use. Age is updated if {@link LRUCache.OptionsBase.updateAgeOnHas} is set
       * to `true` in either the options or the constructor.
       *
       * Will return `false` if the item is stale, even though it is technically in
       * the cache. The difference can be determined (if it matters) by using a
       * `status` argument, and inspecting the `has` field.
       *
       * Will not update item age unless
       * {@link LRUCache.OptionsBase.updateAgeOnHas} is set.
       */
      has(k13, hasOptions = {}) {
        const { updateAgeOnHas = this.updateAgeOnHas, status } = hasOptions;
        const index = this.#keyMap.get(k13);
        if (index !== void 0) {
          const v14 = this.#valList[index];
          if (this.#isBackgroundFetch(v14) && v14.__staleWhileFetching === void 0) {
            return false;
          }
          if (!this.#isStale(index)) {
            if (updateAgeOnHas) {
              this.#updateItemAge(index);
            }
            if (status) {
              status.has = "hit";
              this.#statusTTL(status, index);
            }
            return true;
          } else if (status) {
            status.has = "stale";
            this.#statusTTL(status, index);
          }
        } else if (status) {
          status.has = "miss";
        }
        return false;
      }
      /**
       * Like {@link LRUCache#get} but doesn't update recency or delete stale
       * items.
       *
       * Returns `undefined` if the item is stale, unless
       * {@link LRUCache.OptionsBase.allowStale} is set.
       */
      peek(k13, peekOptions = {}) {
        const { allowStale = this.allowStale } = peekOptions;
        const index = this.#keyMap.get(k13);
        if (index === void 0 || !allowStale && this.#isStale(index)) {
          return;
        }
        const v14 = this.#valList[index];
        return this.#isBackgroundFetch(v14) ? v14.__staleWhileFetching : v14;
      }
      #backgroundFetch(k13, index, options, context) {
        const v14 = index === void 0 ? void 0 : this.#valList[index];
        if (this.#isBackgroundFetch(v14)) {
          return v14;
        }
        const ac = new AC();
        const { signal } = options;
        signal?.addEventListener("abort", () => ac.abort(signal.reason), {
          signal: ac.signal
        });
        const fetchOpts = {
          signal: ac.signal,
          options,
          context
        };
        const cb = /* @__PURE__ */ __name((v15, updateCache = false) => {
          const { aborted } = ac.signal;
          const ignoreAbort = options.ignoreFetchAbort && v15 !== void 0;
          if (options.status) {
            if (aborted && !updateCache) {
              options.status.fetchAborted = true;
              options.status.fetchError = ac.signal.reason;
              if (ignoreAbort)
                options.status.fetchAbortIgnored = true;
            } else {
              options.status.fetchResolved = true;
            }
          }
          if (aborted && !ignoreAbort && !updateCache) {
            return fetchFail(ac.signal.reason);
          }
          const bf2 = p13;
          const vl = this.#valList[index];
          if (vl === p13 || ignoreAbort && updateCache && vl === void 0) {
            if (v15 === void 0) {
              if (bf2.__staleWhileFetching !== void 0) {
                this.#valList[index] = bf2.__staleWhileFetching;
              } else {
                this.#delete(k13, "fetch");
              }
            } else {
              if (options.status)
                options.status.fetchUpdated = true;
              this.set(k13, v15, fetchOpts.options);
            }
          }
          return v15;
        }, "cb");
        const eb = /* @__PURE__ */ __name((er) => {
          if (options.status) {
            options.status.fetchRejected = true;
            options.status.fetchError = er;
          }
          return fetchFail(er);
        }, "eb");
        const fetchFail = /* @__PURE__ */ __name((er) => {
          const { aborted } = ac.signal;
          const allowStaleAborted = aborted && options.allowStaleOnFetchAbort;
          const allowStale = allowStaleAborted || options.allowStaleOnFetchRejection;
          const noDelete = allowStale || options.noDeleteOnFetchRejection;
          const bf2 = p13;
          if (this.#valList[index] === p13) {
            const del = !noDelete || bf2.__staleWhileFetching === void 0;
            if (del) {
              this.#delete(k13, "fetch");
            } else if (!allowStaleAborted) {
              this.#valList[index] = bf2.__staleWhileFetching;
            }
          }
          if (allowStale) {
            if (options.status && bf2.__staleWhileFetching !== void 0) {
              options.status.returnedStale = true;
            }
            return bf2.__staleWhileFetching;
          } else if (bf2.__returned === bf2) {
            throw er;
          }
        }, "fetchFail");
        const pcall = /* @__PURE__ */ __name((res, rej) => {
          const fmp = this.#fetchMethod?.(k13, v14, fetchOpts);
          if (fmp && fmp instanceof Promise) {
            fmp.then((v15) => res(v15 === void 0 ? void 0 : v15), rej);
          }
          ac.signal.addEventListener("abort", () => {
            if (!options.ignoreFetchAbort || options.allowStaleOnFetchAbort) {
              res(void 0);
              if (options.allowStaleOnFetchAbort) {
                res = /* @__PURE__ */ __name((v15) => cb(v15, true), "res");
              }
            }
          });
        }, "pcall");
        if (options.status)
          options.status.fetchDispatched = true;
        const p13 = new Promise(pcall).then(cb, eb);
        const bf = Object.assign(p13, {
          __abortController: ac,
          __staleWhileFetching: v14,
          __returned: void 0
        });
        if (index === void 0) {
          this.set(k13, bf, { ...fetchOpts.options, status: void 0 });
          index = this.#keyMap.get(k13);
        } else {
          this.#valList[index] = bf;
        }
        return bf;
      }
      #isBackgroundFetch(p13) {
        if (!this.#hasFetchMethod)
          return false;
        const b13 = p13;
        return !!b13 && b13 instanceof Promise && b13.hasOwnProperty("__staleWhileFetching") && b13.__abortController instanceof AC;
      }
      async fetch(k13, fetchOptions = {}) {
        const {
          // get options
          allowStale = this.allowStale,
          updateAgeOnGet = this.updateAgeOnGet,
          noDeleteOnStaleGet = this.noDeleteOnStaleGet,
          // set options
          ttl = this.ttl,
          noDisposeOnSet = this.noDisposeOnSet,
          size = 0,
          sizeCalculation = this.sizeCalculation,
          noUpdateTTL = this.noUpdateTTL,
          // fetch exclusive options
          noDeleteOnFetchRejection = this.noDeleteOnFetchRejection,
          allowStaleOnFetchRejection = this.allowStaleOnFetchRejection,
          ignoreFetchAbort = this.ignoreFetchAbort,
          allowStaleOnFetchAbort = this.allowStaleOnFetchAbort,
          context,
          forceRefresh = false,
          status,
          signal
        } = fetchOptions;
        if (!this.#hasFetchMethod) {
          if (status)
            status.fetch = "get";
          return this.get(k13, {
            allowStale,
            updateAgeOnGet,
            noDeleteOnStaleGet,
            status
          });
        }
        const options = {
          allowStale,
          updateAgeOnGet,
          noDeleteOnStaleGet,
          ttl,
          noDisposeOnSet,
          size,
          sizeCalculation,
          noUpdateTTL,
          noDeleteOnFetchRejection,
          allowStaleOnFetchRejection,
          allowStaleOnFetchAbort,
          ignoreFetchAbort,
          status,
          signal
        };
        let index = this.#keyMap.get(k13);
        if (index === void 0) {
          if (status)
            status.fetch = "miss";
          const p13 = this.#backgroundFetch(k13, index, options, context);
          return p13.__returned = p13;
        } else {
          const v14 = this.#valList[index];
          if (this.#isBackgroundFetch(v14)) {
            const stale = allowStale && v14.__staleWhileFetching !== void 0;
            if (status) {
              status.fetch = "inflight";
              if (stale)
                status.returnedStale = true;
            }
            return stale ? v14.__staleWhileFetching : v14.__returned = v14;
          }
          const isStale = this.#isStale(index);
          if (!forceRefresh && !isStale) {
            if (status)
              status.fetch = "hit";
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            if (status)
              this.#statusTTL(status, index);
            return v14;
          }
          const p13 = this.#backgroundFetch(k13, index, options, context);
          const hasStale = p13.__staleWhileFetching !== void 0;
          const staleVal = hasStale && allowStale;
          if (status) {
            status.fetch = isStale ? "stale" : "refresh";
            if (staleVal && isStale)
              status.returnedStale = true;
          }
          return staleVal ? p13.__staleWhileFetching : p13.__returned = p13;
        }
      }
      async forceFetch(k13, fetchOptions = {}) {
        const v14 = await this.fetch(k13, fetchOptions);
        if (v14 === void 0)
          throw new Error("fetch() returned undefined");
        return v14;
      }
      memo(k13, memoOptions = {}) {
        const memoMethod = this.#memoMethod;
        if (!memoMethod) {
          throw new Error("no memoMethod provided to constructor");
        }
        const { context, forceRefresh, ...options } = memoOptions;
        const v14 = this.get(k13, options);
        if (!forceRefresh && v14 !== void 0)
          return v14;
        const vv = memoMethod(k13, v14, {
          options,
          context
        });
        this.set(k13, vv, options);
        return vv;
      }
      /**
       * Return a value from the cache. Will update the recency of the cache
       * entry found.
       *
       * If the key is not found, get() will return `undefined`.
       */
      get(k13, getOptions = {}) {
        const { allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, status } = getOptions;
        const index = this.#keyMap.get(k13);
        if (index !== void 0) {
          const value = this.#valList[index];
          const fetching = this.#isBackgroundFetch(value);
          if (status)
            this.#statusTTL(status, index);
          if (this.#isStale(index)) {
            if (status)
              status.get = "stale";
            if (!fetching) {
              if (!noDeleteOnStaleGet) {
                this.#delete(k13, "expire");
              }
              if (status && allowStale)
                status.returnedStale = true;
              return allowStale ? value : void 0;
            } else {
              if (status && allowStale && value.__staleWhileFetching !== void 0) {
                status.returnedStale = true;
              }
              return allowStale ? value.__staleWhileFetching : void 0;
            }
          } else {
            if (status)
              status.get = "hit";
            if (fetching) {
              return value.__staleWhileFetching;
            }
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            return value;
          }
        } else if (status) {
          status.get = "miss";
        }
      }
      #connect(p13, n13) {
        this.#prev[n13] = p13;
        this.#next[p13] = n13;
      }
      #moveToTail(index) {
        if (index !== this.#tail) {
          if (index === this.#head) {
            this.#head = this.#next[index];
          } else {
            this.#connect(this.#prev[index], this.#next[index]);
          }
          this.#connect(this.#tail, index);
          this.#tail = index;
        }
      }
      /**
       * Deletes a key out of the cache.
       *
       * Returns true if the key was deleted, false otherwise.
       */
      delete(k13) {
        return this.#delete(k13, "delete");
      }
      #delete(k13, reason) {
        let deleted = false;
        if (this.#size !== 0) {
          const index = this.#keyMap.get(k13);
          if (index !== void 0) {
            if (this.#autopurgeTimers?.[index]) {
              clearTimeout(this.#autopurgeTimers?.[index]);
              this.#autopurgeTimers[index] = void 0;
            }
            deleted = true;
            if (this.#size === 1) {
              this.#clear(reason);
            } else {
              this.#removeItemSize(index);
              const v14 = this.#valList[index];
              if (this.#isBackgroundFetch(v14)) {
                v14.__abortController.abort(new Error("deleted"));
              } else if (this.#hasDispose || this.#hasDisposeAfter) {
                if (this.#hasDispose) {
                  this.#dispose?.(v14, k13, reason);
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([v14, k13, reason]);
                }
              }
              this.#keyMap.delete(k13);
              this.#keyList[index] = void 0;
              this.#valList[index] = void 0;
              if (index === this.#tail) {
                this.#tail = this.#prev[index];
              } else if (index === this.#head) {
                this.#head = this.#next[index];
              } else {
                const pi = this.#prev[index];
                this.#next[pi] = this.#next[index];
                const ni = this.#next[index];
                this.#prev[ni] = this.#prev[index];
              }
              this.#size--;
              this.#free.push(index);
            }
          }
        }
        if (this.#hasDisposeAfter && this.#disposed?.length) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return deleted;
      }
      /**
       * Clear the cache entirely, throwing away all values.
       */
      clear() {
        return this.#clear("delete");
      }
      #clear(reason) {
        for (const index of this.#rindexes({ allowStale: true })) {
          const v14 = this.#valList[index];
          if (this.#isBackgroundFetch(v14)) {
            v14.__abortController.abort(new Error("deleted"));
          } else {
            const k13 = this.#keyList[index];
            if (this.#hasDispose) {
              this.#dispose?.(v14, k13, reason);
            }
            if (this.#hasDisposeAfter) {
              this.#disposed?.push([v14, k13, reason]);
            }
          }
        }
        this.#keyMap.clear();
        this.#valList.fill(void 0);
        this.#keyList.fill(void 0);
        if (this.#ttls && this.#starts) {
          this.#ttls.fill(0);
          this.#starts.fill(0);
          for (const t13 of this.#autopurgeTimers ?? []) {
            if (t13 !== void 0)
              clearTimeout(t13);
          }
          this.#autopurgeTimers?.fill(void 0);
        }
        if (this.#sizes) {
          this.#sizes.fill(0);
        }
        this.#head = 0;
        this.#tail = 0;
        this.#free.length = 0;
        this.#calculatedSize = 0;
        this.#size = 0;
        if (this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
      }
    };
  }
});

// ../../node_modules/minipass/dist/esm/index.js
var import_node_events, import_node_stream, import_node_string_decoder, proc, isStream, isReadable, isWritable, EOF, MAYBE_EMIT_END, EMITTED_END, EMITTING_END, EMITTED_ERROR, CLOSED, READ, FLUSH, FLUSHCHUNK, ENCODING, DECODER, FLOWING, PAUSED, RESUME, BUFFER, PIPES, BUFFERLENGTH, BUFFERPUSH, BUFFERSHIFT, OBJECTMODE, DESTROYED, ERROR, EMITDATA, EMITEND, EMITEND2, ASYNC, ABORT, ABORTED, SIGNAL, DATALISTENERS, DISCARDED, defer, nodefer, isEndish, isArrayBufferLike, isArrayBufferView, Pipe, PipeProxyErrors, isObjectModeOptions, isEncodingOptions, Minipass;
var init_esm5 = __esm({
  "../../node_modules/minipass/dist/esm/index.js"() {
    import_node_events = require("node:events");
    import_node_stream = __toESM(require("node:stream"), 1);
    import_node_string_decoder = require("node:string_decoder");
    proc = typeof process === "object" && process ? process : {
      stdout: null,
      stderr: null
    };
    isStream = /* @__PURE__ */ __name((s13) => !!s13 && typeof s13 === "object" && (s13 instanceof Minipass || s13 instanceof import_node_stream.default || isReadable(s13) || isWritable(s13)), "isStream");
    isReadable = /* @__PURE__ */ __name((s13) => !!s13 && typeof s13 === "object" && s13 instanceof import_node_events.EventEmitter && typeof s13.pipe === "function" && // node core Writable streams have a pipe() method, but it throws
    s13.pipe !== import_node_stream.default.Writable.prototype.pipe, "isReadable");
    isWritable = /* @__PURE__ */ __name((s13) => !!s13 && typeof s13 === "object" && s13 instanceof import_node_events.EventEmitter && typeof s13.write === "function" && typeof s13.end === "function", "isWritable");
    EOF = /* @__PURE__ */ Symbol("EOF");
    MAYBE_EMIT_END = /* @__PURE__ */ Symbol("maybeEmitEnd");
    EMITTED_END = /* @__PURE__ */ Symbol("emittedEnd");
    EMITTING_END = /* @__PURE__ */ Symbol("emittingEnd");
    EMITTED_ERROR = /* @__PURE__ */ Symbol("emittedError");
    CLOSED = /* @__PURE__ */ Symbol("closed");
    READ = /* @__PURE__ */ Symbol("read");
    FLUSH = /* @__PURE__ */ Symbol("flush");
    FLUSHCHUNK = /* @__PURE__ */ Symbol("flushChunk");
    ENCODING = /* @__PURE__ */ Symbol("encoding");
    DECODER = /* @__PURE__ */ Symbol("decoder");
    FLOWING = /* @__PURE__ */ Symbol("flowing");
    PAUSED = /* @__PURE__ */ Symbol("paused");
    RESUME = /* @__PURE__ */ Symbol("resume");
    BUFFER = /* @__PURE__ */ Symbol("buffer");
    PIPES = /* @__PURE__ */ Symbol("pipes");
    BUFFERLENGTH = /* @__PURE__ */ Symbol("bufferLength");
    BUFFERPUSH = /* @__PURE__ */ Symbol("bufferPush");
    BUFFERSHIFT = /* @__PURE__ */ Symbol("bufferShift");
    OBJECTMODE = /* @__PURE__ */ Symbol("objectMode");
    DESTROYED = /* @__PURE__ */ Symbol("destroyed");
    ERROR = /* @__PURE__ */ Symbol("error");
    EMITDATA = /* @__PURE__ */ Symbol("emitData");
    EMITEND = /* @__PURE__ */ Symbol("emitEnd");
    EMITEND2 = /* @__PURE__ */ Symbol("emitEnd2");
    ASYNC = /* @__PURE__ */ Symbol("async");
    ABORT = /* @__PURE__ */ Symbol("abort");
    ABORTED = /* @__PURE__ */ Symbol("aborted");
    SIGNAL = /* @__PURE__ */ Symbol("signal");
    DATALISTENERS = /* @__PURE__ */ Symbol("dataListeners");
    DISCARDED = /* @__PURE__ */ Symbol("discarded");
    defer = /* @__PURE__ */ __name((fn) => Promise.resolve().then(fn), "defer");
    nodefer = /* @__PURE__ */ __name((fn) => fn(), "nodefer");
    isEndish = /* @__PURE__ */ __name((ev) => ev === "end" || ev === "finish" || ev === "prefinish", "isEndish");
    isArrayBufferLike = /* @__PURE__ */ __name((b13) => b13 instanceof ArrayBuffer || !!b13 && typeof b13 === "object" && b13.constructor && b13.constructor.name === "ArrayBuffer" && b13.byteLength >= 0, "isArrayBufferLike");
    isArrayBufferView = /* @__PURE__ */ __name((b13) => !Buffer.isBuffer(b13) && ArrayBuffer.isView(b13), "isArrayBufferView");
    Pipe = class {
      static {
        __name(this, "Pipe");
      }
      src;
      dest;
      opts;
      ondrain;
      constructor(src, dest, opts) {
        this.src = src;
        this.dest = dest;
        this.opts = opts;
        this.ondrain = () => src[RESUME]();
        this.dest.on("drain", this.ondrain);
      }
      unpipe() {
        this.dest.removeListener("drain", this.ondrain);
      }
      // only here for the prototype
      /* c8 ignore start */
      proxyErrors(_er) {
      }
      /* c8 ignore stop */
      end() {
        this.unpipe();
        if (this.opts.end)
          this.dest.end();
      }
    };
    PipeProxyErrors = class extends Pipe {
      static {
        __name(this, "PipeProxyErrors");
      }
      unpipe() {
        this.src.removeListener("error", this.proxyErrors);
        super.unpipe();
      }
      constructor(src, dest, opts) {
        super(src, dest, opts);
        this.proxyErrors = (er) => dest.emit("error", er);
        src.on("error", this.proxyErrors);
      }
    };
    isObjectModeOptions = /* @__PURE__ */ __name((o13) => !!o13.objectMode, "isObjectModeOptions");
    isEncodingOptions = /* @__PURE__ */ __name((o13) => !o13.objectMode && !!o13.encoding && o13.encoding !== "buffer", "isEncodingOptions");
    Minipass = class extends import_node_events.EventEmitter {
      static {
        __name(this, "Minipass");
      }
      [FLOWING] = false;
      [PAUSED] = false;
      [PIPES] = [];
      [BUFFER] = [];
      [OBJECTMODE];
      [ENCODING];
      [ASYNC];
      [DECODER];
      [EOF] = false;
      [EMITTED_END] = false;
      [EMITTING_END] = false;
      [CLOSED] = false;
      [EMITTED_ERROR] = null;
      [BUFFERLENGTH] = 0;
      [DESTROYED] = false;
      [SIGNAL];
      [ABORTED] = false;
      [DATALISTENERS] = 0;
      [DISCARDED] = false;
      /**
       * true if the stream can be written
       */
      writable = true;
      /**
       * true if the stream can be read
       */
      readable = true;
      /**
       * If `RType` is Buffer, then options do not need to be provided.
       * Otherwise, an options object must be provided to specify either
       * {@link Minipass.SharedOptions.objectMode} or
       * {@link Minipass.SharedOptions.encoding}, as appropriate.
       */
      constructor(...args) {
        const options = args[0] || {};
        super();
        if (options.objectMode && typeof options.encoding === "string") {
          throw new TypeError("Encoding and objectMode may not be used together");
        }
        if (isObjectModeOptions(options)) {
          this[OBJECTMODE] = true;
          this[ENCODING] = null;
        } else if (isEncodingOptions(options)) {
          this[ENCODING] = options.encoding;
          this[OBJECTMODE] = false;
        } else {
          this[OBJECTMODE] = false;
          this[ENCODING] = null;
        }
        this[ASYNC] = !!options.async;
        this[DECODER] = this[ENCODING] ? new import_node_string_decoder.StringDecoder(this[ENCODING]) : null;
        if (options && options.debugExposeBuffer === true) {
          Object.defineProperty(this, "buffer", { get: /* @__PURE__ */ __name(() => this[BUFFER], "get") });
        }
        if (options && options.debugExposePipes === true) {
          Object.defineProperty(this, "pipes", { get: /* @__PURE__ */ __name(() => this[PIPES], "get") });
        }
        const { signal } = options;
        if (signal) {
          this[SIGNAL] = signal;
          if (signal.aborted) {
            this[ABORT]();
          } else {
            signal.addEventListener("abort", () => this[ABORT]());
          }
        }
      }
      /**
       * The amount of data stored in the buffer waiting to be read.
       *
       * For Buffer strings, this will be the total byte length.
       * For string encoding streams, this will be the string character length,
       * according to JavaScript's `string.length` logic.
       * For objectMode streams, this is a count of the items waiting to be
       * emitted.
       */
      get bufferLength() {
        return this[BUFFERLENGTH];
      }
      /**
       * The `BufferEncoding` currently in use, or `null`
       */
      get encoding() {
        return this[ENCODING];
      }
      /**
       * @deprecated - This is a read only property
       */
      set encoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * @deprecated - Encoding may only be set at instantiation time
       */
      setEncoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * True if this is an objectMode stream
       */
      get objectMode() {
        return this[OBJECTMODE];
      }
      /**
       * @deprecated - This is a read-only property
       */
      set objectMode(_om) {
        throw new Error("objectMode must be set at instantiation time");
      }
      /**
       * true if this is an async stream
       */
      get ["async"]() {
        return this[ASYNC];
      }
      /**
       * Set to true to make this stream async.
       *
       * Once set, it cannot be unset, as this would potentially cause incorrect
       * behavior.  Ie, a sync stream can be made async, but an async stream
       * cannot be safely made sync.
       */
      set ["async"](a13) {
        this[ASYNC] = this[ASYNC] || !!a13;
      }
      // drop everything and get out of the flow completely
      [ABORT]() {
        this[ABORTED] = true;
        this.emit("abort", this[SIGNAL]?.reason);
        this.destroy(this[SIGNAL]?.reason);
      }
      /**
       * True if the stream has been aborted.
       */
      get aborted() {
        return this[ABORTED];
      }
      /**
       * No-op setter. Stream aborted status is set via the AbortSignal provided
       * in the constructor options.
       */
      set aborted(_2) {
      }
      write(chunk, encoding, cb) {
        if (this[ABORTED])
          return false;
        if (this[EOF])
          throw new Error("write after end");
        if (this[DESTROYED]) {
          this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), { code: "ERR_STREAM_DESTROYED" }));
          return true;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (!encoding)
          encoding = "utf8";
        const fn = this[ASYNC] ? defer : nodefer;
        if (!this[OBJECTMODE] && !Buffer.isBuffer(chunk)) {
          if (isArrayBufferView(chunk)) {
            chunk = Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength);
          } else if (isArrayBufferLike(chunk)) {
            chunk = Buffer.from(chunk);
          } else if (typeof chunk !== "string") {
            throw new Error("Non-contiguous data written to non-objectMode stream");
          }
        }
        if (this[OBJECTMODE]) {
          if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
            this[FLUSH](true);
          if (this[FLOWING])
            this.emit("data", chunk);
          else
            this[BUFFERPUSH](chunk);
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (!chunk.length) {
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (typeof chunk === "string" && // unless it is a string already ready for us to use
        !(encoding === this[ENCODING] && !this[DECODER]?.lastNeed)) {
          chunk = Buffer.from(chunk, encoding);
        }
        if (Buffer.isBuffer(chunk) && this[ENCODING]) {
          chunk = this[DECODER].write(chunk);
        }
        if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
          this[FLUSH](true);
        if (this[FLOWING])
          this.emit("data", chunk);
        else
          this[BUFFERPUSH](chunk);
        if (this[BUFFERLENGTH] !== 0)
          this.emit("readable");
        if (cb)
          fn(cb);
        return this[FLOWING];
      }
      /**
       * Low-level explicit read method.
       *
       * In objectMode, the argument is ignored, and one item is returned if
       * available.
       *
       * `n` is the number of bytes (or in the case of encoding streams,
       * characters) to consume. If `n` is not provided, then the entire buffer
       * is returned, or `null` is returned if no data is available.
       *
       * If `n` is greater that the amount of data in the internal buffer,
       * then `null` is returned.
       */
      read(n13) {
        if (this[DESTROYED])
          return null;
        this[DISCARDED] = false;
        if (this[BUFFERLENGTH] === 0 || n13 === 0 || n13 && n13 > this[BUFFERLENGTH]) {
          this[MAYBE_EMIT_END]();
          return null;
        }
        if (this[OBJECTMODE])
          n13 = null;
        if (this[BUFFER].length > 1 && !this[OBJECTMODE]) {
          this[BUFFER] = [
            this[ENCODING] ? this[BUFFER].join("") : Buffer.concat(this[BUFFER], this[BUFFERLENGTH])
          ];
        }
        const ret = this[READ](n13 || null, this[BUFFER][0]);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [READ](n13, chunk) {
        if (this[OBJECTMODE])
          this[BUFFERSHIFT]();
        else {
          const c13 = chunk;
          if (n13 === c13.length || n13 === null)
            this[BUFFERSHIFT]();
          else if (typeof c13 === "string") {
            this[BUFFER][0] = c13.slice(n13);
            chunk = c13.slice(0, n13);
            this[BUFFERLENGTH] -= n13;
          } else {
            this[BUFFER][0] = c13.subarray(n13);
            chunk = c13.subarray(0, n13);
            this[BUFFERLENGTH] -= n13;
          }
        }
        this.emit("data", chunk);
        if (!this[BUFFER].length && !this[EOF])
          this.emit("drain");
        return chunk;
      }
      end(chunk, encoding, cb) {
        if (typeof chunk === "function") {
          cb = chunk;
          chunk = void 0;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (chunk !== void 0)
          this.write(chunk, encoding);
        if (cb)
          this.once("end", cb);
        this[EOF] = true;
        this.writable = false;
        if (this[FLOWING] || !this[PAUSED])
          this[MAYBE_EMIT_END]();
        return this;
      }
      // don't let the internal resume be overwritten
      [RESUME]() {
        if (this[DESTROYED])
          return;
        if (!this[DATALISTENERS] && !this[PIPES].length) {
          this[DISCARDED] = true;
        }
        this[PAUSED] = false;
        this[FLOWING] = true;
        this.emit("resume");
        if (this[BUFFER].length)
          this[FLUSH]();
        else if (this[EOF])
          this[MAYBE_EMIT_END]();
        else
          this.emit("drain");
      }
      /**
       * Resume the stream if it is currently in a paused state
       *
       * If called when there are no pipe destinations or `data` event listeners,
       * this will place the stream in a "discarded" state, where all data will
       * be thrown away. The discarded state is removed if a pipe destination or
       * data handler is added, if pause() is called, or if any synchronous or
       * asynchronous iteration is started.
       */
      resume() {
        return this[RESUME]();
      }
      /**
       * Pause the stream
       */
      pause() {
        this[FLOWING] = false;
        this[PAUSED] = true;
        this[DISCARDED] = false;
      }
      /**
       * true if the stream has been forcibly destroyed
       */
      get destroyed() {
        return this[DESTROYED];
      }
      /**
       * true if the stream is currently in a flowing state, meaning that
       * any writes will be immediately emitted.
       */
      get flowing() {
        return this[FLOWING];
      }
      /**
       * true if the stream is currently in a paused state
       */
      get paused() {
        return this[PAUSED];
      }
      [BUFFERPUSH](chunk) {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] += 1;
        else
          this[BUFFERLENGTH] += chunk.length;
        this[BUFFER].push(chunk);
      }
      [BUFFERSHIFT]() {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] -= 1;
        else
          this[BUFFERLENGTH] -= this[BUFFER][0].length;
        return this[BUFFER].shift();
      }
      [FLUSH](noDrain = false) {
        do {
        } while (this[FLUSHCHUNK](this[BUFFERSHIFT]()) && this[BUFFER].length);
        if (!noDrain && !this[BUFFER].length && !this[EOF])
          this.emit("drain");
      }
      [FLUSHCHUNK](chunk) {
        this.emit("data", chunk);
        return this[FLOWING];
      }
      /**
       * Pipe all data emitted by this stream into the destination provided.
       *
       * Triggers the flow of data.
       */
      pipe(dest, opts) {
        if (this[DESTROYED])
          return dest;
        this[DISCARDED] = false;
        const ended = this[EMITTED_END];
        opts = opts || {};
        if (dest === proc.stdout || dest === proc.stderr)
          opts.end = false;
        else
          opts.end = opts.end !== false;
        opts.proxyErrors = !!opts.proxyErrors;
        if (ended) {
          if (opts.end)
            dest.end();
        } else {
          this[PIPES].push(!opts.proxyErrors ? new Pipe(this, dest, opts) : new PipeProxyErrors(this, dest, opts));
          if (this[ASYNC])
            defer(() => this[RESUME]());
          else
            this[RESUME]();
        }
        return dest;
      }
      /**
       * Fully unhook a piped destination stream.
       *
       * If the destination stream was the only consumer of this stream (ie,
       * there are no other piped destinations or `'data'` event listeners)
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      unpipe(dest) {
        const p13 = this[PIPES].find((p14) => p14.dest === dest);
        if (p13) {
          if (this[PIPES].length === 1) {
            if (this[FLOWING] && this[DATALISTENERS] === 0) {
              this[FLOWING] = false;
            }
            this[PIPES] = [];
          } else
            this[PIPES].splice(this[PIPES].indexOf(p13), 1);
          p13.unpipe();
        }
      }
      /**
       * Alias for {@link Minipass#on}
       */
      addListener(ev, handler) {
        return this.on(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.on`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * - Adding a 'data' event handler will trigger the flow of data
       *
       * - Adding a 'readable' event handler when there is data waiting to be read
       *   will cause 'readable' to be emitted immediately.
       *
       * - Adding an 'endish' event handler ('end', 'finish', etc.) which has
       *   already passed will cause the event to be emitted immediately and all
       *   handlers removed.
       *
       * - Adding an 'error' event handler after an error has been emitted will
       *   cause the event to be re-emitted immediately with the error previously
       *   raised.
       */
      on(ev, handler) {
        const ret = super.on(ev, handler);
        if (ev === "data") {
          this[DISCARDED] = false;
          this[DATALISTENERS]++;
          if (!this[PIPES].length && !this[FLOWING]) {
            this[RESUME]();
          }
        } else if (ev === "readable" && this[BUFFERLENGTH] !== 0) {
          super.emit("readable");
        } else if (isEndish(ev) && this[EMITTED_END]) {
          super.emit(ev);
          this.removeAllListeners(ev);
        } else if (ev === "error" && this[EMITTED_ERROR]) {
          const h13 = handler;
          if (this[ASYNC])
            defer(() => h13.call(this, this[EMITTED_ERROR]));
          else
            h13.call(this, this[EMITTED_ERROR]);
        }
        return ret;
      }
      /**
       * Alias for {@link Minipass#off}
       */
      removeListener(ev, handler) {
        return this.off(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.off`
       *
       * If a 'data' event handler is removed, and it was the last consumer
       * (ie, there are no pipe destinations or other 'data' event listeners),
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      off(ev, handler) {
        const ret = super.off(ev, handler);
        if (ev === "data") {
          this[DATALISTENERS] = this.listeners("data").length;
          if (this[DATALISTENERS] === 0 && !this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * Mostly identical to `EventEmitter.removeAllListeners`
       *
       * If all 'data' event handlers are removed, and they were the last consumer
       * (ie, there are no pipe destinations), then the flow of data will stop
       * until there is another consumer or {@link Minipass#resume} is explicitly
       * called.
       */
      removeAllListeners(ev) {
        const ret = super.removeAllListeners(ev);
        if (ev === "data" || ev === void 0) {
          this[DATALISTENERS] = 0;
          if (!this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * true if the 'end' event has been emitted
       */
      get emittedEnd() {
        return this[EMITTED_END];
      }
      [MAYBE_EMIT_END]() {
        if (!this[EMITTING_END] && !this[EMITTED_END] && !this[DESTROYED] && this[BUFFER].length === 0 && this[EOF]) {
          this[EMITTING_END] = true;
          this.emit("end");
          this.emit("prefinish");
          this.emit("finish");
          if (this[CLOSED])
            this.emit("close");
          this[EMITTING_END] = false;
        }
      }
      /**
       * Mostly identical to `EventEmitter.emit`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * If the stream has been destroyed, and the event is something other
       * than 'close' or 'error', then `false` is returned and no handlers
       * are called.
       *
       * If the event is 'end', and has already been emitted, then the event
       * is ignored. If the stream is in a paused or non-flowing state, then
       * the event will be deferred until data flow resumes. If the stream is
       * async, then handlers will be called on the next tick rather than
       * immediately.
       *
       * If the event is 'close', and 'end' has not yet been emitted, then
       * the event will be deferred until after 'end' is emitted.
       *
       * If the event is 'error', and an AbortSignal was provided for the stream,
       * and there are no listeners, then the event is ignored, matching the
       * behavior of node core streams in the presense of an AbortSignal.
       *
       * If the event is 'finish' or 'prefinish', then all listeners will be
       * removed after emitting the event, to prevent double-firing.
       */
      emit(ev, ...args) {
        const data3 = args[0];
        if (ev !== "error" && ev !== "close" && ev !== DESTROYED && this[DESTROYED]) {
          return false;
        } else if (ev === "data") {
          return !this[OBJECTMODE] && !data3 ? false : this[ASYNC] ? (defer(() => this[EMITDATA](data3)), true) : this[EMITDATA](data3);
        } else if (ev === "end") {
          return this[EMITEND]();
        } else if (ev === "close") {
          this[CLOSED] = true;
          if (!this[EMITTED_END] && !this[DESTROYED])
            return false;
          const ret2 = super.emit("close");
          this.removeAllListeners("close");
          return ret2;
        } else if (ev === "error") {
          this[EMITTED_ERROR] = data3;
          super.emit(ERROR, data3);
          const ret2 = !this[SIGNAL] || this.listeners("error").length ? super.emit("error", data3) : false;
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "resume") {
          const ret2 = super.emit("resume");
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "finish" || ev === "prefinish") {
          const ret2 = super.emit(ev);
          this.removeAllListeners(ev);
          return ret2;
        }
        const ret = super.emit(ev, ...args);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITDATA](data3) {
        for (const p13 of this[PIPES]) {
          if (p13.dest.write(data3) === false)
            this.pause();
        }
        const ret = this[DISCARDED] ? false : super.emit("data", data3);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITEND]() {
        if (this[EMITTED_END])
          return false;
        this[EMITTED_END] = true;
        this.readable = false;
        return this[ASYNC] ? (defer(() => this[EMITEND2]()), true) : this[EMITEND2]();
      }
      [EMITEND2]() {
        if (this[DECODER]) {
          const data3 = this[DECODER].end();
          if (data3) {
            for (const p13 of this[PIPES]) {
              p13.dest.write(data3);
            }
            if (!this[DISCARDED])
              super.emit("data", data3);
          }
        }
        for (const p13 of this[PIPES]) {
          p13.end();
        }
        const ret = super.emit("end");
        this.removeAllListeners("end");
        return ret;
      }
      /**
       * Return a Promise that resolves to an array of all emitted data once
       * the stream ends.
       */
      async collect() {
        const buf = Object.assign([], {
          dataLength: 0
        });
        if (!this[OBJECTMODE])
          buf.dataLength = 0;
        const p13 = this.promise();
        this.on("data", (c13) => {
          buf.push(c13);
          if (!this[OBJECTMODE])
            buf.dataLength += c13.length;
        });
        await p13;
        return buf;
      }
      /**
       * Return a Promise that resolves to the concatenation of all emitted data
       * once the stream ends.
       *
       * Not allowed on objectMode streams.
       */
      async concat() {
        if (this[OBJECTMODE]) {
          throw new Error("cannot concat in objectMode");
        }
        const buf = await this.collect();
        return this[ENCODING] ? buf.join("") : Buffer.concat(buf, buf.dataLength);
      }
      /**
       * Return a void Promise that resolves once the stream ends.
       */
      async promise() {
        return new Promise((resolve16, reject) => {
          this.on(DESTROYED, () => reject(new Error("stream destroyed")));
          this.on("error", (er) => reject(er));
          this.on("end", () => resolve16());
        });
      }
      /**
       * Asynchronous `for await of` iteration.
       *
       * This will continue emitting all chunks until the stream terminates.
       */
      [Symbol.asyncIterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = /* @__PURE__ */ __name(async () => {
          this.pause();
          stopped = true;
          return { value: void 0, done: true };
        }, "stop");
        const next = /* @__PURE__ */ __name(() => {
          if (stopped)
            return stop();
          const res = this.read();
          if (res !== null)
            return Promise.resolve({ done: false, value: res });
          if (this[EOF])
            return stop();
          let resolve16;
          let reject;
          const onerr = /* @__PURE__ */ __name((er) => {
            this.off("data", ondata);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            stop();
            reject(er);
          }, "onerr");
          const ondata = /* @__PURE__ */ __name((value) => {
            this.off("error", onerr);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            this.pause();
            resolve16({ value, done: !!this[EOF] });
          }, "ondata");
          const onend = /* @__PURE__ */ __name(() => {
            this.off("error", onerr);
            this.off("data", ondata);
            this.off(DESTROYED, ondestroy);
            stop();
            resolve16({ done: true, value: void 0 });
          }, "onend");
          const ondestroy = /* @__PURE__ */ __name(() => onerr(new Error("stream destroyed")), "ondestroy");
          return new Promise((res2, rej) => {
            reject = rej;
            resolve16 = res2;
            this.once(DESTROYED, ondestroy);
            this.once("error", onerr);
            this.once("end", onend);
            this.once("data", ondata);
          });
        }, "next");
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.asyncIterator]() {
            return this;
          }
        };
      }
      /**
       * Synchronous `for of` iteration.
       *
       * The iteration will terminate when the internal buffer runs out, even
       * if the stream has not yet terminated.
       */
      [Symbol.iterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = /* @__PURE__ */ __name(() => {
          this.pause();
          this.off(ERROR, stop);
          this.off(DESTROYED, stop);
          this.off("end", stop);
          stopped = true;
          return { done: true, value: void 0 };
        }, "stop");
        const next = /* @__PURE__ */ __name(() => {
          if (stopped)
            return stop();
          const value = this.read();
          return value === null ? stop() : { done: false, value };
        }, "next");
        this.once("end", stop);
        this.once(ERROR, stop);
        this.once(DESTROYED, stop);
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.iterator]() {
            return this;
          }
        };
      }
      /**
       * Destroy a stream, preventing it from being used for any further purpose.
       *
       * If the stream has a `close()` method, then it will be called on
       * destruction.
       *
       * After destruction, any attempt to write data, read data, or emit most
       * events will be ignored.
       *
       * If an error argument is provided, then it will be emitted in an
       * 'error' event.
       */
      destroy(er) {
        if (this[DESTROYED]) {
          if (er)
            this.emit("error", er);
          else
            this.emit(DESTROYED);
          return this;
        }
        this[DESTROYED] = true;
        this[DISCARDED] = true;
        this[BUFFER].length = 0;
        this[BUFFERLENGTH] = 0;
        const wc = this;
        if (typeof wc.close === "function" && !this[CLOSED])
          wc.close();
        if (er)
          this.emit("error", er);
        else
          this.emit(DESTROYED);
        return this;
      }
      /**
       * Alias for {@link isStream}
       *
       * Former export location, maintained for backwards compatibility.
       *
       * @deprecated
       */
      static get isStream() {
        return isStream;
      }
    };
  }
});

// ../../node_modules/glob/node_modules/path-scurry/dist/esm/index.js
var import_node_path, import_node_url, import_fs, actualFS, import_promises, realpathSync2, defaultFS, fsFromOption, uncDriveRegexp, uncToDrive, eitherSep, UNKNOWN, IFIFO, IFCHR, IFDIR, IFBLK, IFREG, IFLNK, IFSOCK, IFMT, IFMT_UNKNOWN, READDIR_CALLED, LSTAT_CALLED, ENOTDIR, ENOENT, ENOREADLINK, ENOREALPATH, ENOCHILD, TYPEMASK, entToType, normalizeCache, normalize, normalizeNocaseCache, normalizeNocase, ResolveCache, ChildrenCache, setAsCwd, PathBase, PathWin32, PathPosix, PathScurryBase, PathScurryWin32, PathScurryPosix, PathScurryDarwin, Path, PathScurry;
var init_esm6 = __esm({
  "../../node_modules/glob/node_modules/path-scurry/dist/esm/index.js"() {
    init_esm4();
    import_node_path = require("node:path");
    import_node_url = require("node:url");
    import_fs = require("fs");
    actualFS = __toESM(require("node:fs"), 1);
    import_promises = require("node:fs/promises");
    init_esm5();
    realpathSync2 = import_fs.realpathSync.native;
    defaultFS = {
      lstatSync: import_fs.lstatSync,
      readdir: import_fs.readdir,
      readdirSync: import_fs.readdirSync,
      readlinkSync: import_fs.readlinkSync,
      realpathSync: realpathSync2,
      promises: {
        lstat: import_promises.lstat,
        readdir: import_promises.readdir,
        readlink: import_promises.readlink,
        realpath: import_promises.realpath
      }
    };
    fsFromOption = /* @__PURE__ */ __name((fsOption) => !fsOption || fsOption === defaultFS || fsOption === actualFS ? defaultFS : {
      ...defaultFS,
      ...fsOption,
      promises: {
        ...defaultFS.promises,
        ...fsOption.promises || {}
      }
    }, "fsFromOption");
    uncDriveRegexp = /^\\\\\?\\([a-z]:)\\?$/i;
    uncToDrive = /* @__PURE__ */ __name((rootPath) => rootPath.replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\"), "uncToDrive");
    eitherSep = /[\\\/]/;
    UNKNOWN = 0;
    IFIFO = 1;
    IFCHR = 2;
    IFDIR = 4;
    IFBLK = 6;
    IFREG = 8;
    IFLNK = 10;
    IFSOCK = 12;
    IFMT = 15;
    IFMT_UNKNOWN = ~IFMT;
    READDIR_CALLED = 16;
    LSTAT_CALLED = 32;
    ENOTDIR = 64;
    ENOENT = 128;
    ENOREADLINK = 256;
    ENOREALPATH = 512;
    ENOCHILD = ENOTDIR | ENOENT | ENOREALPATH;
    TYPEMASK = 1023;
    entToType = /* @__PURE__ */ __name((s13) => s13.isFile() ? IFREG : s13.isDirectory() ? IFDIR : s13.isSymbolicLink() ? IFLNK : s13.isCharacterDevice() ? IFCHR : s13.isBlockDevice() ? IFBLK : s13.isSocket() ? IFSOCK : s13.isFIFO() ? IFIFO : UNKNOWN, "entToType");
    normalizeCache = new LRUCache({ max: 2 ** 12 });
    normalize = /* @__PURE__ */ __name((s13) => {
      const c13 = normalizeCache.get(s13);
      if (c13)
        return c13;
      const n13 = s13.normalize("NFKD");
      normalizeCache.set(s13, n13);
      return n13;
    }, "normalize");
    normalizeNocaseCache = new LRUCache({ max: 2 ** 12 });
    normalizeNocase = /* @__PURE__ */ __name((s13) => {
      const c13 = normalizeNocaseCache.get(s13);
      if (c13)
        return c13;
      const n13 = normalize(s13.toLowerCase());
      normalizeNocaseCache.set(s13, n13);
      return n13;
    }, "normalizeNocase");
    ResolveCache = class extends LRUCache {
      static {
        __name(this, "ResolveCache");
      }
      constructor() {
        super({ max: 256 });
      }
    };
    ChildrenCache = class extends LRUCache {
      static {
        __name(this, "ChildrenCache");
      }
      constructor(maxSize = 16 * 1024) {
        super({
          maxSize,
          // parent + children
          sizeCalculation: /* @__PURE__ */ __name((a13) => a13.length + 1, "sizeCalculation")
        });
      }
    };
    setAsCwd = /* @__PURE__ */ Symbol("PathScurry setAsCwd");
    PathBase = class {
      static {
        __name(this, "PathBase");
      }
      /**
       * the basename of this path
       *
       * **Important**: *always* test the path name against any test string
       * usingthe {@link isNamed} method, and not by directly comparing this
       * string. Otherwise, unicode path strings that the system sees as identical
       * will not be properly treated as the same path, leading to incorrect
       * behavior and possible security issues.
       */
      name;
      /**
       * the Path entry corresponding to the path root.
       *
       * @internal
       */
      root;
      /**
       * All roots found within the current PathScurry family
       *
       * @internal
       */
      roots;
      /**
       * a reference to the parent path, or undefined in the case of root entries
       *
       * @internal
       */
      parent;
      /**
       * boolean indicating whether paths are compared case-insensitively
       * @internal
       */
      nocase;
      /**
       * boolean indicating that this path is the current working directory
       * of the PathScurry collection that contains it.
       */
      isCWD = false;
      // potential default fs override
      #fs;
      // Stats fields
      #dev;
      get dev() {
        return this.#dev;
      }
      #mode;
      get mode() {
        return this.#mode;
      }
      #nlink;
      get nlink() {
        return this.#nlink;
      }
      #uid;
      get uid() {
        return this.#uid;
      }
      #gid;
      get gid() {
        return this.#gid;
      }
      #rdev;
      get rdev() {
        return this.#rdev;
      }
      #blksize;
      get blksize() {
        return this.#blksize;
      }
      #ino;
      get ino() {
        return this.#ino;
      }
      #size;
      get size() {
        return this.#size;
      }
      #blocks;
      get blocks() {
        return this.#blocks;
      }
      #atimeMs;
      get atimeMs() {
        return this.#atimeMs;
      }
      #mtimeMs;
      get mtimeMs() {
        return this.#mtimeMs;
      }
      #ctimeMs;
      get ctimeMs() {
        return this.#ctimeMs;
      }
      #birthtimeMs;
      get birthtimeMs() {
        return this.#birthtimeMs;
      }
      #atime;
      get atime() {
        return this.#atime;
      }
      #mtime;
      get mtime() {
        return this.#mtime;
      }
      #ctime;
      get ctime() {
        return this.#ctime;
      }
      #birthtime;
      get birthtime() {
        return this.#birthtime;
      }
      #matchName;
      #depth;
      #fullpath;
      #fullpathPosix;
      #relative;
      #relativePosix;
      #type;
      #children;
      #linkTarget;
      #realpath;
      /**
       * This property is for compatibility with the Dirent class as of
       * Node v20, where Dirent['parentPath'] refers to the path of the
       * directory that was passed to readdir. For root entries, it's the path
       * to the entry itself.
       */
      get parentPath() {
        return (this.parent || this).fullpath();
      }
      /* c8 ignore start */
      /**
       * Deprecated alias for Dirent['parentPath'] Somewhat counterintuitively,
       * this property refers to the *parent* path, not the path object itself.
       *
       * @deprecated
       */
      get path() {
        return this.parentPath;
      }
      /* c8 ignore stop */
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        this.name = name;
        this.#matchName = nocase ? normalizeNocase(name) : normalize(name);
        this.#type = type & TYPEMASK;
        this.nocase = nocase;
        this.roots = roots;
        this.root = root || this;
        this.#children = children;
        this.#fullpath = opts.fullpath;
        this.#relative = opts.relative;
        this.#relativePosix = opts.relativePosix;
        this.parent = opts.parent;
        if (this.parent) {
          this.#fs = this.parent.#fs;
        } else {
          this.#fs = fsFromOption(opts.fs);
        }
      }
      /**
       * Returns the depth of the Path object from its root.
       *
       * For example, a path at `/foo/bar` would have a depth of 2.
       */
      depth() {
        if (this.#depth !== void 0)
          return this.#depth;
        if (!this.parent)
          return this.#depth = 0;
        return this.#depth = this.parent.depth() + 1;
      }
      /**
       * @internal
       */
      childrenCache() {
        return this.#children;
      }
      /**
       * Get the Path object referenced by the string path, resolved from this Path
       */
      resolve(path44) {
        if (!path44) {
          return this;
        }
        const rootPath = this.getRootString(path44);
        const dir = path44.substring(rootPath.length);
        const dirParts = dir.split(this.splitSep);
        const result2 = rootPath ? this.getRoot(rootPath).#resolveParts(dirParts) : this.#resolveParts(dirParts);
        return result2;
      }
      #resolveParts(dirParts) {
        let p13 = this;
        for (const part of dirParts) {
          p13 = p13.child(part);
        }
        return p13;
      }
      /**
       * Returns the cached children Path objects, if still available.  If they
       * have fallen out of the cache, then returns an empty array, and resets the
       * READDIR_CALLED bit, so that future calls to readdir() will require an fs
       * lookup.
       *
       * @internal
       */
      children() {
        const cached4 = this.#children.get(this);
        if (cached4) {
          return cached4;
        }
        const children = Object.assign([], { provisional: 0 });
        this.#children.set(this, children);
        this.#type &= ~READDIR_CALLED;
        return children;
      }
      /**
       * Resolves a path portion and returns or creates the child Path.
       *
       * Returns `this` if pathPart is `''` or `'.'`, or `parent` if pathPart is
       * `'..'`.
       *
       * This should not be called directly.  If `pathPart` contains any path
       * separators, it will lead to unsafe undefined behavior.
       *
       * Use `Path.resolve()` instead.
       *
       * @internal
       */
      child(pathPart, opts) {
        if (pathPart === "" || pathPart === ".") {
          return this;
        }
        if (pathPart === "..") {
          return this.parent || this;
        }
        const children = this.children();
        const name = this.nocase ? normalizeNocase(pathPart) : normalize(pathPart);
        for (const p13 of children) {
          if (p13.#matchName === name) {
            return p13;
          }
        }
        const s13 = this.parent ? this.sep : "";
        const fullpath = this.#fullpath ? this.#fullpath + s13 + pathPart : void 0;
        const pchild = this.newChild(pathPart, UNKNOWN, {
          ...opts,
          parent: this,
          fullpath
        });
        if (!this.canReaddir()) {
          pchild.#type |= ENOENT;
        }
        children.push(pchild);
        return pchild;
      }
      /**
       * The relative path from the cwd. If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpath()
       */
      relative() {
        if (this.isCWD)
          return "";
        if (this.#relative !== void 0) {
          return this.#relative;
        }
        const name = this.name;
        const p13 = this.parent;
        if (!p13) {
          return this.#relative = this.name;
        }
        const pv = p13.relative();
        return pv + (!pv || !p13.parent ? "" : this.sep) + name;
      }
      /**
       * The relative path from the cwd, using / as the path separator.
       * If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpathPosix()
       * On posix systems, this is identical to relative().
       */
      relativePosix() {
        if (this.sep === "/")
          return this.relative();
        if (this.isCWD)
          return "";
        if (this.#relativePosix !== void 0)
          return this.#relativePosix;
        const name = this.name;
        const p13 = this.parent;
        if (!p13) {
          return this.#relativePosix = this.fullpathPosix();
        }
        const pv = p13.relativePosix();
        return pv + (!pv || !p13.parent ? "" : "/") + name;
      }
      /**
       * The fully resolved path string for this Path entry
       */
      fullpath() {
        if (this.#fullpath !== void 0) {
          return this.#fullpath;
        }
        const name = this.name;
        const p13 = this.parent;
        if (!p13) {
          return this.#fullpath = this.name;
        }
        const pv = p13.fullpath();
        const fp = pv + (!p13.parent ? "" : this.sep) + name;
        return this.#fullpath = fp;
      }
      /**
       * On platforms other than windows, this is identical to fullpath.
       *
       * On windows, this is overridden to return the forward-slash form of the
       * full UNC path.
       */
      fullpathPosix() {
        if (this.#fullpathPosix !== void 0)
          return this.#fullpathPosix;
        if (this.sep === "/")
          return this.#fullpathPosix = this.fullpath();
        if (!this.parent) {
          const p14 = this.fullpath().replace(/\\/g, "/");
          if (/^[a-z]:\//i.test(p14)) {
            return this.#fullpathPosix = `//?/${p14}`;
          } else {
            return this.#fullpathPosix = p14;
          }
        }
        const p13 = this.parent;
        const pfpp = p13.fullpathPosix();
        const fpp = pfpp + (!pfpp || !p13.parent ? "" : "/") + this.name;
        return this.#fullpathPosix = fpp;
      }
      /**
       * Is the Path of an unknown type?
       *
       * Note that we might know *something* about it if there has been a previous
       * filesystem operation, for example that it does not exist, or is not a
       * link, or whether it has child entries.
       */
      isUnknown() {
        return (this.#type & IFMT) === UNKNOWN;
      }
      isType(type) {
        return this[`is${type}`]();
      }
      getType() {
        return this.isUnknown() ? "Unknown" : this.isDirectory() ? "Directory" : this.isFile() ? "File" : this.isSymbolicLink() ? "SymbolicLink" : this.isFIFO() ? "FIFO" : this.isCharacterDevice() ? "CharacterDevice" : this.isBlockDevice() ? "BlockDevice" : (
          /* c8 ignore start */
          this.isSocket() ? "Socket" : "Unknown"
        );
      }
      /**
       * Is the Path a regular file?
       */
      isFile() {
        return (this.#type & IFMT) === IFREG;
      }
      /**
       * Is the Path a directory?
       */
      isDirectory() {
        return (this.#type & IFMT) === IFDIR;
      }
      /**
       * Is the path a character device?
       */
      isCharacterDevice() {
        return (this.#type & IFMT) === IFCHR;
      }
      /**
       * Is the path a block device?
       */
      isBlockDevice() {
        return (this.#type & IFMT) === IFBLK;
      }
      /**
       * Is the path a FIFO pipe?
       */
      isFIFO() {
        return (this.#type & IFMT) === IFIFO;
      }
      /**
       * Is the path a socket?
       */
      isSocket() {
        return (this.#type & IFMT) === IFSOCK;
      }
      /**
       * Is the path a symbolic link?
       */
      isSymbolicLink() {
        return (this.#type & IFLNK) === IFLNK;
      }
      /**
       * Return the entry if it has been subject of a successful lstat, or
       * undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* simply
       * mean that we haven't called lstat on it.
       */
      lstatCached() {
        return this.#type & LSTAT_CALLED ? this : void 0;
      }
      /**
       * Return the cached link target if the entry has been the subject of a
       * successful readlink, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readlink() has been called at some point.
       */
      readlinkCached() {
        return this.#linkTarget;
      }
      /**
       * Returns the cached realpath target if the entry has been the subject
       * of a successful realpath, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * realpath() has been called at some point.
       */
      realpathCached() {
        return this.#realpath;
      }
      /**
       * Returns the cached child Path entries array if the entry has been the
       * subject of a successful readdir(), or [] otherwise.
       *
       * Does not read the filesystem, so an empty array *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readdir() has been called recently enough to still be valid.
       */
      readdirCached() {
        const children = this.children();
        return children.slice(0, children.provisional);
      }
      /**
       * Return true if it's worth trying to readlink.  Ie, we don't (yet) have
       * any indication that readlink will definitely fail.
       *
       * Returns false if the path is known to not be a symlink, if a previous
       * readlink failed, or if the entry does not exist.
       */
      canReadlink() {
        if (this.#linkTarget)
          return true;
        if (!this.parent)
          return false;
        const ifmt = this.#type & IFMT;
        return !(ifmt !== UNKNOWN && ifmt !== IFLNK || this.#type & ENOREADLINK || this.#type & ENOENT);
      }
      /**
       * Return true if readdir has previously been successfully called on this
       * path, indicating that cachedReaddir() is likely valid.
       */
      calledReaddir() {
        return !!(this.#type & READDIR_CALLED);
      }
      /**
       * Returns true if the path is known to not exist. That is, a previous lstat
       * or readdir failed to verify its existence when that would have been
       * expected, or a parent entry was marked either enoent or enotdir.
       */
      isENOENT() {
        return !!(this.#type & ENOENT);
      }
      /**
       * Return true if the path is a match for the given path name.  This handles
       * case sensitivity and unicode normalization.
       *
       * Note: even on case-sensitive systems, it is **not** safe to test the
       * equality of the `.name` property to determine whether a given pathname
       * matches, due to unicode normalization mismatches.
       *
       * Always use this method instead of testing the `path.name` property
       * directly.
       */
      isNamed(n13) {
        return !this.nocase ? this.#matchName === normalize(n13) : this.#matchName === normalizeNocase(n13);
      }
      /**
       * Return the Path object corresponding to the target of a symbolic link.
       *
       * If the Path is not a symbolic link, or if the readlink call fails for any
       * reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       */
      async readlink() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = await this.#fs.promises.readlink(this.fullpath());
          const linkTarget = (await this.parent.realpath())?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      /**
       * Synchronous {@link PathBase.readlink}
       */
      readlinkSync() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = this.#fs.readlinkSync(this.fullpath());
          const linkTarget = this.parent.realpathSync()?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      #readdirSuccess(children) {
        this.#type |= READDIR_CALLED;
        for (let p13 = children.provisional; p13 < children.length; p13++) {
          const c13 = children[p13];
          if (c13)
            c13.#markENOENT();
        }
      }
      #markENOENT() {
        if (this.#type & ENOENT)
          return;
        this.#type = (this.#type | ENOENT) & IFMT_UNKNOWN;
        this.#markChildrenENOENT();
      }
      #markChildrenENOENT() {
        const children = this.children();
        children.provisional = 0;
        for (const p13 of children) {
          p13.#markENOENT();
        }
      }
      #markENOREALPATH() {
        this.#type |= ENOREALPATH;
        this.#markENOTDIR();
      }
      // save the information when we know the entry is not a dir
      #markENOTDIR() {
        if (this.#type & ENOTDIR)
          return;
        let t13 = this.#type;
        if ((t13 & IFMT) === IFDIR)
          t13 &= IFMT_UNKNOWN;
        this.#type = t13 | ENOTDIR;
        this.#markChildrenENOENT();
      }
      #readdirFail(code = "") {
        if (code === "ENOTDIR" || code === "EPERM") {
          this.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        } else {
          this.children().provisional = 0;
        }
      }
      #lstatFail(code = "") {
        if (code === "ENOTDIR") {
          const p13 = this.parent;
          p13.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        }
      }
      #readlinkFail(code = "") {
        let ter = this.#type;
        ter |= ENOREADLINK;
        if (code === "ENOENT")
          ter |= ENOENT;
        if (code === "EINVAL" || code === "UNKNOWN") {
          ter &= IFMT_UNKNOWN;
        }
        this.#type = ter;
        if (code === "ENOTDIR" && this.parent) {
          this.parent.#markENOTDIR();
        }
      }
      #readdirAddChild(e13, c13) {
        return this.#readdirMaybePromoteChild(e13, c13) || this.#readdirAddNewChild(e13, c13);
      }
      #readdirAddNewChild(e13, c13) {
        const type = entToType(e13);
        const child = this.newChild(e13.name, type, { parent: this });
        const ifmt = child.#type & IFMT;
        if (ifmt !== IFDIR && ifmt !== IFLNK && ifmt !== UNKNOWN) {
          child.#type |= ENOTDIR;
        }
        c13.unshift(child);
        c13.provisional++;
        return child;
      }
      #readdirMaybePromoteChild(e13, c13) {
        for (let p13 = c13.provisional; p13 < c13.length; p13++) {
          const pchild = c13[p13];
          const name = this.nocase ? normalizeNocase(e13.name) : normalize(e13.name);
          if (name !== pchild.#matchName) {
            continue;
          }
          return this.#readdirPromoteChild(e13, pchild, p13, c13);
        }
      }
      #readdirPromoteChild(e13, p13, index, c13) {
        const v14 = p13.name;
        p13.#type = p13.#type & IFMT_UNKNOWN | entToType(e13);
        if (v14 !== e13.name)
          p13.name = e13.name;
        if (index !== c13.provisional) {
          if (index === c13.length - 1)
            c13.pop();
          else
            c13.splice(index, 1);
          c13.unshift(p13);
        }
        c13.provisional++;
        return p13;
      }
      /**
       * Call lstat() on this Path, and update all known information that can be
       * determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(await this.#fs.promises.lstat(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      /**
       * synchronous {@link PathBase.lstat}
       */
      lstatSync() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(this.#fs.lstatSync(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      #applyStat(st) {
        const { atime, atimeMs, birthtime, birthtimeMs, blksize, blocks, ctime, ctimeMs, dev, gid, ino, mode, mtime, mtimeMs, nlink, rdev, size, uid } = st;
        this.#atime = atime;
        this.#atimeMs = atimeMs;
        this.#birthtime = birthtime;
        this.#birthtimeMs = birthtimeMs;
        this.#blksize = blksize;
        this.#blocks = blocks;
        this.#ctime = ctime;
        this.#ctimeMs = ctimeMs;
        this.#dev = dev;
        this.#gid = gid;
        this.#ino = ino;
        this.#mode = mode;
        this.#mtime = mtime;
        this.#mtimeMs = mtimeMs;
        this.#nlink = nlink;
        this.#rdev = rdev;
        this.#size = size;
        this.#uid = uid;
        const ifmt = entToType(st);
        this.#type = this.#type & IFMT_UNKNOWN | ifmt | LSTAT_CALLED;
        if (ifmt !== UNKNOWN && ifmt !== IFDIR && ifmt !== IFLNK) {
          this.#type |= ENOTDIR;
        }
      }
      #onReaddirCB = [];
      #readdirCBInFlight = false;
      #callOnReaddirCB(children) {
        this.#readdirCBInFlight = false;
        const cbs = this.#onReaddirCB.slice();
        this.#onReaddirCB.length = 0;
        cbs.forEach((cb) => cb(null, children));
      }
      /**
       * Standard node-style callback interface to get list of directory entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       *
       * @param cb The callback called with (er, entries).  Note that the `er`
       * param is somewhat extraneous, as all readdir() errors are handled and
       * simply result in an empty set of entries being returned.
       * @param allowZalgo Boolean indicating that immediately known results should
       * *not* be deferred with `queueMicrotask`. Defaults to `false`. Release
       * zalgo at your peril, the dark pony lord is devious and unforgiving.
       */
      readdirCB(cb, allowZalgo = false) {
        if (!this.canReaddir()) {
          if (allowZalgo)
            cb(null, []);
          else
            queueMicrotask(() => cb(null, []));
          return;
        }
        const children = this.children();
        if (this.calledReaddir()) {
          const c13 = children.slice(0, children.provisional);
          if (allowZalgo)
            cb(null, c13);
          else
            queueMicrotask(() => cb(null, c13));
          return;
        }
        this.#onReaddirCB.push(cb);
        if (this.#readdirCBInFlight) {
          return;
        }
        this.#readdirCBInFlight = true;
        const fullpath = this.fullpath();
        this.#fs.readdir(fullpath, { withFileTypes: true }, (er, entries) => {
          if (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          } else {
            for (const e13 of entries) {
              this.#readdirAddChild(e13, children);
            }
            this.#readdirSuccess(children);
          }
          this.#callOnReaddirCB(children.slice(0, children.provisional));
          return;
        });
      }
      #asyncReaddirInFlight;
      /**
       * Return an array of known child entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async readdir() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        if (this.#asyncReaddirInFlight) {
          await this.#asyncReaddirInFlight;
        } else {
          let resolve16 = /* @__PURE__ */ __name(() => {
          }, "resolve");
          this.#asyncReaddirInFlight = new Promise((res) => resolve16 = res);
          try {
            for (const e13 of await this.#fs.promises.readdir(fullpath, {
              withFileTypes: true
            })) {
              this.#readdirAddChild(e13, children);
            }
            this.#readdirSuccess(children);
          } catch (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          }
          this.#asyncReaddirInFlight = void 0;
          resolve16();
        }
        return children.slice(0, children.provisional);
      }
      /**
       * synchronous {@link PathBase.readdir}
       */
      readdirSync() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        try {
          for (const e13 of this.#fs.readdirSync(fullpath, {
            withFileTypes: true
          })) {
            this.#readdirAddChild(e13, children);
          }
          this.#readdirSuccess(children);
        } catch (er) {
          this.#readdirFail(er.code);
          children.provisional = 0;
        }
        return children.slice(0, children.provisional);
      }
      canReaddir() {
        if (this.#type & ENOCHILD)
          return false;
        const ifmt = IFMT & this.#type;
        if (!(ifmt === UNKNOWN || ifmt === IFDIR || ifmt === IFLNK)) {
          return false;
        }
        return true;
      }
      shouldWalk(dirs, walkFilter) {
        return (this.#type & IFDIR) === IFDIR && !(this.#type & ENOCHILD) && !dirs.has(this) && (!walkFilter || walkFilter(this));
      }
      /**
       * Return the Path object corresponding to path as resolved
       * by realpath(3).
       *
       * If the realpath call fails for any reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       * On success, returns a Path object.
       */
      async realpath() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = await this.#fs.promises.realpath(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_2) {
          this.#markENOREALPATH();
        }
      }
      /**
       * Synchronous {@link realpath}
       */
      realpathSync() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = this.#fs.realpathSync(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_2) {
          this.#markENOREALPATH();
        }
      }
      /**
       * Internal method to mark this Path object as the scurry cwd,
       * called by {@link PathScurry#chdir}
       *
       * @internal
       */
      [setAsCwd](oldCwd) {
        if (oldCwd === this)
          return;
        oldCwd.isCWD = false;
        this.isCWD = true;
        const changed = /* @__PURE__ */ new Set([]);
        let rp = [];
        let p13 = this;
        while (p13 && p13.parent) {
          changed.add(p13);
          p13.#relative = rp.join(this.sep);
          p13.#relativePosix = rp.join("/");
          p13 = p13.parent;
          rp.push("..");
        }
        p13 = oldCwd;
        while (p13 && p13.parent && !changed.has(p13)) {
          p13.#relative = void 0;
          p13.#relativePosix = void 0;
          p13 = p13.parent;
        }
      }
    };
    PathWin32 = class _PathWin32 extends PathBase {
      static {
        __name(this, "PathWin32");
      }
      /**
       * Separator for generating path strings.
       */
      sep = "\\";
      /**
       * Separator for parsing path strings.
       */
      splitSep = eitherSep;
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      newChild(name, type = UNKNOWN, opts = {}) {
        return new _PathWin32(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
      /**
       * @internal
       */
      getRootString(path44) {
        return import_node_path.win32.parse(path44).root;
      }
      /**
       * @internal
       */
      getRoot(rootPath) {
        rootPath = uncToDrive(rootPath.toUpperCase());
        if (rootPath === this.root.name) {
          return this.root;
        }
        for (const [compare2, root] of Object.entries(this.roots)) {
          if (this.sameRoot(rootPath, compare2)) {
            return this.roots[rootPath] = root;
          }
        }
        return this.roots[rootPath] = new PathScurryWin32(rootPath, this).root;
      }
      /**
       * @internal
       */
      sameRoot(rootPath, compare2 = this.root.name) {
        rootPath = rootPath.toUpperCase().replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
        return rootPath === compare2;
      }
    };
    PathPosix = class _PathPosix extends PathBase {
      static {
        __name(this, "PathPosix");
      }
      /**
       * separator for parsing path strings
       */
      splitSep = "/";
      /**
       * separator for generating path strings
       */
      sep = "/";
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      getRootString(path44) {
        return path44.startsWith("/") ? "/" : "";
      }
      /**
       * @internal
       */
      getRoot(_rootPath) {
        return this.root;
      }
      /**
       * @internal
       */
      newChild(name, type = UNKNOWN, opts = {}) {
        return new _PathPosix(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
    };
    PathScurryBase = class {
      static {
        __name(this, "PathScurryBase");
      }
      /**
       * The root Path entry for the current working directory of this Scurry
       */
      root;
      /**
       * The string path for the root of this Scurry's current working directory
       */
      rootPath;
      /**
       * A collection of all roots encountered, referenced by rootPath
       */
      roots;
      /**
       * The Path entry corresponding to this PathScurry's current working directory.
       */
      cwd;
      #resolveCache;
      #resolvePosixCache;
      #children;
      /**
       * Perform path comparisons case-insensitively.
       *
       * Defaults true on Darwin and Windows systems, false elsewhere.
       */
      nocase;
      #fs;
      /**
       * This class should not be instantiated directly.
       *
       * Use PathScurryWin32, PathScurryDarwin, PathScurryPosix, or PathScurry
       *
       * @internal
       */
      constructor(cwd = process.cwd(), pathImpl, sep5, { nocase, childrenCacheSize = 16 * 1024, fs: fs47 = defaultFS } = {}) {
        this.#fs = fsFromOption(fs47);
        if (cwd instanceof URL || cwd.startsWith("file://")) {
          cwd = (0, import_node_url.fileURLToPath)(cwd);
        }
        const cwdPath = pathImpl.resolve(cwd);
        this.roots = /* @__PURE__ */ Object.create(null);
        this.rootPath = this.parseRootPath(cwdPath);
        this.#resolveCache = new ResolveCache();
        this.#resolvePosixCache = new ResolveCache();
        this.#children = new ChildrenCache(childrenCacheSize);
        const split2 = cwdPath.substring(this.rootPath.length).split(sep5);
        if (split2.length === 1 && !split2[0]) {
          split2.pop();
        }
        if (nocase === void 0) {
          throw new TypeError("must provide nocase setting to PathScurryBase ctor");
        }
        this.nocase = nocase;
        this.root = this.newRoot(this.#fs);
        this.roots[this.rootPath] = this.root;
        let prev = this.root;
        let len = split2.length - 1;
        const joinSep = pathImpl.sep;
        let abs = this.rootPath;
        let sawFirst = false;
        for (const part of split2) {
          const l13 = len--;
          prev = prev.child(part, {
            relative: new Array(l13).fill("..").join(joinSep),
            relativePosix: new Array(l13).fill("..").join("/"),
            fullpath: abs += (sawFirst ? "" : joinSep) + part
          });
          sawFirst = true;
        }
        this.cwd = prev;
      }
      /**
       * Get the depth of a provided path, string, or the cwd
       */
      depth(path44 = this.cwd) {
        if (typeof path44 === "string") {
          path44 = this.cwd.resolve(path44);
        }
        return path44.depth();
      }
      /**
       * Return the cache of child entries.  Exposed so subclasses can create
       * child Path objects in a platform-specific way.
       *
       * @internal
       */
      childrenCache() {
        return this.#children;
      }
      /**
       * Resolve one or more path strings to a resolved string
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolve(...paths) {
        let r13 = "";
        for (let i13 = paths.length - 1; i13 >= 0; i13--) {
          const p13 = paths[i13];
          if (!p13 || p13 === ".")
            continue;
          r13 = r13 ? `${p13}/${r13}` : p13;
          if (this.isAbsolute(p13)) {
            break;
          }
        }
        const cached4 = this.#resolveCache.get(r13);
        if (cached4 !== void 0) {
          return cached4;
        }
        const result2 = this.cwd.resolve(r13).fullpath();
        this.#resolveCache.set(r13, result2);
        return result2;
      }
      /**
       * Resolve one or more path strings to a resolved string, returning
       * the posix path.  Identical to .resolve() on posix systems, but on
       * windows will return a forward-slash separated UNC path.
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolvePosix(...paths) {
        let r13 = "";
        for (let i13 = paths.length - 1; i13 >= 0; i13--) {
          const p13 = paths[i13];
          if (!p13 || p13 === ".")
            continue;
          r13 = r13 ? `${p13}/${r13}` : p13;
          if (this.isAbsolute(p13)) {
            break;
          }
        }
        const cached4 = this.#resolvePosixCache.get(r13);
        if (cached4 !== void 0) {
          return cached4;
        }
        const result2 = this.cwd.resolve(r13).fullpathPosix();
        this.#resolvePosixCache.set(r13, result2);
        return result2;
      }
      /**
       * find the relative path from the cwd to the supplied path string or entry
       */
      relative(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relative();
      }
      /**
       * find the relative path from the cwd to the supplied path string or
       * entry, using / as the path delimiter, even on Windows.
       */
      relativePosix(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relativePosix();
      }
      /**
       * Return the basename for the provided string or Path object
       */
      basename(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.name;
      }
      /**
       * Return the dirname for the provided string or Path object
       */
      dirname(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return (entry.parent || entry).fullpath();
      }
      async readdir(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else {
          const p13 = await entry.readdir();
          return withFileTypes ? p13 : p13.map((e13) => e13.name);
        }
      }
      readdirSync(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else if (withFileTypes) {
          return entry.readdirSync();
        } else {
          return entry.readdirSync().map((e13) => e13.name);
        }
      }
      /**
       * Call lstat() on the string or Path object, and update all known
       * information that can be determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstat();
      }
      /**
       * synchronous {@link PathScurryBase.lstat}
       */
      lstatSync(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstatSync();
      }
      async readlink(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e13 = await entry.readlink();
        return withFileTypes ? e13 : e13?.fullpath();
      }
      readlinkSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e13 = entry.readlinkSync();
        return withFileTypes ? e13 : e13?.fullpath();
      }
      async realpath(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e13 = await entry.realpath();
        return withFileTypes ? e13 : e13?.fullpath();
      }
      realpathSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e13 = entry.realpathSync();
        return withFileTypes ? e13 : e13?.fullpath();
      }
      async walk(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = [];
        if (!filter4 || filter4(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const walk = /* @__PURE__ */ __name((dir, cb) => {
          dirs.add(dir);
          dir.readdirCB((er, entries) => {
            if (er) {
              return cb(er);
            }
            let len = entries.length;
            if (!len)
              return cb();
            const next = /* @__PURE__ */ __name(() => {
              if (--len === 0) {
                cb();
              }
            }, "next");
            for (const e13 of entries) {
              if (!filter4 || filter4(e13)) {
                results.push(withFileTypes ? e13 : e13.fullpath());
              }
              if (follow && e13.isSymbolicLink()) {
                e13.realpath().then((r13) => r13?.isUnknown() ? r13.lstat() : r13).then((r13) => r13?.shouldWalk(dirs, walkFilter) ? walk(r13, next) : next());
              } else {
                if (e13.shouldWalk(dirs, walkFilter)) {
                  walk(e13, next);
                } else {
                  next();
                }
              }
            }
          }, true);
        }, "walk");
        const start = entry;
        return new Promise((res, rej) => {
          walk(start, (er) => {
            if (er)
              return rej(er);
            res(results);
          });
        });
      }
      walkSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = [];
        if (!filter4 || filter4(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e13 of entries) {
            if (!filter4 || filter4(e13)) {
              results.push(withFileTypes ? e13 : e13.fullpath());
            }
            let r13 = e13;
            if (e13.isSymbolicLink()) {
              if (!(follow && (r13 = e13.realpathSync())))
                continue;
              if (r13.isUnknown())
                r13.lstatSync();
            }
            if (r13.shouldWalk(dirs, walkFilter)) {
              dirs.add(r13);
            }
          }
        }
        return results;
      }
      /**
       * Support for `for await`
       *
       * Alias for {@link PathScurryBase.iterate}
       *
       * Note: As of Node 19, this is very slow, compared to other methods of
       * walking.  Consider using {@link PathScurryBase.stream} if memory overhead
       * and backpressure are concerns, or {@link PathScurryBase.walk} if not.
       */
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
      iterate(entry = this.cwd, options = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          options = entry;
          entry = this.cwd;
        }
        return this.stream(entry, options)[Symbol.asyncIterator]();
      }
      /**
       * Iterating over a PathScurry performs a synchronous walk.
       *
       * Alias for {@link PathScurryBase.iterateSync}
       */
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      *iterateSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        if (!filter4 || filter4(entry)) {
          yield withFileTypes ? entry : entry.fullpath();
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e13 of entries) {
            if (!filter4 || filter4(e13)) {
              yield withFileTypes ? e13 : e13.fullpath();
            }
            let r13 = e13;
            if (e13.isSymbolicLink()) {
              if (!(follow && (r13 = e13.realpathSync())))
                continue;
              if (r13.isUnknown())
                r13.lstatSync();
            }
            if (r13.shouldWalk(dirs, walkFilter)) {
              dirs.add(r13);
            }
          }
        }
      }
      stream(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = new Minipass({ objectMode: true });
        if (!filter4 || filter4(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const queue = [entry];
        let processing = 0;
        const process3 = /* @__PURE__ */ __name(() => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const onReaddir = /* @__PURE__ */ __name((er, entries, didRealpaths = false) => {
              if (er)
                return results.emit("error", er);
              if (follow && !didRealpaths) {
                const promises3 = [];
                for (const e13 of entries) {
                  if (e13.isSymbolicLink()) {
                    promises3.push(e13.realpath().then((r13) => r13?.isUnknown() ? r13.lstat() : r13));
                  }
                }
                if (promises3.length) {
                  Promise.all(promises3).then(() => onReaddir(null, entries, true));
                  return;
                }
              }
              for (const e13 of entries) {
                if (e13 && (!filter4 || filter4(e13))) {
                  if (!results.write(withFileTypes ? e13 : e13.fullpath())) {
                    paused = true;
                  }
                }
              }
              processing--;
              for (const e13 of entries) {
                const r13 = e13.realpathCached() || e13;
                if (r13.shouldWalk(dirs, walkFilter)) {
                  queue.push(r13);
                }
              }
              if (paused && !results.flowing) {
                results.once("drain", process3);
              } else if (!sync2) {
                process3();
              }
            }, "onReaddir");
            let sync2 = true;
            dir.readdirCB(onReaddir, true);
            sync2 = false;
          }
        }, "process");
        process3();
        return results;
      }
      streamSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = new Minipass({ objectMode: true });
        const dirs = /* @__PURE__ */ new Set();
        if (!filter4 || filter4(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const queue = [entry];
        let processing = 0;
        const process3 = /* @__PURE__ */ __name(() => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const entries = dir.readdirSync();
            for (const e13 of entries) {
              if (!filter4 || filter4(e13)) {
                if (!results.write(withFileTypes ? e13 : e13.fullpath())) {
                  paused = true;
                }
              }
            }
            processing--;
            for (const e13 of entries) {
              let r13 = e13;
              if (e13.isSymbolicLink()) {
                if (!(follow && (r13 = e13.realpathSync())))
                  continue;
                if (r13.isUnknown())
                  r13.lstatSync();
              }
              if (r13.shouldWalk(dirs, walkFilter)) {
                queue.push(r13);
              }
            }
          }
          if (paused && !results.flowing)
            results.once("drain", process3);
        }, "process");
        process3();
        return results;
      }
      chdir(path44 = this.cwd) {
        const oldCwd = this.cwd;
        this.cwd = typeof path44 === "string" ? this.cwd.resolve(path44) : path44;
        this.cwd[setAsCwd](oldCwd);
      }
    };
    PathScurryWin32 = class extends PathScurryBase {
      static {
        __name(this, "PathScurryWin32");
      }
      /**
       * separator for generating path strings
       */
      sep = "\\";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, import_node_path.win32, "\\", { ...opts, nocase });
        this.nocase = nocase;
        for (let p13 = this.cwd; p13; p13 = p13.parent) {
          p13.nocase = this.nocase;
        }
      }
      /**
       * @internal
       */
      parseRootPath(dir) {
        return import_node_path.win32.parse(dir).root.toUpperCase();
      }
      /**
       * @internal
       */
      newRoot(fs47) {
        return new PathWin32(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs47 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p13) {
        return p13.startsWith("/") || p13.startsWith("\\") || /^[a-z]:(\/|\\)/i.test(p13);
      }
    };
    PathScurryPosix = class extends PathScurryBase {
      static {
        __name(this, "PathScurryPosix");
      }
      /**
       * separator for generating path strings
       */
      sep = "/";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = false } = opts;
        super(cwd, import_node_path.posix, "/", { ...opts, nocase });
        this.nocase = nocase;
      }
      /**
       * @internal
       */
      parseRootPath(_dir) {
        return "/";
      }
      /**
       * @internal
       */
      newRoot(fs47) {
        return new PathPosix(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs47 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p13) {
        return p13.startsWith("/");
      }
    };
    PathScurryDarwin = class extends PathScurryPosix {
      static {
        __name(this, "PathScurryDarwin");
      }
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, { ...opts, nocase });
      }
    };
    Path = process.platform === "win32" ? PathWin32 : PathPosix;
    PathScurry = process.platform === "win32" ? PathScurryWin32 : process.platform === "darwin" ? PathScurryDarwin : PathScurryPosix;
  }
});

// ../../node_modules/glob/dist/esm/pattern.js
var isPatternList, isGlobList, Pattern;
var init_pattern = __esm({
  "../../node_modules/glob/dist/esm/pattern.js"() {
    init_esm3();
    isPatternList = /* @__PURE__ */ __name((pl2) => pl2.length >= 1, "isPatternList");
    isGlobList = /* @__PURE__ */ __name((gl) => gl.length >= 1, "isGlobList");
    Pattern = class _Pattern {
      static {
        __name(this, "Pattern");
      }
      #patternList;
      #globList;
      #index;
      length;
      #platform;
      #rest;
      #globString;
      #isDrive;
      #isUNC;
      #isAbsolute;
      #followGlobstar = true;
      constructor(patternList, globList, index, platform3) {
        if (!isPatternList(patternList)) {
          throw new TypeError("empty pattern list");
        }
        if (!isGlobList(globList)) {
          throw new TypeError("empty glob list");
        }
        if (globList.length !== patternList.length) {
          throw new TypeError("mismatched pattern list and glob list lengths");
        }
        this.length = patternList.length;
        if (index < 0 || index >= this.length) {
          throw new TypeError("index out of range");
        }
        this.#patternList = patternList;
        this.#globList = globList;
        this.#index = index;
        this.#platform = platform3;
        if (this.#index === 0) {
          if (this.isUNC()) {
            const [p0, p1, p22, p32, ...prest] = this.#patternList;
            const [g0, g1, g22, g32, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p13 = [p0, p1, p22, p32, ""].join("/");
            const g13 = [g0, g1, g22, g32, ""].join("/");
            this.#patternList = [p13, ...prest];
            this.#globList = [g13, ...grest];
            this.length = this.#patternList.length;
          } else if (this.isDrive() || this.isAbsolute()) {
            const [p1, ...prest] = this.#patternList;
            const [g1, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p13 = p1 + "/";
            const g13 = g1 + "/";
            this.#patternList = [p13, ...prest];
            this.#globList = [g13, ...grest];
            this.length = this.#patternList.length;
          }
        }
      }
      /**
       * The first entry in the parsed list of patterns
       */
      pattern() {
        return this.#patternList[this.#index];
      }
      /**
       * true of if pattern() returns a string
       */
      isString() {
        return typeof this.#patternList[this.#index] === "string";
      }
      /**
       * true of if pattern() returns GLOBSTAR
       */
      isGlobstar() {
        return this.#patternList[this.#index] === GLOBSTAR;
      }
      /**
       * true if pattern() returns a regexp
       */
      isRegExp() {
        return this.#patternList[this.#index] instanceof RegExp;
      }
      /**
       * The /-joined set of glob parts that make up this pattern
       */
      globString() {
        return this.#globString = this.#globString || (this.#index === 0 ? this.isAbsolute() ? this.#globList[0] + this.#globList.slice(1).join("/") : this.#globList.join("/") : this.#globList.slice(this.#index).join("/"));
      }
      /**
       * true if there are more pattern parts after this one
       */
      hasMore() {
        return this.length > this.#index + 1;
      }
      /**
       * The rest of the pattern after this part, or null if this is the end
       */
      rest() {
        if (this.#rest !== void 0)
          return this.#rest;
        if (!this.hasMore())
          return this.#rest = null;
        this.#rest = new _Pattern(this.#patternList, this.#globList, this.#index + 1, this.#platform);
        this.#rest.#isAbsolute = this.#isAbsolute;
        this.#rest.#isUNC = this.#isUNC;
        this.#rest.#isDrive = this.#isDrive;
        return this.#rest;
      }
      /**
       * true if the pattern represents a //unc/path/ on windows
       */
      isUNC() {
        const pl2 = this.#patternList;
        return this.#isUNC !== void 0 ? this.#isUNC : this.#isUNC = this.#platform === "win32" && this.#index === 0 && pl2[0] === "" && pl2[1] === "" && typeof pl2[2] === "string" && !!pl2[2] && typeof pl2[3] === "string" && !!pl2[3];
      }
      // pattern like C:/...
      // split = ['C:', ...]
      // XXX: would be nice to handle patterns like `c:*` to test the cwd
      // in c: for *, but I don't know of a way to even figure out what that
      // cwd is without actually chdir'ing into it?
      /**
       * True if the pattern starts with a drive letter on Windows
       */
      isDrive() {
        const pl2 = this.#patternList;
        return this.#isDrive !== void 0 ? this.#isDrive : this.#isDrive = this.#platform === "win32" && this.#index === 0 && this.length > 1 && typeof pl2[0] === "string" && /^[a-z]:$/i.test(pl2[0]);
      }
      // pattern = '/' or '/...' or '/x/...'
      // split = ['', ''] or ['', ...] or ['', 'x', ...]
      // Drive and UNC both considered absolute on windows
      /**
       * True if the pattern is rooted on an absolute path
       */
      isAbsolute() {
        const pl2 = this.#patternList;
        return this.#isAbsolute !== void 0 ? this.#isAbsolute : this.#isAbsolute = pl2[0] === "" && pl2.length > 1 || this.isDrive() || this.isUNC();
      }
      /**
       * consume the root of the pattern, and return it
       */
      root() {
        const p13 = this.#patternList[0];
        return typeof p13 === "string" && this.isAbsolute() && this.#index === 0 ? p13 : "";
      }
      /**
       * Check to see if the current globstar pattern is allowed to follow
       * a symbolic link.
       */
      checkFollowGlobstar() {
        return !(this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar);
      }
      /**
       * Mark that the current globstar pattern is following a symbolic link
       */
      markFollowGlobstar() {
        if (this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar)
          return false;
        this.#followGlobstar = false;
        return true;
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/ignore.js
var defaultPlatform2, Ignore;
var init_ignore = __esm({
  "../../node_modules/glob/dist/esm/ignore.js"() {
    init_esm3();
    init_pattern();
    defaultPlatform2 = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    Ignore = class {
      static {
        __name(this, "Ignore");
      }
      relative;
      relativeChildren;
      absolute;
      absoluteChildren;
      platform;
      mmopts;
      constructor(ignored, { nobrace, nocase, noext, noglobstar, platform: platform3 = defaultPlatform2 }) {
        this.relative = [];
        this.absolute = [];
        this.relativeChildren = [];
        this.absoluteChildren = [];
        this.platform = platform3;
        this.mmopts = {
          dot: true,
          nobrace,
          nocase,
          noext,
          noglobstar,
          optimizationLevel: 2,
          platform: platform3,
          nocomment: true,
          nonegate: true
        };
        for (const ign of ignored)
          this.add(ign);
      }
      add(ign) {
        const mm = new Minimatch(ign, this.mmopts);
        for (let i13 = 0; i13 < mm.set.length; i13++) {
          const parsed = mm.set[i13];
          const globParts = mm.globParts[i13];
          if (!parsed || !globParts) {
            throw new Error("invalid pattern object");
          }
          while (parsed[0] === "." && globParts[0] === ".") {
            parsed.shift();
            globParts.shift();
          }
          const p13 = new Pattern(parsed, globParts, 0, this.platform);
          const m13 = new Minimatch(p13.globString(), this.mmopts);
          const children = globParts[globParts.length - 1] === "**";
          const absolute = p13.isAbsolute();
          if (absolute)
            this.absolute.push(m13);
          else
            this.relative.push(m13);
          if (children) {
            if (absolute)
              this.absoluteChildren.push(m13);
            else
              this.relativeChildren.push(m13);
          }
        }
      }
      ignored(p13) {
        const fullpath = p13.fullpath();
        const fullpaths = `${fullpath}/`;
        const relative4 = p13.relative() || ".";
        const relatives = `${relative4}/`;
        for (const m13 of this.relative) {
          if (m13.match(relative4) || m13.match(relatives))
            return true;
        }
        for (const m13 of this.absolute) {
          if (m13.match(fullpath) || m13.match(fullpaths))
            return true;
        }
        return false;
      }
      childrenIgnored(p13) {
        const fullpath = p13.fullpath() + "/";
        const relative4 = (p13.relative() || ".") + "/";
        for (const m13 of this.relativeChildren) {
          if (m13.match(relative4))
            return true;
        }
        for (const m13 of this.absoluteChildren) {
          if (m13.match(fullpath))
            return true;
        }
        return false;
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/processor.js
var HasWalkedCache, MatchRecord, SubWalks, Processor;
var init_processor = __esm({
  "../../node_modules/glob/dist/esm/processor.js"() {
    init_esm3();
    HasWalkedCache = class _HasWalkedCache {
      static {
        __name(this, "HasWalkedCache");
      }
      store;
      constructor(store = /* @__PURE__ */ new Map()) {
        this.store = store;
      }
      copy() {
        return new _HasWalkedCache(new Map(this.store));
      }
      hasWalked(target, pattern) {
        return this.store.get(target.fullpath())?.has(pattern.globString());
      }
      storeWalked(target, pattern) {
        const fullpath = target.fullpath();
        const cached4 = this.store.get(fullpath);
        if (cached4)
          cached4.add(pattern.globString());
        else
          this.store.set(fullpath, /* @__PURE__ */ new Set([pattern.globString()]));
      }
    };
    MatchRecord = class {
      static {
        __name(this, "MatchRecord");
      }
      store = /* @__PURE__ */ new Map();
      add(target, absolute, ifDir) {
        const n13 = (absolute ? 2 : 0) | (ifDir ? 1 : 0);
        const current = this.store.get(target);
        this.store.set(target, current === void 0 ? n13 : n13 & current);
      }
      // match, absolute, ifdir
      entries() {
        return [...this.store.entries()].map(([path44, n13]) => [
          path44,
          !!(n13 & 2),
          !!(n13 & 1)
        ]);
      }
    };
    SubWalks = class {
      static {
        __name(this, "SubWalks");
      }
      store = /* @__PURE__ */ new Map();
      add(target, pattern) {
        if (!target.canReaddir()) {
          return;
        }
        const subs = this.store.get(target);
        if (subs) {
          if (!subs.find((p13) => p13.globString() === pattern.globString())) {
            subs.push(pattern);
          }
        } else
          this.store.set(target, [pattern]);
      }
      get(target) {
        const subs = this.store.get(target);
        if (!subs) {
          throw new Error("attempting to walk unknown path");
        }
        return subs;
      }
      entries() {
        return this.keys().map((k13) => [k13, this.store.get(k13)]);
      }
      keys() {
        return [...this.store.keys()].filter((t13) => t13.canReaddir());
      }
    };
    Processor = class _Processor {
      static {
        __name(this, "Processor");
      }
      hasWalkedCache;
      matches = new MatchRecord();
      subwalks = new SubWalks();
      patterns;
      follow;
      dot;
      opts;
      constructor(opts, hasWalkedCache) {
        this.opts = opts;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.hasWalkedCache = hasWalkedCache ? hasWalkedCache.copy() : new HasWalkedCache();
      }
      processPatterns(target, patterns) {
        this.patterns = patterns;
        const processingSet = patterns.map((p13) => [target, p13]);
        for (let [t13, pattern] of processingSet) {
          this.hasWalkedCache.storeWalked(t13, pattern);
          const root = pattern.root();
          const absolute = pattern.isAbsolute() && this.opts.absolute !== false;
          if (root) {
            t13 = t13.resolve(root === "/" && this.opts.root !== void 0 ? this.opts.root : root);
            const rest2 = pattern.rest();
            if (!rest2) {
              this.matches.add(t13, true, false);
              continue;
            } else {
              pattern = rest2;
            }
          }
          if (t13.isENOENT())
            continue;
          let p13;
          let rest;
          let changed = false;
          while (typeof (p13 = pattern.pattern()) === "string" && (rest = pattern.rest())) {
            const c13 = t13.resolve(p13);
            t13 = c13;
            pattern = rest;
            changed = true;
          }
          p13 = pattern.pattern();
          rest = pattern.rest();
          if (changed) {
            if (this.hasWalkedCache.hasWalked(t13, pattern))
              continue;
            this.hasWalkedCache.storeWalked(t13, pattern);
          }
          if (typeof p13 === "string") {
            const ifDir = p13 === ".." || p13 === "" || p13 === ".";
            this.matches.add(t13.resolve(p13), absolute, ifDir);
            continue;
          } else if (p13 === GLOBSTAR) {
            if (!t13.isSymbolicLink() || this.follow || pattern.checkFollowGlobstar()) {
              this.subwalks.add(t13, pattern);
            }
            const rp = rest?.pattern();
            const rrest = rest?.rest();
            if (!rest || (rp === "" || rp === ".") && !rrest) {
              this.matches.add(t13, absolute, rp === "" || rp === ".");
            } else {
              if (rp === "..") {
                const tp = t13.parent || t13;
                if (!rrest)
                  this.matches.add(tp, absolute, true);
                else if (!this.hasWalkedCache.hasWalked(tp, rrest)) {
                  this.subwalks.add(tp, rrest);
                }
              }
            }
          } else if (p13 instanceof RegExp) {
            this.subwalks.add(t13, pattern);
          }
        }
        return this;
      }
      subwalkTargets() {
        return this.subwalks.keys();
      }
      child() {
        return new _Processor(this.opts, this.hasWalkedCache);
      }
      // return a new Processor containing the subwalks for each
      // child entry, and a set of matches, and
      // a hasWalkedCache that's a copy of this one
      // then we're going to call
      filterEntries(parent, entries) {
        const patterns = this.subwalks.get(parent);
        const results = this.child();
        for (const e13 of entries) {
          for (const pattern of patterns) {
            const absolute = pattern.isAbsolute();
            const p13 = pattern.pattern();
            const rest = pattern.rest();
            if (p13 === GLOBSTAR) {
              results.testGlobstar(e13, pattern, rest, absolute);
            } else if (p13 instanceof RegExp) {
              results.testRegExp(e13, p13, rest, absolute);
            } else {
              results.testString(e13, p13, rest, absolute);
            }
          }
        }
        return results;
      }
      testGlobstar(e13, pattern, rest, absolute) {
        if (this.dot || !e13.name.startsWith(".")) {
          if (!pattern.hasMore()) {
            this.matches.add(e13, absolute, false);
          }
          if (e13.canReaddir()) {
            if (this.follow || !e13.isSymbolicLink()) {
              this.subwalks.add(e13, pattern);
            } else if (e13.isSymbolicLink()) {
              if (rest && pattern.checkFollowGlobstar()) {
                this.subwalks.add(e13, rest);
              } else if (pattern.markFollowGlobstar()) {
                this.subwalks.add(e13, pattern);
              }
            }
          }
        }
        if (rest) {
          const rp = rest.pattern();
          if (typeof rp === "string" && // dots and empty were handled already
          rp !== ".." && rp !== "" && rp !== ".") {
            this.testString(e13, rp, rest.rest(), absolute);
          } else if (rp === "..") {
            const ep = e13.parent || e13;
            this.subwalks.add(ep, rest);
          } else if (rp instanceof RegExp) {
            this.testRegExp(e13, rp, rest.rest(), absolute);
          }
        }
      }
      testRegExp(e13, p13, rest, absolute) {
        if (!p13.test(e13.name))
          return;
        if (!rest) {
          this.matches.add(e13, absolute, false);
        } else {
          this.subwalks.add(e13, rest);
        }
      }
      testString(e13, p13, rest, absolute) {
        if (!e13.isNamed(p13))
          return;
        if (!rest) {
          this.matches.add(e13, absolute, false);
        } else {
          this.subwalks.add(e13, rest);
        }
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/walker.js
var makeIgnore, GlobUtil, GlobWalker, GlobStream;
var init_walker = __esm({
  "../../node_modules/glob/dist/esm/walker.js"() {
    init_esm5();
    init_ignore();
    init_processor();
    makeIgnore = /* @__PURE__ */ __name((ignore2, opts) => typeof ignore2 === "string" ? new Ignore([ignore2], opts) : Array.isArray(ignore2) ? new Ignore(ignore2, opts) : ignore2, "makeIgnore");
    GlobUtil = class {
      static {
        __name(this, "GlobUtil");
      }
      path;
      patterns;
      opts;
      seen = /* @__PURE__ */ new Set();
      paused = false;
      aborted = false;
      #onResume = [];
      #ignore;
      #sep;
      signal;
      maxDepth;
      includeChildMatches;
      constructor(patterns, path44, opts) {
        this.patterns = patterns;
        this.path = path44;
        this.opts = opts;
        this.#sep = !opts.posix && opts.platform === "win32" ? "\\" : "/";
        this.includeChildMatches = opts.includeChildMatches !== false;
        if (opts.ignore || !this.includeChildMatches) {
          this.#ignore = makeIgnore(opts.ignore ?? [], opts);
          if (!this.includeChildMatches && typeof this.#ignore.add !== "function") {
            const m13 = "cannot ignore child matches, ignore lacks add() method.";
            throw new Error(m13);
          }
        }
        this.maxDepth = opts.maxDepth || Infinity;
        if (opts.signal) {
          this.signal = opts.signal;
          this.signal.addEventListener("abort", () => {
            this.#onResume.length = 0;
          });
        }
      }
      #ignored(path44) {
        return this.seen.has(path44) || !!this.#ignore?.ignored?.(path44);
      }
      #childrenIgnored(path44) {
        return !!this.#ignore?.childrenIgnored?.(path44);
      }
      // backpressure mechanism
      pause() {
        this.paused = true;
      }
      resume() {
        if (this.signal?.aborted)
          return;
        this.paused = false;
        let fn = void 0;
        while (!this.paused && (fn = this.#onResume.shift())) {
          fn();
        }
      }
      onResume(fn) {
        if (this.signal?.aborted)
          return;
        if (!this.paused) {
          fn();
        } else {
          this.#onResume.push(fn);
        }
      }
      // do the requisite realpath/stat checking, and return the path
      // to add or undefined to filter it out.
      async matchCheck(e13, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e13.realpathCached() || await e13.realpath();
          if (!rpc)
            return void 0;
          e13 = rpc;
        }
        const needStat = e13.isUnknown() || this.opts.stat;
        const s13 = needStat ? await e13.lstat() : e13;
        if (this.opts.follow && this.opts.nodir && s13?.isSymbolicLink()) {
          const target = await s13.realpath();
          if (target && (target.isUnknown() || this.opts.stat)) {
            await target.lstat();
          }
        }
        return this.matchCheckTest(s13, ifDir);
      }
      matchCheckTest(e13, ifDir) {
        return e13 && (this.maxDepth === Infinity || e13.depth() <= this.maxDepth) && (!ifDir || e13.canReaddir()) && (!this.opts.nodir || !e13.isDirectory()) && (!this.opts.nodir || !this.opts.follow || !e13.isSymbolicLink() || !e13.realpathCached()?.isDirectory()) && !this.#ignored(e13) ? e13 : void 0;
      }
      matchCheckSync(e13, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e13.realpathCached() || e13.realpathSync();
          if (!rpc)
            return void 0;
          e13 = rpc;
        }
        const needStat = e13.isUnknown() || this.opts.stat;
        const s13 = needStat ? e13.lstatSync() : e13;
        if (this.opts.follow && this.opts.nodir && s13?.isSymbolicLink()) {
          const target = s13.realpathSync();
          if (target && (target?.isUnknown() || this.opts.stat)) {
            target.lstatSync();
          }
        }
        return this.matchCheckTest(s13, ifDir);
      }
      matchFinish(e13, absolute) {
        if (this.#ignored(e13))
          return;
        if (!this.includeChildMatches && this.#ignore?.add) {
          const ign = `${e13.relativePosix()}/**`;
          this.#ignore.add(ign);
        }
        const abs = this.opts.absolute === void 0 ? absolute : this.opts.absolute;
        this.seen.add(e13);
        const mark = this.opts.mark && e13.isDirectory() ? this.#sep : "";
        if (this.opts.withFileTypes) {
          this.matchEmit(e13);
        } else if (abs) {
          const abs2 = this.opts.posix ? e13.fullpathPosix() : e13.fullpath();
          this.matchEmit(abs2 + mark);
        } else {
          const rel = this.opts.posix ? e13.relativePosix() : e13.relative();
          const pre = this.opts.dotRelative && !rel.startsWith(".." + this.#sep) ? "." + this.#sep : "";
          this.matchEmit(!rel ? "." + mark : pre + rel + mark);
        }
      }
      async match(e13, absolute, ifDir) {
        const p13 = await this.matchCheck(e13, ifDir);
        if (p13)
          this.matchFinish(p13, absolute);
      }
      matchSync(e13, absolute, ifDir) {
        const p13 = this.matchCheckSync(e13, ifDir);
        if (p13)
          this.matchFinish(p13, absolute);
      }
      walkCB(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2(target, patterns, new Processor(this.opts), cb);
      }
      walkCB2(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = /* @__PURE__ */ __name(() => {
          if (--tasks === 0)
            cb();
        }, "next");
        for (const [m13, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m13))
            continue;
          tasks++;
          this.match(m13, absolute, ifDir).then(() => next());
        }
        for (const t13 of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t13.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const childrenCached = t13.readdirCached();
          if (t13.calledReaddir())
            this.walkCB3(t13, childrenCached, processor, next);
          else {
            t13.readdirCB((_2, entries) => this.walkCB3(t13, entries, processor, next), true);
          }
        }
        next();
      }
      walkCB3(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = /* @__PURE__ */ __name(() => {
          if (--tasks === 0)
            cb();
        }, "next");
        for (const [m13, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m13))
            continue;
          tasks++;
          this.match(m13, absolute, ifDir).then(() => next());
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2(target2, patterns, processor.child(), next);
        }
        next();
      }
      walkCBSync(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2Sync(target, patterns, new Processor(this.opts), cb);
      }
      walkCB2Sync(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2Sync(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = /* @__PURE__ */ __name(() => {
          if (--tasks === 0)
            cb();
        }, "next");
        for (const [m13, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m13))
            continue;
          this.matchSync(m13, absolute, ifDir);
        }
        for (const t13 of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t13.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const children = t13.readdirSync();
          this.walkCB3Sync(t13, children, processor, next);
        }
        next();
      }
      walkCB3Sync(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = /* @__PURE__ */ __name(() => {
          if (--tasks === 0)
            cb();
        }, "next");
        for (const [m13, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m13))
            continue;
          this.matchSync(m13, absolute, ifDir);
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2Sync(target2, patterns, processor.child(), next);
        }
        next();
      }
    };
    GlobWalker = class extends GlobUtil {
      static {
        __name(this, "GlobWalker");
      }
      matches = /* @__PURE__ */ new Set();
      constructor(patterns, path44, opts) {
        super(patterns, path44, opts);
      }
      matchEmit(e13) {
        this.matches.add(e13);
      }
      async walk() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          await this.path.lstat();
        }
        await new Promise((res, rej) => {
          this.walkCB(this.path, this.patterns, () => {
            if (this.signal?.aborted) {
              rej(this.signal.reason);
            } else {
              res(this.matches);
            }
          });
        });
        return this.matches;
      }
      walkSync() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => {
          if (this.signal?.aborted)
            throw this.signal.reason;
        });
        return this.matches;
      }
    };
    GlobStream = class extends GlobUtil {
      static {
        __name(this, "GlobStream");
      }
      results;
      constructor(patterns, path44, opts) {
        super(patterns, path44, opts);
        this.results = new Minipass({
          signal: this.signal,
          objectMode: true
        });
        this.results.on("drain", () => this.resume());
        this.results.on("resume", () => this.resume());
      }
      matchEmit(e13) {
        this.results.write(e13);
        if (!this.results.flowing)
          this.pause();
      }
      stream() {
        const target = this.path;
        if (target.isUnknown()) {
          target.lstat().then(() => {
            this.walkCB(target, this.patterns, () => this.results.end());
          });
        } else {
          this.walkCB(target, this.patterns, () => this.results.end());
        }
        return this.results;
      }
      streamSync() {
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => this.results.end());
        return this.results;
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/glob.js
var import_node_url2, defaultPlatform3, Glob;
var init_glob = __esm({
  "../../node_modules/glob/dist/esm/glob.js"() {
    init_esm3();
    import_node_url2 = require("node:url");
    init_esm6();
    init_pattern();
    init_walker();
    defaultPlatform3 = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    Glob = class {
      static {
        __name(this, "Glob");
      }
      absolute;
      cwd;
      root;
      dot;
      dotRelative;
      follow;
      ignore;
      magicalBraces;
      mark;
      matchBase;
      maxDepth;
      nobrace;
      nocase;
      nodir;
      noext;
      noglobstar;
      pattern;
      platform;
      realpath;
      scurry;
      stat;
      signal;
      windowsPathsNoEscape;
      withFileTypes;
      includeChildMatches;
      /**
       * The options provided to the constructor.
       */
      opts;
      /**
       * An array of parsed immutable {@link Pattern} objects.
       */
      patterns;
      /**
       * All options are stored as properties on the `Glob` object.
       *
       * See {@link GlobOptions} for full options descriptions.
       *
       * Note that a previous `Glob` object can be passed as the
       * `GlobOptions` to another `Glob` instantiation to re-use settings
       * and caches with a new pattern.
       *
       * Traversal functions can be called multiple times to run the walk
       * again.
       */
      constructor(pattern, opts) {
        if (!opts)
          throw new TypeError("glob options required");
        this.withFileTypes = !!opts.withFileTypes;
        this.signal = opts.signal;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.dotRelative = !!opts.dotRelative;
        this.nodir = !!opts.nodir;
        this.mark = !!opts.mark;
        if (!opts.cwd) {
          this.cwd = "";
        } else if (opts.cwd instanceof URL || opts.cwd.startsWith("file://")) {
          opts.cwd = (0, import_node_url2.fileURLToPath)(opts.cwd);
        }
        this.cwd = opts.cwd || "";
        this.root = opts.root;
        this.magicalBraces = !!opts.magicalBraces;
        this.nobrace = !!opts.nobrace;
        this.noext = !!opts.noext;
        this.realpath = !!opts.realpath;
        this.absolute = opts.absolute;
        this.includeChildMatches = opts.includeChildMatches !== false;
        this.noglobstar = !!opts.noglobstar;
        this.matchBase = !!opts.matchBase;
        this.maxDepth = typeof opts.maxDepth === "number" ? opts.maxDepth : Infinity;
        this.stat = !!opts.stat;
        this.ignore = opts.ignore;
        if (this.withFileTypes && this.absolute !== void 0) {
          throw new Error("cannot set absolute and withFileTypes:true");
        }
        if (typeof pattern === "string") {
          pattern = [pattern];
        }
        this.windowsPathsNoEscape = !!opts.windowsPathsNoEscape || opts.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          pattern = pattern.map((p13) => p13.replace(/\\/g, "/"));
        }
        if (this.matchBase) {
          if (opts.noglobstar) {
            throw new TypeError("base matching requires globstar");
          }
          pattern = pattern.map((p13) => p13.includes("/") ? p13 : `./**/${p13}`);
        }
        this.pattern = pattern;
        this.platform = opts.platform || defaultPlatform3;
        this.opts = { ...opts, platform: this.platform };
        if (opts.scurry) {
          this.scurry = opts.scurry;
          if (opts.nocase !== void 0 && opts.nocase !== opts.scurry.nocase) {
            throw new Error("nocase option contradicts provided scurry option");
          }
        } else {
          const Scurry = opts.platform === "win32" ? PathScurryWin32 : opts.platform === "darwin" ? PathScurryDarwin : opts.platform ? PathScurryPosix : PathScurry;
          this.scurry = new Scurry(this.cwd, {
            nocase: opts.nocase,
            fs: opts.fs
          });
        }
        this.nocase = this.scurry.nocase;
        const nocaseMagicOnly = this.platform === "darwin" || this.platform === "win32";
        const mmo = {
          // default nocase based on platform
          ...opts,
          dot: this.dot,
          matchBase: this.matchBase,
          nobrace: this.nobrace,
          nocase: this.nocase,
          nocaseMagicOnly,
          nocomment: true,
          noext: this.noext,
          nonegate: true,
          optimizationLevel: 2,
          platform: this.platform,
          windowsPathsNoEscape: this.windowsPathsNoEscape,
          debug: !!this.opts.debug
        };
        const mms = this.pattern.map((p13) => new Minimatch(p13, mmo));
        const [matchSet, globParts] = mms.reduce((set, m13) => {
          set[0].push(...m13.set);
          set[1].push(...m13.globParts);
          return set;
        }, [[], []]);
        this.patterns = matchSet.map((set, i13) => {
          const g13 = globParts[i13];
          if (!g13)
            throw new Error("invalid pattern object");
          return new Pattern(set, g13, 0, this.platform);
        });
      }
      async walk() {
        return [
          ...await new GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walk()
        ];
      }
      walkSync() {
        return [
          ...new GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walkSync()
        ];
      }
      stream() {
        return new GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).stream();
      }
      streamSync() {
        return new GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).streamSync();
      }
      /**
       * Default sync iteration function. Returns a Generator that
       * iterates over the results.
       */
      iterateSync() {
        return this.streamSync()[Symbol.iterator]();
      }
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      /**
       * Default async iteration function. Returns an AsyncGenerator that
       * iterates over the results.
       */
      iterate() {
        return this.stream()[Symbol.asyncIterator]();
      }
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/has-magic.js
var hasMagic;
var init_has_magic = __esm({
  "../../node_modules/glob/dist/esm/has-magic.js"() {
    init_esm3();
    hasMagic = /* @__PURE__ */ __name((pattern, options = {}) => {
      if (!Array.isArray(pattern)) {
        pattern = [pattern];
      }
      for (const p13 of pattern) {
        if (new Minimatch(p13, options).hasMagic())
          return true;
      }
      return false;
    }, "hasMagic");
  }
});

// ../../node_modules/glob/dist/esm/index.js
function globStreamSync(pattern, options = {}) {
  return new Glob(pattern, options).streamSync();
}
function globStream(pattern, options = {}) {
  return new Glob(pattern, options).stream();
}
function globSync(pattern, options = {}) {
  return new Glob(pattern, options).walkSync();
}
async function glob_(pattern, options = {}) {
  return new Glob(pattern, options).walk();
}
function globIterateSync(pattern, options = {}) {
  return new Glob(pattern, options).iterateSync();
}
function globIterate(pattern, options = {}) {
  return new Glob(pattern, options).iterate();
}
var streamSync, stream, iterateSync, iterate, sync, glob;
var init_esm7 = __esm({
  "../../node_modules/glob/dist/esm/index.js"() {
    init_esm3();
    init_glob();
    init_has_magic();
    init_esm3();
    init_glob();
    init_has_magic();
    init_ignore();
    __name(globStreamSync, "globStreamSync");
    __name(globStream, "globStream");
    __name(globSync, "globSync");
    __name(glob_, "glob_");
    __name(globIterateSync, "globIterateSync");
    __name(globIterate, "globIterate");
    streamSync = globStreamSync;
    stream = Object.assign(globStream, { sync: globStreamSync });
    iterateSync = globIterateSync;
    iterate = Object.assign(globIterate, {
      sync: globIterateSync
    });
    sync = Object.assign(globSync, {
      stream: globStreamSync,
      iterate: globIterateSync
    });
    glob = Object.assign(glob_, {
      glob: glob_,
      globSync,
      sync,
      globStream,
      stream,
      globStreamSync,
      streamSync,
      globIterate,
      iterate,
      globIterateSync,
      iterateSync,
      Glob,
      hasMagic,
      escape,
      unescape: unescape2
    });
    glob.glob = glob;
  }
});

// ../../node_modules/readdir-glob/node_modules/minimatch/lib/path.js
var require_path = __commonJS({
  "../../node_modules/readdir-glob/node_modules/minimatch/lib/path.js"(exports2, module2) {
    var isWindows2 = typeof process === "object" && process && process.platform === "win32";
    module2.exports = isWindows2 ? { sep: "\\" } : { sep: "/" };
  }
});

// ../../node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "../../node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced2;
    function balanced2(a13, b13, str) {
      if (a13 instanceof RegExp) a13 = maybeMatch2(a13, str);
      if (b13 instanceof RegExp) b13 = maybeMatch2(b13, str);
      var r13 = range3(a13, b13, str);
      return r13 && {
        start: r13[0],
        end: r13[1],
        pre: str.slice(0, r13[0]),
        body: str.slice(r13[0] + a13.length, r13[1]),
        post: str.slice(r13[1] + b13.length)
      };
    }
    __name(balanced2, "balanced");
    function maybeMatch2(reg, str) {
      var m13 = str.match(reg);
      return m13 ? m13[0] : null;
    }
    __name(maybeMatch2, "maybeMatch");
    balanced2.range = range3;
    function range3(a13, b13, str) {
      var begs, beg, left, right, result2;
      var ai = str.indexOf(a13);
      var bi = str.indexOf(b13, ai + 1);
      var i13 = ai;
      if (ai >= 0 && bi > 0) {
        if (a13 === b13) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i13 >= 0 && !result2) {
          if (i13 == ai) {
            begs.push(i13);
            ai = str.indexOf(a13, i13 + 1);
          } else if (begs.length == 1) {
            result2 = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b13, i13 + 1);
          }
          i13 = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result2 = [left, right];
        }
      }
      return result2;
    }
    __name(range3, "range");
  }
});

// ../../node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "../../node_modules/brace-expansion/index.js"(exports2, module2) {
    var balanced2 = require_balanced_match();
    module2.exports = expandTop;
    var escSlash2 = "\0SLASH" + Math.random() + "\0";
    var escOpen2 = "\0OPEN" + Math.random() + "\0";
    var escClose2 = "\0CLOSE" + Math.random() + "\0";
    var escComma2 = "\0COMMA" + Math.random() + "\0";
    var escPeriod2 = "\0PERIOD" + Math.random() + "\0";
    function numeric2(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    __name(numeric2, "numeric");
    function escapeBraces2(str) {
      return str.split("\\\\").join(escSlash2).split("\\{").join(escOpen2).split("\\}").join(escClose2).split("\\,").join(escComma2).split("\\.").join(escPeriod2);
    }
    __name(escapeBraces2, "escapeBraces");
    function unescapeBraces2(str) {
      return str.split(escSlash2).join("\\").split(escOpen2).join("{").split(escClose2).join("}").split(escComma2).join(",").split(escPeriod2).join(".");
    }
    __name(unescapeBraces2, "unescapeBraces");
    function parseCommaParts2(str) {
      if (!str)
        return [""];
      var parts = [];
      var m13 = balanced2("{", "}", str);
      if (!m13)
        return str.split(",");
      var pre = m13.pre;
      var body = m13.body;
      var post = m13.post;
      var p13 = pre.split(",");
      p13[p13.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts2(post);
      if (post.length) {
        p13[p13.length - 1] += postParts.shift();
        p13.push.apply(p13, postParts);
      }
      parts.push.apply(parts, p13);
      return parts;
    }
    __name(parseCommaParts2, "parseCommaParts");
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand4(escapeBraces2(str), true).map(unescapeBraces2);
    }
    __name(expandTop, "expandTop");
    function embrace2(str) {
      return "{" + str + "}";
    }
    __name(embrace2, "embrace");
    function isPadded2(el) {
      return /^-?0\d/.test(el);
    }
    __name(isPadded2, "isPadded");
    function lte3(i13, y5) {
      return i13 <= y5;
    }
    __name(lte3, "lte");
    function gte2(i13, y5) {
      return i13 >= y5;
    }
    __name(gte2, "gte");
    function expand4(str, isTop) {
      var expansions = [];
      var m13 = balanced2("{", "}", str);
      if (!m13) return [str];
      var pre = m13.pre;
      var post = m13.post.length ? expand4(m13.post, false) : [""];
      if (/\$$/.test(m13.pre)) {
        for (var k13 = 0; k13 < post.length; k13++) {
          var expansion = pre + "{" + m13.body + "}" + post[k13];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m13.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m13.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m13.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m13.post.match(/,(?!,).*\}/)) {
            str = m13.pre + "{" + m13.body + escClose2 + m13.post;
            return expand4(str);
          }
          return [str];
        }
        var n13;
        if (isSequence) {
          n13 = m13.body.split(/\.\./);
        } else {
          n13 = parseCommaParts2(m13.body);
          if (n13.length === 1) {
            n13 = expand4(n13[0], false).map(embrace2);
            if (n13.length === 1) {
              return post.map(function(p13) {
                return m13.pre + n13[0] + p13;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x13 = numeric2(n13[0]);
          var y5 = numeric2(n13[1]);
          var width = Math.max(n13[0].length, n13[1].length);
          var incr = n13.length == 3 ? Math.abs(numeric2(n13[2])) : 1;
          var test = lte3;
          var reverse = y5 < x13;
          if (reverse) {
            incr *= -1;
            test = gte2;
          }
          var pad = n13.some(isPadded2);
          N = [];
          for (var i13 = x13; test(i13, y5); i13 += incr) {
            var c13;
            if (isAlphaSequence) {
              c13 = String.fromCharCode(i13);
              if (c13 === "\\")
                c13 = "";
            } else {
              c13 = String(i13);
              if (pad) {
                var need = width - c13.length;
                if (need > 0) {
                  var z5 = new Array(need + 1).join("0");
                  if (i13 < 0)
                    c13 = "-" + z5 + c13.slice(1);
                  else
                    c13 = z5 + c13;
                }
              }
            }
            N.push(c13);
          }
        } else {
          N = [];
          for (var j13 = 0; j13 < n13.length; j13++) {
            N.push.apply(N, expand4(n13[j13], false));
          }
        }
        for (var j13 = 0; j13 < N.length; j13++) {
          for (var k13 = 0; k13 < post.length; k13++) {
            var expansion = pre + N[j13] + post[k13];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
    __name(expand4, "expand");
  }
});

// ../../node_modules/readdir-glob/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "../../node_modules/readdir-glob/node_modules/minimatch/minimatch.js"(exports2, module2) {
    var minimatch4 = module2.exports = (p13, pattern, options = {}) => {
      assertValidPattern4(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch4(pattern, options).match(p13);
    };
    module2.exports = minimatch4;
    var path44 = require_path();
    minimatch4.sep = path44.sep;
    var GLOBSTAR4 = /* @__PURE__ */ Symbol("globstar **");
    minimatch4.GLOBSTAR = GLOBSTAR4;
    var expand4 = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark7 = "[^/]";
    var star7 = qmark7 + "*?";
    var twoStarDot4 = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot4 = "(?:(?!(?:\\/|^)\\.).)*?";
    var charSet = /* @__PURE__ */ __name((s13) => s13.split("").reduce((set, c13) => {
      set[c13] = true;
      return set;
    }, {}), "charSet");
    var reSpecials4 = charSet("().*{}+?[]^$\\!");
    var addPatternStartSet = charSet("[.(");
    var slashSplit = /\/+/;
    minimatch4.filter = (pattern, options = {}) => (p13, i13, list2) => minimatch4(p13, pattern, options);
    var ext4 = /* @__PURE__ */ __name((a13, b13 = {}) => {
      const t13 = {};
      Object.keys(a13).forEach((k13) => t13[k13] = a13[k13]);
      Object.keys(b13).forEach((k13) => t13[k13] = b13[k13]);
      return t13;
    }, "ext");
    minimatch4.defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch4;
      }
      const orig = minimatch4;
      const m13 = /* @__PURE__ */ __name((p13, pattern, options) => orig(p13, pattern, ext4(def, options)), "m");
      m13.Minimatch = class Minimatch extends orig.Minimatch {
        static {
          __name(this, "Minimatch");
        }
        constructor(pattern, options) {
          super(pattern, ext4(def, options));
        }
      };
      m13.Minimatch.defaults = (options) => orig.defaults(ext4(def, options)).Minimatch;
      m13.filter = (pattern, options) => orig.filter(pattern, ext4(def, options));
      m13.defaults = (options) => orig.defaults(ext4(def, options));
      m13.makeRe = (pattern, options) => orig.makeRe(pattern, ext4(def, options));
      m13.braceExpand = (pattern, options) => orig.braceExpand(pattern, ext4(def, options));
      m13.match = (list2, pattern, options) => orig.match(list2, pattern, ext4(def, options));
      return m13;
    };
    minimatch4.braceExpand = (pattern, options) => braceExpand4(pattern, options);
    var braceExpand4 = /* @__PURE__ */ __name((pattern, options = {}) => {
      assertValidPattern4(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand4(pattern);
    }, "braceExpand");
    var MAX_PATTERN_LENGTH4 = 1024 * 64;
    var assertValidPattern4 = /* @__PURE__ */ __name((pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH4) {
        throw new TypeError("pattern is too long");
      }
    }, "assertValidPattern");
    var SUBPARSE = /* @__PURE__ */ Symbol("subparse");
    minimatch4.makeRe = (pattern, options) => new Minimatch4(pattern, options || {}).makeRe();
    minimatch4.match = (list2, pattern, options = {}) => {
      const mm = new Minimatch4(pattern, options);
      list2 = list2.filter((f13) => mm.match(f13));
      if (mm.options.nonull && !list2.length) {
        list2.push(pattern);
      }
      return list2;
    };
    var globUnescape = /* @__PURE__ */ __name((s13) => s13.replace(/\\(.)/g, "$1"), "globUnescape");
    var charUnescape = /* @__PURE__ */ __name((s13) => s13.replace(/\\([^-\]])/g, "$1"), "charUnescape");
    var regExpEscape7 = /* @__PURE__ */ __name((s13) => s13.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "regExpEscape");
    var braExpEscape = /* @__PURE__ */ __name((s13) => s13.replace(/[[\]\\]/g, "\\$&"), "braExpEscape");
    var Minimatch4 = class {
      static {
        __name(this, "Minimatch");
      }
      constructor(pattern, options) {
        assertValidPattern4(pattern);
        if (!options) options = {};
        this.options = options;
        this.set = [];
        this.pattern = pattern;
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.regexp = null;
        this.negate = false;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.make();
      }
      debug() {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        let set = this.globSet = this.braceExpand();
        if (options.debug) this.debug = (...args) => console.error(...args);
        this.debug(this.pattern, set);
        set = this.globParts = set.map((s13) => s13.split(slashSplit));
        this.debug(this.pattern, set);
        set = set.map((s13, si, set2) => s13.map(this.parse, this));
        this.debug(this.pattern, set);
        set = set.filter((s13) => s13.indexOf(false) === -1);
        this.debug(this.pattern, set);
        this.set = set;
      }
      parseNegate() {
        if (this.options.nonegate) return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i13 = 0; i13 < pattern.length && pattern.charAt(i13) === "!"; i13++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset) this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial) {
        var options = this.options;
        this.debug(
          "matchOne",
          { "this": this, file, pattern }
        );
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl2 = pattern.length; fi < fl && pi < pl2; fi++, pi++) {
          this.debug("matchOne loop");
          var p13 = pattern[pi];
          var f13 = file[fi];
          this.debug(pattern, p13, f13);
          if (p13 === false) return false;
          if (p13 === GLOBSTAR4) {
            this.debug("GLOBSTAR", [pattern, p13, f13]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl2) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".") return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) return true;
            }
            return false;
          }
          var hit;
          if (typeof p13 === "string") {
            hit = f13 === p13;
            this.debug("string match", p13, f13, hit);
          } else {
            hit = f13.match(p13);
            this.debug("pattern match", p13, f13, hit);
          }
          if (!hit) return false;
        }
        if (fi === fl && pi === pl2) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl2) {
          return fi === fl - 1 && file[fi] === "";
        }
        throw new Error("wtf?");
      }
      braceExpand() {
        return braceExpand4(this.pattern, this.options);
      }
      parse(pattern, isSub) {
        assertValidPattern4(pattern);
        const options = this.options;
        if (pattern === "**") {
          if (!options.noglobstar)
            return GLOBSTAR4;
          else
            pattern = "*";
        }
        if (pattern === "") return "";
        let re = "";
        let hasMagic2 = false;
        let escaping = false;
        const patternListStack = [];
        const negativeLists = [];
        let stateChar;
        let inClass = false;
        let reClassStart = -1;
        let classStart = -1;
        let cs;
        let pl2;
        let sp;
        let dotTravAllowed = pattern.charAt(0) === ".";
        let dotFileAllowed = options.dot || dotTravAllowed;
        const patternStart = /* @__PURE__ */ __name(() => dotTravAllowed ? "" : dotFileAllowed ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)", "patternStart");
        const subPatternStart = /* @__PURE__ */ __name((p13) => p13.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)", "subPatternStart");
        const clearStateChar = /* @__PURE__ */ __name(() => {
          if (stateChar) {
            switch (stateChar) {
              case "*":
                re += star7;
                hasMagic2 = true;
                break;
              case "?":
                re += qmark7;
                hasMagic2 = true;
                break;
              default:
                re += "\\" + stateChar;
                break;
            }
            this.debug("clearStateChar %j %j", stateChar, re);
            stateChar = false;
          }
        }, "clearStateChar");
        for (let i13 = 0, c13; i13 < pattern.length && (c13 = pattern.charAt(i13)); i13++) {
          this.debug("%s	%s %s %j", pattern, i13, re, c13);
          if (escaping) {
            if (c13 === "/") {
              return false;
            }
            if (reSpecials4[c13]) {
              re += "\\";
            }
            re += c13;
            escaping = false;
            continue;
          }
          switch (c13) {
            /* istanbul ignore next */
            case "/": {
              return false;
            }
            case "\\":
              if (inClass && pattern.charAt(i13 + 1) === "-") {
                re += c13;
                continue;
              }
              clearStateChar();
              escaping = true;
              continue;
            // the various stateChar values
            // for the "extglob" stuff.
            case "?":
            case "*":
            case "+":
            case "@":
            case "!":
              this.debug("%s	%s %s %j <-- stateChar", pattern, i13, re, c13);
              if (inClass) {
                this.debug("  in class");
                if (c13 === "!" && i13 === classStart + 1) c13 = "^";
                re += c13;
                continue;
              }
              this.debug("call clearStateChar %j", stateChar);
              clearStateChar();
              stateChar = c13;
              if (options.noext) clearStateChar();
              continue;
            case "(": {
              if (inClass) {
                re += "(";
                continue;
              }
              if (!stateChar) {
                re += "\\(";
                continue;
              }
              const plEntry = {
                type: stateChar,
                start: i13 - 1,
                reStart: re.length,
                open: plTypes[stateChar].open,
                close: plTypes[stateChar].close
              };
              this.debug(this.pattern, "	", plEntry);
              patternListStack.push(plEntry);
              re += plEntry.open;
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re += subPatternStart(pattern.slice(i13 + 1));
              }
              this.debug("plType %j %j", stateChar, re);
              stateChar = false;
              continue;
            }
            case ")": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re += "\\)";
                continue;
              }
              patternListStack.pop();
              clearStateChar();
              hasMagic2 = true;
              pl2 = plEntry;
              re += pl2.close;
              if (pl2.type === "!") {
                negativeLists.push(Object.assign(pl2, { reEnd: re.length }));
              }
              continue;
            }
            case "|": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re += "\\|";
                continue;
              }
              clearStateChar();
              re += "|";
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re += subPatternStart(pattern.slice(i13 + 1));
              }
              continue;
            }
            // these are mostly the same in regexp and glob
            case "[":
              clearStateChar();
              if (inClass) {
                re += "\\" + c13;
                continue;
              }
              inClass = true;
              classStart = i13;
              reClassStart = re.length;
              re += c13;
              continue;
            case "]":
              if (i13 === classStart + 1 || !inClass) {
                re += "\\" + c13;
                continue;
              }
              cs = pattern.substring(classStart + 1, i13);
              try {
                RegExp("[" + braExpEscape(charUnescape(cs)) + "]");
                re += c13;
              } catch (er) {
                re = re.substring(0, reClassStart) + "(?:$.)";
              }
              hasMagic2 = true;
              inClass = false;
              continue;
            default:
              clearStateChar();
              if (reSpecials4[c13] && !(c13 === "^" && inClass)) {
                re += "\\";
              }
              re += c13;
              break;
          }
        }
        if (inClass) {
          cs = pattern.slice(classStart + 1);
          sp = this.parse(cs, SUBPARSE);
          re = re.substring(0, reClassStart) + "\\[" + sp[0];
          hasMagic2 = hasMagic2 || sp[1];
        }
        for (pl2 = patternListStack.pop(); pl2; pl2 = patternListStack.pop()) {
          let tail;
          tail = re.slice(pl2.reStart + pl2.open.length);
          this.debug("setting tail", re, pl2);
          tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, (_2, $1, $2) => {
            if (!$2) {
              $2 = "\\";
            }
            return $1 + $1 + $2 + "|";
          });
          this.debug("tail=%j\n   %s", tail, tail, pl2, re);
          const t13 = pl2.type === "*" ? star7 : pl2.type === "?" ? qmark7 : "\\" + pl2.type;
          hasMagic2 = true;
          re = re.slice(0, pl2.reStart) + t13 + "\\(" + tail;
        }
        clearStateChar();
        if (escaping) {
          re += "\\\\";
        }
        const addPatternStart4 = addPatternStartSet[re.charAt(0)];
        for (let n13 = negativeLists.length - 1; n13 > -1; n13--) {
          const nl = negativeLists[n13];
          const nlBefore = re.slice(0, nl.reStart);
          const nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
          let nlAfter = re.slice(nl.reEnd);
          const nlLast = re.slice(nl.reEnd - 8, nl.reEnd) + nlAfter;
          const closeParensBefore = nlBefore.split(")").length;
          const openParensBefore = nlBefore.split("(").length - closeParensBefore;
          let cleanAfter = nlAfter;
          for (let i13 = 0; i13 < openParensBefore; i13++) {
            cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
          }
          nlAfter = cleanAfter;
          const dollar = nlAfter === "" && isSub !== SUBPARSE ? "(?:$|\\/)" : "";
          re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (re !== "" && hasMagic2) {
          re = "(?=.)" + re;
        }
        if (addPatternStart4) {
          re = patternStart() + re;
        }
        if (isSub === SUBPARSE) {
          return [re, hasMagic2];
        }
        if (options.nocase && !hasMagic2) {
          hasMagic2 = pattern.toUpperCase() !== pattern.toLowerCase();
        }
        if (!hasMagic2) {
          return globUnescape(pattern);
        }
        const flags = options.nocase ? "i" : "";
        try {
          return Object.assign(new RegExp("^" + re + "$", flags), {
            _glob: pattern,
            _src: re
          });
        } catch (er) {
          return new RegExp("$.");
        }
      }
      makeRe() {
        if (this.regexp || this.regexp === false) return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star7 : options.dot ? twoStarDot4 : twoStarNoDot4;
        const flags = options.nocase ? "i" : "";
        let re = set.map((pattern) => {
          pattern = pattern.map(
            (p13) => typeof p13 === "string" ? regExpEscape7(p13) : p13 === GLOBSTAR4 ? GLOBSTAR4 : p13._src
          ).reduce((set2, p13) => {
            if (!(set2[set2.length - 1] === GLOBSTAR4 && p13 === GLOBSTAR4)) {
              set2.push(p13);
            }
            return set2;
          }, []);
          pattern.forEach((p13, i13) => {
            if (p13 !== GLOBSTAR4 || pattern[i13 - 1] === GLOBSTAR4) {
              return;
            }
            if (i13 === 0) {
              if (pattern.length > 1) {
                pattern[i13 + 1] = "(?:\\/|" + twoStar + "\\/)?" + pattern[i13 + 1];
              } else {
                pattern[i13] = twoStar;
              }
            } else if (i13 === pattern.length - 1) {
              pattern[i13 - 1] += "(?:\\/|" + twoStar + ")?";
            } else {
              pattern[i13 - 1] += "(?:\\/|\\/" + twoStar + "\\/)" + pattern[i13 + 1];
              pattern[i13 + 1] = GLOBSTAR4;
            }
          });
          return pattern.filter((p13) => p13 !== GLOBSTAR4).join("/");
        }).join("|");
        re = "^(?:" + re + ")$";
        if (this.negate) re = "^(?!" + re + ").*$";
        try {
          this.regexp = new RegExp(re, flags);
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      match(f13, partial = this.partial) {
        this.debug("match", f13, this.pattern);
        if (this.comment) return false;
        if (this.empty) return f13 === "";
        if (f13 === "/" && partial) return true;
        const options = this.options;
        if (path44.sep !== "/") {
          f13 = f13.split(path44.sep).join("/");
        }
        f13 = f13.split(slashSplit);
        this.debug(this.pattern, "split", f13);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename;
        for (let i13 = f13.length - 1; i13 >= 0; i13--) {
          filename = f13[i13];
          if (filename) break;
        }
        for (let i13 = 0; i13 < set.length; i13++) {
          const pattern = set[i13];
          let file = f13;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) return true;
            return !this.negate;
          }
        }
        if (options.flipNegate) return false;
        return this.negate;
      }
      static defaults(def) {
        return minimatch4.defaults(def).Minimatch;
      }
    };
    minimatch4.Minimatch = Minimatch4;
  }
});

// ../../node_modules/readdir-glob/index.js
var require_readdir_glob = __commonJS({
  "../../node_modules/readdir-glob/index.js"(exports2, module2) {
    module2.exports = readdirGlob;
    var fs47 = require("fs");
    var { EventEmitter: EventEmitter3 } = require("events");
    var { Minimatch: Minimatch4 } = require_minimatch();
    var { resolve: resolve16 } = require("path");
    function readdir5(dir, strict) {
      return new Promise((resolve17, reject) => {
        fs47.readdir(dir, { withFileTypes: true }, (err, files) => {
          if (err) {
            switch (err.code) {
              case "ENOTDIR":
                if (strict) {
                  reject(err);
                } else {
                  resolve17([]);
                }
                break;
              case "ENOTSUP":
              // Operation not supported
              case "ENOENT":
              // No such file or directory
              case "ENAMETOOLONG":
              // Filename too long
              case "UNKNOWN":
                resolve17([]);
                break;
              case "ELOOP":
              // Too many levels of symbolic links
              default:
                reject(err);
                break;
            }
          } else {
            resolve17(files);
          }
        });
      });
    }
    __name(readdir5, "readdir");
    function stat8(file, followSymlinks) {
      return new Promise((resolve17, reject) => {
        const statFunc = followSymlinks ? fs47.stat : fs47.lstat;
        statFunc(file, (err, stats) => {
          if (err) {
            switch (err.code) {
              case "ENOENT":
                if (followSymlinks) {
                  resolve17(stat8(file, false));
                } else {
                  resolve17(null);
                }
                break;
              default:
                resolve17(null);
                break;
            }
          } else {
            resolve17(stats);
          }
        });
      });
    }
    __name(stat8, "stat");
    async function* exploreWalkAsync(dir, path44, followSymlinks, useStat, shouldSkip, strict) {
      let files = await readdir5(path44 + dir, strict);
      for (const file of files) {
        let name = file.name;
        if (name === void 0) {
          name = file;
          useStat = true;
        }
        const filename = dir + "/" + name;
        const relative4 = filename.slice(1);
        const absolute = path44 + "/" + relative4;
        let stats = null;
        if (useStat || followSymlinks) {
          stats = await stat8(absolute, followSymlinks);
        }
        if (!stats && file.name !== void 0) {
          stats = file;
        }
        if (stats === null) {
          stats = { isDirectory: /* @__PURE__ */ __name(() => false, "isDirectory") };
        }
        if (stats.isDirectory()) {
          if (!shouldSkip(relative4)) {
            yield { relative: relative4, absolute, stats };
            yield* exploreWalkAsync(filename, path44, followSymlinks, useStat, shouldSkip, false);
          }
        } else {
          yield { relative: relative4, absolute, stats };
        }
      }
    }
    __name(exploreWalkAsync, "exploreWalkAsync");
    async function* explore(path44, followSymlinks, useStat, shouldSkip) {
      yield* exploreWalkAsync("", path44, followSymlinks, useStat, shouldSkip, true);
    }
    __name(explore, "explore");
    function readOptions(options) {
      return {
        pattern: options.pattern,
        dot: !!options.dot,
        noglobstar: !!options.noglobstar,
        matchBase: !!options.matchBase,
        nocase: !!options.nocase,
        ignore: options.ignore,
        skip: options.skip,
        follow: !!options.follow,
        stat: !!options.stat,
        nodir: !!options.nodir,
        mark: !!options.mark,
        silent: !!options.silent,
        absolute: !!options.absolute
      };
    }
    __name(readOptions, "readOptions");
    var ReaddirGlob = class extends EventEmitter3 {
      static {
        __name(this, "ReaddirGlob");
      }
      constructor(cwd, options, cb) {
        super();
        if (typeof options === "function") {
          cb = options;
          options = null;
        }
        this.options = readOptions(options || {});
        this.matchers = [];
        if (this.options.pattern) {
          const matchers = Array.isArray(this.options.pattern) ? this.options.pattern : [this.options.pattern];
          this.matchers = matchers.map(
            (m13) => new Minimatch4(m13, {
              dot: this.options.dot,
              noglobstar: this.options.noglobstar,
              matchBase: this.options.matchBase,
              nocase: this.options.nocase
            })
          );
        }
        this.ignoreMatchers = [];
        if (this.options.ignore) {
          const ignorePatterns = Array.isArray(this.options.ignore) ? this.options.ignore : [this.options.ignore];
          this.ignoreMatchers = ignorePatterns.map(
            (ignore2) => new Minimatch4(ignore2, { dot: true })
          );
        }
        this.skipMatchers = [];
        if (this.options.skip) {
          const skipPatterns = Array.isArray(this.options.skip) ? this.options.skip : [this.options.skip];
          this.skipMatchers = skipPatterns.map(
            (skip) => new Minimatch4(skip, { dot: true })
          );
        }
        this.iterator = explore(resolve16(cwd || "."), this.options.follow, this.options.stat, this._shouldSkipDirectory.bind(this));
        this.paused = false;
        this.inactive = false;
        this.aborted = false;
        if (cb) {
          this._matches = [];
          this.on("match", (match4) => this._matches.push(this.options.absolute ? match4.absolute : match4.relative));
          this.on("error", (err) => cb(err));
          this.on("end", () => cb(null, this._matches));
        }
        setTimeout(() => this._next(), 0);
      }
      _shouldSkipDirectory(relative4) {
        return this.skipMatchers.some((m13) => m13.match(relative4));
      }
      _fileMatches(relative4, isDirectory) {
        const file = relative4 + (isDirectory ? "/" : "");
        return (this.matchers.length === 0 || this.matchers.some((m13) => m13.match(file))) && !this.ignoreMatchers.some((m13) => m13.match(file)) && (!this.options.nodir || !isDirectory);
      }
      _next() {
        if (!this.paused && !this.aborted) {
          this.iterator.next().then((obj) => {
            if (!obj.done) {
              const isDirectory = obj.value.stats.isDirectory();
              if (this._fileMatches(obj.value.relative, isDirectory)) {
                let relative4 = obj.value.relative;
                let absolute = obj.value.absolute;
                if (this.options.mark && isDirectory) {
                  relative4 += "/";
                  absolute += "/";
                }
                if (this.options.stat) {
                  this.emit("match", { relative: relative4, absolute, stat: obj.value.stats });
                } else {
                  this.emit("match", { relative: relative4, absolute });
                }
              }
              this._next(this.iterator);
            } else {
              this.emit("end");
            }
          }).catch((err) => {
            this.abort();
            this.emit("error", err);
            if (!err.code && !this.options.silent) {
              console.error(err);
            }
          });
        } else {
          this.inactive = true;
        }
      }
      abort() {
        this.aborted = true;
      }
      pause() {
        this.paused = true;
      }
      resume() {
        this.paused = false;
        if (this.inactive) {
          this.inactive = false;
          this._next();
        }
      }
    };
    function readdirGlob(pattern, options, cb) {
      return new ReaddirGlob(pattern, options, cb);
    }
    __name(readdirGlob, "readdirGlob");
    readdirGlob.ReaddirGlob = ReaddirGlob;
  }
});

// ../../node_modules/async/dist/async.js
var require_async = __commonJS({
  "../../node_modules/async/dist/async.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.async = {}));
    })(exports2, (function(exports3) {
      "use strict";
      function apply(fn, ...args) {
        return (...callArgs) => fn(...args, ...callArgs);
      }
      __name(apply, "apply");
      function initialParams(fn) {
        return function(...args) {
          var callback = args.pop();
          return fn.call(this, args, callback);
        };
      }
      __name(initialParams, "initialParams");
      var hasQueueMicrotask = typeof queueMicrotask === "function" && queueMicrotask;
      var hasSetImmediate = typeof setImmediate === "function" && setImmediate;
      var hasNextTick = typeof process === "object" && typeof process.nextTick === "function";
      function fallback(fn) {
        setTimeout(fn, 0);
      }
      __name(fallback, "fallback");
      function wrap(defer2) {
        return (fn, ...args) => defer2(() => fn(...args));
      }
      __name(wrap, "wrap");
      var _defer$1;
      if (hasQueueMicrotask) {
        _defer$1 = queueMicrotask;
      } else if (hasSetImmediate) {
        _defer$1 = setImmediate;
      } else if (hasNextTick) {
        _defer$1 = process.nextTick;
      } else {
        _defer$1 = fallback;
      }
      var setImmediate$1 = wrap(_defer$1);
      function asyncify(func) {
        if (isAsync(func)) {
          return function(...args) {
            const callback = args.pop();
            const promise = func.apply(this, args);
            return handlePromise(promise, callback);
          };
        }
        return initialParams(function(args, callback) {
          var result2;
          try {
            result2 = func.apply(this, args);
          } catch (e13) {
            return callback(e13);
          }
          if (result2 && typeof result2.then === "function") {
            return handlePromise(result2, callback);
          } else {
            callback(null, result2);
          }
        });
      }
      __name(asyncify, "asyncify");
      function handlePromise(promise, callback) {
        return promise.then((value) => {
          invokeCallback(callback, null, value);
        }, (err) => {
          invokeCallback(callback, err && (err instanceof Error || err.message) ? err : new Error(err));
        });
      }
      __name(handlePromise, "handlePromise");
      function invokeCallback(callback, error5, value) {
        try {
          callback(error5, value);
        } catch (err) {
          setImmediate$1((e13) => {
            throw e13;
          }, err);
        }
      }
      __name(invokeCallback, "invokeCallback");
      function isAsync(fn) {
        return fn[Symbol.toStringTag] === "AsyncFunction";
      }
      __name(isAsync, "isAsync");
      function isAsyncGenerator(fn) {
        return fn[Symbol.toStringTag] === "AsyncGenerator";
      }
      __name(isAsyncGenerator, "isAsyncGenerator");
      function isAsyncIterable(obj) {
        return typeof obj[Symbol.asyncIterator] === "function";
      }
      __name(isAsyncIterable, "isAsyncIterable");
      function wrapAsync(asyncFn) {
        if (typeof asyncFn !== "function") throw new Error("expected a function");
        return isAsync(asyncFn) ? asyncify(asyncFn) : asyncFn;
      }
      __name(wrapAsync, "wrapAsync");
      function awaitify(asyncFn, arity) {
        if (!arity) arity = asyncFn.length;
        if (!arity) throw new Error("arity is undefined");
        function awaitable(...args) {
          if (typeof args[arity - 1] === "function") {
            return asyncFn.apply(this, args);
          }
          return new Promise((resolve16, reject2) => {
            args[arity - 1] = (err, ...cbArgs) => {
              if (err) return reject2(err);
              resolve16(cbArgs.length > 1 ? cbArgs : cbArgs[0]);
            };
            asyncFn.apply(this, args);
          });
        }
        __name(awaitable, "awaitable");
        return awaitable;
      }
      __name(awaitify, "awaitify");
      function applyEach$1(eachfn) {
        return /* @__PURE__ */ __name(function applyEach2(fns, ...callArgs) {
          const go = awaitify(function(callback) {
            var that = this;
            return eachfn(fns, (fn, cb) => {
              wrapAsync(fn).apply(that, callArgs.concat(cb));
            }, callback);
          });
          return go;
        }, "applyEach");
      }
      __name(applyEach$1, "applyEach$1");
      function _asyncMap(eachfn, arr, iteratee, callback) {
        arr = arr || [];
        var results = [];
        var counter = 0;
        var _iteratee = wrapAsync(iteratee);
        return eachfn(arr, (value, _2, iterCb) => {
          var index2 = counter++;
          _iteratee(value, (err, v14) => {
            results[index2] = v14;
            iterCb(err);
          });
        }, (err) => {
          callback(err, results);
        });
      }
      __name(_asyncMap, "_asyncMap");
      function isArrayLike(value) {
        return value && typeof value.length === "number" && value.length >= 0 && value.length % 1 === 0;
      }
      __name(isArrayLike, "isArrayLike");
      const breakLoop = {};
      function once(fn) {
        function wrapper(...args) {
          if (fn === null) return;
          var callFn = fn;
          fn = null;
          callFn.apply(this, args);
        }
        __name(wrapper, "wrapper");
        Object.assign(wrapper, fn);
        return wrapper;
      }
      __name(once, "once");
      function getIterator(coll) {
        return coll[Symbol.iterator] && coll[Symbol.iterator]();
      }
      __name(getIterator, "getIterator");
      function createArrayIterator(coll) {
        var i13 = -1;
        var len = coll.length;
        return /* @__PURE__ */ __name(function next() {
          return ++i13 < len ? { value: coll[i13], key: i13 } : null;
        }, "next");
      }
      __name(createArrayIterator, "createArrayIterator");
      function createES2015Iterator(iterator) {
        var i13 = -1;
        return /* @__PURE__ */ __name(function next() {
          var item = iterator.next();
          if (item.done)
            return null;
          i13++;
          return { value: item.value, key: i13 };
        }, "next");
      }
      __name(createES2015Iterator, "createES2015Iterator");
      function createObjectIterator(obj) {
        var okeys = obj ? Object.keys(obj) : [];
        var i13 = -1;
        var len = okeys.length;
        return /* @__PURE__ */ __name(function next() {
          var key = okeys[++i13];
          if (key === "__proto__") {
            return next();
          }
          return i13 < len ? { value: obj[key], key } : null;
        }, "next");
      }
      __name(createObjectIterator, "createObjectIterator");
      function createIterator(coll) {
        if (isArrayLike(coll)) {
          return createArrayIterator(coll);
        }
        var iterator = getIterator(coll);
        return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
      }
      __name(createIterator, "createIterator");
      function onlyOnce(fn) {
        return function(...args) {
          if (fn === null) throw new Error("Callback was already called.");
          var callFn = fn;
          fn = null;
          callFn.apply(this, args);
        };
      }
      __name(onlyOnce, "onlyOnce");
      function asyncEachOfLimit(generator, limit, iteratee, callback) {
        let done = false;
        let canceled = false;
        let awaiting = false;
        let running = 0;
        let idx = 0;
        function replenish() {
          if (running >= limit || awaiting || done) return;
          awaiting = true;
          generator.next().then(({ value, done: iterDone }) => {
            if (canceled || done) return;
            awaiting = false;
            if (iterDone) {
              done = true;
              if (running <= 0) {
                callback(null);
              }
              return;
            }
            running++;
            iteratee(value, idx, iterateeCallback);
            idx++;
            replenish();
          }).catch(handleError);
        }
        __name(replenish, "replenish");
        function iterateeCallback(err, result2) {
          running -= 1;
          if (canceled) return;
          if (err) return handleError(err);
          if (err === false) {
            done = true;
            canceled = true;
            return;
          }
          if (result2 === breakLoop || done && running <= 0) {
            done = true;
            return callback(null);
          }
          replenish();
        }
        __name(iterateeCallback, "iterateeCallback");
        function handleError(err) {
          if (canceled) return;
          awaiting = false;
          done = true;
          callback(err);
        }
        __name(handleError, "handleError");
        replenish();
      }
      __name(asyncEachOfLimit, "asyncEachOfLimit");
      var eachOfLimit$2 = /* @__PURE__ */ __name((limit) => {
        return (obj, iteratee, callback) => {
          callback = once(callback);
          if (limit <= 0) {
            throw new RangeError("concurrency limit cannot be less than 1");
          }
          if (!obj) {
            return callback(null);
          }
          if (isAsyncGenerator(obj)) {
            return asyncEachOfLimit(obj, limit, iteratee, callback);
          }
          if (isAsyncIterable(obj)) {
            return asyncEachOfLimit(obj[Symbol.asyncIterator](), limit, iteratee, callback);
          }
          var nextElem = createIterator(obj);
          var done = false;
          var canceled = false;
          var running = 0;
          var looping = false;
          function iterateeCallback(err, value) {
            if (canceled) return;
            running -= 1;
            if (err) {
              done = true;
              callback(err);
            } else if (err === false) {
              done = true;
              canceled = true;
            } else if (value === breakLoop || done && running <= 0) {
              done = true;
              return callback(null);
            } else if (!looping) {
              replenish();
            }
          }
          __name(iterateeCallback, "iterateeCallback");
          function replenish() {
            looping = true;
            while (running < limit && !done) {
              var elem = nextElem();
              if (elem === null) {
                done = true;
                if (running <= 0) {
                  callback(null);
                }
                return;
              }
              running += 1;
              iteratee(elem.value, elem.key, onlyOnce(iterateeCallback));
            }
            looping = false;
          }
          __name(replenish, "replenish");
          replenish();
        };
      }, "eachOfLimit$2");
      function eachOfLimit(coll, limit, iteratee, callback) {
        return eachOfLimit$2(limit)(coll, wrapAsync(iteratee), callback);
      }
      __name(eachOfLimit, "eachOfLimit");
      var eachOfLimit$1 = awaitify(eachOfLimit, 4);
      function eachOfArrayLike(coll, iteratee, callback) {
        callback = once(callback);
        var index2 = 0, completed = 0, { length } = coll, canceled = false;
        if (length === 0) {
          callback(null);
        }
        function iteratorCallback(err, value) {
          if (err === false) {
            canceled = true;
          }
          if (canceled === true) return;
          if (err) {
            callback(err);
          } else if (++completed === length || value === breakLoop) {
            callback(null);
          }
        }
        __name(iteratorCallback, "iteratorCallback");
        for (; index2 < length; index2++) {
          iteratee(coll[index2], index2, onlyOnce(iteratorCallback));
        }
      }
      __name(eachOfArrayLike, "eachOfArrayLike");
      function eachOfGeneric(coll, iteratee, callback) {
        return eachOfLimit$1(coll, Infinity, iteratee, callback);
      }
      __name(eachOfGeneric, "eachOfGeneric");
      function eachOf(coll, iteratee, callback) {
        var eachOfImplementation = isArrayLike(coll) ? eachOfArrayLike : eachOfGeneric;
        return eachOfImplementation(coll, wrapAsync(iteratee), callback);
      }
      __name(eachOf, "eachOf");
      var eachOf$1 = awaitify(eachOf, 3);
      function map2(coll, iteratee, callback) {
        return _asyncMap(eachOf$1, coll, iteratee, callback);
      }
      __name(map2, "map");
      var map$1 = awaitify(map2, 3);
      var applyEach = applyEach$1(map$1);
      function eachOfSeries(coll, iteratee, callback) {
        return eachOfLimit$1(coll, 1, iteratee, callback);
      }
      __name(eachOfSeries, "eachOfSeries");
      var eachOfSeries$1 = awaitify(eachOfSeries, 3);
      function mapSeries(coll, iteratee, callback) {
        return _asyncMap(eachOfSeries$1, coll, iteratee, callback);
      }
      __name(mapSeries, "mapSeries");
      var mapSeries$1 = awaitify(mapSeries, 3);
      var applyEachSeries = applyEach$1(mapSeries$1);
      const PROMISE_SYMBOL = /* @__PURE__ */ Symbol("promiseCallback");
      function promiseCallback() {
        let resolve16, reject2;
        function callback(err, ...args) {
          if (err) return reject2(err);
          resolve16(args.length > 1 ? args : args[0]);
        }
        __name(callback, "callback");
        callback[PROMISE_SYMBOL] = new Promise((res, rej) => {
          resolve16 = res, reject2 = rej;
        });
        return callback;
      }
      __name(promiseCallback, "promiseCallback");
      function auto(tasks, concurrency, callback) {
        if (typeof concurrency !== "number") {
          callback = concurrency;
          concurrency = null;
        }
        callback = once(callback || promiseCallback());
        var numTasks = Object.keys(tasks).length;
        if (!numTasks) {
          return callback(null);
        }
        if (!concurrency) {
          concurrency = numTasks;
        }
        var results = {};
        var runningTasks = 0;
        var canceled = false;
        var hasError = false;
        var listeners = /* @__PURE__ */ Object.create(null);
        var readyTasks = [];
        var readyToCheck = [];
        var uncheckedDependencies = {};
        Object.keys(tasks).forEach((key) => {
          var task = tasks[key];
          if (!Array.isArray(task)) {
            enqueueTask(key, [task]);
            readyToCheck.push(key);
            return;
          }
          var dependencies = task.slice(0, task.length - 1);
          var remainingDependencies = dependencies.length;
          if (remainingDependencies === 0) {
            enqueueTask(key, task);
            readyToCheck.push(key);
            return;
          }
          uncheckedDependencies[key] = remainingDependencies;
          dependencies.forEach((dependencyName) => {
            if (!tasks[dependencyName]) {
              throw new Error("async.auto task `" + key + "` has a non-existent dependency `" + dependencyName + "` in " + dependencies.join(", "));
            }
            addListener(dependencyName, () => {
              remainingDependencies--;
              if (remainingDependencies === 0) {
                enqueueTask(key, task);
              }
            });
          });
        });
        checkForDeadlocks();
        processQueue();
        function enqueueTask(key, task) {
          readyTasks.push(() => runTask(key, task));
        }
        __name(enqueueTask, "enqueueTask");
        function processQueue() {
          if (canceled) return;
          if (readyTasks.length === 0 && runningTasks === 0) {
            return callback(null, results);
          }
          while (readyTasks.length && runningTasks < concurrency) {
            var run = readyTasks.shift();
            run();
          }
        }
        __name(processQueue, "processQueue");
        function addListener(taskName, fn) {
          var taskListeners = listeners[taskName];
          if (!taskListeners) {
            taskListeners = listeners[taskName] = [];
          }
          taskListeners.push(fn);
        }
        __name(addListener, "addListener");
        function taskComplete(taskName) {
          var taskListeners = listeners[taskName] || [];
          taskListeners.forEach((fn) => fn());
          processQueue();
        }
        __name(taskComplete, "taskComplete");
        function runTask(key, task) {
          if (hasError) return;
          var taskCallback = onlyOnce((err, ...result2) => {
            runningTasks--;
            if (err === false) {
              canceled = true;
              return;
            }
            if (result2.length < 2) {
              [result2] = result2;
            }
            if (err) {
              var safeResults = {};
              Object.keys(results).forEach((rkey) => {
                safeResults[rkey] = results[rkey];
              });
              safeResults[key] = result2;
              hasError = true;
              listeners = /* @__PURE__ */ Object.create(null);
              if (canceled) return;
              callback(err, safeResults);
            } else {
              results[key] = result2;
              taskComplete(key);
            }
          });
          runningTasks++;
          var taskFn = wrapAsync(task[task.length - 1]);
          if (task.length > 1) {
            taskFn(results, taskCallback);
          } else {
            taskFn(taskCallback);
          }
        }
        __name(runTask, "runTask");
        function checkForDeadlocks() {
          var currentTask;
          var counter = 0;
          while (readyToCheck.length) {
            currentTask = readyToCheck.pop();
            counter++;
            getDependents(currentTask).forEach((dependent) => {
              if (--uncheckedDependencies[dependent] === 0) {
                readyToCheck.push(dependent);
              }
            });
          }
          if (counter !== numTasks) {
            throw new Error(
              "async.auto cannot execute tasks due to a recursive dependency"
            );
          }
        }
        __name(checkForDeadlocks, "checkForDeadlocks");
        function getDependents(taskName) {
          var result2 = [];
          Object.keys(tasks).forEach((key) => {
            const task = tasks[key];
            if (Array.isArray(task) && task.indexOf(taskName) >= 0) {
              result2.push(key);
            }
          });
          return result2;
        }
        __name(getDependents, "getDependents");
        return callback[PROMISE_SYMBOL];
      }
      __name(auto, "auto");
      var FN_ARGS = /^(?:async\s)?(?:function)?\s*(?:\w+\s*)?\(([^)]+)\)(?:\s*{)/;
      var ARROW_FN_ARGS = /^(?:async\s)?\s*(?:\(\s*)?((?:[^)=\s]\s*)*)(?:\)\s*)?=>/;
      var FN_ARG_SPLIT = /,/;
      var FN_ARG = /(=.+)?(\s*)$/;
      function stripComments(string) {
        let stripped = "";
        let index2 = 0;
        let endBlockComment = string.indexOf("*/");
        while (index2 < string.length) {
          if (string[index2] === "/" && string[index2 + 1] === "/") {
            let endIndex = string.indexOf("\n", index2);
            index2 = endIndex === -1 ? string.length : endIndex;
          } else if (endBlockComment !== -1 && string[index2] === "/" && string[index2 + 1] === "*") {
            let endIndex = string.indexOf("*/", index2);
            if (endIndex !== -1) {
              index2 = endIndex + 2;
              endBlockComment = string.indexOf("*/", index2);
            } else {
              stripped += string[index2];
              index2++;
            }
          } else {
            stripped += string[index2];
            index2++;
          }
        }
        return stripped;
      }
      __name(stripComments, "stripComments");
      function parseParams(func) {
        const src = stripComments(func.toString());
        let match4 = src.match(FN_ARGS);
        if (!match4) {
          match4 = src.match(ARROW_FN_ARGS);
        }
        if (!match4) throw new Error("could not parse args in autoInject\nSource:\n" + src);
        let [, args] = match4;
        return args.replace(/\s/g, "").split(FN_ARG_SPLIT).map((arg) => arg.replace(FN_ARG, "").trim());
      }
      __name(parseParams, "parseParams");
      function autoInject(tasks, callback) {
        var newTasks = {};
        Object.keys(tasks).forEach((key) => {
          var taskFn = tasks[key];
          var params;
          var fnIsAsync = isAsync(taskFn);
          var hasNoDeps = !fnIsAsync && taskFn.length === 1 || fnIsAsync && taskFn.length === 0;
          if (Array.isArray(taskFn)) {
            params = [...taskFn];
            taskFn = params.pop();
            newTasks[key] = params.concat(params.length > 0 ? newTask : taskFn);
          } else if (hasNoDeps) {
            newTasks[key] = taskFn;
          } else {
            params = parseParams(taskFn);
            if (taskFn.length === 0 && !fnIsAsync && params.length === 0) {
              throw new Error("autoInject task functions require explicit parameters.");
            }
            if (!fnIsAsync) params.pop();
            newTasks[key] = params.concat(newTask);
          }
          function newTask(results, taskCb) {
            var newArgs = params.map((name) => results[name]);
            newArgs.push(taskCb);
            wrapAsync(taskFn)(...newArgs);
          }
          __name(newTask, "newTask");
        });
        return auto(newTasks, callback);
      }
      __name(autoInject, "autoInject");
      class DLL {
        static {
          __name(this, "DLL");
        }
        constructor() {
          this.head = this.tail = null;
          this.length = 0;
        }
        removeLink(node) {
          if (node.prev) node.prev.next = node.next;
          else this.head = node.next;
          if (node.next) node.next.prev = node.prev;
          else this.tail = node.prev;
          node.prev = node.next = null;
          this.length -= 1;
          return node;
        }
        empty() {
          while (this.head) this.shift();
          return this;
        }
        insertAfter(node, newNode) {
          newNode.prev = node;
          newNode.next = node.next;
          if (node.next) node.next.prev = newNode;
          else this.tail = newNode;
          node.next = newNode;
          this.length += 1;
        }
        insertBefore(node, newNode) {
          newNode.prev = node.prev;
          newNode.next = node;
          if (node.prev) node.prev.next = newNode;
          else this.head = newNode;
          node.prev = newNode;
          this.length += 1;
        }
        unshift(node) {
          if (this.head) this.insertBefore(this.head, node);
          else setInitial(this, node);
        }
        push(node) {
          if (this.tail) this.insertAfter(this.tail, node);
          else setInitial(this, node);
        }
        shift() {
          return this.head && this.removeLink(this.head);
        }
        pop() {
          return this.tail && this.removeLink(this.tail);
        }
        toArray() {
          return [...this];
        }
        *[Symbol.iterator]() {
          var cur = this.head;
          while (cur) {
            yield cur.data;
            cur = cur.next;
          }
        }
        remove(testFn) {
          var curr = this.head;
          while (curr) {
            var { next } = curr;
            if (testFn(curr)) {
              this.removeLink(curr);
            }
            curr = next;
          }
          return this;
        }
      }
      function setInitial(dll, node) {
        dll.length = 1;
        dll.head = dll.tail = node;
      }
      __name(setInitial, "setInitial");
      function queue$1(worker, concurrency, payload2) {
        if (concurrency == null) {
          concurrency = 1;
        } else if (concurrency === 0) {
          throw new RangeError("Concurrency must not be zero");
        }
        var _worker = wrapAsync(worker);
        var numRunning = 0;
        var workersList = [];
        const events = {
          error: [],
          drain: [],
          saturated: [],
          unsaturated: [],
          empty: []
        };
        function on(event, handler) {
          events[event].push(handler);
        }
        __name(on, "on");
        function once2(event, handler) {
          const handleAndRemove = /* @__PURE__ */ __name((...args) => {
            off(event, handleAndRemove);
            handler(...args);
          }, "handleAndRemove");
          events[event].push(handleAndRemove);
        }
        __name(once2, "once");
        function off(event, handler) {
          if (!event) return Object.keys(events).forEach((ev) => events[ev] = []);
          if (!handler) return events[event] = [];
          events[event] = events[event].filter((ev) => ev !== handler);
        }
        __name(off, "off");
        function trigger(event, ...args) {
          events[event].forEach((handler) => handler(...args));
        }
        __name(trigger, "trigger");
        var processingScheduled = false;
        function _insert(data3, insertAtFront, rejectOnError, callback) {
          if (callback != null && typeof callback !== "function") {
            throw new Error("task callback must be a function");
          }
          q13.started = true;
          var res, rej;
          function promiseCallback2(err, ...args) {
            if (err) return rejectOnError ? rej(err) : res();
            if (args.length <= 1) return res(args[0]);
            res(args);
          }
          __name(promiseCallback2, "promiseCallback");
          var item = q13._createTaskItem(
            data3,
            rejectOnError ? promiseCallback2 : callback || promiseCallback2
          );
          if (insertAtFront) {
            q13._tasks.unshift(item);
          } else {
            q13._tasks.push(item);
          }
          if (!processingScheduled) {
            processingScheduled = true;
            setImmediate$1(() => {
              processingScheduled = false;
              q13.process();
            });
          }
          if (rejectOnError || !callback) {
            return new Promise((resolve16, reject2) => {
              res = resolve16;
              rej = reject2;
            });
          }
        }
        __name(_insert, "_insert");
        function _createCB(tasks) {
          return function(err, ...args) {
            numRunning -= 1;
            for (var i13 = 0, l13 = tasks.length; i13 < l13; i13++) {
              var task = tasks[i13];
              var index2 = workersList.indexOf(task);
              if (index2 === 0) {
                workersList.shift();
              } else if (index2 > 0) {
                workersList.splice(index2, 1);
              }
              task.callback(err, ...args);
              if (err != null) {
                trigger("error", err, task.data);
              }
            }
            if (numRunning <= q13.concurrency - q13.buffer) {
              trigger("unsaturated");
            }
            if (q13.idle()) {
              trigger("drain");
            }
            q13.process();
          };
        }
        __name(_createCB, "_createCB");
        function _maybeDrain(data3) {
          if (data3.length === 0 && q13.idle()) {
            setImmediate$1(() => trigger("drain"));
            return true;
          }
          return false;
        }
        __name(_maybeDrain, "_maybeDrain");
        const eventMethod = /* @__PURE__ */ __name((name) => (handler) => {
          if (!handler) {
            return new Promise((resolve16, reject2) => {
              once2(name, (err, data3) => {
                if (err) return reject2(err);
                resolve16(data3);
              });
            });
          }
          off(name);
          on(name, handler);
        }, "eventMethod");
        var isProcessing = false;
        var q13 = {
          _tasks: new DLL(),
          _createTaskItem(data3, callback) {
            return {
              data: data3,
              callback
            };
          },
          *[Symbol.iterator]() {
            yield* q13._tasks[Symbol.iterator]();
          },
          concurrency,
          payload: payload2,
          buffer: concurrency / 4,
          started: false,
          paused: false,
          push(data3, callback) {
            if (Array.isArray(data3)) {
              if (_maybeDrain(data3)) return;
              return data3.map((datum) => _insert(datum, false, false, callback));
            }
            return _insert(data3, false, false, callback);
          },
          pushAsync(data3, callback) {
            if (Array.isArray(data3)) {
              if (_maybeDrain(data3)) return;
              return data3.map((datum) => _insert(datum, false, true, callback));
            }
            return _insert(data3, false, true, callback);
          },
          kill() {
            off();
            q13._tasks.empty();
          },
          unshift(data3, callback) {
            if (Array.isArray(data3)) {
              if (_maybeDrain(data3)) return;
              return data3.map((datum) => _insert(datum, true, false, callback));
            }
            return _insert(data3, true, false, callback);
          },
          unshiftAsync(data3, callback) {
            if (Array.isArray(data3)) {
              if (_maybeDrain(data3)) return;
              return data3.map((datum) => _insert(datum, true, true, callback));
            }
            return _insert(data3, true, true, callback);
          },
          remove(testFn) {
            q13._tasks.remove(testFn);
          },
          process() {
            if (isProcessing) {
              return;
            }
            isProcessing = true;
            while (!q13.paused && numRunning < q13.concurrency && q13._tasks.length) {
              var tasks = [], data3 = [];
              var l13 = q13._tasks.length;
              if (q13.payload) l13 = Math.min(l13, q13.payload);
              for (var i13 = 0; i13 < l13; i13++) {
                var node = q13._tasks.shift();
                tasks.push(node);
                workersList.push(node);
                data3.push(node.data);
              }
              numRunning += 1;
              if (q13._tasks.length === 0) {
                trigger("empty");
              }
              if (numRunning === q13.concurrency) {
                trigger("saturated");
              }
              var cb = onlyOnce(_createCB(tasks));
              _worker(data3, cb);
            }
            isProcessing = false;
          },
          length() {
            return q13._tasks.length;
          },
          running() {
            return numRunning;
          },
          workersList() {
            return workersList;
          },
          idle() {
            return q13._tasks.length + numRunning === 0;
          },
          pause() {
            q13.paused = true;
          },
          resume() {
            if (q13.paused === false) {
              return;
            }
            q13.paused = false;
            setImmediate$1(q13.process);
          }
        };
        Object.defineProperties(q13, {
          saturated: {
            writable: false,
            value: eventMethod("saturated")
          },
          unsaturated: {
            writable: false,
            value: eventMethod("unsaturated")
          },
          empty: {
            writable: false,
            value: eventMethod("empty")
          },
          drain: {
            writable: false,
            value: eventMethod("drain")
          },
          error: {
            writable: false,
            value: eventMethod("error")
          }
        });
        return q13;
      }
      __name(queue$1, "queue$1");
      function cargo$1(worker, payload2) {
        return queue$1(worker, 1, payload2);
      }
      __name(cargo$1, "cargo$1");
      function cargo(worker, concurrency, payload2) {
        return queue$1(worker, concurrency, payload2);
      }
      __name(cargo, "cargo");
      function reduce(coll, memo, iteratee, callback) {
        callback = once(callback);
        var _iteratee = wrapAsync(iteratee);
        return eachOfSeries$1(coll, (x13, i13, iterCb) => {
          _iteratee(memo, x13, (err, v14) => {
            memo = v14;
            iterCb(err);
          });
        }, (err) => callback(err, memo));
      }
      __name(reduce, "reduce");
      var reduce$1 = awaitify(reduce, 4);
      function seq(...functions) {
        var _functions = functions.map(wrapAsync);
        return function(...args) {
          var that = this;
          var cb = args[args.length - 1];
          if (typeof cb == "function") {
            args.pop();
          } else {
            cb = promiseCallback();
          }
          reduce$1(
            _functions,
            args,
            (newargs, fn, iterCb) => {
              fn.apply(that, newargs.concat((err, ...nextargs) => {
                iterCb(err, nextargs);
              }));
            },
            (err, results) => cb(err, ...results)
          );
          return cb[PROMISE_SYMBOL];
        };
      }
      __name(seq, "seq");
      function compose(...args) {
        return seq(...args.reverse());
      }
      __name(compose, "compose");
      function mapLimit(coll, limit, iteratee, callback) {
        return _asyncMap(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(mapLimit, "mapLimit");
      var mapLimit$1 = awaitify(mapLimit, 4);
      function concatLimit(coll, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(coll, limit, (val, iterCb) => {
          _iteratee(val, (err, ...args) => {
            if (err) return iterCb(err);
            return iterCb(err, args);
          });
        }, (err, mapResults) => {
          var result2 = [];
          for (var i13 = 0; i13 < mapResults.length; i13++) {
            if (mapResults[i13]) {
              result2 = result2.concat(...mapResults[i13]);
            }
          }
          return callback(err, result2);
        });
      }
      __name(concatLimit, "concatLimit");
      var concatLimit$1 = awaitify(concatLimit, 4);
      function concat(coll, iteratee, callback) {
        return concatLimit$1(coll, Infinity, iteratee, callback);
      }
      __name(concat, "concat");
      var concat$1 = awaitify(concat, 3);
      function concatSeries(coll, iteratee, callback) {
        return concatLimit$1(coll, 1, iteratee, callback);
      }
      __name(concatSeries, "concatSeries");
      var concatSeries$1 = awaitify(concatSeries, 3);
      function constant$1(...args) {
        return function(...ignoredArgs) {
          var callback = ignoredArgs.pop();
          return callback(null, ...args);
        };
      }
      __name(constant$1, "constant$1");
      function _createTester(check, getResult) {
        return (eachfn, arr, _iteratee, cb) => {
          var testPassed = false;
          var testResult;
          const iteratee = wrapAsync(_iteratee);
          eachfn(arr, (value, _2, callback) => {
            iteratee(value, (err, result2) => {
              if (err || err === false) return callback(err);
              if (check(result2) && !testResult) {
                testPassed = true;
                testResult = getResult(true, value);
                return callback(null, breakLoop);
              }
              callback();
            });
          }, (err) => {
            if (err) return cb(err);
            cb(null, testPassed ? testResult : getResult(false));
          });
        };
      }
      __name(_createTester, "_createTester");
      function detect(coll, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOf$1, coll, iteratee, callback);
      }
      __name(detect, "detect");
      var detect$1 = awaitify(detect, 3);
      function detectLimit(coll, limit, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(detectLimit, "detectLimit");
      var detectLimit$1 = awaitify(detectLimit, 4);
      function detectSeries(coll, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOfLimit$2(1), coll, iteratee, callback);
      }
      __name(detectSeries, "detectSeries");
      var detectSeries$1 = awaitify(detectSeries, 3);
      function consoleFunc(name) {
        return (fn, ...args) => wrapAsync(fn)(...args, (err, ...resultArgs) => {
          if (typeof console === "object") {
            if (err) {
              if (console.error) {
                console.error(err);
              }
            } else if (console[name]) {
              resultArgs.forEach((x13) => console[name](x13));
            }
          }
        });
      }
      __name(consoleFunc, "consoleFunc");
      var dir = consoleFunc("dir");
      function doWhilst(iteratee, test, callback) {
        callback = onlyOnce(callback);
        var _fn = wrapAsync(iteratee);
        var _test = wrapAsync(test);
        var results;
        function next(err, ...args) {
          if (err) return callback(err);
          if (err === false) return;
          results = args;
          _test(...args, check);
        }
        __name(next, "next");
        function check(err, truth) {
          if (err) return callback(err);
          if (err === false) return;
          if (!truth) return callback(null, ...results);
          _fn(next);
        }
        __name(check, "check");
        return check(null, true);
      }
      __name(doWhilst, "doWhilst");
      var doWhilst$1 = awaitify(doWhilst, 3);
      function doUntil(iteratee, test, callback) {
        const _test = wrapAsync(test);
        return doWhilst$1(iteratee, (...args) => {
          const cb = args.pop();
          _test(...args, (err, truth) => cb(err, !truth));
        }, callback);
      }
      __name(doUntil, "doUntil");
      function _withoutIndex(iteratee) {
        return (value, index2, callback) => iteratee(value, callback);
      }
      __name(_withoutIndex, "_withoutIndex");
      function eachLimit$2(coll, iteratee, callback) {
        return eachOf$1(coll, _withoutIndex(wrapAsync(iteratee)), callback);
      }
      __name(eachLimit$2, "eachLimit$2");
      var each = awaitify(eachLimit$2, 3);
      function eachLimit(coll, limit, iteratee, callback) {
        return eachOfLimit$2(limit)(coll, _withoutIndex(wrapAsync(iteratee)), callback);
      }
      __name(eachLimit, "eachLimit");
      var eachLimit$1 = awaitify(eachLimit, 4);
      function eachSeries(coll, iteratee, callback) {
        return eachLimit$1(coll, 1, iteratee, callback);
      }
      __name(eachSeries, "eachSeries");
      var eachSeries$1 = awaitify(eachSeries, 3);
      function ensureAsync(fn) {
        if (isAsync(fn)) return fn;
        return function(...args) {
          var callback = args.pop();
          var sync2 = true;
          args.push((...innerArgs) => {
            if (sync2) {
              setImmediate$1(() => callback(...innerArgs));
            } else {
              callback(...innerArgs);
            }
          });
          fn.apply(this, args);
          sync2 = false;
        };
      }
      __name(ensureAsync, "ensureAsync");
      function every(coll, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOf$1, coll, iteratee, callback);
      }
      __name(every, "every");
      var every$1 = awaitify(every, 3);
      function everyLimit(coll, limit, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(everyLimit, "everyLimit");
      var everyLimit$1 = awaitify(everyLimit, 4);
      function everySeries(coll, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOfSeries$1, coll, iteratee, callback);
      }
      __name(everySeries, "everySeries");
      var everySeries$1 = awaitify(everySeries, 3);
      function filterArray(eachfn, arr, iteratee, callback) {
        var truthValues = new Array(arr.length);
        eachfn(arr, (x13, index2, iterCb) => {
          iteratee(x13, (err, v14) => {
            truthValues[index2] = !!v14;
            iterCb(err);
          });
        }, (err) => {
          if (err) return callback(err);
          var results = [];
          for (var i13 = 0; i13 < arr.length; i13++) {
            if (truthValues[i13]) results.push(arr[i13]);
          }
          callback(null, results);
        });
      }
      __name(filterArray, "filterArray");
      function filterGeneric(eachfn, coll, iteratee, callback) {
        var results = [];
        eachfn(coll, (x13, index2, iterCb) => {
          iteratee(x13, (err, v14) => {
            if (err) return iterCb(err);
            if (v14) {
              results.push({ index: index2, value: x13 });
            }
            iterCb(err);
          });
        }, (err) => {
          if (err) return callback(err);
          callback(null, results.sort((a13, b13) => a13.index - b13.index).map((v14) => v14.value));
        });
      }
      __name(filterGeneric, "filterGeneric");
      function _filter(eachfn, coll, iteratee, callback) {
        var filter5 = isArrayLike(coll) ? filterArray : filterGeneric;
        return filter5(eachfn, coll, wrapAsync(iteratee), callback);
      }
      __name(_filter, "_filter");
      function filter4(coll, iteratee, callback) {
        return _filter(eachOf$1, coll, iteratee, callback);
      }
      __name(filter4, "filter");
      var filter$1 = awaitify(filter4, 3);
      function filterLimit(coll, limit, iteratee, callback) {
        return _filter(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(filterLimit, "filterLimit");
      var filterLimit$1 = awaitify(filterLimit, 4);
      function filterSeries(coll, iteratee, callback) {
        return _filter(eachOfSeries$1, coll, iteratee, callback);
      }
      __name(filterSeries, "filterSeries");
      var filterSeries$1 = awaitify(filterSeries, 3);
      function forever(fn, errback) {
        var done = onlyOnce(errback);
        var task = wrapAsync(ensureAsync(fn));
        function next(err) {
          if (err) return done(err);
          if (err === false) return;
          task(next);
        }
        __name(next, "next");
        return next();
      }
      __name(forever, "forever");
      var forever$1 = awaitify(forever, 2);
      function groupByLimit(coll, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(coll, limit, (val, iterCb) => {
          _iteratee(val, (err, key) => {
            if (err) return iterCb(err);
            return iterCb(err, { key, val });
          });
        }, (err, mapResults) => {
          var result2 = {};
          var { hasOwnProperty: hasOwnProperty2 } = Object.prototype;
          for (var i13 = 0; i13 < mapResults.length; i13++) {
            if (mapResults[i13]) {
              var { key } = mapResults[i13];
              var { val } = mapResults[i13];
              if (hasOwnProperty2.call(result2, key)) {
                result2[key].push(val);
              } else {
                result2[key] = [val];
              }
            }
          }
          return callback(err, result2);
        });
      }
      __name(groupByLimit, "groupByLimit");
      var groupByLimit$1 = awaitify(groupByLimit, 4);
      function groupBy(coll, iteratee, callback) {
        return groupByLimit$1(coll, Infinity, iteratee, callback);
      }
      __name(groupBy, "groupBy");
      function groupBySeries(coll, iteratee, callback) {
        return groupByLimit$1(coll, 1, iteratee, callback);
      }
      __name(groupBySeries, "groupBySeries");
      var log = consoleFunc("log");
      function mapValuesLimit(obj, limit, iteratee, callback) {
        callback = once(callback);
        var newObj = {};
        var _iteratee = wrapAsync(iteratee);
        return eachOfLimit$2(limit)(obj, (val, key, next) => {
          _iteratee(val, key, (err, result2) => {
            if (err) return next(err);
            newObj[key] = result2;
            next(err);
          });
        }, (err) => callback(err, newObj));
      }
      __name(mapValuesLimit, "mapValuesLimit");
      var mapValuesLimit$1 = awaitify(mapValuesLimit, 4);
      function mapValues(obj, iteratee, callback) {
        return mapValuesLimit$1(obj, Infinity, iteratee, callback);
      }
      __name(mapValues, "mapValues");
      function mapValuesSeries(obj, iteratee, callback) {
        return mapValuesLimit$1(obj, 1, iteratee, callback);
      }
      __name(mapValuesSeries, "mapValuesSeries");
      function memoize2(fn, hasher = (v14) => v14) {
        var memo = /* @__PURE__ */ Object.create(null);
        var queues = /* @__PURE__ */ Object.create(null);
        var _fn = wrapAsync(fn);
        var memoized = initialParams((args, callback) => {
          var key = hasher(...args);
          if (key in memo) {
            setImmediate$1(() => callback(null, ...memo[key]));
          } else if (key in queues) {
            queues[key].push(callback);
          } else {
            queues[key] = [callback];
            _fn(...args, (err, ...resultArgs) => {
              if (!err) {
                memo[key] = resultArgs;
              }
              var q13 = queues[key];
              delete queues[key];
              for (var i13 = 0, l13 = q13.length; i13 < l13; i13++) {
                q13[i13](err, ...resultArgs);
              }
            });
          }
        });
        memoized.memo = memo;
        memoized.unmemoized = fn;
        return memoized;
      }
      __name(memoize2, "memoize");
      var _defer;
      if (hasNextTick) {
        _defer = process.nextTick;
      } else if (hasSetImmediate) {
        _defer = setImmediate;
      } else {
        _defer = fallback;
      }
      var nextTick = wrap(_defer);
      var _parallel = awaitify((eachfn, tasks, callback) => {
        var results = isArrayLike(tasks) ? [] : {};
        eachfn(tasks, (task, key, taskCb) => {
          wrapAsync(task)((err, ...result2) => {
            if (result2.length < 2) {
              [result2] = result2;
            }
            results[key] = result2;
            taskCb(err);
          });
        }, (err) => callback(err, results));
      }, 3);
      function parallel(tasks, callback) {
        return _parallel(eachOf$1, tasks, callback);
      }
      __name(parallel, "parallel");
      function parallelLimit(tasks, limit, callback) {
        return _parallel(eachOfLimit$2(limit), tasks, callback);
      }
      __name(parallelLimit, "parallelLimit");
      function queue(worker, concurrency) {
        var _worker = wrapAsync(worker);
        return queue$1((items, cb) => {
          _worker(items[0], cb);
        }, concurrency, 1);
      }
      __name(queue, "queue");
      class Heap {
        static {
          __name(this, "Heap");
        }
        constructor() {
          this.heap = [];
          this.pushCount = Number.MIN_SAFE_INTEGER;
        }
        get length() {
          return this.heap.length;
        }
        empty() {
          this.heap = [];
          return this;
        }
        percUp(index2) {
          let p13;
          while (index2 > 0 && smaller(this.heap[index2], this.heap[p13 = parent(index2)])) {
            let t13 = this.heap[index2];
            this.heap[index2] = this.heap[p13];
            this.heap[p13] = t13;
            index2 = p13;
          }
        }
        percDown(index2) {
          let l13;
          while ((l13 = leftChi(index2)) < this.heap.length) {
            if (l13 + 1 < this.heap.length && smaller(this.heap[l13 + 1], this.heap[l13])) {
              l13 = l13 + 1;
            }
            if (smaller(this.heap[index2], this.heap[l13])) {
              break;
            }
            let t13 = this.heap[index2];
            this.heap[index2] = this.heap[l13];
            this.heap[l13] = t13;
            index2 = l13;
          }
        }
        push(node) {
          node.pushCount = ++this.pushCount;
          this.heap.push(node);
          this.percUp(this.heap.length - 1);
        }
        unshift(node) {
          return this.heap.push(node);
        }
        shift() {
          let [top] = this.heap;
          this.heap[0] = this.heap[this.heap.length - 1];
          this.heap.pop();
          this.percDown(0);
          return top;
        }
        toArray() {
          return [...this];
        }
        *[Symbol.iterator]() {
          for (let i13 = 0; i13 < this.heap.length; i13++) {
            yield this.heap[i13].data;
          }
        }
        remove(testFn) {
          let j13 = 0;
          for (let i13 = 0; i13 < this.heap.length; i13++) {
            if (!testFn(this.heap[i13])) {
              this.heap[j13] = this.heap[i13];
              j13++;
            }
          }
          this.heap.splice(j13);
          for (let i13 = parent(this.heap.length - 1); i13 >= 0; i13--) {
            this.percDown(i13);
          }
          return this;
        }
      }
      function leftChi(i13) {
        return (i13 << 1) + 1;
      }
      __name(leftChi, "leftChi");
      function parent(i13) {
        return (i13 + 1 >> 1) - 1;
      }
      __name(parent, "parent");
      function smaller(x13, y5) {
        if (x13.priority !== y5.priority) {
          return x13.priority < y5.priority;
        } else {
          return x13.pushCount < y5.pushCount;
        }
      }
      __name(smaller, "smaller");
      function priorityQueue(worker, concurrency) {
        var q13 = queue(worker, concurrency);
        var {
          push,
          pushAsync
        } = q13;
        q13._tasks = new Heap();
        q13._createTaskItem = ({ data: data3, priority }, callback) => {
          return {
            data: data3,
            priority,
            callback
          };
        };
        function createDataItems(tasks, priority) {
          if (!Array.isArray(tasks)) {
            return { data: tasks, priority };
          }
          return tasks.map((data3) => {
            return { data: data3, priority };
          });
        }
        __name(createDataItems, "createDataItems");
        q13.push = function(data3, priority = 0, callback) {
          return push(createDataItems(data3, priority), callback);
        };
        q13.pushAsync = function(data3, priority = 0, callback) {
          return pushAsync(createDataItems(data3, priority), callback);
        };
        delete q13.unshift;
        delete q13.unshiftAsync;
        return q13;
      }
      __name(priorityQueue, "priorityQueue");
      function race(tasks, callback) {
        callback = once(callback);
        if (!Array.isArray(tasks)) return callback(new TypeError("First argument to race must be an array of functions"));
        if (!tasks.length) return callback();
        for (var i13 = 0, l13 = tasks.length; i13 < l13; i13++) {
          wrapAsync(tasks[i13])(callback);
        }
      }
      __name(race, "race");
      var race$1 = awaitify(race, 2);
      function reduceRight(array, memo, iteratee, callback) {
        var reversed = [...array].reverse();
        return reduce$1(reversed, memo, iteratee, callback);
      }
      __name(reduceRight, "reduceRight");
      function reflect(fn) {
        var _fn = wrapAsync(fn);
        return initialParams(/* @__PURE__ */ __name(function reflectOn(args, reflectCallback) {
          args.push((error5, ...cbArgs) => {
            let retVal = {};
            if (error5) {
              retVal.error = error5;
            }
            if (cbArgs.length > 0) {
              var value = cbArgs;
              if (cbArgs.length <= 1) {
                [value] = cbArgs;
              }
              retVal.value = value;
            }
            reflectCallback(null, retVal);
          });
          return _fn.apply(this, args);
        }, "reflectOn"));
      }
      __name(reflect, "reflect");
      function reflectAll(tasks) {
        var results;
        if (Array.isArray(tasks)) {
          results = tasks.map(reflect);
        } else {
          results = {};
          Object.keys(tasks).forEach((key) => {
            results[key] = reflect.call(this, tasks[key]);
          });
        }
        return results;
      }
      __name(reflectAll, "reflectAll");
      function reject$2(eachfn, arr, _iteratee, callback) {
        const iteratee = wrapAsync(_iteratee);
        return _filter(eachfn, arr, (value, cb) => {
          iteratee(value, (err, v14) => {
            cb(err, !v14);
          });
        }, callback);
      }
      __name(reject$2, "reject$2");
      function reject(coll, iteratee, callback) {
        return reject$2(eachOf$1, coll, iteratee, callback);
      }
      __name(reject, "reject");
      var reject$1 = awaitify(reject, 3);
      function rejectLimit(coll, limit, iteratee, callback) {
        return reject$2(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(rejectLimit, "rejectLimit");
      var rejectLimit$1 = awaitify(rejectLimit, 4);
      function rejectSeries(coll, iteratee, callback) {
        return reject$2(eachOfSeries$1, coll, iteratee, callback);
      }
      __name(rejectSeries, "rejectSeries");
      var rejectSeries$1 = awaitify(rejectSeries, 3);
      function constant(value) {
        return function() {
          return value;
        };
      }
      __name(constant, "constant");
      const DEFAULT_TIMES = 5;
      const DEFAULT_INTERVAL = 0;
      function retry(opts, task, callback) {
        var options = {
          times: DEFAULT_TIMES,
          intervalFunc: constant(DEFAULT_INTERVAL)
        };
        if (arguments.length < 3 && typeof opts === "function") {
          callback = task || promiseCallback();
          task = opts;
        } else {
          parseTimes(options, opts);
          callback = callback || promiseCallback();
        }
        if (typeof task !== "function") {
          throw new Error("Invalid arguments for async.retry");
        }
        var _task = wrapAsync(task);
        var attempt = 1;
        function retryAttempt() {
          _task((err, ...args) => {
            if (err === false) return;
            if (err && attempt++ < options.times && (typeof options.errorFilter != "function" || options.errorFilter(err))) {
              setTimeout(retryAttempt, options.intervalFunc(attempt - 1));
            } else {
              callback(err, ...args);
            }
          });
        }
        __name(retryAttempt, "retryAttempt");
        retryAttempt();
        return callback[PROMISE_SYMBOL];
      }
      __name(retry, "retry");
      function parseTimes(acc, t13) {
        if (typeof t13 === "object") {
          acc.times = +t13.times || DEFAULT_TIMES;
          acc.intervalFunc = typeof t13.interval === "function" ? t13.interval : constant(+t13.interval || DEFAULT_INTERVAL);
          acc.errorFilter = t13.errorFilter;
        } else if (typeof t13 === "number" || typeof t13 === "string") {
          acc.times = +t13 || DEFAULT_TIMES;
        } else {
          throw new Error("Invalid arguments for async.retry");
        }
      }
      __name(parseTimes, "parseTimes");
      function retryable(opts, task) {
        if (!task) {
          task = opts;
          opts = null;
        }
        let arity = opts && opts.arity || task.length;
        if (isAsync(task)) {
          arity += 1;
        }
        var _task = wrapAsync(task);
        return initialParams((args, callback) => {
          if (args.length < arity - 1 || callback == null) {
            args.push(callback);
            callback = promiseCallback();
          }
          function taskFn(cb) {
            _task(...args, cb);
          }
          __name(taskFn, "taskFn");
          if (opts) retry(opts, taskFn, callback);
          else retry(taskFn, callback);
          return callback[PROMISE_SYMBOL];
        });
      }
      __name(retryable, "retryable");
      function series(tasks, callback) {
        return _parallel(eachOfSeries$1, tasks, callback);
      }
      __name(series, "series");
      function some2(coll, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOf$1, coll, iteratee, callback);
      }
      __name(some2, "some");
      var some$1 = awaitify(some2, 3);
      function someLimit(coll, limit, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      __name(someLimit, "someLimit");
      var someLimit$1 = awaitify(someLimit, 4);
      function someSeries(coll, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOfSeries$1, coll, iteratee, callback);
      }
      __name(someSeries, "someSeries");
      var someSeries$1 = awaitify(someSeries, 3);
      function sortBy(coll, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return map$1(coll, (x13, iterCb) => {
          _iteratee(x13, (err, criteria) => {
            if (err) return iterCb(err);
            iterCb(err, { value: x13, criteria });
          });
        }, (err, results) => {
          if (err) return callback(err);
          callback(null, results.sort(comparator).map((v14) => v14.value));
        });
        function comparator(left, right) {
          var a13 = left.criteria, b13 = right.criteria;
          return a13 < b13 ? -1 : a13 > b13 ? 1 : 0;
        }
        __name(comparator, "comparator");
      }
      __name(sortBy, "sortBy");
      var sortBy$1 = awaitify(sortBy, 3);
      function timeout(asyncFn, milliseconds, info2) {
        var fn = wrapAsync(asyncFn);
        return initialParams((args, callback) => {
          var timedOut = false;
          var timer;
          function timeoutCallback() {
            var name = asyncFn.name || "anonymous";
            var error5 = new Error('Callback function "' + name + '" timed out.');
            error5.code = "ETIMEDOUT";
            if (info2) {
              error5.info = info2;
            }
            timedOut = true;
            callback(error5);
          }
          __name(timeoutCallback, "timeoutCallback");
          args.push((...cbArgs) => {
            if (!timedOut) {
              callback(...cbArgs);
              clearTimeout(timer);
            }
          });
          timer = setTimeout(timeoutCallback, milliseconds);
          fn(...args);
        });
      }
      __name(timeout, "timeout");
      function range3(size) {
        var result2 = Array(size);
        while (size--) {
          result2[size] = size;
        }
        return result2;
      }
      __name(range3, "range");
      function timesLimit(count, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(range3(count), limit, _iteratee, callback);
      }
      __name(timesLimit, "timesLimit");
      function times(n13, iteratee, callback) {
        return timesLimit(n13, Infinity, iteratee, callback);
      }
      __name(times, "times");
      function timesSeries(n13, iteratee, callback) {
        return timesLimit(n13, 1, iteratee, callback);
      }
      __name(timesSeries, "timesSeries");
      function transform(coll, accumulator, iteratee, callback) {
        if (arguments.length <= 3 && typeof accumulator === "function") {
          callback = iteratee;
          iteratee = accumulator;
          accumulator = Array.isArray(coll) ? [] : {};
        }
        callback = once(callback || promiseCallback());
        var _iteratee = wrapAsync(iteratee);
        eachOf$1(coll, (v14, k13, cb) => {
          _iteratee(accumulator, v14, k13, cb);
        }, (err) => callback(err, accumulator));
        return callback[PROMISE_SYMBOL];
      }
      __name(transform, "transform");
      function tryEach(tasks, callback) {
        var error5 = null;
        var result2;
        return eachSeries$1(tasks, (task, taskCb) => {
          wrapAsync(task)((err, ...args) => {
            if (err === false) return taskCb(err);
            if (args.length < 2) {
              [result2] = args;
            } else {
              result2 = args;
            }
            error5 = err;
            taskCb(err ? null : {});
          });
        }, () => callback(error5, result2));
      }
      __name(tryEach, "tryEach");
      var tryEach$1 = awaitify(tryEach);
      function unmemoize(fn) {
        return (...args) => {
          return (fn.unmemoized || fn)(...args);
        };
      }
      __name(unmemoize, "unmemoize");
      function whilst(test, iteratee, callback) {
        callback = onlyOnce(callback);
        var _fn = wrapAsync(iteratee);
        var _test = wrapAsync(test);
        var results = [];
        function next(err, ...rest) {
          if (err) return callback(err);
          results = rest;
          if (err === false) return;
          _test(check);
        }
        __name(next, "next");
        function check(err, truth) {
          if (err) return callback(err);
          if (err === false) return;
          if (!truth) return callback(null, ...results);
          _fn(next);
        }
        __name(check, "check");
        return _test(check);
      }
      __name(whilst, "whilst");
      var whilst$1 = awaitify(whilst, 3);
      function until(test, iteratee, callback) {
        const _test = wrapAsync(test);
        return whilst$1((cb) => _test((err, truth) => cb(err, !truth)), iteratee, callback);
      }
      __name(until, "until");
      function waterfall(tasks, callback) {
        callback = once(callback);
        if (!Array.isArray(tasks)) return callback(new Error("First argument to waterfall must be an array of functions"));
        if (!tasks.length) return callback();
        var taskIndex = 0;
        function nextTask(args) {
          var task = wrapAsync(tasks[taskIndex++]);
          task(...args, onlyOnce(next));
        }
        __name(nextTask, "nextTask");
        function next(err, ...args) {
          if (err === false) return;
          if (err || taskIndex === tasks.length) {
            return callback(err, ...args);
          }
          nextTask(args);
        }
        __name(next, "next");
        nextTask([]);
      }
      __name(waterfall, "waterfall");
      var waterfall$1 = awaitify(waterfall);
      var index = {
        apply,
        applyEach,
        applyEachSeries,
        asyncify,
        auto,
        autoInject,
        cargo: cargo$1,
        cargoQueue: cargo,
        compose,
        concat: concat$1,
        concatLimit: concatLimit$1,
        concatSeries: concatSeries$1,
        constant: constant$1,
        detect: detect$1,
        detectLimit: detectLimit$1,
        detectSeries: detectSeries$1,
        dir,
        doUntil,
        doWhilst: doWhilst$1,
        each,
        eachLimit: eachLimit$1,
        eachOf: eachOf$1,
        eachOfLimit: eachOfLimit$1,
        eachOfSeries: eachOfSeries$1,
        eachSeries: eachSeries$1,
        ensureAsync,
        every: every$1,
        everyLimit: everyLimit$1,
        everySeries: everySeries$1,
        filter: filter$1,
        filterLimit: filterLimit$1,
        filterSeries: filterSeries$1,
        forever: forever$1,
        groupBy,
        groupByLimit: groupByLimit$1,
        groupBySeries,
        log,
        map: map$1,
        mapLimit: mapLimit$1,
        mapSeries: mapSeries$1,
        mapValues,
        mapValuesLimit: mapValuesLimit$1,
        mapValuesSeries,
        memoize: memoize2,
        nextTick,
        parallel,
        parallelLimit,
        priorityQueue,
        queue,
        race: race$1,
        reduce: reduce$1,
        reduceRight,
        reflect,
        reflectAll,
        reject: reject$1,
        rejectLimit: rejectLimit$1,
        rejectSeries: rejectSeries$1,
        retry,
        retryable,
        seq,
        series,
        setImmediate: setImmediate$1,
        some: some$1,
        someLimit: someLimit$1,
        someSeries: someSeries$1,
        sortBy: sortBy$1,
        timeout,
        times,
        timesLimit,
        timesSeries,
        transform,
        tryEach: tryEach$1,
        unmemoize,
        until,
        waterfall: waterfall$1,
        whilst: whilst$1,
        // aliases
        all: every$1,
        allLimit: everyLimit$1,
        allSeries: everySeries$1,
        any: some$1,
        anyLimit: someLimit$1,
        anySeries: someSeries$1,
        find: detect$1,
        findLimit: detectLimit$1,
        findSeries: detectSeries$1,
        flatMap: concat$1,
        flatMapLimit: concatLimit$1,
        flatMapSeries: concatSeries$1,
        forEach: each,
        forEachSeries: eachSeries$1,
        forEachLimit: eachLimit$1,
        forEachOf: eachOf$1,
        forEachOfSeries: eachOfSeries$1,
        forEachOfLimit: eachOfLimit$1,
        inject: reduce$1,
        foldl: reduce$1,
        foldr: reduceRight,
        select: filter$1,
        selectLimit: filterLimit$1,
        selectSeries: filterSeries$1,
        wrapSync: asyncify,
        during: whilst$1,
        doDuring: doWhilst$1
      };
      exports3.all = every$1;
      exports3.allLimit = everyLimit$1;
      exports3.allSeries = everySeries$1;
      exports3.any = some$1;
      exports3.anyLimit = someLimit$1;
      exports3.anySeries = someSeries$1;
      exports3.apply = apply;
      exports3.applyEach = applyEach;
      exports3.applyEachSeries = applyEachSeries;
      exports3.asyncify = asyncify;
      exports3.auto = auto;
      exports3.autoInject = autoInject;
      exports3.cargo = cargo$1;
      exports3.cargoQueue = cargo;
      exports3.compose = compose;
      exports3.concat = concat$1;
      exports3.concatLimit = concatLimit$1;
      exports3.concatSeries = concatSeries$1;
      exports3.constant = constant$1;
      exports3.default = index;
      exports3.detect = detect$1;
      exports3.detectLimit = detectLimit$1;
      exports3.detectSeries = detectSeries$1;
      exports3.dir = dir;
      exports3.doDuring = doWhilst$1;
      exports3.doUntil = doUntil;
      exports3.doWhilst = doWhilst$1;
      exports3.during = whilst$1;
      exports3.each = each;
      exports3.eachLimit = eachLimit$1;
      exports3.eachOf = eachOf$1;
      exports3.eachOfLimit = eachOfLimit$1;
      exports3.eachOfSeries = eachOfSeries$1;
      exports3.eachSeries = eachSeries$1;
      exports3.ensureAsync = ensureAsync;
      exports3.every = every$1;
      exports3.everyLimit = everyLimit$1;
      exports3.everySeries = everySeries$1;
      exports3.filter = filter$1;
      exports3.filterLimit = filterLimit$1;
      exports3.filterSeries = filterSeries$1;
      exports3.find = detect$1;
      exports3.findLimit = detectLimit$1;
      exports3.findSeries = detectSeries$1;
      exports3.flatMap = concat$1;
      exports3.flatMapLimit = concatLimit$1;
      exports3.flatMapSeries = concatSeries$1;
      exports3.foldl = reduce$1;
      exports3.foldr = reduceRight;
      exports3.forEach = each;
      exports3.forEachLimit = eachLimit$1;
      exports3.forEachOf = eachOf$1;
      exports3.forEachOfLimit = eachOfLimit$1;
      exports3.forEachOfSeries = eachOfSeries$1;
      exports3.forEachSeries = eachSeries$1;
      exports3.forever = forever$1;
      exports3.groupBy = groupBy;
      exports3.groupByLimit = groupByLimit$1;
      exports3.groupBySeries = groupBySeries;
      exports3.inject = reduce$1;
      exports3.log = log;
      exports3.map = map$1;
      exports3.mapLimit = mapLimit$1;
      exports3.mapSeries = mapSeries$1;
      exports3.mapValues = mapValues;
      exports3.mapValuesLimit = mapValuesLimit$1;
      exports3.mapValuesSeries = mapValuesSeries;
      exports3.memoize = memoize2;
      exports3.nextTick = nextTick;
      exports3.parallel = parallel;
      exports3.parallelLimit = parallelLimit;
      exports3.priorityQueue = priorityQueue;
      exports3.queue = queue;
      exports3.race = race$1;
      exports3.reduce = reduce$1;
      exports3.reduceRight = reduceRight;
      exports3.reflect = reflect;
      exports3.reflectAll = reflectAll;
      exports3.reject = reject$1;
      exports3.rejectLimit = rejectLimit$1;
      exports3.rejectSeries = rejectSeries$1;
      exports3.retry = retry;
      exports3.retryable = retryable;
      exports3.select = filter$1;
      exports3.selectLimit = filterLimit$1;
      exports3.selectSeries = filterSeries$1;
      exports3.seq = seq;
      exports3.series = series;
      exports3.setImmediate = setImmediate$1;
      exports3.some = some$1;
      exports3.someLimit = someLimit$1;
      exports3.someSeries = someSeries$1;
      exports3.sortBy = sortBy$1;
      exports3.timeout = timeout;
      exports3.times = times;
      exports3.timesLimit = timesLimit;
      exports3.timesSeries = timesSeries;
      exports3.transform = transform;
      exports3.tryEach = tryEach$1;
      exports3.unmemoize = unmemoize;
      exports3.until = until;
      exports3.waterfall = waterfall$1;
      exports3.whilst = whilst$1;
      exports3.wrapSync = asyncify;
      Object.defineProperty(exports3, "__esModule", { value: true });
    }));
  }
});

// ../../node_modules/is-stream/index.js
var require_is_stream = __commonJS({
  "../../node_modules/is-stream/index.js"(exports2, module2) {
    "use strict";
    var isStream2 = /* @__PURE__ */ __name((stream3) => stream3 !== null && typeof stream3 === "object" && typeof stream3.pipe === "function", "isStream");
    isStream2.writable = (stream3) => isStream2(stream3) && stream3.writable !== false && typeof stream3._write === "function" && typeof stream3._writableState === "object";
    isStream2.readable = (stream3) => isStream2(stream3) && stream3.readable !== false && typeof stream3._read === "function" && typeof stream3._readableState === "object";
    isStream2.duplex = (stream3) => isStream2.writable(stream3) && isStream2.readable(stream3);
    isStream2.transform = (stream3) => isStream2.duplex(stream3) && typeof stream3._transform === "function";
    module2.exports = isStream2;
  }
});

// ../../node_modules/process-nextick-args/index.js
var require_process_nextick_args = __commonJS({
  "../../node_modules/process-nextick-args/index.js"(exports2, module2) {
    "use strict";
    if (typeof process === "undefined" || !process.version || process.version.indexOf("v0.") === 0 || process.version.indexOf("v1.") === 0 && process.version.indexOf("v1.8.") !== 0) {
      module2.exports = { nextTick };
    } else {
      module2.exports = process;
    }
    function nextTick(fn, arg1, arg2, arg3) {
      if (typeof fn !== "function") {
        throw new TypeError('"callback" argument must be a function');
      }
      var len = arguments.length;
      var args, i13;
      switch (len) {
        case 0:
        case 1:
          return process.nextTick(fn);
        case 2:
          return process.nextTick(/* @__PURE__ */ __name(function afterTickOne() {
            fn.call(null, arg1);
          }, "afterTickOne"));
        case 3:
          return process.nextTick(/* @__PURE__ */ __name(function afterTickTwo() {
            fn.call(null, arg1, arg2);
          }, "afterTickTwo"));
        case 4:
          return process.nextTick(/* @__PURE__ */ __name(function afterTickThree() {
            fn.call(null, arg1, arg2, arg3);
          }, "afterTickThree"));
        default:
          args = new Array(len - 1);
          i13 = 0;
          while (i13 < args.length) {
            args[i13++] = arguments[i13];
          }
          return process.nextTick(/* @__PURE__ */ __name(function afterTick() {
            fn.apply(null, args);
          }, "afterTick"));
      }
    }
    __name(nextTick, "nextTick");
  }
});

// ../../node_modules/readable-stream/node_modules/isarray/index.js
var require_isarray = __commonJS({
  "../../node_modules/readable-stream/node_modules/isarray/index.js"(exports2, module2) {
    var toString = {}.toString;
    module2.exports = Array.isArray || function(arr) {
      return toString.call(arr) == "[object Array]";
    };
  }
});

// ../../node_modules/readable-stream/lib/internal/streams/stream.js
var require_stream = __commonJS({
  "../../node_modules/readable-stream/lib/internal/streams/stream.js"(exports2, module2) {
    module2.exports = require("stream");
  }
});

// ../../node_modules/readable-stream/node_modules/safe-buffer/index.js
var require_safe_buffer = __commonJS({
  "../../node_modules/readable-stream/node_modules/safe-buffer/index.js"(exports2, module2) {
    var buffer = require("buffer");
    var Buffer2 = buffer.Buffer;
    function copyProps(src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    __name(copyProps, "copyProps");
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer;
    } else {
      copyProps(buffer, exports2);
      exports2.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    __name(SafeBuffer, "SafeBuffer");
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer.SlowBuffer(size);
    };
  }
});

// ../../node_modules/core-util-is/lib/util.js
var require_util = __commonJS({
  "../../node_modules/core-util-is/lib/util.js"(exports2) {
    function isArray2(arg) {
      if (Array.isArray) {
        return Array.isArray(arg);
      }
      return objectToString(arg) === "[object Array]";
    }
    __name(isArray2, "isArray");
    exports2.isArray = isArray2;
    function isBoolean2(arg) {
      return typeof arg === "boolean";
    }
    __name(isBoolean2, "isBoolean");
    exports2.isBoolean = isBoolean2;
    function isNull(arg) {
      return arg === null;
    }
    __name(isNull, "isNull");
    exports2.isNull = isNull;
    function isNullOrUndefined(arg) {
      return arg == null;
    }
    __name(isNullOrUndefined, "isNullOrUndefined");
    exports2.isNullOrUndefined = isNullOrUndefined;
    function isNumber(arg) {
      return typeof arg === "number";
    }
    __name(isNumber, "isNumber");
    exports2.isNumber = isNumber;
    function isString(arg) {
      return typeof arg === "string";
    }
    __name(isString, "isString");
    exports2.isString = isString;
    function isSymbol(arg) {
      return typeof arg === "symbol";
    }
    __name(isSymbol, "isSymbol");
    exports2.isSymbol = isSymbol;
    function isUndefined(arg) {
      return arg === void 0;
    }
    __name(isUndefined, "isUndefined");
    exports2.isUndefined = isUndefined;
    function isRegExp(re) {
      return objectToString(re) === "[object RegExp]";
    }
    __name(isRegExp, "isRegExp");
    exports2.isRegExp = isRegExp;
    function isObject3(arg) {
      return typeof arg === "object" && arg !== null;
    }
    __name(isObject3, "isObject");
    exports2.isObject = isObject3;
    function isDate(d13) {
      return objectToString(d13) === "[object Date]";
    }
    __name(isDate, "isDate");
    exports2.isDate = isDate;
    function isError(e13) {
      return objectToString(e13) === "[object Error]" || e13 instanceof Error;
    }
    __name(isError, "isError");
    exports2.isError = isError;
    function isFunction(arg) {
      return typeof arg === "function";
    }
    __name(isFunction, "isFunction");
    exports2.isFunction = isFunction;
    function isPrimitive(arg) {
      return arg === null || typeof arg === "boolean" || typeof arg === "number" || typeof arg === "string" || typeof arg === "symbol" || // ES6 symbol
      typeof arg === "undefined";
    }
    __name(isPrimitive, "isPrimitive");
    exports2.isPrimitive = isPrimitive;
    exports2.isBuffer = require("buffer").Buffer.isBuffer;
    function objectToString(o13) {
      return Object.prototype.toString.call(o13);
    }
    __name(objectToString, "objectToString");
  }
});

// ../../node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "../../node_modules/inherits/inherits_browser.js"(exports2, module2) {
    if (typeof Object.create === "function") {
      module2.exports = /* @__PURE__ */ __name(function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      }, "inherits");
    } else {
      module2.exports = /* @__PURE__ */ __name(function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = /* @__PURE__ */ __name(function() {
          }, "TempCtor");
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      }, "inherits");
    }
  }
});

// ../../node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "../../node_modules/inherits/inherits.js"(exports2, module2) {
    try {
      util12 = require("util");
      if (typeof util12.inherits !== "function") throw "";
      module2.exports = util12.inherits;
    } catch (e13) {
      module2.exports = require_inherits_browser();
    }
    var util12;
  }
});

// ../../node_modules/readable-stream/lib/internal/streams/BufferList.js
var require_BufferList = __commonJS({
  "../../node_modules/readable-stream/lib/internal/streams/BufferList.js"(exports2, module2) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }
    __name(_classCallCheck, "_classCallCheck");
    var Buffer2 = require_safe_buffer().Buffer;
    var util12 = require("util");
    function copyBuffer(src, target, offset) {
      src.copy(target, offset);
    }
    __name(copyBuffer, "copyBuffer");
    module2.exports = (function() {
      function BufferList() {
        _classCallCheck(this, BufferList);
        this.head = null;
        this.tail = null;
        this.length = 0;
      }
      __name(BufferList, "BufferList");
      BufferList.prototype.push = /* @__PURE__ */ __name(function push(v14) {
        var entry = { data: v14, next: null };
        if (this.length > 0) this.tail.next = entry;
        else this.head = entry;
        this.tail = entry;
        ++this.length;
      }, "push");
      BufferList.prototype.unshift = /* @__PURE__ */ __name(function unshift(v14) {
        var entry = { data: v14, next: this.head };
        if (this.length === 0) this.tail = entry;
        this.head = entry;
        ++this.length;
      }, "unshift");
      BufferList.prototype.shift = /* @__PURE__ */ __name(function shift() {
        if (this.length === 0) return;
        var ret = this.head.data;
        if (this.length === 1) this.head = this.tail = null;
        else this.head = this.head.next;
        --this.length;
        return ret;
      }, "shift");
      BufferList.prototype.clear = /* @__PURE__ */ __name(function clear() {
        this.head = this.tail = null;
        this.length = 0;
      }, "clear");
      BufferList.prototype.join = /* @__PURE__ */ __name(function join38(s13) {
        if (this.length === 0) return "";
        var p13 = this.head;
        var ret = "" + p13.data;
        while (p13 = p13.next) {
          ret += s13 + p13.data;
        }
        return ret;
      }, "join");
      BufferList.prototype.concat = /* @__PURE__ */ __name(function concat(n13) {
        if (this.length === 0) return Buffer2.alloc(0);
        var ret = Buffer2.allocUnsafe(n13 >>> 0);
        var p13 = this.head;
        var i13 = 0;
        while (p13) {
          copyBuffer(p13.data, ret, i13);
          i13 += p13.data.length;
          p13 = p13.next;
        }
        return ret;
      }, "concat");
      return BufferList;
    })();
    if (util12 && util12.inspect && util12.inspect.custom) {
      module2.exports.prototype[util12.inspect.custom] = function() {
        var obj = util12.inspect({ length: this.length });
        return this.constructor.name + " " + obj;
      };
    }
  }
});

// ../../node_modules/readable-stream/lib/internal/streams/destroy.js
var require_destroy = __commonJS({
  "../../node_modules/readable-stream/lib/internal/streams/destroy.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    function destroy(err, cb) {
      var _this = this;
      var readableDestroyed = this._readableState && this._readableState.destroyed;
      var writableDestroyed = this._writableState && this._writableState.destroyed;
      if (readableDestroyed || writableDestroyed) {
        if (cb) {
          cb(err);
        } else if (err) {
          if (!this._writableState) {
            pna.nextTick(emitErrorNT, this, err);
          } else if (!this._writableState.errorEmitted) {
            this._writableState.errorEmitted = true;
            pna.nextTick(emitErrorNT, this, err);
          }
        }
        return this;
      }
      if (this._readableState) {
        this._readableState.destroyed = true;
      }
      if (this._writableState) {
        this._writableState.destroyed = true;
      }
      this._destroy(err || null, function(err2) {
        if (!cb && err2) {
          if (!_this._writableState) {
            pna.nextTick(emitErrorNT, _this, err2);
          } else if (!_this._writableState.errorEmitted) {
            _this._writableState.errorEmitted = true;
            pna.nextTick(emitErrorNT, _this, err2);
          }
        } else if (cb) {
          cb(err2);
        }
      });
      return this;
    }
    __name(destroy, "destroy");
    function undestroy() {
      if (this._readableState) {
        this._readableState.destroyed = false;
        this._readableState.reading = false;
        this._readableState.ended = false;
        this._readableState.endEmitted = false;
      }
      if (this._writableState) {
        this._writableState.destroyed = false;
        this._writableState.ended = false;
        this._writableState.ending = false;
        this._writableState.finalCalled = false;
        this._writableState.prefinished = false;
        this._writableState.finished = false;
        this._writableState.errorEmitted = false;
      }
    }
    __name(undestroy, "undestroy");
    function emitErrorNT(self2, err) {
      self2.emit("error", err);
    }
    __name(emitErrorNT, "emitErrorNT");
    module2.exports = {
      destroy,
      undestroy
    };
  }
});

// ../../node_modules/util-deprecate/node.js
var require_node = __commonJS({
  "../../node_modules/util-deprecate/node.js"(exports2, module2) {
    module2.exports = require("util").deprecate;
  }
});

// ../../node_modules/readable-stream/lib/_stream_writable.js
var require_stream_writable = __commonJS({
  "../../node_modules/readable-stream/lib/_stream_writable.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    module2.exports = Writable3;
    function CorkedRequest(state5) {
      var _this = this;
      this.next = null;
      this.entry = null;
      this.finish = function() {
        onCorkedFinish(_this, state5);
      };
    }
    __name(CorkedRequest, "CorkedRequest");
    var asyncWrite = !process.browser && ["v0.10", "v0.9."].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
    var Duplex;
    Writable3.WritableState = WritableState;
    var util12 = Object.create(require_util());
    util12.inherits = require_inherits();
    var internalUtil = {
      deprecate: require_node()
    };
    var Stream2 = require_stream();
    var Buffer2 = require_safe_buffer().Buffer;
    var OurUint8Array = (typeof global !== "undefined" ? global : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    __name(_uint8ArrayToBuffer, "_uint8ArrayToBuffer");
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    __name(_isUint8Array, "_isUint8Array");
    var destroyImpl = require_destroy();
    util12.inherits(Writable3, Stream2);
    function nop() {
    }
    __name(nop, "nop");
    function WritableState(options, stream3) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      var isDuplex = stream3 instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;
      var hwm = options.highWaterMark;
      var writableHwm = options.writableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      if (hwm || hwm === 0) this.highWaterMark = hwm;
      else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;
      else this.highWaterMark = defaultHwm;
      this.highWaterMark = Math.floor(this.highWaterMark);
      this.finalCalled = false;
      this.needDrain = false;
      this.ending = false;
      this.ended = false;
      this.finished = false;
      this.destroyed = false;
      var noDecode = options.decodeStrings === false;
      this.decodeStrings = !noDecode;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.length = 0;
      this.writing = false;
      this.corked = 0;
      this.sync = true;
      this.bufferProcessing = false;
      this.onwrite = function(er) {
        onwrite(stream3, er);
      };
      this.writecb = null;
      this.writelen = 0;
      this.bufferedRequest = null;
      this.lastBufferedRequest = null;
      this.pendingcb = 0;
      this.prefinished = false;
      this.errorEmitted = false;
      this.bufferedRequestCount = 0;
      this.corkedRequestsFree = new CorkedRequest(this);
    }
    __name(WritableState, "WritableState");
    WritableState.prototype.getBuffer = /* @__PURE__ */ __name(function getBuffer() {
      var current = this.bufferedRequest;
      var out = [];
      while (current) {
        out.push(current);
        current = current.next;
      }
      return out;
    }, "getBuffer");
    (function() {
      try {
        Object.defineProperty(WritableState.prototype, "buffer", {
          get: internalUtil.deprecate(function() {
            return this.getBuffer();
          }, "_writableState.buffer is deprecated. Use _writableState.getBuffer instead.", "DEP0003")
        });
      } catch (_2) {
      }
    })();
    var realHasInstance;
    if (typeof Symbol === "function" && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === "function") {
      realHasInstance = Function.prototype[Symbol.hasInstance];
      Object.defineProperty(Writable3, Symbol.hasInstance, {
        value: /* @__PURE__ */ __name(function(object) {
          if (realHasInstance.call(this, object)) return true;
          if (this !== Writable3) return false;
          return object && object._writableState instanceof WritableState;
        }, "value")
      });
    } else {
      realHasInstance = /* @__PURE__ */ __name(function(object) {
        return object instanceof this;
      }, "realHasInstance");
    }
    function Writable3(options) {
      Duplex = Duplex || require_stream_duplex();
      if (!realHasInstance.call(Writable3, this) && !(this instanceof Duplex)) {
        return new Writable3(options);
      }
      this._writableState = new WritableState(options, this);
      this.writable = true;
      if (options) {
        if (typeof options.write === "function") this._write = options.write;
        if (typeof options.writev === "function") this._writev = options.writev;
        if (typeof options.destroy === "function") this._destroy = options.destroy;
        if (typeof options.final === "function") this._final = options.final;
      }
      Stream2.call(this);
    }
    __name(Writable3, "Writable");
    Writable3.prototype.pipe = function() {
      this.emit("error", new Error("Cannot pipe, not readable"));
    };
    function writeAfterEnd(stream3, cb) {
      var er = new Error("write after end");
      stream3.emit("error", er);
      pna.nextTick(cb, er);
    }
    __name(writeAfterEnd, "writeAfterEnd");
    function validChunk(stream3, state5, chunk, cb) {
      var valid3 = true;
      var er = false;
      if (chunk === null) {
        er = new TypeError("May not write null values to stream");
      } else if (typeof chunk !== "string" && chunk !== void 0 && !state5.objectMode) {
        er = new TypeError("Invalid non-string/buffer chunk");
      }
      if (er) {
        stream3.emit("error", er);
        pna.nextTick(cb, er);
        valid3 = false;
      }
      return valid3;
    }
    __name(validChunk, "validChunk");
    Writable3.prototype.write = function(chunk, encoding, cb) {
      var state5 = this._writableState;
      var ret = false;
      var isBuf = !state5.objectMode && _isUint8Array(chunk);
      if (isBuf && !Buffer2.isBuffer(chunk)) {
        chunk = _uint8ArrayToBuffer(chunk);
      }
      if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (isBuf) encoding = "buffer";
      else if (!encoding) encoding = state5.defaultEncoding;
      if (typeof cb !== "function") cb = nop;
      if (state5.ended) writeAfterEnd(this, cb);
      else if (isBuf || validChunk(this, state5, chunk, cb)) {
        state5.pendingcb++;
        ret = writeOrBuffer(this, state5, isBuf, chunk, encoding, cb);
      }
      return ret;
    };
    Writable3.prototype.cork = function() {
      var state5 = this._writableState;
      state5.corked++;
    };
    Writable3.prototype.uncork = function() {
      var state5 = this._writableState;
      if (state5.corked) {
        state5.corked--;
        if (!state5.writing && !state5.corked && !state5.bufferProcessing && state5.bufferedRequest) clearBuffer(this, state5);
      }
    };
    Writable3.prototype.setDefaultEncoding = /* @__PURE__ */ __name(function setDefaultEncoding(encoding) {
      if (typeof encoding === "string") encoding = encoding.toLowerCase();
      if (!(["hex", "utf8", "utf-8", "ascii", "binary", "base64", "ucs2", "ucs-2", "utf16le", "utf-16le", "raw"].indexOf((encoding + "").toLowerCase()) > -1)) throw new TypeError("Unknown encoding: " + encoding);
      this._writableState.defaultEncoding = encoding;
      return this;
    }, "setDefaultEncoding");
    function decodeChunk(state5, chunk, encoding) {
      if (!state5.objectMode && state5.decodeStrings !== false && typeof chunk === "string") {
        chunk = Buffer2.from(chunk, encoding);
      }
      return chunk;
    }
    __name(decodeChunk, "decodeChunk");
    Object.defineProperty(Writable3.prototype, "writableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: /* @__PURE__ */ __name(function() {
        return this._writableState.highWaterMark;
      }, "get")
    });
    function writeOrBuffer(stream3, state5, isBuf, chunk, encoding, cb) {
      if (!isBuf) {
        var newChunk = decodeChunk(state5, chunk, encoding);
        if (chunk !== newChunk) {
          isBuf = true;
          encoding = "buffer";
          chunk = newChunk;
        }
      }
      var len = state5.objectMode ? 1 : chunk.length;
      state5.length += len;
      var ret = state5.length < state5.highWaterMark;
      if (!ret) state5.needDrain = true;
      if (state5.writing || state5.corked) {
        var last = state5.lastBufferedRequest;
        state5.lastBufferedRequest = {
          chunk,
          encoding,
          isBuf,
          callback: cb,
          next: null
        };
        if (last) {
          last.next = state5.lastBufferedRequest;
        } else {
          state5.bufferedRequest = state5.lastBufferedRequest;
        }
        state5.bufferedRequestCount += 1;
      } else {
        doWrite(stream3, state5, false, len, chunk, encoding, cb);
      }
      return ret;
    }
    __name(writeOrBuffer, "writeOrBuffer");
    function doWrite(stream3, state5, writev, len, chunk, encoding, cb) {
      state5.writelen = len;
      state5.writecb = cb;
      state5.writing = true;
      state5.sync = true;
      if (writev) stream3._writev(chunk, state5.onwrite);
      else stream3._write(chunk, encoding, state5.onwrite);
      state5.sync = false;
    }
    __name(doWrite, "doWrite");
    function onwriteError(stream3, state5, sync2, er, cb) {
      --state5.pendingcb;
      if (sync2) {
        pna.nextTick(cb, er);
        pna.nextTick(finishMaybe, stream3, state5);
        stream3._writableState.errorEmitted = true;
        stream3.emit("error", er);
      } else {
        cb(er);
        stream3._writableState.errorEmitted = true;
        stream3.emit("error", er);
        finishMaybe(stream3, state5);
      }
    }
    __name(onwriteError, "onwriteError");
    function onwriteStateUpdate(state5) {
      state5.writing = false;
      state5.writecb = null;
      state5.length -= state5.writelen;
      state5.writelen = 0;
    }
    __name(onwriteStateUpdate, "onwriteStateUpdate");
    function onwrite(stream3, er) {
      var state5 = stream3._writableState;
      var sync2 = state5.sync;
      var cb = state5.writecb;
      onwriteStateUpdate(state5);
      if (er) onwriteError(stream3, state5, sync2, er, cb);
      else {
        var finished = needFinish(state5);
        if (!finished && !state5.corked && !state5.bufferProcessing && state5.bufferedRequest) {
          clearBuffer(stream3, state5);
        }
        if (sync2) {
          asyncWrite(afterWrite, stream3, state5, finished, cb);
        } else {
          afterWrite(stream3, state5, finished, cb);
        }
      }
    }
    __name(onwrite, "onwrite");
    function afterWrite(stream3, state5, finished, cb) {
      if (!finished) onwriteDrain(stream3, state5);
      state5.pendingcb--;
      cb();
      finishMaybe(stream3, state5);
    }
    __name(afterWrite, "afterWrite");
    function onwriteDrain(stream3, state5) {
      if (state5.length === 0 && state5.needDrain) {
        state5.needDrain = false;
        stream3.emit("drain");
      }
    }
    __name(onwriteDrain, "onwriteDrain");
    function clearBuffer(stream3, state5) {
      state5.bufferProcessing = true;
      var entry = state5.bufferedRequest;
      if (stream3._writev && entry && entry.next) {
        var l13 = state5.bufferedRequestCount;
        var buffer = new Array(l13);
        var holder = state5.corkedRequestsFree;
        holder.entry = entry;
        var count = 0;
        var allBuffers = true;
        while (entry) {
          buffer[count] = entry;
          if (!entry.isBuf) allBuffers = false;
          entry = entry.next;
          count += 1;
        }
        buffer.allBuffers = allBuffers;
        doWrite(stream3, state5, true, state5.length, buffer, "", holder.finish);
        state5.pendingcb++;
        state5.lastBufferedRequest = null;
        if (holder.next) {
          state5.corkedRequestsFree = holder.next;
          holder.next = null;
        } else {
          state5.corkedRequestsFree = new CorkedRequest(state5);
        }
        state5.bufferedRequestCount = 0;
      } else {
        while (entry) {
          var chunk = entry.chunk;
          var encoding = entry.encoding;
          var cb = entry.callback;
          var len = state5.objectMode ? 1 : chunk.length;
          doWrite(stream3, state5, false, len, chunk, encoding, cb);
          entry = entry.next;
          state5.bufferedRequestCount--;
          if (state5.writing) {
            break;
          }
        }
        if (entry === null) state5.lastBufferedRequest = null;
      }
      state5.bufferedRequest = entry;
      state5.bufferProcessing = false;
    }
    __name(clearBuffer, "clearBuffer");
    Writable3.prototype._write = function(chunk, encoding, cb) {
      cb(new Error("_write() is not implemented"));
    };
    Writable3.prototype._writev = null;
    Writable3.prototype.end = function(chunk, encoding, cb) {
      var state5 = this._writableState;
      if (typeof chunk === "function") {
        cb = chunk;
        chunk = null;
        encoding = null;
      } else if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (chunk !== null && chunk !== void 0) this.write(chunk, encoding);
      if (state5.corked) {
        state5.corked = 1;
        this.uncork();
      }
      if (!state5.ending) endWritable(this, state5, cb);
    };
    function needFinish(state5) {
      return state5.ending && state5.length === 0 && state5.bufferedRequest === null && !state5.finished && !state5.writing;
    }
    __name(needFinish, "needFinish");
    function callFinal(stream3, state5) {
      stream3._final(function(err) {
        state5.pendingcb--;
        if (err) {
          stream3.emit("error", err);
        }
        state5.prefinished = true;
        stream3.emit("prefinish");
        finishMaybe(stream3, state5);
      });
    }
    __name(callFinal, "callFinal");
    function prefinish(stream3, state5) {
      if (!state5.prefinished && !state5.finalCalled) {
        if (typeof stream3._final === "function") {
          state5.pendingcb++;
          state5.finalCalled = true;
          pna.nextTick(callFinal, stream3, state5);
        } else {
          state5.prefinished = true;
          stream3.emit("prefinish");
        }
      }
    }
    __name(prefinish, "prefinish");
    function finishMaybe(stream3, state5) {
      var need = needFinish(state5);
      if (need) {
        prefinish(stream3, state5);
        if (state5.pendingcb === 0) {
          state5.finished = true;
          stream3.emit("finish");
        }
      }
      return need;
    }
    __name(finishMaybe, "finishMaybe");
    function endWritable(stream3, state5, cb) {
      state5.ending = true;
      finishMaybe(stream3, state5);
      if (cb) {
        if (state5.finished) pna.nextTick(cb);
        else stream3.once("finish", cb);
      }
      state5.ended = true;
      stream3.writable = false;
    }
    __name(endWritable, "endWritable");
    function onCorkedFinish(corkReq, state5, err) {
      var entry = corkReq.entry;
      corkReq.entry = null;
      while (entry) {
        var cb = entry.callback;
        state5.pendingcb--;
        cb(err);
        entry = entry.next;
      }
      state5.corkedRequestsFree.next = corkReq;
    }
    __name(onCorkedFinish, "onCorkedFinish");
    Object.defineProperty(Writable3.prototype, "destroyed", {
      get: /* @__PURE__ */ __name(function() {
        if (this._writableState === void 0) {
          return false;
        }
        return this._writableState.destroyed;
      }, "get"),
      set: /* @__PURE__ */ __name(function(value) {
        if (!this._writableState) {
          return;
        }
        this._writableState.destroyed = value;
      }, "set")
    });
    Writable3.prototype.destroy = destroyImpl.destroy;
    Writable3.prototype._undestroy = destroyImpl.undestroy;
    Writable3.prototype._destroy = function(err, cb) {
      this.end();
      cb(err);
    };
  }
});

// ../../node_modules/readable-stream/lib/_stream_duplex.js
var require_stream_duplex = __commonJS({
  "../../node_modules/readable-stream/lib/_stream_duplex.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    var objectKeys = Object.keys || function(obj) {
      var keys2 = [];
      for (var key in obj) {
        keys2.push(key);
      }
      return keys2;
    };
    module2.exports = Duplex;
    var util12 = Object.create(require_util());
    util12.inherits = require_inherits();
    var Readable2 = require_stream_readable();
    var Writable3 = require_stream_writable();
    util12.inherits(Duplex, Readable2);
    {
      keys = objectKeys(Writable3.prototype);
      for (v14 = 0; v14 < keys.length; v14++) {
        method = keys[v14];
        if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable3.prototype[method];
      }
    }
    var keys;
    var method;
    var v14;
    function Duplex(options) {
      if (!(this instanceof Duplex)) return new Duplex(options);
      Readable2.call(this, options);
      Writable3.call(this, options);
      if (options && options.readable === false) this.readable = false;
      if (options && options.writable === false) this.writable = false;
      this.allowHalfOpen = true;
      if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;
      this.once("end", onend);
    }
    __name(Duplex, "Duplex");
    Object.defineProperty(Duplex.prototype, "writableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: /* @__PURE__ */ __name(function() {
        return this._writableState.highWaterMark;
      }, "get")
    });
    function onend() {
      if (this.allowHalfOpen || this._writableState.ended) return;
      pna.nextTick(onEndNT, this);
    }
    __name(onend, "onend");
    function onEndNT(self2) {
      self2.end();
    }
    __name(onEndNT, "onEndNT");
    Object.defineProperty(Duplex.prototype, "destroyed", {
      get: /* @__PURE__ */ __name(function() {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return false;
        }
        return this._readableState.destroyed && this._writableState.destroyed;
      }, "get"),
      set: /* @__PURE__ */ __name(function(value) {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return;
        }
        this._readableState.destroyed = value;
        this._writableState.destroyed = value;
      }, "set")
    });
    Duplex.prototype._destroy = function(err, cb) {
      this.push(null);
      this.end();
      pna.nextTick(cb, err);
    };
  }
});

// ../../node_modules/readable-stream/node_modules/string_decoder/lib/string_decoder.js
var require_string_decoder = __commonJS({
  "../../node_modules/readable-stream/node_modules/string_decoder/lib/string_decoder.js"(exports2) {
    "use strict";
    var Buffer2 = require_safe_buffer().Buffer;
    var isEncoding = Buffer2.isEncoding || function(encoding) {
      encoding = "" + encoding;
      switch (encoding && encoding.toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
        case "raw":
          return true;
        default:
          return false;
      }
    };
    function _normalizeEncoding(enc) {
      if (!enc) return "utf8";
      var retried;
      while (true) {
        switch (enc) {
          case "utf8":
          case "utf-8":
            return "utf8";
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return "utf16le";
          case "latin1":
          case "binary":
            return "latin1";
          case "base64":
          case "ascii":
          case "hex":
            return enc;
          default:
            if (retried) return;
            enc = ("" + enc).toLowerCase();
            retried = true;
        }
      }
    }
    __name(_normalizeEncoding, "_normalizeEncoding");
    function normalizeEncoding(enc) {
      var nenc = _normalizeEncoding(enc);
      if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc))) throw new Error("Unknown encoding: " + enc);
      return nenc || enc;
    }
    __name(normalizeEncoding, "normalizeEncoding");
    exports2.StringDecoder = StringDecoder2;
    function StringDecoder2(encoding) {
      this.encoding = normalizeEncoding(encoding);
      var nb;
      switch (this.encoding) {
        case "utf16le":
          this.text = utf16Text;
          this.end = utf16End;
          nb = 4;
          break;
        case "utf8":
          this.fillLast = utf8FillLast;
          nb = 4;
          break;
        case "base64":
          this.text = base64Text;
          this.end = base64End;
          nb = 3;
          break;
        default:
          this.write = simpleWrite;
          this.end = simpleEnd;
          return;
      }
      this.lastNeed = 0;
      this.lastTotal = 0;
      this.lastChar = Buffer2.allocUnsafe(nb);
    }
    __name(StringDecoder2, "StringDecoder");
    StringDecoder2.prototype.write = function(buf) {
      if (buf.length === 0) return "";
      var r13;
      var i13;
      if (this.lastNeed) {
        r13 = this.fillLast(buf);
        if (r13 === void 0) return "";
        i13 = this.lastNeed;
        this.lastNeed = 0;
      } else {
        i13 = 0;
      }
      if (i13 < buf.length) return r13 ? r13 + this.text(buf, i13) : this.text(buf, i13);
      return r13 || "";
    };
    StringDecoder2.prototype.end = utf8End;
    StringDecoder2.prototype.text = utf8Text;
    StringDecoder2.prototype.fillLast = function(buf) {
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
      this.lastNeed -= buf.length;
    };
    function utf8CheckByte(byte) {
      if (byte <= 127) return 0;
      else if (byte >> 5 === 6) return 2;
      else if (byte >> 4 === 14) return 3;
      else if (byte >> 3 === 30) return 4;
      return byte >> 6 === 2 ? -1 : -2;
    }
    __name(utf8CheckByte, "utf8CheckByte");
    function utf8CheckIncomplete(self2, buf, i13) {
      var j13 = buf.length - 1;
      if (j13 < i13) return 0;
      var nb = utf8CheckByte(buf[j13]);
      if (nb >= 0) {
        if (nb > 0) self2.lastNeed = nb - 1;
        return nb;
      }
      if (--j13 < i13 || nb === -2) return 0;
      nb = utf8CheckByte(buf[j13]);
      if (nb >= 0) {
        if (nb > 0) self2.lastNeed = nb - 2;
        return nb;
      }
      if (--j13 < i13 || nb === -2) return 0;
      nb = utf8CheckByte(buf[j13]);
      if (nb >= 0) {
        if (nb > 0) {
          if (nb === 2) nb = 0;
          else self2.lastNeed = nb - 3;
        }
        return nb;
      }
      return 0;
    }
    __name(utf8CheckIncomplete, "utf8CheckIncomplete");
    function utf8CheckExtraBytes(self2, buf, p13) {
      if ((buf[0] & 192) !== 128) {
        self2.lastNeed = 0;
        return "\uFFFD";
      }
      if (self2.lastNeed > 1 && buf.length > 1) {
        if ((buf[1] & 192) !== 128) {
          self2.lastNeed = 1;
          return "\uFFFD";
        }
        if (self2.lastNeed > 2 && buf.length > 2) {
          if ((buf[2] & 192) !== 128) {
            self2.lastNeed = 2;
            return "\uFFFD";
          }
        }
      }
    }
    __name(utf8CheckExtraBytes, "utf8CheckExtraBytes");
    function utf8FillLast(buf) {
      var p13 = this.lastTotal - this.lastNeed;
      var r13 = utf8CheckExtraBytes(this, buf, p13);
      if (r13 !== void 0) return r13;
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, p13, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, p13, 0, buf.length);
      this.lastNeed -= buf.length;
    }
    __name(utf8FillLast, "utf8FillLast");
    function utf8Text(buf, i13) {
      var total = utf8CheckIncomplete(this, buf, i13);
      if (!this.lastNeed) return buf.toString("utf8", i13);
      this.lastTotal = total;
      var end = buf.length - (total - this.lastNeed);
      buf.copy(this.lastChar, 0, end);
      return buf.toString("utf8", i13, end);
    }
    __name(utf8Text, "utf8Text");
    function utf8End(buf) {
      var r13 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) return r13 + "\uFFFD";
      return r13;
    }
    __name(utf8End, "utf8End");
    function utf16Text(buf, i13) {
      if ((buf.length - i13) % 2 === 0) {
        var r13 = buf.toString("utf16le", i13);
        if (r13) {
          var c13 = r13.charCodeAt(r13.length - 1);
          if (c13 >= 55296 && c13 <= 56319) {
            this.lastNeed = 2;
            this.lastTotal = 4;
            this.lastChar[0] = buf[buf.length - 2];
            this.lastChar[1] = buf[buf.length - 1];
            return r13.slice(0, -1);
          }
        }
        return r13;
      }
      this.lastNeed = 1;
      this.lastTotal = 2;
      this.lastChar[0] = buf[buf.length - 1];
      return buf.toString("utf16le", i13, buf.length - 1);
    }
    __name(utf16Text, "utf16Text");
    function utf16End(buf) {
      var r13 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) {
        var end = this.lastTotal - this.lastNeed;
        return r13 + this.lastChar.toString("utf16le", 0, end);
      }
      return r13;
    }
    __name(utf16End, "utf16End");
    function base64Text(buf, i13) {
      var n13 = (buf.length - i13) % 3;
      if (n13 === 0) return buf.toString("base64", i13);
      this.lastNeed = 3 - n13;
      this.lastTotal = 3;
      if (n13 === 1) {
        this.lastChar[0] = buf[buf.length - 1];
      } else {
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
      }
      return buf.toString("base64", i13, buf.length - n13);
    }
    __name(base64Text, "base64Text");
    function base64End(buf) {
      var r13 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) return r13 + this.lastChar.toString("base64", 0, 3 - this.lastNeed);
      return r13;
    }
    __name(base64End, "base64End");
    function simpleWrite(buf) {
      return buf.toString(this.encoding);
    }
    __name(simpleWrite, "simpleWrite");
    function simpleEnd(buf) {
      return buf && buf.length ? this.write(buf) : "";
    }
    __name(simpleEnd, "simpleEnd");
  }
});

// ../../node_modules/readable-stream/lib/_stream_readable.js
var require_stream_readable = __commonJS({
  "../../node_modules/readable-stream/lib/_stream_readable.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    module2.exports = Readable2;
    var isArray2 = require_isarray();
    var Duplex;
    Readable2.ReadableState = ReadableState;
    var EE = require("events").EventEmitter;
    var EElistenerCount = /* @__PURE__ */ __name(function(emitter, type) {
      return emitter.listeners(type).length;
    }, "EElistenerCount");
    var Stream2 = require_stream();
    var Buffer2 = require_safe_buffer().Buffer;
    var OurUint8Array = (typeof global !== "undefined" ? global : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    __name(_uint8ArrayToBuffer, "_uint8ArrayToBuffer");
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    __name(_isUint8Array, "_isUint8Array");
    var util12 = Object.create(require_util());
    util12.inherits = require_inherits();
    var debugUtil = require("util");
    var debug3 = void 0;
    if (debugUtil && debugUtil.debuglog) {
      debug3 = debugUtil.debuglog("stream");
    } else {
      debug3 = /* @__PURE__ */ __name(function() {
      }, "debug");
    }
    var BufferList = require_BufferList();
    var destroyImpl = require_destroy();
    var StringDecoder2;
    util12.inherits(Readable2, Stream2);
    var kProxyEvents = ["error", "close", "destroy", "pause", "resume"];
    function prependListener(emitter, event, fn) {
      if (typeof emitter.prependListener === "function") return emitter.prependListener(event, fn);
      if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
      else if (isArray2(emitter._events[event])) emitter._events[event].unshift(fn);
      else emitter._events[event] = [fn, emitter._events[event]];
    }
    __name(prependListener, "prependListener");
    function ReadableState(options, stream3) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      var isDuplex = stream3 instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;
      var hwm = options.highWaterMark;
      var readableHwm = options.readableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      if (hwm || hwm === 0) this.highWaterMark = hwm;
      else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;
      else this.highWaterMark = defaultHwm;
      this.highWaterMark = Math.floor(this.highWaterMark);
      this.buffer = new BufferList();
      this.length = 0;
      this.pipes = null;
      this.pipesCount = 0;
      this.flowing = null;
      this.ended = false;
      this.endEmitted = false;
      this.reading = false;
      this.sync = true;
      this.needReadable = false;
      this.emittedReadable = false;
      this.readableListening = false;
      this.resumeScheduled = false;
      this.destroyed = false;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.awaitDrain = 0;
      this.readingMore = false;
      this.decoder = null;
      this.encoding = null;
      if (options.encoding) {
        if (!StringDecoder2) StringDecoder2 = require_string_decoder().StringDecoder;
        this.decoder = new StringDecoder2(options.encoding);
        this.encoding = options.encoding;
      }
    }
    __name(ReadableState, "ReadableState");
    function Readable2(options) {
      Duplex = Duplex || require_stream_duplex();
      if (!(this instanceof Readable2)) return new Readable2(options);
      this._readableState = new ReadableState(options, this);
      this.readable = true;
      if (options) {
        if (typeof options.read === "function") this._read = options.read;
        if (typeof options.destroy === "function") this._destroy = options.destroy;
      }
      Stream2.call(this);
    }
    __name(Readable2, "Readable");
    Object.defineProperty(Readable2.prototype, "destroyed", {
      get: /* @__PURE__ */ __name(function() {
        if (this._readableState === void 0) {
          return false;
        }
        return this._readableState.destroyed;
      }, "get"),
      set: /* @__PURE__ */ __name(function(value) {
        if (!this._readableState) {
          return;
        }
        this._readableState.destroyed = value;
      }, "set")
    });
    Readable2.prototype.destroy = destroyImpl.destroy;
    Readable2.prototype._undestroy = destroyImpl.undestroy;
    Readable2.prototype._destroy = function(err, cb) {
      this.push(null);
      cb(err);
    };
    Readable2.prototype.push = function(chunk, encoding) {
      var state5 = this._readableState;
      var skipChunkCheck;
      if (!state5.objectMode) {
        if (typeof chunk === "string") {
          encoding = encoding || state5.defaultEncoding;
          if (encoding !== state5.encoding) {
            chunk = Buffer2.from(chunk, encoding);
            encoding = "";
          }
          skipChunkCheck = true;
        }
      } else {
        skipChunkCheck = true;
      }
      return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
    };
    Readable2.prototype.unshift = function(chunk) {
      return readableAddChunk(this, chunk, null, true, false);
    };
    function readableAddChunk(stream3, chunk, encoding, addToFront, skipChunkCheck) {
      var state5 = stream3._readableState;
      if (chunk === null) {
        state5.reading = false;
        onEofChunk(stream3, state5);
      } else {
        var er;
        if (!skipChunkCheck) er = chunkInvalid(state5, chunk);
        if (er) {
          stream3.emit("error", er);
        } else if (state5.objectMode || chunk && chunk.length > 0) {
          if (typeof chunk !== "string" && !state5.objectMode && Object.getPrototypeOf(chunk) !== Buffer2.prototype) {
            chunk = _uint8ArrayToBuffer(chunk);
          }
          if (addToFront) {
            if (state5.endEmitted) stream3.emit("error", new Error("stream.unshift() after end event"));
            else addChunk(stream3, state5, chunk, true);
          } else if (state5.ended) {
            stream3.emit("error", new Error("stream.push() after EOF"));
          } else {
            state5.reading = false;
            if (state5.decoder && !encoding) {
              chunk = state5.decoder.write(chunk);
              if (state5.objectMode || chunk.length !== 0) addChunk(stream3, state5, chunk, false);
              else maybeReadMore(stream3, state5);
            } else {
              addChunk(stream3, state5, chunk, false);
            }
          }
        } else if (!addToFront) {
          state5.reading = false;
        }
      }
      return needMoreData(state5);
    }
    __name(readableAddChunk, "readableAddChunk");
    function addChunk(stream3, state5, chunk, addToFront) {
      if (state5.flowing && state5.length === 0 && !state5.sync) {
        stream3.emit("data", chunk);
        stream3.read(0);
      } else {
        state5.length += state5.objectMode ? 1 : chunk.length;
        if (addToFront) state5.buffer.unshift(chunk);
        else state5.buffer.push(chunk);
        if (state5.needReadable) emitReadable(stream3);
      }
      maybeReadMore(stream3, state5);
    }
    __name(addChunk, "addChunk");
    function chunkInvalid(state5, chunk) {
      var er;
      if (!_isUint8Array(chunk) && typeof chunk !== "string" && chunk !== void 0 && !state5.objectMode) {
        er = new TypeError("Invalid non-string/buffer chunk");
      }
      return er;
    }
    __name(chunkInvalid, "chunkInvalid");
    function needMoreData(state5) {
      return !state5.ended && (state5.needReadable || state5.length < state5.highWaterMark || state5.length === 0);
    }
    __name(needMoreData, "needMoreData");
    Readable2.prototype.isPaused = function() {
      return this._readableState.flowing === false;
    };
    Readable2.prototype.setEncoding = function(enc) {
      if (!StringDecoder2) StringDecoder2 = require_string_decoder().StringDecoder;
      this._readableState.decoder = new StringDecoder2(enc);
      this._readableState.encoding = enc;
      return this;
    };
    var MAX_HWM = 8388608;
    function computeNewHighWaterMark(n13) {
      if (n13 >= MAX_HWM) {
        n13 = MAX_HWM;
      } else {
        n13--;
        n13 |= n13 >>> 1;
        n13 |= n13 >>> 2;
        n13 |= n13 >>> 4;
        n13 |= n13 >>> 8;
        n13 |= n13 >>> 16;
        n13++;
      }
      return n13;
    }
    __name(computeNewHighWaterMark, "computeNewHighWaterMark");
    function howMuchToRead(n13, state5) {
      if (n13 <= 0 || state5.length === 0 && state5.ended) return 0;
      if (state5.objectMode) return 1;
      if (n13 !== n13) {
        if (state5.flowing && state5.length) return state5.buffer.head.data.length;
        else return state5.length;
      }
      if (n13 > state5.highWaterMark) state5.highWaterMark = computeNewHighWaterMark(n13);
      if (n13 <= state5.length) return n13;
      if (!state5.ended) {
        state5.needReadable = true;
        return 0;
      }
      return state5.length;
    }
    __name(howMuchToRead, "howMuchToRead");
    Readable2.prototype.read = function(n13) {
      debug3("read", n13);
      n13 = parseInt(n13, 10);
      var state5 = this._readableState;
      var nOrig = n13;
      if (n13 !== 0) state5.emittedReadable = false;
      if (n13 === 0 && state5.needReadable && (state5.length >= state5.highWaterMark || state5.ended)) {
        debug3("read: emitReadable", state5.length, state5.ended);
        if (state5.length === 0 && state5.ended) endReadable(this);
        else emitReadable(this);
        return null;
      }
      n13 = howMuchToRead(n13, state5);
      if (n13 === 0 && state5.ended) {
        if (state5.length === 0) endReadable(this);
        return null;
      }
      var doRead = state5.needReadable;
      debug3("need readable", doRead);
      if (state5.length === 0 || state5.length - n13 < state5.highWaterMark) {
        doRead = true;
        debug3("length less than watermark", doRead);
      }
      if (state5.ended || state5.reading) {
        doRead = false;
        debug3("reading or ended", doRead);
      } else if (doRead) {
        debug3("do read");
        state5.reading = true;
        state5.sync = true;
        if (state5.length === 0) state5.needReadable = true;
        this._read(state5.highWaterMark);
        state5.sync = false;
        if (!state5.reading) n13 = howMuchToRead(nOrig, state5);
      }
      var ret;
      if (n13 > 0) ret = fromList(n13, state5);
      else ret = null;
      if (ret === null) {
        state5.needReadable = true;
        n13 = 0;
      } else {
        state5.length -= n13;
      }
      if (state5.length === 0) {
        if (!state5.ended) state5.needReadable = true;
        if (nOrig !== n13 && state5.ended) endReadable(this);
      }
      if (ret !== null) this.emit("data", ret);
      return ret;
    };
    function onEofChunk(stream3, state5) {
      if (state5.ended) return;
      if (state5.decoder) {
        var chunk = state5.decoder.end();
        if (chunk && chunk.length) {
          state5.buffer.push(chunk);
          state5.length += state5.objectMode ? 1 : chunk.length;
        }
      }
      state5.ended = true;
      emitReadable(stream3);
    }
    __name(onEofChunk, "onEofChunk");
    function emitReadable(stream3) {
      var state5 = stream3._readableState;
      state5.needReadable = false;
      if (!state5.emittedReadable) {
        debug3("emitReadable", state5.flowing);
        state5.emittedReadable = true;
        if (state5.sync) pna.nextTick(emitReadable_, stream3);
        else emitReadable_(stream3);
      }
    }
    __name(emitReadable, "emitReadable");
    function emitReadable_(stream3) {
      debug3("emit readable");
      stream3.emit("readable");
      flow(stream3);
    }
    __name(emitReadable_, "emitReadable_");
    function maybeReadMore(stream3, state5) {
      if (!state5.readingMore) {
        state5.readingMore = true;
        pna.nextTick(maybeReadMore_, stream3, state5);
      }
    }
    __name(maybeReadMore, "maybeReadMore");
    function maybeReadMore_(stream3, state5) {
      var len = state5.length;
      while (!state5.reading && !state5.flowing && !state5.ended && state5.length < state5.highWaterMark) {
        debug3("maybeReadMore read 0");
        stream3.read(0);
        if (len === state5.length)
          break;
        else len = state5.length;
      }
      state5.readingMore = false;
    }
    __name(maybeReadMore_, "maybeReadMore_");
    Readable2.prototype._read = function(n13) {
      this.emit("error", new Error("_read() is not implemented"));
    };
    Readable2.prototype.pipe = function(dest, pipeOpts) {
      var src = this;
      var state5 = this._readableState;
      switch (state5.pipesCount) {
        case 0:
          state5.pipes = dest;
          break;
        case 1:
          state5.pipes = [state5.pipes, dest];
          break;
        default:
          state5.pipes.push(dest);
          break;
      }
      state5.pipesCount += 1;
      debug3("pipe count=%d opts=%j", state5.pipesCount, pipeOpts);
      var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
      var endFn = doEnd ? onend : unpipe;
      if (state5.endEmitted) pna.nextTick(endFn);
      else src.once("end", endFn);
      dest.on("unpipe", onunpipe);
      function onunpipe(readable, unpipeInfo) {
        debug3("onunpipe");
        if (readable === src) {
          if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
            unpipeInfo.hasUnpiped = true;
            cleanup();
          }
        }
      }
      __name(onunpipe, "onunpipe");
      function onend() {
        debug3("onend");
        dest.end();
      }
      __name(onend, "onend");
      var ondrain = pipeOnDrain(src);
      dest.on("drain", ondrain);
      var cleanedUp = false;
      function cleanup() {
        debug3("cleanup");
        dest.removeListener("close", onclose);
        dest.removeListener("finish", onfinish);
        dest.removeListener("drain", ondrain);
        dest.removeListener("error", onerror);
        dest.removeListener("unpipe", onunpipe);
        src.removeListener("end", onend);
        src.removeListener("end", unpipe);
        src.removeListener("data", ondata);
        cleanedUp = true;
        if (state5.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
      }
      __name(cleanup, "cleanup");
      var increasedAwaitDrain = false;
      src.on("data", ondata);
      function ondata(chunk) {
        debug3("ondata");
        increasedAwaitDrain = false;
        var ret = dest.write(chunk);
        if (false === ret && !increasedAwaitDrain) {
          if ((state5.pipesCount === 1 && state5.pipes === dest || state5.pipesCount > 1 && indexOf(state5.pipes, dest) !== -1) && !cleanedUp) {
            debug3("false write response, pause", state5.awaitDrain);
            state5.awaitDrain++;
            increasedAwaitDrain = true;
          }
          src.pause();
        }
      }
      __name(ondata, "ondata");
      function onerror(er) {
        debug3("onerror", er);
        unpipe();
        dest.removeListener("error", onerror);
        if (EElistenerCount(dest, "error") === 0) dest.emit("error", er);
      }
      __name(onerror, "onerror");
      prependListener(dest, "error", onerror);
      function onclose() {
        dest.removeListener("finish", onfinish);
        unpipe();
      }
      __name(onclose, "onclose");
      dest.once("close", onclose);
      function onfinish() {
        debug3("onfinish");
        dest.removeListener("close", onclose);
        unpipe();
      }
      __name(onfinish, "onfinish");
      dest.once("finish", onfinish);
      function unpipe() {
        debug3("unpipe");
        src.unpipe(dest);
      }
      __name(unpipe, "unpipe");
      dest.emit("pipe", src);
      if (!state5.flowing) {
        debug3("pipe resume");
        src.resume();
      }
      return dest;
    };
    function pipeOnDrain(src) {
      return function() {
        var state5 = src._readableState;
        debug3("pipeOnDrain", state5.awaitDrain);
        if (state5.awaitDrain) state5.awaitDrain--;
        if (state5.awaitDrain === 0 && EElistenerCount(src, "data")) {
          state5.flowing = true;
          flow(src);
        }
      };
    }
    __name(pipeOnDrain, "pipeOnDrain");
    Readable2.prototype.unpipe = function(dest) {
      var state5 = this._readableState;
      var unpipeInfo = { hasUnpiped: false };
      if (state5.pipesCount === 0) return this;
      if (state5.pipesCount === 1) {
        if (dest && dest !== state5.pipes) return this;
        if (!dest) dest = state5.pipes;
        state5.pipes = null;
        state5.pipesCount = 0;
        state5.flowing = false;
        if (dest) dest.emit("unpipe", this, unpipeInfo);
        return this;
      }
      if (!dest) {
        var dests = state5.pipes;
        var len = state5.pipesCount;
        state5.pipes = null;
        state5.pipesCount = 0;
        state5.flowing = false;
        for (var i13 = 0; i13 < len; i13++) {
          dests[i13].emit("unpipe", this, { hasUnpiped: false });
        }
        return this;
      }
      var index = indexOf(state5.pipes, dest);
      if (index === -1) return this;
      state5.pipes.splice(index, 1);
      state5.pipesCount -= 1;
      if (state5.pipesCount === 1) state5.pipes = state5.pipes[0];
      dest.emit("unpipe", this, unpipeInfo);
      return this;
    };
    Readable2.prototype.on = function(ev, fn) {
      var res = Stream2.prototype.on.call(this, ev, fn);
      if (ev === "data") {
        if (this._readableState.flowing !== false) this.resume();
      } else if (ev === "readable") {
        var state5 = this._readableState;
        if (!state5.endEmitted && !state5.readableListening) {
          state5.readableListening = state5.needReadable = true;
          state5.emittedReadable = false;
          if (!state5.reading) {
            pna.nextTick(nReadingNextTick, this);
          } else if (state5.length) {
            emitReadable(this);
          }
        }
      }
      return res;
    };
    Readable2.prototype.addListener = Readable2.prototype.on;
    function nReadingNextTick(self2) {
      debug3("readable nexttick read 0");
      self2.read(0);
    }
    __name(nReadingNextTick, "nReadingNextTick");
    Readable2.prototype.resume = function() {
      var state5 = this._readableState;
      if (!state5.flowing) {
        debug3("resume");
        state5.flowing = true;
        resume(this, state5);
      }
      return this;
    };
    function resume(stream3, state5) {
      if (!state5.resumeScheduled) {
        state5.resumeScheduled = true;
        pna.nextTick(resume_, stream3, state5);
      }
    }
    __name(resume, "resume");
    function resume_(stream3, state5) {
      if (!state5.reading) {
        debug3("resume read 0");
        stream3.read(0);
      }
      state5.resumeScheduled = false;
      state5.awaitDrain = 0;
      stream3.emit("resume");
      flow(stream3);
      if (state5.flowing && !state5.reading) stream3.read(0);
    }
    __name(resume_, "resume_");
    Readable2.prototype.pause = function() {
      debug3("call pause flowing=%j", this._readableState.flowing);
      if (false !== this._readableState.flowing) {
        debug3("pause");
        this._readableState.flowing = false;
        this.emit("pause");
      }
      return this;
    };
    function flow(stream3) {
      var state5 = stream3._readableState;
      debug3("flow", state5.flowing);
      while (state5.flowing && stream3.read() !== null) {
      }
    }
    __name(flow, "flow");
    Readable2.prototype.wrap = function(stream3) {
      var _this = this;
      var state5 = this._readableState;
      var paused = false;
      stream3.on("end", function() {
        debug3("wrapped end");
        if (state5.decoder && !state5.ended) {
          var chunk = state5.decoder.end();
          if (chunk && chunk.length) _this.push(chunk);
        }
        _this.push(null);
      });
      stream3.on("data", function(chunk) {
        debug3("wrapped data");
        if (state5.decoder) chunk = state5.decoder.write(chunk);
        if (state5.objectMode && (chunk === null || chunk === void 0)) return;
        else if (!state5.objectMode && (!chunk || !chunk.length)) return;
        var ret = _this.push(chunk);
        if (!ret) {
          paused = true;
          stream3.pause();
        }
      });
      for (var i13 in stream3) {
        if (this[i13] === void 0 && typeof stream3[i13] === "function") {
          this[i13] = /* @__PURE__ */ (function(method) {
            return function() {
              return stream3[method].apply(stream3, arguments);
            };
          })(i13);
        }
      }
      for (var n13 = 0; n13 < kProxyEvents.length; n13++) {
        stream3.on(kProxyEvents[n13], this.emit.bind(this, kProxyEvents[n13]));
      }
      this._read = function(n14) {
        debug3("wrapped _read", n14);
        if (paused) {
          paused = false;
          stream3.resume();
        }
      };
      return this;
    };
    Object.defineProperty(Readable2.prototype, "readableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: /* @__PURE__ */ __name(function() {
        return this._readableState.highWaterMark;
      }, "get")
    });
    Readable2._fromList = fromList;
    function fromList(n13, state5) {
      if (state5.length === 0) return null;
      var ret;
      if (state5.objectMode) ret = state5.buffer.shift();
      else if (!n13 || n13 >= state5.length) {
        if (state5.decoder) ret = state5.buffer.join("");
        else if (state5.buffer.length === 1) ret = state5.buffer.head.data;
        else ret = state5.buffer.concat(state5.length);
        state5.buffer.clear();
      } else {
        ret = fromListPartial(n13, state5.buffer, state5.decoder);
      }
      return ret;
    }
    __name(fromList, "fromList");
    function fromListPartial(n13, list2, hasStrings) {
      var ret;
      if (n13 < list2.head.data.length) {
        ret = list2.head.data.slice(0, n13);
        list2.head.data = list2.head.data.slice(n13);
      } else if (n13 === list2.head.data.length) {
        ret = list2.shift();
      } else {
        ret = hasStrings ? copyFromBufferString(n13, list2) : copyFromBuffer(n13, list2);
      }
      return ret;
    }
    __name(fromListPartial, "fromListPartial");
    function copyFromBufferString(n13, list2) {
      var p13 = list2.head;
      var c13 = 1;
      var ret = p13.data;
      n13 -= ret.length;
      while (p13 = p13.next) {
        var str = p13.data;
        var nb = n13 > str.length ? str.length : n13;
        if (nb === str.length) ret += str;
        else ret += str.slice(0, n13);
        n13 -= nb;
        if (n13 === 0) {
          if (nb === str.length) {
            ++c13;
            if (p13.next) list2.head = p13.next;
            else list2.head = list2.tail = null;
          } else {
            list2.head = p13;
            p13.data = str.slice(nb);
          }
          break;
        }
        ++c13;
      }
      list2.length -= c13;
      return ret;
    }
    __name(copyFromBufferString, "copyFromBufferString");
    function copyFromBuffer(n13, list2) {
      var ret = Buffer2.allocUnsafe(n13);
      var p13 = list2.head;
      var c13 = 1;
      p13.data.copy(ret);
      n13 -= p13.data.length;
      while (p13 = p13.next) {
        var buf = p13.data;
        var nb = n13 > buf.length ? buf.length : n13;
        buf.copy(ret, ret.length - n13, 0, nb);
        n13 -= nb;
        if (n13 === 0) {
          if (nb === buf.length) {
            ++c13;
            if (p13.next) list2.head = p13.next;
            else list2.head = list2.tail = null;
          } else {
            list2.head = p13;
            p13.data = buf.slice(nb);
          }
          break;
        }
        ++c13;
      }
      list2.length -= c13;
      return ret;
    }
    __name(copyFromBuffer, "copyFromBuffer");
    function endReadable(stream3) {
      var state5 = stream3._readableState;
      if (state5.length > 0) throw new Error('"endReadable()" called on non-empty stream');
      if (!state5.endEmitted) {
        state5.ended = true;
        pna.nextTick(endReadableNT, state5, stream3);
      }
    }
    __name(endReadable, "endReadable");
    function endReadableNT(state5, stream3) {
      if (!state5.endEmitted && state5.length === 0) {
        state5.endEmitted = true;
        stream3.readable = false;
        stream3.emit("end");
      }
    }
    __name(endReadableNT, "endReadableNT");
    function indexOf(xs, x13) {
      for (var i13 = 0, l13 = xs.length; i13 < l13; i13++) {
        if (xs[i13] === x13) return i13;
      }
      return -1;
    }
    __name(indexOf, "indexOf");
  }
});

// ../../node_modules/readable-stream/lib/_stream_transform.js
var require_stream_transform = __commonJS({
  "../../node_modules/readable-stream/lib/_stream_transform.js"(exports2, module2) {
    "use strict";
    module2.exports = Transform;
    var Duplex = require_stream_duplex();
    var util12 = Object.create(require_util());
    util12.inherits = require_inherits();
    util12.inherits(Transform, Duplex);
    function afterTransform(er, data3) {
      var ts = this._transformState;
      ts.transforming = false;
      var cb = ts.writecb;
      if (!cb) {
        return this.emit("error", new Error("write callback called multiple times"));
      }
      ts.writechunk = null;
      ts.writecb = null;
      if (data3 != null)
        this.push(data3);
      cb(er);
      var rs = this._readableState;
      rs.reading = false;
      if (rs.needReadable || rs.length < rs.highWaterMark) {
        this._read(rs.highWaterMark);
      }
    }
    __name(afterTransform, "afterTransform");
    function Transform(options) {
      if (!(this instanceof Transform)) return new Transform(options);
      Duplex.call(this, options);
      this._transformState = {
        afterTransform: afterTransform.bind(this),
        needTransform: false,
        transforming: false,
        writecb: null,
        writechunk: null,
        writeencoding: null
      };
      this._readableState.needReadable = true;
      this._readableState.sync = false;
      if (options) {
        if (typeof options.transform === "function") this._transform = options.transform;
        if (typeof options.flush === "function") this._flush = options.flush;
      }
      this.on("prefinish", prefinish);
    }
    __name(Transform, "Transform");
    function prefinish() {
      var _this = this;
      if (typeof this._flush === "function") {
        this._flush(function(er, data3) {
          done(_this, er, data3);
        });
      } else {
        done(this, null, null);
      }
    }
    __name(prefinish, "prefinish");
    Transform.prototype.push = function(chunk, encoding) {
      this._transformState.needTransform = false;
      return Duplex.prototype.push.call(this, chunk, encoding);
    };
    Transform.prototype._transform = function(chunk, encoding, cb) {
      throw new Error("_transform() is not implemented");
    };
    Transform.prototype._write = function(chunk, encoding, cb) {
      var ts = this._transformState;
      ts.writecb = cb;
      ts.writechunk = chunk;
      ts.writeencoding = encoding;
      if (!ts.transforming) {
        var rs = this._readableState;
        if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
      }
    };
    Transform.prototype._read = function(n13) {
      var ts = this._transformState;
      if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
        ts.transforming = true;
        this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
      } else {
        ts.needTransform = true;
      }
    };
    Transform.prototype._destroy = function(err, cb) {
      var _this2 = this;
      Duplex.prototype._destroy.call(this, err, function(err2) {
        cb(err2);
        _this2.emit("close");
      });
    };
    function done(stream3, er, data3) {
      if (er) return stream3.emit("error", er);
      if (data3 != null)
        stream3.push(data3);
      if (stream3._writableState.length) throw new Error("Calling transform done when ws.length != 0");
      if (stream3._transformState.transforming) throw new Error("Calling transform done when still transforming");
      return stream3.push(null);
    }
    __name(done, "done");
  }
});

// ../../node_modules/readable-stream/lib/_stream_passthrough.js
var require_stream_passthrough = __commonJS({
  "../../node_modules/readable-stream/lib/_stream_passthrough.js"(exports2, module2) {
    "use strict";
    module2.exports = PassThrough;
    var Transform = require_stream_transform();
    var util12 = Object.create(require_util());
    util12.inherits = require_inherits();
    util12.inherits(PassThrough, Transform);
    function PassThrough(options) {
      if (!(this instanceof PassThrough)) return new PassThrough(options);
      Transform.call(this, options);
    }
    __name(PassThrough, "PassThrough");
    PassThrough.prototype._transform = function(chunk, encoding, cb) {
      cb(null, chunk);
    };
  }
});

// ../../node_modules/readable-stream/readable.js
var require_readable = __commonJS({
  "../../node_modules/readable-stream/readable.js"(exports2, module2) {
    var Stream2 = require("stream");
    if (process.env.READABLE_STREAM === "disable" && Stream2) {
      module2.exports = Stream2;
      exports2 = module2.exports = Stream2.Readable;
      exports2.Readable = Stream2.Readable;
      exports2.Writable = Stream2.Writable;
      exports2.Duplex = Stream2.Duplex;
      exports2.Transform = Stream2.Transform;
      exports2.PassThrough = Stream2.PassThrough;
      exports2.Stream = Stream2;
    } else {
      exports2 = module2.exports = require_stream_readable();
      exports2.Stream = Stream2 || exports2;
      exports2.Readable = exports2;
      exports2.Writable = require_stream_writable();
      exports2.Duplex = require_stream_duplex();
      exports2.Transform = require_stream_transform();
      exports2.PassThrough = require_stream_passthrough();
    }
  }
});

// ../../node_modules/readable-stream/passthrough.js
var require_passthrough = __commonJS({
  "../../node_modules/readable-stream/passthrough.js"(exports2, module2) {
    module2.exports = require_readable().PassThrough;
  }
});

// ../../node_modules/lazystream/lib/lazystream.js
var require_lazystream = __commonJS({
  "../../node_modules/lazystream/lib/lazystream.js"(exports2, module2) {
    var util12 = require("util");
    var PassThrough = require_passthrough();
    module2.exports = {
      Readable: Readable2,
      Writable: Writable3
    };
    util12.inherits(Readable2, PassThrough);
    util12.inherits(Writable3, PassThrough);
    function beforeFirstCall(instance, method, callback) {
      instance[method] = function() {
        delete instance[method];
        callback.apply(this, arguments);
        return this[method].apply(this, arguments);
      };
    }
    __name(beforeFirstCall, "beforeFirstCall");
    function Readable2(fn, options) {
      if (!(this instanceof Readable2))
        return new Readable2(fn, options);
      PassThrough.call(this, options);
      beforeFirstCall(this, "_read", function() {
        var source = fn.call(this, options);
        var emit = this.emit.bind(this, "error");
        source.on("error", emit);
        source.pipe(this);
      });
      this.emit("readable");
    }
    __name(Readable2, "Readable");
    function Writable3(fn, options) {
      if (!(this instanceof Writable3))
        return new Writable3(fn, options);
      PassThrough.call(this, options);
      beforeFirstCall(this, "_write", function() {
        var destination = fn.call(this, options);
        var emit = this.emit.bind(this, "error");
        destination.on("error", emit);
        this.pipe(destination);
      });
      this.emit("writable");
    }
    __name(Writable3, "Writable");
  }
});

// ../../node_modules/normalize-path/index.js
var require_normalize_path = __commonJS({
  "../../node_modules/normalize-path/index.js"(exports2, module2) {
    module2.exports = function(path44, stripTrailing) {
      if (typeof path44 !== "string") {
        throw new TypeError("expected path to be a string");
      }
      if (path44 === "\\" || path44 === "/") return "/";
      var len = path44.length;
      if (len <= 1) return path44;
      var prefix2 = "";
      if (len > 4 && path44[3] === "\\") {
        var ch = path44[2];
        if ((ch === "?" || ch === ".") && path44.slice(0, 2) === "\\\\") {
          path44 = path44.slice(2);
          prefix2 = "//";
        }
      }
      var segs = path44.split(/[/\\]+/);
      if (stripTrailing !== false && segs[segs.length - 1] === "") {
        segs.pop();
      }
      return prefix2 + segs.join("/");
    };
  }
});

// ../../node_modules/lodash/identity.js
var require_identity = __commonJS({
  "../../node_modules/lodash/identity.js"(exports2, module2) {
    function identity(value) {
      return value;
    }
    __name(identity, "identity");
    module2.exports = identity;
  }
});

// ../../node_modules/lodash/_apply.js
var require_apply = __commonJS({
  "../../node_modules/lodash/_apply.js"(exports2, module2) {
    function apply(func, thisArg, args) {
      switch (args.length) {
        case 0:
          return func.call(thisArg);
        case 1:
          return func.call(thisArg, args[0]);
        case 2:
          return func.call(thisArg, args[0], args[1]);
        case 3:
          return func.call(thisArg, args[0], args[1], args[2]);
      }
      return func.apply(thisArg, args);
    }
    __name(apply, "apply");
    module2.exports = apply;
  }
});

// ../../node_modules/lodash/_overRest.js
var require_overRest = __commonJS({
  "../../node_modules/lodash/_overRest.js"(exports2, module2) {
    var apply = require_apply();
    var nativeMax = Math.max;
    function overRest(func, start, transform) {
      start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
      return function() {
        var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
        while (++index < length) {
          array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while (++index < start) {
          otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return apply(func, this, otherArgs);
      };
    }
    __name(overRest, "overRest");
    module2.exports = overRest;
  }
});

// ../../node_modules/lodash/constant.js
var require_constant = __commonJS({
  "../../node_modules/lodash/constant.js"(exports2, module2) {
    function constant(value) {
      return function() {
        return value;
      };
    }
    __name(constant, "constant");
    module2.exports = constant;
  }
});

// ../../node_modules/lodash/_freeGlobal.js
var require_freeGlobal = __commonJS({
  "../../node_modules/lodash/_freeGlobal.js"(exports2, module2) {
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    module2.exports = freeGlobal;
  }
});

// ../../node_modules/lodash/_root.js
var require_root = __commonJS({
  "../../node_modules/lodash/_root.js"(exports2, module2) {
    var freeGlobal = require_freeGlobal();
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    module2.exports = root;
  }
});

// ../../node_modules/lodash/_Symbol.js
var require_Symbol = __commonJS({
  "../../node_modules/lodash/_Symbol.js"(exports2, module2) {
    var root = require_root();
    var Symbol2 = root.Symbol;
    module2.exports = Symbol2;
  }
});

// ../../node_modules/lodash/_getRawTag.js
var require_getRawTag = __commonJS({
  "../../node_modules/lodash/_getRawTag.js"(exports2, module2) {
    var Symbol2 = require_Symbol();
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var nativeObjectToString = objectProto.toString;
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function getRawTag(value) {
      var isOwn = hasOwnProperty2.call(value, symToStringTag), tag2 = value[symToStringTag];
      try {
        value[symToStringTag] = void 0;
        var unmasked = true;
      } catch (e13) {
      }
      var result2 = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag2;
        } else {
          delete value[symToStringTag];
        }
      }
      return result2;
    }
    __name(getRawTag, "getRawTag");
    module2.exports = getRawTag;
  }
});

// ../../node_modules/lodash/_objectToString.js
var require_objectToString = __commonJS({
  "../../node_modules/lodash/_objectToString.js"(exports2, module2) {
    var objectProto = Object.prototype;
    var nativeObjectToString = objectProto.toString;
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    __name(objectToString, "objectToString");
    module2.exports = objectToString;
  }
});

// ../../node_modules/lodash/_baseGetTag.js
var require_baseGetTag = __commonJS({
  "../../node_modules/lodash/_baseGetTag.js"(exports2, module2) {
    var Symbol2 = require_Symbol();
    var getRawTag = require_getRawTag();
    var objectToString = require_objectToString();
    var nullTag = "[object Null]";
    var undefinedTag = "[object Undefined]";
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function baseGetTag(value) {
      if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
      }
      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    __name(baseGetTag, "baseGetTag");
    module2.exports = baseGetTag;
  }
});

// ../../node_modules/lodash/isObject.js
var require_isObject = __commonJS({
  "../../node_modules/lodash/isObject.js"(exports2, module2) {
    function isObject3(value) {
      var type = typeof value;
      return value != null && (type == "object" || type == "function");
    }
    __name(isObject3, "isObject");
    module2.exports = isObject3;
  }
});

// ../../node_modules/lodash/isFunction.js
var require_isFunction = __commonJS({
  "../../node_modules/lodash/isFunction.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isObject3 = require_isObject();
    var asyncTag = "[object AsyncFunction]";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var proxyTag = "[object Proxy]";
    function isFunction(value) {
      if (!isObject3(value)) {
        return false;
      }
      var tag2 = baseGetTag(value);
      return tag2 == funcTag || tag2 == genTag || tag2 == asyncTag || tag2 == proxyTag;
    }
    __name(isFunction, "isFunction");
    module2.exports = isFunction;
  }
});

// ../../node_modules/lodash/_coreJsData.js
var require_coreJsData = __commonJS({
  "../../node_modules/lodash/_coreJsData.js"(exports2, module2) {
    var root = require_root();
    var coreJsData = root["__core-js_shared__"];
    module2.exports = coreJsData;
  }
});

// ../../node_modules/lodash/_isMasked.js
var require_isMasked = __commonJS({
  "../../node_modules/lodash/_isMasked.js"(exports2, module2) {
    var coreJsData = require_coreJsData();
    var maskSrcKey = (function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    })();
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    __name(isMasked, "isMasked");
    module2.exports = isMasked;
  }
});

// ../../node_modules/lodash/_toSource.js
var require_toSource = __commonJS({
  "../../node_modules/lodash/_toSource.js"(exports2, module2) {
    var funcProto = Function.prototype;
    var funcToString = funcProto.toString;
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e13) {
        }
        try {
          return func + "";
        } catch (e13) {
        }
      }
      return "";
    }
    __name(toSource, "toSource");
    module2.exports = toSource;
  }
});

// ../../node_modules/lodash/_baseIsNative.js
var require_baseIsNative = __commonJS({
  "../../node_modules/lodash/_baseIsNative.js"(exports2, module2) {
    var isFunction = require_isFunction();
    var isMasked = require_isMasked();
    var isObject3 = require_isObject();
    var toSource = require_toSource();
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var funcProto = Function.prototype;
    var objectProto = Object.prototype;
    var funcToString = funcProto.toString;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var reIsNative = RegExp(
      "^" + funcToString.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    function baseIsNative(value) {
      if (!isObject3(value) || isMasked(value)) {
        return false;
      }
      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    __name(baseIsNative, "baseIsNative");
    module2.exports = baseIsNative;
  }
});

// ../../node_modules/lodash/_getValue.js
var require_getValue = __commonJS({
  "../../node_modules/lodash/_getValue.js"(exports2, module2) {
    function getValue(object, key) {
      return object == null ? void 0 : object[key];
    }
    __name(getValue, "getValue");
    module2.exports = getValue;
  }
});

// ../../node_modules/lodash/_getNative.js
var require_getNative = __commonJS({
  "../../node_modules/lodash/_getNative.js"(exports2, module2) {
    var baseIsNative = require_baseIsNative();
    var getValue = require_getValue();
    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : void 0;
    }
    __name(getNative, "getNative");
    module2.exports = getNative;
  }
});

// ../../node_modules/lodash/_defineProperty.js
var require_defineProperty = __commonJS({
  "../../node_modules/lodash/_defineProperty.js"(exports2, module2) {
    var getNative = require_getNative();
    var defineProperty = (function() {
      try {
        var func = getNative(Object, "defineProperty");
        func({}, "", {});
        return func;
      } catch (e13) {
      }
    })();
    module2.exports = defineProperty;
  }
});

// ../../node_modules/lodash/_baseSetToString.js
var require_baseSetToString = __commonJS({
  "../../node_modules/lodash/_baseSetToString.js"(exports2, module2) {
    var constant = require_constant();
    var defineProperty = require_defineProperty();
    var identity = require_identity();
    var baseSetToString = !defineProperty ? identity : function(func, string) {
      return defineProperty(func, "toString", {
        "configurable": true,
        "enumerable": false,
        "value": constant(string),
        "writable": true
      });
    };
    module2.exports = baseSetToString;
  }
});

// ../../node_modules/lodash/_shortOut.js
var require_shortOut = __commonJS({
  "../../node_modules/lodash/_shortOut.js"(exports2, module2) {
    var HOT_COUNT = 800;
    var HOT_SPAN = 16;
    var nativeNow = Date.now;
    function shortOut(func) {
      var count = 0, lastCalled = 0;
      return function() {
        var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return arguments[0];
          }
        } else {
          count = 0;
        }
        return func.apply(void 0, arguments);
      };
    }
    __name(shortOut, "shortOut");
    module2.exports = shortOut;
  }
});

// ../../node_modules/lodash/_setToString.js
var require_setToString = __commonJS({
  "../../node_modules/lodash/_setToString.js"(exports2, module2) {
    var baseSetToString = require_baseSetToString();
    var shortOut = require_shortOut();
    var setToString = shortOut(baseSetToString);
    module2.exports = setToString;
  }
});

// ../../node_modules/lodash/_baseRest.js
var require_baseRest = __commonJS({
  "../../node_modules/lodash/_baseRest.js"(exports2, module2) {
    var identity = require_identity();
    var overRest = require_overRest();
    var setToString = require_setToString();
    function baseRest(func, start) {
      return setToString(overRest(func, start, identity), func + "");
    }
    __name(baseRest, "baseRest");
    module2.exports = baseRest;
  }
});

// ../../node_modules/lodash/eq.js
var require_eq2 = __commonJS({
  "../../node_modules/lodash/eq.js"(exports2, module2) {
    function eq2(value, other) {
      return value === other || value !== value && other !== other;
    }
    __name(eq2, "eq");
    module2.exports = eq2;
  }
});

// ../../node_modules/lodash/isLength.js
var require_isLength = __commonJS({
  "../../node_modules/lodash/isLength.js"(exports2, module2) {
    var MAX_SAFE_INTEGER = 9007199254740991;
    function isLength(value) {
      return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    __name(isLength, "isLength");
    module2.exports = isLength;
  }
});

// ../../node_modules/lodash/isArrayLike.js
var require_isArrayLike = __commonJS({
  "../../node_modules/lodash/isArrayLike.js"(exports2, module2) {
    var isFunction = require_isFunction();
    var isLength = require_isLength();
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    __name(isArrayLike, "isArrayLike");
    module2.exports = isArrayLike;
  }
});

// ../../node_modules/lodash/_isIndex.js
var require_isIndex = __commonJS({
  "../../node_modules/lodash/_isIndex.js"(exports2, module2) {
    var MAX_SAFE_INTEGER = 9007199254740991;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    function isIndex(value, length) {
      var type = typeof value;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
    }
    __name(isIndex, "isIndex");
    module2.exports = isIndex;
  }
});

// ../../node_modules/lodash/_isIterateeCall.js
var require_isIterateeCall = __commonJS({
  "../../node_modules/lodash/_isIterateeCall.js"(exports2, module2) {
    var eq2 = require_eq2();
    var isArrayLike = require_isArrayLike();
    var isIndex = require_isIndex();
    var isObject3 = require_isObject();
    function isIterateeCall(value, index, object) {
      if (!isObject3(object)) {
        return false;
      }
      var type = typeof index;
      if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
        return eq2(object[index], value);
      }
      return false;
    }
    __name(isIterateeCall, "isIterateeCall");
    module2.exports = isIterateeCall;
  }
});

// ../../node_modules/lodash/_baseTimes.js
var require_baseTimes = __commonJS({
  "../../node_modules/lodash/_baseTimes.js"(exports2, module2) {
    function baseTimes(n13, iteratee) {
      var index = -1, result2 = Array(n13);
      while (++index < n13) {
        result2[index] = iteratee(index);
      }
      return result2;
    }
    __name(baseTimes, "baseTimes");
    module2.exports = baseTimes;
  }
});

// ../../node_modules/lodash/isObjectLike.js
var require_isObjectLike = __commonJS({
  "../../node_modules/lodash/isObjectLike.js"(exports2, module2) {
    function isObjectLike(value) {
      return value != null && typeof value == "object";
    }
    __name(isObjectLike, "isObjectLike");
    module2.exports = isObjectLike;
  }
});

// ../../node_modules/lodash/_baseIsArguments.js
var require_baseIsArguments = __commonJS({
  "../../node_modules/lodash/_baseIsArguments.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isObjectLike = require_isObjectLike();
    var argsTag = "[object Arguments]";
    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }
    __name(baseIsArguments, "baseIsArguments");
    module2.exports = baseIsArguments;
  }
});

// ../../node_modules/lodash/isArguments.js
var require_isArguments = __commonJS({
  "../../node_modules/lodash/isArguments.js"(exports2, module2) {
    var baseIsArguments = require_baseIsArguments();
    var isObjectLike = require_isObjectLike();
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var propertyIsEnumerable = objectProto.propertyIsEnumerable;
    var isArguments = baseIsArguments(/* @__PURE__ */ (function() {
      return arguments;
    })()) ? baseIsArguments : function(value) {
      return isObjectLike(value) && hasOwnProperty2.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
    };
    module2.exports = isArguments;
  }
});

// ../../node_modules/lodash/isArray.js
var require_isArray = __commonJS({
  "../../node_modules/lodash/isArray.js"(exports2, module2) {
    var isArray2 = Array.isArray;
    module2.exports = isArray2;
  }
});

// ../../node_modules/lodash/stubFalse.js
var require_stubFalse = __commonJS({
  "../../node_modules/lodash/stubFalse.js"(exports2, module2) {
    function stubFalse() {
      return false;
    }
    __name(stubFalse, "stubFalse");
    module2.exports = stubFalse;
  }
});

// ../../node_modules/lodash/isBuffer.js
var require_isBuffer = __commonJS({
  "../../node_modules/lodash/isBuffer.js"(exports2, module2) {
    var root = require_root();
    var stubFalse = require_stubFalse();
    var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer = nativeIsBuffer || stubFalse;
    module2.exports = isBuffer;
  }
});

// ../../node_modules/lodash/_baseIsTypedArray.js
var require_baseIsTypedArray = __commonJS({
  "../../node_modules/lodash/_baseIsTypedArray.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isLength = require_isLength();
    var isObjectLike = require_isObjectLike();
    var argsTag = "[object Arguments]";
    var arrayTag = "[object Array]";
    var boolTag = "[object Boolean]";
    var dateTag = "[object Date]";
    var errorTag = "[object Error]";
    var funcTag = "[object Function]";
    var mapTag = "[object Map]";
    var numberTag = "[object Number]";
    var objectTag = "[object Object]";
    var regexpTag = "[object RegExp]";
    var setTag = "[object Set]";
    var stringTag = "[object String]";
    var weakMapTag = "[object WeakMap]";
    var arrayBufferTag = "[object ArrayBuffer]";
    var dataViewTag = "[object DataView]";
    var float32Tag = "[object Float32Array]";
    var float64Tag = "[object Float64Array]";
    var int8Tag = "[object Int8Array]";
    var int16Tag = "[object Int16Array]";
    var int32Tag = "[object Int32Array]";
    var uint8Tag = "[object Uint8Array]";
    var uint8ClampedTag = "[object Uint8ClampedArray]";
    var uint16Tag = "[object Uint16Array]";
    var uint32Tag = "[object Uint32Array]";
    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }
    __name(baseIsTypedArray, "baseIsTypedArray");
    module2.exports = baseIsTypedArray;
  }
});

// ../../node_modules/lodash/_baseUnary.js
var require_baseUnary = __commonJS({
  "../../node_modules/lodash/_baseUnary.js"(exports2, module2) {
    function baseUnary(func) {
      return function(value) {
        return func(value);
      };
    }
    __name(baseUnary, "baseUnary");
    module2.exports = baseUnary;
  }
});

// ../../node_modules/lodash/_nodeUtil.js
var require_nodeUtil = __commonJS({
  "../../node_modules/lodash/_nodeUtil.js"(exports2, module2) {
    var freeGlobal = require_freeGlobal();
    var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal.process;
    var nodeUtil = (function() {
      try {
        var types5 = freeModule && freeModule.require && freeModule.require("util").types;
        if (types5) {
          return types5;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e13) {
      }
    })();
    module2.exports = nodeUtil;
  }
});

// ../../node_modules/lodash/isTypedArray.js
var require_isTypedArray = __commonJS({
  "../../node_modules/lodash/isTypedArray.js"(exports2, module2) {
    var baseIsTypedArray = require_baseIsTypedArray();
    var baseUnary = require_baseUnary();
    var nodeUtil = require_nodeUtil();
    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    module2.exports = isTypedArray;
  }
});

// ../../node_modules/lodash/_arrayLikeKeys.js
var require_arrayLikeKeys = __commonJS({
  "../../node_modules/lodash/_arrayLikeKeys.js"(exports2, module2) {
    var baseTimes = require_baseTimes();
    var isArguments = require_isArguments();
    var isArray2 = require_isArray();
    var isBuffer = require_isBuffer();
    var isIndex = require_isIndex();
    var isTypedArray = require_isTypedArray();
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    function arrayLikeKeys(value, inherited) {
      var isArr = isArray2(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String) : [], length = result2.length;
      for (var key in value) {
        if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
        (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
        isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
        isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
        isIndex(key, length)))) {
          result2.push(key);
        }
      }
      return result2;
    }
    __name(arrayLikeKeys, "arrayLikeKeys");
    module2.exports = arrayLikeKeys;
  }
});

// ../../node_modules/lodash/_isPrototype.js
var require_isPrototype = __commonJS({
  "../../node_modules/lodash/_isPrototype.js"(exports2, module2) {
    var objectProto = Object.prototype;
    function isPrototype(value) {
      var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
      return value === proto;
    }
    __name(isPrototype, "isPrototype");
    module2.exports = isPrototype;
  }
});

// ../../node_modules/lodash/_nativeKeysIn.js
var require_nativeKeysIn = __commonJS({
  "../../node_modules/lodash/_nativeKeysIn.js"(exports2, module2) {
    function nativeKeysIn(object) {
      var result2 = [];
      if (object != null) {
        for (var key in Object(object)) {
          result2.push(key);
        }
      }
      return result2;
    }
    __name(nativeKeysIn, "nativeKeysIn");
    module2.exports = nativeKeysIn;
  }
});

// ../../node_modules/lodash/_baseKeysIn.js
var require_baseKeysIn = __commonJS({
  "../../node_modules/lodash/_baseKeysIn.js"(exports2, module2) {
    var isObject3 = require_isObject();
    var isPrototype = require_isPrototype();
    var nativeKeysIn = require_nativeKeysIn();
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    function baseKeysIn(object) {
      if (!isObject3(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype(object), result2 = [];
      for (var key in object) {
        if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object, key)))) {
          result2.push(key);
        }
      }
      return result2;
    }
    __name(baseKeysIn, "baseKeysIn");
    module2.exports = baseKeysIn;
  }
});

// ../../node_modules/lodash/keysIn.js
var require_keysIn = __commonJS({
  "../../node_modules/lodash/keysIn.js"(exports2, module2) {
    var arrayLikeKeys = require_arrayLikeKeys();
    var baseKeysIn = require_baseKeysIn();
    var isArrayLike = require_isArrayLike();
    function keysIn(object) {
      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
    }
    __name(keysIn, "keysIn");
    module2.exports = keysIn;
  }
});

// ../../node_modules/lodash/defaults.js
var require_defaults = __commonJS({
  "../../node_modules/lodash/defaults.js"(exports2, module2) {
    var baseRest = require_baseRest();
    var eq2 = require_eq2();
    var isIterateeCall = require_isIterateeCall();
    var keysIn = require_keysIn();
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var defaults4 = baseRest(function(object, sources) {
      object = Object(object);
      var index = -1;
      var length = sources.length;
      var guard = length > 2 ? sources[2] : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        length = 1;
      }
      while (++index < length) {
        var source = sources[index];
        var props = keysIn(source);
        var propsIndex = -1;
        var propsLength = props.length;
        while (++propsIndex < propsLength) {
          var key = props[propsIndex];
          var value = object[key];
          if (value === void 0 || eq2(value, objectProto[key]) && !hasOwnProperty2.call(object, key)) {
            object[key] = source[key];
          }
        }
      }
      return object;
    });
    module2.exports = defaults4;
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/primordials.js
var require_primordials = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/primordials.js"(exports2, module2) {
    "use strict";
    var AggregateError = class extends Error {
      static {
        __name(this, "AggregateError");
      }
      constructor(errors) {
        if (!Array.isArray(errors)) {
          throw new TypeError(`Expected input to be an Array, got ${typeof errors}`);
        }
        let message2 = "";
        for (let i13 = 0; i13 < errors.length; i13++) {
          message2 += `    ${errors[i13].stack}
`;
        }
        super(message2);
        this.name = "AggregateError";
        this.errors = errors;
      }
    };
    module2.exports = {
      AggregateError,
      ArrayIsArray(self2) {
        return Array.isArray(self2);
      },
      ArrayPrototypeIncludes(self2, el) {
        return self2.includes(el);
      },
      ArrayPrototypeIndexOf(self2, el) {
        return self2.indexOf(el);
      },
      ArrayPrototypeJoin(self2, sep5) {
        return self2.join(sep5);
      },
      ArrayPrototypeMap(self2, fn) {
        return self2.map(fn);
      },
      ArrayPrototypePop(self2, el) {
        return self2.pop(el);
      },
      ArrayPrototypePush(self2, el) {
        return self2.push(el);
      },
      ArrayPrototypeSlice(self2, start, end) {
        return self2.slice(start, end);
      },
      Error,
      FunctionPrototypeCall(fn, thisArgs, ...args) {
        return fn.call(thisArgs, ...args);
      },
      FunctionPrototypeSymbolHasInstance(self2, instance) {
        return Function.prototype[Symbol.hasInstance].call(self2, instance);
      },
      MathFloor: Math.floor,
      Number,
      NumberIsInteger: Number.isInteger,
      NumberIsNaN: Number.isNaN,
      NumberMAX_SAFE_INTEGER: Number.MAX_SAFE_INTEGER,
      NumberMIN_SAFE_INTEGER: Number.MIN_SAFE_INTEGER,
      NumberParseInt: Number.parseInt,
      ObjectDefineProperties(self2, props) {
        return Object.defineProperties(self2, props);
      },
      ObjectDefineProperty(self2, name, prop) {
        return Object.defineProperty(self2, name, prop);
      },
      ObjectGetOwnPropertyDescriptor(self2, name) {
        return Object.getOwnPropertyDescriptor(self2, name);
      },
      ObjectKeys(obj) {
        return Object.keys(obj);
      },
      ObjectSetPrototypeOf(target, proto) {
        return Object.setPrototypeOf(target, proto);
      },
      Promise,
      PromisePrototypeCatch(self2, fn) {
        return self2.catch(fn);
      },
      PromisePrototypeThen(self2, thenFn, catchFn) {
        return self2.then(thenFn, catchFn);
      },
      PromiseReject(err) {
        return Promise.reject(err);
      },
      PromiseResolve(val) {
        return Promise.resolve(val);
      },
      ReflectApply: Reflect.apply,
      RegExpPrototypeTest(self2, value) {
        return self2.test(value);
      },
      SafeSet: Set,
      String,
      StringPrototypeSlice(self2, start, end) {
        return self2.slice(start, end);
      },
      StringPrototypeToLowerCase(self2) {
        return self2.toLowerCase();
      },
      StringPrototypeToUpperCase(self2) {
        return self2.toUpperCase();
      },
      StringPrototypeTrim(self2) {
        return self2.trim();
      },
      Symbol,
      SymbolFor: Symbol.for,
      SymbolAsyncIterator: Symbol.asyncIterator,
      SymbolHasInstance: Symbol.hasInstance,
      SymbolIterator: Symbol.iterator,
      SymbolDispose: Symbol.dispose || /* @__PURE__ */ Symbol("Symbol.dispose"),
      SymbolAsyncDispose: Symbol.asyncDispose || /* @__PURE__ */ Symbol("Symbol.asyncDispose"),
      TypedArrayPrototypeSet(self2, buf, len) {
        return self2.set(buf, len);
      },
      Boolean,
      Uint8Array
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util/inspect.js
var require_inspect = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util/inspect.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      format(format28, ...args) {
        return format28.replace(/%([sdifj])/g, function(...[_unused, type]) {
          const replacement = args.shift();
          if (type === "f") {
            return replacement.toFixed(6);
          } else if (type === "j") {
            return JSON.stringify(replacement);
          } else if (type === "s" && typeof replacement === "object") {
            const ctor = replacement.constructor !== Object ? replacement.constructor.name : "";
            return `${ctor} {}`.trim();
          } else {
            return replacement.toString();
          }
        });
      },
      inspect(value) {
        switch (typeof value) {
          case "string":
            if (value.includes("'")) {
              if (!value.includes('"')) {
                return `"${value}"`;
              } else if (!value.includes("`") && !value.includes("${")) {
                return `\`${value}\``;
              }
            }
            return `'${value}'`;
          case "number":
            if (isNaN(value)) {
              return "NaN";
            } else if (Object.is(value, -0)) {
              return String(value);
            }
            return value;
          case "bigint":
            return `${String(value)}n`;
          case "boolean":
          case "undefined":
            return String(value);
          case "object":
            return "{}";
        }
      }
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/errors.js
var require_errors = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/errors.js"(exports2, module2) {
    "use strict";
    var { format: format28, inspect: inspect4 } = require_inspect();
    var { AggregateError: CustomAggregateError } = require_primordials();
    var AggregateError = globalThis.AggregateError || CustomAggregateError;
    var kIsNodeError = /* @__PURE__ */ Symbol("kIsNodeError");
    var kTypes = [
      "string",
      "function",
      "number",
      "object",
      // Accept 'Function' and 'Object' as alternative to the lower cased version.
      "Function",
      "Object",
      "boolean",
      "bigint",
      "symbol"
    ];
    var classRegExp = /^([A-Z][a-z0-9]*)+$/;
    var nodeInternalPrefix = "__node_internal_";
    var codes = {};
    function assert(value, message2) {
      if (!value) {
        throw new codes.ERR_INTERNAL_ASSERTION(message2);
      }
    }
    __name(assert, "assert");
    function addNumericalSeparator(val) {
      let res = "";
      let i13 = val.length;
      const start = val[0] === "-" ? 1 : 0;
      for (; i13 >= start + 4; i13 -= 3) {
        res = `_${val.slice(i13 - 3, i13)}${res}`;
      }
      return `${val.slice(0, i13)}${res}`;
    }
    __name(addNumericalSeparator, "addNumericalSeparator");
    function getMessage(key, msg, args) {
      if (typeof msg === "function") {
        assert(
          msg.length <= args.length,
          // Default options do not count.
          `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${msg.length}).`
        );
        return msg(...args);
      }
      const expectedLength = (msg.match(/%[dfijoOs]/g) || []).length;
      assert(
        expectedLength === args.length,
        `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${expectedLength}).`
      );
      if (args.length === 0) {
        return msg;
      }
      return format28(msg, ...args);
    }
    __name(getMessage, "getMessage");
    function E5(code, message2, Base) {
      if (!Base) {
        Base = Error;
      }
      class NodeError extends Base {
        static {
          __name(this, "NodeError");
        }
        constructor(...args) {
          super(getMessage(code, message2, args));
        }
        toString() {
          return `${this.name} [${code}]: ${this.message}`;
        }
      }
      Object.defineProperties(NodeError.prototype, {
        name: {
          value: Base.name,
          writable: true,
          enumerable: false,
          configurable: true
        },
        toString: {
          value() {
            return `${this.name} [${code}]: ${this.message}`;
          },
          writable: true,
          enumerable: false,
          configurable: true
        }
      });
      NodeError.prototype.code = code;
      NodeError.prototype[kIsNodeError] = true;
      codes[code] = NodeError;
    }
    __name(E5, "E");
    function hideStackFrames(fn) {
      const hidden = nodeInternalPrefix + fn.name;
      Object.defineProperty(fn, "name", {
        value: hidden
      });
      return fn;
    }
    __name(hideStackFrames, "hideStackFrames");
    function aggregateTwoErrors(innerError, outerError) {
      if (innerError && outerError && innerError !== outerError) {
        if (Array.isArray(outerError.errors)) {
          outerError.errors.push(innerError);
          return outerError;
        }
        const err = new AggregateError([outerError, innerError], outerError.message);
        err.code = outerError.code;
        return err;
      }
      return innerError || outerError;
    }
    __name(aggregateTwoErrors, "aggregateTwoErrors");
    var AbortError = class extends Error {
      static {
        __name(this, "AbortError");
      }
      constructor(message2 = "The operation was aborted", options = void 0) {
        if (options !== void 0 && typeof options !== "object") {
          throw new codes.ERR_INVALID_ARG_TYPE("options", "Object", options);
        }
        super(message2, options);
        this.code = "ABORT_ERR";
        this.name = "AbortError";
      }
    };
    E5("ERR_ASSERTION", "%s", Error);
    E5(
      "ERR_INVALID_ARG_TYPE",
      (name, expected, actual) => {
        assert(typeof name === "string", "'name' must be a string");
        if (!Array.isArray(expected)) {
          expected = [expected];
        }
        let msg = "The ";
        if (name.endsWith(" argument")) {
          msg += `${name} `;
        } else {
          msg += `"${name}" ${name.includes(".") ? "property" : "argument"} `;
        }
        msg += "must be ";
        const types5 = [];
        const instances = [];
        const other = [];
        for (const value of expected) {
          assert(typeof value === "string", "All expected entries have to be of type string");
          if (kTypes.includes(value)) {
            types5.push(value.toLowerCase());
          } else if (classRegExp.test(value)) {
            instances.push(value);
          } else {
            assert(value !== "object", 'The value "object" should be written as "Object"');
            other.push(value);
          }
        }
        if (instances.length > 0) {
          const pos = types5.indexOf("object");
          if (pos !== -1) {
            types5.splice(types5, pos, 1);
            instances.push("Object");
          }
        }
        if (types5.length > 0) {
          switch (types5.length) {
            case 1:
              msg += `of type ${types5[0]}`;
              break;
            case 2:
              msg += `one of type ${types5[0]} or ${types5[1]}`;
              break;
            default: {
              const last = types5.pop();
              msg += `one of type ${types5.join(", ")}, or ${last}`;
            }
          }
          if (instances.length > 0 || other.length > 0) {
            msg += " or ";
          }
        }
        if (instances.length > 0) {
          switch (instances.length) {
            case 1:
              msg += `an instance of ${instances[0]}`;
              break;
            case 2:
              msg += `an instance of ${instances[0]} or ${instances[1]}`;
              break;
            default: {
              const last = instances.pop();
              msg += `an instance of ${instances.join(", ")}, or ${last}`;
            }
          }
          if (other.length > 0) {
            msg += " or ";
          }
        }
        switch (other.length) {
          case 0:
            break;
          case 1:
            if (other[0].toLowerCase() !== other[0]) {
              msg += "an ";
            }
            msg += `${other[0]}`;
            break;
          case 2:
            msg += `one of ${other[0]} or ${other[1]}`;
            break;
          default: {
            const last = other.pop();
            msg += `one of ${other.join(", ")}, or ${last}`;
          }
        }
        if (actual == null) {
          msg += `. Received ${actual}`;
        } else if (typeof actual === "function" && actual.name) {
          msg += `. Received function ${actual.name}`;
        } else if (typeof actual === "object") {
          var _actual$constructor;
          if ((_actual$constructor = actual.constructor) !== null && _actual$constructor !== void 0 && _actual$constructor.name) {
            msg += `. Received an instance of ${actual.constructor.name}`;
          } else {
            const inspected = inspect4(actual, {
              depth: -1
            });
            msg += `. Received ${inspected}`;
          }
        } else {
          let inspected = inspect4(actual, {
            colors: false
          });
          if (inspected.length > 25) {
            inspected = `${inspected.slice(0, 25)}...`;
          }
          msg += `. Received type ${typeof actual} (${inspected})`;
        }
        return msg;
      },
      TypeError
    );
    E5(
      "ERR_INVALID_ARG_VALUE",
      (name, value, reason = "is invalid") => {
        let inspected = inspect4(value);
        if (inspected.length > 128) {
          inspected = inspected.slice(0, 128) + "...";
        }
        const type = name.includes(".") ? "property" : "argument";
        return `The ${type} '${name}' ${reason}. Received ${inspected}`;
      },
      TypeError
    );
    E5(
      "ERR_INVALID_RETURN_VALUE",
      (input, name, value) => {
        var _value$constructor;
        const type = value !== null && value !== void 0 && (_value$constructor = value.constructor) !== null && _value$constructor !== void 0 && _value$constructor.name ? `instance of ${value.constructor.name}` : `type ${typeof value}`;
        return `Expected ${input} to be returned from the "${name}" function but got ${type}.`;
      },
      TypeError
    );
    E5(
      "ERR_MISSING_ARGS",
      (...args) => {
        assert(args.length > 0, "At least one arg needs to be specified");
        let msg;
        const len = args.length;
        args = (Array.isArray(args) ? args : [args]).map((a13) => `"${a13}"`).join(" or ");
        switch (len) {
          case 1:
            msg += `The ${args[0]} argument`;
            break;
          case 2:
            msg += `The ${args[0]} and ${args[1]} arguments`;
            break;
          default:
            {
              const last = args.pop();
              msg += `The ${args.join(", ")}, and ${last} arguments`;
            }
            break;
        }
        return `${msg} must be specified`;
      },
      TypeError
    );
    E5(
      "ERR_OUT_OF_RANGE",
      (str, range3, input) => {
        assert(range3, 'Missing "range" argument');
        let received;
        if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
          received = addNumericalSeparator(String(input));
        } else if (typeof input === "bigint") {
          received = String(input);
          const limit = BigInt(2) ** BigInt(32);
          if (input > limit || input < -limit) {
            received = addNumericalSeparator(received);
          }
          received += "n";
        } else {
          received = inspect4(input);
        }
        return `The value of "${str}" is out of range. It must be ${range3}. Received ${received}`;
      },
      RangeError
    );
    E5("ERR_MULTIPLE_CALLBACK", "Callback called multiple times", Error);
    E5("ERR_METHOD_NOT_IMPLEMENTED", "The %s method is not implemented", Error);
    E5("ERR_STREAM_ALREADY_FINISHED", "Cannot call %s after a stream was finished", Error);
    E5("ERR_STREAM_CANNOT_PIPE", "Cannot pipe, not readable", Error);
    E5("ERR_STREAM_DESTROYED", "Cannot call %s after a stream was destroyed", Error);
    E5("ERR_STREAM_NULL_VALUES", "May not write null values to stream", TypeError);
    E5("ERR_STREAM_PREMATURE_CLOSE", "Premature close", Error);
    E5("ERR_STREAM_PUSH_AFTER_EOF", "stream.push() after EOF", Error);
    E5("ERR_STREAM_UNSHIFT_AFTER_END_EVENT", "stream.unshift() after end event", Error);
    E5("ERR_STREAM_WRITE_AFTER_END", "write after end", Error);
    E5("ERR_UNKNOWN_ENCODING", "Unknown encoding: %s", TypeError);
    module2.exports = {
      AbortError,
      aggregateTwoErrors: hideStackFrames(aggregateTwoErrors),
      hideStackFrames,
      codes
    };
  }
});

// ../../node_modules/event-target-shim/dist/event-target-shim.js
var require_event_target_shim = __commonJS({
  "../../node_modules/event-target-shim/dist/event-target-shim.js"(exports2, module2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var privateData = /* @__PURE__ */ new WeakMap();
    var wrappers = /* @__PURE__ */ new WeakMap();
    function pd(event) {
      const retv = privateData.get(event);
      console.assert(
        retv != null,
        "'this' is expected an Event object, but got",
        event
      );
      return retv;
    }
    __name(pd, "pd");
    function setCancelFlag(data3) {
      if (data3.passiveListener != null) {
        if (typeof console !== "undefined" && typeof console.error === "function") {
          console.error(
            "Unable to preventDefault inside passive event listener invocation.",
            data3.passiveListener
          );
        }
        return;
      }
      if (!data3.event.cancelable) {
        return;
      }
      data3.canceled = true;
      if (typeof data3.event.preventDefault === "function") {
        data3.event.preventDefault();
      }
    }
    __name(setCancelFlag, "setCancelFlag");
    function Event(eventTarget, event) {
      privateData.set(this, {
        eventTarget,
        event,
        eventPhase: 2,
        currentTarget: eventTarget,
        canceled: false,
        stopped: false,
        immediateStopped: false,
        passiveListener: null,
        timeStamp: event.timeStamp || Date.now()
      });
      Object.defineProperty(this, "isTrusted", { value: false, enumerable: true });
      const keys = Object.keys(event);
      for (let i13 = 0; i13 < keys.length; ++i13) {
        const key = keys[i13];
        if (!(key in this)) {
          Object.defineProperty(this, key, defineRedirectDescriptor(key));
        }
      }
    }
    __name(Event, "Event");
    Event.prototype = {
      /**
       * The type of this event.
       * @type {string}
       */
      get type() {
        return pd(this).event.type;
      },
      /**
       * The target of this event.
       * @type {EventTarget}
       */
      get target() {
        return pd(this).eventTarget;
      },
      /**
       * The target of this event.
       * @type {EventTarget}
       */
      get currentTarget() {
        return pd(this).currentTarget;
      },
      /**
       * @returns {EventTarget[]} The composed path of this event.
       */
      composedPath() {
        const currentTarget = pd(this).currentTarget;
        if (currentTarget == null) {
          return [];
        }
        return [currentTarget];
      },
      /**
       * Constant of NONE.
       * @type {number}
       */
      get NONE() {
        return 0;
      },
      /**
       * Constant of CAPTURING_PHASE.
       * @type {number}
       */
      get CAPTURING_PHASE() {
        return 1;
      },
      /**
       * Constant of AT_TARGET.
       * @type {number}
       */
      get AT_TARGET() {
        return 2;
      },
      /**
       * Constant of BUBBLING_PHASE.
       * @type {number}
       */
      get BUBBLING_PHASE() {
        return 3;
      },
      /**
       * The target of this event.
       * @type {number}
       */
      get eventPhase() {
        return pd(this).eventPhase;
      },
      /**
       * Stop event bubbling.
       * @returns {void}
       */
      stopPropagation() {
        const data3 = pd(this);
        data3.stopped = true;
        if (typeof data3.event.stopPropagation === "function") {
          data3.event.stopPropagation();
        }
      },
      /**
       * Stop event bubbling.
       * @returns {void}
       */
      stopImmediatePropagation() {
        const data3 = pd(this);
        data3.stopped = true;
        data3.immediateStopped = true;
        if (typeof data3.event.stopImmediatePropagation === "function") {
          data3.event.stopImmediatePropagation();
        }
      },
      /**
       * The flag to be bubbling.
       * @type {boolean}
       */
      get bubbles() {
        return Boolean(pd(this).event.bubbles);
      },
      /**
       * The flag to be cancelable.
       * @type {boolean}
       */
      get cancelable() {
        return Boolean(pd(this).event.cancelable);
      },
      /**
       * Cancel this event.
       * @returns {void}
       */
      preventDefault() {
        setCancelFlag(pd(this));
      },
      /**
       * The flag to indicate cancellation state.
       * @type {boolean}
       */
      get defaultPrevented() {
        return pd(this).canceled;
      },
      /**
       * The flag to be composed.
       * @type {boolean}
       */
      get composed() {
        return Boolean(pd(this).event.composed);
      },
      /**
       * The unix time of this event.
       * @type {number}
       */
      get timeStamp() {
        return pd(this).timeStamp;
      },
      /**
       * The target of this event.
       * @type {EventTarget}
       * @deprecated
       */
      get srcElement() {
        return pd(this).eventTarget;
      },
      /**
       * The flag to stop event bubbling.
       * @type {boolean}
       * @deprecated
       */
      get cancelBubble() {
        return pd(this).stopped;
      },
      set cancelBubble(value) {
        if (!value) {
          return;
        }
        const data3 = pd(this);
        data3.stopped = true;
        if (typeof data3.event.cancelBubble === "boolean") {
          data3.event.cancelBubble = true;
        }
      },
      /**
       * The flag to indicate cancellation state.
       * @type {boolean}
       * @deprecated
       */
      get returnValue() {
        return !pd(this).canceled;
      },
      set returnValue(value) {
        if (!value) {
          setCancelFlag(pd(this));
        }
      },
      /**
       * Initialize this event object. But do nothing under event dispatching.
       * @param {string} type The event type.
       * @param {boolean} [bubbles=false] The flag to be possible to bubble up.
       * @param {boolean} [cancelable=false] The flag to be possible to cancel.
       * @deprecated
       */
      initEvent() {
      }
    };
    Object.defineProperty(Event.prototype, "constructor", {
      value: Event,
      configurable: true,
      writable: true
    });
    if (typeof window !== "undefined" && typeof window.Event !== "undefined") {
      Object.setPrototypeOf(Event.prototype, window.Event.prototype);
      wrappers.set(window.Event.prototype, Event);
    }
    function defineRedirectDescriptor(key) {
      return {
        get() {
          return pd(this).event[key];
        },
        set(value) {
          pd(this).event[key] = value;
        },
        configurable: true,
        enumerable: true
      };
    }
    __name(defineRedirectDescriptor, "defineRedirectDescriptor");
    function defineCallDescriptor(key) {
      return {
        value() {
          const event = pd(this).event;
          return event[key].apply(event, arguments);
        },
        configurable: true,
        enumerable: true
      };
    }
    __name(defineCallDescriptor, "defineCallDescriptor");
    function defineWrapper(BaseEvent, proto) {
      const keys = Object.keys(proto);
      if (keys.length === 0) {
        return BaseEvent;
      }
      function CustomEvent(eventTarget, event) {
        BaseEvent.call(this, eventTarget, event);
      }
      __name(CustomEvent, "CustomEvent");
      CustomEvent.prototype = Object.create(BaseEvent.prototype, {
        constructor: { value: CustomEvent, configurable: true, writable: true }
      });
      for (let i13 = 0; i13 < keys.length; ++i13) {
        const key = keys[i13];
        if (!(key in BaseEvent.prototype)) {
          const descriptor = Object.getOwnPropertyDescriptor(proto, key);
          const isFunc = typeof descriptor.value === "function";
          Object.defineProperty(
            CustomEvent.prototype,
            key,
            isFunc ? defineCallDescriptor(key) : defineRedirectDescriptor(key)
          );
        }
      }
      return CustomEvent;
    }
    __name(defineWrapper, "defineWrapper");
    function getWrapper(proto) {
      if (proto == null || proto === Object.prototype) {
        return Event;
      }
      let wrapper = wrappers.get(proto);
      if (wrapper == null) {
        wrapper = defineWrapper(getWrapper(Object.getPrototypeOf(proto)), proto);
        wrappers.set(proto, wrapper);
      }
      return wrapper;
    }
    __name(getWrapper, "getWrapper");
    function wrapEvent(eventTarget, event) {
      const Wrapper = getWrapper(Object.getPrototypeOf(event));
      return new Wrapper(eventTarget, event);
    }
    __name(wrapEvent, "wrapEvent");
    function isStopped(event) {
      return pd(event).immediateStopped;
    }
    __name(isStopped, "isStopped");
    function setEventPhase(event, eventPhase) {
      pd(event).eventPhase = eventPhase;
    }
    __name(setEventPhase, "setEventPhase");
    function setCurrentTarget(event, currentTarget) {
      pd(event).currentTarget = currentTarget;
    }
    __name(setCurrentTarget, "setCurrentTarget");
    function setPassiveListener(event, passiveListener) {
      pd(event).passiveListener = passiveListener;
    }
    __name(setPassiveListener, "setPassiveListener");
    var listenersMap = /* @__PURE__ */ new WeakMap();
    var CAPTURE = 1;
    var BUBBLE = 2;
    var ATTRIBUTE = 3;
    function isObject3(x13) {
      return x13 !== null && typeof x13 === "object";
    }
    __name(isObject3, "isObject");
    function getListeners(eventTarget) {
      const listeners = listenersMap.get(eventTarget);
      if (listeners == null) {
        throw new TypeError(
          "'this' is expected an EventTarget object, but got another value."
        );
      }
      return listeners;
    }
    __name(getListeners, "getListeners");
    function defineEventAttributeDescriptor(eventName) {
      return {
        get() {
          const listeners = getListeners(this);
          let node = listeners.get(eventName);
          while (node != null) {
            if (node.listenerType === ATTRIBUTE) {
              return node.listener;
            }
            node = node.next;
          }
          return null;
        },
        set(listener) {
          if (typeof listener !== "function" && !isObject3(listener)) {
            listener = null;
          }
          const listeners = getListeners(this);
          let prev = null;
          let node = listeners.get(eventName);
          while (node != null) {
            if (node.listenerType === ATTRIBUTE) {
              if (prev !== null) {
                prev.next = node.next;
              } else if (node.next !== null) {
                listeners.set(eventName, node.next);
              } else {
                listeners.delete(eventName);
              }
            } else {
              prev = node;
            }
            node = node.next;
          }
          if (listener !== null) {
            const newNode = {
              listener,
              listenerType: ATTRIBUTE,
              passive: false,
              once: false,
              next: null
            };
            if (prev === null) {
              listeners.set(eventName, newNode);
            } else {
              prev.next = newNode;
            }
          }
        },
        configurable: true,
        enumerable: true
      };
    }
    __name(defineEventAttributeDescriptor, "defineEventAttributeDescriptor");
    function defineEventAttribute(eventTargetPrototype, eventName) {
      Object.defineProperty(
        eventTargetPrototype,
        `on${eventName}`,
        defineEventAttributeDescriptor(eventName)
      );
    }
    __name(defineEventAttribute, "defineEventAttribute");
    function defineCustomEventTarget(eventNames) {
      function CustomEventTarget() {
        EventTarget.call(this);
      }
      __name(CustomEventTarget, "CustomEventTarget");
      CustomEventTarget.prototype = Object.create(EventTarget.prototype, {
        constructor: {
          value: CustomEventTarget,
          configurable: true,
          writable: true
        }
      });
      for (let i13 = 0; i13 < eventNames.length; ++i13) {
        defineEventAttribute(CustomEventTarget.prototype, eventNames[i13]);
      }
      return CustomEventTarget;
    }
    __name(defineCustomEventTarget, "defineCustomEventTarget");
    function EventTarget() {
      if (this instanceof EventTarget) {
        listenersMap.set(this, /* @__PURE__ */ new Map());
        return;
      }
      if (arguments.length === 1 && Array.isArray(arguments[0])) {
        return defineCustomEventTarget(arguments[0]);
      }
      if (arguments.length > 0) {
        const types5 = new Array(arguments.length);
        for (let i13 = 0; i13 < arguments.length; ++i13) {
          types5[i13] = arguments[i13];
        }
        return defineCustomEventTarget(types5);
      }
      throw new TypeError("Cannot call a class as a function");
    }
    __name(EventTarget, "EventTarget");
    EventTarget.prototype = {
      /**
       * Add a given listener to this event target.
       * @param {string} eventName The event name to add.
       * @param {Function} listener The listener to add.
       * @param {boolean|{capture?:boolean,passive?:boolean,once?:boolean}} [options] The options for this listener.
       * @returns {void}
       */
      addEventListener(eventName, listener, options) {
        if (listener == null) {
          return;
        }
        if (typeof listener !== "function" && !isObject3(listener)) {
          throw new TypeError("'listener' should be a function or an object.");
        }
        const listeners = getListeners(this);
        const optionsIsObj = isObject3(options);
        const capture = optionsIsObj ? Boolean(options.capture) : Boolean(options);
        const listenerType = capture ? CAPTURE : BUBBLE;
        const newNode = {
          listener,
          listenerType,
          passive: optionsIsObj && Boolean(options.passive),
          once: optionsIsObj && Boolean(options.once),
          next: null
        };
        let node = listeners.get(eventName);
        if (node === void 0) {
          listeners.set(eventName, newNode);
          return;
        }
        let prev = null;
        while (node != null) {
          if (node.listener === listener && node.listenerType === listenerType) {
            return;
          }
          prev = node;
          node = node.next;
        }
        prev.next = newNode;
      },
      /**
       * Remove a given listener from this event target.
       * @param {string} eventName The event name to remove.
       * @param {Function} listener The listener to remove.
       * @param {boolean|{capture?:boolean,passive?:boolean,once?:boolean}} [options] The options for this listener.
       * @returns {void}
       */
      removeEventListener(eventName, listener, options) {
        if (listener == null) {
          return;
        }
        const listeners = getListeners(this);
        const capture = isObject3(options) ? Boolean(options.capture) : Boolean(options);
        const listenerType = capture ? CAPTURE : BUBBLE;
        let prev = null;
        let node = listeners.get(eventName);
        while (node != null) {
          if (node.listener === listener && node.listenerType === listenerType) {
            if (prev !== null) {
              prev.next = node.next;
            } else if (node.next !== null) {
              listeners.set(eventName, node.next);
            } else {
              listeners.delete(eventName);
            }
            return;
          }
          prev = node;
          node = node.next;
        }
      },
      /**
       * Dispatch a given event.
       * @param {Event|{type:string}} event The event to dispatch.
       * @returns {boolean} `false` if canceled.
       */
      dispatchEvent(event) {
        if (event == null || typeof event.type !== "string") {
          throw new TypeError('"event.type" should be a string.');
        }
        const listeners = getListeners(this);
        const eventName = event.type;
        let node = listeners.get(eventName);
        if (node == null) {
          return true;
        }
        const wrappedEvent = wrapEvent(this, event);
        let prev = null;
        while (node != null) {
          if (node.once) {
            if (prev !== null) {
              prev.next = node.next;
            } else if (node.next !== null) {
              listeners.set(eventName, node.next);
            } else {
              listeners.delete(eventName);
            }
          } else {
            prev = node;
          }
          setPassiveListener(
            wrappedEvent,
            node.passive ? node.listener : null
          );
          if (typeof node.listener === "function") {
            try {
              node.listener.call(this, wrappedEvent);
            } catch (err) {
              if (typeof console !== "undefined" && typeof console.error === "function") {
                console.error(err);
              }
            }
          } else if (node.listenerType !== ATTRIBUTE && typeof node.listener.handleEvent === "function") {
            node.listener.handleEvent(wrappedEvent);
          }
          if (isStopped(wrappedEvent)) {
            break;
          }
          node = node.next;
        }
        setPassiveListener(wrappedEvent, null);
        setEventPhase(wrappedEvent, 0);
        setCurrentTarget(wrappedEvent, null);
        return !wrappedEvent.defaultPrevented;
      }
    };
    Object.defineProperty(EventTarget.prototype, "constructor", {
      value: EventTarget,
      configurable: true,
      writable: true
    });
    if (typeof window !== "undefined" && typeof window.EventTarget !== "undefined") {
      Object.setPrototypeOf(EventTarget.prototype, window.EventTarget.prototype);
    }
    exports2.defineEventAttribute = defineEventAttribute;
    exports2.EventTarget = EventTarget;
    exports2.default = EventTarget;
    module2.exports = EventTarget;
    module2.exports.EventTarget = module2.exports["default"] = EventTarget;
    module2.exports.defineEventAttribute = defineEventAttribute;
  }
});

// ../../node_modules/abort-controller/dist/abort-controller.js
var require_abort_controller = __commonJS({
  "../../node_modules/abort-controller/dist/abort-controller.js"(exports2, module2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var eventTargetShim = require_event_target_shim();
    var AbortSignal2 = class extends eventTargetShim.EventTarget {
      static {
        __name(this, "AbortSignal");
      }
      /**
       * AbortSignal cannot be constructed directly.
       */
      constructor() {
        super();
        throw new TypeError("AbortSignal cannot be constructed directly");
      }
      /**
       * Returns `true` if this `AbortSignal`'s `AbortController` has signaled to abort, and `false` otherwise.
       */
      get aborted() {
        const aborted = abortedFlags.get(this);
        if (typeof aborted !== "boolean") {
          throw new TypeError(`Expected 'this' to be an 'AbortSignal' object, but got ${this === null ? "null" : typeof this}`);
        }
        return aborted;
      }
    };
    eventTargetShim.defineEventAttribute(AbortSignal2.prototype, "abort");
    function createAbortSignal() {
      const signal = Object.create(AbortSignal2.prototype);
      eventTargetShim.EventTarget.call(signal);
      abortedFlags.set(signal, false);
      return signal;
    }
    __name(createAbortSignal, "createAbortSignal");
    function abortSignal(signal) {
      if (abortedFlags.get(signal) !== false) {
        return;
      }
      abortedFlags.set(signal, true);
      signal.dispatchEvent({ type: "abort" });
    }
    __name(abortSignal, "abortSignal");
    var abortedFlags = /* @__PURE__ */ new WeakMap();
    Object.defineProperties(AbortSignal2.prototype, {
      aborted: { enumerable: true }
    });
    if (typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol") {
      Object.defineProperty(AbortSignal2.prototype, Symbol.toStringTag, {
        configurable: true,
        value: "AbortSignal"
      });
    }
    var AbortController2 = class {
      static {
        __name(this, "AbortController");
      }
      /**
       * Initialize this controller.
       */
      constructor() {
        signals.set(this, createAbortSignal());
      }
      /**
       * Returns the `AbortSignal` object associated with this object.
       */
      get signal() {
        return getSignal(this);
      }
      /**
       * Abort and signal to any observers that the associated activity is to be aborted.
       */
      abort() {
        abortSignal(getSignal(this));
      }
    };
    var signals = /* @__PURE__ */ new WeakMap();
    function getSignal(controller) {
      const signal = signals.get(controller);
      if (signal == null) {
        throw new TypeError(`Expected 'this' to be an 'AbortController' object, but got ${controller === null ? "null" : typeof controller}`);
      }
      return signal;
    }
    __name(getSignal, "getSignal");
    Object.defineProperties(AbortController2.prototype, {
      signal: { enumerable: true },
      abort: { enumerable: true }
    });
    if (typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol") {
      Object.defineProperty(AbortController2.prototype, Symbol.toStringTag, {
        configurable: true,
        value: "AbortController"
      });
    }
    exports2.AbortController = AbortController2;
    exports2.AbortSignal = AbortSignal2;
    exports2.default = AbortController2;
    module2.exports = AbortController2;
    module2.exports.AbortController = module2.exports["default"] = AbortController2;
    module2.exports.AbortSignal = AbortSignal2;
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util.js
var require_util2 = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util.js"(exports2, module2) {
    "use strict";
    var bufferModule = require("buffer");
    var { format: format28, inspect: inspect4 } = require_inspect();
    var {
      codes: { ERR_INVALID_ARG_TYPE }
    } = require_errors();
    var { kResistStopPropagation, AggregateError, SymbolDispose } = require_primordials();
    var AbortSignal2 = globalThis.AbortSignal || require_abort_controller().AbortSignal;
    var AbortController2 = globalThis.AbortController || require_abort_controller().AbortController;
    var AsyncFunction = Object.getPrototypeOf(async function() {
    }).constructor;
    var Blob2 = globalThis.Blob || bufferModule.Blob;
    var isBlob = typeof Blob2 !== "undefined" ? /* @__PURE__ */ __name(function isBlob2(b13) {
      return b13 instanceof Blob2;
    }, "isBlob") : /* @__PURE__ */ __name(function isBlob2(b13) {
      return false;
    }, "isBlob");
    var validateAbortSignal = /* @__PURE__ */ __name((signal, name) => {
      if (signal !== void 0 && (signal === null || typeof signal !== "object" || !("aborted" in signal))) {
        throw new ERR_INVALID_ARG_TYPE(name, "AbortSignal", signal);
      }
    }, "validateAbortSignal");
    var validateFunction = /* @__PURE__ */ __name((value, name) => {
      if (typeof value !== "function") {
        throw new ERR_INVALID_ARG_TYPE(name, "Function", value);
      }
    }, "validateFunction");
    module2.exports = {
      AggregateError,
      kEmptyObject: Object.freeze({}),
      once(callback) {
        let called = false;
        return function(...args) {
          if (called) {
            return;
          }
          called = true;
          callback.apply(this, args);
        };
      },
      createDeferredPromise: /* @__PURE__ */ __name(function() {
        let resolve16;
        let reject;
        const promise = new Promise((res, rej) => {
          resolve16 = res;
          reject = rej;
        });
        return {
          promise,
          resolve: resolve16,
          reject
        };
      }, "createDeferredPromise"),
      promisify(fn) {
        return new Promise((resolve16, reject) => {
          fn((err, ...args) => {
            if (err) {
              return reject(err);
            }
            return resolve16(...args);
          });
        });
      },
      debuglog() {
        return function() {
        };
      },
      format: format28,
      inspect: inspect4,
      types: {
        isAsyncFunction(fn) {
          return fn instanceof AsyncFunction;
        },
        isArrayBufferView(arr) {
          return ArrayBuffer.isView(arr);
        }
      },
      isBlob,
      deprecate(fn, message2) {
        return fn;
      },
      addAbortListener: require("events").addAbortListener || /* @__PURE__ */ __name(function addAbortListener(signal, listener) {
        if (signal === void 0) {
          throw new ERR_INVALID_ARG_TYPE("signal", "AbortSignal", signal);
        }
        validateAbortSignal(signal, "signal");
        validateFunction(listener, "listener");
        let removeEventListener;
        if (signal.aborted) {
          queueMicrotask(() => listener());
        } else {
          signal.addEventListener("abort", listener, {
            __proto__: null,
            once: true,
            [kResistStopPropagation]: true
          });
          removeEventListener = /* @__PURE__ */ __name(() => {
            signal.removeEventListener("abort", listener);
          }, "removeEventListener");
        }
        return {
          __proto__: null,
          [SymbolDispose]() {
            var _removeEventListener;
            (_removeEventListener = removeEventListener) === null || _removeEventListener === void 0 ? void 0 : _removeEventListener();
          }
        };
      }, "addAbortListener"),
      AbortSignalAny: AbortSignal2.any || /* @__PURE__ */ __name(function AbortSignalAny(signals) {
        if (signals.length === 1) {
          return signals[0];
        }
        const ac = new AbortController2();
        const abort = /* @__PURE__ */ __name(() => ac.abort(), "abort");
        signals.forEach((signal) => {
          validateAbortSignal(signal, "signals");
          signal.addEventListener("abort", abort, {
            once: true
          });
        });
        ac.signal.addEventListener(
          "abort",
          () => {
            signals.forEach((signal) => signal.removeEventListener("abort", abort));
          },
          {
            once: true
          }
        );
        return ac.signal;
      }, "AbortSignalAny")
    };
    module2.exports.promisify.custom = /* @__PURE__ */ Symbol.for("nodejs.util.promisify.custom");
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/validators.js
var require_validators = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/validators.js"(exports2, module2) {
    "use strict";
    var {
      ArrayIsArray,
      ArrayPrototypeIncludes,
      ArrayPrototypeJoin,
      ArrayPrototypeMap,
      NumberIsInteger,
      NumberIsNaN,
      NumberMAX_SAFE_INTEGER,
      NumberMIN_SAFE_INTEGER,
      NumberParseInt,
      ObjectPrototypeHasOwnProperty,
      RegExpPrototypeExec,
      String: String2,
      StringPrototypeToUpperCase,
      StringPrototypeTrim
    } = require_primordials();
    var {
      hideStackFrames,
      codes: { ERR_SOCKET_BAD_PORT, ERR_INVALID_ARG_TYPE, ERR_INVALID_ARG_VALUE, ERR_OUT_OF_RANGE, ERR_UNKNOWN_SIGNAL }
    } = require_errors();
    var { normalizeEncoding } = require_util2();
    var { isAsyncFunction, isArrayBufferView: isArrayBufferView2 } = require_util2().types;
    var signals = {};
    function isInt32(value) {
      return value === (value | 0);
    }
    __name(isInt32, "isInt32");
    function isUint32(value) {
      return value === value >>> 0;
    }
    __name(isUint32, "isUint32");
    var octalReg = /^[0-7]+$/;
    var modeDesc = "must be a 32-bit unsigned integer or an octal string";
    function parseFileMode(value, name, def) {
      if (typeof value === "undefined") {
        value = def;
      }
      if (typeof value === "string") {
        if (RegExpPrototypeExec(octalReg, value) === null) {
          throw new ERR_INVALID_ARG_VALUE(name, value, modeDesc);
        }
        value = NumberParseInt(value, 8);
      }
      validateUint32(value, name);
      return value;
    }
    __name(parseFileMode, "parseFileMode");
    var validateInteger = hideStackFrames((value, name, min = NumberMIN_SAFE_INTEGER, max = NumberMAX_SAFE_INTEGER) => {
      if (typeof value !== "number") throw new ERR_INVALID_ARG_TYPE(name, "number", value);
      if (!NumberIsInteger(value)) throw new ERR_OUT_OF_RANGE(name, "an integer", value);
      if (value < min || value > max) throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value);
    });
    var validateInt32 = hideStackFrames((value, name, min = -2147483648, max = 2147483647) => {
      if (typeof value !== "number") {
        throw new ERR_INVALID_ARG_TYPE(name, "number", value);
      }
      if (!NumberIsInteger(value)) {
        throw new ERR_OUT_OF_RANGE(name, "an integer", value);
      }
      if (value < min || value > max) {
        throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value);
      }
    });
    var validateUint32 = hideStackFrames((value, name, positive = false) => {
      if (typeof value !== "number") {
        throw new ERR_INVALID_ARG_TYPE(name, "number", value);
      }
      if (!NumberIsInteger(value)) {
        throw new ERR_OUT_OF_RANGE(name, "an integer", value);
      }
      const min = positive ? 1 : 0;
      const max = 4294967295;
      if (value < min || value > max) {
        throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value);
      }
    });
    function validateString(value, name) {
      if (typeof value !== "string") throw new ERR_INVALID_ARG_TYPE(name, "string", value);
    }
    __name(validateString, "validateString");
    function validateNumber(value, name, min = void 0, max) {
      if (typeof value !== "number") throw new ERR_INVALID_ARG_TYPE(name, "number", value);
      if (min != null && value < min || max != null && value > max || (min != null || max != null) && NumberIsNaN(value)) {
        throw new ERR_OUT_OF_RANGE(
          name,
          `${min != null ? `>= ${min}` : ""}${min != null && max != null ? " && " : ""}${max != null ? `<= ${max}` : ""}`,
          value
        );
      }
    }
    __name(validateNumber, "validateNumber");
    var validateOneOf = hideStackFrames((value, name, oneOf) => {
      if (!ArrayPrototypeIncludes(oneOf, value)) {
        const allowed = ArrayPrototypeJoin(
          ArrayPrototypeMap(oneOf, (v14) => typeof v14 === "string" ? `'${v14}'` : String2(v14)),
          ", "
        );
        const reason = "must be one of: " + allowed;
        throw new ERR_INVALID_ARG_VALUE(name, value, reason);
      }
    });
    function validateBoolean(value, name) {
      if (typeof value !== "boolean") throw new ERR_INVALID_ARG_TYPE(name, "boolean", value);
    }
    __name(validateBoolean, "validateBoolean");
    function getOwnPropertyValueOrDefault(options, key, defaultValue2) {
      return options == null || !ObjectPrototypeHasOwnProperty(options, key) ? defaultValue2 : options[key];
    }
    __name(getOwnPropertyValueOrDefault, "getOwnPropertyValueOrDefault");
    var validateObject = hideStackFrames((value, name, options = null) => {
      const allowArray = getOwnPropertyValueOrDefault(options, "allowArray", false);
      const allowFunction = getOwnPropertyValueOrDefault(options, "allowFunction", false);
      const nullable = getOwnPropertyValueOrDefault(options, "nullable", false);
      if (!nullable && value === null || !allowArray && ArrayIsArray(value) || typeof value !== "object" && (!allowFunction || typeof value !== "function")) {
        throw new ERR_INVALID_ARG_TYPE(name, "Object", value);
      }
    });
    var validateDictionary = hideStackFrames((value, name) => {
      if (value != null && typeof value !== "object" && typeof value !== "function") {
        throw new ERR_INVALID_ARG_TYPE(name, "a dictionary", value);
      }
    });
    var validateArray = hideStackFrames((value, name, minLength = 0) => {
      if (!ArrayIsArray(value)) {
        throw new ERR_INVALID_ARG_TYPE(name, "Array", value);
      }
      if (value.length < minLength) {
        const reason = `must be longer than ${minLength}`;
        throw new ERR_INVALID_ARG_VALUE(name, value, reason);
      }
    });
    function validateStringArray(value, name) {
      validateArray(value, name);
      for (let i13 = 0; i13 < value.length; i13++) {
        validateString(value[i13], `${name}[${i13}]`);
      }
    }
    __name(validateStringArray, "validateStringArray");
    function validateBooleanArray(value, name) {
      validateArray(value, name);
      for (let i13 = 0; i13 < value.length; i13++) {
        validateBoolean(value[i13], `${name}[${i13}]`);
      }
    }
    __name(validateBooleanArray, "validateBooleanArray");
    function validateAbortSignalArray(value, name) {
      validateArray(value, name);
      for (let i13 = 0; i13 < value.length; i13++) {
        const signal = value[i13];
        const indexedName = `${name}[${i13}]`;
        if (signal == null) {
          throw new ERR_INVALID_ARG_TYPE(indexedName, "AbortSignal", signal);
        }
        validateAbortSignal(signal, indexedName);
      }
    }
    __name(validateAbortSignalArray, "validateAbortSignalArray");
    function validateSignalName(signal, name = "signal") {
      validateString(signal, name);
      if (signals[signal] === void 0) {
        if (signals[StringPrototypeToUpperCase(signal)] !== void 0) {
          throw new ERR_UNKNOWN_SIGNAL(signal + " (signals must use all capital letters)");
        }
        throw new ERR_UNKNOWN_SIGNAL(signal);
      }
    }
    __name(validateSignalName, "validateSignalName");
    var validateBuffer = hideStackFrames((buffer, name = "buffer") => {
      if (!isArrayBufferView2(buffer)) {
        throw new ERR_INVALID_ARG_TYPE(name, ["Buffer", "TypedArray", "DataView"], buffer);
      }
    });
    function validateEncoding(data3, encoding) {
      const normalizedEncoding = normalizeEncoding(encoding);
      const length = data3.length;
      if (normalizedEncoding === "hex" && length % 2 !== 0) {
        throw new ERR_INVALID_ARG_VALUE("encoding", encoding, `is invalid for data of length ${length}`);
      }
    }
    __name(validateEncoding, "validateEncoding");
    function validatePort(port, name = "Port", allowZero = true) {
      if (typeof port !== "number" && typeof port !== "string" || typeof port === "string" && StringPrototypeTrim(port).length === 0 || +port !== +port >>> 0 || port > 65535 || port === 0 && !allowZero) {
        throw new ERR_SOCKET_BAD_PORT(name, port, allowZero);
      }
      return port | 0;
    }
    __name(validatePort, "validatePort");
    var validateAbortSignal = hideStackFrames((signal, name) => {
      if (signal !== void 0 && (signal === null || typeof signal !== "object" || !("aborted" in signal))) {
        throw new ERR_INVALID_ARG_TYPE(name, "AbortSignal", signal);
      }
    });
    var validateFunction = hideStackFrames((value, name) => {
      if (typeof value !== "function") throw new ERR_INVALID_ARG_TYPE(name, "Function", value);
    });
    var validatePlainFunction = hideStackFrames((value, name) => {
      if (typeof value !== "function" || isAsyncFunction(value)) throw new ERR_INVALID_ARG_TYPE(name, "Function", value);
    });
    var validateUndefined = hideStackFrames((value, name) => {
      if (value !== void 0) throw new ERR_INVALID_ARG_TYPE(name, "undefined", value);
    });
    function validateUnion(value, name, union) {
      if (!ArrayPrototypeIncludes(union, value)) {
        throw new ERR_INVALID_ARG_TYPE(name, `('${ArrayPrototypeJoin(union, "|")}')`, value);
      }
    }
    __name(validateUnion, "validateUnion");
    var linkValueRegExp = /^(?:<[^>]*>)(?:\s*;\s*[^;"\s]+(?:=(")?[^;"\s]*\1)?)*$/;
    function validateLinkHeaderFormat(value, name) {
      if (typeof value === "undefined" || !RegExpPrototypeExec(linkValueRegExp, value)) {
        throw new ERR_INVALID_ARG_VALUE(
          name,
          value,
          'must be an array or string of format "</styles.css>; rel=preload; as=style"'
        );
      }
    }
    __name(validateLinkHeaderFormat, "validateLinkHeaderFormat");
    function validateLinkHeaderValue(hints) {
      if (typeof hints === "string") {
        validateLinkHeaderFormat(hints, "hints");
        return hints;
      } else if (ArrayIsArray(hints)) {
        const hintsLength = hints.length;
        let result2 = "";
        if (hintsLength === 0) {
          return result2;
        }
        for (let i13 = 0; i13 < hintsLength; i13++) {
          const link = hints[i13];
          validateLinkHeaderFormat(link, "hints");
          result2 += link;
          if (i13 !== hintsLength - 1) {
            result2 += ", ";
          }
        }
        return result2;
      }
      throw new ERR_INVALID_ARG_VALUE(
        "hints",
        hints,
        'must be an array or string of format "</styles.css>; rel=preload; as=style"'
      );
    }
    __name(validateLinkHeaderValue, "validateLinkHeaderValue");
    module2.exports = {
      isInt32,
      isUint32,
      parseFileMode,
      validateArray,
      validateStringArray,
      validateBooleanArray,
      validateAbortSignalArray,
      validateBoolean,
      validateBuffer,
      validateDictionary,
      validateEncoding,
      validateFunction,
      validateInt32,
      validateInteger,
      validateNumber,
      validateObject,
      validateOneOf,
      validatePlainFunction,
      validatePort,
      validateSignalName,
      validateString,
      validateUint32,
      validateUndefined,
      validateUnion,
      validateAbortSignal,
      validateLinkHeaderValue
    };
  }
});

// ../../node_modules/process/index.js
var require_process = __commonJS({
  "../../node_modules/process/index.js"(exports2, module2) {
    module2.exports = global.process;
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/utils.js
var require_utils2 = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/utils.js"(exports2, module2) {
    "use strict";
    var { SymbolAsyncIterator, SymbolIterator, SymbolFor } = require_primordials();
    var kIsDestroyed = SymbolFor("nodejs.stream.destroyed");
    var kIsErrored = SymbolFor("nodejs.stream.errored");
    var kIsReadable = SymbolFor("nodejs.stream.readable");
    var kIsWritable = SymbolFor("nodejs.stream.writable");
    var kIsDisturbed = SymbolFor("nodejs.stream.disturbed");
    var kIsClosedPromise = SymbolFor("nodejs.webstream.isClosedPromise");
    var kControllerErrorFunction = SymbolFor("nodejs.webstream.controllerErrorFunction");
    function isReadableNodeStream(obj, strict = false) {
      var _obj$_readableState;
      return !!(obj && typeof obj.pipe === "function" && typeof obj.on === "function" && (!strict || typeof obj.pause === "function" && typeof obj.resume === "function") && (!obj._writableState || ((_obj$_readableState = obj._readableState) === null || _obj$_readableState === void 0 ? void 0 : _obj$_readableState.readable) !== false) && // Duplex
      (!obj._writableState || obj._readableState));
    }
    __name(isReadableNodeStream, "isReadableNodeStream");
    function isWritableNodeStream(obj) {
      var _obj$_writableState;
      return !!(obj && typeof obj.write === "function" && typeof obj.on === "function" && (!obj._readableState || ((_obj$_writableState = obj._writableState) === null || _obj$_writableState === void 0 ? void 0 : _obj$_writableState.writable) !== false));
    }
    __name(isWritableNodeStream, "isWritableNodeStream");
    function isDuplexNodeStream(obj) {
      return !!(obj && typeof obj.pipe === "function" && obj._readableState && typeof obj.on === "function" && typeof obj.write === "function");
    }
    __name(isDuplexNodeStream, "isDuplexNodeStream");
    function isNodeStream(obj) {
      return obj && (obj._readableState || obj._writableState || typeof obj.write === "function" && typeof obj.on === "function" || typeof obj.pipe === "function" && typeof obj.on === "function");
    }
    __name(isNodeStream, "isNodeStream");
    function isReadableStream(obj) {
      return !!(obj && !isNodeStream(obj) && typeof obj.pipeThrough === "function" && typeof obj.getReader === "function" && typeof obj.cancel === "function");
    }
    __name(isReadableStream, "isReadableStream");
    function isWritableStream(obj) {
      return !!(obj && !isNodeStream(obj) && typeof obj.getWriter === "function" && typeof obj.abort === "function");
    }
    __name(isWritableStream, "isWritableStream");
    function isTransformStream(obj) {
      return !!(obj && !isNodeStream(obj) && typeof obj.readable === "object" && typeof obj.writable === "object");
    }
    __name(isTransformStream, "isTransformStream");
    function isWebStream(obj) {
      return isReadableStream(obj) || isWritableStream(obj) || isTransformStream(obj);
    }
    __name(isWebStream, "isWebStream");
    function isIterable(obj, isAsync) {
      if (obj == null) return false;
      if (isAsync === true) return typeof obj[SymbolAsyncIterator] === "function";
      if (isAsync === false) return typeof obj[SymbolIterator] === "function";
      return typeof obj[SymbolAsyncIterator] === "function" || typeof obj[SymbolIterator] === "function";
    }
    __name(isIterable, "isIterable");
    function isDestroyed(stream3) {
      if (!isNodeStream(stream3)) return null;
      const wState = stream3._writableState;
      const rState = stream3._readableState;
      const state5 = wState || rState;
      return !!(stream3.destroyed || stream3[kIsDestroyed] || state5 !== null && state5 !== void 0 && state5.destroyed);
    }
    __name(isDestroyed, "isDestroyed");
    function isWritableEnded(stream3) {
      if (!isWritableNodeStream(stream3)) return null;
      if (stream3.writableEnded === true) return true;
      const wState = stream3._writableState;
      if (wState !== null && wState !== void 0 && wState.errored) return false;
      if (typeof (wState === null || wState === void 0 ? void 0 : wState.ended) !== "boolean") return null;
      return wState.ended;
    }
    __name(isWritableEnded, "isWritableEnded");
    function isWritableFinished(stream3, strict) {
      if (!isWritableNodeStream(stream3)) return null;
      if (stream3.writableFinished === true) return true;
      const wState = stream3._writableState;
      if (wState !== null && wState !== void 0 && wState.errored) return false;
      if (typeof (wState === null || wState === void 0 ? void 0 : wState.finished) !== "boolean") return null;
      return !!(wState.finished || strict === false && wState.ended === true && wState.length === 0);
    }
    __name(isWritableFinished, "isWritableFinished");
    function isReadableEnded(stream3) {
      if (!isReadableNodeStream(stream3)) return null;
      if (stream3.readableEnded === true) return true;
      const rState = stream3._readableState;
      if (!rState || rState.errored) return false;
      if (typeof (rState === null || rState === void 0 ? void 0 : rState.ended) !== "boolean") return null;
      return rState.ended;
    }
    __name(isReadableEnded, "isReadableEnded");
    function isReadableFinished(stream3, strict) {
      if (!isReadableNodeStream(stream3)) return null;
      const rState = stream3._readableState;
      if (rState !== null && rState !== void 0 && rState.errored) return false;
      if (typeof (rState === null || rState === void 0 ? void 0 : rState.endEmitted) !== "boolean") return null;
      return !!(rState.endEmitted || strict === false && rState.ended === true && rState.length === 0);
    }
    __name(isReadableFinished, "isReadableFinished");
    function isReadable2(stream3) {
      if (stream3 && stream3[kIsReadable] != null) return stream3[kIsReadable];
      if (typeof (stream3 === null || stream3 === void 0 ? void 0 : stream3.readable) !== "boolean") return null;
      if (isDestroyed(stream3)) return false;
      return isReadableNodeStream(stream3) && stream3.readable && !isReadableFinished(stream3);
    }
    __name(isReadable2, "isReadable");
    function isWritable2(stream3) {
      if (stream3 && stream3[kIsWritable] != null) return stream3[kIsWritable];
      if (typeof (stream3 === null || stream3 === void 0 ? void 0 : stream3.writable) !== "boolean") return null;
      if (isDestroyed(stream3)) return false;
      return isWritableNodeStream(stream3) && stream3.writable && !isWritableEnded(stream3);
    }
    __name(isWritable2, "isWritable");
    function isFinished(stream3, opts) {
      if (!isNodeStream(stream3)) {
        return null;
      }
      if (isDestroyed(stream3)) {
        return true;
      }
      if ((opts === null || opts === void 0 ? void 0 : opts.readable) !== false && isReadable2(stream3)) {
        return false;
      }
      if ((opts === null || opts === void 0 ? void 0 : opts.writable) !== false && isWritable2(stream3)) {
        return false;
      }
      return true;
    }
    __name(isFinished, "isFinished");
    function isWritableErrored(stream3) {
      var _stream$_writableStat, _stream$_writableStat2;
      if (!isNodeStream(stream3)) {
        return null;
      }
      if (stream3.writableErrored) {
        return stream3.writableErrored;
      }
      return (_stream$_writableStat = (_stream$_writableStat2 = stream3._writableState) === null || _stream$_writableStat2 === void 0 ? void 0 : _stream$_writableStat2.errored) !== null && _stream$_writableStat !== void 0 ? _stream$_writableStat : null;
    }
    __name(isWritableErrored, "isWritableErrored");
    function isReadableErrored(stream3) {
      var _stream$_readableStat, _stream$_readableStat2;
      if (!isNodeStream(stream3)) {
        return null;
      }
      if (stream3.readableErrored) {
        return stream3.readableErrored;
      }
      return (_stream$_readableStat = (_stream$_readableStat2 = stream3._readableState) === null || _stream$_readableStat2 === void 0 ? void 0 : _stream$_readableStat2.errored) !== null && _stream$_readableStat !== void 0 ? _stream$_readableStat : null;
    }
    __name(isReadableErrored, "isReadableErrored");
    function isClosed(stream3) {
      if (!isNodeStream(stream3)) {
        return null;
      }
      if (typeof stream3.closed === "boolean") {
        return stream3.closed;
      }
      const wState = stream3._writableState;
      const rState = stream3._readableState;
      if (typeof (wState === null || wState === void 0 ? void 0 : wState.closed) === "boolean" || typeof (rState === null || rState === void 0 ? void 0 : rState.closed) === "boolean") {
        return (wState === null || wState === void 0 ? void 0 : wState.closed) || (rState === null || rState === void 0 ? void 0 : rState.closed);
      }
      if (typeof stream3._closed === "boolean" && isOutgoingMessage(stream3)) {
        return stream3._closed;
      }
      return null;
    }
    __name(isClosed, "isClosed");
    function isOutgoingMessage(stream3) {
      return typeof stream3._closed === "boolean" && typeof stream3._defaultKeepAlive === "boolean" && typeof stream3._removedConnection === "boolean" && typeof stream3._removedContLen === "boolean";
    }
    __name(isOutgoingMessage, "isOutgoingMessage");
    function isServerResponse(stream3) {
      return typeof stream3._sent100 === "boolean" && isOutgoingMessage(stream3);
    }
    __name(isServerResponse, "isServerResponse");
    function isServerRequest(stream3) {
      var _stream$req;
      return typeof stream3._consuming === "boolean" && typeof stream3._dumped === "boolean" && ((_stream$req = stream3.req) === null || _stream$req === void 0 ? void 0 : _stream$req.upgradeOrConnect) === void 0;
    }
    __name(isServerRequest, "isServerRequest");
    function willEmitClose(stream3) {
      if (!isNodeStream(stream3)) return null;
      const wState = stream3._writableState;
      const rState = stream3._readableState;
      const state5 = wState || rState;
      return !state5 && isServerResponse(stream3) || !!(state5 && state5.autoDestroy && state5.emitClose && state5.closed === false);
    }
    __name(willEmitClose, "willEmitClose");
    function isDisturbed(stream3) {
      var _stream$kIsDisturbed;
      return !!(stream3 && ((_stream$kIsDisturbed = stream3[kIsDisturbed]) !== null && _stream$kIsDisturbed !== void 0 ? _stream$kIsDisturbed : stream3.readableDidRead || stream3.readableAborted));
    }
    __name(isDisturbed, "isDisturbed");
    function isErrored(stream3) {
      var _ref, _ref2, _ref3, _ref4, _ref5, _stream$kIsErrored, _stream$_readableStat3, _stream$_writableStat3, _stream$_readableStat4, _stream$_writableStat4;
      return !!(stream3 && ((_ref = (_ref2 = (_ref3 = (_ref4 = (_ref5 = (_stream$kIsErrored = stream3[kIsErrored]) !== null && _stream$kIsErrored !== void 0 ? _stream$kIsErrored : stream3.readableErrored) !== null && _ref5 !== void 0 ? _ref5 : stream3.writableErrored) !== null && _ref4 !== void 0 ? _ref4 : (_stream$_readableStat3 = stream3._readableState) === null || _stream$_readableStat3 === void 0 ? void 0 : _stream$_readableStat3.errorEmitted) !== null && _ref3 !== void 0 ? _ref3 : (_stream$_writableStat3 = stream3._writableState) === null || _stream$_writableStat3 === void 0 ? void 0 : _stream$_writableStat3.errorEmitted) !== null && _ref2 !== void 0 ? _ref2 : (_stream$_readableStat4 = stream3._readableState) === null || _stream$_readableStat4 === void 0 ? void 0 : _stream$_readableStat4.errored) !== null && _ref !== void 0 ? _ref : (_stream$_writableStat4 = stream3._writableState) === null || _stream$_writableStat4 === void 0 ? void 0 : _stream$_writableStat4.errored));
    }
    __name(isErrored, "isErrored");
    module2.exports = {
      isDestroyed,
      kIsDestroyed,
      isDisturbed,
      kIsDisturbed,
      isErrored,
      kIsErrored,
      isReadable: isReadable2,
      kIsReadable,
      kIsClosedPromise,
      kControllerErrorFunction,
      kIsWritable,
      isClosed,
      isDuplexNodeStream,
      isFinished,
      isIterable,
      isReadableNodeStream,
      isReadableStream,
      isReadableEnded,
      isReadableFinished,
      isReadableErrored,
      isNodeStream,
      isWebStream,
      isWritable: isWritable2,
      isWritableNodeStream,
      isWritableStream,
      isWritableEnded,
      isWritableFinished,
      isWritableErrored,
      isServerRequest,
      isServerResponse,
      willEmitClose,
      isTransformStream
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/end-of-stream.js
var require_end_of_stream = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/end-of-stream.js"(exports2, module2) {
    "use strict";
    var process3 = require_process();
    var { AbortError, codes } = require_errors();
    var { ERR_INVALID_ARG_TYPE, ERR_STREAM_PREMATURE_CLOSE } = codes;
    var { kEmptyObject, once } = require_util2();
    var { validateAbortSignal, validateFunction, validateObject, validateBoolean } = require_validators();
    var { Promise: Promise2, PromisePrototypeThen, SymbolDispose } = require_primordials();
    var {
      isClosed,
      isReadable: isReadable2,
      isReadableNodeStream,
      isReadableStream,
      isReadableFinished,
      isReadableErrored,
      isWritable: isWritable2,
      isWritableNodeStream,
      isWritableStream,
      isWritableFinished,
      isWritableErrored,
      isNodeStream,
      willEmitClose: _willEmitClose,
      kIsClosedPromise
    } = require_utils2();
    var addAbortListener;
    function isRequest(stream3) {
      return stream3.setHeader && typeof stream3.abort === "function";
    }
    __name(isRequest, "isRequest");
    var nop = /* @__PURE__ */ __name(() => {
    }, "nop");
    function eos(stream3, options, callback) {
      var _options$readable, _options$writable;
      if (arguments.length === 2) {
        callback = options;
        options = kEmptyObject;
      } else if (options == null) {
        options = kEmptyObject;
      } else {
        validateObject(options, "options");
      }
      validateFunction(callback, "callback");
      validateAbortSignal(options.signal, "options.signal");
      callback = once(callback);
      if (isReadableStream(stream3) || isWritableStream(stream3)) {
        return eosWeb(stream3, options, callback);
      }
      if (!isNodeStream(stream3)) {
        throw new ERR_INVALID_ARG_TYPE("stream", ["ReadableStream", "WritableStream", "Stream"], stream3);
      }
      const readable = (_options$readable = options.readable) !== null && _options$readable !== void 0 ? _options$readable : isReadableNodeStream(stream3);
      const writable = (_options$writable = options.writable) !== null && _options$writable !== void 0 ? _options$writable : isWritableNodeStream(stream3);
      const wState = stream3._writableState;
      const rState = stream3._readableState;
      const onlegacyfinish = /* @__PURE__ */ __name(() => {
        if (!stream3.writable) {
          onfinish();
        }
      }, "onlegacyfinish");
      let willEmitClose = _willEmitClose(stream3) && isReadableNodeStream(stream3) === readable && isWritableNodeStream(stream3) === writable;
      let writableFinished = isWritableFinished(stream3, false);
      const onfinish = /* @__PURE__ */ __name(() => {
        writableFinished = true;
        if (stream3.destroyed) {
          willEmitClose = false;
        }
        if (willEmitClose && (!stream3.readable || readable)) {
          return;
        }
        if (!readable || readableFinished) {
          callback.call(stream3);
        }
      }, "onfinish");
      let readableFinished = isReadableFinished(stream3, false);
      const onend = /* @__PURE__ */ __name(() => {
        readableFinished = true;
        if (stream3.destroyed) {
          willEmitClose = false;
        }
        if (willEmitClose && (!stream3.writable || writable)) {
          return;
        }
        if (!writable || writableFinished) {
          callback.call(stream3);
        }
      }, "onend");
      const onerror = /* @__PURE__ */ __name((err) => {
        callback.call(stream3, err);
      }, "onerror");
      let closed = isClosed(stream3);
      const onclose = /* @__PURE__ */ __name(() => {
        closed = true;
        const errored = isWritableErrored(stream3) || isReadableErrored(stream3);
        if (errored && typeof errored !== "boolean") {
          return callback.call(stream3, errored);
        }
        if (readable && !readableFinished && isReadableNodeStream(stream3, true)) {
          if (!isReadableFinished(stream3, false)) return callback.call(stream3, new ERR_STREAM_PREMATURE_CLOSE());
        }
        if (writable && !writableFinished) {
          if (!isWritableFinished(stream3, false)) return callback.call(stream3, new ERR_STREAM_PREMATURE_CLOSE());
        }
        callback.call(stream3);
      }, "onclose");
      const onclosed = /* @__PURE__ */ __name(() => {
        closed = true;
        const errored = isWritableErrored(stream3) || isReadableErrored(stream3);
        if (errored && typeof errored !== "boolean") {
          return callback.call(stream3, errored);
        }
        callback.call(stream3);
      }, "onclosed");
      const onrequest = /* @__PURE__ */ __name(() => {
        stream3.req.on("finish", onfinish);
      }, "onrequest");
      if (isRequest(stream3)) {
        stream3.on("complete", onfinish);
        if (!willEmitClose) {
          stream3.on("abort", onclose);
        }
        if (stream3.req) {
          onrequest();
        } else {
          stream3.on("request", onrequest);
        }
      } else if (writable && !wState) {
        stream3.on("end", onlegacyfinish);
        stream3.on("close", onlegacyfinish);
      }
      if (!willEmitClose && typeof stream3.aborted === "boolean") {
        stream3.on("aborted", onclose);
      }
      stream3.on("end", onend);
      stream3.on("finish", onfinish);
      if (options.error !== false) {
        stream3.on("error", onerror);
      }
      stream3.on("close", onclose);
      if (closed) {
        process3.nextTick(onclose);
      } else if (wState !== null && wState !== void 0 && wState.errorEmitted || rState !== null && rState !== void 0 && rState.errorEmitted) {
        if (!willEmitClose) {
          process3.nextTick(onclosed);
        }
      } else if (!readable && (!willEmitClose || isReadable2(stream3)) && (writableFinished || isWritable2(stream3) === false)) {
        process3.nextTick(onclosed);
      } else if (!writable && (!willEmitClose || isWritable2(stream3)) && (readableFinished || isReadable2(stream3) === false)) {
        process3.nextTick(onclosed);
      } else if (rState && stream3.req && stream3.aborted) {
        process3.nextTick(onclosed);
      }
      const cleanup = /* @__PURE__ */ __name(() => {
        callback = nop;
        stream3.removeListener("aborted", onclose);
        stream3.removeListener("complete", onfinish);
        stream3.removeListener("abort", onclose);
        stream3.removeListener("request", onrequest);
        if (stream3.req) stream3.req.removeListener("finish", onfinish);
        stream3.removeListener("end", onlegacyfinish);
        stream3.removeListener("close", onlegacyfinish);
        stream3.removeListener("finish", onfinish);
        stream3.removeListener("end", onend);
        stream3.removeListener("error", onerror);
        stream3.removeListener("close", onclose);
      }, "cleanup");
      if (options.signal && !closed) {
        const abort = /* @__PURE__ */ __name(() => {
          const endCallback = callback;
          cleanup();
          endCallback.call(
            stream3,
            new AbortError(void 0, {
              cause: options.signal.reason
            })
          );
        }, "abort");
        if (options.signal.aborted) {
          process3.nextTick(abort);
        } else {
          addAbortListener = addAbortListener || require_util2().addAbortListener;
          const disposable = addAbortListener(options.signal, abort);
          const originalCallback = callback;
          callback = once((...args) => {
            disposable[SymbolDispose]();
            originalCallback.apply(stream3, args);
          });
        }
      }
      return cleanup;
    }
    __name(eos, "eos");
    function eosWeb(stream3, options, callback) {
      let isAborted = false;
      let abort = nop;
      if (options.signal) {
        abort = /* @__PURE__ */ __name(() => {
          isAborted = true;
          callback.call(
            stream3,
            new AbortError(void 0, {
              cause: options.signal.reason
            })
          );
        }, "abort");
        if (options.signal.aborted) {
          process3.nextTick(abort);
        } else {
          addAbortListener = addAbortListener || require_util2().addAbortListener;
          const disposable = addAbortListener(options.signal, abort);
          const originalCallback = callback;
          callback = once((...args) => {
            disposable[SymbolDispose]();
            originalCallback.apply(stream3, args);
          });
        }
      }
      const resolverFn = /* @__PURE__ */ __name((...args) => {
        if (!isAborted) {
          process3.nextTick(() => callback.apply(stream3, args));
        }
      }, "resolverFn");
      PromisePrototypeThen(stream3[kIsClosedPromise].promise, resolverFn, resolverFn);
      return nop;
    }
    __name(eosWeb, "eosWeb");
    function finished(stream3, opts) {
      var _opts;
      let autoCleanup = false;
      if (opts === null) {
        opts = kEmptyObject;
      }
      if ((_opts = opts) !== null && _opts !== void 0 && _opts.cleanup) {
        validateBoolean(opts.cleanup, "cleanup");
        autoCleanup = opts.cleanup;
      }
      return new Promise2((resolve16, reject) => {
        const cleanup = eos(stream3, opts, (err) => {
          if (autoCleanup) {
            cleanup();
          }
          if (err) {
            reject(err);
          } else {
            resolve16();
          }
        });
      });
    }
    __name(finished, "finished");
    module2.exports = eos;
    module2.exports.finished = finished;
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/destroy.js
var require_destroy2 = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/destroy.js"(exports2, module2) {
    "use strict";
    var process3 = require_process();
    var {
      aggregateTwoErrors,
      codes: { ERR_MULTIPLE_CALLBACK },
      AbortError
    } = require_errors();
    var { Symbol: Symbol2 } = require_primordials();
    var { kIsDestroyed, isDestroyed, isFinished, isServerRequest } = require_utils2();
    var kDestroy = Symbol2("kDestroy");
    var kConstruct = Symbol2("kConstruct");
    function checkError(err, w13, r13) {
      if (err) {
        err.stack;
        if (w13 && !w13.errored) {
          w13.errored = err;
        }
        if (r13 && !r13.errored) {
          r13.errored = err;
        }
      }
    }
    __name(checkError, "checkError");
    function destroy(err, cb) {
      const r13 = this._readableState;
      const w13 = this._writableState;
      const s13 = w13 || r13;
      if (w13 !== null && w13 !== void 0 && w13.destroyed || r13 !== null && r13 !== void 0 && r13.destroyed) {
        if (typeof cb === "function") {
          cb();
        }
        return this;
      }
      checkError(err, w13, r13);
      if (w13) {
        w13.destroyed = true;
      }
      if (r13) {
        r13.destroyed = true;
      }
      if (!s13.constructed) {
        this.once(kDestroy, function(er) {
          _destroy(this, aggregateTwoErrors(er, err), cb);
        });
      } else {
        _destroy(this, err, cb);
      }
      return this;
    }
    __name(destroy, "destroy");
    function _destroy(self2, err, cb) {
      let called = false;
      function onDestroy(err2) {
        if (called) {
          return;
        }
        called = true;
        const r13 = self2._readableState;
        const w13 = self2._writableState;
        checkError(err2, w13, r13);
        if (w13) {
          w13.closed = true;
        }
        if (r13) {
          r13.closed = true;
        }
        if (typeof cb === "function") {
          cb(err2);
        }
        if (err2) {
          process3.nextTick(emitErrorCloseNT, self2, err2);
        } else {
          process3.nextTick(emitCloseNT, self2);
        }
      }
      __name(onDestroy, "onDestroy");
      try {
        self2._destroy(err || null, onDestroy);
      } catch (err2) {
        onDestroy(err2);
      }
    }
    __name(_destroy, "_destroy");
    function emitErrorCloseNT(self2, err) {
      emitErrorNT(self2, err);
      emitCloseNT(self2);
    }
    __name(emitErrorCloseNT, "emitErrorCloseNT");
    function emitCloseNT(self2) {
      const r13 = self2._readableState;
      const w13 = self2._writableState;
      if (w13) {
        w13.closeEmitted = true;
      }
      if (r13) {
        r13.closeEmitted = true;
      }
      if (w13 !== null && w13 !== void 0 && w13.emitClose || r13 !== null && r13 !== void 0 && r13.emitClose) {
        self2.emit("close");
      }
    }
    __name(emitCloseNT, "emitCloseNT");
    function emitErrorNT(self2, err) {
      const r13 = self2._readableState;
      const w13 = self2._writableState;
      if (w13 !== null && w13 !== void 0 && w13.errorEmitted || r13 !== null && r13 !== void 0 && r13.errorEmitted) {
        return;
      }
      if (w13) {
        w13.errorEmitted = true;
      }
      if (r13) {
        r13.errorEmitted = true;
      }
      self2.emit("error", err);
    }
    __name(emitErrorNT, "emitErrorNT");
    function undestroy() {
      const r13 = this._readableState;
      const w13 = this._writableState;
      if (r13) {
        r13.constructed = true;
        r13.closed = false;
        r13.closeEmitted = false;
        r13.destroyed = false;
        r13.errored = null;
        r13.errorEmitted = false;
        r13.reading = false;
        r13.ended = r13.readable === false;
        r13.endEmitted = r13.readable === false;
      }
      if (w13) {
        w13.constructed = true;
        w13.destroyed = false;
        w13.closed = false;
        w13.closeEmitted = false;
        w13.errored = null;
        w13.errorEmitted = false;
        w13.finalCalled = false;
        w13.prefinished = false;
        w13.ended = w13.writable === false;
        w13.ending = w13.writable === false;
        w13.finished = w13.writable === false;
      }
    }
    __name(undestroy, "undestroy");
    function errorOrDestroy(stream3, err, sync2) {
      const r13 = stream3._readableState;
      const w13 = stream3._writableState;
      if (w13 !== null && w13 !== void 0 && w13.destroyed || r13 !== null && r13 !== void 0 && r13.destroyed) {
        return this;
      }
      if (r13 !== null && r13 !== void 0 && r13.autoDestroy || w13 !== null && w13 !== void 0 && w13.autoDestroy)
        stream3.destroy(err);
      else if (err) {
        err.stack;
        if (w13 && !w13.errored) {
          w13.errored = err;
        }
        if (r13 && !r13.errored) {
          r13.errored = err;
        }
        if (sync2) {
          process3.nextTick(emitErrorNT, stream3, err);
        } else {
          emitErrorNT(stream3, err);
        }
      }
    }
    __name(errorOrDestroy, "errorOrDestroy");
    function construct(stream3, cb) {
      if (typeof stream3._construct !== "function") {
        return;
      }
      const r13 = stream3._readableState;
      const w13 = stream3._writableState;
      if (r13) {
        r13.constructed = false;
      }
      if (w13) {
        w13.constructed = false;
      }
      stream3.once(kConstruct, cb);
      if (stream3.listenerCount(kConstruct) > 1) {
        return;
      }
      process3.nextTick(constructNT, stream3);
    }
    __name(construct, "construct");
    function constructNT(stream3) {
      let called = false;
      function onConstruct(err) {
        if (called) {
          errorOrDestroy(stream3, err !== null && err !== void 0 ? err : new ERR_MULTIPLE_CALLBACK());
          return;
        }
        called = true;
        const r13 = stream3._readableState;
        const w13 = stream3._writableState;
        const s13 = w13 || r13;
        if (r13) {
          r13.constructed = true;
        }
        if (w13) {
          w13.constructed = true;
        }
        if (s13.destroyed) {
          stream3.emit(kDestroy, err);
        } else if (err) {
          errorOrDestroy(stream3, err, true);
        } else {
          process3.nextTick(emitConstructNT, stream3);
        }
      }
      __name(onConstruct, "onConstruct");
      try {
        stream3._construct((err) => {
          process3.nextTick(onConstruct, err);
        });
      } catch (err) {
        process3.nextTick(onConstruct, err);
      }
    }
    __name(constructNT, "constructNT");
    function emitConstructNT(stream3) {
      stream3.emit(kConstruct);
    }
    __name(emitConstructNT, "emitConstructNT");
    function isRequest(stream3) {
      return (stream3 === null || stream3 === void 0 ? void 0 : stream3.setHeader) && typeof stream3.abort === "function";
    }
    __name(isRequest, "isRequest");
    function emitCloseLegacy(stream3) {
      stream3.emit("close");
    }
    __name(emitCloseLegacy, "emitCloseLegacy");
    function emitErrorCloseLegacy(stream3, err) {
      stream3.emit("error", err);
      process3.nextTick(emitCloseLegacy, stream3);
    }
    __name(emitErrorCloseLegacy, "emitErrorCloseLegacy");
    function destroyer(stream3, err) {
      if (!stream3 || isDestroyed(stream3)) {
        return;
      }
      if (!err && !isFinished(stream3)) {
        err = new AbortError();
      }
      if (isServerRequest(stream3)) {
        stream3.socket = null;
        stream3.destroy(err);
      } else if (isRequest(stream3)) {
        stream3.abort();
      } else if (isRequest(stream3.req)) {
        stream3.req.abort();
      } else if (typeof stream3.destroy === "function") {
        stream3.destroy(err);
      } else if (typeof stream3.close === "function") {
        stream3.close();
      } else if (err) {
        process3.nextTick(emitErrorCloseLegacy, stream3, err);
      } else {
        process3.nextTick(emitCloseLegacy, stream3);
      }
      if (!stream3.destroyed) {
        stream3[kIsDestroyed] = true;
      }
    }
    __name(destroyer, "destroyer");
    module2.exports = {
      construct,
      destroyer,
      destroy,
      undestroy,
      errorOrDestroy
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/legacy.js
var require_legacy = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/legacy.js"(exports2, module2) {
    "use strict";
    var { ArrayIsArray, ObjectSetPrototypeOf } = require_primordials();
    var { EventEmitter: EE } = require("events");
    function Stream2(opts) {
      EE.call(this, opts);
    }
    __name(Stream2, "Stream");
    ObjectSetPrototypeOf(Stream2.prototype, EE.prototype);
    ObjectSetPrototypeOf(Stream2, EE);
    Stream2.prototype.pipe = function(dest, options) {
      const source = this;
      function ondata(chunk) {
        if (dest.writable && dest.write(chunk) === false && source.pause) {
          source.pause();
        }
      }
      __name(ondata, "ondata");
      source.on("data", ondata);
      function ondrain() {
        if (source.readable && source.resume) {
          source.resume();
        }
      }
      __name(ondrain, "ondrain");
      dest.on("drain", ondrain);
      if (!dest._isStdio && (!options || options.end !== false)) {
        source.on("end", onend);
        source.on("close", onclose);
      }
      let didOnEnd = false;
      function onend() {
        if (didOnEnd) return;
        didOnEnd = true;
        dest.end();
      }
      __name(onend, "onend");
      function onclose() {
        if (didOnEnd) return;
        didOnEnd = true;
        if (typeof dest.destroy === "function") dest.destroy();
      }
      __name(onclose, "onclose");
      function onerror(er) {
        cleanup();
        if (EE.listenerCount(this, "error") === 0) {
          this.emit("error", er);
        }
      }
      __name(onerror, "onerror");
      prependListener(source, "error", onerror);
      prependListener(dest, "error", onerror);
      function cleanup() {
        source.removeListener("data", ondata);
        dest.removeListener("drain", ondrain);
        source.removeListener("end", onend);
        source.removeListener("close", onclose);
        source.removeListener("error", onerror);
        dest.removeListener("error", onerror);
        source.removeListener("end", cleanup);
        source.removeListener("close", cleanup);
        dest.removeListener("close", cleanup);
      }
      __name(cleanup, "cleanup");
      source.on("end", cleanup);
      source.on("close", cleanup);
      dest.on("close", cleanup);
      dest.emit("pipe", source);
      return dest;
    };
    function prependListener(emitter, event, fn) {
      if (typeof emitter.prependListener === "function") return emitter.prependListener(event, fn);
      if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
      else if (ArrayIsArray(emitter._events[event])) emitter._events[event].unshift(fn);
      else emitter._events[event] = [fn, emitter._events[event]];
    }
    __name(prependListener, "prependListener");
    module2.exports = {
      Stream: Stream2,
      prependListener
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/add-abort-signal.js
var require_add_abort_signal = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/add-abort-signal.js"(exports2, module2) {
    "use strict";
    var { SymbolDispose } = require_primordials();
    var { AbortError, codes } = require_errors();
    var { isNodeStream, isWebStream, kControllerErrorFunction } = require_utils2();
    var eos = require_end_of_stream();
    var { ERR_INVALID_ARG_TYPE } = codes;
    var addAbortListener;
    var validateAbortSignal = /* @__PURE__ */ __name((signal, name) => {
      if (typeof signal !== "object" || !("aborted" in signal)) {
        throw new ERR_INVALID_ARG_TYPE(name, "AbortSignal", signal);
      }
    }, "validateAbortSignal");
    module2.exports.addAbortSignal = /* @__PURE__ */ __name(function addAbortSignal(signal, stream3) {
      validateAbortSignal(signal, "signal");
      if (!isNodeStream(stream3) && !isWebStream(stream3)) {
        throw new ERR_INVALID_ARG_TYPE("stream", ["ReadableStream", "WritableStream", "Stream"], stream3);
      }
      return module2.exports.addAbortSignalNoValidate(signal, stream3);
    }, "addAbortSignal");
    module2.exports.addAbortSignalNoValidate = function(signal, stream3) {
      if (typeof signal !== "object" || !("aborted" in signal)) {
        return stream3;
      }
      const onAbort = isNodeStream(stream3) ? () => {
        stream3.destroy(
          new AbortError(void 0, {
            cause: signal.reason
          })
        );
      } : () => {
        stream3[kControllerErrorFunction](
          new AbortError(void 0, {
            cause: signal.reason
          })
        );
      };
      if (signal.aborted) {
        onAbort();
      } else {
        addAbortListener = addAbortListener || require_util2().addAbortListener;
        const disposable = addAbortListener(signal, onAbort);
        eos(stream3, disposable[SymbolDispose]);
      }
      return stream3;
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/buffer_list.js
var require_buffer_list = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/buffer_list.js"(exports2, module2) {
    "use strict";
    var { StringPrototypeSlice, SymbolIterator, TypedArrayPrototypeSet, Uint8Array: Uint8Array2 } = require_primordials();
    var { Buffer: Buffer2 } = require("buffer");
    var { inspect: inspect4 } = require_util2();
    module2.exports = class BufferList {
      static {
        __name(this, "BufferList");
      }
      constructor() {
        this.head = null;
        this.tail = null;
        this.length = 0;
      }
      push(v14) {
        const entry = {
          data: v14,
          next: null
        };
        if (this.length > 0) this.tail.next = entry;
        else this.head = entry;
        this.tail = entry;
        ++this.length;
      }
      unshift(v14) {
        const entry = {
          data: v14,
          next: this.head
        };
        if (this.length === 0) this.tail = entry;
        this.head = entry;
        ++this.length;
      }
      shift() {
        if (this.length === 0) return;
        const ret = this.head.data;
        if (this.length === 1) this.head = this.tail = null;
        else this.head = this.head.next;
        --this.length;
        return ret;
      }
      clear() {
        this.head = this.tail = null;
        this.length = 0;
      }
      join(s13) {
        if (this.length === 0) return "";
        let p13 = this.head;
        let ret = "" + p13.data;
        while ((p13 = p13.next) !== null) ret += s13 + p13.data;
        return ret;
      }
      concat(n13) {
        if (this.length === 0) return Buffer2.alloc(0);
        const ret = Buffer2.allocUnsafe(n13 >>> 0);
        let p13 = this.head;
        let i13 = 0;
        while (p13) {
          TypedArrayPrototypeSet(ret, p13.data, i13);
          i13 += p13.data.length;
          p13 = p13.next;
        }
        return ret;
      }
      // Consumes a specified amount of bytes or characters from the buffered data.
      consume(n13, hasStrings) {
        const data3 = this.head.data;
        if (n13 < data3.length) {
          const slice = data3.slice(0, n13);
          this.head.data = data3.slice(n13);
          return slice;
        }
        if (n13 === data3.length) {
          return this.shift();
        }
        return hasStrings ? this._getString(n13) : this._getBuffer(n13);
      }
      first() {
        return this.head.data;
      }
      *[SymbolIterator]() {
        for (let p13 = this.head; p13; p13 = p13.next) {
          yield p13.data;
        }
      }
      // Consumes a specified amount of characters from the buffered data.
      _getString(n13) {
        let ret = "";
        let p13 = this.head;
        let c13 = 0;
        do {
          const str = p13.data;
          if (n13 > str.length) {
            ret += str;
            n13 -= str.length;
          } else {
            if (n13 === str.length) {
              ret += str;
              ++c13;
              if (p13.next) this.head = p13.next;
              else this.head = this.tail = null;
            } else {
              ret += StringPrototypeSlice(str, 0, n13);
              this.head = p13;
              p13.data = StringPrototypeSlice(str, n13);
            }
            break;
          }
          ++c13;
        } while ((p13 = p13.next) !== null);
        this.length -= c13;
        return ret;
      }
      // Consumes a specified amount of bytes from the buffered data.
      _getBuffer(n13) {
        const ret = Buffer2.allocUnsafe(n13);
        const retLen = n13;
        let p13 = this.head;
        let c13 = 0;
        do {
          const buf = p13.data;
          if (n13 > buf.length) {
            TypedArrayPrototypeSet(ret, buf, retLen - n13);
            n13 -= buf.length;
          } else {
            if (n13 === buf.length) {
              TypedArrayPrototypeSet(ret, buf, retLen - n13);
              ++c13;
              if (p13.next) this.head = p13.next;
              else this.head = this.tail = null;
            } else {
              TypedArrayPrototypeSet(ret, new Uint8Array2(buf.buffer, buf.byteOffset, n13), retLen - n13);
              this.head = p13;
              p13.data = buf.slice(n13);
            }
            break;
          }
          ++c13;
        } while ((p13 = p13.next) !== null);
        this.length -= c13;
        return ret;
      }
      // Make sure the linked list only shows the minimal necessary information.
      [/* @__PURE__ */ Symbol.for("nodejs.util.inspect.custom")](_2, options) {
        return inspect4(this, {
          ...options,
          // Only inspect one level.
          depth: 0,
          // It should not recurse.
          customInspect: false
        });
      }
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/state.js
var require_state = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/internal/streams/state.js"(exports2, module2) {
    "use strict";
    var { MathFloor, NumberIsInteger } = require_primordials();
    var { validateInteger } = require_validators();
    var { ERR_INVALID_ARG_VALUE } = require_errors().codes;
    var defaultHighWaterMarkBytes = 16 * 1024;
    var defaultHighWaterMarkObjectMode = 16;
    function highWaterMarkFrom(options, isDuplex, duplexKey) {
      return options.highWaterMark != null ? options.highWaterMark : isDuplex ? options[duplexKey] : null;
    }
    __name(highWaterMarkFrom, "highWaterMarkFrom");
    function getDefaultHighWaterMark(objectMode) {
      return objectMode ? defaultHighWaterMarkObjectMode : defaultHighWaterMarkBytes;
    }
    __name(getDefaultHighWaterMark, "getDefaultHighWaterMark");
    function setDefaultHighWaterMark(objectMode, value) {
      validateInteger(value, "value", 0);
      if (objectMode) {
        defaultHighWaterMarkObjectMode = value;
      } else {
        defaultHighWaterMarkBytes = value;
      }
    }
    __name(setDefaultHighWaterMark, "setDefaultHighWaterMark");
    function getHighWaterMark(state5, options, duplexKey, isDuplex) {
      const hwm = highWaterMarkFrom(options, isDuplex, duplexKey);
      if (hwm != null) {
        if (!NumberIsInteger(hwm) || hwm < 0) {
          const name = isDuplex ? `options.${duplexKey}` : "options.highWaterMark";
          throw new ERR_INVALID_ARG_VALUE(name, hwm);
        }
        return MathFloor(hwm);
      }
      return getDefaultHighWaterMark(state5.objectMode);
    }
    __name(getHighWaterMark, "getHighWaterMark");
    module2.exports = {
      getHighWaterMark,
      getDefaultHighWaterMark,
      setDefaultHighWaterMark
    };
  }
});

// ../../node_modules/safe-buffer/index.js
var require_safe_buffer2 = __commonJS({
  "../../node_modules/safe-buffer/index.js"(exports2, module2) {
    var buffer = require("buffer");
    var Buffer2 = buffer.Buffer;
    function copyProps(src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    __name(copyProps, "copyProps");
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer;
    } else {
      copyProps(buffer, exports2);
      exports2.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    __name(SafeBuffer, "SafeBuffer");
    SafeBuffer.prototype = Object.create(Buffer2.prototype);
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer.SlowBuffer(size);
    };
  }
});

// ../../node_modules/string_decoder/lib/string_decoder.js
var require_string_decoder2 = __commonJS({
  "../../node_modules/string_decoder/lib/string_decoder.js"(exports2) {
    "use strict";
    var Buffer2 = require_safe_buffer2().Buffer;
    var isEncoding = Buffer2.isEncoding || function(encoding) {
      encoding = "" + encoding;
      switch (encoding && encoding.toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
        case "raw":
          return true;
        default:
          return false;
      }
    };
    function _normalizeEncoding(enc) {
      if (!enc) return "utf8";
      var retried;
      while (true) {
        switch (enc) {
          case "utf8":
          case "utf-8":
            return "utf8";
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return "utf16le";
          case "latin1":
          case "binary":
            return "latin1";
          case "base64":
          case "ascii":
          case "hex":
            return enc;
          default:
            if (retried) return;
            enc = ("" + enc).toLowerCase();
            retried = true;
        }
      }
    }
    __name(_normalizeEncoding, "_normalizeEncoding");
    function normalizeEncoding(enc) {
      var nenc = _normalizeEncoding(enc);
      if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc))) throw new Error("Unknown encoding: " + enc);
      return nenc || enc;
    }
    __name(normalizeEncoding, "normalizeEncoding");
    exports2.StringDecoder = StringDecoder2;
    function StringDecoder2(encoding) {
      this.encoding = normalizeEncoding(encoding);
      var nb;
      switch (this.encoding) {
        case "utf16le":
          this.text = utf16Text;
          this.end = utf16End;
          nb = 4;
          break;
        case "utf8":
          this.fillLast = utf8FillLast;
          nb = 4;
          break;
        case "base64":
          this.text = base64Text;
          this.end = base64End;
          nb = 3;
          break;
        default:
          this.write = simpleWrite;
          this.end = simpleEnd;
          return;
      }
      this.lastNeed = 0;
      this.lastTotal = 0;
      this.lastChar = Buffer2.allocUnsafe(nb);
    }
    __name(StringDecoder2, "StringDecoder");
    StringDecoder2.prototype.write = function(buf) {
      if (buf.length === 0) return "";
      var r13;
      var i13;
      if (this.lastNeed) {
        r13 = this.fillLast(buf);
        if (r13 === void 0) return "";
        i13 = this.lastNeed;
        this.lastNeed = 0;
      } else {
        i13 = 0;
      }
      if (i13 < buf.length) return r13 ? r13 + this.text(buf, i13) : this.text(buf, i13);
      return r13 || "";
    };
    StringDecoder2.prototype.end = utf8End;
    StringDecoder2.prototype.text = utf8Text;
    StringDecoder2.prototype.fillLast = function(buf) {
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
      this.lastNeed -= buf.length;
    };
    function utf8CheckByte(byte) {
      if (byte <= 127) return 0;
      else if (byte >> 5 === 6) return 2;
      else if (byte >> 4 === 14) return 3;
      else if (byte >> 3 === 30) return 4;
      return byte >> 6 === 2 ? -1 : -2;
    }
    __name(utf8CheckByte, "utf8CheckByte");
    function utf8CheckIncomplete(self2, buf, i13) {
      var j13 = buf.length - 1;
      if (j13 < i13) return 0;
      var nb = utf8CheckByte(buf[j13]);
      if (nb >= 0) {
        if (nb > 0) self2.lastNeed = nb - 1;
 