/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import { CloudErrorMapper, BaseResourceMapper } from "@azure/ms-rest-azure-js";
export var CloudError = CloudErrorMapper;
export var BaseResource = BaseResourceMapper;
export var Location = {
    serializedName: "Location",
    type: {
        name: "Composite",
        className: "Location",
        modelProperties: {
            id: {
                readOnly: true,
                serializedName: "id",
                type: {
                    name: "String"
                }
            },
            subscriptionId: {
                readOnly: true,
                serializedName: "subscriptionId",
                type: {
                    name: "String"
                }
            },
            name: {
                readOnly: true,
                serializedName: "name",
                type: {
                    name: "String"
                }
            },
            displayName: {
                readOnly: true,
                serializedName: "displayName",
                type: {
                    name: "String"
                }
            },
            latitude: {
                readOnly: true,
                serializedName: "latitude",
                type: {
                    name: "String"
                }
            },
            longitude: {
                readOnly: true,
                serializedName: "longitude",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var SubscriptionPolicies = {
    serializedName: "SubscriptionPolicies",
    type: {
        name: "Composite",
        className: "SubscriptionPolicies",
        modelProperties: {
            locationPlacementId: {
                readOnly: true,
                serializedName: "locationPlacementId",
                type: {
                    name: "String"
                }
            },
            quotaId: {
                readOnly: true,
                serializedName: "quotaId",
                type: {
                    name: "String"
                }
            },
            spendingLimit: {
                readOnly: true,
                serializedName: "spendingLimit",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "On",
                        "Off",
                        "CurrentPeriodOff"
                    ]
                }
            }
        }
    }
};
export var Subscription = {
    serializedName: "Subscription",
    type: {
        name: "Composite",
        className: "Subscription",
        modelProperties: {
            id: {
                readOnly: true,
                serializedName: "id",
                type: {
                    name: "String"
                }
            },
            subscriptionId: {
                readOnly: true,
                serializedName: "subscriptionId",
                type: {
                    name: "String"
                }
            },
            displayName: {
                readOnly: true,
                serializedName: "displayName",
                type: {
                    name: "String"
                }
            },
            state: {
                readOnly: true,
                serializedName: "state",
                type: {
                    name: "Enum",
                    allowedValues: [
                        "Enabled",
                        "Warned",
                        "PastDue",
                        "Disabled",
                        "Deleted"
                    ]
                }
            },
            subscriptionPolicies: {
                serializedName: "subscriptionPolicies",
                type: {
                    name: "Composite",
                    className: "SubscriptionPolicies"
                }
            },
            authorizationSource: {
                serializedName: "authorizationSource",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var TenantIdDescription = {
    serializedName: "TenantIdDescription",
    type: {
        name: "Composite",
        className: "TenantIdDescription",
        modelProperties: {
            id: {
                readOnly: true,
                serializedName: "id",
                type: {
                    name: "String"
                }
            },
            tenantId: {
                readOnly: true,
                serializedName: "tenantId",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var ErrorResponse = {
    serializedName: "ErrorResponse",
    type: {
        name: "Composite",
        className: "ErrorResponse",
        modelProperties: {
            code: {
                serializedName: "code",
                type: {
                    name: "String"
                }
            },
            message: {
                serializedName: "message",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var ErrorResponseBody = {
    serializedName: "ErrorResponseBody",
    type: {
        name: "Composite",
        className: "ErrorResponseBody",
        modelProperties: {
            error: {
                serializedName: "error",
                type: {
                    name: "Composite",
                    className: "ErrorResponse"
                }
            }
        }
    }
};
export var CanceledSubscriptionId = {
    serializedName: "CanceledSubscriptionId",
    type: {
        name: "Composite",
        className: "CanceledSubscriptionId",
        modelProperties: {
            value: {
                readOnly: true,
                serializedName: "value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var RenamedSubscriptionId = {
    serializedName: "RenamedSubscriptionId",
    type: {
        name: "Composite",
        className: "RenamedSubscriptionId",
        modelProperties: {
            value: {
                readOnly: true,
                serializedName: "value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var EnabledSubscriptionId = {
    serializedName: "EnabledSubscriptionId",
    type: {
        name: "Composite",
        className: "EnabledSubscriptionId",
        modelProperties: {
            value: {
                readOnly: true,
                serializedName: "value",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var SubscriptionName = {
    serializedName: "SubscriptionName",
    type: {
        name: "Composite",
        className: "SubscriptionName",
        modelProperties: {
            subscriptionName: {
                serializedName: "subscriptionName",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var OperationDisplay = {
    serializedName: "Operation_display",
    type: {
        name: "Composite",
        className: "OperationDisplay",
        modelProperties: {
            provider: {
                serializedName: "provider",
                type: {
                    name: "String"
                }
            },
            resource: {
                serializedName: "resource",
                type: {
                    name: "String"
                }
            },
            operation: {
                serializedName: "operation",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var Operation = {
    serializedName: "Operation",
    type: {
        name: "Composite",
        className: "Operation",
        modelProperties: {
            name: {
                serializedName: "name",
                type: {
                    name: "String"
                }
            },
            display: {
                serializedName: "display",
                type: {
                    name: "Composite",
                    className: "OperationDisplay"
                }
            }
        }
    }
};
export var OperationListResult = {
    serializedName: "OperationListResult",
    type: {
        name: "Composite",
        className: "OperationListResult",
        modelProperties: {
            value: {
                serializedName: "value",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Operation"
                        }
                    }
                }
            },
            nextLink: {
                serializedName: "nextLink",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var PutAliasRequestProperties = {
    serializedName: "PutAliasRequestProperties",
    type: {
        name: "Composite",
        className: "PutAliasRequestProperties",
        modelProperties: {
            displayName: {
                serializedName: "displayName",
                type: {
                    name: "String"
                }
            },
            workload: {
                serializedName: "workload",
                type: {
                    name: "String"
                }
            },
            billingScope: {
                serializedName: "billingScope",
                type: {
                    name: "String"
                }
            },
            subscriptionId: {
                serializedName: "subscriptionId",
                type: {
                    name: "String"
                }
            },
            resellerId: {
                serializedName: "resellerId",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var PutAliasRequest = {
    serializedName: "PutAliasRequest",
    type: {
        name: "Composite",
        className: "PutAliasRequest",
        modelProperties: {
            properties: {
                required: true,
                serializedName: "properties",
                type: {
                    name: "Composite",
                    className: "PutAliasRequestProperties"
                }
            }
        }
    }
};
export var PutAliasResponseProperties = {
    serializedName: "PutAliasResponseProperties",
    type: {
        name: "Composite",
        className: "PutAliasResponseProperties",
        modelProperties: {
            subscriptionId: {
                readOnly: true,
                serializedName: "subscriptionId",
                type: {
                    name: "String"
                }
            },
            provisioningState: {
                serializedName: "provisioningState",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var PutAliasResponse = {
    serializedName: "PutAliasResponse",
    type: {
        name: "Composite",
        className: "PutAliasResponse",
        modelProperties: {
            id: {
                readOnly: true,
                serializedName: "id",
                type: {
                    name: "String"
                }
            },
            name: {
                readOnly: true,
                serializedName: "name",
                type: {
                    name: "String"
                }
            },
            type: {
                readOnly: true,
                serializedName: "type",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "properties",
                type: {
                    name: "Composite",
                    className: "PutAliasResponseProperties"
                }
            }
        }
    }
};
export var PutAliasListResult = {
    serializedName: "PutAliasListResult",
    type: {
        name: "Composite",
        className: "PutAliasListResult",
        modelProperties: {
            value: {
                readOnly: true,
                serializedName: "value",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "PutAliasResponse"
                        }
                    }
                }
            },
            nextLink: {
                readOnly: true,
                serializedName: "nextLink",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var LocationListResult = {
    serializedName: "LocationListResult",
    type: {
        name: "Composite",
        className: "LocationListResult",
        modelProperties: {
            value: {
                serializedName: "",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Location"
                        }
                    }
                }
            }
        }
    }
};
export var SubscriptionListResult = {
    serializedName: "SubscriptionListResult",
    type: {
        name: "Composite",
        className: "SubscriptionListResult",
        modelProperties: {
            value: {
                serializedName: "",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Subscription"
                        }
                    }
                }
            },
            nextLink: {
                required: true,
                serializedName: "nextLink",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export var TenantListResult = {
    serializedName: "TenantListResult",
    type: {
        name: "Composite",
        className: "TenantListResult",
        modelProperties: {
            value: {
                serializedName: "",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "TenantIdDescription"
                        }
                    }
                }
            },
            nextLink: {
                required: true,
                serializedName: "nextLink",
                type: {
                    name: "String"
                }
            }
        }
    }
};
//# sourceMappingURL=mappers.js.map