import * as msRest from "@azure/ms-rest-js";
import { TokenCredential } from "@azure/core-auth";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as operations from "./operations";
import { ResourceGraphClientContext } from "./resourceGraphClientContext";
declare class ResourceGraphClient extends ResourceGraphClientContext {
    operations: operations.Operations;
    /**
     * Initializes a new instance of the ResourceGraphClient class.
     * @param credentials Credentials needed for the client to connect to Azure. Credentials
     * implementing the TokenCredential interface from the @azure/identity package are recommended. For
     * more information about these credentials, see
     * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
     * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
     * @azure/ms-rest-browserauth are also supported.
     * @param [options] The parameter options
     */
    constructor(credentials: msRest.ServiceClientCredentials | TokenCredential, options?: Models.ResourceGraphClientOptions);
    /**
     * List changes to a resource for a given time interval.
     * @param parameters the parameters for this request for changes.
     * @param [options] The optional parameters
     * @returns Promise<Models.ResourceChangesResponse>
     */
    resourceChanges(parameters: Models.ResourceChangesRequestParameters, options?: msRest.RequestOptionsBase): Promise<Models.ResourceChangesResponse>;
    /**
     * @param parameters the parameters for this request for changes.
     * @param callback The callback
     */
    resourceChanges(parameters: Models.ResourceChangesRequestParameters, callback: msRest.ServiceCallback<Models.ResourceChangeList>): void;
    /**
     * @param parameters the parameters for this request for changes.
     * @param options The optional parameters
     * @param callback The callback
     */
    resourceChanges(parameters: Models.ResourceChangesRequestParameters, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ResourceChangeList>): void;
    /**
     * Get resource change details.
     * @param parameters The parameters for this request for resource change details.
     * @param [options] The optional parameters
     * @returns Promise<Models.ResourceChangeDetailsResponse>
     */
    resourceChangeDetails(parameters: Models.ResourceChangeDetailsRequestParameters, options?: msRest.RequestOptionsBase): Promise<Models.ResourceChangeDetailsResponse>;
    /**
     * @param parameters The parameters for this request for resource change details.
     * @param callback The callback
     */
    resourceChangeDetails(parameters: Models.ResourceChangeDetailsRequestParameters, callback: msRest.ServiceCallback<Models.ResourceChangeData[]>): void;
    /**
     * @param parameters The parameters for this request for resource change details.
     * @param options The optional parameters
     * @param callback The callback
     */
    resourceChangeDetails(parameters: Models.ResourceChangeDetailsRequestParameters, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ResourceChangeData[]>): void;
    /**
     * Queries the resources managed by Azure Resource Manager for scopes specified in the request.
     * @param query Request specifying query and its options.
     * @param [options] The optional parameters
     * @returns Promise<Models.ResourcesResponse>
     */
    resources(query: Models.QueryRequest, options?: msRest.RequestOptionsBase): Promise<Models.ResourcesResponse>;
    /**
     * @param query Request specifying query and its options.
     * @param callback The callback
     */
    resources(query: Models.QueryRequest, callback: msRest.ServiceCallback<Models.QueryResponse>): void;
    /**
     * @param query Request specifying query and its options.
     * @param options The optional parameters
     * @param callback The callback
     */
    resources(query: Models.QueryRequest, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.QueryResponse>): void;
    /**
     * List all snapshots of a resource for a given time interval.
     * @param request
     * @param [options] The optional parameters
     * @returns Promise<Models.ResourcesHistoryResponse>
     */
    resourcesHistory(request: Models.ResourcesHistoryRequest, options?: msRest.RequestOptionsBase): Promise<Models.ResourcesHistoryResponse>;
    /**
     * @param request
     * @param callback The callback
     */
    resourcesHistory(request: Models.ResourcesHistoryRequest, callback: msRest.ServiceCallback<any>): void;
    /**
     * @param request
     * @param options The optional parameters
     * @param callback The callback
     */
    resourcesHistory(request: Models.ResourcesHistoryRequest, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<any>): void;
}
export { ResourceGraphClient, ResourceGraphClientContext, Models as ResourceGraphModels, Mappers as ResourceGraphMappers };
export * from "./operations";
//# sourceMappingURL=resourceGraphClient.d.ts.map