import { BaseResource, CloudError, AzureServiceClientOptions } from "@azure/ms-rest-azure-js";
import * as msRest from "@azure/ms-rest-js";
export { BaseResource, CloudError };
/**
 * Location information.
 */
export interface Location {
    /**
     * The fully qualified ID of the location. For example,
     * /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly id?: string;
    /**
     * The subscription ID.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly subscriptionId?: string;
    /**
     * The location name.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly name?: string;
    /**
     * The display name of the location.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly displayName?: string;
    /**
     * The latitude of the location.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly latitude?: string;
    /**
     * The longitude of the location.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly longitude?: string;
}
/**
 * Subscription policies.
 */
export interface SubscriptionPolicies {
    /**
     * The subscription location placement ID. The ID indicates which regions are visible for a
     * subscription. For example, a subscription with a location placement Id of Public_2014-09-01
     * has access to Azure public regions.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly locationPlacementId?: string;
    /**
     * The subscription quota ID.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly quotaId?: string;
    /**
     * The subscription spending limit. Possible values include: 'On', 'Off', 'CurrentPeriodOff'
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly spendingLimit?: SpendingLimit;
}
/**
 * Subscription information.
 */
export interface Subscription {
    /**
     * The fully qualified ID for the subscription. For example,
     * /subscriptions/00000000-0000-0000-0000-000000000000.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly id?: string;
    /**
     * The subscription ID.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly subscriptionId?: string;
    /**
     * The subscription display name.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly displayName?: string;
    /**
     * The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted.
     * Possible values include: 'Enabled', 'Warned', 'PastDue', 'Disabled', 'Deleted'
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly state?: SubscriptionState;
    /**
     * The subscription policies.
     */
    subscriptionPolicies?: SubscriptionPolicies;
    /**
     * The authorization source of the request. Valid values are one or more combinations of Legacy,
     * RoleBased, Bypassed, Direct and Management. For example, 'Legacy, RoleBased'.
     */
    authorizationSource?: string;
}
/**
 * Tenant Id information.
 */
export interface TenantIdDescription {
    /**
     * The fully qualified ID of the tenant. For example,
     * /tenants/00000000-0000-0000-0000-000000000000.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly id?: string;
    /**
     * The tenant ID. For example, 00000000-0000-0000-0000-000000000000.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly tenantId?: string;
}
/**
 * Describes the format of Error response.
 */
export interface ErrorResponse {
    /**
     * Error code
     */
    code?: string;
    /**
     * Error message indicating why the operation failed.
     */
    message?: string;
}
/**
 * Error response indicates that the service is not able to process the incoming request. The
 * reason is provided in the error message.
 */
export interface ErrorResponseBody {
    /**
     * The details of the error.
     */
    error?: ErrorResponse;
}
/**
 * The ID of the canceled subscription
 */
export interface CanceledSubscriptionId {
    /**
     * The ID of the canceled subscription
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly value?: string;
}
/**
 * The ID of the subscriptions that is being renamed
 */
export interface RenamedSubscriptionId {
    /**
     * The ID of the subscriptions that is being renamed
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly value?: string;
}
/**
 * The ID of the subscriptions that is being enabled
 */
export interface EnabledSubscriptionId {
    /**
     * The ID of the subscriptions that is being enabled
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly value?: string;
}
/**
 * The new name of the subscription.
 */
export interface SubscriptionName {
    /**
     * New subscription name
     */
    subscriptionName?: string;
}
/**
 * The object that represents the operation.
 */
export interface OperationDisplay {
    /**
     * Service provider: Microsoft.Subscription
     */
    provider?: string;
    /**
     * Resource on which the operation is performed: Profile, endpoint, etc.
     */
    resource?: string;
    /**
     * Operation type: Read, write, delete, etc.
     */
    operation?: string;
}
/**
 * REST API operation
 */
export interface Operation {
    /**
     * Operation name: {provider}/{resource}/{operation}
     */
    name?: string;
    /**
     * The object that represents the operation.
     */
    display?: OperationDisplay;
}
/**
 * Result of the request to list operations. It contains a list of operations and a URL link to get
 * the next set of results.
 */
export interface OperationListResult {
    /**
     * List of operations.
     */
    value?: Operation[];
    /**
     * URL to get the next set of operation list results if there are any.
     */
    nextLink?: string;
}
/**
 * Put subscription properties.
 */
export interface PutAliasRequestProperties {
    /**
     * The friendly name of the subscription.
     */
    displayName?: string;
    /**
     * The workload type of the subscription. It can be either Production or DevTest. Possible values
     * include: 'Production', 'DevTest'
     */
    workload?: Workload;
    /**
     * Determines whether subscription is fieldLed, partnerLed or LegacyEA
     */
    billingScope?: string;
    /**
     * This parameter can be used to create alias for existing subscription Id
     */
    subscriptionId?: string;
    /**
     * Reseller ID, basically MPN Id
     */
    resellerId?: string;
}
/**
 * The parameters required to create a new subscription.
 */
export interface PutAliasRequest {
    /**
     * Put alias request properties.
     */
    properties: PutAliasRequestProperties;
}
/**
 * Put subscription creation result properties.
 */
export interface PutAliasResponseProperties {
    /**
     * Newly created subscription Id.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly subscriptionId?: string;
    /**
     * The provisioning state of the resource. Possible values include: 'Accepted', 'Succeeded',
     * 'Failed'
     */
    provisioningState?: ProvisioningState;
}
/**
 * Subscription Information with the alias.
 */
export interface PutAliasResponse extends BaseResource {
    /**
     * Fully qualified ID for the alias resource.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly id?: string;
    /**
     * Alias ID.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly name?: string;
    /**
     * Resource type, Microsoft.Subscription/aliases.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly type?: string;
    /**
     * Put Alias response properties.
     */
    properties?: PutAliasResponseProperties;
}
/**
 * The list of aliases.
 */
export interface PutAliasListResult {
    /**
     * The list of alias.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly value?: PutAliasResponse[];
    /**
     * The link (url) to the next page of results.
     * **NOTE: This property will not be serialized. It can only be populated by the server.**
     */
    readonly nextLink?: string;
}
/**
 * An interface representing SubscriptionClientOptions.
 */
export interface SubscriptionClientOptions extends AzureServiceClientOptions {
    baseUri?: string;
}
/**
 * @interface
 * Location list operation response.
 * @extends Array<Location>
 */
export interface LocationListResult extends Array<Location> {
}
/**
 * @interface
 * Subscription list operation response.
 * @extends Array<Subscription>
 */
export interface SubscriptionListResult extends Array<Subscription> {
    /**
     * The URL to get the next set of results.
     */
    nextLink: string;
}
/**
 * @interface
 * Tenant Ids information.
 * @extends Array<TenantIdDescription>
 */
export interface TenantListResult extends Array<TenantIdDescription> {
    /**
     * The URL to use for getting the next set of results.
     */
    nextLink: string;
}
/**
 * Defines values for SubscriptionState.
 * Possible values include: 'Enabled', 'Warned', 'PastDue', 'Disabled', 'Deleted'
 * @readonly
 * @enum {string}
 */
export declare type SubscriptionState = 'Enabled' | 'Warned' | 'PastDue' | 'Disabled' | 'Deleted';
/**
 * Defines values for SpendingLimit.
 * Possible values include: 'On', 'Off', 'CurrentPeriodOff'
 * @readonly
 * @enum {string}
 */
export declare type SpendingLimit = 'On' | 'Off' | 'CurrentPeriodOff';
/**
 * Defines values for Workload.
 * Possible values include: 'Production', 'DevTest'
 * @readonly
 * @enum {string}
 */
export declare type Workload = 'Production' | 'DevTest';
/**
 * Defines values for ProvisioningState.
 * Possible values include: 'Accepted', 'Succeeded', 'Failed'
 * @readonly
 * @enum {string}
 */
export declare type ProvisioningState = 'Accepted' | 'Succeeded' | 'Failed';
/**
 * Contains response data for the listLocations operation.
 */
export declare type SubscriptionsListLocationsResponse = LocationListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: LocationListResult;
    };
};
/**
 * Contains response data for the get operation.
 */
export declare type SubscriptionsGetResponse = Subscription & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: Subscription;
    };
};
/**
 * Contains response data for the list operation.
 */
export declare type SubscriptionsListResponse = SubscriptionListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: SubscriptionListResult;
    };
};
/**
 * Contains response data for the listNext operation.
 */
export declare type SubscriptionsListNextResponse = SubscriptionListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: SubscriptionListResult;
    };
};
/**
 * Contains response data for the list operation.
 */
export declare type TenantsListResponse = TenantListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: TenantListResult;
    };
};
/**
 * Contains response data for the listNext operation.
 */
export declare type TenantsListNextResponse = TenantListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: TenantListResult;
    };
};
/**
 * Contains response data for the cancel operation.
 */
export declare type SubscriptionCancelResponse = CanceledSubscriptionId & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: CanceledSubscriptionId;
    };
};
/**
 * Contains response data for the rename operation.
 */
export declare type SubscriptionRenameResponse = RenamedSubscriptionId & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: RenamedSubscriptionId;
    };
};
/**
 * Contains response data for the enable operation.
 */
export declare type SubscriptionEnableResponse = EnabledSubscriptionId & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: EnabledSubscriptionId;
    };
};
/**
 * Contains response data for the list operation.
 */
export declare type OperationsListResponse = OperationListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: OperationListResult;
    };
};
/**
 * Contains response data for the create operation.
 */
export declare type AliasCreateResponse = PutAliasResponse & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: PutAliasResponse;
    };
};
/**
 * Contains response data for the get operation.
 */
export declare type AliasGetResponse = PutAliasResponse & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: PutAliasResponse;
    };
};
/**
 * Contains response data for the list operation.
 */
export declare type AliasListResponse = PutAliasListResult & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: PutAliasListResult;
    };
};
/**
 * Contains response data for the beginCreate operation.
 */
export declare type AliasBeginCreateResponse = PutAliasResponse & {
    /**
     * The underlying HTTP response.
     */
    _response: msRest.HttpResponse & {
        /**
         * The response body as text (string format)
         */
        bodyAsText: string;
        /**
         * The response body as parsed JSON or XML
         */
        parsedBody: PutAliasResponse;
    };
};
//# sourceMappingURL=index.d.ts.map