import * as msRest from "@azure/ms-rest-js";
import * as msRestAzure from "@azure/ms-rest-azure-js";
import * as Models from "../models";
import { SubscriptionClientContext } from "../subscriptionClientContext";
/** Class representing a Alias. */
export declare class Alias {
    private readonly client;
    /**
     * Create a Alias.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    constructor(client: SubscriptionClientContext);
    /**
     * Create Alias Subscription.
     * @param aliasName Alias Name
     * @param body
     * @param [options] The optional parameters
     * @returns Promise<Models.AliasCreateResponse>
     */
    create(aliasName: string, body: Models.PutAliasRequest, options?: msRest.RequestOptionsBase): Promise<Models.AliasCreateResponse>;
    /**
     * Get Alias Subscription.
     * @param aliasName Alias Name
     * @param [options] The optional parameters
     * @returns Promise<Models.AliasGetResponse>
     */
    get(aliasName: string, options?: msRest.RequestOptionsBase): Promise<Models.AliasGetResponse>;
    /**
     * @param aliasName Alias Name
     * @param callback The callback
     */
    get(aliasName: string, callback: msRest.ServiceCallback<Models.PutAliasResponse>): void;
    /**
     * @param aliasName Alias Name
     * @param options The optional parameters
     * @param callback The callback
     */
    get(aliasName: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PutAliasResponse>): void;
    /**
     * Delete Alias.
     * @param aliasName Alias Name
     * @param [options] The optional parameters
     * @returns Promise<msRest.RestResponse>
     */
    deleteMethod(aliasName: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
    /**
     * @param aliasName Alias Name
     * @param callback The callback
     */
    deleteMethod(aliasName: string, callback: msRest.ServiceCallback<void>): void;
    /**
     * @param aliasName Alias Name
     * @param options The optional parameters
     * @param callback The callback
     */
    deleteMethod(aliasName: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
    /**
     * Get Alias Subscription.
     * @param [options] The optional parameters
     * @returns Promise<Models.AliasListResponse>
     */
    list(options?: msRest.RequestOptionsBase): Promise<Models.AliasListResponse>;
    /**
     * @param callback The callback
     */
    list(callback: msRest.ServiceCallback<Models.PutAliasListResult>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    list(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PutAliasListResult>): void;
    /**
     * Create Alias Subscription.
     * @param aliasName Alias Name
     * @param body
     * @param [options] The optional parameters
     * @returns Promise<msRestAzure.LROPoller>
     */
    beginCreate(aliasName: string, body: Models.PutAliasRequest, options?: msRest.RequestOptionsBase): Promise<msRestAzure.LROPoller>;
}
//# sourceMappingURL=alias.d.ts.map