import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { SubscriptionClientContext } from "../subscriptionClientContext";
/** Class representing a Subscriptions. */
export declare class Subscriptions {
    private readonly client;
    /**
     * Create a Subscriptions.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    constructor(client: SubscriptionClientContext);
    /**
     * This operation provides all the locations that are available for resource providers; however,
     * each resource provider may support a subset of this list.
     * @summary Gets all available geo-locations.
     * @param subscriptionId The ID of the target subscription.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionsListLocationsResponse>
     */
    listLocations(subscriptionId: string, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionsListLocationsResponse>;
    /**
     * @param subscriptionId The ID of the target subscription.
     * @param callback The callback
     */
    listLocations(subscriptionId: string, callback: msRest.ServiceCallback<Models.LocationListResult>): void;
    /**
     * @param subscriptionId The ID of the target subscription.
     * @param options The optional parameters
     * @param callback The callback
     */
    listLocations(subscriptionId: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.LocationListResult>): void;
    /**
     * Gets details about a specified subscription.
     * @param subscriptionId The ID of the target subscription.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionsGetResponse>
     */
    get(subscriptionId: string, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionsGetResponse>;
    /**
     * @param subscriptionId The ID of the target subscription.
     * @param callback The callback
     */
    get(subscriptionId: string, callback: msRest.ServiceCallback<Models.Subscription>): void;
    /**
     * @param subscriptionId The ID of the target subscription.
     * @param options The optional parameters
     * @param callback The callback
     */
    get(subscriptionId: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Subscription>): void;
    /**
     * Gets all subscriptions for a tenant.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionsListResponse>
     */
    list(options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionsListResponse>;
    /**
     * @param callback The callback
     */
    list(callback: msRest.ServiceCallback<Models.SubscriptionListResult>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    list(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.SubscriptionListResult>): void;
    /**
     * Gets all subscriptions for a tenant.
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionsListNextResponse>
     */
    listNext(nextPageLink: string, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionsListNextResponse>;
    /**
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param callback The callback
     */
    listNext(nextPageLink: string, callback: msRest.ServiceCallback<Models.SubscriptionListResult>): void;
    /**
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param options The optional parameters
     * @param callback The callback
     */
    listNext(nextPageLink: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.SubscriptionListResult>): void;
}
//# sourceMappingURL=subscriptions.d.ts.map