import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { SubscriptionClientContext } from "../subscriptionClientContext";
/** Class representing a SubscriptionOperations. */
export declare class SubscriptionOperations {
    private readonly client;
    /**
     * Create a SubscriptionOperations.
     * @param {SubscriptionClientContext} client Reference to the service client.
     */
    constructor(client: SubscriptionClientContext);
    /**
     * The operation to cancel a subscription
     * @param subscriptionId Subscription Id.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionCancelResponse>
     */
    cancel(subscriptionId: string, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionCancelResponse>;
    /**
     * @param subscriptionId Subscription Id.
     * @param callback The callback
     */
    cancel(subscriptionId: string, callback: msRest.ServiceCallback<Models.CanceledSubscriptionId>): void;
    /**
     * @param subscriptionId Subscription Id.
     * @param options The optional parameters
     * @param callback The callback
     */
    cancel(subscriptionId: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.CanceledSubscriptionId>): void;
    /**
     * The operation to rename a subscription
     * @param subscriptionId Subscription Id.
     * @param body Subscription Name
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionRenameResponse>
     */
    rename(subscriptionId: string, body: Models.SubscriptionName, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionRenameResponse>;
    /**
     * @param subscriptionId Subscription Id.
     * @param body Subscription Name
     * @param callback The callback
     */
    rename(subscriptionId: string, body: Models.SubscriptionName, callback: msRest.ServiceCallback<Models.RenamedSubscriptionId>): void;
    /**
     * @param subscriptionId Subscription Id.
     * @param body Subscription Name
     * @param options The optional parameters
     * @param callback The callback
     */
    rename(subscriptionId: string, body: Models.SubscriptionName, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.RenamedSubscriptionId>): void;
    /**
     * The operation to enable a subscription
     * @param subscriptionId Subscription Id.
     * @param [options] The optional parameters
     * @returns Promise<Models.SubscriptionEnableResponse>
     */
    enable(subscriptionId: string, options?: msRest.RequestOptionsBase): Promise<Models.SubscriptionEnableResponse>;
    /**
     * @param subscriptionId Subscription Id.
     * @param callback The callback
     */
    enable(subscriptionId: string, callback: msRest.ServiceCallback<Models.EnabledSubscriptionId>): void;
    /**
     * @param subscriptionId Subscription Id.
     * @param options The optional parameters
     * @param callback The callback
     */
    enable(subscriptionId: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.EnabledSubscriptionId>): void;
}
//# sourceMappingURL=subscriptionOperations.d.ts.map