// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
export var CloudErrorMapper = {
    serializedName: "CloudError",
    type: {
        name: "Composite",
        className: "CloudError",
        modelProperties: {
            code: {
                required: true,
                serializedName: "code",
                type: {
                    name: "String"
                }
            },
            message: {
                required: true,
                serializedName: "message",
                type: {
                    name: "String"
                }
            },
            target: {
                serializedName: "target",
                type: {
                    name: "String"
                }
            },
            details: {
                serializedName: "details",
                type: {
                    name: "Sequence",
                    element: {
                        serializedName: "CloudErrorElementType",
                        type: {
                            name: "Composite",
                            className: "CloudError"
                        }
                    }
                }
            },
            innerError: {
                required: false,
                serializedName: "innererror",
                type: {
                    name: "Object"
                }
            },
            additionalInfo: {
                required: false,
                serializedName: "additionalInfo",
                type: {
                    name: "Composite",
                    className: "AdditionalInfoElement",
                    modelProperties: {
                        type: {
                            required: true,
                            serializedName: "type",
                            type: {
                                name: "String"
                            }
                        },
                        info: {
                            required: false,
                            serializedName: "info",
                            type: {
                                name: "Object"
                            }
                        }
                    }
                }
            }
        }
    }
};
//# sourceMappingURL=cloudError.js.map