/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@azure/ms-rest-azure-js'), require('@azure/ms-rest-js')) :
    typeof define === 'function' && define.amd ? define(['exports', '@azure/ms-rest-azure-js', '@azure/ms-rest-js'], factory) :
    (global = global || self, factory((global.Azure = global.Azure || {}, global.Azure.ArmSubscriptions = {}), global.msRestAzure, global.msRest));
}(this, (function (exports, msRestAzure, msRest) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var index = /*#__PURE__*/Object.freeze({
        __proto__: null
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */
    var CloudError = msRestAzure.CloudErrorMapper;
    var BaseResource = msRestAzure.BaseResourceMapper;
    var Location = {
        serializedName: "Location",
        type: {
            name: "Composite",
            className: "Location",
            modelProperties: {
                id: {
                    readOnly: true,
                    serializedName: "id",
                    type: {
                        name: "String"
                    }
                },
                subscriptionId: {
                    readOnly: true,
                    serializedName: "subscriptionId",
                    type: {
                        name: "String"
                    }
                },
                name: {
                    readOnly: true,
                    serializedName: "name",
                    type: {
                        name: "String"
                    }
                },
                displayName: {
                    readOnly: true,
                    serializedName: "displayName",
                    type: {
                        name: "String"
                    }
                },
                latitude: {
                    readOnly: true,
                    serializedName: "latitude",
                    type: {
                        name: "String"
                    }
                },
                longitude: {
                    readOnly: true,
                    serializedName: "longitude",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var SubscriptionPolicies = {
        serializedName: "SubscriptionPolicies",
        type: {
            name: "Composite",
            className: "SubscriptionPolicies",
            modelProperties: {
                locationPlacementId: {
                    readOnly: true,
                    serializedName: "locationPlacementId",
                    type: {
                        name: "String"
                    }
                },
                quotaId: {
                    readOnly: true,
                    serializedName: "quotaId",
                    type: {
                        name: "String"
                    }
                },
                spendingLimit: {
                    readOnly: true,
                    serializedName: "spendingLimit",
                    type: {
                        name: "Enum",
                        allowedValues: [
                            "On",
                            "Off",
                            "CurrentPeriodOff"
                        ]
                    }
                }
            }
        }
    };
    var Subscription = {
        serializedName: "Subscription",
        type: {
            name: "Composite",
            className: "Subscription",
            modelProperties: {
                id: {
                    readOnly: true,
                    serializedName: "id",
                    type: {
                        name: "String"
                    }
                },
                subscriptionId: {
                    readOnly: true,
                    serializedName: "subscriptionId",
                    type: {
                        name: "String"
                    }
                },
                displayName: {
                    readOnly: true,
                    serializedName: "displayName",
                    type: {
                        name: "String"
                    }
                },
                state: {
                    readOnly: true,
                    serializedName: "state",
                    type: {
                        name: "Enum",
                        allowedValues: [
                            "Enabled",
                            "Warned",
                            "PastDue",
                            "Disabled",
                            "Deleted"
                        ]
                    }
                },
                subscriptionPolicies: {
                    serializedName: "subscriptionPolicies",
                    type: {
                        name: "Composite",
                        className: "SubscriptionPolicies"
                    }
                },
                authorizationSource: {
                    serializedName: "authorizationSource",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var TenantIdDescription = {
        serializedName: "TenantIdDescription",
        type: {
            name: "Composite",
            className: "TenantIdDescription",
            modelProperties: {
                id: {
                    readOnly: true,
                    serializedName: "id",
                    type: {
                        name: "String"
                    }
                },
                tenantId: {
                    readOnly: true,
                    serializedName: "tenantId",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var ErrorResponse = {
        serializedName: "ErrorResponse",
        type: {
            name: "Composite",
            className: "ErrorResponse",
            modelProperties: {
                code: {
                    serializedName: "code",
                    type: {
                        name: "String"
                    }
                },
                message: {
                    serializedName: "message",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var ErrorResponseBody = {
        serializedName: "ErrorResponseBody",
        type: {
            name: "Composite",
            className: "ErrorResponseBody",
            modelProperties: {
                error: {
                    serializedName: "error",
                    type: {
                        name: "Composite",
                        className: "ErrorResponse"
                    }
                }
            }
        }
    };
    var CanceledSubscriptionId = {
        serializedName: "CanceledSubscriptionId",
        type: {
            name: "Composite",
            className: "CanceledSubscriptionId",
            modelProperties: {
                value: {
                    readOnly: true,
                    serializedName: "value",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var RenamedSubscriptionId = {
        serializedName: "RenamedSubscriptionId",
        type: {
            name: "Composite",
            className: "RenamedSubscriptionId",
            modelProperties: {
                value: {
                    readOnly: true,
                    serializedName: "value",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var EnabledSubscriptionId = {
        serializedName: "EnabledSubscriptionId",
        type: {
            name: "Composite",
            className: "EnabledSubscriptionId",
            modelProperties: {
                value: {
                    readOnly: true,
                    serializedName: "value",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var SubscriptionName = {
        serializedName: "SubscriptionName",
        type: {
            name: "Composite",
            className: "SubscriptionName",
            modelProperties: {
                subscriptionName: {
                    serializedName: "subscriptionName",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var OperationDisplay = {
        serializedName: "Operation_display",
        type: {
            name: "Composite",
            className: "OperationDisplay",
            modelProperties: {
                provider: {
                    serializedName: "provider",
                    type: {
                        name: "String"
                    }
                },
                resource: {
                    serializedName: "resource",
                    type: {
                        name: "String"
                    }
                },
                operation: {
                    serializedName: "operation",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var Operation = {
        serializedName: "Operation",
        type: {
            name: "Composite",
            className: "Operation",
            modelProperties: {
                name: {
                    serializedName: "name",
                    type: {
                        name: "String"
                    }
                },
                display: {
                    serializedName: "display",
                    type: {
                        name: "Composite",
                        className: "OperationDisplay"
                    }
                }
            }
        }
    };
    var OperationListResult = {
        serializedName: "OperationListResult",
        type: {
            name: "Composite",
            className: "OperationListResult",
            modelProperties: {
                value: {
                    serializedName: "value",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Operation"
                            }
                        }
                    }
                },
                nextLink: {
                    serializedName: "nextLink",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var PutAliasRequestProperties = {
        serializedName: "PutAliasRequestProperties",
        type: {
            name: "Composite",
            className: "PutAliasRequestProperties",
            modelProperties: {
                displayName: {
                    serializedName: "displayName",
                    type: {
                        name: "String"
                    }
                },
                workload: {
                    serializedName: "workload",
                    type: {
                        name: "String"
                    }
                },
                billingScope: {
                    serializedName: "billingScope",
                    type: {
                        name: "String"
                    }
                },
                subscriptionId: {
                    serializedName: "subscriptionId",
                    type: {
                        name: "String"
                    }
                },
                resellerId: {
                    serializedName: "resellerId",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var PutAliasRequest = {
        serializedName: "PutAliasRequest",
        type: {
            name: "Composite",
            className: "PutAliasRequest",
            modelProperties: {
                properties: {
                    required: true,
                    serializedName: "properties",
                    type: {
                        name: "Composite",
                        className: "PutAliasRequestProperties"
                    }
                }
            }
        }
    };
    var PutAliasResponseProperties = {
        serializedName: "PutAliasResponseProperties",
        type: {
            name: "Composite",
            className: "PutAliasResponseProperties",
            modelProperties: {
                subscriptionId: {
                    readOnly: true,
                    serializedName: "subscriptionId",
                    type: {
                        name: "String"
                    }
                },
                provisioningState: {
                    serializedName: "provisioningState",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var PutAliasResponse = {
        serializedName: "PutAliasResponse",
        type: {
            name: "Composite",
            className: "PutAliasResponse",
            modelProperties: {
                id: {
                    readOnly: true,
                    serializedName: "id",
                    type: {
                        name: "String"
                    }
                },
                name: {
                    readOnly: true,
                    serializedName: "name",
                    type: {
                        name: "String"
                    }
                },
                type: {
                    readOnly: true,
                    serializedName: "type",
                    type: {
                        name: "String"
                    }
                },
                properties: {
                    serializedName: "properties",
                    type: {
                        name: "Composite",
                        className: "PutAliasResponseProperties"
                    }
                }
            }
        }
    };
    var PutAliasListResult = {
        serializedName: "PutAliasListResult",
        type: {
            name: "Composite",
            className: "PutAliasListResult",
            modelProperties: {
                value: {
                    readOnly: true,
                    serializedName: "value",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "PutAliasResponse"
                            }
                        }
                    }
                },
                nextLink: {
                    readOnly: true,
                    serializedName: "nextLink",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var LocationListResult = {
        serializedName: "LocationListResult",
        type: {
            name: "Composite",
            className: "LocationListResult",
            modelProperties: {
                value: {
                    serializedName: "",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Location"
                            }
                        }
                    }
                }
            }
        }
    };
    var SubscriptionListResult = {
        serializedName: "SubscriptionListResult",
        type: {
            name: "Composite",
            className: "SubscriptionListResult",
            modelProperties: {
                value: {
                    serializedName: "",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Subscription"
                            }
                        }
                    }
                },
                nextLink: {
                    required: true,
                    serializedName: "nextLink",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var TenantListResult = {
        serializedName: "TenantListResult",
        type: {
            name: "Composite",
            className: "TenantListResult",
            modelProperties: {
                value: {
                    serializedName: "",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "TenantIdDescription"
                            }
                        }
                    }
                },
                nextLink: {
                    required: true,
                    serializedName: "nextLink",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };

    var mappers = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CloudError: CloudError,
        BaseResource: BaseResource,
        Location: Location,
        SubscriptionPolicies: SubscriptionPolicies,
        Subscription: Subscription,
        TenantIdDescription: TenantIdDescription,
        ErrorResponse: ErrorResponse,
        ErrorResponseBody: ErrorResponseBody,
        CanceledSubscriptionId: CanceledSubscriptionId,
        RenamedSubscriptionId: RenamedSubscriptionId,
        EnabledSubscriptionId: EnabledSubscriptionId,
        SubscriptionName: SubscriptionName,
        OperationDisplay: OperationDisplay,
        Operation: Operation,
        OperationListResult: OperationListResult,
        PutAliasRequestProperties: PutAliasRequestProperties,
        PutAliasRequest: PutAliasRequest,
        PutAliasResponseProperties: PutAliasResponseProperties,
        PutAliasResponse: PutAliasResponse,
        PutAliasListResult: PutAliasListResult,
        LocationListResult: LocationListResult,
        SubscriptionListResult: SubscriptionListResult,
        TenantListResult: TenantListResult
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CloudError: CloudError,
        Location: Location,
        LocationListResult: LocationListResult,
        Subscription: Subscription,
        SubscriptionListResult: SubscriptionListResult,
        SubscriptionPolicies: SubscriptionPolicies
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var acceptLanguage = {
        parameterPath: "acceptLanguage",
        mapper: {
            serializedName: "accept-language",
            defaultValue: 'en-US',
            type: {
                name: "String"
            }
        }
    };
    var aliasName = {
        parameterPath: "aliasName",
        mapper: {
            required: true,
            serializedName: "aliasName",
            type: {
                name: "String"
            }
        }
    };
    var apiVersion0 = {
        parameterPath: "apiVersion",
        mapper: {
            required: true,
            isConstant: true,
            serializedName: "api-version",
            defaultValue: '2016-06-01',
            type: {
                name: "String"
            }
        }
    };
    var apiVersion1 = {
        parameterPath: "apiVersion",
        mapper: {
            required: true,
            isConstant: true,
            serializedName: "api-version",
            defaultValue: '2020-09-01',
            type: {
                name: "String"
            }
        }
    };
    var nextPageLink = {
        parameterPath: "nextPageLink",
        mapper: {
            required: true,
            serializedName: "nextLink",
            type: {
                name: "String"
            }
        },
        skipEncoding: true
    };
    var subscriptionId = {
        parameterPath: "subscriptionId",
        mapper: {
            required: true,
            serializedName: "subscriptionId",
            type: {
                name: "String"
            }
        }
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a Subscriptions. */
    var Subscriptions = /** @class */ (function () {
        /**
         * Create a Subscriptions.
         * @param {SubscriptionClientContext} client Reference to the service client.
         */
        function Subscriptions(client) {
            this.client = client;
        }
        Subscriptions.prototype.listLocations = function (subscriptionId, options, callback) {
            return this.client.sendOperationRequest({
                subscriptionId: subscriptionId,
                options: options
            }, listLocationsOperationSpec, callback);
        };
        Subscriptions.prototype.get = function (subscriptionId, options, callback) {
            return this.client.sendOperationRequest({
                subscriptionId: subscriptionId,
                options: options
            }, getOperationSpec, callback);
        };
        Subscriptions.prototype.list = function (options, callback) {
            return this.client.sendOperationRequest({
                options: options
            }, listOperationSpec, callback);
        };
        Subscriptions.prototype.listNext = function (nextPageLink, options, callback) {
            return this.client.sendOperationRequest({
                nextPageLink: nextPageLink,
                options: options
            }, listNextOperationSpec, callback);
        };
        return Subscriptions;
    }());
    // Operation Specifications
    var serializer = new msRest.Serializer(Mappers);
    var listLocationsOperationSpec = {
        httpMethod: "GET",
        path: "subscriptions/{subscriptionId}/locations",
        urlParameters: [
            subscriptionId
        ],
        queryParameters: [
            apiVersion0
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: LocationListResult
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer
    };
    var getOperationSpec = {
        httpMethod: "GET",
        path: "subscriptions/{subscriptionId}",
        urlParameters: [
            subscriptionId
        ],
        queryParameters: [
            apiVersion0
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: Subscription
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer
    };
    var listOperationSpec = {
        httpMethod: "GET",
        path: "subscriptions",
        queryParameters: [
            apiVersion0
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: SubscriptionListResult
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer
    };
    var listNextOperationSpec = {
        httpMethod: "GET",
        baseUrl: "https://management.azure.com",
        path: "{nextLink}",
        urlParameters: [
            nextPageLink
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: SubscriptionListResult
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers$1 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CloudError: CloudError,
        TenantIdDescription: TenantIdDescription,
        TenantListResult: TenantListResult
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a Tenants. */
    var Tenants = /** @class */ (function () {
        /**
         * Create a Tenants.
         * @param {SubscriptionClientContext} client Reference to the service client.
         */
        function Tenants(client) {
            this.client = client;
        }
        Tenants.prototype.list = function (options, callback) {
            return this.client.sendOperationRequest({
                options: options
            }, listOperationSpec$1, callback);
        };
        Tenants.prototype.listNext = function (nextPageLink, options, callback) {
            return this.client.sendOperationRequest({
                nextPageLink: nextPageLink,
                options: options
            }, listNextOperationSpec$1, callback);
        };
        return Tenants;
    }());
    // Operation Specifications
    var serializer$1 = new msRest.Serializer(Mappers$1);
    var listOperationSpec$1 = {
        httpMethod: "GET",
        path: "tenants",
        queryParameters: [
            apiVersion0
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: TenantListResult
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer$1
    };
    var listNextOperationSpec$1 = {
        httpMethod: "GET",
        baseUrl: "https://management.azure.com",
        path: "{nextLink}",
        urlParameters: [
            nextPageLink
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: TenantListResult
            },
            default: {
                bodyMapper: CloudError
            }
        },
        serializer: serializer$1
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers$2 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CanceledSubscriptionId: CanceledSubscriptionId,
        EnabledSubscriptionId: EnabledSubscriptionId,
        ErrorResponse: ErrorResponse,
        RenamedSubscriptionId: RenamedSubscriptionId,
        SubscriptionName: SubscriptionName
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a SubscriptionOperations. */
    var SubscriptionOperations = /** @class */ (function () {
        /**
         * Create a SubscriptionOperations.
         * @param {SubscriptionClientContext} client Reference to the service client.
         */
        function SubscriptionOperations(client) {
            this.client = client;
        }
        SubscriptionOperations.prototype.cancel = function (subscriptionId, options, callback) {
            return this.client.sendOperationRequest({
                subscriptionId: subscriptionId,
                options: options
            }, cancelOperationSpec, callback);
        };
        SubscriptionOperations.prototype.rename = function (subscriptionId, body, options, callback) {
            return this.client.sendOperationRequest({
                subscriptionId: subscriptionId,
                body: body,
                options: options
            }, renameOperationSpec, callback);
        };
        SubscriptionOperations.prototype.enable = function (subscriptionId, options, callback) {
            return this.client.sendOperationRequest({
                subscriptionId: subscriptionId,
                options: options
            }, enableOperationSpec, callback);
        };
        return SubscriptionOperations;
    }());
    // Operation Specifications
    var serializer$2 = new msRest.Serializer(Mappers$2);
    var cancelOperationSpec = {
        httpMethod: "POST",
        path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel",
        urlParameters: [
            subscriptionId
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: CanceledSubscriptionId
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$2
    };
    var renameOperationSpec = {
        httpMethod: "POST",
        path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename",
        urlParameters: [
            subscriptionId
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        requestBody: {
            parameterPath: "body",
            mapper: __assign(__assign({}, SubscriptionName), { required: true })
        },
        responses: {
            200: {
                bodyMapper: RenamedSubscriptionId
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$2
    };
    var enableOperationSpec = {
        httpMethod: "POST",
        path: "subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable",
        urlParameters: [
            subscriptionId
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: EnabledSubscriptionId
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$2
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers$3 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ErrorResponse: ErrorResponse,
        Operation: Operation,
        OperationDisplay: OperationDisplay,
        OperationListResult: OperationListResult
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a Operations. */
    var Operations = /** @class */ (function () {
        /**
         * Create a Operations.
         * @param {SubscriptionClientContext} client Reference to the service client.
         */
        function Operations(client) {
            this.client = client;
        }
        Operations.prototype.list = function (options, callback) {
            return this.client.sendOperationRequest({
                options: options
            }, listOperationSpec$2, callback);
        };
        return Operations;
    }());
    // Operation Specifications
    var serializer$3 = new msRest.Serializer(Mappers$3);
    var listOperationSpec$2 = {
        httpMethod: "GET",
        path: "providers/Microsoft.Subscription/operations",
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: OperationListResult
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$3
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers$4 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        BaseResource: BaseResource,
        ErrorResponse: ErrorResponse,
        ErrorResponseBody: ErrorResponseBody,
        PutAliasListResult: PutAliasListResult,
        PutAliasRequest: PutAliasRequest,
        PutAliasRequestProperties: PutAliasRequestProperties,
        PutAliasResponse: PutAliasResponse,
        PutAliasResponseProperties: PutAliasResponseProperties
    });

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a Alias. */
    var Alias = /** @class */ (function () {
        /**
         * Create a Alias.
         * @param {SubscriptionClientContext} client Reference to the service client.
         */
        function Alias(client) {
            this.client = client;
        }
        /**
         * Create Alias Subscription.
         * @param aliasName Alias Name
         * @param body
         * @param [options] The optional parameters
         * @returns Promise<Models.AliasCreateResponse>
         */
        Alias.prototype.create = function (aliasName, body, options) {
            return this.beginCreate(aliasName, body, options)
                .then(function (lroPoller) { return lroPoller.pollUntilFinished(); });
        };
        Alias.prototype.get = function (aliasName, options, callback) {
            return this.client.sendOperationRequest({
                aliasName: aliasName,
                options: options
            }, getOperationSpec$1, callback);
        };
        Alias.prototype.deleteMethod = function (aliasName, options, callback) {
            return this.client.sendOperationRequest({
                aliasName: aliasName,
                options: options
            }, deleteMethodOperationSpec, callback);
        };
        Alias.prototype.list = function (options, callback) {
            return this.client.sendOperationRequest({
                options: options
            }, listOperationSpec$3, callback);
        };
        /**
         * Create Alias Subscription.
         * @param aliasName Alias Name
         * @param body
         * @param [options] The optional parameters
         * @returns Promise<msRestAzure.LROPoller>
         */
        Alias.prototype.beginCreate = function (aliasName, body, options) {
            return this.client.sendLRORequest({
                aliasName: aliasName,
                body: body,
                options: options
            }, beginCreateOperationSpec, options);
        };
        return Alias;
    }());
    // Operation Specifications
    var serializer$4 = new msRest.Serializer(Mappers$4);
    var getOperationSpec$1 = {
        httpMethod: "GET",
        path: "providers/Microsoft.Subscription/aliases/{aliasName}",
        urlParameters: [
            aliasName
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: PutAliasResponse
            },
            default: {
                bodyMapper: ErrorResponseBody
            }
        },
        serializer: serializer$4
    };
    var deleteMethodOperationSpec = {
        httpMethod: "DELETE",
        path: "providers/Microsoft.Subscription/aliases/{aliasName}",
        urlParameters: [
            aliasName
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {},
            204: {},
            default: {
                bodyMapper: ErrorResponseBody
            }
        },
        serializer: serializer$4
    };
    var listOperationSpec$3 = {
        httpMethod: "GET",
        path: "providers/Microsoft.Subscription/aliases",
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        responses: {
            200: {
                bodyMapper: PutAliasListResult
            },
            default: {
                bodyMapper: ErrorResponseBody
            }
        },
        serializer: serializer$4
    };
    var beginCreateOperationSpec = {
        httpMethod: "PUT",
        path: "providers/Microsoft.Subscription/aliases/{aliasName}",
        urlParameters: [
            aliasName
        ],
        queryParameters: [
            apiVersion1
        ],
        headerParameters: [
            acceptLanguage
        ],
        requestBody: {
            parameterPath: "body",
            mapper: __assign(__assign({}, PutAliasRequest), { required: true })
        },
        responses: {
            200: {
                bodyMapper: PutAliasResponse
            },
            201: {
                bodyMapper: PutAliasResponse
            },
            default: {
                bodyMapper: ErrorResponseBody
            }
        },
        serializer: serializer$4
    };

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var packageName = "@azure/arm-subscriptions";
    var packageVersion = "3.1.2";
    var SubscriptionClientContext = /** @class */ (function (_super) {
        __extends(SubscriptionClientContext, _super);
        /**
         * Initializes a new instance of the SubscriptionClient class.
         * @param credentials Credentials needed for the client to connect to Azure. Credentials
         * implementing the TokenCredential interface from the @azure/identity package are recommended. For
         * more information about these credentials, see
         * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
         * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
         * @azure/ms-rest-browserauth are also supported.
         * @param [options] The parameter options
         */
        function SubscriptionClientContext(credentials, options) {
            var _this = this;
            if (credentials == undefined) {
                throw new Error('\'credentials\' cannot be null.');
            }
            if (!options) {
                options = {};
            }
            if (!options.userAgent) {
                var defaultUserAgent = msRestAzure.getDefaultUserAgentValue();
                options.userAgent = packageName + "/" + packageVersion + " " + defaultUserAgent;
            }
            _this = _super.call(this, credentials, options) || this;
            _this.acceptLanguage = 'en-US';
            _this.longRunningOperationRetryTimeout = 30;
            _this.baseUri = options.baseUri || _this.baseUri || "https://management.azure.com";
            _this.requestContentType = "application/json; charset=utf-8";
            _this.credentials = credentials;
            if (options.acceptLanguage !== null && options.acceptLanguage !== undefined) {
                _this.acceptLanguage = options.acceptLanguage;
            }
            if (options.longRunningOperationRetryTimeout !== null && options.longRunningOperationRetryTimeout !== undefined) {
                _this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
            }
            return _this;
        }
        return SubscriptionClientContext;
    }(msRestAzure.AzureServiceClient));

    /*
     * Copyright (c) Microsoft Corporation. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for
     * license information.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var SubscriptionClient = /** @class */ (function (_super) {
        __extends(SubscriptionClient, _super);
        /**
         * Initializes a new instance of the SubscriptionClient class.
         * @param credentials Credentials needed for the client to connect to Azure. Credentials
         * implementing the TokenCredential interface from the @azure/identity package are recommended. For
         * more information about these credentials, see
         * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
         * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
         * @azure/ms-rest-browserauth are also supported.
         * @param [options] The parameter options
         */
        function SubscriptionClient(credentials, options) {
            var _this = _super.call(this, credentials, options) || this;
            _this.subscriptions = new Subscriptions(_this);
            _this.tenants = new Tenants(_this);
            _this.subscription = new SubscriptionOperations(_this);
            _this.operations = new Operations(_this);
            _this.alias = new Alias(_this);
            return _this;
        }
        return SubscriptionClient;
    }(SubscriptionClientContext));

    exports.Alias = Alias;
    exports.Operations = Operations;
    exports.SubscriptionClient = SubscriptionClient;
    exports.SubscriptionClientContext = SubscriptionClientContext;
    exports.SubscriptionMappers = mappers;
    exports.SubscriptionModels = index;
    exports.SubscriptionOperations = SubscriptionOperations;
    exports.Subscriptions = Subscriptions;
    exports.Tenants = Tenants;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=arm-subscriptions.js.map
