# Global properties
set(CMAKE_PROJECT_HOMEPAGE_URL https://github.com/GrammaTech/gtirb)
set(CPACK_COMPONENTS_GROUPING ALL_COMPONENTS_IN_ONE)

set(CPACK_DEB_COMPONENT_INSTALL ON)

# Reusable lists of components
set(LIB_COMPONENTS library license)
set(DEV_COMPONENTS headers proto_library cmake_config cmake_target)

# Debian packages
if("${CPACK_GTIRB_PACKAGE}" STREQUAL "debian-lib")
  set(CPACK_DEBIAN_PACKAGE_NAME "libgtirb")
  set(CPACK_DEBIAN_FILE_NAME DEB-DEFAULT)
  set(CPACK_COMPONENTS_ALL ${LIB_COMPONENTS})
  if("${CPACK_DEBIAN_PACKAGE_RELEASE}" STREQUAL "focal")
    set(CPACK_DEBIAN_PACKAGE_DEPENDS
        "libstdc++6, libc6, libgcc1, libprotobuf17"
    )
  elseif("${CPACK_DEBIAN_PACKAGE_RELEASE}" STREQUAL "jammy")
    set(CPACK_DEBIAN_PACKAGE_DEPENDS
        "libstdc++6, libc6, libgcc-s1, libprotobuf23"
    )
  elseif("${CPACK_DEBIAN_PACKAGE_RELEASE}" STREQUAL "noble")
    set(CPACK_DEBIAN_PACKAGE_DEPENDS
        "libstdc++6, libc6, libgcc-s1, libprotobuf32t64"
    )
  else()
    message(
      SEND_ERROR "Unknown / missing value for CPACK_DEBIAN_PACKAGE_RELEASE."
    )
  endif()
elseif("${CPACK_GTIRB_PACKAGE}" STREQUAL "debian-dev")
  set(CPACK_DEBIAN_PACKAGE_NAME "libgtirb-dev")
  set(CPACK_DEBIAN_FILE_NAME DEB-DEFAULT)
  set(CPACK_COMPONENTS_ALL ${DEV_COMPONENTS})
  set(CPACK_DEBIAN_PACKAGE_DEPENDS
      "libgtirb (=${CPACK_GTIRB_VERSION}-${CPACK_DEBIAN_PACKAGE_RELEASE}), libboost-dev (>=1.68) | libboost1.68-dev, libprotobuf-dev (>=${CPACK_PROTOBUF_VERSION_LOWER_BOUND}~), libprotobuf-dev (<<${CPACK_PROTOBUF_VERSION_UPPER_BOUND})"
  )
elseif("${CPACK_GTIRB_PACKAGE}" STREQUAL "debian-debug")
  set(CPACK_DEBIAN_PACKAGE_NAME "libgtirb-dbg")
  set(CPACK_DEBIAN_FILE_NAME DEB-DEFAULT)
  set(CPACK_COMPONENTS_ALL debug-file)
  set(CPACK_DEBIAN_PACKAGE_DEPENDS
      "libgtirb (=${CPACK_GTIRB_VERSION}-${CPACK_DEBIAN_PACKAGE_RELEASE})"
  )
endif()
