# Using the C++ Library

We have provided several C++ examples in directory
`gtirb/doc/examples`. See the [Examples page](../examples.html) for more
information.

The remainder of this section provides examples walking through common
tasks using the GTIRB C++ library API.

- [Using the C++ Library](#using-the-c-library)
  - [Building](#building)
    - [Requirements](#requirements)
    - [Building on Windows](#building-on-windows)
    - [As a dependency](#as-a-dependency)
  - [Using the API](#using-the-api)

## Building

### Requirements

To build and install GTIRB, the following requirements should be installed in addition to the [common requirements](../../README.md#requirements):

- [Boost](https://www.boost.org/), version 1.68.0 or later.
  - No version of Ubuntu provides this version of Boost yet; you must build it from source.

### Building on Windows

CMake can optionally use a toolchain file, as generated by
[Microsoft's vcpkg](https://github.com/Microsoft/vcpkg), to find packages like
boost or protobuf on Windows. One way to install GTIRB's dependencies is to run
`vcpkg` before running `cmake`:

```
vcpkg.exe install --triplet x64-windows protobuf boost
```

and pass the path to the toolchain file when executing the CMake command above:

```
    -DCMAKE_TOOLCHAIN_FILE="C:\path\to\vcpkg\scripts\buildsystems\vcpkg.cmake"
```

### As a dependency

Note that, to compile a C++ client that uses the GTIRB library,
you have to inform the compiler and linker where to find GTIRB's
header files and library archives. In addition, the OS also needs to
be informed about where to find GTIRB's dynamic libraries. These files
are located under `include` and `lib` in the build output directory
you picked when running CMake originally. How to do this will depend
on the particular compiler tool chain and context you are working
with.

If the C++ client in question also uses CMake, then it can find gtirb as a dependency by adding this to thier `CMakeLists.txt`:

```cmake
find_package(gtirb REQUIRED)
```

On Linux systems, If GTIRB was installed (perhaps via `make install` or via APT package),
using GTIRB as a library is as simple as specifying `-lgtirb` or similar on your C compiler's command line.

If you choose to install a static build of GTIRB (via `-DGTIRB_BUILD_SHARED_LIBS=OFF`),
then you must provide `-lgtirb_proto` on your command line as well as `-lgtirb`.

## Using the API

See [api-walkthrough.cpp](../api-walkthrough_8cpp-example.html) (in
the repository at `gtirb/doc/examples/api-walkthrough.cpp`) for a
basic introduction to using the GTIRB API in C++.

## Iteration Order
\anchor iteration_order

### Blocks

Iterating over blocks on a ByteInterval will yield them in order of offset,
size, kind, decode mode, and UUID. Iterating over blocks on other containers,
such as Section or Module, will yield them in order of address, size, kind,
decode mode, and UUID.

### Sections and ByteIntervals

Iterating over Sections or ByteIntervals will yield them in order of address,
size, and UUID.

### Iterator Invalidation

Altering a property that affects sort order will not cause iterators to be
invalidated. However, it may cause objects to be visited more than once or
to be skipped completely.
