from typing import Iterable, Iterator, MutableSet, Set, TypeVar, overload

from .interval import Interval

PointT = TypeVar("PointT")
DataT = TypeVar("DataT")

class IntervalTree(MutableSet[Interval[PointT, DataT]]):
    def __init__(
        self, intervals: Iterable[Interval[PointT, DataT]] | None = ...
    ): ...
    def __contains__(self, item: object) -> bool: ...
    def __iter__(self) -> Iterator[Interval[PointT, DataT]]: ...
    def __len__(self) -> int: ...
    def add(self, interval: Interval[PointT, DataT]) -> None: ...
    def discard(self, interval: Interval[PointT, DataT]) -> None: ...
    def begin(self) -> PointT: ...
    def span(self) -> PointT: ...
    @overload
    def overlap(
        self, begin: Interval[PointT, DataT]
    ) -> Set[Interval[PointT, DataT]]: ...
    @overload
    def overlap(
        self, begin: PointT, end: PointT
    ) -> Set[Interval[PointT, DataT]]: ...
