/**
 * License for programmatically and manually incorporated
 * documentation aka. `JSDoc` from https://github.com/nodejs/node/tree/master/doc
 *
 * Copyright Node.js contributors. All rights reserved.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

// NOTE: These definitions support Node.js and TypeScript 5.8+.

// Reference required TypeScript libraries:
/// <reference lib="es2020" />
/// <reference lib="esnext.disposable" />
/// <reference lib="esnext.float16" />

// Iterator definitions required for compatibility with TypeScript <5.6:
/// <reference path="./compatibility/iterators.d.cts" />

// Definitions for Node.js modules specific to TypeScript 5.7+:
/// <reference path="./globals.typedarray.d.cts" />
/// <reference path="./buffer.buffer.d.cts" />

// Definitions for Node.js modules that are not specific to any version of TypeScript:
/// <reference path="./globals.d.cts" />
/// <reference path="./assert.d.cts" />
/// <reference path="./assert/strict.d.cts" />
/// <reference path="./async_hooks.d.cts" />
/// <reference path="./buffer.d.cts" />
/// <reference path="./child_process.d.cts" />
/// <reference path="./cluster.d.cts" />
/// <reference path="./console.d.cts" />
/// <reference path="./constants.d.cts" />
/// <reference path="./crypto.d.cts" />
/// <reference path="./dgram.d.cts" />
/// <reference path="./diagnostics_channel.d.cts" />
/// <reference path="./dns.d.cts" />
/// <reference path="./dns/promises.d.cts" />
/// <reference path="./dns/promises.d.cts" />
/// <reference path="./domain.d.cts" />
/// <reference path="./dom-events.d.cts" />
/// <reference path="./events.d.cts" />
/// <reference path="./fs.d.cts" />
/// <reference path="./fs/promises.d.cts" />
/// <reference path="./http.d.cts" />
/// <reference path="./http2.d.cts" />
/// <reference path="./https.d.cts" />
/// <reference path="./inspector.d.cts" />
/// <reference path="./module.d.cts" />
/// <reference path="./net.d.cts" />
/// <reference path="./os.d.cts" />
/// <reference path="./path.d.cts" />
/// <reference path="./perf_hooks.d.cts" />
/// <reference path="./process.d.cts" />
/// <reference path="./punycode.d.cts" />
/// <reference path="./querystring.d.cts" />
/// <reference path="./readline.d.cts" />
/// <reference path="./readline/promises.d.cts" />
/// <reference path="./repl.d.cts" />
/// <reference path="./sea.d.cts" />
/// <reference path="./sqlite.d.cts" />
/// <reference path="./stream.d.cts" />
/// <reference path="./stream/promises.d.cts" />
/// <reference path="./stream/consumers.d.cts" />
/// <reference path="./stream/web.d.cts" />
/// <reference path="./string_decoder.d.cts" />
/// <reference path="./test.d.cts" />
/// <reference path="./timers.d.cts" />
/// <reference path="./timers/promises.d.cts" />
/// <reference path="./tls.d.cts" />
/// <reference path="./trace_events.d.cts" />
/// <reference path="./tty.d.cts" />
/// <reference path="./url.d.cts" />
/// <reference path="./util.d.cts" />
/// <reference path="./v8.d.cts" />
/// <reference path="./vm.d.cts" />
/// <reference path="./wasi.d.cts" />
/// <reference path="./worker_threads.d.cts" />
/// <reference path="./zlib.d.cts" />
