// Copyright 2018-2026 the Deno authors. MIT license.

// This file is auto-generated by tools/update_tsgo.ts
// DO NOT EDIT THIS FILE MANUALLY

pub struct Hashes {
  pub windows_x64: &'static str,
  pub macos_x64: &'static str,
  pub macos_arm64: &'static str,
  pub linux_x64: &'static str,
  pub linux_arm64: &'static str,
}

impl Hashes {
  pub const fn all(&self) -> [&'static str; 5] {
    [
      self.windows_x64,
      self.macos_x64,
      self.macos_arm64,
      self.linux_x64,
      self.linux_arm64,
    ]
  }
}

pub const VERSION: &str = "0.1.15";
pub const DOWNLOAD_BASE_URL: &str =
  "https://github.com/denoland/typescript-go/releases/download/v0.1.15";
pub const HASHES: Hashes = Hashes {
  windows_x64: "sha256:dea89ae71da8e5022a084718b54eb59ea4316d97d58222e9725a72e540b33c92",
  macos_x64: "sha256:79f0ce40090ddbcecd984bd413b388b41353e42b9e5b7a6dcfadd30871b43d1a",
  macos_arm64: "sha256:c51b905d0ee19598a040a359983b23d44c7e65834e859856f90edd00d9cdfebc",
  linux_x64: "sha256:4aa265d9885a8e83988560b2864ce0df6711cd7f07b12073f457a2546b737989",
  linux_arm64: "sha256:bd77de2b3ced369053098e1c220cbb3d474a89da78df3018ad597b0379672113",
};

const _: () = {
  let sha256 = "sha256".as_bytes();

  let mut i = 0;
  let hashes = HASHES.all();

  while i < hashes.len() {
    let hash = hashes[i].as_bytes();
    let mut j = 0;

    while j < 6 {
      if hash[j] != sha256[j] {
        panic!("Hash algorithm is not sha256");
      }
      j += 1;
    }
    i += 1;
  }
};
