# deno_crypto

**This crate implements the Web Cryptography API.**

Spec: https://www.w3.org/TR/WebCryptoAPI/

## Usage Example

From javascript, include the extension's source, and assign `CryptoKey`,
`crypto`, `Crypto`, and `SubtleCrypto` to the global scope:

```javascript
import * as crypto from "ext:deno_crypto/00_crypto.js";

Object.defineProperty(globalThis, "CryptoKey", {
  value: crypto.CryptoKey,
  enumerable: false,
  configurable: true,
  writable: true,
});

Object.defineProperty(globalThis, "crypto", {
  value: crypto.crypto,
  enumerable: false,
  configurable: true,
  writable: false,
});

Object.defineProperty(globalThis, "Crypto", {
  value: crypto.Crypto,
  enumerable: false,
  configurable: true,
  writable: true,
});

Object.defineProperty(globalThis, "SubtleCrypto", {
  value: crypto.SubtleCrypto,
  enumerable: false,
  configurable: true,
  writable: true,
});
```

Then from rust, provide: `deno_crypto::deno_crypto::init(Option<u64>)` in the
`extensions` field of your `RuntimeOptions`

Where the `Option<u64>` represents an optional seed for initialization.

## Dependencies

- **deno_webidl**: Provided by the `deno_webidl` crate
- **deno_web**: Provided by the `deno_web` crate

## Provided ops

Following ops are provided, which can be accessed through `Deno.ops`:

- op_crypto_get_random_values
- op_crypto_generate_key
- op_crypto_sign_key
- op_crypto_verify_key
- op_crypto_derive_bits
- op_crypto_import_key
- op_crypto_export_key
- op_crypto_encrypt
- op_crypto_decrypt
- op_crypto_subtle_digest
- op_crypto_random_uuid
- op_crypto_wrap_key
- op_crypto_unwrap_key
- op_crypto_base64url_decode
- op_crypto_base64url_encode
- x25519::op_crypto_generate_x25519_keypair
- x25519::op_crypto_derive_bits_x25519
- x25519::op_crypto_import_spki_x25519
- x25519::op_crypto_import_pkcs8_x25519
- ed25519::op_crypto_generate_ed25519_keypair
- ed25519::op_crypto_import_spki_ed25519
- ed25519::op_crypto_import_pkcs8_ed25519
- ed25519::op_crypto_sign_ed25519
- ed25519::op_crypto_verify_ed25519
- ed25519::op_crypto_export_spki_ed25519
- ed25519::op_crypto_export_pkcs8_ed25519
- ed25519::op_crypto_jwk_x_ed25519
- x25519::op_crypto_export_spki_x25519
- x25519::op_crypto_export_pkcs8_x25519
