// Copyright 2018-2026 the Deno authors. MIT license.

import { assertEquals, loadTestLibrary } from "./common.js";

const strings = loadTestLibrary();

Deno.test("napi string utf8", function () {
  assertEquals(strings.test_utf8(""), "");
  assertEquals(strings.test_utf8("🦕"), "🦕");
});

Deno.test("napi string", function () {
  assertEquals(strings.test_utf16(""), "");
  assertEquals(strings.test_utf16("🦕"), "🦕");
});

Deno.test("napi string utf8 roundtrip", function () {
  assertEquals(strings.test_utf8_roundtrip(""), "");
  assertEquals(strings.test_utf8_roundtrip("hello"), "hello");
  assertEquals(strings.test_utf8_roundtrip("🦕"), "🦕");
});
