/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.model.Model;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.m2e.core.ui.internal.archetype.MavenArchetype;
import org.eclipse.m2e.core.ui.internal.components.TextComboBoxCellEditor;
import org.eclipse.m2e.core.ui.internal.util.ArchetypeUtil;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectWizardArchetypeParametersPage
extends AbstractMavenWizardPage {
    private static final String ARCHETYPE_REQUIRED_PROPERTY = "ArcheType.RequiredProperty";
    private static final Logger log = LoggerFactory.getLogger(MavenProjectWizardArchetypeParametersPage.class);
    public static final String DEFAULT_VERSION = "0.0.1-SNAPSHOT";
    Table propertiesTable;
    TableViewer propertiesViewer;
    public static final String KEY_PROPERTY = "key";
    public static final int KEY_INDEX = 0;
    public static final String VALUE_PROPERTY = "value";
    public static final int VALUE_INDEX = 1;
    protected Combo groupIdCombo;
    protected Combo artifactIdCombo;
    protected Combo versionCombo;
    protected Combo packageCombo;
    protected Button removeButton;
    private boolean isUsed = true;
    protected final Map<String, RequiredProperty> requiredProperties = new LinkedHashMap<String, RequiredProperty>();
    protected final Set<String> optionalProperties = new LinkedHashSet<String>();
    protected Archetype archetype;
    protected boolean archetypeChanged = false;
    protected boolean packageCustomized = false;
    private Button runInteractive;

    public MavenProjectWizardArchetypeParametersPage(ProjectImportConfiguration projectImportConfiguration) {
        super("Maven2ProjectWizardArchifactPage", projectImportConfiguration);
        this.setTitle(Messages.wizardProjectPageMaven2Title);
        this.setDescription(Messages.wizardProjectPageMaven2ArchetypeParametersDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createArtifactGroup(composite);
        this.createPropertiesGroup(composite);
        this.validate();
        this.createAdvancedSettings(composite, new GridData(4, 128, false, false, 3, 1));
        this.resolverConfigurationComponent.setModifyListener(e -> this.validate());
        this.setControl((Control)composite);
    }

    private void createArtifactGroup(Composite parent) {
        Label groupIdlabel = new Label(parent, 0);
        groupIdlabel.setText(Messages.artifactComponentGroupId);
        this.groupIdCombo = new Combo(parent, 2048);
        this.groupIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.addFieldWithHistory("groupId", this.groupIdCombo);
        this.groupIdCombo.setData("name", (Object)"groupId");
        this.groupIdCombo.addModifyListener(e -> {
            this.updateJavaPackage();
            this.validate();
        });
        Label artifactIdLabel = new Label(parent, 0);
        artifactIdLabel.setText(Messages.artifactComponentArtifactId);
        this.artifactIdCombo = new Combo(parent, 2048);
        this.artifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.addFieldWithHistory("artifactId", this.artifactIdCombo);
        this.artifactIdCombo.setData("name", (Object)"artifactId");
        this.artifactIdCombo.addModifyListener(e -> {
            this.updateJavaPackage();
            this.validate();
        });
        Label versionLabel = new Label(parent, 0);
        versionLabel.setText(Messages.artifactComponentVersion);
        this.versionCombo = new Combo(parent, 2048);
        GridData gd_versionCombo = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_versionCombo.widthHint = 150;
        this.versionCombo.setLayoutData((Object)gd_versionCombo);
        this.versionCombo.setText(DEFAULT_VERSION);
        this.addFieldWithHistory("version", this.versionCombo);
        this.versionCombo.addModifyListener(e -> this.validate());
        Label packageLabel = new Label(parent, 0);
        packageLabel.setText(Messages.artifactComponentPackage);
        this.packageCombo = new Combo(parent, 2048);
        this.packageCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.packageCombo.setData("name", (Object)"package");
        this.addFieldWithHistory("package", this.packageCombo);
        this.packageCombo.addModifyListener(e -> {
            if (!this.packageCustomized && !this.packageCombo.getText().equals(this.getDefaultJavaPackage())) {
                this.packageCustomized = true;
            }
            this.validate();
        });
        new Label(parent, 0);
        this.runInteractive = new Button(parent, 32);
        this.runInteractive.setSelection(true);
        this.runInteractive.setText(Messages.MavenProjectWizardArchetypeParametersPage_runInteractive);
        this.runInteractive.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MavenProjectWizardArchetypeParametersPage.this.validate();
            }
        });
    }

    private void createPropertiesGroup(Composite composite) {
        Label propertiesLabel = new Label(composite, 0);
        propertiesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        propertiesLabel.setText(Messages.MavenProjectWizardArchetypeParametersPage_lblProps);
        this.propertiesViewer = new TableViewer(composite, 67584);
        this.propertiesTable = this.propertiesViewer.getTable();
        this.propertiesTable.setLinesVisible(true);
        this.propertiesTable.setHeaderVisible(true);
        this.propertiesTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        TableColumn propertiesTableNameColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableNameColumn.setWidth(130);
        propertiesTableNameColumn.setText(Messages.MavenProjectWizardArchetypeParametersPage_columnName);
        TableColumn propertiesTableValueColumn = new TableColumn(this.propertiesTable, 0);
        propertiesTableValueColumn.setWidth(230);
        propertiesTableValueColumn.setText(Messages.MavenProjectWizardArchetypeParametersPage_columnValue);
        this.propertiesViewer.setColumnProperties(new String[]{KEY_PROPERTY, VALUE_PROPERTY});
        this.propertiesViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.propertiesTable, 0), new TextCellEditor((Composite)this.propertiesTable, 0)});
        this.propertiesViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    TableItem item = (TableItem)element;
                    item.setText(MavenProjectWizardArchetypeParametersPage.this.getTextIndex(property), String.valueOf(value));
                    MavenProjectWizardArchetypeParametersPage.this.validate();
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof TableItem) {
                    TableItem item = (TableItem)element;
                    return item.getText(MavenProjectWizardArchetypeParametersPage.this.getTextIndex(property));
                }
                return null;
            }
        });
        Button addButton = new Button(composite, 0);
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.setText(Messages.MavenProjectWizardArchetypeParametersPage_btnAdd);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem item = this.addTableItem("?", "?");
            this.propertiesTable.setFocus();
            this.propertiesViewer.editElement((Object)item, 0);
            this.propertiesViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
        }));
        this.removeButton = new Button(composite, 0);
        this.removeButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.removeButton.setText(Messages.MavenProjectWizardArchetypeParametersPage_btnRemove);
        this.removeButton.setEnabled(this.propertiesTable.getSelectionCount() > 0);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.propertiesTable.remove(this.propertiesTable.getSelectionIndices());
            this.removeButton.setEnabled(this.propertiesTable.getSelectionCount() > 0);
            this.validate();
        }));
        this.propertiesTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.removeButton.setEnabled(this.propertiesTable.getSelectionCount() > 0)));
    }

    void validate() {
        if (this.isVisible()) {
            String error = this.validateInput();
            this.setErrorMessage(error);
            this.setPageComplete(error == null);
        }
    }

    private String validateInput() {
        String error = this.validateGroupIdInput(this.groupIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        error = this.validateArtifactIdInput(this.artifactIdCombo.getText().trim());
        if (error != null) {
            return error;
        }
        String versionValue = this.versionCombo.getText().trim();
        if (versionValue.length() == 0) {
            return Messages.wizardProjectPageMaven2ValidatorVersion;
        }
        String packageName = this.packageCombo.getText();
        if (packageName.trim().length() != 0 && !Pattern.matches("[A-Za-z_$][A-Za-z_$\\d]*(?:\\.[A-Za-z_$][A-Za-z_$\\d]*)*", packageName)) {
            return Messages.MavenProjectWizardArchetypeParametersPage_error_package;
        }
        IStatus nameStatus = MavenProjectWizard.validateProjectName(this.getImportConfiguration(), this.getModel());
        if (!nameStatus.isOK()) {
            return NLS.bind((String)Messages.wizardProjectPageMaven2ValidatorProjectNameInvalid, (Object)nameStatus.getMessage());
        }
        if (!this.requiredProperties.isEmpty()) {
            Map<String, String> properties = this.getProperties();
            for (Map.Entry<String, RequiredProperty> entry : this.requiredProperties.entrySet()) {
                Predicate<String> predicate;
                String propertyKey = entry.getKey();
                RequiredProperty requiredProperty = entry.getValue();
                String value = properties.get(propertyKey);
                String defaultValue = requiredProperty.getDefaultValue();
                if (value == null || value.isBlank()) {
                    if (defaultValue != null && !defaultValue.isEmpty()) {
                        if (!this.requireEvaluation(defaultValue) || this.isInteractive()) continue;
                        return Messages.wizardProjectPageMaven2ValidatorRequireInteractive;
                    }
                    return NLS.bind((String)Messages.wizardProjectPageMaven2ValidatorRequiredProperty, (Object)propertyKey);
                }
                String regex = requiredProperty.getValidationRegex();
                if (regex == null || regex.isBlank() || (predicate = Pattern.compile(regex).asMatchPredicate()).test(value)) continue;
                return NLS.bind((String)Messages.wizardProjectPageMaven2ValidatorRequiredPropertyInvalidValue, (Object)propertyKey, (Object)regex);
            }
        }
        return null;
    }

    private boolean requireEvaluation(String value) {
        return value != null && value.contains("${");
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setArchetype(Archetype archetype) {
        if (archetype == null) {
            this.propertiesTable.removeAll();
            this.archetypeChanged = false;
        } else if (!ArchetypeUtil.areEqual(archetype, this.archetype)) {
            this.archetype = archetype;
            this.propertiesTable.removeAll();
            this.requiredProperties.clear();
            this.optionalProperties.clear();
            this.archetypeChanged = true;
            Properties properties = archetype.getProperties();
            if (properties != null) {
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry;
                    Map.Entry<Object, Object> e = entry = iterator.next();
                    String key = (String)e.getKey();
                    this.addTableItem(key, (String)e.getValue());
                    this.optionalProperties.add(key);
                }
            }
        }
    }

    void loadArchetypeDescriptor() {
        try {
            RequiredPropertiesLoader propertiesLoader = new RequiredPropertiesLoader(this.archetype);
            this.getContainer().run(true, true, (IRunnableWithProgress)propertiesLoader);
            List<RequiredProperty> properties = propertiesLoader.getProperties();
            if (properties != null) {
                for (RequiredProperty property : properties) {
                    this.requiredProperties.put(property.getKey(), property);
                    if (this.requireEvaluation(property.getDefaultValue())) {
                        this.optionalProperties.add(property.getKey());
                        continue;
                    }
                    TableItem tableItem = this.addTableItem(property.getKey(), property.getDefaultValue());
                    tableItem.setData(ARCHETYPE_REQUIRED_PROPERTY, (Object)property);
                }
            }
        }
        catch (InterruptedException propertiesLoader) {
        }
        catch (InvocationTargetException ex) {
            String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypeParametersPage_error_download, (Object)MavenProjectWizardArchetypeParametersPage.getName(this.archetype));
            log.error(msg, (Throwable)ex);
            this.setErrorMessage(msg + "\n" + ex.toString());
        }
    }

    static String getName(Archetype archetype) {
        String groupId = archetype.getGroupId();
        String artifactId = archetype.getArtifactId();
        String version = archetype.getVersion();
        return groupId + ":" + artifactId + ":" + version;
    }

    TableItem addTableItem(String key, String value) {
        TableItem item = new TableItem(this.propertiesTable, 0);
        item.setData((Object)item);
        item.setText(0, key);
        item.setText(1, value == null ? "" : value);
        return item;
    }

    public void setProjectName(String projectName) {
        if (this.artifactIdCombo.getText().equals(this.groupIdCombo.getText())) {
            this.groupIdCombo.setText(projectName);
        }
        this.artifactIdCombo.setText(projectName);
        this.packageCombo.setText("org." + projectName.replace('-', '.'));
        this.validate();
    }

    public void setParentProject(String groupId, String artifactId, String version) {
        this.groupIdCombo.setText(groupId);
        this.versionCombo.setText(version);
        this.validate();
    }

    public void setArtifactIdEnabled(boolean b) {
        this.artifactIdCombo.setEnabled(b);
    }

    public String getJavaPackage() {
        if (this.packageCombo.getText().length() > 0) {
            return this.packageCombo.getText();
        }
        return this.getDefaultJavaPackage();
    }

    protected void updateJavaPackage() {
        if (this.packageCustomized) {
            return;
        }
        String defaultPackageName = this.getDefaultJavaPackage();
        this.packageCombo.setText(defaultPackageName);
    }

    protected String getDefaultJavaPackage() {
        return MavenProjectWizardArchetypeParametersPage.getDefaultJavaPackage(this.groupIdCombo.getText().trim(), this.artifactIdCombo.getText().trim());
    }

    public Model getModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupIdCombo.getText());
        model.setArtifactId(this.artifactIdCombo.getText());
        model.setVersion(this.versionCombo.getText());
        return model;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        return !this.isUsed || super.isPageComplete();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        boolean shouldValidate = false;
        if (visible) {
            if (this.archetypeChanged && this.archetype != null) {
                this.archetypeChanged = false;
                this.loadArchetypeDescriptor();
                shouldValidate = true;
            }
            if (this.groupIdCombo.getText().length() == 0 && this.groupIdCombo.getItemCount() > 0) {
                this.groupIdCombo.setText(this.groupIdCombo.getItem(0));
                this.packageCombo.setText(this.getDefaultJavaPackage());
                this.packageCustomized = false;
            }
            if (shouldValidate) {
                this.validate();
            }
            this.updatePropertyEditors();
        }
    }

    public Map<String, String> getProperties() {
        if (this.propertiesViewer.isCellEditorActive()) {
            this.propertiesTable.setFocus();
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < this.propertiesTable.getItemCount()) {
            TableItem item = this.propertiesTable.getItem(i);
            properties.put(item.getText(0), item.getText(1));
            ++i;
        }
        return properties;
    }

    public int getTextIndex(String property) {
        return KEY_PROPERTY.equals(property) ? 0 : 1;
    }

    public void updatePropertyEditors() {
        CellEditor[] ce = this.propertiesViewer.getCellEditors();
        int n = this.requiredProperties.size() + this.optionalProperties.size();
        if (n == 0) {
            if (ce[0] instanceof TextComboBoxCellEditor) {
                ce[0].dispose();
                ce[0] = new TextCellEditor((Composite)this.propertiesTable, 0x800000);
            }
        } else {
            TextComboBoxCellEditor comboEditor = null;
            CellEditor cellEditor = ce[0];
            if (cellEditor instanceof TextComboBoxCellEditor) {
                TextComboBoxCellEditor textComboCellEditor;
                comboEditor = textComboCellEditor = (TextComboBoxCellEditor)cellEditor;
            } else {
                ce[0].dispose();
                comboEditor = new TextComboBoxCellEditor((Composite)this.propertiesTable, 0x800000);
                ce[0] = comboEditor;
            }
            ArrayList<String> propertyKeys = new ArrayList<String>(n);
            propertyKeys.addAll(this.requiredProperties.keySet());
            propertyKeys.addAll(this.optionalProperties);
            comboEditor.setItems(propertyKeys.toArray(new String[n]));
        }
    }

    public static String getDefaultJavaPackage(String groupId, String artifactId) {
        StringBuilder sb = new StringBuilder(groupId);
        if (sb.length() > 0 && artifactId.length() > 0) {
            sb.append('.');
        }
        sb.append(artifactId);
        boolean isFirst = true;
        StringBuilder pkg = new StringBuilder();
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == '-') {
                pkg.append('_');
                isFirst = false;
            } else if (isFirst) {
                if (Character.isJavaIdentifierStart(c)) {
                    pkg.append(c);
                    isFirst = false;
                }
            } else if (c == '.') {
                pkg.append('.');
                isFirst = true;
            } else if (Character.isJavaIdentifierPart(c)) {
                pkg.append(c);
            }
            ++i;
        }
        return pkg.toString();
    }

    private boolean isVisible() {
        return this.getControl() != null && this.getControl().isVisible();
    }

    public boolean isInteractive() {
        return this.runInteractive.getSelection();
    }

    private static class RequiredPropertiesLoader
    implements IRunnableWithProgress {
        private final Archetype archetype;
        private List<RequiredProperty> properties;

        RequiredPropertiesLoader(Archetype archetype) {
            this.archetype = archetype;
        }

        List<RequiredProperty> getProperties() {
            return this.properties;
        }

        public void run(IProgressMonitor monitor) {
            String archetypeName = MavenProjectWizardArchetypeParametersPage.getName(this.archetype);
            monitor.beginTask(NLS.bind((String)Messages.MavenProjectWizardArchetypeParametersPage_task, (Object)archetypeName), -1);
            try {
                try {
                    ArchetypePlugin archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
                    this.properties = archetypeManager.getRequiredProperties(new MavenArchetype(this.archetype), monitor);
                }
                catch (CoreException e) {
                    log.error(NLS.bind((String)"Error downloading archetype {0}", (Object)archetypeName), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

