/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.launcher.AbstractProfileExeLaunchSettingsSection;
import org.eclipse.php.profile.ui.launcher.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ZendDebuggerProfileExeLaunchSettingsSection
extends AbstractProfileExeLaunchSettingsSection {
    private Group fGeneralGroup;
    private Button fCodeCoverageButton;

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("ATTR_ENABLE_CODE_COVERAGE", true);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        super.initialize(configuration);
        if (this.fGeneralGroup != null) {
            try {
                boolean enableCodeCoverage = configuration.getAttribute("ATTR_ENABLE_CODE_COVERAGE", false);
                this.fCodeCoverageButton.setSelection(enableCodeCoverage);
            }
            catch (CoreException e) {
                ProfilerUiPlugin.log(e);
            }
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fGeneralGroup != null) {
            configuration.setAttribute("ATTR_ENABLE_CODE_COVERAGE", this.fCodeCoverageButton.getSelection());
        }
    }

    @Override
    protected void buildSection(Composite parent) {
        this.createGeneralGroup(parent);
    }

    protected void createGeneralGroup(Composite parent) {
        this.fGeneralGroup = new Group(parent, 0);
        this.fGeneralGroup.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralGroup.setLayoutData((Object)new GridData(768));
        this.fGeneralGroup.setText(Messages.ZendDebuggerProfileExeLaunchSettingsSection_General_group_name);
        this.fCodeCoverageButton = new Button((Composite)this.fGeneralGroup, 32);
        this.fCodeCoverageButton.setText(Messages.ZendDebuggerProfileExeLaunchSettingsSection_Show_code_coverage);
        this.fCodeCoverageButton.addSelectionListener((SelectionListener)this.widgetListener);
    }
}

