/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.wst.internet.monitor.core.internal.Connection;
import org.eclipse.wst.internet.monitor.core.internal.Monitor;
import org.eclipse.wst.internet.monitor.core.internal.SocketWrapper;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPThread;
import org.eclipse.wst.internet.monitor.core.internal.http.ResendHTTPConnection;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class ResendHTTPRequest
extends HTTPRequest {
    private boolean sent = false;
    private byte[] header;
    private byte[] content;
    private Request originalRequest = null;

    public ResendHTTPRequest(Monitor monitor, Request req) {
        super(monitor, req.getLocalPort(), req.getRemoteHost(), req.getRemotePort());
        this.setProperty("request-header", req.getProperty("request-header"));
        this.setProperty("request-body", req.getProperty("request-body"));
        this.header = req.getRequest(1);
        this.content = req.getRequest(2);
        this.request = req.getRequest(3);
        this.name = req.getName();
        this.originalRequest = req;
    }

    public void sendRequest() {
        try {
            SocketWrapper inSocket = new SocketWrapper(new ByteArrayInputStream(this.request));
            Socket outSocket = new Socket(this.remoteHost, this.remotePort);
            Connection conn2 = new Connection(inSocket, outSocket);
            ResendHTTPConnection conn = new ResendHTTPConnection(this);
            HTTPThread request2 = new HTTPThread(conn2, ((Socket)inSocket).getInputStream(), outSocket.getOutputStream(), conn, true, this.remoteHost, this.remotePort);
            HTTPThread response2 = new HTTPThread(conn2, outSocket.getInputStream(), ((Socket)inSocket).getOutputStream(), conn, false, "localhost", this.localPort, request2);
            request2.start();
            response2.start();
        }
        catch (IOException e) {
            this.response = ("Unable to resend to server.\n" + String.valueOf(e)).getBytes();
        }
        this.sent = true;
    }

    @Override
    public void addToRequest(byte[] addRequest) {
    }

    public boolean hasBeenSent() {
        return this.sent;
    }

    public void setRequest(byte[] request, int type) {
        if (request == null) {
            request = new byte[]{};
        }
        if (type == 1) {
            this.header = request;
        } else if (type == 2) {
            this.content = request;
        }
        int length = 0;
        int headerLength = 0;
        if (this.header != null) {
            headerLength = length += this.header.length;
        }
        if (this.content != null) {
            length += this.content.length;
        }
        byte[] newRequest = new byte[length];
        if (this.header != null) {
            System.arraycopy(this.header, 0, newRequest, 0, this.header.length);
        }
        if (this.content != null) {
            System.arraycopy(this.content, 0, newRequest, headerLength, this.content.length);
        }
        super.setRequest(newRequest);
    }

    @Override
    protected byte[] getRequestContent() {
        return this.content;
    }

    @Override
    protected byte[] getRequestHeader() {
        return this.header;
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }
}

