/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;

class AddressHasher {
    private final Address startAddress;
    private final Address endAddress;

    AddressHasher(Address startAddress, Address endAddress) {
        this.startAddress = startAddress;
        this.endAddress = endAddress;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressHasher other = (AddressHasher)obj;
        return SystemUtilities.isEqual((Object)this.startAddress, (Object)other.startAddress) && SystemUtilities.isEqual((Object)this.endAddress, (Object)other.endAddress);
    }

    public int hashCode() {
        return this.startAddress.hashCode() ^ this.endAddress.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[start=" + String.valueOf(this.startAddress) + ", end=" + String.valueOf(this.endAddress) + "]";
    }
}

