/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.sarif;

import com.contrastsecurity.sarif.CodeFlow;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.LogicalLocation;
import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.ThreadFlow;
import com.contrastsecurity.sarif.ThreadFlowLocation;
import ghidra.app.plugin.core.decompiler.taint.AbstractTaintState;
import ghidra.app.plugin.core.decompiler.taint.TaintRule;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.SarifUtils;
import sarif.handlers.SarifResultHandler;
import sarif.model.SarifDataFrame;

public class SarifTaintCodeFlowResultHandler
extends SarifResultHandler {
    public String getKey() {
        return "Address";
    }

    public boolean isEnabled(SarifDataFrame dframe) {
        return dframe.getToolID().equals(AbstractTaintState.ENGINE_NAME);
    }

    public void handle(SarifDataFrame dframe, Run r, Result res, Map<String, Object> map) {
        this.df = dframe;
        this.controller = this.df.getController();
        this.run = r;
        this.result = res;
        List tableResults = this.df.getTableResults();
        String ruleId = this.result.getRuleId();
        if (ruleId == null || !ruleId.equals("C0001")) {
            return;
        }
        String type = TaintRule.fromRuleId(ruleId).toString();
        String label = "UNSPECIFIED";
        Message msg = this.result.getMessage();
        String[] parts = msg.getText().split(":");
        if (parts.length > 1) {
            label = parts[1].strip();
        }
        String comment = this.result.getMessage().getText();
        List codeFlows = this.result.getCodeFlows();
        if (codeFlows == null) {
            return;
        }
        int path_id = 1;
        int path_index = 0;
        for (CodeFlow cf : codeFlows) {
            List threadFlows = cf.getThreadFlows();
            if (threadFlows == null) continue;
            for (ThreadFlow tf : threadFlows) {
                List threadFlowLocations = tf.getLocations();
                path_index = 1;
                for (ThreadFlowLocation tfl : threadFlowLocations) {
                    map.put("Message", this.result.getMessage().getText());
                    Result.Kind kind = this.result.getKind();
                    map.put("Kind", kind == null ? "None" : kind.toString());
                    Result.Level level = this.result.getLevel();
                    if (level != null) {
                        map.put("Level", level.toString());
                    }
                    map.put("RuleId", this.result.getRuleId());
                    map.put("type", type);
                    map.put("value", label);
                    map.put("comment", comment);
                    map.put("pathID", path_id);
                    map.put("index", path_index);
                    this.populate(map, tfl, path_index);
                    if (path_index > 1) {
                        tableResults.add(map);
                    }
                    map = new HashMap<String, Object>();
                    ++path_index;
                }
            }
            ++path_id;
        }
    }

    protected Object parse() {
        return null;
    }

    private void populate(Map<String, Object> map, ThreadFlowLocation tfl, int path_index) {
        Location loc = tfl.getLocation();
        LogicalLocation ll = SarifUtils.getLogicalLocation((Run)this.run, (Location)loc);
        String name = ll.getName();
        String fqname = ll.getDecoratedName();
        String displayName = SarifUtils.extractDisplayName((LogicalLocation)ll);
        map.put("originalName", name);
        map.put("name", displayName);
        map.put("location", fqname);
        map.put("function", SarifUtils.extractFQNameFunction((String)fqname));
        Address faddr = SarifUtils.extractFunctionEntryAddr((Program)this.controller.getProgram(), (String)fqname);
        if (faddr != null && faddr.getOffset() >= 0L) {
            map.put("entry", faddr);
            map.put("Address", faddr);
        }
        String kind = ll.getKind();
        String operation = "";
        switch (kind) {
            case "variable": {
                map.put("Address", SarifUtils.extractFQNameAddrPair((Program)this.controller.getProgram(), (String)fqname).get(1));
                kind = path_index == 1 ? "path source" : "path sink";
                operation = path_index == 1 ? "Source" : "Sink";
                break;
            }
            case "member": {
                map.put("Address", SarifUtils.extractFQNameAddrPair((Program)this.controller.getProgram(), (String)fqname).get(1));
                operation = this.controller.getStateText(tfl.getState(), "assignment");
                kind = "path node";
                break;
            }
            default: {
                System.err.println(String.format("Path Kind: '%s' is unknown", kind));
            }
        }
        map.put("kind", kind);
        map.put("operation", operation);
    }
}

