/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.LogicalLocation;
import com.contrastsecurity.sarif.Node;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Run;
import ghidra.app.plugin.core.decompiler.taint.TaintService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedVertex;
import java.util.Map;
import sarif.SarifUtils;
import sarif.handlers.run.SarifGraphRunHandler;

public class SarifTaintGraphRunHandler
extends SarifGraphRunHandler {
    private TaintService service;

    protected void populateVertex(Node n, AttributedVertex vertex) {
        Map additional;
        if (this.service == null) {
            PluginTool tool = this.controller.getPlugin().getTool();
            this.service = (TaintService)tool.getService(TaintService.class);
        }
        Address addr = this.controller.locationToAddress(this.run, n.getLocation());
        vertex.setName(addr.toString());
        String text = n.getLabel().getText();
        PropertyBag properties = n.getProperties();
        if (properties != null && (additional = properties.getAdditionalProperties()) != null) {
            for (Map.Entry entry : additional.entrySet()) {
                vertex.setAttribute((String)entry.getKey(), entry.getValue().toString());
            }
        }
        vertex.setAttribute("Label", text);
        vertex.setAttribute("Address", addr.toString(true));
        LogicalLocation ll = SarifUtils.getLogicalLocation((Run)this.run, (Location)n.getLocation());
        if (ll != null) {
            String name = ll.getName();
            String fqname = ll.getFullyQualifiedName();
            String displayName = SarifUtils.extractDisplayName((LogicalLocation)ll);
            vertex.setAttribute("originalName", name);
            vertex.setAttribute("name", displayName);
            if (name != null) {
                vertex.setName(displayName);
            }
            if ((addr = SarifUtils.getLocAddress((Program)this.controller.getProgram(), (String)fqname)) != null) {
                vertex.setAttribute("Address", addr.toString(true));
            }
            vertex.setAttribute("location", fqname);
            vertex.setAttribute("kind", ll.getKind());
            vertex.setAttribute("function", SarifUtils.extractFQNameFunction((String)fqname));
            Address faddr = SarifUtils.extractFunctionEntryAddr((Program)this.controller.getProgram(), (String)fqname);
            if (faddr != null && faddr.getOffset() >= 0L) {
                vertex.setAttribute("func_addr", faddr.toString(true));
            }
        }
    }
}

