/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.search;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.search.DecompilerTextFinderDialog;
import ghidra.app.plugin.core.search.DecompilerTextFinderTableModel;
import ghidra.app.plugin.core.search.TextMatch;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.SearchConstants;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.GhidraTable;
import java.awt.Color;
import javax.swing.Icon;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Decompiler Text Finder Plugin", description="This plugin adds an action to allow users to search decompiled text.", servicesRequired={TableService.class})
public class DecompilerTextFinderPlugin
extends ProgramPlugin {
    private static final Icon SELECT_FUNCTIONS_ICON = new GIcon("icon.plugin.decompiler.text.finder.select.functions");
    private DecompilerTextFinderDialog searchDialog;

    public DecompilerTextFinderPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        NavigatableContextAction searchAction = new NavigatableContextAction("Search Decompiled Text", this.getName()){

            public void actionPerformed(NavigatableActionContext context) {
                DecompilerTextFinderPlugin.this.search(context.getNavigatable(), context.getProgram());
            }
        };
        String subGroup = "e";
        searchAction.setMenuBarData(new MenuData(new String[]{"Search", "Decompiled Text..."}, null, "search", -1, subGroup));
        searchAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)searchAction);
    }

    private void search(Navigatable navigatable, Program program) {
        FunctionManager functionManager;
        FunctionIterator it;
        if (this.searchDialog == null) {
            this.searchDialog = new DecompilerTextFinderDialog();
        }
        boolean enableSearchSelection = false;
        if (this.currentSelection != null && (it = (functionManager = program.getFunctionManager()).getFunctions((AddressSetView)this.currentSelection, true)).hasNext()) {
            enableSearchSelection = true;
        }
        this.searchDialog.setSearchSelectionEnabled(enableSearchSelection);
        this.tool.showDialog((DialogComponentProvider)this.searchDialog);
        if (this.searchDialog.isCancelled()) {
            return;
        }
        String searchText = this.searchDialog.getSearchText();
        boolean isRegex = this.searchDialog.isRegex();
        DecompilerTextFinderTableModel model = new DecompilerTextFinderTableModel((ServiceProvider)this.tool, program, searchText, isRegex);
        if (this.searchDialog.isSearchSelection()) {
            model.setSelection((AddressSetView)this.currentSelection);
        }
        int searchLimit = this.getSearchLimit();
        model.setSearchLimit(searchLimit);
        GColor markerColor = SearchConstants.SEARCH_HIGHLIGHT_COLOR;
        GIcon markerIcon = new GIcon("icon.base.search.marker");
        String title = "Decompiler Search Text - '" + searchText + "'";
        String tableTypeName = "Decompiler Search Results";
        String windowSubMenu = "Search";
        TableService tableService = (TableService)this.tool.getService(TableService.class);
        TableComponentProvider provider = tableService.showTableWithMarkers(title, tableTypeName, (GhidraProgramTableModel)model, (Color)markerColor, (Icon)markerIcon, windowSubMenu, navigatable);
        provider.installRemoveItemsAction();
        GhidraTable table = provider.getTable();
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Functions", this.getName()).description("Make program selection of function starts from selected rows")).toolBarIcon(SELECT_FUNCTIONS_ICON)).popupMenuIcon(SELECT_FUNCTIONS_ICON)).popupMenuPath(new String[]{"Select Functions"})).popupMenuGroup(null, "a")).enabledWhen(c -> table.getSelectedRowCount() > 0)).onAction(c -> this.selectFunctions(table, model))).buildAndInstallLocal((ComponentProvider)provider);
    }

    private int getSearchLimit() {
        ToolOptions options = this.tool.getOptions("Search");
        return options.getInt("Search Limit", 500);
    }

    private void selectFunctions(GhidraTable table, DecompilerTextFinderTableModel model) {
        int[] rows;
        AddressSet addresses = new AddressSet();
        for (int row : rows = table.getSelectedRows()) {
            TextMatch match = (TextMatch)model.getRowObject(row);
            Function f = match.getFunction();
            addresses.add(f.getEntryPoint());
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)addresses);
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.getName(), selection, table.getProgram());
        this.firePluginEvent((PluginEvent)event);
    }
}

