/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.variadic;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.plugin.core.string.variadic.FormatArgument;
import ghidra.app.plugin.core.string.variadic.FormatStringParser;
import ghidra.app.plugin.core.string.variadic.FunctionCallData;
import ghidra.app.plugin.core.string.variadic.PcodeFunctionParser;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.util.DefinedStringIterator;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;

public class FormatStringAnalyzer
extends AbstractAnalyzer {
    private static final String[] VARIADIC_SUBSTRINGS = new String[]{"printf", "scanf"};
    private static final String NAME = "Variadic Function Signature Override";
    private static final String DESCRIPTION = "Detects variadic function calls in the bodies of each function that intersect the current selection and parses their format string arguments to infer the correct signatures. Currently, this analyzer only supports printf, scanf, and their variants (e.g., snprintf, fscanf). If the current selection is empty, it searches through every function. Once the correct signatures are inferred, they are overridden.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = false;
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "Select this check box if you want this analyzer to create analysis bookmarks when items of interest are created/identified by the analyzer.";
    private boolean createBookmarksEnabled = false;
    private static final String INPUT_FUNCTION_SUBSTRING = "scanf";
    private Program currentProgram = null;
    private FormatStringParser parser;

    public FormatStringAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_SIGNATURES_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.LOW_PRIORITY);
        this.setDefaultEnablement(false);
        this.setPrototype();
    }

    public boolean canAnalyze(Program program) {
        return true;
    }

    private synchronized FormatStringParser getParser() {
        if (this.parser == null) {
            this.parser = new FormatStringParser(this.currentProgram);
        }
        return this.parser;
    }

    private synchronized void disposeParser() {
        this.parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.currentProgram = program;
        try {
            this.run(set, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.disposeParser();
        }
        return true;
    }

    private void run(AddressSetView selection, TaskMonitor monitor) throws CancelledException {
        Iterator functionsToSearchIterator;
        HashMap<Address, Data> stringsByAddress = new HashMap<Address, Data>();
        for (Data data : DefinedStringIterator.forProgram((Program)this.currentProgram)) {
            String s = data.getDefaultValueRepresentation();
            if (s.contains("%")) {
                stringsByAddress.put(data.getAddress(), data);
            }
            monitor.checkCancelled();
        }
        FunctionIterator functionIterator = this.currentProgram.getListing().getFunctions(true);
        FunctionIterator externalIterator = this.currentProgram.getListing().getExternalFunctions();
        Iterator programFunctionIterator = IteratorUtils.chainedIterator((Iterator)functionIterator, (Iterator)externalIterator);
        HashMap<String, List<DataType>> namesToParameters = new HashMap<String, List<DataType>>();
        HashMap<String, DataType> namesToReturn = new HashMap<String, DataType>();
        HashSet<Function> toDecompile = new HashSet<Function>();
        HashSet<String> variadicFunctionNames = new HashSet<String>();
        for (Function function : IteratorUtils.asIterable((Iterator)programFunctionIterator)) {
            String name = function.getName().strip();
            if (this.usesVariadicFormatString(function)) {
                for (String variadicSubstring : VARIADIC_SUBSTRINGS) {
                    if (!name.contains(variadicSubstring)) continue;
                    variadicFunctionNames.add(name);
                    namesToParameters.put(name, this.getParameters(function));
                    namesToReturn.put(name, function.getReturnType());
                    break;
                }
            }
            monitor.checkCancelled();
        }
        Iterator iterator = functionsToSearchIterator = selection != null ? this.currentProgram.getFunctionManager().getFunctionsOverlapping(selection) : this.currentProgram.getFunctionManager().getFunctionsNoStubs(true);
        while (functionsToSearchIterator.hasNext()) {
            Function function;
            function = (Function)functionsToSearchIterator.next();
            Set calledFunctions = function.getCalledFunctions(monitor);
            for (Function calledFunction : calledFunctions) {
                if (!namesToParameters.containsKey(calledFunction.getName())) continue;
                toDecompile.add(function);
                break;
            }
            monitor.checkCancelled();
        }
        this.decompile(this.currentProgram, monitor, stringsByAddress, variadicFunctionNames, namesToParameters, namesToReturn, toDecompile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompile(Program program, TaskMonitor monitor, Map<Address, Data> stringsByAddress, Set<String> variadicFunctionNames, Map<String, List<DataType>> namesToParameters, Map<String, DataType> namesToReturn, Set<Function> toDecompile) {
        DecompilerCallback<Void> callback = this.initDecompilerCallback(program, stringsByAddress, variadicFunctionNames, namesToParameters, namesToReturn);
        if (toDecompile.isEmpty()) {
            Msg.info((Object)((Object)this), (Object)"No functions detected that make variadic function calls with format strings containing format specifiers");
            return;
        }
        try {
            ParallelDecompiler.decompileFunctions(callback, toDecompile, (TaskMonitor)monitor);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Error: could not decompile functions with ParallelDecompiler", (Throwable)e);
        }
        finally {
            callback.dispose();
        }
    }

    private DecompilerCallback<Void> initDecompilerCallback(final Program program, final Map<Address, Data> stringsByAddress, final Set<String> variadicFuncNames, final Map<String, List<DataType>> namesToParameters, final Map<String, DataType> namesToReturn) {
        return new DecompilerCallback<Void>(program, (DecompileConfigurer)new VariadicSignatureDecompileConfigurer()){

            public Void process(DecompileResults results, TaskMonitor tMonitor) throws Exception {
                List<FunctionCallData> functionCallDataList;
                if (results == null) {
                    return null;
                }
                Function function = results.getFunction();
                PcodeFunctionParser pcodeParser = new PcodeFunctionParser(program);
                if (results.getHighFunction() == null || results.getHighFunction().getPcodeOps() == null) {
                    return null;
                }
                Iterator pcodeOpASTIterator = results.getHighFunction().getPcodeOps();
                ArrayList<PcodeOpAST> pcodeOpASTs = new ArrayList<PcodeOpAST>();
                if (results.getHighFunction() != null && pcodeOpASTIterator != null) {
                    while (pcodeOpASTIterator.hasNext()) {
                        PcodeOpAST pcodeAST = (PcodeOpAST)pcodeOpASTIterator.next();
                        pcodeOpASTs.add(pcodeAST);
                    }
                }
                if ((functionCallDataList = pcodeParser.parseFunctionForCallData(pcodeOpASTs, stringsByAddress, variadicFuncNames)) != null && functionCallDataList.size() > 0) {
                    FormatStringAnalyzer.this.overrideCallList(program, function, functionCallDataList, namesToParameters, namesToReturn);
                }
                tMonitor.checkCancelled();
                return null;
            }
        };
    }

    private List<DataType> getParameters(Function function) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (ParameterDefinition pd : function.getSignature().getArguments()) {
            dataTypes.add(pd.getDataType());
        }
        return dataTypes;
    }

    private boolean usesVariadicFormatString(Function function) {
        int paramCount = function.getParameterCount();
        return function.hasVarArgs() && paramCount > 0 && this.isCharPointer(function.getParameters()[paramCount - 1].getDataType());
    }

    private boolean isCharPointer(DataType dataType) {
        if (dataType instanceof TypeDef) {
            dataType = ((TypeDef)dataType).getBaseDataType();
        }
        if (!(dataType instanceof Pointer)) {
            return false;
        }
        DataType dt = ((Pointer)dataType).getDataType();
        return dt instanceof CharDataType || dt instanceof WideCharDataType || dt instanceof WideChar16DataType || dt instanceof WideChar32DataType;
    }

    private ParameterDefinition[] parseParameters(Function function, Address address, String callFunctionName, String formatString, Map<String, List<DataType>> namesToParameters) {
        DataType[] dataTypes;
        Program functionProgram = function.getProgram();
        FormatStringParser parser = this.getParser();
        boolean isOutputType = !callFunctionName.contains(INPUT_FUNCTION_SUBSTRING);
        List<FormatArgument> formatArguments = parser.convertToFormatArgumentList(formatString, isOutputType);
        DataType[] dataTypeArray = dataTypes = isOutputType ? parser.convertToOutputDataTypes(formatArguments) : parser.convertToInputDataTypes(formatArguments);
        if (dataTypes == null) {
            this.currentProgram.getBookmarkManager().setBookmark(address, "Analysis", "Unrecognized format string", "Format string could not be parsed: " + formatString);
            return null;
        }
        ParameterDefinition[] paramDefs = this.createParameters(callFunctionName, dataTypes, functionProgram, namesToParameters);
        return paramDefs;
    }

    private ParameterDefinition[] createParameters(String callFunctionName, DataType[] dataTypes, Program program, Map<String, List<DataType>> namesToParameters) {
        List<DataType> initialFunctionParameters = namesToParameters.get(callFunctionName);
        int numberOfParameters = initialFunctionParameters.size() + dataTypes.length;
        if (numberOfParameters == 0) {
            return null;
        }
        ParameterDefinition[] parameterDefinitions = new ParameterDefinition[numberOfParameters];
        for (int i = 0; i < numberOfParameters; ++i) {
            parameterDefinitions[i] = i < initialFunctionParameters.size() ? new ParameterDefinitionImpl("param" + i, initialFunctionParameters.get(i), "") : new ParameterDefinitionImpl("param" + i, dataTypes[i - initialFunctionParameters.size()], "");
        }
        return parameterDefinitions;
    }

    private FunctionSignature initSignature(Function function, Address address, String callFunctionName, String formatString, Map<String, List<DataType>> namesToParameters, Map<String, DataType> namesToReturn) {
        ParameterDefinition[] parameterDefinitions = this.parseParameters(function, address, callFunctionName, formatString, namesToParameters);
        if (parameterDefinitions == null || parameterDefinitions.length == 0) {
            return null;
        }
        FunctionDefinitionDataType signature = new FunctionDefinitionDataType(callFunctionName);
        signature.setArguments(parameterDefinitions);
        signature.setReturnType(namesToReturn.get(callFunctionName));
        return signature;
    }

    private void overrideCallList(Program program, Function function, List<FunctionCallData> functionCallDataList, Map<String, List<DataType>> namesToParameters, Map<String, DataType> namesToReturn) {
        if (function == null || functionCallDataList == null) {
            return;
        }
        for (FunctionCallData data : functionCallDataList) {
            this.overrideFunctionCall(program, function, data.getAddressOfCall(), data.getCallFuncName(), data.getFormatString(), namesToParameters, namesToReturn);
        }
    }

    private void overrideFunctionCall(Program program, Function function, Address address, String callFunctionName, String formatString, Map<String, List<DataType>> namesToParameters, Map<String, DataType> namesToReturn) {
        if (formatString == null) {
            return;
        }
        FunctionSignature functionSignature = this.initSignature(function, address, callFunctionName, formatString, namesToParameters, namesToReturn);
        if (functionSignature == null || function == null || address == null) {
            return;
        }
        try {
            if (this.createBookmarksEnabled) {
                BookmarkManager bookmark = program.getBookmarkManager();
                bookmark.setBookmark(address, "Analysis", "Function Signature Override", "Override for call to function " + callFunctionName);
            }
            HighFunctionDBUtil.writeOverride((Function)function, (Address)address, (FunctionSignature)functionSignature);
        }
        catch (InvalidInputException e) {
            Msg.warn((Object)((Object)this), (Object)("Error applying override to " + address.toString() + ": " + e.getMessage()));
        }
    }

    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }

    private class VariadicSignatureDecompileConfigurer
    implements DecompileConfigurer {
        private VariadicSignatureDecompileConfigurer() {
        }

        public void configure(DecompInterface decompiler) {
            decompiler.toggleCCode(false);
            decompiler.toggleSyntaxTree(true);
            decompiler.openProgram(FormatStringAnalyzer.this.currentProgram);
            decompiler.setSimplificationStyle("normalize");
            DecompileOptions options = new DecompileOptions();
            options.grabFromProgram(FormatStringAnalyzer.this.currentProgram);
            decompiler.setOptions(options);
        }
    }
}

