/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.markuptype.FunctionEntryPointBasedAbstractMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.FunctionSignatureStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FunctionSignatureMarkupType
extends FunctionEntryPointBasedAbstractMarkupType {
    public static final VTMarkupType INSTANCE = new FunctionSignatureMarkupType();

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return list;
        }
        Address sourceAddress = sourceFunction.getEntryPoint();
        MarkupItemImpl markupItemImpl = new MarkupItemImpl(association, this, sourceAddress);
        markupItemImpl.setDefaultDestinationAddress(association.getDestinationAddress(), "Function");
        list.add(markupItemImpl);
        return list;
    }

    private FunctionSignatureMarkupType() {
        super("Function Signature");
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.REPLACE;
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        Function function = this.getSourceFunction(association);
        if (function == null) {
            return null;
        }
        return new FunctionSignatureStringable(function);
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        if (!markupItem.canUnapply()) {
            throw new VersionTrackingApplyException("Attempted to unapply a non-applied markup item");
        }
        Address destinationAddress = markupItem.getDestinationAddress();
        FunctionSignatureStringable destinationSignatureStringable = (FunctionSignatureStringable)markupItem.getOriginalDestinationValue();
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        Function destinationFunction = functionManager.getFunctionAt(destinationAddress);
        if (destinationFunction == null) {
            return;
        }
        if (destinationSignatureStringable.sameFunctionSignature(destinationFunction)) {
            return;
        }
        destinationSignatureStringable.applyFunctionSignature(destinationFunction, VT_UNAPPLY_MARKUP_OPTIONS, true);
    }

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        VTMatchApplyChoices.FunctionSignatureChoices functionSignatureChoice = (VTMatchApplyChoices.FunctionSignatureChoices)markupOptions.getEnum("Apply Markup Options.Function Signature", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE);
        if (functionSignatureChoice == VTMatchApplyChoices.FunctionSignatureChoices.EXCLUDE) {
            throw new IllegalArgumentException("Can't apply function signature for " + markupItem.getMarkupType().getDisplayName() + " since it is excluded.");
        }
        ToolOptions adjustedOptions = markupOptions.copy();
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destinationAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        Program destinationProgram = this.getDestinationProgram(markupItem.getAssociation());
        FunctionSignatureStringable sourceStringable = (FunctionSignatureStringable)markupItem.getSourceValue();
        if (sourceStringable == null) {
            throw new VersionTrackingApplyException("Cannot apply function signature.  The data from the source program no longer exists. Markup Item: " + String.valueOf(markupItem));
        }
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        Function destinationFunction = functionManager.getFunctionAt(destinationAddress);
        if (destinationFunction == null) {
            throw new VersionTrackingApplyException("Couldn't find destination function to apply a name.");
        }
        return sourceStringable.applyFunctionSignature(destinationFunction, adjustedOptions, false);
    }

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destinationAddress) {
        FunctionReturnTypeFieldLocation functionReturnTypeLocation = this.getFunctionReturnTypeLocation(association, destinationAddress, false);
        if (functionReturnTypeLocation != null) {
            return functionReturnTypeLocation;
        }
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return null;
        }
        return new AddressFieldLocation(this.getDestinationProgram(association), destinationAddress);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        FunctionReturnTypeFieldLocation functionReturnTypeLocation = this.getFunctionReturnTypeLocation(association, sourceAddress, true);
        if (functionReturnTypeLocation != null) {
            return functionReturnTypeLocation;
        }
        return new AddressFieldLocation(this.getSourceProgram(association), sourceAddress);
    }

    private FunctionReturnTypeFieldLocation getFunctionReturnTypeLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        Function function = program.getFunctionManager().getFunctionContaining(address);
        if (function == null) {
            return null;
        }
        Address entryAddress = function.getEntryPoint();
        Stringable value = isSource ? this.getSourceValue(association, address) : this.getCurrentDestinationValue(association, address);
        String displayString = value != null ? value.getDisplayString() : null;
        return new FunctionReturnTypeFieldLocation(program, entryAddress, displayString);
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destinationAddress) {
        Address expectedDestinationAddress = association.getDestinationAddress();
        if (expectedDestinationAddress.equals((Object)destinationAddress)) {
            Function function = this.getDestinationFunction(association);
            if (function == null) {
                return null;
            }
            return new FunctionSignatureStringable(function);
        }
        return null;
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.FunctionSignatureChoices replaceDefaultChoice = (VTMatchApplyChoices.FunctionSignatureChoices)options.getEnum("Apply Markup Options.Function Signature", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE);
        switch (replaceDefaultChoice) {
            case REPLACE: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
            case WHEN_SAME_PARAMETER_COUNT: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform an Add action.");
            }
            case ADD_AS_PRIMARY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform an Add As Primary action.");
            }
            case REPLACE_DEFAULT_ONLY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform a Replace Default Only action.");
            }
            case REPLACE: {
                options.setEnum("Apply Markup Options.Function Signature", (Enum)VTMatchApplyChoices.FunctionSignatureChoices.REPLACE);
            }
        }
        return options;
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        VTAssociation association = markupItem.getAssociation();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return false;
        }
        FunctionSignatureStringable sourceStringable = new FunctionSignatureStringable(sourceFunction);
        FunctionSignatureStringable destinationStringable = new FunctionSignatureStringable(destinationFunction);
        return SystemUtilities.isEqual((Object)sourceStringable, (Object)destinationStringable);
    }

    @Override
    public boolean conflictsWithOtherMarkup(MarkupItemImpl markupItem, Collection<VTMarkupItem> markupItems) {
        return false;
    }
}

