/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class IntegerInputVerifier
extends InputVerifier {
    @Override
    public boolean verify(JComponent input) {
        if (!(input instanceof JFormattedTextField)) {
            return true;
        }
        JFormattedTextField ftf = (JFormattedTextField)input;
        JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
        if (formatter == null) {
            return true;
        }
        String text = ftf.getText();
        try {
            Integer intValue = ((Number)formatter.stringToValue(text)).intValue();
            return intValue.compareTo(0) >= 0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean shouldYieldFocus = super.shouldYieldFocus(input);
        if (!shouldYieldFocus) {
            this.warn();
        }
        return shouldYieldFocus;
    }

    private void warn() {
        Toolkit.getDefaultToolkit().beep();
    }
}

